namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AvatarResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AvatarResources_fr_fr : AvatarResources_en_us, IAvatarResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Advanced"
	/// Click Advanced to get the advanced options
	/// English String: "Advanced"
	/// </summary>
	public override string ActionAdvanced => "Avancé";

	/// <summary>
	/// Key: "Action.Buy"
	/// Button used to buy an item to customize the user's avatar.
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "Acheter";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Annuler";

	/// <summary>
	/// Key: "Action.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "Fermer";

	/// <summary>
	/// Key: "Action.Create"
	/// English String: "Create"
	/// </summary>
	public override string ActionCreate => "Créer";

	/// <summary>
	/// Key: "Action.CreateNewOutfit"
	/// Button to create new outfit
	/// English String: "Create"
	/// </summary>
	public override string ActionCreateNewOutfit => "Créer";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "Supprimer";

	/// <summary>
	/// Key: "Action.Done"
	/// English String: "Done"
	/// </summary>
	public override string ActionDone => "Terminé";

	/// <summary>
	/// Key: "Action.Get"
	/// Button used to buy get an item for free to customize the user's avatar.
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "Obtenir";

	/// <summary>
	/// Key: "Action.GetMore"
	/// A call to action for the user to buy more clothes from the Catalog page. This could improve how their avatar looks.
	/// English String: "Get More"
	/// </summary>
	public override string ActionGetMore => "Obtenir plus";

	/// <summary>
	/// Key: "Action.OpenRobloxApp"
	/// English String: "Open Roblox App"
	/// </summary>
	public override string ActionOpenRobloxApp => "Ouvrir l'application Roblox";

	/// <summary>
	/// Key: "Action.Redraw"
	/// Redraw the avatar on the screen
	/// English String: "Redraw"
	/// </summary>
	public override string ActionRedraw => "Redessiner";

	/// <summary>
	/// Key: "Action.Rename"
	/// English String: "Rename"
	/// </summary>
	public override string ActionRename => "Renommer";

	/// <summary>
	/// Key: "Action.RenameOutfit"
	/// Button to rename outfit
	/// English String: "Rename"
	/// </summary>
	public override string ActionRenameOutfit => "Renommer";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Enregistrer";

	/// <summary>
	/// Key: "Action.SeeAll"
	/// See all clothing that user can buy
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Afficher tout";

	/// <summary>
	/// Key: "Action.ThreeDimensions"
	/// This button allows the user to view their avatar in three dimensions.
	/// English String: "3D"
	/// </summary>
	public override string ActionThreeDimensions => "3D";

	/// <summary>
	/// Key: "Action.TwoDimensions"
	/// This button allows the user to view their avatar in two dimensions.
	/// English String: "2D"
	/// </summary>
	public override string ActionTwoDimensions => "2D";

	/// <summary>
	/// Key: "Action.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionUpdate => "Mise à jour";

	/// <summary>
	/// Key: "Action.UserUnderstands"
	/// The user casually responds to the application saying that they understand how to navigate the menu.
	/// English String: "Got it"
	/// </summary>
	public override string ActionUserUnderstands => "OK";

	/// <summary>
	/// Key: "Description.AvatarEditorUpsell"
	/// English String: "To change your look you will need to use the Avatar Editor on the App."
	/// </summary>
	public override string DescriptionAvatarEditorUpsell => "Pour modifier ton apparence, tu dois utiliser l'éditeur d'avatar dans l'application.";

	/// <summary>
	/// Key: "Description.CreateNewCostume"
	/// A costume will be created from your avatar's current appearance.
	/// English String: "A costume will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewCostume => "Un costume sera créé à partir de l'apparence actuelle de votre avatar.";

	/// <summary>
	/// Key: "Description.CreateNewOutfit"
	/// An outfit will be created from your avatar's current appearance.
	/// English String: "An outfit will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewOutfit => "Une tenue sera créée à partir de l'apparence actuelle de ton avatar.";

	/// <summary>
	/// Key: "Description.RenameCostume"
	/// Choose a new name for your costume.
	/// English String: "Choose a new name for your costume."
	/// </summary>
	public override string DescriptionRenameCostume => "Choisissez un nouveau nom pour votre costume.";

	/// <summary>
	/// Key: "Description.RenameOutfit"
	/// Choose a new name for your outfit.
	/// English String: "Choose a new name for your outfit."
	/// </summary>
	public override string DescriptionRenameOutfit => "Choisis un nouveau nom pour ta tenue.";

	/// <summary>
	/// Key: "Heading.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string HeadingAccessories => "Accessoires";

	/// <summary>
	/// Key: "Heading.AccessoriesChange"
	/// English String: "Accessories Change"
	/// </summary>
	public override string HeadingAccessoriesChange => "Changement d'accessoires";

	/// <summary>
	/// Key: "Heading.AdvancedOptions"
	/// English String: "Advanced Options"
	/// </summary>
	public override string HeadingAdvancedOptions => "Options avancées";

	/// <summary>
	/// Key: "Heading.All"
	/// All avatar modification types
	/// English String: "All"
	/// </summary>
	public override string HeadingAll => "Tous";

	/// <summary>
	/// Key: "Heading.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string HeadingAnimations => "Animations";

	/// <summary>
	/// Key: "Heading.Appearance"
	/// English String: "Appearance"
	/// </summary>
	public override string HeadingAppearance => "Apparence";

	/// <summary>
	/// Key: "Heading.AvatarPageTitle"
	/// Page title for the Avatar page. On this page, the user can modify how they look.
	/// English String: "Avatar Editor"
	/// </summary>
	public override string HeadingAvatarPageTitle => "Éditeur d'avatar";

	/// <summary>
	/// Key: "Heading.Body"
	/// English String: "Body"
	/// </summary>
	public override string HeadingBody => "Corps";

	/// <summary>
	/// Key: "Heading.BodyParts"
	/// English String: "Body Parts"
	/// </summary>
	public override string HeadingBodyParts => "Parties du corps";

	/// <summary>
	/// Key: "Heading.Clothing"
	/// English String: "Clothing"
	/// </summary>
	public override string HeadingClothing => "Vêtements";

	/// <summary>
	/// Key: "Heading.Costumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Costumes"
	/// </summary>
	public override string HeadingCostumes => "Costumes";

	/// <summary>
	/// Key: "Heading.CreateNewCostume"
	/// NOTE: Costume is a more whimsical word choice for outfit. Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Create New Costume"
	/// </summary>
	public override string HeadingCreateNewCostume => "Créer un nouveau costume";

	/// <summary>
	/// Key: "Heading.CreateNewOutfit"
	/// English String: "Create New Outfit"
	/// </summary>
	public override string HeadingCreateNewOutfit => "Créer une nouvelle tenue";

	/// <summary>
	/// Key: "Heading.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string HeadingDelete => "Supprimer";

	/// <summary>
	/// Key: "Heading.DeleteCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Delete Costume"
	/// </summary>
	public override string HeadingDeleteCostume => "Supprimer le costume";

	/// <summary>
	/// Key: "Heading.DeleteOutfit"
	/// English String: "Delete Outfit"
	/// </summary>
	public override string HeadingDeleteOutfit => "Supprimer la tenue";

	/// <summary>
	/// Key: "Heading.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string HeadingEmotes => "Emotes";

	/// <summary>
	/// Key: "Heading.EquipEmotes"
	/// English String: "Equip Emotes"
	/// </summary>
	public override string HeadingEquipEmotes => "Équiper";

	/// <summary>
	/// Key: "Heading.Outfits"
	/// English String: "Outfits"
	/// </summary>
	public override string HeadingOutfits => "Tenues";

	/// <summary>
	/// Key: "Heading.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string HeadingPackages => "Packs";

	/// <summary>
	/// Key: "Heading.Recent"
	/// English String: "Recent"
	/// </summary>
	public override string HeadingRecent => "Récents";

	/// <summary>
	/// Key: "Heading.Recommended"
	/// See recommended clothing for your avatar
	/// English String: "Recommended"
	/// </summary>
	public override string HeadingRecommended => "Recommandés";

	/// <summary>
	/// Key: "Heading.RenameCostume"
	/// English String: "Rename Costume"
	/// </summary>
	public override string HeadingRenameCostume => "Renommer le costume";

	/// <summary>
	/// Key: "Heading.RenameOutfit"
	/// English String: "Rename Outfit"
	/// </summary>
	public override string HeadingRenameOutfit => "Renommer la tenue";

	/// <summary>
	/// Key: "Heading.Scaling"
	/// English String: "Scaling"
	/// </summary>
	public override string HeadingScaling => "Changement de taille";

	/// <summary>
	/// Key: "Heading.SkinToneBodyParts"
	/// English String: "Skin Tone by Body Parts"
	/// </summary>
	public override string HeadingSkinToneBodyParts => "Teint des différentes parties du corps";

	/// <summary>
	/// Key: "Heading.Update"
	/// English String: "Update"
	/// </summary>
	public override string HeadingUpdate => "Mise à jour";

	/// <summary>
	/// Key: "Heading.UpdateCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Update Costume"
	/// </summary>
	public override string HeadingUpdateCostume => "Mettre à jour le costume";

	/// <summary>
	/// Key: "Heading.UpdateOutfit"
	/// English String: "Update Outfit"
	/// </summary>
	public override string HeadingUpdateOutfit => "Mettre à jour la tenue";

	/// <summary>
	/// Key: "Label.All"
	/// All body parts. This label will allow for body parts to change color
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "Tous";

	/// <summary>
	/// Key: "Label.AskIfLoadingCorrectly"
	/// Avatar isn't loading correctly?
	/// English String: "Avatar isn't loading correctly?"
	/// </summary>
	public override string LabelAskIfLoadingCorrectly => "L'avatar ne se charge pas correctement\u00a0?";

	/// <summary>
	/// Key: "Label.AssetIDPlaceholder"
	/// This refers to the Asset ID which is a technical word for the Identification Number of an item or asset.
	/// English String: "Asset ID"
	/// </summary>
	public override string LabelAssetIDPlaceholder => "ID de l'élément";

	/// <summary>
	/// Key: "Label.Back"
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "Dos";

	/// <summary>
	/// Key: "Label.BackAccessories"
	/// English String: "Back Accessories"
	/// </summary>
	public override string LabelBackAccessories => "Accessoires arrière";

	/// <summary>
	/// Key: "Label.BodyType"
	/// English String: "Body Type"
	/// </summary>
	public override string LabelBodyType => "Type de corps";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "Escalade";

	/// <summary>
	/// Key: "Label.ClimbAnimations"
	/// English String: "Climb Animations"
	/// </summary>
	public override string LabelClimbAnimations => "Animations d'escalade";

	/// <summary>
	/// Key: "Label.Clothes"
	/// English String: "Clothes"
	/// </summary>
	public override string LabelClothes => "Vêtements";

	/// <summary>
	/// Key: "Label.Costume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Costume"
	/// </summary>
	public override string LabelCostume => "Costume";

	/// <summary>
	/// Key: "label.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string labelEmotes => "Emotes";

	/// <summary>
	/// Key: "Label.Equip"
	/// English String: "Equip"
	/// </summary>
	public override string LabelEquip => "Équiper";

	/// <summary>
	/// Key: "Label.ExploreCatalog"
	/// This text entices users to shop for more things to wear on their avatar
	/// English String: "Explore the catalog to find more clothes!"
	/// </summary>
	public override string LabelExploreCatalog => "Naviguez dans le catalogue pour trouver plus de vêtements\u00a0!";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "Visage";

	/// <summary>
	/// Key: "Label.FaceAccessories"
	/// English String: "Face Accessories"
	/// </summary>
	public override string LabelFaceAccessories => "Accessoires de visage";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Visages";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "Chute";

	/// <summary>
	/// Key: "Label.FallAnimations"
	/// English String: "Fall Animations"
	/// </summary>
	public override string LabelFallAnimations => "Animations de chute";

	/// <summary>
	/// Key: "Label.Free"
	/// Text label for recommended items
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Gratuit";

	/// <summary>
	/// Key: "Label.Front"
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "Avant";

	/// <summary>
	/// Key: "Label.FrontAccessories"
	/// English String: "Front Accessories"
	/// </summary>
	public override string LabelFrontAccessories => "Accessoires avant";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Équipement";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "Cheveux";

	/// <summary>
	/// Key: "Label.HairAccessories"
	/// English String: "Hair Accessories"
	/// </summary>
	public override string LabelHairAccessories => "Accessoires de cheveux";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "Chapeau";

	/// <summary>
	/// Key: "Label.HatAccessories"
	/// English String: "Hat Accessories"
	/// </summary>
	public override string LabelHatAccessories => "Accessoires de chapeau";

	/// <summary>
	/// Key: "Label.Head"
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "Tête";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Têtes";

	/// <summary>
	/// Key: "Label.Height"
	/// English String: "Height"
	/// </summary>
	public override string LabelHeight => "Hauteur";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "Inaction";

	/// <summary>
	/// Key: "Label.IdleAnimations"
	/// English String: "Idle Animations"
	/// </summary>
	public override string LabelIdleAnimations => "Animations d'inaction";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "Saut";

	/// <summary>
	/// Key: "Label.JumpAnimations"
	/// English String: "Jump Animations"
	/// </summary>
	public override string LabelJumpAnimations => "Animations de saut";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "Bras gauche";

	/// <summary>
	/// Key: "Label.LeftArms"
	/// English String: "Left Arms"
	/// </summary>
	public override string LabelLeftArms => "Bras gauches";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "Jambe gauche";

	/// <summary>
	/// Key: "Label.LeftLegs"
	/// English String: "Left Legs"
	/// </summary>
	public override string LabelLeftLegs => "Jambes gauches";

	/// <summary>
	/// Key: "Label.MyCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "My Costumes"
	/// </summary>
	public override string LabelMyCostumes => "Mes costumes";

	/// <summary>
	/// Key: "Label.NamePlaceholderCostume"
	/// English String: "Name your costume"
	/// </summary>
	public override string LabelNamePlaceholderCostume => "Nommez votre costume";

	/// <summary>
	/// Key: "Label.NamePlaceholderOutfit"
	/// English String: "Name your outfit"
	/// </summary>
	public override string LabelNamePlaceholderOutfit => "Nomme ta tenue";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "Cou";

	/// <summary>
	/// Key: "Label.NeckAccessories"
	/// English String: "Neck Accessories"
	/// </summary>
	public override string LabelNeckAccessories => "Accessoires de cou";

	/// <summary>
	/// Key: "Label.NoResellers"
	/// Text label for recommended items
	/// English String: "No resellers"
	/// </summary>
	public override string LabelNoResellers => "Aucun revendeur";

	/// <summary>
	/// Key: "Label.OffSale"
	/// Text label for recommended items
	/// English String: "Off sale"
	/// </summary>
	public override string LabelOffSale => "Hors d'offre";

	/// <summary>
	/// Key: "Label.Outfit"
	/// English String: "Outfit"
	/// </summary>
	public override string LabelOutfit => "Tenue";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Pantalons";

	/// <summary>
	/// Key: "Label.Parts"
	/// English String: "Parts"
	/// </summary>
	public override string LabelParts => "Parties";

	/// <summary>
	/// Key: "Label.PresetCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Preset Costumes"
	/// </summary>
	public override string LabelPresetCostumes => "Costumes prédéfinis";

	/// <summary>
	/// Key: "Label.Proportions"
	/// English String: "Proportions"
	/// </summary>
	public override string LabelProportions => "Proportions";

	/// <summary>
	/// Key: "Label.RedrawUnavailable"
	/// Avatar redraw is unavailable
	/// English String: "Avatar redraw is unavailable."
	/// </summary>
	public override string LabelRedrawUnavailable => "Impossible de redessiner l'avatar.";

	/// <summary>
	/// Key: "Label.RightArm"
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "Bras droit";

	/// <summary>
	/// Key: "Label.RightArms"
	/// English String: "Right Arms"
	/// </summary>
	public override string LabelRightArms => "Bras droits";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "Jambe droite";

	/// <summary>
	/// Key: "Label.RightLegs"
	/// English String: "Right Legs"
	/// </summary>
	public override string LabelRightLegs => "Jambes droites";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "Course";

	/// <summary>
	/// Key: "Label.RunAnimations"
	/// English String: "Run Animations"
	/// </summary>
	public override string LabelRunAnimations => "Animations de course";

	/// <summary>
	/// Key: "Label.Scale"
	/// English String: "Scale"
	/// </summary>
	public override string LabelScale => "Taille";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Chemises";

	/// <summary>
	/// Key: "Label.ShoulderAccessories"
	/// English String: "Shoulder Accessories"
	/// </summary>
	public override string LabelShoulderAccessories => "Accessoires d'épaule";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "Épaules";

	/// <summary>
	/// Key: "Label.SkinTone"
	/// English String: "Skin Tone"
	/// </summary>
	public override string LabelSkinTone => "Teint";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "Nage";

	/// <summary>
	/// Key: "Label.SwimAnimations"
	/// English String: "Swim Animations"
	/// </summary>
	public override string LabelSwimAnimations => "Animations de nage";

	/// <summary>
	/// Key: "Label.SwitchAvatarType"
	/// User is able to increase the number of joints in their avatar from 6 to 15. R15 moves better. See http://roblox.wikia.com/wiki/R15
	/// English String: "Switch between classic R6 avatar and more expressive next generation R15 avatar"
	/// </summary>
	public override string LabelSwitchAvatarType => "Alternez entre l'avatar classique R6 et le modèle R15 de nouvelle génération, plus expressif.";

	/// <summary>
	/// Key: "Label.Torso"
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "Torse";

	/// <summary>
	/// Key: "Label.Torsos"
	/// English String: "Torsos"
	/// </summary>
	public override string LabelTorsos => "Torses";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Tee-shirts";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "Taille";

	/// <summary>
	/// Key: "Label.WaistAccessories"
	/// English String: "Waist Accessories"
	/// </summary>
	public override string LabelWaistAccessories => "Accessoires de taille";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "Marche";

	/// <summary>
	/// Key: "Label.WalkAnimations"
	/// English String: "Walk Animations"
	/// </summary>
	public override string LabelWalkAnimations => "Animations de marche";

	/// <summary>
	/// Key: "Label.Width"
	/// English String: "Width"
	/// </summary>
	public override string LabelWidth => "Largeur";

	/// <summary>
	/// Key: "Label.YourEmotes"
	/// English String: "Your Emotes"
	/// </summary>
	public override string LabelYourEmotes => "Tes Emotes";

	/// <summary>
	/// Key: "Message.AccessoriesChange"
	/// English String: "Are you sure you want to override your current look?"
	/// </summary>
	public override string MessageAccessoriesChange => "Veux-tu vraiment remplacer ton apparence actuelle\u00a0?";

	/// <summary>
	/// Key: "Message.ChooseEmote"
	/// English String: "Choose an Emote"
	/// </summary>
	public override string MessageChooseEmote => "Choisis une Emote";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlot"
	/// English String: "Choose a slot"
	/// </summary>
	public override string MessageChooseEmoteSlot => "Choisis un emplacement";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlotOrEmote"
	/// English String: "Choose a slot or an Emote"
	/// </summary>
	public override string MessageChooseEmoteSlotOrEmote => "Choisis un emplacement ou une Emote";

	/// <summary>
	/// Key: "Message.DefaultClothing"
	/// Encourage user to choose their own clothes.
	/// English String: "Default clothing has been applied to your avatar - wear something from your clothing."
	/// </summary>
	public override string MessageDefaultClothing => "Les vêtements par défaut ont été appliqués à ton avatar\u00a0; mets tes propres vêtements.";

	/// <summary>
	/// Key: "Message.DeleteThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Are you sure you want to delete this costume?"
	/// </summary>
	public override string MessageDeleteThisCostume => "Voulez-vous vraiment supprimer ce costume\u00a0?";

	/// <summary>
	/// Key: "Message.DeleteThisOutfit"
	/// English String: "Are you sure you want to delete this outfit?"
	/// </summary>
	public override string MessageDeleteThisOutfit => "Voulez-vous vraiment supprimer cette tenue\u00a0?";

	/// <summary>
	/// Key: "Message.EmotesInstructions"
	/// The instructions describe the navigation flow within the Avatar Editor to equip an emote.
	/// English String: "Go to \"Animations\" &gt; \"Emotes\" &gt; \"Equip Emotes\" to equip an emote."
	/// </summary>
	public override string MessageEmotesInstructions => "Va dans \"Animations\" > \"Emotes\" > \"Équiper\" pour enregistrer une emote.";

	/// <summary>
	/// Key: "Message.EmptyAssetList"
	/// User is seeing no assets on this page because they don't have any.
	/// English String: "You don't have any."
	/// </summary>
	public override string MessageEmptyAssetList => "Rien à afficher.";

	/// <summary>
	/// Key: "Message.EmptyListOfCostumes"
	/// The user is viewing an empty list of costumes to choose from. The application tells the user that they can create an costume.
	/// English String: "You don't have any costumes. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfCostumes => "Vous n'avez aucun costume. Essayez d'en créer un\u00a0!";

	/// <summary>
	/// Key: "Message.EmptyListOfOutfits"
	/// The user is viewing an empty list of outfits to choose from. The application tells the user that they can create an outfit.
	/// English String: "You don't have any outfits. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfOutfits => "Vous n'avez aucune tenue. Essayez d'en créer une\u00a0!";

	/// <summary>
	/// Key: "Message.EmptyRecentItems"
	/// English String: "You don't have any recent items."
	/// </summary>
	public override string MessageEmptyRecentItems => "Vous n'avez aucun objet récent.";

	/// <summary>
	/// Key: "Message.ErrorCreateCostume"
	/// English String: "Unable to create costume, try again later."
	/// </summary>
	public override string MessageErrorCreateCostume => "Impossible de créer le costume. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.ErrorCreateOutfit"
	/// English String: "Unable to create outfit, try again later."
	/// </summary>
	public override string MessageErrorCreateOutfit => "Impossible de créer la tenue. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.ErrorDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageErrorDeleteEmote => "Impossible de supprimer l’emote.";

	/// <summary>
	/// Key: "Message.ErrorEquipEmote"
	/// English String: "Failed to equip emote, please try again later."
	/// </summary>
	public override string MessageErrorEquipEmote => "Impossible d'enregistrer l'emote, réessaye plus tard.";

	/// <summary>
	/// Key: "Message.ErrorLoadCostume"
	/// English String: "Failed to load costume."
	/// </summary>
	public override string MessageErrorLoadCostume => "Impossible de charger le costume.";

	/// <summary>
	/// Key: "Message.ErrorLoadEmotes"
	/// English String: "Failed to load emotes."
	/// </summary>
	public override string MessageErrorLoadEmotes => "Impossible de charger les emotes.";

	/// <summary>
	/// Key: "Message.ErrorLoadOutfits"
	/// English String: "Failed to load outfits."
	/// </summary>
	public override string MessageErrorLoadOutfits => "Impossible de charger les tenues.";

	/// <summary>
	/// Key: "Message.ErrorOutfitName"
	/// English String: "Name can contain letters, numbers, and spaces."
	/// </summary>
	public override string MessageErrorOutfitName => "Les noms peuvent contenir des lettres, des chiffres et des espaces.";

	/// <summary>
	/// Key: "Message.ErrorRenameCostume"
	/// English String: "Failed to rename costume."
	/// </summary>
	public override string MessageErrorRenameCostume => "Impossible de renommer le costume.";

	/// <summary>
	/// Key: "Message.ErrorRenameOutfit"
	/// English String: "Failed to rename outfit."
	/// </summary>
	public override string MessageErrorRenameOutfit => "Impossible de renommer la tenue.";

	/// <summary>
	/// Key: "Message.ErrorUnequipEmote"
	/// English String: "Failed to unequip emote."
	/// </summary>
	public override string MessageErrorUnequipEmote => "Impossible d'enlever l’emote.";

	/// <summary>
	/// Key: "Message.ErrorUpdateCostume"
	/// English String: "Costume update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateCostume => "Échec de la mise à jour du costume. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.ErrorUpdateEmote"
	/// English String: "Updating emote slot failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateEmote => "La mise à jour des emotes a échoué, réessaye plus tard.";

	/// <summary>
	/// Key: "Message.ErrorUpdateOutfit"
	/// English String: "Outfit update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateOutfit => "Échec de la mise à jour de la tenue. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.ErrorUpdateWorn"
	/// There was an error updating items that the user is already wearing.
	/// English String: "Error while updating worn items."
	/// </summary>
	public override string MessageErrorUpdateWorn => "Erreur lors de la mise à jour des objets portés.";

	/// <summary>
	/// Key: "Message.ErrorWearCostume"
	/// English String: "Failed to wear costume."
	/// </summary>
	public override string MessageErrorWearCostume => "Impossible de porter le costume.";

	/// <summary>
	/// Key: "Message.ErrorWearOutfit"
	/// English String: "Failed to wear outfit."
	/// </summary>
	public override string MessageErrorWearOutfit => "Impossible de porter la tenue.";

	/// <summary>
	/// Key: "Message.FailedDeleteCostume"
	/// English String: "Failed to delete costume."
	/// </summary>
	public override string MessageFailedDeleteCostume => "Impossible de supprimer le costume.";

	/// <summary>
	/// Key: "Message.FailedDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageFailedDeleteEmote => "Impossible de supprimer l’emote.";

	/// <summary>
	/// Key: "Message.FailedDeleteOutfit"
	/// English String: "Failed to delete outfit."
	/// </summary>
	public override string MessageFailedDeleteOutfit => "Impossible de supprimer la tenue.";

	/// <summary>
	/// Key: "Message.FailedLoadAssets"
	/// English String: "Failed to load assets list."
	/// </summary>
	public override string MessageFailedLoadAssets => "Impossible de charger la liste des éléments.";

	/// <summary>
	/// Key: "Message.FailedLoadRecent"
	/// English String: "Failed to load recent items."
	/// </summary>
	public override string MessageFailedLoadRecent => "Impossible de charger les objets récents.";

	/// <summary>
	/// Key: "Message.FailedUpdateBodyColor"
	/// English String: "Failed to update skin tone."
	/// </summary>
	public override string MessageFailedUpdateBodyColor => "Impossible de mettre à jour le teint.";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedCostume"
	/// The user tried to update a deleted costume.
	/// English String: "The costume you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedCostume => "Le costume que vous essayez de mettre à jour n'existe plus.";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedOutfit"
	/// The user tried to update a deleted outfit.
	/// English String: "The outfit you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedOutfit => "La tenue que vous essayez de mettre à jour n'existe plus.";

	/// <summary>
	/// Key: "Message.FailedUpdateScales"
	/// English String: "Failed to update scales."
	/// </summary>
	public override string MessageFailedUpdateScales => "Impossible de mettre à jour la taille.";

	/// <summary>
	/// Key: "Message.FailedUpdateType"
	/// Failed to update the way the user's avatar is rendered.
	/// English String: "Failed to update avatar type."
	/// </summary>
	public override string MessageFailedUpdateType => "Impossible de mettre à jour le type d'avatar.";

	/// <summary>
	/// Key: "Message.FailedWearPackage"
	/// English String: "Failed to wear package."
	/// </summary>
	public override string MessageFailedWearPackage => "Impossible de porter le pack.";

	/// <summary>
	/// Key: "Message.HatLimitTooltip"
	/// English String: "You can wear up to 3 hats"
	/// </summary>
	public override string MessageHatLimitTooltip => "Vous pouvez porter jusqu'à 3\u00a0chapeaux.";

	/// <summary>
	/// Key: "Message.InvalidOutfitName"
	/// English String: "Name must be appropriate and less than 200 characters."
	/// </summary>
	public override string MessageInvalidOutfitName => "Le nom doit être approprié et compter moins de 200\u00a0caractères.";

	/// <summary>
	/// Key: "Message.Loading"
	/// The user's avatar is loading
	/// English String: "Loading..."
	/// </summary>
	public override string MessageLoading => "Chargement...";

	/// <summary>
	/// Key: "Message.PageUnavailable"
	/// English String: "The avatar page is temporarily unavailable."
	/// </summary>
	public override string MessagePageUnavailable => "La page des avatars est temporairement indisponible.";

	/// <summary>
	/// Key: "Message.PresetCostumesDelay"
	/// One-time message that appears to the user first time they visit the Preset Costumes tab. The delay is caused by initial migration.
	/// English String: "Note: We're doing some housekeeping, so it may take a few minutes for all your costumes to appear. Check again in a bit!"
	/// </summary>
	public override string MessagePresetCostumesDelay => "Remarque\u00a0: nous faisons un peu de ménage, alors vos costumes peuvent prendre plusieurs minutes avant d'apparaître. Réessayez dans quelques minutes\u00a0!";

	/// <summary>
	/// Key: "Message.ReachedMaxCostumes"
	/// English String: "You have reached the maximum number of costumes."
	/// </summary>
	public override string MessageReachedMaxCostumes => "Vous avez atteint le nombre maximum de costumes autorisés.";

	/// <summary>
	/// Key: "Message.ReachedMaxOutfits"
	/// English String: "You have reached the maximum number of outfits."
	/// </summary>
	public override string MessageReachedMaxOutfits => "Vous avez atteint le nombre maximum de tenues autorisées.";

	/// <summary>
	/// Key: "Message.RedirectAvatarSettings"
	/// English String: "You can set Avatar Settings from your Roblox Studio project. In Roblox Studio, go to Home &gt; Game Settings &gt; Avatar"
	/// </summary>
	public override string MessageRedirectAvatarSettings => "Vous pouvez définir les paramètres de votre avatar depuis votre projet Roblox Studio. Dans Roblox Studio, allez dans Accueil > Paramètres du jeu > Avatar";

	/// <summary>
	/// Key: "Message.RedrawFloodchecked"
	/// English String: "You have redrawn your avatar too many times, please try again later."
	/// </summary>
	public override string MessageRedrawFloodchecked => "Tu as redessiné ton avatar trop de fois. Réessaye plus tard.";

	/// <summary>
	/// Key: "Message.RedrawThumbnailFailed"
	/// English String: "Failed to redraw thumbnail."
	/// </summary>
	public override string MessageRedrawThumbnailFailed => "Impossible de redessiner la miniature.";

	/// <summary>
	/// Key: "Message.SelectEnableScaling"
	/// R15 is a proper noun
	/// English String: "Select R15 to enable scaling."
	/// </summary>
	public override string MessageSelectEnableScaling => "Sélectionnez le modèle\u00a0R15 afin d'autoriser le changement de taille.";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "Succès";

	/// <summary>
	/// Key: "Message.SuccessCreateCostume"
	/// English String: "Created costume"
	/// </summary>
	public override string MessageSuccessCreateCostume => "Costume créé";

	/// <summary>
	/// Key: "Message.SuccessCreateOutfit"
	/// English String: "Created outfit"
	/// </summary>
	public override string MessageSuccessCreateOutfit => "Tenue créée";

	/// <summary>
	/// Key: "Message.SuccessDeleteCostume"
	/// Deleted costume
	/// English String: "Deleted costume"
	/// </summary>
	public override string MessageSuccessDeleteCostume => "Costume supprimé";

	/// <summary>
	/// Key: "Message.SuccessDeleteOutfit"
	/// English String: "Deleted outfit"
	/// </summary>
	public override string MessageSuccessDeleteOutfit => "Tenue supprimée";

	/// <summary>
	/// Key: "Message.SuccessEquipEmote"
	/// English String: "Equipped Emote"
	/// </summary>
	public override string MessageSuccessEquipEmote => "Emote actuelle";

	/// <summary>
	/// Key: "Message.SuccessRenameCostume"
	/// English String: "Renamed costume"
	/// </summary>
	public override string MessageSuccessRenameCostume => "Costume renommé";

	/// <summary>
	/// Key: "Message.SuccessRenameOutfit"
	/// English String: "Renamed outfit"
	/// </summary>
	public override string MessageSuccessRenameOutfit => "Tenue renommée";

	/// <summary>
	/// Key: "Message.SuccessSavedAccessories"
	/// English String: "Saved accessories"
	/// </summary>
	public override string MessageSuccessSavedAccessories => "Accessoires enregistrés";

	/// <summary>
	/// Key: "Message.SuccessUnequipEmote"
	/// English String: "Unequipped emote"
	/// </summary>
	public override string MessageSuccessUnequipEmote => "Emote enlevée";

	/// <summary>
	/// Key: "Message.SuccessUpdatedCostume"
	/// English String: "Updated costume"
	/// </summary>
	public override string MessageSuccessUpdatedCostume => "Costume mis à jour";

	/// <summary>
	/// Key: "Message.SuccessUpdatedOutfit"
	/// English String: "Updated outfit"
	/// </summary>
	public override string MessageSuccessUpdatedOutfit => "Tenue mise à jour";

	/// <summary>
	/// Key: "Message.SuccessWoreCostume"
	/// English String: "Successfully wore costume"
	/// </summary>
	public override string MessageSuccessWoreCostume => "Vous portez le costume.";

	/// <summary>
	/// Key: "Message.SuccessWoreOutfit"
	/// English String: "Successfully wore outfit"
	/// </summary>
	public override string MessageSuccessWoreOutfit => "Vous portez la tenue.";

	/// <summary>
	/// Key: "Message.UpdateThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Do you want to update this costume? This will overwrite the costume with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisCostume => "Voulez-vous vraiment mettre à jour ce costume\u00a0? Le costume sera remplacé par l'apparence actuelle de votre avatar.";

	/// <summary>
	/// Key: "Message.UpdateThisOutfit"
	/// English String: "Do you want to update this outfit? This will overwrite the outfit with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisOutfit => "Voulez-vous vraiment mettre à jour cette tenue\u00a0? La tenue sera remplacée par l'apparence actuelle de votre avatar.";

	/// <summary>
	/// Key: "Message.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string MessageWarning => "Avertissement";

	public AvatarResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdvanced()
	{
		return "Avancé";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "Acheter";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "Fermer";
	}

	protected override string _GetTemplateForActionCreate()
	{
		return "Créer";
	}

	protected override string _GetTemplateForActionCreateNewOutfit()
	{
		return "Créer";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "Supprimer";
	}

	protected override string _GetTemplateForActionDone()
	{
		return "Terminé";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "Obtenir";
	}

	protected override string _GetTemplateForActionGetMore()
	{
		return "Obtenir plus";
	}

	protected override string _GetTemplateForActionOpenRobloxApp()
	{
		return "Ouvrir l'application Roblox";
	}

	protected override string _GetTemplateForActionRedraw()
	{
		return "Redessiner";
	}

	protected override string _GetTemplateForActionRename()
	{
		return "Renommer";
	}

	protected override string _GetTemplateForActionRenameOutfit()
	{
		return "Renommer";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Enregistrer";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Afficher tout";
	}

	protected override string _GetTemplateForActionThreeDimensions()
	{
		return "3D";
	}

	protected override string _GetTemplateForActionTwoDimensions()
	{
		return "2D";
	}

	protected override string _GetTemplateForActionUpdate()
	{
		return "Mise à jour";
	}

	protected override string _GetTemplateForActionUserUnderstands()
	{
		return "OK";
	}

	protected override string _GetTemplateForDescriptionAvatarEditorUpsell()
	{
		return "Pour modifier ton apparence, tu dois utiliser l'éditeur d'avatar dans l'application.";
	}

	protected override string _GetTemplateForDescriptionCreateNewCostume()
	{
		return "Un costume sera créé à partir de l'apparence actuelle de votre avatar.";
	}

	protected override string _GetTemplateForDescriptionCreateNewOutfit()
	{
		return "Une tenue sera créée à partir de l'apparence actuelle de ton avatar.";
	}

	protected override string _GetTemplateForDescriptionRenameCostume()
	{
		return "Choisissez un nouveau nom pour votre costume.";
	}

	protected override string _GetTemplateForDescriptionRenameOutfit()
	{
		return "Choisis un nouveau nom pour ta tenue.";
	}

	protected override string _GetTemplateForHeadingAccessories()
	{
		return "Accessoires";
	}

	protected override string _GetTemplateForHeadingAccessoriesChange()
	{
		return "Changement d'accessoires";
	}

	protected override string _GetTemplateForHeadingAdvancedOptions()
	{
		return "Options avancées";
	}

	protected override string _GetTemplateForHeadingAll()
	{
		return "Tous";
	}

	protected override string _GetTemplateForHeadingAnimations()
	{
		return "Animations";
	}

	protected override string _GetTemplateForHeadingAppearance()
	{
		return "Apparence";
	}

	protected override string _GetTemplateForHeadingAvatarPageTitle()
	{
		return "Éditeur d'avatar";
	}

	protected override string _GetTemplateForHeadingBody()
	{
		return "Corps";
	}

	protected override string _GetTemplateForHeadingBodyParts()
	{
		return "Parties du corps";
	}

	protected override string _GetTemplateForHeadingClothing()
	{
		return "Vêtements";
	}

	protected override string _GetTemplateForHeadingCostumes()
	{
		return "Costumes";
	}

	protected override string _GetTemplateForHeadingCreateNewCostume()
	{
		return "Créer un nouveau costume";
	}

	protected override string _GetTemplateForHeadingCreateNewOutfit()
	{
		return "Créer une nouvelle tenue";
	}

	protected override string _GetTemplateForHeadingDelete()
	{
		return "Supprimer";
	}

	protected override string _GetTemplateForHeadingDeleteCostume()
	{
		return "Supprimer le costume";
	}

	protected override string _GetTemplateForHeadingDeleteOutfit()
	{
		return "Supprimer la tenue";
	}

	protected override string _GetTemplateForHeadingEmotes()
	{
		return "Emotes";
	}

	protected override string _GetTemplateForHeadingEquipEmotes()
	{
		return "Équiper";
	}

	protected override string _GetTemplateForHeadingOutfits()
	{
		return "Tenues";
	}

	protected override string _GetTemplateForHeadingPackages()
	{
		return "Packs";
	}

	protected override string _GetTemplateForHeadingRecent()
	{
		return "Récents";
	}

	protected override string _GetTemplateForHeadingRecommended()
	{
		return "Recommandés";
	}

	protected override string _GetTemplateForHeadingRenameCostume()
	{
		return "Renommer le costume";
	}

	protected override string _GetTemplateForHeadingRenameOutfit()
	{
		return "Renommer la tenue";
	}

	protected override string _GetTemplateForHeadingScaling()
	{
		return "Changement de taille";
	}

	protected override string _GetTemplateForHeadingSkinToneBodyParts()
	{
		return "Teint des différentes parties du corps";
	}

	protected override string _GetTemplateForHeadingUpdate()
	{
		return "Mise à jour";
	}

	protected override string _GetTemplateForHeadingUpdateCostume()
	{
		return "Mettre à jour le costume";
	}

	protected override string _GetTemplateForHeadingUpdateOutfit()
	{
		return "Mettre à jour la tenue";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "Tous";
	}

	protected override string _GetTemplateForLabelAskIfLoadingCorrectly()
	{
		return "L'avatar ne se charge pas correctement\u00a0?";
	}

	protected override string _GetTemplateForLabelAssetIDPlaceholder()
	{
		return "ID de l'élément";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "Dos";
	}

	protected override string _GetTemplateForLabelBackAccessories()
	{
		return "Accessoires arrière";
	}

	protected override string _GetTemplateForLabelBodyType()
	{
		return "Type de corps";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "Escalade";
	}

	protected override string _GetTemplateForLabelClimbAnimations()
	{
		return "Animations d'escalade";
	}

	protected override string _GetTemplateForLabelClothes()
	{
		return "Vêtements";
	}

	protected override string _GetTemplateForLabelCostume()
	{
		return "Costume";
	}

	/// <summary>
	/// Key: "Label.DirectionsForPackagePlacement"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Packages have been moved to Costumes. Check {startBold}Costumes{rightArrow}Preset Costumes{endBold}"
	/// </summary>
	public override string LabelDirectionsForPackagePlacement(string startBold, string rightArrow, string endBold)
	{
		return $"Les packs ont été déplacés avec les costumes. Allez dans {startBold}Costumes{rightArrow}Costumes prédéfinis{endBold}.";
	}

	protected override string _GetTemplateForLabelDirectionsForPackagePlacement()
	{
		return "Les packs ont été déplacés avec les costumes. Allez dans {startBold}Costumes{rightArrow}Costumes prédéfinis{endBold}.";
	}

	/// <summary>
	/// Key: "Label.DirectionsForScalingOptions"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Scaling options are available under Body category. Check {startBold}Body{rightArrow}Scale{endBold}"
	/// </summary>
	public override string LabelDirectionsForScalingOptions(string startBold, string rightArrow, string endBold)
	{
		return $"Les options de changement de taille sont disponibles dans la catégorie Corps. Rendez-vous dans {startBold}Corps{rightArrow}Taille{endBold}";
	}

	protected override string _GetTemplateForLabelDirectionsForScalingOptions()
	{
		return "Les options de changement de taille sont disponibles dans la catégorie Corps. Rendez-vous dans {startBold}Corps{rightArrow}Taille{endBold}";
	}

	protected override string _GetTemplateForlabelEmotes()
	{
		return "Emotes";
	}

	protected override string _GetTemplateForLabelEquip()
	{
		return "Équiper";
	}

	protected override string _GetTemplateForLabelExploreCatalog()
	{
		return "Naviguez dans le catalogue pour trouver plus de vêtements\u00a0!";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "Visage";
	}

	protected override string _GetTemplateForLabelFaceAccessories()
	{
		return "Accessoires de visage";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Visages";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "Chute";
	}

	protected override string _GetTemplateForLabelFallAnimations()
	{
		return "Animations de chute";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Gratuit";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "Avant";
	}

	protected override string _GetTemplateForLabelFrontAccessories()
	{
		return "Accessoires avant";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Équipement";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "Cheveux";
	}

	protected override string _GetTemplateForLabelHairAccessories()
	{
		return "Accessoires de cheveux";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "Chapeau";
	}

	protected override string _GetTemplateForLabelHatAccessories()
	{
		return "Accessoires de chapeau";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "Tête";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Têtes";
	}

	protected override string _GetTemplateForLabelHeight()
	{
		return "Hauteur";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "Inaction";
	}

	protected override string _GetTemplateForLabelIdleAnimations()
	{
		return "Animations d'inaction";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "Saut";
	}

	protected override string _GetTemplateForLabelJumpAnimations()
	{
		return "Animations de saut";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "Bras gauche";
	}

	protected override string _GetTemplateForLabelLeftArms()
	{
		return "Bras gauches";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "Jambe gauche";
	}

	protected override string _GetTemplateForLabelLeftLegs()
	{
		return "Jambes gauches";
	}

	protected override string _GetTemplateForLabelMyCostumes()
	{
		return "Mes costumes";
	}

	protected override string _GetTemplateForLabelNamePlaceholderCostume()
	{
		return "Nommez votre costume";
	}

	protected override string _GetTemplateForLabelNamePlaceholderOutfit()
	{
		return "Nomme ta tenue";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "Cou";
	}

	protected override string _GetTemplateForLabelNeckAccessories()
	{
		return "Accessoires de cou";
	}

	protected override string _GetTemplateForLabelNoResellers()
	{
		return "Aucun revendeur";
	}

	protected override string _GetTemplateForLabelOffSale()
	{
		return "Hors d'offre";
	}

	protected override string _GetTemplateForLabelOutfit()
	{
		return "Tenue";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Pantalons";
	}

	protected override string _GetTemplateForLabelParts()
	{
		return "Parties";
	}

	protected override string _GetTemplateForLabelPresetCostumes()
	{
		return "Costumes prédéfinis";
	}

	protected override string _GetTemplateForLabelProportions()
	{
		return "Proportions";
	}

	protected override string _GetTemplateForLabelRedrawUnavailable()
	{
		return "Impossible de redessiner l'avatar.";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "Bras droit";
	}

	protected override string _GetTemplateForLabelRightArms()
	{
		return "Bras droits";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "Jambe droite";
	}

	protected override string _GetTemplateForLabelRightLegs()
	{
		return "Jambes droites";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "Course";
	}

	protected override string _GetTemplateForLabelRunAnimations()
	{
		return "Animations de course";
	}

	protected override string _GetTemplateForLabelScale()
	{
		return "Taille";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Chemises";
	}

	protected override string _GetTemplateForLabelShoulderAccessories()
	{
		return "Accessoires d'épaule";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "Épaules";
	}

	protected override string _GetTemplateForLabelSkinTone()
	{
		return "Teint";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "Nage";
	}

	protected override string _GetTemplateForLabelSwimAnimations()
	{
		return "Animations de nage";
	}

	protected override string _GetTemplateForLabelSwitchAvatarType()
	{
		return "Alternez entre l'avatar classique R6 et le modèle R15 de nouvelle génération, plus expressif.";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "Torse";
	}

	protected override string _GetTemplateForLabelTorsos()
	{
		return "Torses";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Tee-shirts";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "Taille";
	}

	protected override string _GetTemplateForLabelWaistAccessories()
	{
		return "Accessoires de taille";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "Marche";
	}

	protected override string _GetTemplateForLabelWalkAnimations()
	{
		return "Animations de marche";
	}

	protected override string _GetTemplateForLabelWidth()
	{
		return "Largeur";
	}

	protected override string _GetTemplateForLabelYourEmotes()
	{
		return "Tes Emotes";
	}

	protected override string _GetTemplateForMessageAccessoriesChange()
	{
		return "Veux-tu vraiment remplacer ton apparence actuelle\u00a0?";
	}

	protected override string _GetTemplateForMessageChooseEmote()
	{
		return "Choisis une Emote";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlot()
	{
		return "Choisis un emplacement";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlotOrEmote()
	{
		return "Choisis un emplacement ou une Emote";
	}

	protected override string _GetTemplateForMessageDefaultClothing()
	{
		return "Les vêtements par défaut ont été appliqués à ton avatar\u00a0; mets tes propres vêtements.";
	}

	/// <summary>
	/// Key: "Message.DeleteOutfit"
	/// English String: "Are you sure you want to delete this {outfitType}?"
	/// </summary>
	public override string MessageDeleteOutfit(string outfitType)
	{
		return $"Voulez-vous vraiment supprimer la tenue {outfitType}\u00a0?";
	}

	protected override string _GetTemplateForMessageDeleteOutfit()
	{
		return "Voulez-vous vraiment supprimer la tenue {outfitType}\u00a0?";
	}

	protected override string _GetTemplateForMessageDeleteThisCostume()
	{
		return "Voulez-vous vraiment supprimer ce costume\u00a0?";
	}

	protected override string _GetTemplateForMessageDeleteThisOutfit()
	{
		return "Voulez-vous vraiment supprimer cette tenue\u00a0?";
	}

	protected override string _GetTemplateForMessageEmotesInstructions()
	{
		return "Va dans \"Animations\" > \"Emotes\" > \"Équiper\" pour enregistrer une emote.";
	}

	protected override string _GetTemplateForMessageEmptyAssetList()
	{
		return "Rien à afficher.";
	}

	/// <summary>
	/// Key: "Message.EmptyListForItem"
	/// The user tries to load a list of some item but they see nothing because they don't own anything of that type.
	/// English String: "You don't have this item: {itemType}"
	/// </summary>
	public override string MessageEmptyListForItem(string itemType)
	{
		return $"Vous ne possédez pas cet objet\u00a0: {itemType}";
	}

	protected override string _GetTemplateForMessageEmptyListForItem()
	{
		return "Vous ne possédez pas cet objet\u00a0: {itemType}";
	}

	protected override string _GetTemplateForMessageEmptyListOfCostumes()
	{
		return "Vous n'avez aucun costume. Essayez d'en créer un\u00a0!";
	}

	protected override string _GetTemplateForMessageEmptyListOfOutfits()
	{
		return "Vous n'avez aucune tenue. Essayez d'en créer une\u00a0!";
	}

	protected override string _GetTemplateForMessageEmptyRecentItems()
	{
		return "Vous n'avez aucun objet récent.";
	}

	protected override string _GetTemplateForMessageErrorCreateCostume()
	{
		return "Impossible de créer le costume. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorCreateOutfit()
	{
		return "Impossible de créer la tenue. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorDeleteEmote()
	{
		return "Impossible de supprimer l’emote.";
	}

	protected override string _GetTemplateForMessageErrorEquipEmote()
	{
		return "Impossible d'enregistrer l'emote, réessaye plus tard.";
	}

	protected override string _GetTemplateForMessageErrorLoadCostume()
	{
		return "Impossible de charger le costume.";
	}

	protected override string _GetTemplateForMessageErrorLoadEmotes()
	{
		return "Impossible de charger les emotes.";
	}

	protected override string _GetTemplateForMessageErrorLoadOutfits()
	{
		return "Impossible de charger les tenues.";
	}

	protected override string _GetTemplateForMessageErrorOutfitName()
	{
		return "Les noms peuvent contenir des lettres, des chiffres et des espaces.";
	}

	protected override string _GetTemplateForMessageErrorRenameCostume()
	{
		return "Impossible de renommer le costume.";
	}

	protected override string _GetTemplateForMessageErrorRenameOutfit()
	{
		return "Impossible de renommer la tenue.";
	}

	protected override string _GetTemplateForMessageErrorUnequipEmote()
	{
		return "Impossible d'enlever l’emote.";
	}

	protected override string _GetTemplateForMessageErrorUpdateCostume()
	{
		return "Échec de la mise à jour du costume. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorUpdateEmote()
	{
		return "La mise à jour des emotes a échoué, réessaye plus tard.";
	}

	protected override string _GetTemplateForMessageErrorUpdateOutfit()
	{
		return "Échec de la mise à jour de la tenue. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorUpdateWorn()
	{
		return "Erreur lors de la mise à jour des objets portés.";
	}

	protected override string _GetTemplateForMessageErrorWearCostume()
	{
		return "Impossible de porter le costume.";
	}

	protected override string _GetTemplateForMessageErrorWearOutfit()
	{
		return "Impossible de porter la tenue.";
	}

	protected override string _GetTemplateForMessageFailedDeleteCostume()
	{
		return "Impossible de supprimer le costume.";
	}

	protected override string _GetTemplateForMessageFailedDeleteEmote()
	{
		return "Impossible de supprimer l’emote.";
	}

	protected override string _GetTemplateForMessageFailedDeleteOutfit()
	{
		return "Impossible de supprimer la tenue.";
	}

	protected override string _GetTemplateForMessageFailedLoadAssets()
	{
		return "Impossible de charger la liste des éléments.";
	}

	protected override string _GetTemplateForMessageFailedLoadRecent()
	{
		return "Impossible de charger les objets récents.";
	}

	protected override string _GetTemplateForMessageFailedUpdateBodyColor()
	{
		return "Impossible de mettre à jour le teint.";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedCostume()
	{
		return "Le costume que vous essayez de mettre à jour n'existe plus.";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedOutfit()
	{
		return "La tenue que vous essayez de mettre à jour n'existe plus.";
	}

	protected override string _GetTemplateForMessageFailedUpdateScales()
	{
		return "Impossible de mettre à jour la taille.";
	}

	protected override string _GetTemplateForMessageFailedUpdateType()
	{
		return "Impossible de mettre à jour le type d'avatar.";
	}

	protected override string _GetTemplateForMessageFailedWearPackage()
	{
		return "Impossible de porter le pack.";
	}

	protected override string _GetTemplateForMessageHatLimitTooltip()
	{
		return "Vous pouvez porter jusqu'à 3\u00a0chapeaux.";
	}

	protected override string _GetTemplateForMessageInvalidOutfitName()
	{
		return "Le nom doit être approprié et compter moins de 200\u00a0caractères.";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "Chargement...";
	}

	/// <summary>
	/// Key: "Message.MissingItemsFromOutfit"
	/// User cannot wear an outfit because they are missing or have deleted some of the items that were part of that outfit.
	/// English String: "Number of items that you don't own in this outfit: {number}"
	/// </summary>
	public override string MessageMissingItemsFromOutfit(string number)
	{
		return $"Nombre d'objets non possédés dans cette tenue\u00a0: {number}";
	}

	protected override string _GetTemplateForMessageMissingItemsFromOutfit()
	{
		return "Nombre d'objets non possédés dans cette tenue\u00a0: {number}";
	}

	protected override string _GetTemplateForMessagePageUnavailable()
	{
		return "La page des avatars est temporairement indisponible.";
	}

	protected override string _GetTemplateForMessagePresetCostumesDelay()
	{
		return "Remarque\u00a0: nous faisons un peu de ménage, alors vos costumes peuvent prendre plusieurs minutes avant d'apparaître. Réessayez dans quelques minutes\u00a0!";
	}

	protected override string _GetTemplateForMessageReachedMaxCostumes()
	{
		return "Vous avez atteint le nombre maximum de costumes autorisés.";
	}

	protected override string _GetTemplateForMessageReachedMaxOutfits()
	{
		return "Vous avez atteint le nombre maximum de tenues autorisées.";
	}

	protected override string _GetTemplateForMessageRedirectAvatarSettings()
	{
		return "Vous pouvez définir les paramètres de votre avatar depuis votre projet Roblox Studio. Dans Roblox Studio, allez dans Accueil > Paramètres du jeu > Avatar";
	}

	protected override string _GetTemplateForMessageRedrawFloodchecked()
	{
		return "Tu as redessiné ton avatar trop de fois. Réessaye plus tard.";
	}

	protected override string _GetTemplateForMessageRedrawThumbnailFailed()
	{
		return "Impossible de redessiner la miniature.";
	}

	protected override string _GetTemplateForMessageSelectEnableScaling()
	{
		return "Sélectionnez le modèle\u00a0R15 afin d'autoriser le changement de taille.";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "Succès";
	}

	protected override string _GetTemplateForMessageSuccessCreateCostume()
	{
		return "Costume créé";
	}

	protected override string _GetTemplateForMessageSuccessCreateOutfit()
	{
		return "Tenue créée";
	}

	protected override string _GetTemplateForMessageSuccessDeleteCostume()
	{
		return "Costume supprimé";
	}

	protected override string _GetTemplateForMessageSuccessDeleteOutfit()
	{
		return "Tenue supprimée";
	}

	protected override string _GetTemplateForMessageSuccessEquipEmote()
	{
		return "Emote actuelle";
	}

	protected override string _GetTemplateForMessageSuccessRenameCostume()
	{
		return "Costume renommé";
	}

	protected override string _GetTemplateForMessageSuccessRenameOutfit()
	{
		return "Tenue renommée";
	}

	protected override string _GetTemplateForMessageSuccessSavedAccessories()
	{
		return "Accessoires enregistrés";
	}

	protected override string _GetTemplateForMessageSuccessUnequipEmote()
	{
		return "Emote enlevée";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedCostume()
	{
		return "Costume mis à jour";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedOutfit()
	{
		return "Tenue mise à jour";
	}

	protected override string _GetTemplateForMessageSuccessWoreCostume()
	{
		return "Vous portez le costume.";
	}

	protected override string _GetTemplateForMessageSuccessWoreOutfit()
	{
		return "Vous portez la tenue.";
	}

	/// <summary>
	/// Key: "Message.UpdateOutfit"
	/// English String: "Do you want to update this {outfitType1}? This will overwrite the {outfitType2} with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateOutfit(string outfitType1, string outfitType2)
	{
		return $"Veux-tu vraiment mettre à jour la tenue {outfitType1}\u00a0? La tenue {outfitType2} sera remplacée par l'apparence actuelle de ton avatar.";
	}

	protected override string _GetTemplateForMessageUpdateOutfit()
	{
		return "Veux-tu vraiment mettre à jour la tenue {outfitType1}\u00a0? La tenue {outfitType2} sera remplacée par l'apparence actuelle de ton avatar.";
	}

	protected override string _GetTemplateForMessageUpdateThisCostume()
	{
		return "Voulez-vous vraiment mettre à jour ce costume\u00a0? Le costume sera remplacé par l'apparence actuelle de votre avatar.";
	}

	protected override string _GetTemplateForMessageUpdateThisOutfit()
	{
		return "Voulez-vous vraiment mettre à jour cette tenue\u00a0? La tenue sera remplacée par l'apparence actuelle de votre avatar.";
	}

	protected override string _GetTemplateForMessageWarning()
	{
		return "Avertissement";
	}
}
