namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AvatarResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AvatarResources_es_es : AvatarResources_en_us, IAvatarResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.Advanced"
	/// Click Advanced to get the advanced options
	/// English String: "Advanced"
	/// </summary>
	public override string ActionAdvanced => "Avanzado";

	/// <summary>
	/// Key: "Action.Buy"
	/// Button used to buy an item to customize the user's avatar.
	/// English String: "Buy"
	/// </summary>
	public override string ActionBuy => "Comprar";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionClose => "Cerrar";

	/// <summary>
	/// Key: "Action.Create"
	/// English String: "Create"
	/// </summary>
	public override string ActionCreate => "Crear";

	/// <summary>
	/// Key: "Action.CreateNewOutfit"
	/// Button to create new outfit
	/// English String: "Create"
	/// </summary>
	public override string ActionCreateNewOutfit => "Crear";

	/// <summary>
	/// Key: "Action.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string ActionDelete => "Eliminar";

	/// <summary>
	/// Key: "Action.Done"
	/// English String: "Done"
	/// </summary>
	public override string ActionDone => "Hecho";

	/// <summary>
	/// Key: "Action.Get"
	/// Button used to buy get an item for free to customize the user's avatar.
	/// English String: "Get"
	/// </summary>
	public override string ActionGet => "Obtener";

	/// <summary>
	/// Key: "Action.GetMore"
	/// A call to action for the user to buy more clothes from the Catalog page. This could improve how their avatar looks.
	/// English String: "Get More"
	/// </summary>
	public override string ActionGetMore => "Obtener más";

	/// <summary>
	/// Key: "Action.OpenRobloxApp"
	/// English String: "Open Roblox App"
	/// </summary>
	public override string ActionOpenRobloxApp => "Abrir aplicación de Roblox";

	/// <summary>
	/// Key: "Action.Redraw"
	/// Redraw the avatar on the screen
	/// English String: "Redraw"
	/// </summary>
	public override string ActionRedraw => "Redibujar";

	/// <summary>
	/// Key: "Action.Rename"
	/// English String: "Rename"
	/// </summary>
	public override string ActionRename => "Renombrar";

	/// <summary>
	/// Key: "Action.RenameOutfit"
	/// Button to rename outfit
	/// English String: "Rename"
	/// </summary>
	public override string ActionRenameOutfit => "Renombrar";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Guardar";

	/// <summary>
	/// Key: "Action.SeeAll"
	/// See all clothing that user can buy
	/// English String: "See All"
	/// </summary>
	public override string ActionSeeAll => "Ver todo";

	/// <summary>
	/// Key: "Action.ThreeDimensions"
	/// This button allows the user to view their avatar in three dimensions.
	/// English String: "3D"
	/// </summary>
	public override string ActionThreeDimensions => "3D";

	/// <summary>
	/// Key: "Action.TwoDimensions"
	/// This button allows the user to view their avatar in two dimensions.
	/// English String: "2D"
	/// </summary>
	public override string ActionTwoDimensions => "2D";

	/// <summary>
	/// Key: "Action.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionUpdate => "Actualizar";

	/// <summary>
	/// Key: "Action.UserUnderstands"
	/// The user casually responds to the application saying that they understand how to navigate the menu.
	/// English String: "Got it"
	/// </summary>
	public override string ActionUserUnderstands => "Entendido";

	/// <summary>
	/// Key: "Description.AvatarEditorUpsell"
	/// English String: "To change your look you will need to use the Avatar Editor on the App."
	/// </summary>
	public override string DescriptionAvatarEditorUpsell => "Para cambiar tu aspecto, tendrás que utilizar el Editor de avatares en la aplicación.";

	/// <summary>
	/// Key: "Description.CreateNewCostume"
	/// A costume will be created from your avatar's current appearance.
	/// English String: "A costume will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewCostume => "El disfraz se creará según el aspecto actual de tu avatar.";

	/// <summary>
	/// Key: "Description.CreateNewOutfit"
	/// An outfit will be created from your avatar's current appearance.
	/// English String: "An outfit will be created from your avatar's current appearance."
	/// </summary>
	public override string DescriptionCreateNewOutfit => "El conjunto se creará a partir del aspecto actual de tu avatar.";

	/// <summary>
	/// Key: "Description.RenameCostume"
	/// Choose a new name for your costume.
	/// English String: "Choose a new name for your costume."
	/// </summary>
	public override string DescriptionRenameCostume => "Elige un nuevo nombre para tu disfraz.";

	/// <summary>
	/// Key: "Description.RenameOutfit"
	/// Choose a new name for your outfit.
	/// English String: "Choose a new name for your outfit."
	/// </summary>
	public override string DescriptionRenameOutfit => "Elige un nuevo nombre para tu conjunto.";

	/// <summary>
	/// Key: "Heading.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string HeadingAccessories => "Accesorios";

	/// <summary>
	/// Key: "Heading.AccessoriesChange"
	/// English String: "Accessories Change"
	/// </summary>
	public override string HeadingAccessoriesChange => "Cambio de accesorios";

	/// <summary>
	/// Key: "Heading.AdvancedOptions"
	/// English String: "Advanced Options"
	/// </summary>
	public override string HeadingAdvancedOptions => "Opciones avanzadas";

	/// <summary>
	/// Key: "Heading.All"
	/// All avatar modification types
	/// English String: "All"
	/// </summary>
	public override string HeadingAll => "Todos";

	/// <summary>
	/// Key: "Heading.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string HeadingAnimations => "Animaciones";

	/// <summary>
	/// Key: "Heading.Appearance"
	/// English String: "Appearance"
	/// </summary>
	public override string HeadingAppearance => "Aspecto";

	/// <summary>
	/// Key: "Heading.AvatarPageTitle"
	/// Page title for the Avatar page. On this page, the user can modify how they look.
	/// English String: "Avatar Editor"
	/// </summary>
	public override string HeadingAvatarPageTitle => "Editor de avatares";

	/// <summary>
	/// Key: "Heading.Body"
	/// English String: "Body"
	/// </summary>
	public override string HeadingBody => "Cuerpo";

	/// <summary>
	/// Key: "Heading.BodyParts"
	/// English String: "Body Parts"
	/// </summary>
	public override string HeadingBodyParts => "Partes del cuerpo";

	/// <summary>
	/// Key: "Heading.Clothing"
	/// English String: "Clothing"
	/// </summary>
	public override string HeadingClothing => "Ropa";

	/// <summary>
	/// Key: "Heading.Costumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Costumes"
	/// </summary>
	public override string HeadingCostumes => "Disfraces";

	/// <summary>
	/// Key: "Heading.CreateNewCostume"
	/// NOTE: Costume is a more whimsical word choice for outfit. Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Create New Costume"
	/// </summary>
	public override string HeadingCreateNewCostume => "Crear nuevo disfraz";

	/// <summary>
	/// Key: "Heading.CreateNewOutfit"
	/// English String: "Create New Outfit"
	/// </summary>
	public override string HeadingCreateNewOutfit => "Crear nuevo conjunto";

	/// <summary>
	/// Key: "Heading.Delete"
	/// English String: "Delete"
	/// </summary>
	public override string HeadingDelete => "Eliminar";

	/// <summary>
	/// Key: "Heading.DeleteCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Delete Costume"
	/// </summary>
	public override string HeadingDeleteCostume => "Eliminar el disfraz";

	/// <summary>
	/// Key: "Heading.DeleteOutfit"
	/// English String: "Delete Outfit"
	/// </summary>
	public override string HeadingDeleteOutfit => "Eliminar el conjunto";

	/// <summary>
	/// Key: "Heading.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string HeadingEmotes => "Emoticonos";

	/// <summary>
	/// Key: "Heading.EquipEmotes"
	/// English String: "Equip Emotes"
	/// </summary>
	public override string HeadingEquipEmotes => "Equipar emoticonos";

	/// <summary>
	/// Key: "Heading.Outfits"
	/// English String: "Outfits"
	/// </summary>
	public override string HeadingOutfits => "Conjuntos";

	/// <summary>
	/// Key: "Heading.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string HeadingPackages => "Paquetes";

	/// <summary>
	/// Key: "Heading.Recent"
	/// English String: "Recent"
	/// </summary>
	public override string HeadingRecent => "Recientes";

	/// <summary>
	/// Key: "Heading.Recommended"
	/// See recommended clothing for your avatar
	/// English String: "Recommended"
	/// </summary>
	public override string HeadingRecommended => "Recomendados";

	/// <summary>
	/// Key: "Heading.RenameCostume"
	/// English String: "Rename Costume"
	/// </summary>
	public override string HeadingRenameCostume => "Cambiar el nombre del disfraz";

	/// <summary>
	/// Key: "Heading.RenameOutfit"
	/// English String: "Rename Outfit"
	/// </summary>
	public override string HeadingRenameOutfit => "Cambiar el nombre del conjunto";

	/// <summary>
	/// Key: "Heading.Scaling"
	/// English String: "Scaling"
	/// </summary>
	public override string HeadingScaling => "Escalado";

	/// <summary>
	/// Key: "Heading.SkinToneBodyParts"
	/// English String: "Skin Tone by Body Parts"
	/// </summary>
	public override string HeadingSkinToneBodyParts => "Tono de piel por partes del cuerpo";

	/// <summary>
	/// Key: "Heading.Update"
	/// English String: "Update"
	/// </summary>
	public override string HeadingUpdate => "Actualizar";

	/// <summary>
	/// Key: "Heading.UpdateCostume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Update Costume"
	/// </summary>
	public override string HeadingUpdateCostume => "Actualizar el disfraz";

	/// <summary>
	/// Key: "Heading.UpdateOutfit"
	/// English String: "Update Outfit"
	/// </summary>
	public override string HeadingUpdateOutfit => "Actualizar el conjunto";

	/// <summary>
	/// Key: "Label.All"
	/// All body parts. This label will allow for body parts to change color
	/// English String: "All"
	/// </summary>
	public override string LabelAll => "Todas";

	/// <summary>
	/// Key: "Label.AskIfLoadingCorrectly"
	/// Avatar isn't loading correctly?
	/// English String: "Avatar isn't loading correctly?"
	/// </summary>
	public override string LabelAskIfLoadingCorrectly => "¿El avatar no se carga correctamente?";

	/// <summary>
	/// Key: "Label.AssetIDPlaceholder"
	/// This refers to the Asset ID which is a technical word for the Identification Number of an item or asset.
	/// English String: "Asset ID"
	/// </summary>
	public override string LabelAssetIDPlaceholder => "ID del recurso";

	/// <summary>
	/// Key: "Label.Back"
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "Traseros";

	/// <summary>
	/// Key: "Label.BackAccessories"
	/// English String: "Back Accessories"
	/// </summary>
	public override string LabelBackAccessories => "Accesorios traseros";

	/// <summary>
	/// Key: "Label.BodyType"
	/// English String: "Body Type"
	/// </summary>
	public override string LabelBodyType => "Tipo de cuerpo";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "Escalada";

	/// <summary>
	/// Key: "Label.ClimbAnimations"
	/// English String: "Climb Animations"
	/// </summary>
	public override string LabelClimbAnimations => "Animaciones de escalada";

	/// <summary>
	/// Key: "Label.Clothes"
	/// English String: "Clothes"
	/// </summary>
	public override string LabelClothes => "Ropa";

	/// <summary>
	/// Key: "Label.Costume"
	/// NOTE: Any instance of the word "Outfit" will eventually be swapped out for "Costume" This is not currently in the UI
	/// English String: "Costume"
	/// </summary>
	public override string LabelCostume => "Disfraz";

	/// <summary>
	/// Key: "label.Emotes"
	/// English String: "Emotes"
	/// </summary>
	public override string labelEmotes => "Emoticonos";

	/// <summary>
	/// Key: "Label.Equip"
	/// English String: "Equip"
	/// </summary>
	public override string LabelEquip => "Equipar";

	/// <summary>
	/// Key: "Label.ExploreCatalog"
	/// This text entices users to shop for more things to wear on their avatar
	/// English String: "Explore the catalog to find more clothes!"
	/// </summary>
	public override string LabelExploreCatalog => "¡Explora el catálogo para encontrar más ropa!";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "Cara";

	/// <summary>
	/// Key: "Label.FaceAccessories"
	/// English String: "Face Accessories"
	/// </summary>
	public override string LabelFaceAccessories => "Accesorios para la cara";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Caras";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "Caída";

	/// <summary>
	/// Key: "Label.FallAnimations"
	/// English String: "Fall Animations"
	/// </summary>
	public override string LabelFallAnimations => "Animaciones de caída";

	/// <summary>
	/// Key: "Label.Free"
	/// Text label for recommended items
	/// English String: "Free"
	/// </summary>
	public override string LabelFree => "Gratis";

	/// <summary>
	/// Key: "Label.Front"
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "Frontales";

	/// <summary>
	/// Key: "Label.FrontAccessories"
	/// English String: "Front Accessories"
	/// </summary>
	public override string LabelFrontAccessories => "Accesorios frontales";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Equipamiento";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "Pelo";

	/// <summary>
	/// Key: "Label.HairAccessories"
	/// English String: "Hair Accessories"
	/// </summary>
	public override string LabelHairAccessories => "Accesorios para el pelo";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "Sombrero";

	/// <summary>
	/// Key: "Label.HatAccessories"
	/// English String: "Hat Accessories"
	/// </summary>
	public override string LabelHatAccessories => "Accesorios para el sombrero";

	/// <summary>
	/// Key: "Label.Head"
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "Cabeza";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Cabezas";

	/// <summary>
	/// Key: "Label.Height"
	/// English String: "Height"
	/// </summary>
	public override string LabelHeight => "Altura";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "Inactividad";

	/// <summary>
	/// Key: "Label.IdleAnimations"
	/// English String: "Idle Animations"
	/// </summary>
	public override string LabelIdleAnimations => "Animaciones de inactividad";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "Salto";

	/// <summary>
	/// Key: "Label.JumpAnimations"
	/// English String: "Jump Animations"
	/// </summary>
	public override string LabelJumpAnimations => "Animaciones de salto";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "Brazo izquierdo";

	/// <summary>
	/// Key: "Label.LeftArms"
	/// English String: "Left Arms"
	/// </summary>
	public override string LabelLeftArms => "Brazos izquierdos";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "Pierna izquierda";

	/// <summary>
	/// Key: "Label.LeftLegs"
	/// English String: "Left Legs"
	/// </summary>
	public override string LabelLeftLegs => "Piernas izquierdas";

	/// <summary>
	/// Key: "Label.MyCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "My Costumes"
	/// </summary>
	public override string LabelMyCostumes => "Mis disfraces";

	/// <summary>
	/// Key: "Label.NamePlaceholderCostume"
	/// English String: "Name your costume"
	/// </summary>
	public override string LabelNamePlaceholderCostume => "Ponle un nombre a tu disfraz";

	/// <summary>
	/// Key: "Label.NamePlaceholderOutfit"
	/// English String: "Name your outfit"
	/// </summary>
	public override string LabelNamePlaceholderOutfit => "Ponle un nombre a tu conjunto";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "Cuello";

	/// <summary>
	/// Key: "Label.NeckAccessories"
	/// English String: "Neck Accessories"
	/// </summary>
	public override string LabelNeckAccessories => "Accesorios para el cuello";

	/// <summary>
	/// Key: "Label.NoResellers"
	/// Text label for recommended items
	/// English String: "No resellers"
	/// </summary>
	public override string LabelNoResellers => "Sin reventa";

	/// <summary>
	/// Key: "Label.OffSale"
	/// Text label for recommended items
	/// English String: "Off sale"
	/// </summary>
	public override string LabelOffSale => "Fuera de venta";

	/// <summary>
	/// Key: "Label.Outfit"
	/// English String: "Outfit"
	/// </summary>
	public override string LabelOutfit => "Conjunto";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Pantalones";

	/// <summary>
	/// Key: "Label.Parts"
	/// English String: "Parts"
	/// </summary>
	public override string LabelParts => "Partes del cuerpo";

	/// <summary>
	/// Key: "Label.PresetCostumes"
	/// NOTE: Any instance of the word "Outfits" will eventually be swapped out for "Costumes" This is not currently in the UI
	/// English String: "Preset Costumes"
	/// </summary>
	public override string LabelPresetCostumes => "Disfraces predeterminados";

	/// <summary>
	/// Key: "Label.Proportions"
	/// English String: "Proportions"
	/// </summary>
	public override string LabelProportions => "Proporciones";

	/// <summary>
	/// Key: "Label.RedrawUnavailable"
	/// Avatar redraw is unavailable
	/// English String: "Avatar redraw is unavailable."
	/// </summary>
	public override string LabelRedrawUnavailable => "El redibujo del avatar no está disponible.";

	/// <summary>
	/// Key: "Label.RightArm"
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "Brazo derecho";

	/// <summary>
	/// Key: "Label.RightArms"
	/// English String: "Right Arms"
	/// </summary>
	public override string LabelRightArms => "Brazos derechos";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "Pierna derecha";

	/// <summary>
	/// Key: "Label.RightLegs"
	/// English String: "Right Legs"
	/// </summary>
	public override string LabelRightLegs => "Piernas derechas";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "Carrera";

	/// <summary>
	/// Key: "Label.RunAnimations"
	/// English String: "Run Animations"
	/// </summary>
	public override string LabelRunAnimations => "Animaciones de carrera";

	/// <summary>
	/// Key: "Label.Scale"
	/// English String: "Scale"
	/// </summary>
	public override string LabelScale => "Escalado";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Camisas";

	/// <summary>
	/// Key: "Label.ShoulderAccessories"
	/// English String: "Shoulder Accessories"
	/// </summary>
	public override string LabelShoulderAccessories => "Accesorios para el hombro";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "Hombros";

	/// <summary>
	/// Key: "Label.SkinTone"
	/// English String: "Skin Tone"
	/// </summary>
	public override string LabelSkinTone => "Tono de piel";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "Nado";

	/// <summary>
	/// Key: "Label.SwimAnimations"
	/// English String: "Swim Animations"
	/// </summary>
	public override string LabelSwimAnimations => "Animaciones de nado";

	/// <summary>
	/// Key: "Label.SwitchAvatarType"
	/// User is able to increase the number of joints in their avatar from 6 to 15. R15 moves better. See http://roblox.wikia.com/wiki/R15
	/// English String: "Switch between classic R6 avatar and more expressive next generation R15 avatar"
	/// </summary>
	public override string LabelSwitchAvatarType => "Cambia entre la versión clásica de avatar R6 y la nueva generación R15 más expresiva.";

	/// <summary>
	/// Key: "Label.Torso"
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "Torso";

	/// <summary>
	/// Key: "Label.Torsos"
	/// English String: "Torsos"
	/// </summary>
	public override string LabelTorsos => "Torsos";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Camisetas";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "Cintura";

	/// <summary>
	/// Key: "Label.WaistAccessories"
	/// English String: "Waist Accessories"
	/// </summary>
	public override string LabelWaistAccessories => "Accesorios para la cintura";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "Marcha";

	/// <summary>
	/// Key: "Label.WalkAnimations"
	/// English String: "Walk Animations"
	/// </summary>
	public override string LabelWalkAnimations => "Animaciones de marcha";

	/// <summary>
	/// Key: "Label.Width"
	/// English String: "Width"
	/// </summary>
	public override string LabelWidth => "Anchura";

	/// <summary>
	/// Key: "Label.YourEmotes"
	/// English String: "Your Emotes"
	/// </summary>
	public override string LabelYourEmotes => "Tus emoticonos";

	/// <summary>
	/// Key: "Message.AccessoriesChange"
	/// English String: "Are you sure you want to override your current look?"
	/// </summary>
	public override string MessageAccessoriesChange => "¿Seguro que quieres reemplazar tu aspecto actual?";

	/// <summary>
	/// Key: "Message.ChooseEmote"
	/// English String: "Choose an Emote"
	/// </summary>
	public override string MessageChooseEmote => "Elige un emoticono";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlot"
	/// English String: "Choose a slot"
	/// </summary>
	public override string MessageChooseEmoteSlot => "Elige un espacio";

	/// <summary>
	/// Key: "Message.ChooseEmoteSlotOrEmote"
	/// English String: "Choose a slot or an Emote"
	/// </summary>
	public override string MessageChooseEmoteSlotOrEmote => "Elige un espacio o un emoticono";

	/// <summary>
	/// Key: "Message.DefaultClothing"
	/// Encourage user to choose their own clothes.
	/// English String: "Default clothing has been applied to your avatar - wear something from your clothing."
	/// </summary>
	public override string MessageDefaultClothing => "Se ha equipado tu avatar con ropa predeterminada. Viste algo de tu guardarropa.";

	/// <summary>
	/// Key: "Message.DeleteThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Are you sure you want to delete this costume?"
	/// </summary>
	public override string MessageDeleteThisCostume => "¿Seguro que quieres eliminar este disfraz?";

	/// <summary>
	/// Key: "Message.DeleteThisOutfit"
	/// English String: "Are you sure you want to delete this outfit?"
	/// </summary>
	public override string MessageDeleteThisOutfit => "¿Seguro que quieres eliminar este conjunto?";

	/// <summary>
	/// Key: "Message.EmotesInstructions"
	/// The instructions describe the navigation flow within the Avatar Editor to equip an emote.
	/// English String: "Go to \"Animations\" &gt; \"Emotes\" &gt; \"Equip Emotes\" to equip an emote."
	/// </summary>
	public override string MessageEmotesInstructions => "Ve a Animaciones > Emoticonos > Equipar emoticonos";

	/// <summary>
	/// Key: "Message.EmptyAssetList"
	/// User is seeing no assets on this page because they don't have any.
	/// English String: "You don't have any."
	/// </summary>
	public override string MessageEmptyAssetList => "No tienes ninguno.";

	/// <summary>
	/// Key: "Message.EmptyListOfCostumes"
	/// The user is viewing an empty list of costumes to choose from. The application tells the user that they can create an costume.
	/// English String: "You don't have any costumes. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfCostumes => "No tienes disfraces. ¡Crea algunos!";

	/// <summary>
	/// Key: "Message.EmptyListOfOutfits"
	/// The user is viewing an empty list of outfits to choose from. The application tells the user that they can create an outfit.
	/// English String: "You don't have any outfits. Try creating some!"
	/// </summary>
	public override string MessageEmptyListOfOutfits => "No tienes conjuntos. ¡Crea algunos!";

	/// <summary>
	/// Key: "Message.EmptyRecentItems"
	/// English String: "You don't have any recent items."
	/// </summary>
	public override string MessageEmptyRecentItems => "No tienes ningún objeto reciente.";

	/// <summary>
	/// Key: "Message.ErrorCreateCostume"
	/// English String: "Unable to create costume, try again later."
	/// </summary>
	public override string MessageErrorCreateCostume => "No se ha podido crear el disfraz. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.ErrorCreateOutfit"
	/// English String: "Unable to create outfit, try again later."
	/// </summary>
	public override string MessageErrorCreateOutfit => "No se ha podido crear el conjunto. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.ErrorDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageErrorDeleteEmote => "Error al eliminar el emoticono.";

	/// <summary>
	/// Key: "Message.ErrorEquipEmote"
	/// English String: "Failed to equip emote, please try again later."
	/// </summary>
	public override string MessageErrorEquipEmote => "Error al equipar el emoticono. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.ErrorLoadCostume"
	/// English String: "Failed to load costume."
	/// </summary>
	public override string MessageErrorLoadCostume => "Error al cargar el disfraz";

	/// <summary>
	/// Key: "Message.ErrorLoadEmotes"
	/// English String: "Failed to load emotes."
	/// </summary>
	public override string MessageErrorLoadEmotes => "Error al cargar los emoticonos.";

	/// <summary>
	/// Key: "Message.ErrorLoadOutfits"
	/// English String: "Failed to load outfits."
	/// </summary>
	public override string MessageErrorLoadOutfits => "Error al cargar los conjuntos";

	/// <summary>
	/// Key: "Message.ErrorOutfitName"
	/// English String: "Name can contain letters, numbers, and spaces."
	/// </summary>
	public override string MessageErrorOutfitName => "El nombre puede contener letras, números y espacios.";

	/// <summary>
	/// Key: "Message.ErrorRenameCostume"
	/// English String: "Failed to rename costume."
	/// </summary>
	public override string MessageErrorRenameCostume => "Error al cambiar el nombre del disfraz";

	/// <summary>
	/// Key: "Message.ErrorRenameOutfit"
	/// English String: "Failed to rename outfit."
	/// </summary>
	public override string MessageErrorRenameOutfit => "Error al cambiar el nombre del conjunto";

	/// <summary>
	/// Key: "Message.ErrorUnequipEmote"
	/// English String: "Failed to unequip emote."
	/// </summary>
	public override string MessageErrorUnequipEmote => "Error al desequipar el emoticono.";

	/// <summary>
	/// Key: "Message.ErrorUpdateCostume"
	/// English String: "Costume update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateCostume => "No se ha podido actualizar el disfraz. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.ErrorUpdateEmote"
	/// English String: "Updating emote slot failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateEmote => "Error al actualizar el espacio del emoticono. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.ErrorUpdateOutfit"
	/// English String: "Outfit update failed, please try again later."
	/// </summary>
	public override string MessageErrorUpdateOutfit => "No se ha podido actualizar el conjunto. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.ErrorUpdateWorn"
	/// There was an error updating items that the user is already wearing.
	/// English String: "Error while updating worn items."
	/// </summary>
	public override string MessageErrorUpdateWorn => "Error al actualizar los objetos puestos";

	/// <summary>
	/// Key: "Message.ErrorWearCostume"
	/// English String: "Failed to wear costume."
	/// </summary>
	public override string MessageErrorWearCostume => "Error al vestir el disfraz";

	/// <summary>
	/// Key: "Message.ErrorWearOutfit"
	/// English String: "Failed to wear outfit."
	/// </summary>
	public override string MessageErrorWearOutfit => "Error al vestir el conjunto";

	/// <summary>
	/// Key: "Message.FailedDeleteCostume"
	/// English String: "Failed to delete costume."
	/// </summary>
	public override string MessageFailedDeleteCostume => "Error al eliminar el disfraz";

	/// <summary>
	/// Key: "Message.FailedDeleteEmote"
	/// English String: "Failed to delete emote."
	/// </summary>
	public override string MessageFailedDeleteEmote => "Error al eliminar el emoticono.";

	/// <summary>
	/// Key: "Message.FailedDeleteOutfit"
	/// English String: "Failed to delete outfit."
	/// </summary>
	public override string MessageFailedDeleteOutfit => "Error al eliminar el conjunto";

	/// <summary>
	/// Key: "Message.FailedLoadAssets"
	/// English String: "Failed to load assets list."
	/// </summary>
	public override string MessageFailedLoadAssets => "Error al cargar la lista de recursos";

	/// <summary>
	/// Key: "Message.FailedLoadRecent"
	/// English String: "Failed to load recent items."
	/// </summary>
	public override string MessageFailedLoadRecent => "Error al cargar objetos recientes";

	/// <summary>
	/// Key: "Message.FailedUpdateBodyColor"
	/// English String: "Failed to update skin tone."
	/// </summary>
	public override string MessageFailedUpdateBodyColor => "Error al actualizar el tono de piel";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedCostume"
	/// The user tried to update a deleted costume.
	/// English String: "The costume you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedCostume => "El disfraz que querías actualizar ya no existe.";

	/// <summary>
	/// Key: "Message.FailedUpdateDeletedOutfit"
	/// The user tried to update a deleted outfit.
	/// English String: "The outfit you tried to update no longer exists."
	/// </summary>
	public override string MessageFailedUpdateDeletedOutfit => "El conjunto que querías actualizar ya no existe.";

	/// <summary>
	/// Key: "Message.FailedUpdateScales"
	/// English String: "Failed to update scales."
	/// </summary>
	public override string MessageFailedUpdateScales => "Error al actualizar las dimensiones";

	/// <summary>
	/// Key: "Message.FailedUpdateType"
	/// Failed to update the way the user's avatar is rendered.
	/// English String: "Failed to update avatar type."
	/// </summary>
	public override string MessageFailedUpdateType => "Error al actualizar el tipo de avatar";

	/// <summary>
	/// Key: "Message.FailedWearPackage"
	/// English String: "Failed to wear package."
	/// </summary>
	public override string MessageFailedWearPackage => "Error al vestir el paquete";

	/// <summary>
	/// Key: "Message.HatLimitTooltip"
	/// English String: "You can wear up to 3 hats"
	/// </summary>
	public override string MessageHatLimitTooltip => "Puedes ponerte hasta tres sombreros.";

	/// <summary>
	/// Key: "Message.InvalidOutfitName"
	/// English String: "Name must be appropriate and less than 200 characters."
	/// </summary>
	public override string MessageInvalidOutfitName => "El nombre debe ser adecuado y tener menos de 200 caracteres.";

	/// <summary>
	/// Key: "Message.Loading"
	/// The user's avatar is loading
	/// English String: "Loading..."
	/// </summary>
	public override string MessageLoading => "Cargando...";

	/// <summary>
	/// Key: "Message.PageUnavailable"
	/// English String: "The avatar page is temporarily unavailable."
	/// </summary>
	public override string MessagePageUnavailable => "La página de Avatar no está disponible temporalmente.";

	/// <summary>
	/// Key: "Message.PresetCostumesDelay"
	/// One-time message that appears to the user first time they visit the Preset Costumes tab. The delay is caused by initial migration.
	/// English String: "Note: We're doing some housekeeping, so it may take a few minutes for all your costumes to appear. Check again in a bit!"
	/// </summary>
	public override string MessagePresetCostumesDelay => "Nota: estamos haciendo trabajos de mantenimiento, por lo que los disfraces pueden tomar algunos minutos en cargarse. ¡Vuelve en un rato!";

	/// <summary>
	/// Key: "Message.ReachedMaxCostumes"
	/// English String: "You have reached the maximum number of costumes."
	/// </summary>
	public override string MessageReachedMaxCostumes => "Has llegado a la cantidad máxima de disfraces.";

	/// <summary>
	/// Key: "Message.ReachedMaxOutfits"
	/// English String: "You have reached the maximum number of outfits."
	/// </summary>
	public override string MessageReachedMaxOutfits => "Has llegado a la cantidad máxima de conjuntos.";

	/// <summary>
	/// Key: "Message.RedirectAvatarSettings"
	/// English String: "You can set Avatar Settings from your Roblox Studio project. In Roblox Studio, go to Home &gt; Game Settings &gt; Avatar"
	/// </summary>
	public override string MessageRedirectAvatarSettings => "Puedes acceder a la Configuración del avatar desde tu proyecto de Roblox Studio. En Roblox Studio, ve a Inicio > Configuración del juego > Avatar";

	/// <summary>
	/// Key: "Message.RedrawFloodchecked"
	/// English String: "You have redrawn your avatar too many times, please try again later."
	/// </summary>
	public override string MessageRedrawFloodchecked => "Has redibujado tu avatar demasiadas veces. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.RedrawThumbnailFailed"
	/// English String: "Failed to redraw thumbnail."
	/// </summary>
	public override string MessageRedrawThumbnailFailed => "Error al redibujar la miniatura";

	/// <summary>
	/// Key: "Message.SelectEnableScaling"
	/// R15 is a proper noun
	/// English String: "Select R15 to enable scaling."
	/// </summary>
	public override string MessageSelectEnableScaling => "Selecciona R15 para activar el escalado.";

	/// <summary>
	/// Key: "Message.Success"
	/// English String: "Success"
	/// </summary>
	public override string MessageSuccess => "Hecho";

	/// <summary>
	/// Key: "Message.SuccessCreateCostume"
	/// English String: "Created costume"
	/// </summary>
	public override string MessageSuccessCreateCostume => "Disfraz creado";

	/// <summary>
	/// Key: "Message.SuccessCreateOutfit"
	/// English String: "Created outfit"
	/// </summary>
	public override string MessageSuccessCreateOutfit => "Conjunto creado";

	/// <summary>
	/// Key: "Message.SuccessDeleteCostume"
	/// Deleted costume
	/// English String: "Deleted costume"
	/// </summary>
	public override string MessageSuccessDeleteCostume => "Disfraz eliminado";

	/// <summary>
	/// Key: "Message.SuccessDeleteOutfit"
	/// English String: "Deleted outfit"
	/// </summary>
	public override string MessageSuccessDeleteOutfit => "Conjunto eliminado";

	/// <summary>
	/// Key: "Message.SuccessEquipEmote"
	/// English String: "Equipped Emote"
	/// </summary>
	public override string MessageSuccessEquipEmote => "Emoticono equipado";

	/// <summary>
	/// Key: "Message.SuccessRenameCostume"
	/// English String: "Renamed costume"
	/// </summary>
	public override string MessageSuccessRenameCostume => "Disfraz renombrado";

	/// <summary>
	/// Key: "Message.SuccessRenameOutfit"
	/// English String: "Renamed outfit"
	/// </summary>
	public override string MessageSuccessRenameOutfit => "Conjunto renombrado";

	/// <summary>
	/// Key: "Message.SuccessSavedAccessories"
	/// English String: "Saved accessories"
	/// </summary>
	public override string MessageSuccessSavedAccessories => "Accesorios guardados";

	/// <summary>
	/// Key: "Message.SuccessUnequipEmote"
	/// English String: "Unequipped emote"
	/// </summary>
	public override string MessageSuccessUnequipEmote => "Emoticono desequipado";

	/// <summary>
	/// Key: "Message.SuccessUpdatedCostume"
	/// English String: "Updated costume"
	/// </summary>
	public override string MessageSuccessUpdatedCostume => "Disfraz actualizado";

	/// <summary>
	/// Key: "Message.SuccessUpdatedOutfit"
	/// English String: "Updated outfit"
	/// </summary>
	public override string MessageSuccessUpdatedOutfit => "Conjunto actualizado";

	/// <summary>
	/// Key: "Message.SuccessWoreCostume"
	/// English String: "Successfully wore costume"
	/// </summary>
	public override string MessageSuccessWoreCostume => "Se ha vestido el disfraz correctamente.";

	/// <summary>
	/// Key: "Message.SuccessWoreOutfit"
	/// English String: "Successfully wore outfit"
	/// </summary>
	public override string MessageSuccessWoreOutfit => "Se ha vestido el conjunto correctamente.";

	/// <summary>
	/// Key: "Message.UpdateThisCostume"
	/// NOTE: Any instance of the word "outfit" will eventually be swapped out for "costume" This is not currently in the UI
	/// English String: "Do you want to update this costume? This will overwrite the costume with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisCostume => "¿Quieres actualizar este disfraz? Esta acción sobrescribirá el disfraz con el aspecto actual de tu avatar.";

	/// <summary>
	/// Key: "Message.UpdateThisOutfit"
	/// English String: "Do you want to update this outfit? This will overwrite the outfit with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateThisOutfit => "¿Quieres actualizar este conjunto? Esta acción sobrescribirá el conjunto con el aspecto actual de tu avatar.";

	/// <summary>
	/// Key: "Message.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string MessageWarning => "Advertencia";

	public AvatarResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionAdvanced()
	{
		return "Avanzado";
	}

	protected override string _GetTemplateForActionBuy()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionClose()
	{
		return "Cerrar";
	}

	protected override string _GetTemplateForActionCreate()
	{
		return "Crear";
	}

	protected override string _GetTemplateForActionCreateNewOutfit()
	{
		return "Crear";
	}

	protected override string _GetTemplateForActionDelete()
	{
		return "Eliminar";
	}

	protected override string _GetTemplateForActionDone()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForActionGet()
	{
		return "Obtener";
	}

	protected override string _GetTemplateForActionGetMore()
	{
		return "Obtener más";
	}

	protected override string _GetTemplateForActionOpenRobloxApp()
	{
		return "Abrir aplicación de Roblox";
	}

	protected override string _GetTemplateForActionRedraw()
	{
		return "Redibujar";
	}

	protected override string _GetTemplateForActionRename()
	{
		return "Renombrar";
	}

	protected override string _GetTemplateForActionRenameOutfit()
	{
		return "Renombrar";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Guardar";
	}

	protected override string _GetTemplateForActionSeeAll()
	{
		return "Ver todo";
	}

	protected override string _GetTemplateForActionThreeDimensions()
	{
		return "3D";
	}

	protected override string _GetTemplateForActionTwoDimensions()
	{
		return "2D";
	}

	protected override string _GetTemplateForActionUpdate()
	{
		return "Actualizar";
	}

	protected override string _GetTemplateForActionUserUnderstands()
	{
		return "Entendido";
	}

	protected override string _GetTemplateForDescriptionAvatarEditorUpsell()
	{
		return "Para cambiar tu aspecto, tendrás que utilizar el Editor de avatares en la aplicación.";
	}

	protected override string _GetTemplateForDescriptionCreateNewCostume()
	{
		return "El disfraz se creará según el aspecto actual de tu avatar.";
	}

	protected override string _GetTemplateForDescriptionCreateNewOutfit()
	{
		return "El conjunto se creará a partir del aspecto actual de tu avatar.";
	}

	protected override string _GetTemplateForDescriptionRenameCostume()
	{
		return "Elige un nuevo nombre para tu disfraz.";
	}

	protected override string _GetTemplateForDescriptionRenameOutfit()
	{
		return "Elige un nuevo nombre para tu conjunto.";
	}

	protected override string _GetTemplateForHeadingAccessories()
	{
		return "Accesorios";
	}

	protected override string _GetTemplateForHeadingAccessoriesChange()
	{
		return "Cambio de accesorios";
	}

	protected override string _GetTemplateForHeadingAdvancedOptions()
	{
		return "Opciones avanzadas";
	}

	protected override string _GetTemplateForHeadingAll()
	{
		return "Todos";
	}

	protected override string _GetTemplateForHeadingAnimations()
	{
		return "Animaciones";
	}

	protected override string _GetTemplateForHeadingAppearance()
	{
		return "Aspecto";
	}

	protected override string _GetTemplateForHeadingAvatarPageTitle()
	{
		return "Editor de avatares";
	}

	protected override string _GetTemplateForHeadingBody()
	{
		return "Cuerpo";
	}

	protected override string _GetTemplateForHeadingBodyParts()
	{
		return "Partes del cuerpo";
	}

	protected override string _GetTemplateForHeadingClothing()
	{
		return "Ropa";
	}

	protected override string _GetTemplateForHeadingCostumes()
	{
		return "Disfraces";
	}

	protected override string _GetTemplateForHeadingCreateNewCostume()
	{
		return "Crear nuevo disfraz";
	}

	protected override string _GetTemplateForHeadingCreateNewOutfit()
	{
		return "Crear nuevo conjunto";
	}

	protected override string _GetTemplateForHeadingDelete()
	{
		return "Eliminar";
	}

	protected override string _GetTemplateForHeadingDeleteCostume()
	{
		return "Eliminar el disfraz";
	}

	protected override string _GetTemplateForHeadingDeleteOutfit()
	{
		return "Eliminar el conjunto";
	}

	protected override string _GetTemplateForHeadingEmotes()
	{
		return "Emoticonos";
	}

	protected override string _GetTemplateForHeadingEquipEmotes()
	{
		return "Equipar emoticonos";
	}

	protected override string _GetTemplateForHeadingOutfits()
	{
		return "Conjuntos";
	}

	protected override string _GetTemplateForHeadingPackages()
	{
		return "Paquetes";
	}

	protected override string _GetTemplateForHeadingRecent()
	{
		return "Recientes";
	}

	protected override string _GetTemplateForHeadingRecommended()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForHeadingRenameCostume()
	{
		return "Cambiar el nombre del disfraz";
	}

	protected override string _GetTemplateForHeadingRenameOutfit()
	{
		return "Cambiar el nombre del conjunto";
	}

	protected override string _GetTemplateForHeadingScaling()
	{
		return "Escalado";
	}

	protected override string _GetTemplateForHeadingSkinToneBodyParts()
	{
		return "Tono de piel por partes del cuerpo";
	}

	protected override string _GetTemplateForHeadingUpdate()
	{
		return "Actualizar";
	}

	protected override string _GetTemplateForHeadingUpdateCostume()
	{
		return "Actualizar el disfraz";
	}

	protected override string _GetTemplateForHeadingUpdateOutfit()
	{
		return "Actualizar el conjunto";
	}

	protected override string _GetTemplateForLabelAll()
	{
		return "Todas";
	}

	protected override string _GetTemplateForLabelAskIfLoadingCorrectly()
	{
		return "¿El avatar no se carga correctamente?";
	}

	protected override string _GetTemplateForLabelAssetIDPlaceholder()
	{
		return "ID del recurso";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "Traseros";
	}

	protected override string _GetTemplateForLabelBackAccessories()
	{
		return "Accesorios traseros";
	}

	protected override string _GetTemplateForLabelBodyType()
	{
		return "Tipo de cuerpo";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "Escalada";
	}

	protected override string _GetTemplateForLabelClimbAnimations()
	{
		return "Animaciones de escalada";
	}

	protected override string _GetTemplateForLabelClothes()
	{
		return "Ropa";
	}

	protected override string _GetTemplateForLabelCostume()
	{
		return "Disfraz";
	}

	/// <summary>
	/// Key: "Label.DirectionsForPackagePlacement"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Packages have been moved to Costumes. Check {startBold}Costumes{rightArrow}Preset Costumes{endBold}"
	/// </summary>
	public override string LabelDirectionsForPackagePlacement(string startBold, string rightArrow, string endBold)
	{
		return $"Los paquetes se han trasladado a Disfraces. Echa un vistazo a {startBold}Disfraces{rightArrow}Disfraces predeterminados{endBold}";
	}

	protected override string _GetTemplateForLabelDirectionsForPackagePlacement()
	{
		return "Los paquetes se han trasladado a Disfraces. Echa un vistazo a {startBold}Disfraces{rightArrow}Disfraces predeterminados{endBold}";
	}

	/// <summary>
	/// Key: "Label.DirectionsForScalingOptions"
	/// The arrow in this text has spacing built-in, so there's no space in the text here. These instructions tell the user where to click on the menu.
	/// English String: "Scaling options are available under Body category. Check {startBold}Body{rightArrow}Scale{endBold}"
	/// </summary>
	public override string LabelDirectionsForScalingOptions(string startBold, string rightArrow, string endBold)
	{
		return $"Las opciones de escalado están disponibles en la categoría Cuerpo. Echa un vistazo a {startBold}Cuerpo{rightArrow}Escalado{endBold}";
	}

	protected override string _GetTemplateForLabelDirectionsForScalingOptions()
	{
		return "Las opciones de escalado están disponibles en la categoría Cuerpo. Echa un vistazo a {startBold}Cuerpo{rightArrow}Escalado{endBold}";
	}

	protected override string _GetTemplateForlabelEmotes()
	{
		return "Emoticonos";
	}

	protected override string _GetTemplateForLabelEquip()
	{
		return "Equipar";
	}

	protected override string _GetTemplateForLabelExploreCatalog()
	{
		return "¡Explora el catálogo para encontrar más ropa!";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "Cara";
	}

	protected override string _GetTemplateForLabelFaceAccessories()
	{
		return "Accesorios para la cara";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Caras";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "Caída";
	}

	protected override string _GetTemplateForLabelFallAnimations()
	{
		return "Animaciones de caída";
	}

	protected override string _GetTemplateForLabelFree()
	{
		return "Gratis";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "Frontales";
	}

	protected override string _GetTemplateForLabelFrontAccessories()
	{
		return "Accesorios frontales";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Equipamiento";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "Pelo";
	}

	protected override string _GetTemplateForLabelHairAccessories()
	{
		return "Accesorios para el pelo";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "Sombrero";
	}

	protected override string _GetTemplateForLabelHatAccessories()
	{
		return "Accesorios para el sombrero";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "Cabeza";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Cabezas";
	}

	protected override string _GetTemplateForLabelHeight()
	{
		return "Altura";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "Inactividad";
	}

	protected override string _GetTemplateForLabelIdleAnimations()
	{
		return "Animaciones de inactividad";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "Salto";
	}

	protected override string _GetTemplateForLabelJumpAnimations()
	{
		return "Animaciones de salto";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "Brazo izquierdo";
	}

	protected override string _GetTemplateForLabelLeftArms()
	{
		return "Brazos izquierdos";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "Pierna izquierda";
	}

	protected override string _GetTemplateForLabelLeftLegs()
	{
		return "Piernas izquierdas";
	}

	protected override string _GetTemplateForLabelMyCostumes()
	{
		return "Mis disfraces";
	}

	protected override string _GetTemplateForLabelNamePlaceholderCostume()
	{
		return "Ponle un nombre a tu disfraz";
	}

	protected override string _GetTemplateForLabelNamePlaceholderOutfit()
	{
		return "Ponle un nombre a tu conjunto";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "Cuello";
	}

	protected override string _GetTemplateForLabelNeckAccessories()
	{
		return "Accesorios para el cuello";
	}

	protected override string _GetTemplateForLabelNoResellers()
	{
		return "Sin reventa";
	}

	protected override string _GetTemplateForLabelOffSale()
	{
		return "Fuera de venta";
	}

	protected override string _GetTemplateForLabelOutfit()
	{
		return "Conjunto";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Pantalones";
	}

	protected override string _GetTemplateForLabelParts()
	{
		return "Partes del cuerpo";
	}

	protected override string _GetTemplateForLabelPresetCostumes()
	{
		return "Disfraces predeterminados";
	}

	protected override string _GetTemplateForLabelProportions()
	{
		return "Proporciones";
	}

	protected override string _GetTemplateForLabelRedrawUnavailable()
	{
		return "El redibujo del avatar no está disponible.";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "Brazo derecho";
	}

	protected override string _GetTemplateForLabelRightArms()
	{
		return "Brazos derechos";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "Pierna derecha";
	}

	protected override string _GetTemplateForLabelRightLegs()
	{
		return "Piernas derechas";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "Carrera";
	}

	protected override string _GetTemplateForLabelRunAnimations()
	{
		return "Animaciones de carrera";
	}

	protected override string _GetTemplateForLabelScale()
	{
		return "Escalado";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Camisas";
	}

	protected override string _GetTemplateForLabelShoulderAccessories()
	{
		return "Accesorios para el hombro";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "Hombros";
	}

	protected override string _GetTemplateForLabelSkinTone()
	{
		return "Tono de piel";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "Nado";
	}

	protected override string _GetTemplateForLabelSwimAnimations()
	{
		return "Animaciones de nado";
	}

	protected override string _GetTemplateForLabelSwitchAvatarType()
	{
		return "Cambia entre la versión clásica de avatar R6 y la nueva generación R15 más expresiva.";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "Torso";
	}

	protected override string _GetTemplateForLabelTorsos()
	{
		return "Torsos";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Camisetas";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "Cintura";
	}

	protected override string _GetTemplateForLabelWaistAccessories()
	{
		return "Accesorios para la cintura";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "Marcha";
	}

	protected override string _GetTemplateForLabelWalkAnimations()
	{
		return "Animaciones de marcha";
	}

	protected override string _GetTemplateForLabelWidth()
	{
		return "Anchura";
	}

	protected override string _GetTemplateForLabelYourEmotes()
	{
		return "Tus emoticonos";
	}

	protected override string _GetTemplateForMessageAccessoriesChange()
	{
		return "¿Seguro que quieres reemplazar tu aspecto actual?";
	}

	protected override string _GetTemplateForMessageChooseEmote()
	{
		return "Elige un emoticono";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlot()
	{
		return "Elige un espacio";
	}

	protected override string _GetTemplateForMessageChooseEmoteSlotOrEmote()
	{
		return "Elige un espacio o un emoticono";
	}

	protected override string _GetTemplateForMessageDefaultClothing()
	{
		return "Se ha equipado tu avatar con ropa predeterminada. Viste algo de tu guardarropa.";
	}

	/// <summary>
	/// Key: "Message.DeleteOutfit"
	/// English String: "Are you sure you want to delete this {outfitType}?"
	/// </summary>
	public override string MessageDeleteOutfit(string outfitType)
	{
		return $"¿Seguro que quieres eliminar este {outfitType}?";
	}

	protected override string _GetTemplateForMessageDeleteOutfit()
	{
		return "¿Seguro que quieres eliminar este {outfitType}?";
	}

	protected override string _GetTemplateForMessageDeleteThisCostume()
	{
		return "¿Seguro que quieres eliminar este disfraz?";
	}

	protected override string _GetTemplateForMessageDeleteThisOutfit()
	{
		return "¿Seguro que quieres eliminar este conjunto?";
	}

	protected override string _GetTemplateForMessageEmotesInstructions()
	{
		return "Ve a Animaciones > Emoticonos > Equipar emoticonos";
	}

	protected override string _GetTemplateForMessageEmptyAssetList()
	{
		return "No tienes ninguno.";
	}

	/// <summary>
	/// Key: "Message.EmptyListForItem"
	/// The user tries to load a list of some item but they see nothing because they don't own anything of that type.
	/// English String: "You don't have this item: {itemType}"
	/// </summary>
	public override string MessageEmptyListForItem(string itemType)
	{
		return $"No tienes este objeto: {itemType}";
	}

	protected override string _GetTemplateForMessageEmptyListForItem()
	{
		return "No tienes este objeto: {itemType}";
	}

	protected override string _GetTemplateForMessageEmptyListOfCostumes()
	{
		return "No tienes disfraces. ¡Crea algunos!";
	}

	protected override string _GetTemplateForMessageEmptyListOfOutfits()
	{
		return "No tienes conjuntos. ¡Crea algunos!";
	}

	protected override string _GetTemplateForMessageEmptyRecentItems()
	{
		return "No tienes ningún objeto reciente.";
	}

	protected override string _GetTemplateForMessageErrorCreateCostume()
	{
		return "No se ha podido crear el disfraz. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorCreateOutfit()
	{
		return "No se ha podido crear el conjunto. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorDeleteEmote()
	{
		return "Error al eliminar el emoticono.";
	}

	protected override string _GetTemplateForMessageErrorEquipEmote()
	{
		return "Error al equipar el emoticono. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorLoadCostume()
	{
		return "Error al cargar el disfraz";
	}

	protected override string _GetTemplateForMessageErrorLoadEmotes()
	{
		return "Error al cargar los emoticonos.";
	}

	protected override string _GetTemplateForMessageErrorLoadOutfits()
	{
		return "Error al cargar los conjuntos";
	}

	protected override string _GetTemplateForMessageErrorOutfitName()
	{
		return "El nombre puede contener letras, números y espacios.";
	}

	protected override string _GetTemplateForMessageErrorRenameCostume()
	{
		return "Error al cambiar el nombre del disfraz";
	}

	protected override string _GetTemplateForMessageErrorRenameOutfit()
	{
		return "Error al cambiar el nombre del conjunto";
	}

	protected override string _GetTemplateForMessageErrorUnequipEmote()
	{
		return "Error al desequipar el emoticono.";
	}

	protected override string _GetTemplateForMessageErrorUpdateCostume()
	{
		return "No se ha podido actualizar el disfraz. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorUpdateEmote()
	{
		return "Error al actualizar el espacio del emoticono. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorUpdateOutfit()
	{
		return "No se ha podido actualizar el conjunto. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorUpdateWorn()
	{
		return "Error al actualizar los objetos puestos";
	}

	protected override string _GetTemplateForMessageErrorWearCostume()
	{
		return "Error al vestir el disfraz";
	}

	protected override string _GetTemplateForMessageErrorWearOutfit()
	{
		return "Error al vestir el conjunto";
	}

	protected override string _GetTemplateForMessageFailedDeleteCostume()
	{
		return "Error al eliminar el disfraz";
	}

	protected override string _GetTemplateForMessageFailedDeleteEmote()
	{
		return "Error al eliminar el emoticono.";
	}

	protected override string _GetTemplateForMessageFailedDeleteOutfit()
	{
		return "Error al eliminar el conjunto";
	}

	protected override string _GetTemplateForMessageFailedLoadAssets()
	{
		return "Error al cargar la lista de recursos";
	}

	protected override string _GetTemplateForMessageFailedLoadRecent()
	{
		return "Error al cargar objetos recientes";
	}

	protected override string _GetTemplateForMessageFailedUpdateBodyColor()
	{
		return "Error al actualizar el tono de piel";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedCostume()
	{
		return "El disfraz que querías actualizar ya no existe.";
	}

	protected override string _GetTemplateForMessageFailedUpdateDeletedOutfit()
	{
		return "El conjunto que querías actualizar ya no existe.";
	}

	protected override string _GetTemplateForMessageFailedUpdateScales()
	{
		return "Error al actualizar las dimensiones";
	}

	protected override string _GetTemplateForMessageFailedUpdateType()
	{
		return "Error al actualizar el tipo de avatar";
	}

	protected override string _GetTemplateForMessageFailedWearPackage()
	{
		return "Error al vestir el paquete";
	}

	protected override string _GetTemplateForMessageHatLimitTooltip()
	{
		return "Puedes ponerte hasta tres sombreros.";
	}

	protected override string _GetTemplateForMessageInvalidOutfitName()
	{
		return "El nombre debe ser adecuado y tener menos de 200 caracteres.";
	}

	protected override string _GetTemplateForMessageLoading()
	{
		return "Cargando...";
	}

	/// <summary>
	/// Key: "Message.MissingItemsFromOutfit"
	/// User cannot wear an outfit because they are missing or have deleted some of the items that were part of that outfit.
	/// English String: "Number of items that you don't own in this outfit: {number}"
	/// </summary>
	public override string MessageMissingItemsFromOutfit(string number)
	{
		return $"Número de objetos que te faltan para completar este conjunto: {number}";
	}

	protected override string _GetTemplateForMessageMissingItemsFromOutfit()
	{
		return "Número de objetos que te faltan para completar este conjunto: {number}";
	}

	protected override string _GetTemplateForMessagePageUnavailable()
	{
		return "La página de Avatar no está disponible temporalmente.";
	}

	protected override string _GetTemplateForMessagePresetCostumesDelay()
	{
		return "Nota: estamos haciendo trabajos de mantenimiento, por lo que los disfraces pueden tomar algunos minutos en cargarse. ¡Vuelve en un rato!";
	}

	protected override string _GetTemplateForMessageReachedMaxCostumes()
	{
		return "Has llegado a la cantidad máxima de disfraces.";
	}

	protected override string _GetTemplateForMessageReachedMaxOutfits()
	{
		return "Has llegado a la cantidad máxima de conjuntos.";
	}

	protected override string _GetTemplateForMessageRedirectAvatarSettings()
	{
		return "Puedes acceder a la Configuración del avatar desde tu proyecto de Roblox Studio. En Roblox Studio, ve a Inicio > Configuración del juego > Avatar";
	}

	protected override string _GetTemplateForMessageRedrawFloodchecked()
	{
		return "Has redibujado tu avatar demasiadas veces. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageRedrawThumbnailFailed()
	{
		return "Error al redibujar la miniatura";
	}

	protected override string _GetTemplateForMessageSelectEnableScaling()
	{
		return "Selecciona R15 para activar el escalado.";
	}

	protected override string _GetTemplateForMessageSuccess()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForMessageSuccessCreateCostume()
	{
		return "Disfraz creado";
	}

	protected override string _GetTemplateForMessageSuccessCreateOutfit()
	{
		return "Conjunto creado";
	}

	protected override string _GetTemplateForMessageSuccessDeleteCostume()
	{
		return "Disfraz eliminado";
	}

	protected override string _GetTemplateForMessageSuccessDeleteOutfit()
	{
		return "Conjunto eliminado";
	}

	protected override string _GetTemplateForMessageSuccessEquipEmote()
	{
		return "Emoticono equipado";
	}

	protected override string _GetTemplateForMessageSuccessRenameCostume()
	{
		return "Disfraz renombrado";
	}

	protected override string _GetTemplateForMessageSuccessRenameOutfit()
	{
		return "Conjunto renombrado";
	}

	protected override string _GetTemplateForMessageSuccessSavedAccessories()
	{
		return "Accesorios guardados";
	}

	protected override string _GetTemplateForMessageSuccessUnequipEmote()
	{
		return "Emoticono desequipado";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedCostume()
	{
		return "Disfraz actualizado";
	}

	protected override string _GetTemplateForMessageSuccessUpdatedOutfit()
	{
		return "Conjunto actualizado";
	}

	protected override string _GetTemplateForMessageSuccessWoreCostume()
	{
		return "Se ha vestido el disfraz correctamente.";
	}

	protected override string _GetTemplateForMessageSuccessWoreOutfit()
	{
		return "Se ha vestido el conjunto correctamente.";
	}

	/// <summary>
	/// Key: "Message.UpdateOutfit"
	/// English String: "Do you want to update this {outfitType1}? This will overwrite the {outfitType2} with your avatar's current appearance."
	/// </summary>
	public override string MessageUpdateOutfit(string outfitType1, string outfitType2)
	{
		return $"¿Quieres actualizar este {outfitType1}? Esta acción sobrescribirá el {outfitType2} con el aspecto actual de tu avatar.";
	}

	protected override string _GetTemplateForMessageUpdateOutfit()
	{
		return "¿Quieres actualizar este {outfitType1}? Esta acción sobrescribirá el {outfitType2} con el aspecto actual de tu avatar.";
	}

	protected override string _GetTemplateForMessageUpdateThisCostume()
	{
		return "¿Quieres actualizar este disfraz? Esta acción sobrescribirá el disfraz con el aspecto actual de tu avatar.";
	}

	protected override string _GetTemplateForMessageUpdateThisOutfit()
	{
		return "¿Quieres actualizar este conjunto? Esta acción sobrescribirá el conjunto con el aspecto actual de tu avatar.";
	}

	protected override string _GetTemplateForMessageWarning()
	{
		return "Advertencia";
	}
}
