namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_zh_tw : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "載入更多";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "取消續訂";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "新增電子郵件地址";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "新增手機號碼";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "取消";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "變更電子郵件地址";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "確定";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "更新";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "確定";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "購買";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "關閉";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "編輯手機號碼";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "移除手機號碼";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "購買";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "否";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "新增";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "確定";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "解鎖";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "移除";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "取消";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "傳送";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "確定";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "更新";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "確定";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "驗證電子郵件地址";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "重試";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "驗證";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "重新傳送驗證碼";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "取消";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "是";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "隱藏";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "加入";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "加入 Builders Club";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "儲存";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "顯示";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "登出";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "中斷連線";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "確定";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "解除封鎖";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "升級會員資格";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "您可以設定帳號限制，限制使用帳號設定及未篩選的內容";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "重置 Roblox 電子郵件地址";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Roblox 未開啟時仍可收到電腦通知。";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "若要看見通知，請在您的瀏覽器允許通知。";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "此裝置的桌面通知。";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "請確認您的國碼，並輸入您的手機號碼。我們會傳送一則簡訊完成驗證程序。（注意：可能會收取簡訊費用）";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "已傳送驗證電子郵件";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "新的電子郵件地址驗證後才會生效。";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "您已成功變更密碼。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "重要：帳號建立日期將會轉移到新的使用者名稱。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "免費變更使用者名稱一次。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "之前的論壇發文會顯示在您過去的使用者名稱之下，不會轉到您新的使用者名稱。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "變更使用者名稱";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "新的手機號碼驗證完畢後，手機號碼才會變更。";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "若要變更使用者名稱，請先提供並驗證您的電子郵件地址。";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "謝謝，已傳送驗證電子郵件。";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "若要變更使用者名稱，請先驗證電子郵件地址。";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "在您解除 Facebook 帳號連接之前，請新增密碼保護您的帳號。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "若要新增帳號 PIN，請先提供並驗證您的電子郵件地址。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "若要啟用兩步驟驗證，請先提供並驗證您的電子郵件地址。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "若要變更使用者名稱，請先提供並驗證您的電子郵件地址。";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "輸入您的帳號的 PIN";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "若要新增帳號 PIN，請先驗證您的電子郵件地址。";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "若要啟用雙步驟驗證，請先驗證電子郵件地址。";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "若要變更使用者名稱，請先驗證電子郵件地址。";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "由於您持續提交良好的檢舉報告，您已被加到快速通道企劃。您的檢舉報告將會更快受到審核。繼續提交良好的檢舉報告，即可留在快速通道計畫。感謝您協助維護 Roblox 的環境！";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "數據";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "請勿提供任何可以在 Roblox 以外用來識別您的身分的詳細資料。";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "準確度為管理員同意檢舉報告的頻率，在您提交一定數量檢舉報告後將會開始顯示。「所有人」指所有快速通道成員合在一起。";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "更新年齡為 13 歲以下會啟用隱私模式。";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "變更密碼";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "變更使用者名稱";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "更新電子郵件地址";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "帳務和付款問題：info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "您還不是會員，現在加入 Builders Club！";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "您還不是會員，現在加入 Roblox Premium！";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "在裝置首頁看見通知；您可以從 Roblox App 開啟或關閉。";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "此裝置的行動裝置推播通知。";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "在我的動態消息中看見通知。按下頂端列的通知圖示檢視這些通知。";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "您關閉一種通知類型之後，我們將不會傳送該類型的新通知給您。";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "注意：若您想取消續訂會員資格，請從網站登入。";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "已成功儲存！";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "需要已驗證的電子郵件地址";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Roblox 使用者名稱變更";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Roblox 電子郵件地址驗證";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Roblox 帳號許可";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "自我介紹（最多 1000 個字元）";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "例如 www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "例如 http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "例如 www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "例如 @Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "例如 www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "什麼是帳號控制？";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "帳號資訊";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "帳務";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "封鎖的使用者";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "聯絡設定";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "桌面推播";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "新增密碼";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "新增手機號碼";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "變更我的電子郵件地址";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "電子郵件地址已變更";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "變更密碼";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "變更使用者名稱";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "錯誤";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "編輯手機號碼";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "資金不足";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "使用者名稱無效";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "新增 PIN";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "需要帳號 PIN";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "移除手機號碼";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "需要已驗證的電子郵件地址";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "驗證電子郵件地址";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "驗證手機號碼";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "快速通道";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "會員資格狀態";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "有以下情形時通知我";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "通知";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "有以下情形時通知我";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "桌面推播";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "行動裝置推播";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "動態消息";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "動態消息";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "其它設定";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "我的設定";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "個人資訊";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "帳號 PIN";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "隱私權設定";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "續訂日期";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "帳號限制";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "安全登出";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "社交網路";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "社交登入";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "成功";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "帳號資訊";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "帳務";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "快速通道";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "通知";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "隱私權";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "安全";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "交易";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "雙步驟驗證";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "帳號 PIN 目前停用";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "帳號 PIN 目前啟用";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "帳號限制目前停用";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "帳號限制目前啟用";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "新增電子郵件地址";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "新增家長的電子郵件地址";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "新增密碼：";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "新增手機號碼";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "新增手機號碼";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "帳務和付款問題：";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "費用";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "日期";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "說明";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "此服務目前停用，請稍後再試。";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "無交易";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "付款方式";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "生日";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "變更您的使用者名稱";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "選擇語言";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "關閉";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "連接帳號：";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "選擇國家或地區";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "位置";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "黑暗";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "新增我的電子郵件地址";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "新增家長的電子郵件地址";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "手機號碼";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "輸入此帳號的密碼";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "輸入新的電子郵件地址";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "輸入新的電子郵件地址";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "變更家長的電子郵件地址";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "確認密碼";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "目前密碼";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "新密碼";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "帳號密碼";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "欲使用的使用者名稱 （3 到 20 個字元）";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "確認您的 PIN";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "目前號碼：";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "電子郵件地址已變更";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "需要電子郵件地址";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "已驗證的電子郵件地址：";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "輸入此帳號的密碼";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "請輸入傳送到您的手機的驗證碼";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "驗證簡訊";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "自訂";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "預設";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "所有人";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "好友、我追蹤的使用者及追蹤者";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "好友及我追蹤的使用者";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "好友";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "高";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "低";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "中";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "無";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "沒有人";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "關閉";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "電子郵件地址：";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "家長的電子郵件地址：";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "待驗證";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "有效期限";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook：";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "準確度";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "所有人";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "月";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "年";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "數據";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "您";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "性別";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+：";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "燈光";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "語言";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "您還不是會員，現在加入 Roblox Premium！";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "有人邀請我加入 VIP 伺服器";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "有人與我聊天";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "有人置頂新遊戲一起玩";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "有新的分析報告";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "有人接受我的好友邀請";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "我收到一則好友邀請";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "我收到遊戲更新通知";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "有人邀請我加入隊伍";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "有人加入我目前的隊伍";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "我收到私人訊息";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "有人邀請我編輯遊戲";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "密碼：";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "手機號碼：";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "分";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "剩餘時間";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "秒";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "之前的使用者名稱：";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "隱私模式";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "續訂日期";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "登出其它在線作業";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "開放顯示對象：";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "主題";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "自訂：控制您自己的設定。預設 ：啟用好友聊天與訊息。關閉：停用聊天與訊息。";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "所有設定已鎖定。若要編輯，請輸入 PIN 解鎖";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "按下鎖定您的設定頁面";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "按下此處取得更多資訊";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "此設定控制此使用者可以在 App 及網頁中的聊天對象（但無法控制遊戲中的聊天對象）。此設定也禁止此使用者在論壇和群組留言板上貼文。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "此設定控制此使用者可以在遊戲中聊天的對象。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "此設定控制誰可以使用您提供的手機號碼找到您。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "此設定控制誰可以在 VIP 伺服器中加入這位使用者；VIP 伺服器是只可以透過伺服器主人邀請加入的伺服器。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "此設定控制誰可以看到我在玩的遊戲，並加入我的伺服器。若選擇「沒有人」，將不會有人跟隨我加入我的伺服器，但我仍會和其他使用者玩遊戲。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "此設定控制此使用者可以從哪些使用者收到訊息。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "此設定控制誰可以看到您的道具欄。";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "交易品質篩選器";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch：";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter：";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "啟用雙步驟驗證";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "需要已驗證的電子郵件地址。";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "進一步保護您的帳號。當您從新裝置登入時，您將需要輸入驗證碼。";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "您的帳號已受保護！";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "更新電子郵件地址";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "更新手機號碼";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "使用裝置語言";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "使用者名稱：";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "已驗證";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "驗證";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "誰可以在 App 與我聊天？";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "誰可以與我聊天？";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "誰可以透過我的手機號碼找到我？";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "誰可以邀請我到 VIP 伺服器？";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "誰可以加入我？";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "誰可以傳送訊息給我？";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "誰可以看到我的道具欄？";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "誰可以與我交易？";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "已連接 Xbox 帳號";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube：";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Robux 不足";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "此帳號已設置 PIN，請嘗試其他請求。";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "此帳號遭到封鎖，請在執行此動作前解鎖此帳號。";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "此電子郵件地址已驗證。";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "此功能目前停用，請稍後再試。";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "密碼不正確。";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "電子郵件地址無效。";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "此帳號沒有加入電子郵件地址。";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "PIN 已鎖定。";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "這已是目前的電子郵件地址。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "加入此電子郵件地址的帳號過多。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "更新電子郵件地址次數過多，請稍後再試。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "傳送驗證電子郵件次數過多，請稍後再試。";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "發生未知錯誤。";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "PIN 碼錯誤。";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "PIN 格式無效。";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "帳號沒有 PIN。";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "此帳號沒有已驗證的電子郵件地址。";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "系統錯誤。";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "請求次數過多，請稍後再試。";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "已新增電子郵件地址";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "您的電子郵件地址已驗證！";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "此功能目前停用，請稍後再試。";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "您的 Robux 不足，無法變更使用者名稱。";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "電子郵件地址無效";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "您必須在此帳號新增電子郵件地址";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "您的 Robux 不足，無法變更使用者名稱。";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "PIN 已鎖定。";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "這已是目前已驗證的電子郵件地址。";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "您的設定已更新。";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "加入此電子郵件地址的帳號過多。";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "嘗試次數過多，請稍後再試。";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "發生未知錯誤。";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "您的密碼不正確。";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "驗證碼無效，請檢查您的手機後重新嘗試。";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "「誰可以與我交易」的值應在「誰可以看到我的道具欄」的值以下。";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "需要驗證碼，請輸入您的驗證碼。";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "若變更生日為 13 歲以下，之後將無法還原。確定？";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "若要變更生日，請先新增 Roblox 帳號密碼。";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "必須新增密碼";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "若變更生日為 13 歲以下，之後將無法還原。您的 Facebook 社交登入將會被停用，之後必須使用 Roblox 密碼登入。";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "您目前的密碼不正確，密碼並未變更。";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "密碼不相符";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "需要 8 個字元以上";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "請輸入使用者名稱。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "此使用者名稱含有不當內容。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "此使用者名稱已被使用。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "已成功變更使用者名稱。";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "載入國家清單時發生錯誤";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "貨幣服務發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "發生錯誤";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "已成功儲存！";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "解除您的 Xbox 帳號連接時發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "已傳送驗證電子郵件。";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "電子郵件地址無效";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "手機號碼無效";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "按下「傳送」提交聯絡單，或按下「取消」編輯使用者名稱。提供正確的使用者名稱可以讓我們更快解決您的問題。";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "密碼需要 8 個字元以上，其中應含有 2 個數字、4 個字母及 1 個符號。";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "您的 PIN 已成功設定。往後進入設定頁面之前，您將需要輸入此 PIN。";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "PIN 不相符";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "登出其它在線作業時發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "您已登出其它在線作業。";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "若您關閉雙步驟驗證，您使用新裝置登入時將只需輸入密碼。確定？";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "雙步驟驗證已啟用";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "您的帳號已受到保護，目前不需進行其他動作。您下一次從新裝置登入時，我們將會送出安全碼。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "我們已更新您的道具欄隱私權設定；道具欄設定必須和交易設定一致。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "更新您的通知設定時發生錯誤，請稍後再試。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "我們已更新您的交易隱私權設定；交易設定必須和道具欄設定一致。";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "驗證碼無效，請檢查您的手機後重新嘗試。";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "警告";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "此功能目前停用，請稍後再試。";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "發生錯誤，請重新嘗試。";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "您輸入錯誤驗證碼的次數過多。";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "密碼不正確，請檢查您的密碼後重新嘗試。";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "手機號碼格式無效，請檢查之後重新嘗試。";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "手機號碼已移除";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "手機號碼已成功更新！";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "已有帳號加入此手機號碼。";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "若要變更您的設定，請先輸入 PIN。";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "此社交網路連結無效。";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "對不起，您不可以將年齡改為 13 歲以下。若您未滿 13 歲，請建立一個新帳號，並聯絡客服人員刪除您的舊帳號。";

	public AccountSettingsResources_zh_tw(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "載入更多";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "取消續訂";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "新增電子郵件地址";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "新增手機號碼";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "變更電子郵件地址";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "更新";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "購買";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "關閉";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "編輯手機號碼";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "移除手機號碼";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "購買";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "否";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "新增";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "解鎖";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "移除";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "傳送";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "更新";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "驗證電子郵件地址";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "重試";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "驗證";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "重新傳送驗證碼";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "是";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "隱藏";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "加入";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "加入 Builders Club";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "儲存";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "顯示";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "登出";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "中斷連線";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "解除封鎖";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "升級會員資格";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "您可以設定帳號限制，限制使用帳號設定及未篩選的內容";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}重置 Roblox 電子郵件地址{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}重置 Roblox 電子郵件地址{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}我們發現您將您的帳號 {username} 的電子郵件地址從 {oldEmailAddress} 變更為 {newEmailAddress}。若您沒有要變更你的電子郵件地址，或者認為有人不小心變更你的電子郵件地址，您可以按下 {lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak} 復原您原本的電子郵件地址。除此之外，您也需要輸入一組新的密碼，確保您的帳號的安全。{lineBreak}{lineBreak}若您有變更電子郵件地址，您的變更已經生效，您不需要採取任何動作。{lineBreak}{lineBreak}請勿回覆此電子郵件。若您有任何問題，請聯絡 {robloxInfoEmailAddress}。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}我們發現您將您的帳號 {username} 的電子郵件地址從 {oldEmailAddress} 變更為 {newEmailAddress}。若您沒有要變更你的電子郵件地址，或者認為有人不小心變更你的電子郵件地址，您可以按下 {lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak} 復原您原本的電子郵件地址。除此之外，您也需要輸入一組新的密碼，確保您的帳號的安全。{lineBreak}{lineBreak}若您有變更電子郵件地址，您的變更已經生效，您不需要採取任何動作。{lineBreak}{lineBreak}請勿回覆此電子郵件。若您有任何問題，請聯絡 {robloxInfoEmailAddress}。";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}我們發現您將您的帳號 {username} 的電子郵件地址從 {oldEmailAddress} 變更為 {newEmailAddress}。若您沒有要變更你的電子郵件地址，或者認為有人不小心變更你的電子郵件地址，您可以按下 {lineBreak}{revertAccountEmailLink}{lineBreak} 復原您原本的電子郵件地址。除此之外，您也需要輸入一組新的密碼，確保您的帳號的安全。{lineBreak}{lineBreak}若您有變更電子郵件地址，您的變更已經生效，您不需要採取任何動作。{lineBreak}請勿回覆此電子郵件。若您有任何問題，請聯絡 {robloxInfoEmailAddress}。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}我們發現您將您的帳號 {username} 的電子郵件地址從 {oldEmailAddress} 變更為 {newEmailAddress}。若您沒有要變更你的電子郵件地址，或者認為有人不小心變更你的電子郵件地址，您可以按下 {lineBreak}{revertAccountEmailLink}{lineBreak} 復原您原本的電子郵件地址。除此之外，您也需要輸入一組新的密碼，確保您的帳號的安全。{lineBreak}{lineBreak}若您有變更電子郵件地址，您的變更已經生效，您不需要採取任何動作。{lineBreak}請勿回覆此電子郵件。若您有任何問題，請聯絡 {robloxInfoEmailAddress}。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "重置 Roblox 電子郵件地址";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"此帳號只能使用 Roblox 上經篩選的內容。另外，聯絡設定（在{linkStart}隱私權{linkEnd}頁面上方）將設為「關閉」。";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "此帳號只能使用 Roblox 上經篩選的內容。另外，聯絡設定（在{linkStart}隱私權{linkEnd}頁面上方）將設為「關閉」。";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"您正在封鎖 {totalBlockedCount} 名使用者（最多 {maxBlockedCount} 名）：";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "您正在封鎖 {totalBlockedCount} 名使用者（最多 {maxBlockedCount} 名）：";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"因帳號限制（在{linkStart}安全性{linkEnd}頁面下）啟用中，聯絡設定已鎖定。";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "因帳號限制（在{linkStart}安全性{linkEnd}頁面下）啟用中，聯絡設定已鎖定。";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Roblox 未開啟時仍可收到電腦通知。";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "若要看見通知，請在您的瀏覽器允許通知。";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "此裝置的桌面通知。";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "請確認您的國碼，並輸入您的手機號碼。我們會傳送一則簡訊完成驗證程序。（注意：可能會收取簡訊費用）";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "已傳送驗證電子郵件";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "新的電子郵件地址驗證後才會生效。";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "您已成功變更密碼。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "重要：帳號建立日期將會轉移到新的使用者名稱。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "免費變更使用者名稱一次。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "之前的論壇發文會顯示在您過去的使用者名稱之下，不會轉到您新的使用者名稱。";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"以 {robuxIcon} {price} 變更使用者名稱？";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "以 {robuxIcon} {price} 變更使用者名稱？";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "變更使用者名稱";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "新的手機號碼驗證完畢後，手機號碼才會變更。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "若要變更使用者名稱，請先提供並驗證您的電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "謝謝，已傳送驗證電子郵件。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "若要變更使用者名稱，請先驗證電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "在您解除 Facebook 帳號連接之前，請新增密碼保護您的帳號。";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"您還需要 {robuxToBuy} 才能更改使用者名稱。您要加購 Robux 嗎？";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "您還需要 {robuxToBuy} 才能更改使用者名稱。您要加購 Robux 嗎？";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "若要新增帳號 PIN，請先提供並驗證您的電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "若要啟用兩步驟驗證，請先提供並驗證您的電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "若要變更使用者名稱，請先提供並驗證您的電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "輸入您的帳號的 PIN";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"確定移除後四碼為 {phoneLast4} 的手機號碼？";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "確定移除後四碼為 {phoneLast4} 的手機號碼？";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "若要新增帳號 PIN，請先驗證您的電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "若要啟用雙步驟驗證，請先驗證電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "若要變更使用者名稱，請先驗證電子郵件地址。";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "由於您持續提交良好的檢舉報告，您已被加到快速通道企劃。您的檢舉報告將會更快受到審核。繼續提交良好的檢舉報告，即可留在快速通道計畫。感謝您協助維護 Roblox 的環境！";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "數據";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "請勿提供任何可以在 Roblox 以外用來識別您的身分的詳細資料。";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "準確度為管理員同意檢舉報告的頻率，在您提交一定數量檢舉報告後將會開始顯示。「所有人」指所有快速通道成員合在一起。";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "更新年齡為 13 歲以下會啟用隱私模式。";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "變更密碼";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "變更使用者名稱";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "更新電子郵件地址";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "帳務和付款問題：info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "您還不是會員，現在加入 Builders Club！";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "您還不是會員，現在加入 Roblox Premium！";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "在裝置首頁看見通知；您可以從 Roblox App 開啟或關閉。";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "此裝置的行動裝置推播通知。";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "在我的動態消息中看見通知。按下頂端列的通知圖示檢視這些通知。";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "您關閉一種通知類型之後，我們將不會傳送該類型的新通知給您。";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "注意：若您想取消續訂會員資格，請從網站登入。";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "已成功儲存！";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "需要已驗證的電子郵件地址";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"當您從新裝置登入時，驗證碼會傳送到 {email}";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "當您從新裝置登入時，驗證碼會傳送到 {email}";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"Roblox 使用者您好，{lineBreaks}您的使用者名稱最近從 {oldUsername} 變更為 {newUsername}。若您沒有變更使用者名稱，請在 {robloxInfoEmailAddress} 通知我們。";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "Roblox 使用者您好，{lineBreaks}您的使用者名稱最近從 {oldUsername} 變更為 {newUsername}。若您沒有變更使用者名稱，請在 {robloxInfoEmailAddress} 通知我們。";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Roblox 使用者名稱變更{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Roblox 使用者名稱變更{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Roblox 使用者名稱變更";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox 電子郵件地址驗證{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Roblox 電子郵件地址驗證{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox 帳號許可{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Roblox 帳號許可{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}很高興您提供電子郵件地址保護您的帳號 {username}。{lineBreak}電子郵件地址經過驗證後，您的帳號將會更安全。{lineBreak}請按下下方按鈕完成驗證程序。{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}驗證電子郵件{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}很高興您提供電子郵件地址保護您的帳號 {username}。{lineBreak}電子郵件地址經過驗證後，您的帳號將會更安全。{lineBreak}請按下下方按鈕完成驗證程序。{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}驗證電子郵件{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"您好，{lineBreak}{lineBreak}您的小孩已在 Roblox 建立帳號，使用者名稱為 {boldTagStart}{username}{boldTagEnd}。Roblox 是一個網路娛樂平台，玩家可以在我們眾多身歷其境的 3D 世界裡一起發揮想像力和同樂。玩家也可以使用我們免費的開發工具 Roblox Studio 創作簡單的模組和設計複雜的多人遊戲，盡情揮灑創意。已經有幾百萬名兒童透過 Roblox 實現他們的幻想，其中包括設計華麗的主題公園、以職業賽車手之姿和其他人競賽、成為時裝秀的焦點、化身超級英雄、邀請好友到夢寐以求的房子等等。{lineBreak}{lineBreak}我們想讓您知道您的小孩已提供我們使用者名稱、出生日期和家長的電子郵件地址。家長的電子郵件地址只會用在帳號管理、密碼重置及通知帳號使用權限更改上。請按下此按鈕驗證您的電子郵件地址：{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}驗證電子郵件地址{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}關於 Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox 致力打造一個老少咸宜的愉快環境；我們持續地和數位安全專家增強我們的安全措施，確保所有玩家都能安心地同樂、聊天及合作。我們建議您閱讀以下的家長指南讓您更加熟悉我們的平台，並了解如何讓您的小孩的 Roblox 體驗更加豐富：{aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox 也備有{boldTagStart}家長監護功能{boldTagEnd}。家長可以啟用家長 PIN，變更小孩的通訊與聊天設定。若要尋找這些監護功能，您可於登入小孩的帳號，並前往帳號設定中的安全性及隱私權標籤。{lineBreak}{lineBreak}若要新增家長 PIN，請前往：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}若要變更聊天設定，請前往： {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隱私權{boldTagEnd}{lineBreak}{lineBreak}若要移除您的小孩的帳號，您可以前往此處聯絡客服人員：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊 {lineBreak}{lineBreak} 請勿直接回覆此電子郵件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "您好，{lineBreak}{lineBreak}您的小孩已在 Roblox 建立帳號，使用者名稱為 {boldTagStart}{username}{boldTagEnd}。Roblox 是一個網路娛樂平台，玩家可以在我們眾多身歷其境的 3D 世界裡一起發揮想像力和同樂。玩家也可以使用我們免費的開發工具 Roblox Studio 創作簡單的模組和設計複雜的多人遊戲，盡情揮灑創意。已經有幾百萬名兒童透過 Roblox 實現他們的幻想，其中包括設計華麗的主題公園、以職業賽車手之姿和其他人競賽、成為時裝秀的焦點、化身超級英雄、邀請好友到夢寐以求的房子等等。{lineBreak}{lineBreak}我們想讓您知道您的小孩已提供我們使用者名稱、出生日期和家長的電子郵件地址。家長的電子郵件地址只會用在帳號管理、密碼重置及通知帳號使用權限更改上。請按下此按鈕驗證您的電子郵件地址：{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}驗證電子郵件地址{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}關於 Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox 致力打造一個老少咸宜的愉快環境；我們持續地和數位安全專家增強我們的安全措施，確保所有玩家都能安心地同樂、聊天及合作。我們建議您閱讀以下的家長指南讓您更加熟悉我們的平台，並了解如何讓您的小孩的 Roblox 體驗更加豐富：{aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox 也備有{boldTagStart}家長監護功能{boldTagEnd}。家長可以啟用家長 PIN，變更小孩的通訊與聊天設定。若要尋找這些監護功能，您可於登入小孩的帳號，並前往帳號設定中的安全性及隱私權標籤。{lineBreak}{lineBreak}若要新增家長 PIN，請前往：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}若要變更聊天設定，請前往： {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隱私權{boldTagEnd}{lineBreak}{lineBreak}若要移除您的小孩的帳號，您可以前往此處聯絡客服人員：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊 {lineBreak}{lineBreak} 請勿直接回覆此電子郵件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"若要尋找這些監護功能，您可於登入小孩的帳號，並前往帳號設定中的安全性及隱私權標籤。{lineBreak}{lineBreak}若要新增家長 PIN，請瀏覽：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}。{lineBreak}{lineBreak}若要變更聊天設定，請瀏覽：{aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隱私權{boldTagEnd}{lineBreak}{lineBreak}若要移除您的小孩的帳號，可前往此處聯絡客服人員：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊 {lineBreak}{lineBreak}請勿直接回覆此電子郵件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "若要尋找這些監護功能，您可於登入小孩的帳號，並前往帳號設定中的安全性及隱私權標籤。{lineBreak}{lineBreak}若要新增家長 PIN，請瀏覽：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}。{lineBreak}{lineBreak}若要變更聊天設定，請瀏覽：{aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隱私權{boldTagEnd}{lineBreak}{lineBreak}若要移除您的小孩的帳號，可前往此處聯絡客服人員：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊 {lineBreak}{lineBreak}請勿直接回覆此電子郵件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}很高興您提供電子郵件地址保護您的帳號 {username}。{lineBreak}電子郵件地址經過驗證後，您的帳號將會更安全。{lineBreak}請按下下方連結完成驗證程序：{lineBreak}{verificationLink}。";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "親愛的 Roblox 使用者您好，{lineBreak}{lineBreak}很高興您提供電子郵件地址保護您的帳號 {username}。{lineBreak}電子郵件地址經過驗證後，您的帳號將會更安全。{lineBreak}請按下下方連結完成驗證程序：{lineBreak}{verificationLink}。";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"您好，{lineBreak}{lineBreak}您的小孩已在 Roblox 建立帳號，使用者名稱為 {username}。Roblox 是一個網路娛樂平台，玩家可以在我們眾多身歷其境的 3D 世界裡一起發揮想像力和同樂。玩家也可以使用我們免費的開發工具 Roblox Studio 創作簡單的模組和設計複雜的多人遊戲，盡情揮灑創意。已經有幾百萬名兒童透過 Roblox 實現他們的幻想，其中包括設計華麗的主題公園、以職業賽車手之姿和其他人競賽、成為時裝秀的焦點、化身超級英雄、邀請好友到夢寐以求的房子等等。{lineBreak}{lineBreak}我們想讓您知道您的小孩已提供我們使用者名稱、出生日期和家長的電子郵件地址。家長的電子郵件地址只會用在帳號管理、密碼重置及通知帳號使用權限更改上。請按下此按鈕驗證您的電子郵件地址：{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}關於 Roblox{lineBreak}{lineBreak}Roblox 致力打造一個老少咸宜的愉快環境；我們持續地和數位安全專家增強我們的安全措施，確保所有玩家都能安心地同樂、聊天及合作。我們建議您閱讀以下的家長指南讓您更加熟悉我們的平台，並了解如何讓您的小孩的 Roblox 體驗更加豐富：{parentalPageLink}{lineBreak}{lineBreak}Roblox 也備有家長監護功能。家長可以啟用家長 PIN，變更小孩的通訊與聊天設定。若要尋找這些監護功能，您可於登入小孩的帳號，並前往帳號設定中的安全性及隱私權標籤。{lineBreak}{lineBreak}若要新增家長 PIN，請前往：{accountSecurityLink}{lineBreak}{lineBreak}若要變更聊天設定，請前往： {chatPrivacyLink}{lineBreak}{lineBreak}隱私權{lineBreak}{lineBreak}若要移除您的小孩的帳號，可前往此處聯絡客服人員：{supportPageLink}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{privacyPageLink}。{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊 {lineBreak}請勿直接回覆此電子郵件。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "您好，{lineBreak}{lineBreak}您的小孩已在 Roblox 建立帳號，使用者名稱為 {username}。Roblox 是一個網路娛樂平台，玩家可以在我們眾多身歷其境的 3D 世界裡一起發揮想像力和同樂。玩家也可以使用我們免費的開發工具 Roblox Studio 創作簡單的模組和設計複雜的多人遊戲，盡情揮灑創意。已經有幾百萬名兒童透過 Roblox 實現他們的幻想，其中包括設計華麗的主題公園、以職業賽車手之姿和其他人競賽、成為時裝秀的焦點、化身超級英雄、邀請好友到夢寐以求的房子等等。{lineBreak}{lineBreak}我們想讓您知道您的小孩已提供我們使用者名稱、出生日期和家長的電子郵件地址。家長的電子郵件地址只會用在帳號管理、密碼重置及通知帳號使用權限更改上。請按下此按鈕驗證您的電子郵件地址：{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}關於 Roblox{lineBreak}{lineBreak}Roblox 致力打造一個老少咸宜的愉快環境；我們持續地和數位安全專家增強我們的安全措施，確保所有玩家都能安心地同樂、聊天及合作。我們建議您閱讀以下的家長指南讓您更加熟悉我們的平台，並了解如何讓您的小孩的 Roblox 體驗更加豐富：{parentalPageLink}{lineBreak}{lineBreak}Roblox 也備有家長監護功能。家長可以啟用家長 PIN，變更小孩的通訊與聊天設定。若要尋找這些監護功能，您可於登入小孩的帳號，並前往帳號設定中的安全性及隱私權標籤。{lineBreak}{lineBreak}若要新增家長 PIN，請前往：{accountSecurityLink}{lineBreak}{lineBreak}若要變更聊天設定，請前往： {chatPrivacyLink}{lineBreak}{lineBreak}隱私權{lineBreak}{lineBreak}若要移除您的小孩的帳號，可前往此處聯絡客服人員：{supportPageLink}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{privacyPageLink}。{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊 {lineBreak}請勿直接回覆此電子郵件。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"若要變更聊天設定，請瀏覽：{chatPrivacyLink}\u3000{lineBreak}{lineBreak}。隱私權{lineBreak}{lineBreak}若要移除您的小孩的帳號，可前往此處聯絡客服人員：{supportPageLink}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{privacyPageLink}。{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊{lineBreak}請勿直接回覆此電子郵件。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "若要變更聊天設定，請瀏覽：{chatPrivacyLink}\u3000{lineBreak}{lineBreak}。隱私權{lineBreak}{lineBreak}若要移除您的小孩的帳號，可前往此處聯絡客服人員：{supportPageLink}。您的電子郵件地址不會用在其他用途、向第三方揭露或與您的小孩的個人資料合併。若您需要更多資訊，您可以前往此連結查看我們的隱私權政策：{privacyPageLink}。{lineBreak}{lineBreak}謝謝您，{lineBreak}{lineBreak}Roblox 團隊{lineBreak}請勿直接回覆此電子郵件。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Roblox 電子郵件地址驗證";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Roblox 帳號許可";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "自我介紹（最多 1000 個字元）";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "例如 www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "例如 http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "例如 www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "例如 @Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "例如 www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "什麼是帳號控制？";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "帳號資訊";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "帳務";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "封鎖的使用者";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "聯絡設定";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "桌面推播";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "新增密碼";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "新增手機號碼";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "變更我的電子郵件地址";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "電子郵件地址已變更";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "變更密碼";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "變更使用者名稱";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "錯誤";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "編輯手機號碼";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "資金不足";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "使用者名稱無效";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "新增 PIN";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "需要帳號 PIN";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "移除手機號碼";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "需要已驗證的電子郵件地址";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "驗證電子郵件地址";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "驗證手機號碼";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "快速通道";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "會員資格狀態";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "有以下情形時通知我";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "通知";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "有以下情形時通知我";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "桌面推播";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "行動裝置推播";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "動態消息";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "動態消息";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "其它設定";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "我的設定";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "個人資訊";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "帳號 PIN";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "隱私權設定";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "續訂日期";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "帳號限制";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "安全登出";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "社交網路";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "社交登入";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "帳號資訊";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "帳務";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "快速通道";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "通知";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "隱私權";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "安全";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "交易";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "雙步驟驗證";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "帳號 PIN 目前停用";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "帳號 PIN 目前啟用";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "帳號限制目前停用";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "帳號限制目前啟用";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "新增電子郵件地址";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "新增家長的電子郵件地址";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "新增密碼：";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "新增手機號碼";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "新增手機號碼";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "帳務和付款問題：";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"若有帳務和付款問題，請前往{aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}帳務協助頁面{aTagEnd}。";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "若有帳務和付款問題，請前往{aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}帳務協助頁面{aTagEnd}。";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"末四碼為 {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "末四碼為 {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "費用";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "日期";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "說明";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "此服務目前停用，請稍後再試。";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "無交易";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "付款方式";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "生日";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"您還不是會員，現在加入 {startSpan}Builders Club{endSpan}！";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "您還不是會員，現在加入 {startSpan}Builders Club{endSpan}！";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "變更您的使用者名稱";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "選擇語言";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "關閉";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "連接帳號：";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "選擇國家或地區";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "位置";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "黑暗";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "新增我的電子郵件地址";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "新增家長的電子郵件地址";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "手機號碼";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "輸入此帳號的密碼";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "輸入新的電子郵件地址";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "輸入新的電子郵件地址";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "變更家長的電子郵件地址";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "確認密碼";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "目前密碼";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "新密碼";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "帳號密碼";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "欲使用的使用者名稱 （3 到 20 個字元）";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "確認您的 PIN";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"建立 {digitCount} 碼 PIN";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "建立 {digitCount} 碼 PIN";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "目前號碼：";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "電子郵件地址已變更";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "需要電子郵件地址";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "已驗證的電子郵件地址：";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "輸入此帳號的密碼";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"輸入驗證碼（{digitCount} 位）";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "輸入驗證碼（{digitCount} 位）";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "請輸入傳送到您的手機的驗證碼";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "驗證簡訊";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "自訂";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "預設";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "所有人";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "好友、我追蹤的使用者及追蹤者";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "好友及我追蹤的使用者";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "好友";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "高";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "低";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "中";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "無";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "沒有人";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "關閉";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "電子郵件地址：";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "家長的電子郵件地址：";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "待驗證";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "有效期限";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"{startSpan}{expirationDate}{endSpan} 到期";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "{startSpan}{expirationDate}{endSpan} 到期";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook：";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "準確度";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "所有人";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "月";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "年";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "數據";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "您";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "性別";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+：";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "燈光";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "語言";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"{startSpan}Builders Club{endSpan} 會員資格";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "{startSpan}Builders Club{endSpan} 會員資格";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "您還不是會員，現在加入 Roblox Premium！";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "有人邀請我加入 VIP 伺服器";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "有人與我聊天";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "有人置頂新遊戲一起玩";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "有新的分析報告";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "有人接受我的好友邀請";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "我收到一則好友邀請";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "我收到遊戲更新通知";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "有人邀請我加入隊伍";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "有人加入我目前的隊伍";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "我收到私人訊息";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "有人邀請我編輯遊戲";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "密碼：";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "手機號碼：";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "分";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "剩餘時間";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "秒";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "之前的使用者名稱：";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "隱私模式";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "續訂日期";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"於 {startSpan}{expirationDate}{endSpan} 自動續訂。";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "於 {startSpan}{expirationDate}{endSpan} 自動續訂。";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount} Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount} Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "登出其它在線作業";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "開放顯示對象：";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"以 {socialUsername} 連線";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "以 {socialUsername} 連線";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "主題";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "自訂：控制您自己的設定。預設 ：啟用好友聊天與訊息。關閉：停用聊天與訊息。";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "所有設定已鎖定。若要編輯，請輸入 PIN 解鎖";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "按下鎖定您的設定頁面";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "按下此處取得更多資訊";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "此設定控制此使用者可以在 App 及網頁中的聊天對象（但無法控制遊戲中的聊天對象）。此設定也禁止此使用者在論壇和群組留言板上貼文。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "此設定控制此使用者可以在遊戲中聊天的對象。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "此設定控制誰可以使用您提供的手機號碼找到您。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "此設定控制誰可以在 VIP 伺服器中加入這位使用者；VIP 伺服器是只可以透過伺服器主人邀請加入的伺服器。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "此設定控制誰可以看到我在玩的遊戲，並加入我的伺服器。若選擇「沒有人」，將不會有人跟隨我加入我的伺服器，但我仍會和其他使用者玩遊戲。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "此設定控制此使用者可以從哪些使用者收到訊息。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "此設定控制誰可以看到您的道具欄。";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "交易品質篩選器";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch：";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter：";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "啟用雙步驟驗證";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "需要已驗證的電子郵件地址。";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "進一步保護您的帳號。當您從新裝置登入時，您將需要輸入驗證碼。";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "您的帳號已受保護！";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "更新電子郵件地址";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "更新手機號碼";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "使用裝置語言";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "使用者名稱：";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "已驗證";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "驗證";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "誰可以在 App 與我聊天？";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "誰可以與我聊天？";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "誰可以透過我的手機號碼找到我？";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "誰可以邀請我到 VIP 伺服器？";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "誰可以加入我？";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "誰可以傳送訊息給我？";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "誰可以看到我的道具欄？";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "誰可以與我交易？";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "已連接 Xbox 帳號";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube：";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Robux 不足";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "此帳號已設置 PIN，請嘗試其他請求。";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "此帳號遭到封鎖，請在執行此動作前解鎖此帳號。";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "此電子郵件地址已驗證。";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "此功能目前停用，請稍後再試。";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "密碼不正確。";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "電子郵件地址無效。";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "此帳號沒有加入電子郵件地址。";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "PIN 已鎖定。";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "這已是目前的電子郵件地址。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "加入此電子郵件地址的帳號過多。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "更新電子郵件地址次數過多，請稍後再試。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "傳送驗證電子郵件次數過多，請稍後再試。";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "發生未知錯誤。";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "PIN 碼錯誤。";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "PIN 格式無效。";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "帳號沒有 PIN。";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "此帳號沒有已驗證的電子郵件地址。";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "系統錯誤。";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "請求次數過多，請稍後再試。";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "已新增電子郵件地址";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "您的電子郵件地址已驗證！";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "此功能目前停用，請稍後再試。";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "您的 Robux 不足，無法變更使用者名稱。";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "電子郵件地址無效";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "您必須在此帳號新增電子郵件地址";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "您的 Robux 不足，無法變更使用者名稱。";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "PIN 已鎖定。";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "這已是目前已驗證的電子郵件地址。";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "您的設定已更新。";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "加入此電子郵件地址的帳號過多。";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "嘗試次數過多，請稍後再試。";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "發生未知錯誤。";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "您的密碼不正確。";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "驗證碼無效，請檢查您的手機後重新嘗試。";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "「誰可以與我交易」的值應在「誰可以看到我的道具欄」的值以下。";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "需要驗證碼，請輸入您的驗證碼。";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "若變更生日為 13 歲以下，之後將無法還原。確定？";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "若要變更生日，請先新增 Roblox 帳號密碼。";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "必須新增密碼";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "若變更生日為 13 歲以下，之後將無法還原。您的 Facebook 社交登入將會被停用，之後必須使用 Roblox 密碼登入。";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "您目前的密碼不正確，密碼並未變更。";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "密碼不相符";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "需要 8 個字元以上";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "請輸入使用者名稱。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "此使用者名稱含有不當內容。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "此使用者名稱已被使用。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "已成功變更使用者名稱。";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "載入國家清單時發生錯誤";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "貨幣服務發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "發生錯誤";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "已成功儲存！";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "解除您的 Xbox 帳號連接時發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "已傳送驗證電子郵件。";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "電子郵件地址無效";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "手機號碼無效";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "按下「傳送」提交聯絡單，或按下「取消」編輯使用者名稱。提供正確的使用者名稱可以讓我們更快解決您的問題。";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "密碼需要 8 個字元以上，其中應含有 2 個數字、4 個字母及 1 個符號。";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "您的 PIN 已成功設定。往後進入設定頁面之前，您將需要輸入此 PIN。";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "PIN 不相符";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "登出其它在線作業時發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "您已登出其它在線作業。";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "若您關閉雙步驟驗證，您使用新裝置登入時將只需輸入密碼。確定？";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "雙步驟驗證已啟用";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "您的帳號已受到保護，目前不需進行其他動作。您下一次從新裝置登入時，我們將會送出安全碼。";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "我們已更新您的道具欄隱私權設定；道具欄設定必須和交易設定一致。";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "更新您的通知設定時發生錯誤，請稍後再試。";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "我們已更新您的交易隱私權設定；交易設定必須和道具欄設定一致。";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "驗證碼無效，請檢查您的手機後重新嘗試。";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "警告";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "此功能目前停用，請稍後再試。";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "發生錯誤，請重新嘗試。";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "您輸入錯誤驗證碼的次數過多。";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "密碼不正確，請檢查您的密碼後重新嘗試。";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "手機號碼格式無效，請檢查之後重新嘗試。";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "手機號碼已移除";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "手機號碼已成功更新！";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "已有帳號加入此手機號碼。";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "若要變更您的設定，請先輸入 PIN。";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "此社交網路連結無效。";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "對不起，您不可以將年齡改為 13 歲以下。若您未滿 13 歲，請建立一個新帳號，並聯絡客服人員刪除您的舊帳號。";
	}
}
