namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_zh_cn : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "加载更多";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "取消续订";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "添加电子邮件";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "添加手机";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "取消";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "更改电子邮件";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "好";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "更新";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "好";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "购买";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "关闭";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "编辑手机";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "移除手机号码";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "购买";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "否";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "添加";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "好";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "解锁";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "移除";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "取消";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "发送";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "好";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "更新";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "好";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "验证电子邮件";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "重试";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "验证";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "重新发送验证码";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "取消";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "是";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "隐藏";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "加入";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "加入 Builders Club";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "保存";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "显示";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "注销";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "断开连接";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "好";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "取消屏蔽";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "升级会员资格";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "你可以设置帐户限制，限制对帐户设置及未筛选内容的访问权限";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "重置 Roblox 电子邮件";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Roblox 关闭时仍可在此电脑上收到通知。";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "要看到通知，系统可能会提示你打开浏览器的推送通知。";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "此设备的桌面通知。";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "请确认你的国家代码并输入你的电话号码。我们会发送短信以完成验证。（注意：发送短信时可能会产生通信费用）";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "已发送验证电子邮件";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "新电子邮件验证后，才能对帐户邮件进行更改。";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "你已成功更改密码。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "重要通知：原始帐户的创建日期将转移至你的新用户名下。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "可免费更改用户名一次。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "此前的论坛发帖会显示在你的旧用户名下，不会转移至你的新用户名下。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "更改用户名";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "新手机号码验证后，才能对手机号码进行更改。";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "你必须先提供并验证电子邮件，才能更改用户名。";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "谢谢！你的验证电子邮件已发送。";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "你必须先验证电子邮件，才能更改用户名。";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "请先添加密码保护你的帐户，然后再从 Facebook 断开连接。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "你必须先提供并验证电子邮件，才能添加帐户 PIN。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "你必须先提供并验证电子邮件，才能启用两步验证。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "你必须先提供并验证电子邮件，才能更改用户名。";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "请输入与你的帐户相关联的 PIN";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "你必须先验证电子邮件，才能添加帐户 PIN 码。";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "你必须先验证电子邮件，才能启用两步验证。";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "你必须先验证电子邮件，才能更改用户名。";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "由于你持续提交了优质的滥用行为报告，你已被加至快速追踪报告计划。你提交的滥用行为报告将会更快地得到审核。继续提交优质的滥用行为报告，你即可继续留在本计划。感谢你帮助 Roblox 维护优质环境！";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "统计信息";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "请勿提供任何能在 Roblox 以外用于识别个人身份的详细信息。";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "准确性代表的是审核团队批准滥用报告的频率。在你提交一定数量的报告后将会显示该项数据。“所有人”则是代表所有快速追踪计划的成员。";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "将年龄更新为 13 岁以下会启用隐私模式。";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "更改密码";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "更改用户名";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "更新电子邮件";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "关于账单与付款问题，请联系：info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "你还不是会员。快来加入 Builders Club 吧！";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "你还不是会员。快来加入 Roblox Premium 吧！";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "在你的设备主画面看到通知。你可以从 Roblox App 中开启或关闭这项设置。";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "此设备的移动推送通知。";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "在我的动态消息中看到通知。点击顶部栏中的通知图标，即可查看这些通知。";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "当你关闭某种通知类型后，我们则不会再向你发送任何该类型的新通知。";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "注意：如果你想取消会员资格续订，请从网站登录。";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "已成功保存！";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "需要已验证的电子邮件";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Roblox 用户名更改";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Roblox 电子邮件验证";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Roblox 帐户授权";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "自我介绍（限 1000 个字符以内）";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "例如：www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "例如：http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "例如：www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "例如：@Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "例如：www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "什么是帐户控制？";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "帐户信息";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "账单";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "已屏蔽用户";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "联系人设置";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "桌面推送";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "添加密码";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "添加手机";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "更改我的电子邮件";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "电子邮件地址已更改";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "更改密码";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "更改用户名";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "错误";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "编辑手机";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "资金不足";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "用户名无效";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "添加 PIN";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "需要帐户 PIN";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "移除手机";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "需要已验证的电子邮件";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "验证电子邮件";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "验证手机";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "快速追踪";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "会员状态";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "有下列情形时通知我";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "通知";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "有下列情形时通知我";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "桌面推送";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "移动推送";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "动态消息";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "动态消息";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "其他设置";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "我的设置";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "个人资料";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "帐户 PIN";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "隐私设置";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "续订日期";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "帐户限制";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "安全注销";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "社交网络";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "社交登录";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "成功";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "帐户信息";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "账单";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "快速追踪";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "通知";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "隐私";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "安全";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "交易";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "两步验证";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "帐户 PIN 当前已停用";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "帐户 PIN 当前已启用";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "帐户限制当前已停用";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "帐户限制当前已启用";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "添加电子邮件";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "添加家长电子邮件";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "添加密码：";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "添加手机";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "添加手机";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "关于账单与付款问题：";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "费用";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "日期";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "描述";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "服务当前已停用，请稍后重试。";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "无交易";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "付款类型";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "生日";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "更改你的用户名";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "选择语言";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "关闭";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "连接帐户：";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "选择国家/地区";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "位置";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "黑色";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "添加我的电子邮件";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "添加家长电子邮件";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "手机号码";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "验证帐户密码";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "更改我的电子邮件";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "更改我的电子邮件";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "更改家长电子邮件";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "确认密码";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "当前密码";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "新密码";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "帐户密码";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "想使用的用户名（3-20 个字符）";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "确认你的 PIN";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "当前号码：";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "电子邮件地址已更改";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "需要电子邮件";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "已验证的电子邮件：";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "验证帐户密码";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "请输入我们刚发送至你手机的验证码";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "验证短信";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "自定义";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "默认";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "每个人";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "好友、我关注的用户和粉丝";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "好友和我关注的用户";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "好友";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "高";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "低";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "中";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "无";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "没有人";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "关闭";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "电子邮件地址：";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "家长电子邮件地址：";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "待处理验证";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "失效日期";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook：";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "准确性";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "所有人";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "月";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "年";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "统计信息";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "你";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "性别";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+：";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "白色";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "语言";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "你还不是会员。快来加入 Roblox Premium 吧！";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "我受邀进入 VIP 服务器";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "有人与我聊天";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "有人置顶了新游戏一起玩";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "分析报告现已可用";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "有人接受了我的好友请求";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "我收到好友请求";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "我收到更新通知";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "有人邀请我参加派对";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "有人加入我当前的派对";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "我收到私人信息";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "有人邀请我编辑游戏";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "密码：";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "手机号码：";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "分";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "剩余时间";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "秒";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "旧用户名：";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "隐私模式";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "续订日期";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "注销所有其他会话";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "可见对象：";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "主题";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "自定义 - 控制你自己的设置。默认 - 启用与好友聊天并发送信息等功能。关闭 - 停用聊天和发送信息功能。";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "设置已全部锁定。若要编辑，请使用 PIN 解锁";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "点按以锁定你的设置页面";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "点击此处了解更多信息";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "此设置决定此用户在 App 中及网络上可以聊天的对象（无法控制游戏中的聊天对象）。此设置也可阻止此用户在论坛和群组留言板上发帖。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "此设置决定此用户在游戏中可以聊天的对象。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "此设置决定谁可以通过你提供的手机号码找到你。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "此设置决定谁可以在 VIP 服务器中加入此用户 - VIP 服务器只能通过服务器主人的邀请才能加入。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "此设置决定谁能看到我在哪个游戏中，并加入我的服务器。选择“没有人”，表示没有人可以跟随我进入我的特定服务器，但我可以跟其他用户一起玩游戏。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "此设置决定谁可以向此用户的信息收件箱发送信息。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "这项设置决定谁可以看到你的道具。";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "交易品质过滤器";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter：";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "启用两步验证";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "需要已验证的电子邮件。";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "提高你的帐户安全性。当你从新设备登录时，需要输入验证码。";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "你的帐户已受到保护！";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "更新电子邮件";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "更新手机";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "使用设备语言";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "用户名：";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "已验证";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "验证";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "谁可以在 App 中与我聊天？";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "谁可以与我聊天？";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "谁可以通过我的手机号码找到我？";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "谁可以邀请我加入 VIP 服务器？";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "谁可以加入我？";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "谁可以向我发送消息？";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "谁可以看到我的道具？";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "谁可以与我交易？";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "已使用 Xbox 帐户连接";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube：";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Robux 余额不足";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "帐户已有 PIN 码。请尝试不同请求。";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "帐户已锁。在继续下一个动作之前，请先解锁帐户。";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "发生错误，请稍后重试。";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "电子邮件已验证。";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "此功能当前已停用。请稍后重试。";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "密码不正确。";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "电子邮件地址无效。";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "没有与此帐户关联的电子邮件。";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "PIN 已锁定。";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "这已经是当前的电子邮件。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "此邮件地址的关联帐户过多。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "尝试更新邮件的次数过多。请稍后重试。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "尝试发送验证邮件的次数过多。请稍后重试。";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "发生未知错误。";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "PIN 码不正确。";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "PIN 格式无效。";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "帐户中不存在 PIN 码。";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "帐户没有已验证的电子邮件。";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "系统错误。";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "请求次数过多，请稍后重试。";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "电子邮件已添加";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "你的电子邮件已验证！";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "此功能当前已停用。请稍后重试。";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "你的 Robux 余额不足，无法更改用户名。";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "电子邮件无效";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "你必须将电子邮件地址与你的帐户相关联";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "你的 Robux 不足，无法更改用户名。";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "PIN 已锁定。";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "这已经是当前已验证的电子邮件。";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "你的设置已更新。";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "此电子邮件地址的关联帐户过多。";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "尝试次数过多。请稍后重试。";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "发生未知错误。";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "你的密码不正确。";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "验证码无效。请查看你的手机并重试。";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "“谁可以与我交易“的设置应与”谁可以看到我的道具“相符，或比后者更严格。";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "需要验证码。请输入你的验证码。";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "将你的生日更改为 13 岁以下则无法还原。是否确定要继续？";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "若要更改生日，你必须先为你的 Roblox 帐户添加密码。";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "必须添加密码";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "将你的生日更改为 13 岁以下则无法还原。你的 Facebook 社交登录将被停用，你也将必须使用 Roblox 密码登录。";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "你当前的密码不正确，密码未更改。";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "密码不符";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "必须至少为 8 个字符";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "请输入用户名。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "用户名不适用于 Roblox。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "此用户名已被使用。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "已成功更改用户名。";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "加载国家列表时出错";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "运行货币服务时发生错误。请稍后重试。";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "发生错误，请稍后重试。";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "发生错误";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "保存成功！";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "断开你的 Xbox 帐户连接时发生错误，请稍后重试。";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "已发送验证电子邮件。";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "电子邮件地址无效";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "手机号码无效";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "按“发送”提交票单，或按”取消”以编辑用户名。用户名是非常重要的信息，有助于加快解决你的问题。";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "密码须至少包含 2 个数字、4 个字母、1 个符号，且至少为 8 个字符。";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "你的 PIN 现已设置好。你将需要先输入此 PIN，才能访问设置页面。";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "PIN 不匹配";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "注销所有其他会话时发生错误，请稍后重试。";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "你已注销所有其他会话。";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "如果关闭两步验证，那么下次当你从新设备登录时，你将只需要输入密码。是否确定？";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "两步验证已启用";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "你的帐户现已受到保护，目前无需任何下一步的操作。下次当你从新设备登录时，系统将会发送一个安全码。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "我们已更新了你的道具隐私设置。道具与交易的设置须保持一致。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "更新你的通知设置时发生错误，请稍后重试。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "我们已更新了你的道具隐私设置。道具与交易的设置须保持一致。";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "验证码无效。请查看你的手机并重试。";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "警告";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "此功能当前已停用。请稍后重试。";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "发生错误。请重试。";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "你输入错误验证码的次数过多。";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "密码不正确。请检查你的密码并重试。";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "手机号码格式无效。请检查并重试。";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "手机已移除";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "手机已更新成功！";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "此号码已与另一帐户相关联。";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "请输入你的 PIN 以更改设置。";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "社交网络链接无效。";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "抱歉，你无法将你的年龄改为 13 岁以下。如果你未满 13 岁，请创建一个新帐户，联系技术支持以删除你的旧帐户。";

	public AccountSettingsResources_zh_cn(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "加载更多";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "取消续订";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "添加电子邮件";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "添加手机";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "更改电子邮件";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "好";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "更新";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "好";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "购买";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "关闭";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "编辑手机";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "移除手机号码";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "购买";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "否";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "添加";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "好";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "解锁";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "移除";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "发送";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "好";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "更新";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "好";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "验证电子邮件";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "重试";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "验证";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "重新发送验证码";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "是";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "隐藏";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "加入";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "加入 Builders Club";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "保存";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "显示";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "注销";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "断开连接";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "好";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "取消屏蔽";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "升级会员资格";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "你可以设置帐户限制，限制对帐户设置及未筛选内容的访问权限";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}重置 Roblox 电子邮件{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}重置 Roblox 电子邮件{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"亲爱的 Roblox 用户，{lineBreak}{lineBreak}我们注意到你已将 {username} 帐户的电子邮件地址从 {oldEmailAddress} 更改为 {newEmailAddress}。如果你不想真的更改，或者你认为别人可能不小心作出了此更改，那么我们需要你点按此链接{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}以将电子邮件改回原地址。你还将需要输入一个新密码。这样，我们才能确认你帐户的安全性。{lineBreak}{lineBreak}如果你更倾向于在 Roblox 上使用新的电子邮件地址，无需任何步骤，帐户已为你设置好。{lineBreak}{lineBreak}请不要回复此信息。如果你有任何问题，请发送电子邮件至 {robloxInfoEmailAddress}。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "亲爱的 Roblox 用户，{lineBreak}{lineBreak}我们注意到你已将 {username} 帐户的电子邮件地址从 {oldEmailAddress} 更改为 {newEmailAddress}。如果你不想真的更改，或者你认为别人可能不小心作出了此更改，那么我们需要你点按此链接{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}以将电子邮件改回原地址。你还将需要输入一个新密码。这样，我们才能确认你帐户的安全性。{lineBreak}{lineBreak}如果你更倾向于在 Roblox 上使用新的电子邮件地址，无需任何步骤，帐户已为你设置好。{lineBreak}{lineBreak}请不要回复此信息。如果你有任何问题，请发送电子邮件至 {robloxInfoEmailAddress}。";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"亲爱的 Roblox 用户，{lineBreak}{lineBreak}我们注意到你已将 {username} 帐户的电子邮件地址从 {oldEmailAddress} 更改为 {newEmailAddress}。如果你不想真的更改，或者你认为别人可能不小心作出了此更改，那么我们需要你点按此链接{lineBreak}{revertAccountEmailLink}{lineBreak}以将电子邮件改回原地址。你还将需要输入一个新密码。这样，我们才能确认你帐户的安全性。{lineBreak}{lineBreak}如果你更倾向于在 Roblox 上使用新的电子邮件地址，无需任何步骤，帐户已设置好。{lineBreak}请不要回复此信息。如果你有任何问题，请发送电子邮件至 {robloxInfoEmailAddress}。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "亲爱的 Roblox 用户，{lineBreak}{lineBreak}我们注意到你已将 {username} 帐户的电子邮件地址从 {oldEmailAddress} 更改为 {newEmailAddress}。如果你不想真的更改，或者你认为别人可能不小心作出了此更改，那么我们需要你点按此链接{lineBreak}{revertAccountEmailLink}{lineBreak}以将电子邮件改回原地址。你还将需要输入一个新密码。这样，我们才能确认你帐户的安全性。{lineBreak}{lineBreak}如果你更倾向于在 Roblox 上使用新的电子邮件地址，无需任何步骤，帐户已设置好。{lineBreak}请不要回复此信息。如果你有任何问题，请发送电子邮件至 {robloxInfoEmailAddress}。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "重置 Roblox 电子邮件";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"此帐户只能访问我们平台上的已筛选内容。此外，“联系人设置”部分（位于{linkStart}隐私{linkEnd}页面上方）将被设为“关闭”。";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "此帐户只能访问我们平台上的已筛选内容。此外，“联系人设置”部分（位于{linkStart}隐私{linkEnd}页面上方）将被设为“关闭”。";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"你已屏蔽 {totalBlockedCount} 名用户（最多 {maxBlockedCount} 名）：";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "你已屏蔽 {totalBlockedCount} 名用户（最多 {maxBlockedCount} 名）：";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"由于启用帐户限制（位于{linkStart}安全性{linkEnd}页面下方），“联系人设置”部分已锁定";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "由于启用帐户限制（位于{linkStart}安全性{linkEnd}页面下方），“联系人设置”部分已锁定";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Roblox 关闭时仍可在此电脑上收到通知。";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "要看到通知，系统可能会提示你打开浏览器的推送通知。";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "此设备的桌面通知。";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "请确认你的国家代码并输入你的电话号码。我们会发送短信以完成验证。（注意：发送短信时可能会产生通信费用）";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "已发送验证电子邮件";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "新电子邮件验证后，才能对帐户邮件进行更改。";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "你已成功更改密码。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "重要通知：原始帐户的创建日期将转移至你的新用户名下。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "可免费更改用户名一次。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "此前的论坛发帖会显示在你的旧用户名下，不会转移至你的新用户名下。";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"以 {robuxIcon} {price} 的价格更改用户名？";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "以 {robuxIcon} {price} 的价格更改用户名？";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "更改用户名";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "新手机号码验证后，才能对手机号码进行更改。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "你必须先提供并验证电子邮件，才能更改用户名。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "谢谢！你的验证电子邮件已发送。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "你必须先验证电子邮件，才能更改用户名。";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "请先添加密码保护你的帐户，然后再从 Facebook 断开连接。";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"你还需要 {robuxToBuy} 才能更改用户名。是否要购买更多 Robux？";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "你还需要 {robuxToBuy} 才能更改用户名。是否要购买更多 Robux？";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "你必须先提供并验证电子邮件，才能添加帐户 PIN。";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "你必须先提供并验证电子邮件，才能启用两步验证。";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "你必须先提供并验证电子邮件，才能更改用户名。";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "请输入与你的帐户相关联的 PIN";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"是否确定移除你尾号为 {phoneLast4} 的手机号码？";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "是否确定移除你尾号为 {phoneLast4} 的手机号码？";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "你必须先验证电子邮件，才能添加帐户 PIN 码。";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "你必须先验证电子邮件，才能启用两步验证。";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "你必须先验证电子邮件，才能更改用户名。";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "由于你持续提交了优质的滥用行为报告，你已被加至快速追踪报告计划。你提交的滥用行为报告将会更快地得到审核。继续提交优质的滥用行为报告，你即可继续留在本计划。感谢你帮助 Roblox 维护优质环境！";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "统计信息";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "请勿提供任何能在 Roblox 以外用于识别个人身份的详细信息。";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "准确性代表的是审核团队批准滥用报告的频率。在你提交一定数量的报告后将会显示该项数据。“所有人”则是代表所有快速追踪计划的成员。";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "将年龄更新为 13 岁以下会启用隐私模式。";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "更改密码";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "更改用户名";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "更新电子邮件";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "关于账单与付款问题，请联系：info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "你还不是会员。快来加入 Builders Club 吧！";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "你还不是会员。快来加入 Roblox Premium 吧！";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "在你的设备主画面看到通知。你可以从 Roblox App 中开启或关闭这项设置。";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "此设备的移动推送通知。";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "在我的动态消息中看到通知。点击顶部栏中的通知图标，即可查看这些通知。";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "当你关闭某种通知类型后，我们则不会再向你发送任何该类型的新通知。";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "注意：如果你想取消会员资格续订，请从网站登录。";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "已成功保存！";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "需要已验证的电子邮件";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"当你从新设备登录时，验证码会发送至 {email}";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "当你从新设备登录时，验证码会发送至 {email}";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"你好 Roblox 用户，{lineBreaks}你的用户名最近从“{oldUsername}”更改为“{newUsername}”。如果你未申请更改用户名，请发送电子邮件至 {robloxInfoEmailAddress}。";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "你好 Roblox 用户，{lineBreaks}你的用户名最近从“{oldUsername}”更改为“{newUsername}”。如果你未申请更改用户名，请发送电子邮件至 {robloxInfoEmailAddress}。";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Roblox 用户名更改{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Roblox 用户名更改{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Roblox 用户名更改";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox 电子邮件验证{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Roblox 电子邮件验证{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox 帐户授权{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Roblox 帐户授权{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"亲爱的 Roblox 用户，{lineBreak}{lineBreak}很高兴你选择提供电子邮件地址以保护你的帐户“{username}”。{lineBreak}通过验证你 Roblox 帐户的关联电子邮件地址，你将得到更高级别的帐户安全保障。{lineBreak}请点按下面的按钮以完成验证。{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}验证电子邮件{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "亲爱的 Roblox 用户，{lineBreak}{lineBreak}很高兴你选择提供电子邮件地址以保护你的帐户“{username}”。{lineBreak}通过验证你 Roblox 帐户的关联电子邮件地址，你将得到更高级别的帐户安全保障。{lineBreak}请点按下面的按钮以完成验证。{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}验证电子邮件{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"您好，{lineBreak}{lineBreak}您的孩子已在 Roblox 上创建账户，用户名为 {boldTagStart}{username}{boldTagEnd}。Roblox 是一个网络娱乐平台，让孩子们可以在我们众多身临其境的 3D 世界中一起发挥想象力，享受游戏带来的乐趣。他们也可以使用我们开发的免费工具 Roblox Studio。无论是创作简单的模块，还是进阶到设计复杂的多人游戏，他们都能在这里尽情挥洒创意。无论是设计独一无二的主题乐园，以职业赛车手的身份竞技，成为 T 台上闪亮的明星，还是邀请朋友到自己的梦幻家园做客，目前，已经有数百万儿童通过 Roblox 实现了他们的创意。{lineBreak}{lineBreak}我们想让您知道，您的孩子已向我们提供了用户名、生日和家长的电子邮件地址。家长电子邮件将仅用于帐户管理、密码重置以及通知帐户使用权限更改等用途。请点按此按钮验证您的电子邮件地址：{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}验证电子邮件地址{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}关于 Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox 致力打造一个适合全家老少的愉快环境。我们和数码安全专家协力，不断地增强我们的安全措施，确保所有玩家都能安心地一起游戏、聊天、合作。我们建议您访问以下的《家长指南》，让您能够更加熟悉我们的平台，并了解如何让您的孩子在 Roblox 上获得更好的体验：{aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox 还提供{boldTagStart}家长控制功能{boldTagEnd}。家长可以启用家长 PIN，更改孩子的通信和聊天设定。若要找到这些控制空能，您可以登录孩子的帐户，访问帐户设置中的安全和隐私标签。{lineBreak}{lineBreak}若要添加家长 PIN，请访问：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}{lineBreak}{lineBreak}若要更改聊天设置，请访问： {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隐私{boldTagEnd}{lineBreak}{lineBreak}若要移除您孩子的帐户，您可以前往此处联系客户服务：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。您的电子邮件不会用于其他用途；不会披露给第三方；也不会与您孩子的个人资料合并。如需要更多信息，您可以访问此链接查看我们的隐私政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}谢谢您，{lineBreak}{lineBreak}Roblox 团队 {lineBreak}{lineBreak} 请勿直接回复此邮件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "您好，{lineBreak}{lineBreak}您的孩子已在 Roblox 上创建账户，用户名为 {boldTagStart}{username}{boldTagEnd}。Roblox 是一个网络娱乐平台，让孩子们可以在我们众多身临其境的 3D 世界中一起发挥想象力，享受游戏带来的乐趣。他们也可以使用我们开发的免费工具 Roblox Studio。无论是创作简单的模块，还是进阶到设计复杂的多人游戏，他们都能在这里尽情挥洒创意。无论是设计独一无二的主题乐园，以职业赛车手的身份竞技，成为 T 台上闪亮的明星，还是邀请朋友到自己的梦幻家园做客，目前，已经有数百万儿童通过 Roblox 实现了他们的创意。{lineBreak}{lineBreak}我们想让您知道，您的孩子已向我们提供了用户名、生日和家长的电子邮件地址。家长电子邮件将仅用于帐户管理、密码重置以及通知帐户使用权限更改等用途。请点按此按钮验证您的电子邮件地址：{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}验证电子邮件地址{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}关于 Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox 致力打造一个适合全家老少的愉快环境。我们和数码安全专家协力，不断地增强我们的安全措施，确保所有玩家都能安心地一起游戏、聊天、合作。我们建议您访问以下的《家长指南》，让您能够更加熟悉我们的平台，并了解如何让您的孩子在 Roblox 上获得更好的体验：{aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox 还提供{boldTagStart}家长控制功能{boldTagEnd}。家长可以启用家长 PIN，更改孩子的通信和聊天设定。若要找到这些控制空能，您可以登录孩子的帐户，访问帐户设置中的安全和隐私标签。{lineBreak}{lineBreak}若要添加家长 PIN，请访问：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}{lineBreak}{lineBreak}若要更改聊天设置，请访问： {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隐私{boldTagEnd}{lineBreak}{lineBreak}若要移除您孩子的帐户，您可以前往此处联系客户服务：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。您的电子邮件不会用于其他用途；不会披露给第三方；也不会与您孩子的个人资料合并。如需要更多信息，您可以访问此链接查看我们的隐私政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}谢谢您，{lineBreak}{lineBreak}Roblox 团队 {lineBreak}{lineBreak} 请勿直接回复此邮件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"要找到这些控制功能，你可以登录孩子的帐户，访问帐户设置中的安全性和隐私标签。{lineBreak}{lineBreak}要添加家长 PIN，请访问：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}。{lineBreak}{lineBreak}要更改聊天设置，请访问：{aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隐私{boldTagEnd}{lineBreak}{lineBreak}你可以通过联系客户服务，移除孩子的帐户：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。你的电子邮件不会用于任何其他目的，不会披露给第三方，也不会与收集自你孩子的任何其他个人信息合并。如需更多信息，请查阅我们的隐私政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}谢谢，{lineBreak}{lineBreak}Roblox 团队{lineBreak}{lineBreak}请勿直接回复本电子邮件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "要找到这些控制功能，你可以登录孩子的帐户，访问帐户设置中的安全性和隐私标签。{lineBreak}{lineBreak}要添加家长 PIN，请访问：{aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}。{lineBreak}{lineBreak}要更改聊天设置，请访问：{aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}。{lineBreak}{lineBreak}{boldTagStart}隐私{boldTagEnd}{lineBreak}{lineBreak}你可以通过联系客户服务，移除孩子的帐户：{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}。你的电子邮件不会用于任何其他目的，不会披露给第三方，也不会与收集自你孩子的任何其他个人信息合并。如需更多信息，请查阅我们的隐私政策：{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}。{lineBreak}{lineBreak}{lineBreak}谢谢，{lineBreak}{lineBreak}Roblox 团队{lineBreak}{lineBreak}请勿直接回复本电子邮件。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"亲爱的 Roblox 用户，{lineBreak}{lineBreak}很高兴你选择提供电子邮件地址以保护你的帐户“{username}”。{lineBreak}通过验证你 Roblox 帐户的关联电子邮件地址，你将得到更高级别的帐户安全保障。{lineBreak}请点按下面的链接以完成验证{lineBreak}{verificationLink}。\n";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "亲爱的 Roblox 用户，{lineBreak}{lineBreak}很高兴你选择提供电子邮件地址以保护你的帐户“{username}”。{lineBreak}通过验证你 Roblox 帐户的关联电子邮件地址，你将得到更高级别的帐户安全保障。{lineBreak}请点按下面的链接以完成验证{lineBreak}{verificationLink}。\n";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"您好，{lineBreak}{lineBreak}您的孩子已在 Roblox 上创建账户，用户名为“{username}”。Roblox 是一个网络娱乐平台，让孩子们可以在我们众多身临其境的 3D 世界中一起发挥想象力，享受游戏带来的乐趣。他们也可以使用我们开发的免费工具 Roblox Studio。无论是创作简单的模块，还是进阶到设计复杂的多人游戏，他们都能在这里尽情挥洒创意。无论是设计独一无二的主题乐园，以职业赛车手的身份竞技，成为 T 台上闪亮的明星，还是邀请朋友到自己的梦幻家园做客，目前，已经有数百万儿童通过 Roblox 实现了他们的创意。{lineBreak}{lineBreak}我们想让您知道，您的孩子已向我们提供了用户名、生日和家长的电子邮件地址。家长电子邮件将仅用于帐户管理、密码重置以及通知帐户使用权限更改等用途。请点按此按钮验证您的电子邮件地址：{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}关于 Roblox{lineBreak}{lineBreak}Roblox 致力打造一个适合全家老少的愉快环境。我们和数码安全专家协力，不断地增强我们的安全措施，确保所有玩家都能安心地一起游戏、聊天、合作。我们建议您访问以下的《家长指南》，让您能够更加熟悉我们的平台，并了解如何让您的孩子在 Roblox 上获得更好的体验：{parentalPageLink}{lineBreak}{lineBreak}Roblox 还提供家长控制功能。家长可以启用家长 PIN，更改孩子的通信和聊天设定。若要找到这些控制空能，您可以登录孩子的帐户，访问帐户设置中的安全和隐私标签。{lineBreak}{lineBreak}若要添加家长 PIN，请访问：{accountSecurityLink}{lineBreak}{lineBreak}若要更改聊天设置，请访问：{chatPrivacyLink} {lineBreak}{lineBreak}隐私{lineBreak}{lineBreak}若要移除您孩子的帐户，您可以前往此处联系客户服务：{supportPageLink}您的电子邮件不会用于其他用途；不会披露给第三方；也不会与您孩子的个人资料合并。如果需要更多信息，您可以访问此链接查看我们的隐私政策：{privacyPageLink}{lineBreak}{lineBreak}谢谢您，{lineBreak}{lineBreak}Roblox 团队{lineBreak}请勿直接回复此邮件。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "您好，{lineBreak}{lineBreak}您的孩子已在 Roblox 上创建账户，用户名为“{username}”。Roblox 是一个网络娱乐平台，让孩子们可以在我们众多身临其境的 3D 世界中一起发挥想象力，享受游戏带来的乐趣。他们也可以使用我们开发的免费工具 Roblox Studio。无论是创作简单的模块，还是进阶到设计复杂的多人游戏，他们都能在这里尽情挥洒创意。无论是设计独一无二的主题乐园，以职业赛车手的身份竞技，成为 T 台上闪亮的明星，还是邀请朋友到自己的梦幻家园做客，目前，已经有数百万儿童通过 Roblox 实现了他们的创意。{lineBreak}{lineBreak}我们想让您知道，您的孩子已向我们提供了用户名、生日和家长的电子邮件地址。家长电子邮件将仅用于帐户管理、密码重置以及通知帐户使用权限更改等用途。请点按此按钮验证您的电子邮件地址：{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}关于 Roblox{lineBreak}{lineBreak}Roblox 致力打造一个适合全家老少的愉快环境。我们和数码安全专家协力，不断地增强我们的安全措施，确保所有玩家都能安心地一起游戏、聊天、合作。我们建议您访问以下的《家长指南》，让您能够更加熟悉我们的平台，并了解如何让您的孩子在 Roblox 上获得更好的体验：{parentalPageLink}{lineBreak}{lineBreak}Roblox 还提供家长控制功能。家长可以启用家长 PIN，更改孩子的通信和聊天设定。若要找到这些控制空能，您可以登录孩子的帐户，访问帐户设置中的安全和隐私标签。{lineBreak}{lineBreak}若要添加家长 PIN，请访问：{accountSecurityLink}{lineBreak}{lineBreak}若要更改聊天设置，请访问：{chatPrivacyLink} {lineBreak}{lineBreak}隐私{lineBreak}{lineBreak}若要移除您孩子的帐户，您可以前往此处联系客户服务：{supportPageLink}您的电子邮件不会用于其他用途；不会披露给第三方；也不会与您孩子的个人资料合并。如果需要更多信息，您可以访问此链接查看我们的隐私政策：{privacyPageLink}{lineBreak}{lineBreak}谢谢您，{lineBreak}{lineBreak}Roblox 团队{lineBreak}请勿直接回复此邮件。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"若要更改聊天设置，请访问：{chatPrivacyLink}{lineBreak}{lineBreak}隐私{lineBreak}{lineBreak}若要移除您孩子的帐户，请访问此处联系客户服务：{supportPageLink}。您的电子邮件不会用于其他用途；不会披露给第三方；也不会与您孩子的个人资料合并。如需更多信息，请查阅我们的隐私政策：{privacyPageLink}。{lineBreak}{lineBreak}谢谢您，{lineBreak}{lineBreak}Roblox 团队{lineBreak}请勿直接回复此邮件。 {lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "若要更改聊天设置，请访问：{chatPrivacyLink}{lineBreak}{lineBreak}隐私{lineBreak}{lineBreak}若要移除您孩子的帐户，请访问此处联系客户服务：{supportPageLink}。您的电子邮件不会用于其他用途；不会披露给第三方；也不会与您孩子的个人资料合并。如需更多信息，请查阅我们的隐私政策：{privacyPageLink}。{lineBreak}{lineBreak}谢谢您，{lineBreak}{lineBreak}Roblox 团队{lineBreak}请勿直接回复此邮件。 {lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Roblox 电子邮件验证";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Roblox 帐户授权";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "自我介绍（限 1000 个字符以内）";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "例如：www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "例如：http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "例如：www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "例如：@Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "例如：www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "什么是帐户控制？";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "帐户信息";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "账单";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "已屏蔽用户";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "联系人设置";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "桌面推送";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "添加密码";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "添加手机";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "更改我的电子邮件";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "电子邮件地址已更改";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "更改密码";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "更改用户名";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "错误";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "编辑手机";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "资金不足";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "用户名无效";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "添加 PIN";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "需要帐户 PIN";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "移除手机";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "需要已验证的电子邮件";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "验证电子邮件";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "验证手机";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "快速追踪";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "会员状态";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "有下列情形时通知我";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "通知";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "有下列情形时通知我";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "桌面推送";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "移动推送";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "动态消息";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "动态消息";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "其他设置";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "我的设置";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "个人资料";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "帐户 PIN";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "隐私设置";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "续订日期";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "帐户限制";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "安全注销";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "社交网络";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "社交登录";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "帐户信息";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "账单";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "快速追踪";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "通知";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "隐私";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "安全";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "交易";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "两步验证";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "帐户 PIN 当前已停用";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "帐户 PIN 当前已启用";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "帐户限制当前已停用";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "帐户限制当前已启用";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "添加电子邮件";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "添加家长电子邮件";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "添加密码：";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "添加手机";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "添加手机";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "关于账单与付款问题：";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"关于账单与付款问题，请查看{aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}账单帮助页面{aTagEnd}。";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "关于账单与付款问题，请查看{aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}账单帮助页面{aTagEnd}。";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"尾号 {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "尾号 {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "费用";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "日期";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "描述";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "服务当前已停用，请稍后重试。";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "无交易";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "付款类型";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "生日";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"你还不是会员。马上加入{startSpan} Builders Club {endSpan}吧！";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "你还不是会员。马上加入{startSpan} Builders Club {endSpan}吧！";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "更改你的用户名";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "选择语言";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "关闭";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "连接帐户：";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "选择国家/地区";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "位置";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "黑色";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "添加我的电子邮件";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "添加家长电子邮件";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "手机号码";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "验证帐户密码";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "更改我的电子邮件";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "更改我的电子邮件";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "更改家长电子邮件";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "确认密码";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "当前密码";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "新密码";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "帐户密码";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "想使用的用户名（3-20 个字符）";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "确认你的 PIN";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"创建一个 {digitCount} 位 PIN";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "创建一个 {digitCount} 位 PIN";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "当前号码：";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "电子邮件地址已更改";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "需要电子邮件";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "已验证的电子邮件：";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "验证帐户密码";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"输入验证码（{digitCount} 位）";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "输入验证码（{digitCount} 位）";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "请输入我们刚发送至你手机的验证码";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "验证短信";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "自定义";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "默认";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "每个人";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "好友、我关注的用户和粉丝";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "好友和我关注的用户";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "好友";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "高";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "低";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "中";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "无";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "没有人";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "关闭";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "电子邮件地址：";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "家长电子邮件地址：";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "待处理验证";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "失效日期";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"失效日期：{startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "失效日期：{startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook：";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "准确性";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "所有人";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "月";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "年";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "统计信息";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "你";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "性别";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+：";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "白色";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "语言";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"{startSpan}Builders Club {endSpan}会员资格";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "{startSpan}Builders Club {endSpan}会员资格";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "你还不是会员。快来加入 Roblox Premium 吧！";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "我受邀进入 VIP 服务器";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "有人与我聊天";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "有人置顶了新游戏一起玩";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "分析报告现已可用";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "有人接受了我的好友请求";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "我收到好友请求";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "我收到更新通知";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "有人邀请我参加派对";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "有人加入我当前的派对";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "我收到私人信息";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "有人邀请我编辑游戏";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "密码：";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "手机号码：";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "分";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "剩余时间";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "秒";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "旧用户名：";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "隐私模式";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "续订日期";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"于 {startSpan}{expirationDate}{endSpan} 期间自动续订。";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "于 {startSpan}{expirationDate}{endSpan} 期间自动续订。";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount} Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount} Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "注销所有其他会话";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "可见对象：";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"使用“{socialUsername}”连接";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "使用“{socialUsername}”连接";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "主题";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "自定义 - 控制你自己的设置。默认 - 启用与好友聊天并发送信息等功能。关闭 - 停用聊天和发送信息功能。";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "设置已全部锁定。若要编辑，请使用 PIN 解锁";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "点按以锁定你的设置页面";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "点击此处了解更多信息";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "此设置决定此用户在 App 中及网络上可以聊天的对象（无法控制游戏中的聊天对象）。此设置也可阻止此用户在论坛和群组留言板上发帖。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "此设置决定此用户在游戏中可以聊天的对象。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "此设置决定谁可以通过你提供的手机号码找到你。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "此设置决定谁可以在 VIP 服务器中加入此用户 - VIP 服务器只能通过服务器主人的邀请才能加入。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "此设置决定谁能看到我在哪个游戏中，并加入我的服务器。选择“没有人”，表示没有人可以跟随我进入我的特定服务器，但我可以跟其他用户一起玩游戏。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "此设置决定谁可以向此用户的信息收件箱发送信息。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "这项设置决定谁可以看到你的道具。";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "交易品质过滤器";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter：";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "启用两步验证";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "需要已验证的电子邮件。";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "提高你的帐户安全性。当你从新设备登录时，需要输入验证码。";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "你的帐户已受到保护！";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "更新电子邮件";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "更新手机";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "使用设备语言";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "用户名：";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "已验证";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "验证";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "谁可以在 App 中与我聊天？";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "谁可以与我聊天？";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "谁可以通过我的手机号码找到我？";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "谁可以邀请我加入 VIP 服务器？";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "谁可以加入我？";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "谁可以向我发送消息？";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "谁可以看到我的道具？";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "谁可以与我交易？";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "已使用 Xbox 帐户连接";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube：";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Robux 余额不足";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "帐户已有 PIN 码。请尝试不同请求。";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "帐户已锁。在继续下一个动作之前，请先解锁帐户。";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "发生错误，请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "电子邮件已验证。";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "此功能当前已停用。请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "密码不正确。";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "电子邮件地址无效。";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "没有与此帐户关联的电子邮件。";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "PIN 已锁定。";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "这已经是当前的电子邮件。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "此邮件地址的关联帐户过多。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "尝试更新邮件的次数过多。请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "尝试发送验证邮件的次数过多。请稍后重试。";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "发生未知错误。";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "PIN 码不正确。";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "PIN 格式无效。";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "帐户中不存在 PIN 码。";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "帐户没有已验证的电子邮件。";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "系统错误。";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "请求次数过多，请稍后重试。";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "电子邮件已添加";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "你的电子邮件已验证！";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "此功能当前已停用。请稍后重试。";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "你的 Robux 余额不足，无法更改用户名。";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "电子邮件无效";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "你必须将电子邮件地址与你的帐户相关联";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "你的 Robux 不足，无法更改用户名。";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "PIN 已锁定。";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "这已经是当前已验证的电子邮件。";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "你的设置已更新。";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "此电子邮件地址的关联帐户过多。";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "尝试次数过多。请稍后重试。";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "发生未知错误。";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "你的密码不正确。";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "验证码无效。请查看你的手机并重试。";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "“谁可以与我交易“的设置应与”谁可以看到我的道具“相符，或比后者更严格。";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "需要验证码。请输入你的验证码。";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "将你的生日更改为 13 岁以下则无法还原。是否确定要继续？";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "若要更改生日，你必须先为你的 Roblox 帐户添加密码。";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "必须添加密码";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "将你的生日更改为 13 岁以下则无法还原。你的 Facebook 社交登录将被停用，你也将必须使用 Roblox 密码登录。";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "你当前的密码不正确，密码未更改。";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "密码不符";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "必须至少为 8 个字符";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "请输入用户名。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "用户名不适用于 Roblox。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "此用户名已被使用。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "已成功更改用户名。";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "加载国家列表时出错";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "运行货币服务时发生错误。请稍后重试。";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "发生错误，请稍后重试。";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "发生错误";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "保存成功！";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "断开你的 Xbox 帐户连接时发生错误，请稍后重试。";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "已发送验证电子邮件。";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "电子邮件地址无效";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "手机号码无效";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "按“发送”提交票单，或按”取消”以编辑用户名。用户名是非常重要的信息，有助于加快解决你的问题。";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "密码须至少包含 2 个数字、4 个字母、1 个符号，且至少为 8 个字符。";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "你的 PIN 现已设置好。你将需要先输入此 PIN，才能访问设置页面。";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "PIN 不匹配";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "注销所有其他会话时发生错误，请稍后重试。";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "你已注销所有其他会话。";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "如果关闭两步验证，那么下次当你从新设备登录时，你将只需要输入密码。是否确定？";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "两步验证已启用";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "你的帐户现已受到保护，目前无需任何下一步的操作。下次当你从新设备登录时，系统将会发送一个安全码。";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "我们已更新了你的道具隐私设置。道具与交易的设置须保持一致。";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "更新你的通知设置时发生错误，请稍后重试。";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "我们已更新了你的道具隐私设置。道具与交易的设置须保持一致。";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "验证码无效。请查看你的手机并重试。";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "警告";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "此功能当前已停用。请稍后重试。";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "发生错误。请重试。";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "你输入错误验证码的次数过多。";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "密码不正确。请检查你的密码并重试。";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "手机号码格式无效。请检查并重试。";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "手机已移除";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "手机已更新成功！";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "此号码已与另一帐户相关联。";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "请输入你的 PIN 以更改设置。";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "社交网络链接无效。";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "抱歉，你无法将你的年龄改为 13 岁以下。如果你未满 13 岁，请创建一个新帐户，联系技术支持以删除你的旧帐户。";
	}
}
