namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_pt_br : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "Carregar mais";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "Cancelar renovação";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "Adicionar e-mail";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "Adicionar telefone";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "Alterar e-mail";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "OK";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "Atualizar";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "OK";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "Comprar";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "Fechar";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "Editar telefone";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "Remover número de telefone";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "Comprar";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "Não";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "Adicionar";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "OK";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "Desbloquear";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "Remover";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Enviar";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "OK";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "Atualização";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "OK";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "Verificar e-mail";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "Tentar de novo";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "Verificar";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "Reenviar código";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "Sim";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "Esconder";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "Entrar";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "Juntar-se ao Builders Club";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Salvar";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "Exibir";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "Desconectar-se";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "Desconectar";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "OK";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "Desbloquear";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "Upgrade de assinatura";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "Você pode modificar restrições da conta e limitar o acesso às configurações de conta e conteúdo não verificado.";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "Redefinição de e-mail da conta Roblox";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Veja as notificações neste computador mesmo quando o Roblox estiver fechado.";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "Para ver as notificações, pode ser que seja solicitada a ativação das notificações push no seu navegador.";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "Notificações de desktop para este dispositivo.";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "Confirme o código do seu país e digite o seu número de telefone. Enviaremos uma mensagem de texto para completar a verificação. (Aviso: taxas de envio de mensagem de texto podem ser cobradas)";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "Um e-mail de verificação foi enviado";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "O e-mail da conta não mudará até que o novo seja verificado.";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "Você alterou sua senha com sucesso.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "Importante: a data de criação da conta original será transferida para seu novo nome de usuário.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "Altere o nome de usuário uma vez de graça.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "Publicações anteriores no fórum aparecerão com o seu nome de usuário antigo e NÃO serão transferidas para o novo.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "Alterar nome de usuário";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "O número de telefone não mudará até que o novo seja verificado.";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "Você precisa fornecer e validar o seu e-mail antes de poder alterar seu nome de usuário.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "Obrigado! Um e-mail de verificação foi enviado.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "Você precisa validar o seu e-mail antes de poder alterar seu nome de usuário.";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "Adicione uma senha para resguardar sua conta antes de se desconectar do Facebook.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "Você precisa fornecer e validar o seu e-mail antes de poder adicionar um PIN da conta.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "Você precisa fornecer e validar o seu e-mail antes de poder ativar a verificação de 2 passos.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "Você precisa fornecer e validar o seu e-mail antes de poder alterar seu nome de usuário.";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "Insira o PIN da conta anexado à sua conta";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "Você precisa validar o seu e-mail antes de poder adicionar um PIN da conta.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "Você precisa validar o seu e-mail antes de poder ativar a verificação de 2 passos.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "Você precisa validar o seu e-mail antes de poder alterar seu nome de usuário.";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "Você agora faz parte do programa de denúncia Avaliação Prioritária por fazer boas denúncias de abuso. Suas denúncias de abuso serão avaliadas com prioridade. Continue no programa fazendo boas denúncias de abuso. Obrigado por nos ajudar a tornar o Roblox uma experiência mais positiva!";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "Estatísticas";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "Não forneça detalhes que possam ser usados para identificar você fora do Roblox.";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "A Concordância representa quantas vezes os moderadores concordaram com as denúncias de abuso. Seu número será exibido depois que você enviar várias denúncias. ‘Todos' significa todos os membros do grupo de pessoas com Avaliação Prioritária.";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "Atualizar a idade para abaixo de 13 anos habilita o modo de privacidade.";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "Alterar senha";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "Alterar nome de usuário";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "Atualizar e-mail";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "Para dúvidas sobre cobrança e pagamento: info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "Você ainda não é um membro. Entre para o Builders Club hoje mesmo!";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "Você ainda não é um membro. Entre para o Roblox Premium hoje mesmo!";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "Veja as notificações nas telas iniciais dos seus dispositivos. Você pode ligá-las e desligá-las de dentro do app do Roblox.";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "Notificações de dispositivos móveis para este dispositivo.";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "Ver notificações no meu stream. Clique no ícone de notificações na barra superior para ver estas notificações.";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "Depois de desligar um tipo de notificação, você não receberá mais nenhuma mensagem daquele tipo.";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "Aviso: Se você quiser cancelar sua renovação de assinatura, conecte-se no website.";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "Salvo com sucesso!";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "Um e-mail verificado é obrigatório";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Alteração de nome de usuário";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Verificação de e-mail Roblox";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Autorização da conta Roblox";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "Descreva-se (limite de 1000 caracteres)";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "ex. www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "ex: http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "ex. www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "ex. @Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "ex. www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "O que são os controles de conta?";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "Informações da conta";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "Cobrança";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "Usuários bloqueados";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "Configurações de contato";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "Alerta de desktop";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "Adicionar senha";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "Adicionar telefone";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "Alterar meu e-mail";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "Endereço de e-mail alterado";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "Alterar senha";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "Sucesso";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "Sucesso";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "Alterar nome de usuário";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "Erro";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "Sucesso";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "Editar telefone";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "Fundos insuficientes";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Nome de usuário inválido";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "Adicionar PIN";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "Sucesso";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "PIN da conta obrigatório";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "Remover telefone";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "Um e-mail verificado é obrigatório";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "Verificar e-mail";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "Verificar telefone";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "Avaliação Prioritária";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "Status de membro";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "Avise-me quando";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "Notificações";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "Avise-me quando";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "Alerta de desktop";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "Alerta de dispositivo móvel";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "Stream de notificação";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "Stream de notificação";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "Outras configurações";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "Minhas configurações";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "Pessoal";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "PIN da conta";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "Configurações de privacidade";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "Data de renovação";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "Restrições da conta";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "Desconexão segura";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "Redes sociais";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "Conexão social";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "Sucesso";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "Informações da conta";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "Cobrança";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "Avaliação Prioritária";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "Notificações";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "Privacidade";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "Segurança";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "Transações";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "Verificação de 2 passos";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "PIN da conta desabilitado no momento";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "PIN da conta habilitado no momento";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "As restrições da conta estão desabilitadas no momento";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "As restrições da conta estão habilitadas no momento";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "Adicionar e-mail";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "Adicionar e-mail do responsável";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "Adicionar senha:";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "Adicionar telefone";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "Adicionar telefone";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "Para dúvidas sobre cobrança e pagamento:";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "Custo";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "Data";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "Descrição";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "Este serviço está desabilitado no momento. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "Sem transações";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "Tipo de pagamento";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "Data de nascimento";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "Alterar seu nome de usuário";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "Escolher idioma";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "Desligado";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "Conectar conta:";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "Escolha um país/região";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "Local";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "Escuro";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "Adicionar meu e-mail";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "Adicionar e-mail do responsável";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "Número de telefone";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "Verificar senha da conta";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "Alterar meu e-mail";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "Alterar meu e-mail";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "Alterar e-mail do responsável";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "Confirmar senha";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "Senha atual";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "Nova senha";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "Senha da conta";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "Nome de usuário desejado (3-20 caracteres)";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "Confirmar seu PIN";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "Número atual:";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "Endereço de e-mail alterado";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "E-mail obrigatório";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "E-mail verificado:";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "Verificar senha da conta";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "Insira o código que enviamos para o seu telefone";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "Verificar SMS";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "Personalizado";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "Padrão";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "Todos";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "Amigos, usuários que sigo e seguidores";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "Amigos e usuários que sigo";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "Amigos";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "Alto";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "Baixo";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "Médio";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "Ninguém";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "Ninguém";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "Desligado";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "Endereço de e-mail:";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "Endereço de e-mail do responsável:";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "Verificação pendente";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "Data de expiração";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook:";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "Concordância";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "Todos";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "Mês";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "Ano";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "Estatísticas";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "Você";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "Gênero";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+:";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "Claro";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "Idioma";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "Você ainda não é um membro. Entre para o Roblox Premium hoje mesmo!";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "Alguém me convida para um servidor VIP";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "Alguém fala comigo no chat";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "Alguém marca um novo jogo para jogar junto";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "O relatório analítico fica disponível";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "Alguém aceita minha solicitação de amizade";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "Recebo uma solicitação de amizade";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "Recebo notificações de atualização";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "Alguém me convida para um time";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "Alguém entra no meu time";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "Recebo uma mensagem privada";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "Alguém me convida para editar um jogo";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "Senha:";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "Número de telefone:";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "min";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "Tempo restante";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "s";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "Nomes de usuário anteriores:";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "Modo de privacidade";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "Data de renovação";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "Encerrar todas as outras sessões";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "Visível para:";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "Tema";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "Personalizado - Controle suas próprias configurações. Padrão - Habilita chat e mensagens com amigos. Desligado - Desabilita chat e mensagens.";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "Todas as configurações estão bloqueadas. Para editar, desbloqueie com seu PIN.";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "Clique para desbloquear sua página de Configurações";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "Clique aqui para mais informações";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "Esta configuração controla com quem este usuário pode falar no chat no app e na web (no jogo é separado). Ela também permite impedir que este usuário publique em fóruns e murais de grupos.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "Esta configuração controla com quem este usuário pode falar no chat no jogo.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "Esta configuração controla quem pode encontrar você usando o número de telefone que você forneceu.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "Esta configuração controla quem pode entrar nos servidores VIP deste usuário, servidores estes que só podem ser acessados com um convite do dono.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "Esta configuração controla quem pode ver o jogo que estou jogando e entrar no meu servidor. Selecionar ninguém faz com que ninguém possa me seguir no meu servidor específico, mas ainda assim poderei jogar com outros usuários.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "Esta configuração controla de quem este usuário pode receber mensagens em sua caixa de entrada.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "Esta configuração controla quem pode ver o seu inventário.";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "Filtro de qualidade de troca";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter:";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "Habilitar verificação de 2 passos";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "Um e-mail verificado é obrigatório.";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "Melhore a segurança da sua conta. Um código será obrigatório quando você se conectar com um outro dispositivo.";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "Sua conta está protegida!";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "Atualizar e-mail";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "Atualizar telefone";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "Usar idioma do dispositivo";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "Nome de usuário:";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "Verificado";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "Verificar";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "Quem pode falar no chat do app comigo?";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "Quem pode falar no chat comigo?";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "Quem pode me encontrar pelo meu número de telefone?";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "Quem pode me convidar para servidores VIP?";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "Quem pode entrar no meu jogo?";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "Quem pode me enviar mensagens?";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "Quem pode ver meu inventário?";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "Quem pode trocar comigo?";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "Conectado com uma conta Xbox";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube:";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Robux insuficientes";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "Esta conta já têm um PIN. Tente uma solicitação diferente.";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "Esta conta está bloqueada. Desbloqueie a conta antes de realizar esta ação.";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "Algo deu errado. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "O e-mail já foi verificado.";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "Esta funcionalidade está desabilitada no momento. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "Senha incorreta.";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "Endereço de e-mail inválido.";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "Nenhum endereço de e-mail associado à esta conta.";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "PIN bloqueado.";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "Este é o e-mail atual.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "Existem muitas contas associadas a este endereço de e-mail.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "Foram feitas muitas tentativas para atualizar o e-mail. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "Foram feitas muitas tentativas de verificação de e-mail. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "Ocorreu um erro desconhecido.";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "PIN incorreto.";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "Formato de PIN inválido.";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "Não existe um PIN para esta conta.";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "Esta conta não tem um e-mail verificado.";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "Erro do sistema.";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "Foram feitas muitas tentativas. Tente novamente mais tarde.";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "E-mail adicionado";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "Seu e-mail já foi verificado!";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "Esta funcionalidade está desabilitada no momento. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "Você não tem Robux suficientes para alterar seu nome de usuário.";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "E-mail inválido";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "Você precisa associar um endereço de e-mail à sua conta.";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "Você não tem Robux suficientes para alterar seu nome de usuário.";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "PIN bloqueado.";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "Este já é o e-mail verificado atual.";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "Suas configurações foram atualizadas.";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "Contas demais estão associadas a este endereço de e-mail.";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "Tentativas excessivas. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "Um erro desconhecido ocorreu.";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "Sua senha está incorreta.";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "Código inválido. Confira seu telefone e tente novamente.";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "O valor para \"Quem pode trocar comigo\" deve ser o mesmo ou com mais restrições do que o valor para \"Quem pode ver meu inventário\".";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "Código obrigatório. Insira seu código.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "Alterar sua data de nascimento para menos de 13 anos não pode ser desfeito. Quer mesmo continuar?";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "Você precisa adicionar uma senha à sua conta Roblox para alterar sua data de nascimento.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "É preciso adicionar senha";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "Alterar a sua data de nascimento para menos de 13 anos não pode ser desfeito. Sua conexão social do Facebook será desabilitada e você terá que usar sua conta Roblox.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "Sua senha atual está incorreta. A senha não foi alterada.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "As senhas não conferem";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "Deve conter pelo menos 8 caracteres";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "Insira um nome de usuário.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "Nome de usuário inapropriado para Roblox.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "Este nome de usuário já está sendo usado.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "Nome de usuário alterado com sucesso.";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "Erro ao carregar lista de países";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "Ocorreu um erro no serviço de moeda. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "Algo deu errado. Tente de novo.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "Ocorreu um erro";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "Salvo com sucesso!";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "Ocorreu um erro ao tentar desconectar sua conta Xbox. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "Um e-mail de verificação foi enviado.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "Endereço de e-mail inválido";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "Número de telefone inválido";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Aperte Enviar para enviar a solicitação ou Cancelar para editar o nome de usuário. O nome de usuário é uma informação muito importante e pode ajudar a resolver seu problema mais rápido.";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "A senha deve conter pelo menos 2 dígitos, 4 letras, 1 símbolo e ter pelo menos 8 caracteres.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "Seu PIN foi definido. Você precisa inserir este PIN antes de acessar a página de Configurações no futuro.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "PINs não conferem";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "Ocorreu um erro ao tentar encerrar todas as outras sessões. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "Você foi desconectado de todas as outras sessões.";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "Se você desligar a verificação de 2 passos, só a sua senha será necessária para se conectar em um novo dispositivo. Tem certeza?";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "Verificação de 2 passos habilitada";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "Sua conta está agora protegida! Mais nenhuma ação é necessária no momento. Um código de segurança será enviado na próxima vez que você se conectar em um novo dispositivo.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "Atualizamos as configurações de privacidade de seu inventário. As configurações de troca e inventário devem ser consistentes.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "Ocorreu um erro ao tentar atualizar suas configurações de notificação. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "Atualizamos as configurações de privacidade de seu inventário. As configurações de troca e inventário devem ser consistentes.";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "Código inválido. Confira seu telefone e tente novamente.";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "Aviso";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "Esta funcionalidade está desabilitada no momento. Tente de novo mais tarde.";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "Ocorreu um erro. Tente novamente.";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "Você inseriu o código incorreto um número excessivo de vezes.";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "Senha inválida. Confira sua senha e tente novamente.";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "Formato de número de telefone inválido. Confira e tente novamente.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "Telefone removido";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "Telefone atualizado com sucesso!";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "O número já está associado a outra conta.";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "Insira seu PIN para alterar suas configurações.";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "O link da rede social não é válido.";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "Lamentamos, mas você não pode alterar sua idade para menos de 13 anos. Se você tiver menos de 13 anos, crie uma nova conta e entre em contato com o suporte para excluir sua conta antiga.";

	public AccountSettingsResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "Carregar mais";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "Cancelar renovação";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "Adicionar e-mail";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "Adicionar telefone";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "Alterar e-mail";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "Atualizar";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "Fechar";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "Editar telefone";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "Remover número de telefone";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "Não";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "Adicionar";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "Remover";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Enviar";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "Atualização";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "Verificar e-mail";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "Tentar de novo";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "Verificar";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "Reenviar código";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "Sim";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "Esconder";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "Entrar";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "Juntar-se ao Builders Club";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Salvar";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "Exibir";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "Desconectar-se";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "Desconectar";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "Upgrade de assinatura";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "Você pode modificar restrições da conta e limitar o acesso às configurações de conta e conteúdo não verificado.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Redefinir e-mail Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}Redefinir e-mail Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"Prezado usuário Roblox,{lineBreak}{lineBreak}Notamos que você alterou o endereço de e-mail da conta de {username} de {oldEmailAddress} para {newEmailAddress}. Caso você ou alguém tenha alterado este endereço de e-mail por acidente, clique neste link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}para voltar para o endereço de e-mail anterior. Você também deve alterar sua senha, desta forma teremos certeza que sua conta está segura.{lineBreak}{lineBreak}Caso esteja satisfeito com o novo endereço de e-mail de sua conta Roblox, nenhuma ação é necessária, já está tudo pronto!{lineBreak}{lineBreak}Não responda esta mensagem. Em caso de dúvidas, envie um e-mail para {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "Prezado usuário Roblox,{lineBreak}{lineBreak}Notamos que você alterou o endereço de e-mail da conta de {username} de {oldEmailAddress} para {newEmailAddress}. Caso você ou alguém tenha alterado este endereço de e-mail por acidente, clique neste link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}para voltar para o endereço de e-mail anterior. Você também deve alterar sua senha, desta forma teremos certeza que sua conta está segura.{lineBreak}{lineBreak}Caso esteja satisfeito com o novo endereço de e-mail de sua conta Roblox, nenhuma ação é necessária, já está tudo pronto!{lineBreak}{lineBreak}Não responda esta mensagem. Em caso de dúvidas, envie um e-mail para {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"Prezado usuário Roblox,{lineBreak}{lineBreak}Notamos que você alterou o endereço de e-mail da conta de {username} de {oldEmailAddress} para {newEmailAddress}. Caso você ou alguém tenha alterado este endereço de e-mail por acidente, clique neste link{lineBreak}{revertAccountEmailLink}{lineBreak}para voltar para o endereço de e-mail anterior. Você também deve alterar sua senha, desta forma teremos certeza que sua conta está segura.{lineBreak}{lineBreak}Caso esteja satisfeito com o novo endereço de e-mail de sua conta Roblox, nenhuma ação é necessária, já está tudo pronto!{lineBreak}Não responda esta mensagem. Em caso de dúvidas, envie um e-mail para {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "Prezado usuário Roblox,{lineBreak}{lineBreak}Notamos que você alterou o endereço de e-mail da conta de {username} de {oldEmailAddress} para {newEmailAddress}. Caso você ou alguém tenha alterado este endereço de e-mail por acidente, clique neste link{lineBreak}{revertAccountEmailLink}{lineBreak}para voltar para o endereço de e-mail anterior. Você também deve alterar sua senha, desta forma teremos certeza que sua conta está segura.{lineBreak}{lineBreak}Caso esteja satisfeito com o novo endereço de e-mail de sua conta Roblox, nenhuma ação é necessária, já está tudo pronto!{lineBreak}Não responda esta mensagem. Em caso de dúvidas, envie um e-mail para {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "Redefinição de e-mail da conta Roblox";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"Esta conta só pode acessar nosso conteúdo verificado na plataforma. Além disso, as configurações de contato (na página de {linkStart}Privacidade{linkEnd}) serão Desligadas.";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "Esta conta só pode acessar nosso conteúdo verificado na plataforma. Além disso, as configurações de contato (na página de {linkStart}Privacidade{linkEnd}) serão Desligadas.";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"Você está bloqueando {totalBlockedCount} de {maxBlockedCount} usuários permitidos:";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "Você está bloqueando {totalBlockedCount} de {maxBlockedCount} usuários permitidos:";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"As configurações de contato ficam travadas pois as restrições da conta (na página de {linkStart}Segurança{linkEnd}) estão habilitadas.";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "As configurações de contato ficam travadas pois as restrições da conta (na página de {linkStart}Segurança{linkEnd}) estão habilitadas.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Veja as notificações neste computador mesmo quando o Roblox estiver fechado.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "Para ver as notificações, pode ser que seja solicitada a ativação das notificações push no seu navegador.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "Notificações de desktop para este dispositivo.";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "Confirme o código do seu país e digite o seu número de telefone. Enviaremos uma mensagem de texto para completar a verificação. (Aviso: taxas de envio de mensagem de texto podem ser cobradas)";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "Um e-mail de verificação foi enviado";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "O e-mail da conta não mudará até que o novo seja verificado.";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "Você alterou sua senha com sucesso.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "Importante: a data de criação da conta original será transferida para seu novo nome de usuário.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "Altere o nome de usuário uma vez de graça.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "Publicações anteriores no fórum aparecerão com o seu nome de usuário antigo e NÃO serão transferidas para o novo.";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"Alterar nome de usuário por {robuxIcon} {price}?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "Alterar nome de usuário por {robuxIcon} {price}?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "Alterar nome de usuário";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "O número de telefone não mudará até que o novo seja verificado.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "Você precisa fornecer e validar o seu e-mail antes de poder alterar seu nome de usuário.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "Obrigado! Um e-mail de verificação foi enviado.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "Você precisa validar o seu e-mail antes de poder alterar seu nome de usuário.";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "Adicione uma senha para resguardar sua conta antes de se desconectar do Facebook.";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"Você precisa de mais {robuxToBuy} para alterar seu nome de usuário. Deseja comprar mais Robux?";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "Você precisa de mais {robuxToBuy} para alterar seu nome de usuário. Deseja comprar mais Robux?";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "Você precisa fornecer e validar o seu e-mail antes de poder adicionar um PIN da conta.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "Você precisa fornecer e validar o seu e-mail antes de poder ativar a verificação de 2 passos.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "Você precisa fornecer e validar o seu e-mail antes de poder alterar seu nome de usuário.";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "Insira o PIN da conta anexado à sua conta";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"Quer mesmo remover seu número de telefone terminado em {phoneLast4}?";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "Quer mesmo remover seu número de telefone terminado em {phoneLast4}?";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "Você precisa validar o seu e-mail antes de poder adicionar um PIN da conta.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "Você precisa validar o seu e-mail antes de poder ativar a verificação de 2 passos.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "Você precisa validar o seu e-mail antes de poder alterar seu nome de usuário.";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "Você agora faz parte do programa de denúncia Avaliação Prioritária por fazer boas denúncias de abuso. Suas denúncias de abuso serão avaliadas com prioridade. Continue no programa fazendo boas denúncias de abuso. Obrigado por nos ajudar a tornar o Roblox uma experiência mais positiva!";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "Estatísticas";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "Não forneça detalhes que possam ser usados para identificar você fora do Roblox.";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "A Concordância representa quantas vezes os moderadores concordaram com as denúncias de abuso. Seu número será exibido depois que você enviar várias denúncias. ‘Todos' significa todos os membros do grupo de pessoas com Avaliação Prioritária.";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "Atualizar a idade para abaixo de 13 anos habilita o modo de privacidade.";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "Alterar senha";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "Alterar nome de usuário";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "Atualizar e-mail";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "Para dúvidas sobre cobrança e pagamento: info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "Você ainda não é um membro. Entre para o Builders Club hoje mesmo!";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "Você ainda não é um membro. Entre para o Roblox Premium hoje mesmo!";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "Veja as notificações nas telas iniciais dos seus dispositivos. Você pode ligá-las e desligá-las de dentro do app do Roblox.";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "Notificações de dispositivos móveis para este dispositivo.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "Ver notificações no meu stream. Clique no ícone de notificações na barra superior para ver estas notificações.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "Depois de desligar um tipo de notificação, você não receberá mais nenhuma mensagem daquele tipo.";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "Aviso: Se você quiser cancelar sua renovação de assinatura, conecte-se no website.";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "Salvo com sucesso!";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "Um e-mail verificado é obrigatório";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"Quando você se conecta de um novo dispositivo, os códigos serão enviados para {email}.";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "Quando você se conecta de um novo dispositivo, os códigos serão enviados para {email}.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"Olá, usuário Roblox, {lineBreaks}Seu nome de usuário foi alterado recentemente de {oldUsername} para {newUsername}. Se você não solicitou essa mudança, envie um e-mail para {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "Olá, usuário Roblox, {lineBreaks}Seu nome de usuário foi alterado recentemente de {oldUsername} para {newUsername}. Se você não solicitou essa mudança, envie um e-mail para {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Alteração de nome de usuário{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Alteração de nome de usuário{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Alteração de nome de usuário";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Verificação de e-mail Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Verificação de e-mail Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Autorização da conta Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Autorização da conta Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"Caro usuário Roblox,{lineBreak}{lineBreak}Estamos contentes por você ter decidido resguardar sua conta {username} fornecendo um endereço de e-mail.{lineBreak}Ao verificar o endereço de e-mail associado com sua conta Roblox, você permite um nível mais alto de segurança de conta.{lineBreak}Clique no botão abaixo para completar o processo de verificação.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verificar e-mail{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "Caro usuário Roblox,{lineBreak}{lineBreak}Estamos contentes por você ter decidido resguardar sua conta {username} fornecendo um endereço de e-mail.{lineBreak}Ao verificar o endereço de e-mail associado com sua conta Roblox, você permite um nível mais alto de segurança de conta.{lineBreak}Clique no botão abaixo para completar o processo de verificação.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verificar e-mail{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Olá,{lineBreak}{lineBreak}Seu filho ou filha criou a conta {boldTagStart}{username}{boldTagEnd} no Roblox, uma plataforma de entretenimento online que permite que crianças imaginem, criem e joguem juntas em mundos 3D imersivos gerados por usuários. Nossa plataforma também oferece uma ferramenta de desenvolvimento grátis chamada “Roblox Studio”, que permite que usuários criem qualquer coisa que imaginarem, de construções com simples comandos de arrastar e largar a jogos multijogador complexos. Milhões de crianças já usaram o Roblox para viver a experiência de criar o parque temático perfeito, competir como um piloto profissional, estrelar em um desfile de moda, ou simplesmente construir a casa dos sonhos para compartilhar com os amigos.{lineBreak}{lineBreak}Este e-mail serve para informar a você que seu filho ou filha nos forneceu um nome de usuário, data de nascimento e endereço de e-mail do responsável. O endereço de e-mail do responsável só será usado para gerenciamento de conta, reinício de senha, no caso de a criança esquecê-lo, e para notificar os responsáveis sobre mudanças no acesso da conta de seu filho ou filha. Para verificar seu endereço de e-mail, clique no botão abaixo: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verificar e-mail{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Sobre o Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox se dedica a construir um ambiente agradável para todas as idades. Estamos sempre evoluindo nossas funcionalidades de segurança e trabalhando ao lado de peritos em segurança para garantir que todos os jogadores tenham um local protegido e confortável para jogar, conversar e colaborar em projetos criativos. Recomendamos que você visite nosso Guia do Responsável para se familiarizar com nossa plataforma e encontrar dicas úteis para criar uma experiência positiva para seus filhos no Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox também oferece {boldTagStart}controles dos responsáveis{boldTagEnd}. Os responsáveis podem habilitar um código PIN e alterar as configurações de comunicação e chat da criança. Você pode encontrar esses controles visitando as abas de segurança e privacidade nas configurações da conta enquanto estiver conectado na conta da criança.{lineBreak}{lineBreak}Para adicionar um código PIN de responsável, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para alterar as configurações de chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidade{boldTagEnd}{lineBreak}{lineBreak}Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Seu e-mail não será usado para nenhum outro propósito, revelado a terceiros ou combinado com quaisquer dados ou informações pessoais coletadas do menor de idade. Revise nossa política de privacidade para mais informações em {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox {lineBreak}{lineBreak} Não responda a esse e-mail diretamente. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "Olá,{lineBreak}{lineBreak}Seu filho ou filha criou a conta {boldTagStart}{username}{boldTagEnd} no Roblox, uma plataforma de entretenimento online que permite que crianças imaginem, criem e joguem juntas em mundos 3D imersivos gerados por usuários. Nossa plataforma também oferece uma ferramenta de desenvolvimento grátis chamada “Roblox Studio”, que permite que usuários criem qualquer coisa que imaginarem, de construções com simples comandos de arrastar e largar a jogos multijogador complexos. Milhões de crianças já usaram o Roblox para viver a experiência de criar o parque temático perfeito, competir como um piloto profissional, estrelar em um desfile de moda, ou simplesmente construir a casa dos sonhos para compartilhar com os amigos.{lineBreak}{lineBreak}Este e-mail serve para informar a você que seu filho ou filha nos forneceu um nome de usuário, data de nascimento e endereço de e-mail do responsável. O endereço de e-mail do responsável só será usado para gerenciamento de conta, reinício de senha, no caso de a criança esquecê-lo, e para notificar os responsáveis sobre mudanças no acesso da conta de seu filho ou filha. Para verificar seu endereço de e-mail, clique no botão abaixo: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verificar e-mail{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Sobre o Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox se dedica a construir um ambiente agradável para todas as idades. Estamos sempre evoluindo nossas funcionalidades de segurança e trabalhando ao lado de peritos em segurança para garantir que todos os jogadores tenham um local protegido e confortável para jogar, conversar e colaborar em projetos criativos. Recomendamos que você visite nosso Guia do Responsável para se familiarizar com nossa plataforma e encontrar dicas úteis para criar uma experiência positiva para seus filhos no Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox também oferece {boldTagStart}controles dos responsáveis{boldTagEnd}. Os responsáveis podem habilitar um código PIN e alterar as configurações de comunicação e chat da criança. Você pode encontrar esses controles visitando as abas de segurança e privacidade nas configurações da conta enquanto estiver conectado na conta da criança.{lineBreak}{lineBreak}Para adicionar um código PIN de responsável, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para alterar as configurações de chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidade{boldTagEnd}{lineBreak}{lineBreak}Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Seu e-mail não será usado para nenhum outro propósito, revelado a terceiros ou combinado com quaisquer dados ou informações pessoais coletadas do menor de idade. Revise nossa política de privacidade para mais informações em {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox {lineBreak}{lineBreak} Não responda a esse e-mail diretamente. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Você pode encontrar esses controles visitando as abas de segurança e privacidade nas configurações da conta enquanto estiver conectado na conta da criança.{lineBreak}{lineBreak}Para adicionar um código PIN de responsável, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para alterar as configurações de chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidade{boldTagEnd}{lineBreak}{lineBreak}Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Seu e-mail não será usado para outros propósitos, divulgado para terceiros ou combinado com quaisquer outras informações coletadas do seu filho ou filha. Consulte a Política de Privacidade para mais informações em {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox {lineBreak}{lineBreak} Não responda a este e-mail diretamente. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "Você pode encontrar esses controles visitando as abas de segurança e privacidade nas configurações da conta enquanto estiver conectado na conta da criança.{lineBreak}{lineBreak}Para adicionar um código PIN de responsável, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para alterar as configurações de chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidade{boldTagEnd}{lineBreak}{lineBreak}Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Seu e-mail não será usado para outros propósitos, divulgado para terceiros ou combinado com quaisquer outras informações coletadas do seu filho ou filha. Consulte a Política de Privacidade para mais informações em {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox {lineBreak}{lineBreak} Não responda a este e-mail diretamente. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"Caro usuário Roblox,{lineBreak}{lineBreak}Estamos felizes por você ter decidido resguardar sua conta {username} fornecendo um endereço de e-mail.{lineBreak}Ao verificar o endereço de e-mail associado com sua conta Roblox, você permite um nível mais alto de segurança de conta.{lineBreak}Clique no link abaixo para completar o processo de verificação{lineBreak}{verificationLink}.\n";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "Caro usuário Roblox,{lineBreak}{lineBreak}Estamos felizes por você ter decidido resguardar sua conta {username} fornecendo um endereço de e-mail.{lineBreak}Ao verificar o endereço de e-mail associado com sua conta Roblox, você permite um nível mais alto de segurança de conta.{lineBreak}Clique no link abaixo para completar o processo de verificação{lineBreak}{verificationLink}.\n";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Olá,{lineBreak}{lineBreak}Seu filho ou filha criou a conta {username} no Roblox, uma plataforma de entretenimento online que permite que crianças imaginem, criem e joguem juntas em mundos 3D imersivos gerados por usuários. Nossa plataforma também oferece uma ferramenta de desenvolvimento grátis chamada “Roblox Studio”, que permite que usuários criem qualquer coisa que imaginarem, de construções com simples comandos de arrastar e largar a jogos multijogador complexos. Milhões de crianças já usaram o Roblox para viver a experiência de criar o parque temático perfeito, competir como um piloto profissional, estrelar em um desfile de moda, ou simplesmente construir a casa dos sonhos para compartilhar com os amigos.{lineBreak}{lineBreak}Este e-mail serve para informar a você que seu filho ou filha nos forneceu um nome de usuário, data de nascimento e endereço de e-mail do responsável. O endereço de e-mail do responsável só será usado para gerenciamento de conta, reinício de senha, no caso de a criança esquecê-lo, e para notificar os responsáveis sobre mudanças no acesso da conta de seu filho ou filha. Para verificar seu endereço de e-mail, clique no botão abaixo:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Sobre o Roblox{lineBreak}{lineBreak}Roblox se dedica a construir um ambiente agradável para todas as idades. Estamos sempre evoluindo nossas funcionalidades de segurança e trabalhando ao lado de peritos em segurança para garantir que todos os jogadores tenham um local protegido e confortável para jogar, conversar e colaborar em projetos criativos. Recomendamos que você visite nosso Guia do Responsável para se familiarizar com nossa plataforma e encontrar dicas úteis para criar uma experiência positiva para seus filhos no Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox também oferece controles dos responsáveis. Os responsáveis podem habilitar um código PIN e alterar as configurações de comunicação e chat da criança. Você pode encontrar esses controles visitando as abas de segurança e privacidade nas configurações da conta enquanto estiver conectado na conta da criança.{lineBreak}{lineBreak}Para adicionar um código PIN de responsável, visite: {accountSecurityLink}{lineBreak}{lineBreak}Para alterar as configurações de chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidade{lineBreak}{lineBreak} Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {supportPageLink}. Seu e-mail não será usado para nenhum outro propósito, revelado a terceiros ou combinado com quaisquer dados ou informações pessoais coletadas do menor de idade. Revise nossa política de privacidade para mais informações em {privacyPageLink}.{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox{lineBreak}Não responda a esse e-mail diretamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "Olá,{lineBreak}{lineBreak}Seu filho ou filha criou a conta {username} no Roblox, uma plataforma de entretenimento online que permite que crianças imaginem, criem e joguem juntas em mundos 3D imersivos gerados por usuários. Nossa plataforma também oferece uma ferramenta de desenvolvimento grátis chamada “Roblox Studio”, que permite que usuários criem qualquer coisa que imaginarem, de construções com simples comandos de arrastar e largar a jogos multijogador complexos. Milhões de crianças já usaram o Roblox para viver a experiência de criar o parque temático perfeito, competir como um piloto profissional, estrelar em um desfile de moda, ou simplesmente construir a casa dos sonhos para compartilhar com os amigos.{lineBreak}{lineBreak}Este e-mail serve para informar a você que seu filho ou filha nos forneceu um nome de usuário, data de nascimento e endereço de e-mail do responsável. O endereço de e-mail do responsável só será usado para gerenciamento de conta, reinício de senha, no caso de a criança esquecê-lo, e para notificar os responsáveis sobre mudanças no acesso da conta de seu filho ou filha. Para verificar seu endereço de e-mail, clique no botão abaixo:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Sobre o Roblox{lineBreak}{lineBreak}Roblox se dedica a construir um ambiente agradável para todas as idades. Estamos sempre evoluindo nossas funcionalidades de segurança e trabalhando ao lado de peritos em segurança para garantir que todos os jogadores tenham um local protegido e confortável para jogar, conversar e colaborar em projetos criativos. Recomendamos que você visite nosso Guia do Responsável para se familiarizar com nossa plataforma e encontrar dicas úteis para criar uma experiência positiva para seus filhos no Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox também oferece controles dos responsáveis. Os responsáveis podem habilitar um código PIN e alterar as configurações de comunicação e chat da criança. Você pode encontrar esses controles visitando as abas de segurança e privacidade nas configurações da conta enquanto estiver conectado na conta da criança.{lineBreak}{lineBreak}Para adicionar um código PIN de responsável, visite: {accountSecurityLink}{lineBreak}{lineBreak}Para alterar as configurações de chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidade{lineBreak}{lineBreak} Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {supportPageLink}. Seu e-mail não será usado para nenhum outro propósito, revelado a terceiros ou combinado com quaisquer dados ou informações pessoais coletadas do menor de idade. Revise nossa política de privacidade para mais informações em {privacyPageLink}.{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox{lineBreak}Não responda a esse e-mail diretamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Para alterar as configurações de chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidade{lineBreak}{lineBreak} Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {supportPageLink}. Seu e-mail não será usado para outros propósitos, divulgado para terceiros ou combinado com quaisquer outras informações coletadas do seu filho ou filha. Consulte a política de Privacidade para mais informações em {privacyPageLink}.{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox{lineBreak}Não responda a este e-mail diretamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "Para alterar as configurações de chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidade{lineBreak}{lineBreak} Você pode remover a conta do seu filho ou filha contatando o serviço ao cliente em {supportPageLink}. Seu e-mail não será usado para outros propósitos, divulgado para terceiros ou combinado com quaisquer outras informações coletadas do seu filho ou filha. Consulte a política de Privacidade para mais informações em {privacyPageLink}.{lineBreak}{lineBreak}Obrigado,{lineBreak}{lineBreak}A equipe Roblox{lineBreak}Não responda a este e-mail diretamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Verificação de e-mail Roblox";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Autorização da conta Roblox";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "Descreva-se (limite de 1000 caracteres)";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "ex. www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "ex: http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "ex. www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "ex. @Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "ex. www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "O que são os controles de conta?";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "Informações da conta";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "Cobrança";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "Usuários bloqueados";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "Configurações de contato";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "Alerta de desktop";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "Adicionar senha";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "Adicionar telefone";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "Alterar meu e-mail";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "Endereço de e-mail alterado";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "Alterar senha";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "Sucesso";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "Sucesso";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "Alterar nome de usuário";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "Erro";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "Sucesso";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "Editar telefone";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "Fundos insuficientes";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Nome de usuário inválido";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "Adicionar PIN";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "Sucesso";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "PIN da conta obrigatório";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "Remover telefone";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "Um e-mail verificado é obrigatório";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "Verificar e-mail";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "Verificar telefone";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "Avaliação Prioritária";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "Status de membro";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "Avise-me quando";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "Notificações";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "Avise-me quando";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "Alerta de desktop";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "Alerta de dispositivo móvel";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "Stream de notificação";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "Stream de notificação";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "Outras configurações";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Minhas configurações";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "Pessoal";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "PIN da conta";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "Configurações de privacidade";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "Data de renovação";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "Restrições da conta";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "Desconexão segura";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "Redes sociais";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "Conexão social";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "Sucesso";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "Informações da conta";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "Cobrança";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "Avaliação Prioritária";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "Notificações";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "Privacidade";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "Segurança";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "Transações";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "Verificação de 2 passos";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "PIN da conta desabilitado no momento";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "PIN da conta habilitado no momento";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "As restrições da conta estão desabilitadas no momento";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "As restrições da conta estão habilitadas no momento";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "Adicionar e-mail";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "Adicionar e-mail do responsável";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "Adicionar senha:";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "Adicionar telefone";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "Adicionar telefone";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "Para dúvidas sobre cobrança e pagamento:";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"Para dúvidas sobre cobrança e pagamento, confira as {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}páginas de ajuda de cobrança{aTagEnd}.";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "Para dúvidas sobre cobrança e pagamento, confira as {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}páginas de ajuda de cobrança{aTagEnd}.";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"Terminando em {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "Terminando em {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "Custo";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "Data";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "Descrição";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "Este serviço está desabilitado no momento. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "Sem transações";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "Tipo de pagamento";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "Data de nascimento";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"Você ainda não é um membro. Entre para o {startSpan}Builders Club{endSpan} hoje mesmo!";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "Você ainda não é um membro. Entre para o {startSpan}Builders Club{endSpan} hoje mesmo!";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "Alterar seu nome de usuário";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "Escolher idioma";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "Desligado";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "Conectar conta:";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "Escolha um país/região";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "Local";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "Escuro";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "Adicionar meu e-mail";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "Adicionar e-mail do responsável";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "Número de telefone";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "Verificar senha da conta";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "Alterar meu e-mail";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "Alterar meu e-mail";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "Alterar e-mail do responsável";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "Confirmar senha";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "Senha atual";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "Nova senha";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "Senha da conta";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "Nome de usuário desejado (3-20 caracteres)";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "Confirmar seu PIN";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"Criar um PIN de {digitCount} dígitos";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "Criar um PIN de {digitCount} dígitos";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "Número atual:";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "Endereço de e-mail alterado";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "E-mail obrigatório";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "E-mail verificado:";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "Verificar senha da conta";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"Insira o código ({digitCount} dígitos)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "Insira o código ({digitCount} dígitos)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "Insira o código que enviamos para o seu telefone";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "Verificar SMS";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "Personalizado";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "Padrão";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "Todos";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "Amigos, usuários que sigo e seguidores";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "Amigos e usuários que sigo";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "Amigos";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "Alto";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "Baixo";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "Médio";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "Ninguém";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "Ninguém";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "Desligado";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "Endereço de e-mail:";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "Endereço de e-mail do responsável:";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "Verificação pendente";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "Data de expiração";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Expira em {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "Expira em {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook:";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "Concordância";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "Todos";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "Mês";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "Ano";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "Estatísticas";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "Você";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "Gênero";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+:";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "Claro";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "Idioma";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"Assinatura do {startSpan}Builders Club{endSpan}";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "Assinatura do {startSpan}Builders Club{endSpan}";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "Você ainda não é um membro. Entre para o Roblox Premium hoje mesmo!";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "Alguém me convida para um servidor VIP";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "Alguém fala comigo no chat";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "Alguém marca um novo jogo para jogar junto";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "O relatório analítico fica disponível";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "Alguém aceita minha solicitação de amizade";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "Recebo uma solicitação de amizade";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "Recebo notificações de atualização";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "Alguém me convida para um time";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "Alguém entra no meu time";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "Recebo uma mensagem privada";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "Alguém me convida para editar um jogo";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "Senha:";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "Número de telefone:";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "min";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "Tempo restante";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "s";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox Premium: {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox Premium: {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "Nomes de usuário anteriores:";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "Modo de privacidade";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "Data de renovação";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Renova automaticamente em {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "Renova automaticamente em {startSpan}{expirationDate}{endSpan}.";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox Premium: {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox Premium: {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount} Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount} Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "Encerrar todas as outras sessões";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "Visível para:";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"Conectado como {socialUsername}";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "Conectado como {socialUsername}";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "Tema";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "Personalizado - Controle suas próprias configurações. Padrão - Habilita chat e mensagens com amigos. Desligado - Desabilita chat e mensagens.";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "Todas as configurações estão bloqueadas. Para editar, desbloqueie com seu PIN.";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "Clique para desbloquear sua página de Configurações";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "Clique aqui para mais informações";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "Esta configuração controla com quem este usuário pode falar no chat no app e na web (no jogo é separado). Ela também permite impedir que este usuário publique em fóruns e murais de grupos.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "Esta configuração controla com quem este usuário pode falar no chat no jogo.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "Esta configuração controla quem pode encontrar você usando o número de telefone que você forneceu.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "Esta configuração controla quem pode entrar nos servidores VIP deste usuário, servidores estes que só podem ser acessados com um convite do dono.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "Esta configuração controla quem pode ver o jogo que estou jogando e entrar no meu servidor. Selecionar ninguém faz com que ninguém possa me seguir no meu servidor específico, mas ainda assim poderei jogar com outros usuários.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "Esta configuração controla de quem este usuário pode receber mensagens em sua caixa de entrada.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "Esta configuração controla quem pode ver o seu inventário.";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "Filtro de qualidade de troca";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter:";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "Habilitar verificação de 2 passos";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "Um e-mail verificado é obrigatório.";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "Melhore a segurança da sua conta. Um código será obrigatório quando você se conectar com um outro dispositivo.";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "Sua conta está protegida!";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "Atualizar e-mail";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "Atualizar telefone";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "Usar idioma do dispositivo";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Nome de usuário:";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "Verificado";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "Verificar";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "Quem pode falar no chat do app comigo?";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "Quem pode falar no chat comigo?";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "Quem pode me encontrar pelo meu número de telefone?";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "Quem pode me convidar para servidores VIP?";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "Quem pode entrar no meu jogo?";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "Quem pode me enviar mensagens?";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "Quem pode ver meu inventário?";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "Quem pode trocar comigo?";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "Conectado com uma conta Xbox";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube:";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Robux insuficientes";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "Esta conta já têm um PIN. Tente uma solicitação diferente.";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "Esta conta está bloqueada. Desbloqueie a conta antes de realizar esta ação.";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "Algo deu errado. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "O e-mail já foi verificado.";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "Esta funcionalidade está desabilitada no momento. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "Senha incorreta.";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "Endereço de e-mail inválido.";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "Nenhum endereço de e-mail associado à esta conta.";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "PIN bloqueado.";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "Este é o e-mail atual.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "Existem muitas contas associadas a este endereço de e-mail.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "Foram feitas muitas tentativas para atualizar o e-mail. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "Foram feitas muitas tentativas de verificação de e-mail. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "Ocorreu um erro desconhecido.";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "PIN incorreto.";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "Formato de PIN inválido.";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "Não existe um PIN para esta conta.";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "Esta conta não tem um e-mail verificado.";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "Erro do sistema.";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "Foram feitas muitas tentativas. Tente novamente mais tarde.";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "E-mail adicionado";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "Seu e-mail já foi verificado!";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "Esta funcionalidade está desabilitada no momento. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "Você não tem Robux suficientes para alterar seu nome de usuário.";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "E-mail inválido";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "Você precisa associar um endereço de e-mail à sua conta.";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "Você não tem Robux suficientes para alterar seu nome de usuário.";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "PIN bloqueado.";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "Este já é o e-mail verificado atual.";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "Suas configurações foram atualizadas.";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "Contas demais estão associadas a este endereço de e-mail.";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "Tentativas excessivas. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "Um erro desconhecido ocorreu.";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "Sua senha está incorreta.";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "Código inválido. Confira seu telefone e tente novamente.";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "O valor para \"Quem pode trocar comigo\" deve ser o mesmo ou com mais restrições do que o valor para \"Quem pode ver meu inventário\".";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "Código obrigatório. Insira seu código.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "Alterar sua data de nascimento para menos de 13 anos não pode ser desfeito. Quer mesmo continuar?";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "Você precisa adicionar uma senha à sua conta Roblox para alterar sua data de nascimento.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "É preciso adicionar senha";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "Alterar a sua data de nascimento para menos de 13 anos não pode ser desfeito. Sua conexão social do Facebook será desabilitada e você terá que usar sua conta Roblox.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "Sua senha atual está incorreta. A senha não foi alterada.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "As senhas não conferem";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "Deve conter pelo menos 8 caracteres";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "Insira um nome de usuário.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "Nome de usuário inapropriado para Roblox.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "Este nome de usuário já está sendo usado.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "Nome de usuário alterado com sucesso.";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "Erro ao carregar lista de países";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "Ocorreu um erro no serviço de moeda. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "Algo deu errado. Tente de novo.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "Ocorreu um erro";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "Salvo com sucesso!";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "Ocorreu um erro ao tentar desconectar sua conta Xbox. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "Um e-mail de verificação foi enviado.";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "Endereço de e-mail inválido";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "Número de telefone inválido";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Aperte Enviar para enviar a solicitação ou Cancelar para editar o nome de usuário. O nome de usuário é uma informação muito importante e pode ajudar a resolver seu problema mais rápido.";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "A senha deve conter pelo menos 2 dígitos, 4 letras, 1 símbolo e ter pelo menos 8 caracteres.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "Seu PIN foi definido. Você precisa inserir este PIN antes de acessar a página de Configurações no futuro.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "PINs não conferem";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "Ocorreu um erro ao tentar encerrar todas as outras sessões. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "Você foi desconectado de todas as outras sessões.";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "Se você desligar a verificação de 2 passos, só a sua senha será necessária para se conectar em um novo dispositivo. Tem certeza?";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "Verificação de 2 passos habilitada";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "Sua conta está agora protegida! Mais nenhuma ação é necessária no momento. Um código de segurança será enviado na próxima vez que você se conectar em um novo dispositivo.";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "Atualizamos as configurações de privacidade de seu inventário. As configurações de troca e inventário devem ser consistentes.";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "Ocorreu um erro ao tentar atualizar suas configurações de notificação. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "Atualizamos as configurações de privacidade de seu inventário. As configurações de troca e inventário devem ser consistentes.";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "Código inválido. Confira seu telefone e tente novamente.";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "Aviso";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "Esta funcionalidade está desabilitada no momento. Tente de novo mais tarde.";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "Ocorreu um erro. Tente novamente.";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "Você inseriu o código incorreto um número excessivo de vezes.";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "Senha inválida. Confira sua senha e tente novamente.";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "Formato de número de telefone inválido. Confira e tente novamente.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "Telefone removido";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "Telefone atualizado com sucesso!";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "O número já está associado a outra conta.";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "Insira seu PIN para alterar suas configurações.";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "O link da rede social não é válido.";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "Lamentamos, mas você não pode alterar sua idade para menos de 13 anos. Se você tiver menos de 13 anos, crie uma nova conta e entre em contato com o suporte para excluir sua conta antiga.";
	}
}
