namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_ko_kr : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "더 불러오기";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "갱신 취소";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "이메일 추가";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "전화번호 추가";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "취소";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "이메일 변경";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "확인";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "업데이트";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "확인";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "구매";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "닫기";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "전화번호 수정";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "전화번호 삭제";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "구매";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "아니요";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "추가";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "확인";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "잠금 해제";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "삭제";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "취소";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "보내기";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "확인";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "업데이트";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "확인";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "이메일 인증";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "다시 시도";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "인증";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "코드 다시 보내기";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "취소";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "예";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "감추기";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "가입";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "Builders Club 가입";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "저장";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "보이기";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "로그아웃";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "연결 해제";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "확인";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "차단 해제";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "멤버십 업그레이드";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "본 계정에 계정 제한을 설정하여 계정 설정 및 검증되지 않은 콘텐츠로의 접근을 제한할 수 있습니다";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "Roblox 이메일 재설정";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Roblox를 종료하더라도 사용 중인 컴퓨터로 알림을 받아볼 수 있습니다.";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "알림을 사용하려면 먼저 사용 중인 브라우저에서 푸시 알림을 활성화해야 합니다.";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "본 기기에 사용할 데스크톱 알림입니다.";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "국가 코드를 확인하고 전화번호를 입력하세요. 인증을 위해 문자 메시지를 보내드려요. (참고: 문자 메시지 발송 수수료가 부과될 수 있습니다)";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "인증을 위해 이메일이 발송되었습니다";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "새 이메일의 인증이 완료될 때까지 이메일은 변경되지 않습니다.";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "비밀번호 변경을 완료했어요.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "중요: 원래 계정 생성일은 새 사용자 이름으로 옮겨져요.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "일 회에 한해 사용자 이름을 무료로 변경할 수 있어요.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "과거에 작성한 포럼 게시물은 새 사용자 이름으로 이전되지 않으며 변경 전 사용자 이름으로 게시됩니다.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "사용자 이름 변경";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "새 전화번호 인증이 완료될 때까지 전화번호는 변경되지 않습니다.";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "사용자 이름을 변경하려면 먼저 이메일 주소 등록 및 인증을 해야 합니다.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "감사합니다! 인증 이메일이 발송되었어요.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "사용자 이름을 변경하려면 먼저 이메일 인증을 완료해야 합니다.";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "Facebook 연결을 해제하기 전에 계정 보호를 위해 비밀번호를 추가하세요.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "계정 PIN을 추가하려면 먼저 이메일을 입력하고 인증을 하셔야 합니다.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "2단계 인증을 활성화하려면 먼저 이메일을 입력하고 인증을 하셔야 합니다.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "사용자 이름을 변경하려면 먼저 이메일을 입력하고 인증을 하셔야 합니다.";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "계정에 연결된 계정 PIN을 입력하세요";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "계정 PIN을 추가하려면 먼저 이메일을 인증하셔야 합니다.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "2단계 인증을 활성화하려면 먼저 이메일을 인증하셔야 합니다.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "사용자 이름을 변경하려면 먼저 이메일을 인증하셔야 합니다.";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "여러 건의 정확한 신고를 하셨기 때문에 패스트트랙 프로그램에 등록되셨습니다. 이제 회원님의 신고는 패스트 트랙으로 처리되어 우선적으로 검토된답니다. 앞으로도 정확한 신고를 계속하여 본 프로그램에 남아주세요. Roblox가 안전한 공간이 될 수 있도록 도와줘서 고마워요!";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "통계";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "Roblox 밖에서 회원님을 식별할 수 있는 내용이나 정보를 기재하지 마세요.";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "정확도는 검열팀이 신고에 동의한 빈도입니다. 여러 건의 신고를 하고나서야 회원님의 정확도가 표시되죠. '전체'는 그룹으로서의 패스트트랙 멤버 전원을 의미합니다.";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "나이를 만 13세 미만으로 설정하면 개인정보 보호 모드가 활성화됩니다.";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "비밀번호 변경";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "사용자 이름 변경";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "이메일 업데이트";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "청구 및 결제 관련 질문: info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "아직 회원이 아니시군요. 지금 Builders Club에 가입하세요!";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "아직 회원이 아니네요. 지금 바로 Roblox 프리미엄에 가입하세요!";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "사용 중인 기기의 홈 화면에서 알림을 확인하세요. Roblox 앱에서 알림을 설정하거나 해제할 수 있습니다.";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "본 기기에서 사용할 모바일 푸시 알림입니다.";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "내 스트림에서 알림을 확인하세요. 상단 바의 알림 아이콘을 클릭하시면 됩니다.";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "알림을 해제하시면 해당 유형의 알림이 발송되지 않습니다.";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "참고: 멤버십 갱신을 취소하려면 웹 사이트에서 로그인하세요.";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "저장을 완료했어요!";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "이메일 인증이 필요합니다";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Roblox 사용자 이름 변경";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Roblox 이메일 인증";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Roblox 계정 승인";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "자기소개 (1000자 이내)";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "예: www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "예: http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "예: www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "예: @Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "예: www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "계정 컨트롤";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "계정 정보";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "결제";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "차단된 사용자";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "연락처 설정";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "데스크톱 푸시 알림";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "비밀번호 추가";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "전화번호 추가";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "이메일 주소 변경";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "이메일 주소 변경 완료";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "비밀번호 변경";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "완료";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "완료";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "사용자 이름 변경";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "오류";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "완료";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "전화번호 수정";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "잔액 부족";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "유효하지 않은 사용자 이름";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "PIN 추가";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "완료";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "계정 PIN이 필요합니다";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "전화번호 삭제";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "이메일 인증 필요";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "이메일 인증";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "전화번호 인증";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "패스트트랙";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "멤버십 상태";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "알림 조건:";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "알림";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "알림 조건:";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "데스크톱 푸시 알림";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "모바일 푸시 알림";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "알림 스트림";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "알림 스트림";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "기타 설정";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "내 설정";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "개인정보";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "계정 PIN";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "개인정보 설정";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "갱신 날짜";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "계정 제한";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "보안 로그아웃";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "소셜 네트워크";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "소셜 로그인";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "완료";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "계정 정보";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "결제";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "패스트트랙";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "알림";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "개인정보";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "보안";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "거래";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "2단계 인증";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "계정 PIN을 현재 사용하지 않습니다";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "계정 PIN이 현재 사용 중입니다";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "계정 제한을 현재 사용하지 않습니다";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "계정 제한을 현재 사용 중입니다";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "이메일 추가";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "보호자 이메일 추가";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "비밀번호 추가:";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "전화번호 추가";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "전화번호 추가";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "청구 및 결제 관련 질문:";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "가격";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "날짜";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "설명";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "현재 서비스 이용 불가. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "거래내역 없음";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "결제 방식";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "생년월일";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "사용자 이름을 변경하세요";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "언어 선택";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "테마 끄기";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "계정 연결:";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "국가/지역 선택";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "지역";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "어두운 테마";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "내 이메일 추가";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "보호자 이메일 추가";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "전화번호";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "계정 비밀번호 확인";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "내 이메일 변경";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "내 이메일 변경";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "보호자 이메일 변경";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "비밀번호 확인";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "현재 비밀번호";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "새 비밀번호";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "계정 비밀번호";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "새 사용자 이름 (3~20자)";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "PIN을 확인하세요";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "현재 전화번호:";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "이메일 주소 변경됨";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "이메일이 필요합니다";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "인증된 이메일:";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "계정 비밀번호 확인";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "방금 휴대폰으로 전송된 코드를 입력하세요";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "SMS 인증";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "사용자 정의";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "기본값";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "모두";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "친구, 내가 팔로우하는 사용자, 팔로워";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "친구, 내가 팔로우하는 사용자";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "친구";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "높음";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "낮음";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "중간";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "없음";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "없음";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "끄기";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "이메일:";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "보호자 이메일:";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "대기 중인 인증";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "종료일";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook:";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "정확도";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "전체";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "월";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "년";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "통계";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "본인";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "성별";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+:";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "밝은 테마";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "언어";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "아직 회원이 아니네요. 지금 바로 Roblox Premium에 가입하세요!";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "VIP 서버 초대를 받았을 때";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "채팅에서 누군가가 나와 대화를 시작할 때";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "누군가가 함께 플레이할 새로운 게임을 핀했을 때";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "분석 보고서 열람 가능";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "내 친구 요청이 수락되었을 때";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "친구 요청을 받았을 때";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "업데이트 알림을 받습니다";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "파티 초대를 받았을 때";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "누군가 내 파티에 참가했을 때";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "비공개 메시지를 받았을 때";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "누군가가 게임 편집에 나를 초대할 때";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "비밀번호:";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "전화번호:";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "분";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "남은 시간";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "초";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "이전 사용자 이름:";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "개인정보 보호 모드";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "갱신일";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "다른 모든 세션에서 로그아웃합니다";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "공개 대상:";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "테마";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "사용자 정의: 각 항목을 직접 설정. 기본값: 친구와의 채팅 및 메시지 활성화. 끄기: 채팅 및 메시지 비활성화.";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "설정 사용이 모두 중지되었습니다. 수정하려면 PIN으로 잠금을 해제하세요";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "설정 페이지 사용을 중단하려면 클릭하세요";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "자세한 정보는 여기를 클릭하세요";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "앱과 웹사이트에서 나와 채팅할 수 있는 대상을 설정합니다(게임 내 채팅 제외). 본 항목을 설정하면 포럼이나 그룹 담벼락에 글을 게시하지 못할 수도 있어요.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "게임에서 나와 채팅할 수 있는 대상을 설정합니다.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "회원님이 제공한 전화번호로 회원님을 찾을 수 있는 대상을 설정합니다.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "나를 VIP 서버로 초대할 수 있는 대상을 설정합니다. VIP 서버는 서버 소유자의 초대가 있어야만 참가할 수 있는 서버입니다.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "내가 하고 있는 게임을 보거나 내 서버에 참가할 수 있는 대상을 설정합니다. 아무도 선택하지 않으면 누구도 내 서버에 참가할 수 없지만, 나는 다른 사용자와 게임을 즐길 수 있어요.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "수신함으로 메시지를 보낼 수 있는 대상을 설정합니다.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "내 인벤토리를 볼 수 있는 대상을 설정합니다.";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "거래 품질 필터";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter:";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "2단계 인증 사용";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "이메일 인증이 필요합니다.";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "계정을 더욱 안전하게 보호하세요. 새로운 기기로 로그인 시 코드를 입력해야 합니다.";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "2단계 인증이 실행 중입니다.";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "이메일 주소 업데이트";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "전화번호 업데이트";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "장치 언어 사용";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "사용자 이름:";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "인증 완료";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "인증";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "누가 나와 앱에서 채팅할 수 있나요?";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "누가 나와 채팅할 수 있나요?";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "누가 내 전화번호로 나를 찾을 수 있나요?";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "누가 나를 VIP 서버로 초대할 수 있나요?";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "누가 나와 합류할 수 있나요?";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "누가 내게 메시지를 보낼 수 있나요?";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "누가 내 인벤토리를 볼 수 있나요?";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "누가 나와 거래할 수 있나요?";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "Xbox 계정과 연결됨";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube:";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Robux 부족";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "계정에 이미 PIN이 존재합니다. 다른 요청을 시도해 보세요.";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "계정 사용이 중지되었습니다. 작업 수행 전 계정 잠금을 해제하세요.";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "오류가 발생했어요. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "이미 인증된 이메일입니다.";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "본 기능은 현재 사용할 수 없습니다. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "비밀번호가 일치하지 않습니다.";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "유효하지 않은 이메일.";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "본 계정과 연결된 이메일 주소가 존재하지 않습니다.";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "PIN 사용이 중지되었습니다.";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "이미 등록된 이메일입니다.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "너무 많은 계정이 본 이메일과 연결되어 있습니다.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "이메일 업데이트 시도 가능 횟수를 초과했습니다. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "이메일 인증 시도 가능 횟수를 초과했습니다. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "알 수 없는 오류가 발생했어요.";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "일치하지 않는 PIN.";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "유효하지 않은 PIN 형식.";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "계정 PIN이 존재하지 않아요.";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "본 계정은 이메일을 인증하지 않았습니다.";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "시스템 오류.";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "요청 가능 횟수 초과. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "이메일 추가 완료";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "회원님의 이메일은 이미 인증이 완료되었습니다.";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "현재 사용할 수 없는 기능입니다. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "Robux가 부족해서 사용자 이름을 변경할 수 없어요.";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "유효하지 않은 이메일";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "이메일 주소를 계정에 연결해야 합니다";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "Robux가 부족해서 사용자 이름을 변경할 수 없어요.";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "PIN 사용이 중지되었습니다.";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "이미 인증된 이메일입니다.";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "설정이 업데이트되었습니다.";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "너무 많은 이메일 주소가 본 계정과 연결되어 있습니다.";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "시도 가능 횟수를 초과했습니다. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "알 수 없는 오류가 발생했어요.";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "비밀번호가 일치하지 않습니다. ";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "유효하지 않은 코드입니다. 확인 후 다시 시도하세요.";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "'나와 거래할 수 있는 대상'은 '내 인벤토리를 볼 수 있는 대상'과 동일하거나 더 제한적이어야 합니다.";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "코드가 필요합니다. 코드를 입력하세요.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "일단 만 13세 미만으로 생년월일을 변경하면 취소할 수 없습니다. 계속하시겠습니까?";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "생년월일을 변경하려면 Roblox 계정에 비밀번호를 추가해야 합니다.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "비밀번호를 추가해야 합니다";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "일단 만 13세 미만으로 생년월일을 변경하면 취소할 수 없습니다. 또한 Facebook 소셜 로그인이 비활성화되며 Roblox 비밀번호를 사용하여 로그인하셔야 합니다.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "입력하신 비밀번호가 일치하지 않아 비밀번호 변경을 완료하지 못했습니다.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "비밀번호가 일치하지 않습니다";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "8자 이상 입력하세요";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "사용자 이름을 입력하세요.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "부적절한 사용자 이름입니다.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "이미 사용 중인 사용자 이름입니다.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "변경 완료된 사용자 이름.";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "국가 목록 로드 중 오류 발생";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "통화 서비스 관련 오류가 발생했어요. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "오류가 발생했어요. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "오류 발생";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "저장을 완료했어요!";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "Xbox 계정과 연결 해제 중 오류가 발생했어요. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "인증을 위한 이메일이 발송되었어요.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "유효하지 않은 이메일 주소";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "유효하지 않은 전화번호";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "보내기를 눌러 티켓을 제출하거나 취소를 눌러 사용자 이름을 수정하세요. 사용자 이름은 매우 중요한 정보로 문제 발생 시 빠른 해결에 도움을 줄 수 있습니다.";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "비밀번호는 최소한 숫자 2개, 문자 4개, 기호 1개를 포함하며 총 8자 이상이어야 합니다.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "PIN이 설정되었습니다. 앞으로는 방금 설정한 PIN을 입력해야 설정 페이지를 이용하실 수 있어요.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "PIN이 일치하지 않아요";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "다른 모든 세션에서 로그아웃하는 중에 오류가 발생했어요. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "다른 모든 세션에서 로그아웃했어요.";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "2단계 인증을 해제하면 비밀번호만으로도 새 기기에서 로그인이 가능합니다. 계속하시겠습니까?";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "2단계 인증 활성화";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "2단계 인증이 실행 중입니다. 지금 필요한 추가 작업은 없습니다. 다음 번 새 장치에서 로그인 시 보안 코드가 발송됩니다.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "인벤토리 개인정보 설정을 업데이트했어요. 인벤토리 설정과 거래 설정은 일관성을 유지해야 합니다.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "알림 설정을 업데이트하는 중 오류가 발생했어요. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "거래 개인정보 설정을 업데이트했어요. 인벤토리 설정과 거래 설정은 일관성을 유지해야 합니다.";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "유효하지 않은 코드입니다. 코드를 확인하신 후 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "주의";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "현재 사용할 수 없는 기능입니다. 나중에 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "오류가 발생했어요. 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "코드 입력 시도 가능 횟수를 초과했어요.";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "비밀번호가 일치하지 않습니다. 확인 후 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "유효하지 않은 전화번호 형식입니다. 확인 후 다시 시도하세요.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "전화번호가 삭제되었습니다";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "전화번호 업데이트를 완료했어요!";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "전화번호가 이미 다른 계정에 연결되어 있어요.";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "설정을 변경하려면 PIN을 입력하세요.";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "유효하지 않은 소셜 네트워크 링크입니다.";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "죄송합니다. 13세 미만으로 나이를 변경할 수 없습니다. 13세 미만 사용자는 새로 계정을 만든 후 고객지원으로 사용 중인 계정의 삭제를 요청하세요.";

	public AccountSettingsResources_ko_kr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "더 불러오기";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "갱신 취소";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "이메일 추가";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "전화번호 추가";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "취소";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "이메일 변경";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "확인";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "업데이트";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "확인";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "구매";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "닫기";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "전화번호 수정";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "전화번호 삭제";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "구매";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "아니요";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "추가";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "확인";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "잠금 해제";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "삭제";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "취소";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "보내기";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "확인";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "업데이트";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "확인";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "이메일 인증";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "다시 시도";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "인증";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "코드 다시 보내기";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "취소";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "예";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "감추기";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "가입";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "Builders Club 가입";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "저장";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "보이기";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "로그아웃";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "연결 해제";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "확인";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "차단 해제";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "멤버십 업그레이드";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "본 계정에 계정 제한을 설정하여 계정 설정 및 검증되지 않은 콘텐츠로의 접근을 제한할 수 있습니다";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Roblox 이메일 재설정{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}Roblox 이메일 재설정{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"Roblox 사용자님께{lineBreak}{lineBreak}{username} 계정의 이메일 주소를 {oldEmailAddress}에서 {newEmailAddress}(으)로 바꾸셨군요. 원래 변경할 생각이 없으셨거나 다른 누군가가 실수로 변경한 것이라면 아래 링크를 클릭해 원래대로 돌릴 수 있어요.{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}새 비밀번호도 입력해야 합니다. 그래야 사용자님의 계정이 안전하게 보안되고 있다는 걸 안심할 수 있어요.{lineBreak}{lineBreak}Roblox에 등록된 새 이메일 주소에 문제가 없다면 그대로 두면 됩니다! 이대로 사용하면 되요.{lineBreak}{lineBreak}이 메시지에 회신하지 마세요. 문의 사항이 있는 경우 {robloxInfoEmailAddress} 주소로 이메일을 보내주세요.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "Roblox 사용자님께{lineBreak}{lineBreak}{username} 계정의 이메일 주소를 {oldEmailAddress}에서 {newEmailAddress}(으)로 바꾸셨군요. 원래 변경할 생각이 없으셨거나 다른 누군가가 실수로 변경한 것이라면 아래 링크를 클릭해 원래대로 돌릴 수 있어요.{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}새 비밀번호도 입력해야 합니다. 그래야 사용자님의 계정이 안전하게 보안되고 있다는 걸 안심할 수 있어요.{lineBreak}{lineBreak}Roblox에 등록된 새 이메일 주소에 문제가 없다면 그대로 두면 됩니다! 이대로 사용하면 되요.{lineBreak}{lineBreak}이 메시지에 회신하지 마세요. 문의 사항이 있는 경우 {robloxInfoEmailAddress} 주소로 이메일을 보내주세요.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"Roblox 사용자님께{lineBreak}{lineBreak}{username} 계정의 이메일 주소를 {oldEmailAddress}에서 {newEmailAddress}(으)로 바꾸셨군요. 원래 변경할 생각이 없으셨거나 다른 누군가가 실수로 변경한 것이라면 아래 링크를 클릭해 원래대로 돌릴 수 있어요.{lineBreak}{revertAccountEmailLink}{lineBreak}새 비밀번호도 입력해야 합니다. 그래야 사용자님의 계정이 안전하게 보안되고 있다는 걸 안심할 수 있어요.{lineBreak}{lineBreak}Roblox에 등록된 새 이메일 주소에 문제가 없다면 그대로 두면 됩니다! 이대로 사용하면 되요.{lineBreak}이 메시지에 회신하지 마세요. 문의 사항이 있는 경우 {robloxInfoEmailAddress} 주소로 이메일을 보내주세요.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "Roblox 사용자님께{lineBreak}{lineBreak}{username} 계정의 이메일 주소를 {oldEmailAddress}에서 {newEmailAddress}(으)로 바꾸셨군요. 원래 변경할 생각이 없으셨거나 다른 누군가가 실수로 변경한 것이라면 아래 링크를 클릭해 원래대로 돌릴 수 있어요.{lineBreak}{revertAccountEmailLink}{lineBreak}새 비밀번호도 입력해야 합니다. 그래야 사용자님의 계정이 안전하게 보안되고 있다는 걸 안심할 수 있어요.{lineBreak}{lineBreak}Roblox에 등록된 새 이메일 주소에 문제가 없다면 그대로 두면 됩니다! 이대로 사용하면 되요.{lineBreak}이 메시지에 회신하지 마세요. 문의 사항이 있는 경우 {robloxInfoEmailAddress} 주소로 이메일을 보내주세요.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "Roblox 이메일 재설정";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"이 계정은 플랫폼에서 저희가 선정한 콘텐츠만 이용할 수 있어요. 또한, {linkStart}개인정보{linkEnd} 페이지의 연락 설정이 끔으로 설정돼요.";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "이 계정은 플랫폼에서 저희가 선정한 콘텐츠만 이용할 수 있어요. 또한, {linkStart}개인정보{linkEnd} 페이지의 연락 설정이 끔으로 설정돼요.";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"{totalBlockedCount}명의 사용자를 차단 중 (최대 {maxBlockedCount}명 차단 가능):";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "{totalBlockedCount}명의 사용자를 차단 중 (최대 {maxBlockedCount}명 차단 가능):";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"계정 제한({linkStart}보안{linkEnd} 페이지 하단)이 활성화 상태이므로 연락처 설정이 차단됩니다";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "계정 제한({linkStart}보안{linkEnd} 페이지 하단)이 활성화 상태이므로 연락처 설정이 차단됩니다";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Roblox를 종료하더라도 사용 중인 컴퓨터로 알림을 받아볼 수 있습니다.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "알림을 사용하려면 먼저 사용 중인 브라우저에서 푸시 알림을 활성화해야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "본 기기에 사용할 데스크톱 알림입니다.";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "국가 코드를 확인하고 전화번호를 입력하세요. 인증을 위해 문자 메시지를 보내드려요. (참고: 문자 메시지 발송 수수료가 부과될 수 있습니다)";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "인증을 위해 이메일이 발송되었습니다";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "새 이메일의 인증이 완료될 때까지 이메일은 변경되지 않습니다.";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "비밀번호 변경을 완료했어요.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "중요: 원래 계정 생성일은 새 사용자 이름으로 옮겨져요.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "일 회에 한해 사용자 이름을 무료로 변경할 수 있어요.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "과거에 작성한 포럼 게시물은 새 사용자 이름으로 이전되지 않으며 변경 전 사용자 이름으로 게시됩니다.";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"{robuxIcon} {price}(으)로 사용자 이름을 변경할까요?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "{robuxIcon} {price}(으)로 사용자 이름을 변경할까요?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "사용자 이름 변경";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "새 전화번호 인증이 완료될 때까지 전화번호는 변경되지 않습니다.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "사용자 이름을 변경하려면 먼저 이메일 주소 등록 및 인증을 해야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "감사합니다! 인증 이메일이 발송되었어요.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "사용자 이름을 변경하려면 먼저 이메일 인증을 완료해야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "Facebook 연결을 해제하기 전에 계정 보호를 위해 비밀번호를 추가하세요.";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"{robuxToBuy}이(가) 부족하여 사용자 이름을 변경할 수 없습니다. Robux를 구매하시겠습니까?";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "{robuxToBuy}이(가) 부족하여 사용자 이름을 변경할 수 없습니다. Robux를 구매하시겠습니까?";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "계정 PIN을 추가하려면 먼저 이메일을 입력하고 인증을 하셔야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "2단계 인증을 활성화하려면 먼저 이메일을 입력하고 인증을 하셔야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "사용자 이름을 변경하려면 먼저 이메일을 입력하고 인증을 하셔야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "계정에 연결된 계정 PIN을 입력하세요";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"{phoneLast4}(으)로 끝나는 전화번호를 정말 삭제하시겠습니까?";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "{phoneLast4}(으)로 끝나는 전화번호를 정말 삭제하시겠습니까?";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "계정 PIN을 추가하려면 먼저 이메일을 인증하셔야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "2단계 인증을 활성화하려면 먼저 이메일을 인증하셔야 합니다.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "사용자 이름을 변경하려면 먼저 이메일을 인증하셔야 합니다.";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "여러 건의 정확한 신고를 하셨기 때문에 패스트트랙 프로그램에 등록되셨습니다. 이제 회원님의 신고는 패스트 트랙으로 처리되어 우선적으로 검토된답니다. 앞으로도 정확한 신고를 계속하여 본 프로그램에 남아주세요. Roblox가 안전한 공간이 될 수 있도록 도와줘서 고마워요!";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "통계";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "Roblox 밖에서 회원님을 식별할 수 있는 내용이나 정보를 기재하지 마세요.";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "정확도는 검열팀이 신고에 동의한 빈도입니다. 여러 건의 신고를 하고나서야 회원님의 정확도가 표시되죠. '전체'는 그룹으로서의 패스트트랙 멤버 전원을 의미합니다.";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "나이를 만 13세 미만으로 설정하면 개인정보 보호 모드가 활성화됩니다.";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "비밀번호 변경";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "사용자 이름 변경";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "이메일 업데이트";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "청구 및 결제 관련 질문: info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "아직 회원이 아니시군요. 지금 Builders Club에 가입하세요!";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "아직 회원이 아니네요. 지금 바로 Roblox 프리미엄에 가입하세요!";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "사용 중인 기기의 홈 화면에서 알림을 확인하세요. Roblox 앱에서 알림을 설정하거나 해제할 수 있습니다.";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "본 기기에서 사용할 모바일 푸시 알림입니다.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "내 스트림에서 알림을 확인하세요. 상단 바의 알림 아이콘을 클릭하시면 됩니다.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "알림을 해제하시면 해당 유형의 알림이 발송되지 않습니다.";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "참고: 멤버십 갱신을 취소하려면 웹 사이트에서 로그인하세요.";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "저장을 완료했어요!";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "이메일 인증이 필요합니다";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"새로운 기기로 로그인 시 {email}(으)로 인증 코드를 보내드립니다";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "새로운 기기로 로그인 시 {email}(으)로 인증 코드를 보내드립니다";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"Roblox 사용자님, 안녕하세요! 최근 {lineBreaks}사용자 이름을 {oldUsername}에서 {newUsername}(으)로 바꾸셨네요. 사용자 이름 변경 요청을 하지 않으셨다면 {robloxInfoEmailAddress}(으)로 문의주세요.";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "Roblox 사용자님, 안녕하세요! 최근 {lineBreaks}사용자 이름을 {oldUsername}에서 {newUsername}(으)로 바꾸셨네요. 사용자 이름 변경 요청을 하지 않으셨다면 {robloxInfoEmailAddress}(으)로 문의주세요.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Roblox 사용자 이름 변경{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Roblox 사용자 이름 변경{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Roblox 사용자 이름 변경";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox 이메일 인증{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Roblox 이메일 인증{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox 계정 승인{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Roblox 계정 승인{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"Roblox 사용자 여러분들께{lineBreak}{lineBreak}{username} 계정 보안을 위해 이메일 주소를 제공해 주셔서 감사합니다.{lineBreak}Roblox 계정에 연결된 이메일 주소를 인증하면 계정 보안이 한층 더 강화됩니다.{lineBreak}아래 버튼을 클릭해 인증 절차를 완료하세요.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}이메일 인증{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "Roblox 사용자 여러분들께{lineBreak}{lineBreak}{username} 계정 보안을 위해 이메일 주소를 제공해 주셔서 감사합니다.{lineBreak}Roblox 계정에 연결된 이메일 주소를 인증하면 계정 보안이 한층 더 강화됩니다.{lineBreak}아래 버튼을 클릭해 인증 절차를 완료하세요.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}이메일 인증{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"안녕하세요,{lineBreak}{lineBreak}귀하의 자녀가 Roblox에서 {boldTagStart}{username}{boldTagEnd} 계정을 만들었습니다. Roblox는 흥미진진한 사용자 제작 3D 세계에서 어린이들이 상상하고, 만들고, 함께 플레이할 수 있는 온라인 엔터테인먼트 플랫폼입니다. Roblox 플랫폼은 'Roblox Studio'라는 무료 개발 도구도 제공합니다. 사용자들은 Roblox Studio를 사용하여 드래그앤드롭만으로 간단한 건물 건설에서부터 복잡한 멀티플레이 게임에 이르기까지 상상하는 모든 것을 만들어 볼 수 있어요. 수많은 어린이들이 Roblox를 통해 근사한 테마 파크를 만드는 경험을 하거나, 프로 카레이서가 되어 경쟁하거나, 패션쇼의 스타가 되어보거나, 자신이 꿈꾸는 집을 짓고 친구들과 시간을 보내는 등 상상의 나래를 펼치고 있습니다.{lineBreak}{lineBreak}본 이메일은 귀하의 자녀가 저희에게 사용자 이름, 생년월일, 보호자 이메일 주소를 제공했다는 사실을 알려드리기 위한 이메일입니다. 보호자의 이메일 주소는 계정 관리, 자녀가 비밀번호 분실 시 비밀번호 재설정, 자녀의 계정 접근 권한에 변동이 있을 시 보호자에게 알려드리는 용도로만 사용됩니다. 이메일 주소를 인증하려면 아래 버튼을 클릭하세요. {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}이메일 인증{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Roblox 소개{boldTagEnd}{lineBreak}{lineBreak}Roblox는 즐겁고도 가족 친화적인 환경을 조성하기 위해 최선을 다하고 있습니다. 지속적인 안전 기능 개선 및 디지털 안전 전문가와의 협업을 통해 모든 플레이어들이 플레이, 채팅 및 창의적인 프로젝트를 위해 공동 작업할 수 있는 안전하고 편안한 장이 될 수 있도록 끊임없이 노력하고 있습니다. 보호자 가이드를 참고하여 Roblox 플랫폼에 대해 자세히 알아보고 Roblox에서 자녀가 더욱 긍정적인 경험을 할 수 있도록 유용한 팁을 찾아보세요. {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox는 또한 {boldTagStart}자녀 보호 설정{boldTagEnd} 기능도 제공하고 있습니다. 보호자는 보호자 PIN을 활성화하여 자녀의 대화 및 채팅 설정을 변경하실 수 있습니다. 자녀 계정 로그인 상태로 계정 설정의 보안 및 개인정보 탭에서 이러한 설정 기능을 확인하실 수 있습니다.{lineBreak}{lineBreak}보호자 PIN을 추가하려면 {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}채팅 설정을 변경하려면 {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}{boldTagStart}개인정보{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}의 고객지원에 연락하여 자녀의 계정을 제거할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 활용되지 않습니다. 자세한 내용은 {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀 드림 {lineBreak}{lineBreak} 본 이메일에 직접 회신하지 마십시오. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "안녕하세요,{lineBreak}{lineBreak}귀하의 자녀가 Roblox에서 {boldTagStart}{username}{boldTagEnd} 계정을 만들었습니다. Roblox는 흥미진진한 사용자 제작 3D 세계에서 어린이들이 상상하고, 만들고, 함께 플레이할 수 있는 온라인 엔터테인먼트 플랫폼입니다. Roblox 플랫폼은 'Roblox Studio'라는 무료 개발 도구도 제공합니다. 사용자들은 Roblox Studio를 사용하여 드래그앤드롭만으로 간단한 건물 건설에서부터 복잡한 멀티플레이 게임에 이르기까지 상상하는 모든 것을 만들어 볼 수 있어요. 수많은 어린이들이 Roblox를 통해 근사한 테마 파크를 만드는 경험을 하거나, 프로 카레이서가 되어 경쟁하거나, 패션쇼의 스타가 되어보거나, 자신이 꿈꾸는 집을 짓고 친구들과 시간을 보내는 등 상상의 나래를 펼치고 있습니다.{lineBreak}{lineBreak}본 이메일은 귀하의 자녀가 저희에게 사용자 이름, 생년월일, 보호자 이메일 주소를 제공했다는 사실을 알려드리기 위한 이메일입니다. 보호자의 이메일 주소는 계정 관리, 자녀가 비밀번호 분실 시 비밀번호 재설정, 자녀의 계정 접근 권한에 변동이 있을 시 보호자에게 알려드리는 용도로만 사용됩니다. 이메일 주소를 인증하려면 아래 버튼을 클릭하세요. {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}이메일 인증{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Roblox 소개{boldTagEnd}{lineBreak}{lineBreak}Roblox는 즐겁고도 가족 친화적인 환경을 조성하기 위해 최선을 다하고 있습니다. 지속적인 안전 기능 개선 및 디지털 안전 전문가와의 협업을 통해 모든 플레이어들이 플레이, 채팅 및 창의적인 프로젝트를 위해 공동 작업할 수 있는 안전하고 편안한 장이 될 수 있도록 끊임없이 노력하고 있습니다. 보호자 가이드를 참고하여 Roblox 플랫폼에 대해 자세히 알아보고 Roblox에서 자녀가 더욱 긍정적인 경험을 할 수 있도록 유용한 팁을 찾아보세요. {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox는 또한 {boldTagStart}자녀 보호 설정{boldTagEnd} 기능도 제공하고 있습니다. 보호자는 보호자 PIN을 활성화하여 자녀의 대화 및 채팅 설정을 변경하실 수 있습니다. 자녀 계정 로그인 상태로 계정 설정의 보안 및 개인정보 탭에서 이러한 설정 기능을 확인하실 수 있습니다.{lineBreak}{lineBreak}보호자 PIN을 추가하려면 {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}채팅 설정을 변경하려면 {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}{boldTagStart}개인정보{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}의 고객지원에 연락하여 자녀의 계정을 제거할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 활용되지 않습니다. 자세한 내용은 {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀 드림 {lineBreak}{lineBreak} 본 이메일에 직접 회신하지 마십시오. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"자녀의 계정으로 로그인하면 계정 설정의 보안 및 개인정보 탭에서 이러한 설정 기능을 확인할 수 있습니다.{lineBreak}{lineBreak}보호자 PIN을 추가하려면 {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}채팅 설정을 변경하려면 {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}{boldTagStart}개인정보{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}의 지원 센터에 연락하여 자녀의 계정을 제거할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 활용되지 않습니다. 자세한 내용은 {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀 드림{lineBreak}{lineBreak} 본 이메일에 직접 회신하지 마십시오. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "자녀의 계정으로 로그인하면 계정 설정의 보안 및 개인정보 탭에서 이러한 설정 기능을 확인할 수 있습니다.{lineBreak}{lineBreak}보호자 PIN을 추가하려면 {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}채팅 설정을 변경하려면 {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}를 방문하세요.{lineBreak}{lineBreak}{boldTagStart}개인정보{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}의 지원 센터에 연락하여 자녀의 계정을 제거할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 활용되지 않습니다. 자세한 내용은 {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀 드림{lineBreak}{lineBreak} 본 이메일에 직접 회신하지 마십시오. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"Roblox 사용자님께{lineBreak}{lineBreak}{username} 계정 보안을 위해 이메일 주소를 제공해 주셔서 감사합니다.{lineBreak}Roblox 계정에 연결된 이메일 주소를 인증하면 계정 보안이 한층 더 강화됩니다.{lineBreak}아래 링크를 클릭해 인증 절차를 완료하세요{lineBreak}{verificationLink}.\n";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "Roblox 사용자님께{lineBreak}{lineBreak}{username} 계정 보안을 위해 이메일 주소를 제공해 주셔서 감사합니다.{lineBreak}Roblox 계정에 연결된 이메일 주소를 인증하면 계정 보안이 한층 더 강화됩니다.{lineBreak}아래 링크를 클릭해 인증 절차를 완료하세요{lineBreak}{verificationLink}.\n";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"안녕하세요,{lineBreak}{lineBreak}귀하의 자녀가 온라인 엔터테인먼트 플랫폼 Roblox에서 {username} 계정을 만들었습니다. Roblox의 흥미진진한 사용자 제작 3D 세계에서 어린이들은 함께 상상하고, 만들고, 플레이할 수 있어요. 사용자는 Roblox가 제공하는 'Roblox Studio'라는 무료 개발 도구를 사용해 단순히 드래그앤드롭 만으로 건물을 건설하거나 복잡한 멀티플레이 게임을 개발하는 등 상상하는 모든 것을 만들어 볼 수 있습니다. 수많은 어린이들이 Roblox를 통해 근사한 테마 파크를 만드는 경험을 하거나, 프로 카레이서가 되어 경쟁하거나, 패션쇼의 스타가 되어보거나, 아니면 그냥 자신이 꿈꾸는 집을 짓고 친구들과 시간을 보내는 등 접근상상의 나래를 펼치고 있습니다.{lineBreak}{lineBreak}본 이메일은 귀하의 자녀가 저희에게 사용자 이름, 생년월일, 보호자 이메일 주소를 제공했다는 사실을 알려드리기 위함입니다. 보호자 이메일 주소는 계정 관리를 비롯해 자녀가 비밀번호 분실 시 비밀번호 재설정, 자녀의 계정 접근 권한 변동 시 보호자에게 알려드리는 용도로만 사용됩니다. 이메일 주소를 인증하려면 아래 버튼을 클릭하세요.{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Roblox 소개{lineBreak}{lineBreak}Roblox는 즐겁고도 가족 친화적인 환경을 조성하기 위해 최선을 다하고 있습니다. 지속적인 안전 기능 개선 및 디지털 안전 전문가와의 협업을 통해 모든 플레이어들이 안전하고 편안한 환경에서 플레이하고 채팅하며 창의적인 프로젝트를 위해 공동 작업할 수 있도록 끊임없이 노력하고 있습니다. 보호자 가이드를 참고하여 Roblox 플랫폼에 대해 자세히 알아보고 자녀가 긍정적인 경험을 할 수 있도록 유용한 팁을 찾아보세요. {parentalPageLink}{lineBreak}{lineBreak}Roblox는 자녀 보호 기능도 제공하고 있습니다. 부모님께서는 보호자 PIN을 활성화하여 자녀의 대화 및 채팅 설정을 변경하실 수 있습니다. 자녀 계정 로그인 상태로 계정 설정의 보안 및 개인정보 탭에서 이러한 설정 기능을 확인하실 수 있습니다.{lineBreak}{lineBreak}보호자 PIN을 추가하려면 {accountSecurityLink}을 방문하세요.{lineBreak}{lineBreak}채팅 설정을 변경하려면 {chatPrivacyLink}를 방문하세요.{lineBreak}{lineBreak}개인정보{lineBreak}{lineBreak}{supportPageLink}의 고객지원에 연락하여 자녀의 계정을 삭제할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 활용되지 않습니다. 자세한 내용은 {privacyPageLink}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀{lineBreak}본 이메일에 직접 회신하지 마십시오.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "안녕하세요,{lineBreak}{lineBreak}귀하의 자녀가 온라인 엔터테인먼트 플랫폼 Roblox에서 {username} 계정을 만들었습니다. Roblox의 흥미진진한 사용자 제작 3D 세계에서 어린이들은 함께 상상하고, 만들고, 플레이할 수 있어요. 사용자는 Roblox가 제공하는 'Roblox Studio'라는 무료 개발 도구를 사용해 단순히 드래그앤드롭 만으로 건물을 건설하거나 복잡한 멀티플레이 게임을 개발하는 등 상상하는 모든 것을 만들어 볼 수 있습니다. 수많은 어린이들이 Roblox를 통해 근사한 테마 파크를 만드는 경험을 하거나, 프로 카레이서가 되어 경쟁하거나, 패션쇼의 스타가 되어보거나, 아니면 그냥 자신이 꿈꾸는 집을 짓고 친구들과 시간을 보내는 등 접근상상의 나래를 펼치고 있습니다.{lineBreak}{lineBreak}본 이메일은 귀하의 자녀가 저희에게 사용자 이름, 생년월일, 보호자 이메일 주소를 제공했다는 사실을 알려드리기 위함입니다. 보호자 이메일 주소는 계정 관리를 비롯해 자녀가 비밀번호 분실 시 비밀번호 재설정, 자녀의 계정 접근 권한 변동 시 보호자에게 알려드리는 용도로만 사용됩니다. 이메일 주소를 인증하려면 아래 버튼을 클릭하세요.{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Roblox 소개{lineBreak}{lineBreak}Roblox는 즐겁고도 가족 친화적인 환경을 조성하기 위해 최선을 다하고 있습니다. 지속적인 안전 기능 개선 및 디지털 안전 전문가와의 협업을 통해 모든 플레이어들이 안전하고 편안한 환경에서 플레이하고 채팅하며 창의적인 프로젝트를 위해 공동 작업할 수 있도록 끊임없이 노력하고 있습니다. 보호자 가이드를 참고하여 Roblox 플랫폼에 대해 자세히 알아보고 자녀가 긍정적인 경험을 할 수 있도록 유용한 팁을 찾아보세요. {parentalPageLink}{lineBreak}{lineBreak}Roblox는 자녀 보호 기능도 제공하고 있습니다. 부모님께서는 보호자 PIN을 활성화하여 자녀의 대화 및 채팅 설정을 변경하실 수 있습니다. 자녀 계정 로그인 상태로 계정 설정의 보안 및 개인정보 탭에서 이러한 설정 기능을 확인하실 수 있습니다.{lineBreak}{lineBreak}보호자 PIN을 추가하려면 {accountSecurityLink}을 방문하세요.{lineBreak}{lineBreak}채팅 설정을 변경하려면 {chatPrivacyLink}를 방문하세요.{lineBreak}{lineBreak}개인정보{lineBreak}{lineBreak}{supportPageLink}의 고객지원에 연락하여 자녀의 계정을 삭제할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 활용되지 않습니다. 자세한 내용은 {privacyPageLink}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀{lineBreak}본 이메일에 직접 회신하지 마십시오.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"채팅 설정을 변경하려면 {chatPrivacyLink}를 방문하세요.{lineBreak}{lineBreak}개인정보{lineBreak}{lineBreak} {supportPageLink}의 지원 센터에 연락하여 자녀의 계정을 제거할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 사용되지 않습니다. 자세한 내용은 {privacyPageLink}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀 드림{lineBreak}본 이메일에 직접 회신하지 마십시오.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "채팅 설정을 변경하려면 {chatPrivacyLink}를 방문하세요.{lineBreak}{lineBreak}개인정보{lineBreak}{lineBreak} {supportPageLink}의 지원 센터에 연락하여 자녀의 계정을 제거할 수도 있습니다. 귀하의 이메일은 다른 목적으로 사용되거나 제삼자에게 공개되지 않으며, 자녀로부터 수집한 기타 개인 정보와 결합하여 사용되지 않습니다. 자세한 내용은 {privacyPageLink}에서 개인정보 처리방침을 확인하세요.{lineBreak}{lineBreak}감사합니다.{lineBreak}{lineBreak}Roblox 팀 드림{lineBreak}본 이메일에 직접 회신하지 마십시오.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Roblox 이메일 인증";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Roblox 계정 승인";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "자기소개 (1000자 이내)";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "예: www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "예: http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "예: www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "예: @Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "예: www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "계정 컨트롤";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "계정 정보";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "결제";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "차단된 사용자";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "연락처 설정";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "데스크톱 푸시 알림";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "비밀번호 추가";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "전화번호 추가";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "이메일 주소 변경";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "이메일 주소 변경 완료";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "비밀번호 변경";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "완료";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "완료";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "사용자 이름 변경";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "오류";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "완료";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "전화번호 수정";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "잔액 부족";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "유효하지 않은 사용자 이름";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "PIN 추가";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "완료";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "계정 PIN이 필요합니다";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "전화번호 삭제";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "이메일 인증 필요";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "이메일 인증";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "전화번호 인증";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "패스트트랙";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "멤버십 상태";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "알림 조건:";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "알림";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "알림 조건:";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "데스크톱 푸시 알림";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "모바일 푸시 알림";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "알림 스트림";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "알림 스트림";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "기타 설정";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "내 설정";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "개인정보";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "계정 PIN";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "개인정보 설정";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "갱신 날짜";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "계정 제한";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "보안 로그아웃";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "소셜 네트워크";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "소셜 로그인";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "완료";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "계정 정보";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "결제";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "패스트트랙";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "알림";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "개인정보";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "보안";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "거래";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "2단계 인증";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "계정 PIN을 현재 사용하지 않습니다";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "계정 PIN이 현재 사용 중입니다";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "계정 제한을 현재 사용하지 않습니다";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "계정 제한을 현재 사용 중입니다";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "이메일 추가";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "보호자 이메일 추가";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "비밀번호 추가:";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "전화번호 추가";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "전화번호 추가";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "청구 및 결제 관련 질문:";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"청구 및 결제 관련 질문은 {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}결제 도움말 페이지{aTagEnd}를 참고하세요.";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "청구 및 결제 관련 질문은 {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}결제 도움말 페이지{aTagEnd}를 참고하세요.";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"마지막 4자리: {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "마지막 4자리: {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "가격";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "날짜";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "설명";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "현재 서비스 이용 불가. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "거래내역 없음";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "결제 방식";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "생년월일";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"아직 회원이 아니시군요. 지금 {startSpan}Builders Club{endSpan}에 가입하세요!";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "아직 회원이 아니시군요. 지금 {startSpan}Builders Club{endSpan}에 가입하세요!";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "사용자 이름을 변경하세요";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "언어 선택";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "테마 끄기";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "계정 연결:";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "국가/지역 선택";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "지역";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "어두운 테마";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "내 이메일 추가";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "보호자 이메일 추가";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "전화번호";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "계정 비밀번호 확인";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "내 이메일 변경";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "내 이메일 변경";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "보호자 이메일 변경";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "비밀번호 확인";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "현재 비밀번호";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "새 비밀번호";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "계정 비밀번호";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "새 사용자 이름 (3~20자)";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "PIN을 확인하세요";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"{digitCount}자리 PIN을 설정하세요";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "{digitCount}자리 PIN을 설정하세요";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "현재 전화번호:";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "이메일 주소 변경됨";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "이메일이 필요합니다";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "인증된 이메일:";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "계정 비밀번호 확인";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"코드 입력 ({digitCount}자리)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "코드 입력 ({digitCount}자리)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "방금 휴대폰으로 전송된 코드를 입력하세요";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "SMS 인증";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "사용자 정의";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "기본값";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "모두";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "친구, 내가 팔로우하는 사용자, 팔로워";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "친구, 내가 팔로우하는 사용자";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "친구";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "높음";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "낮음";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "중간";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "없음";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "없음";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "끄기";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "이메일:";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "보호자 이메일:";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "대기 중인 인증";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "종료일";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"{startSpan}{expirationDate}{endSpan}에 종료";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "{startSpan}{expirationDate}{endSpan}에 종료";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook:";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "정확도";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "전체";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "월";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "년";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "통계";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "본인";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "성별";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+:";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "밝은 테마";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "언어";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"{startSpan}Builders Club{endSpan} 멤버십";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "{startSpan}Builders Club{endSpan} 멤버십";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "아직 회원이 아니네요. 지금 바로 Roblox Premium에 가입하세요!";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "VIP 서버 초대를 받았을 때";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "채팅에서 누군가가 나와 대화를 시작할 때";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "누군가가 함께 플레이할 새로운 게임을 핀했을 때";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "분석 보고서 열람 가능";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "내 친구 요청이 수락되었을 때";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "친구 요청을 받았을 때";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "업데이트 알림을 받습니다";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "파티 초대를 받았을 때";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "누군가 내 파티에 참가했을 때";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "비공개 메시지를 받았을 때";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "누군가가 게임 편집에 나를 초대할 때";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "비밀번호:";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "전화번호:";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "분";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "남은 시간";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "초";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "이전 사용자 이름:";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "개인정보 보호 모드";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "갱신일";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"{startSpan}{expirationDate}{endSpan}에 자동 갱신.";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "{startSpan}{expirationDate}{endSpan}에 자동 갱신.";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount} Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount} Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "다른 모든 세션에서 로그아웃합니다";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "공개 대상:";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"{socialUsername}(으)로 접속 중";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "{socialUsername}(으)로 접속 중";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "테마";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "사용자 정의: 각 항목을 직접 설정. 기본값: 친구와의 채팅 및 메시지 활성화. 끄기: 채팅 및 메시지 비활성화.";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "설정 사용이 모두 중지되었습니다. 수정하려면 PIN으로 잠금을 해제하세요";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "설정 페이지 사용을 중단하려면 클릭하세요";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "자세한 정보는 여기를 클릭하세요";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "앱과 웹사이트에서 나와 채팅할 수 있는 대상을 설정합니다(게임 내 채팅 제외). 본 항목을 설정하면 포럼이나 그룹 담벼락에 글을 게시하지 못할 수도 있어요.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "게임에서 나와 채팅할 수 있는 대상을 설정합니다.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "회원님이 제공한 전화번호로 회원님을 찾을 수 있는 대상을 설정합니다.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "나를 VIP 서버로 초대할 수 있는 대상을 설정합니다. VIP 서버는 서버 소유자의 초대가 있어야만 참가할 수 있는 서버입니다.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "내가 하고 있는 게임을 보거나 내 서버에 참가할 수 있는 대상을 설정합니다. 아무도 선택하지 않으면 누구도 내 서버에 참가할 수 없지만, 나는 다른 사용자와 게임을 즐길 수 있어요.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "수신함으로 메시지를 보낼 수 있는 대상을 설정합니다.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "내 인벤토리를 볼 수 있는 대상을 설정합니다.";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "거래 품질 필터";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter:";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "2단계 인증 사용";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "이메일 인증이 필요합니다.";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "계정을 더욱 안전하게 보호하세요. 새로운 기기로 로그인 시 코드를 입력해야 합니다.";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "2단계 인증이 실행 중입니다.";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "이메일 주소 업데이트";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "전화번호 업데이트";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "장치 언어 사용";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "사용자 이름:";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "인증 완료";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "인증";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "누가 나와 앱에서 채팅할 수 있나요?";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "누가 나와 채팅할 수 있나요?";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "누가 내 전화번호로 나를 찾을 수 있나요?";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "누가 나를 VIP 서버로 초대할 수 있나요?";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "누가 나와 합류할 수 있나요?";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "누가 내게 메시지를 보낼 수 있나요?";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "누가 내 인벤토리를 볼 수 있나요?";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "누가 나와 거래할 수 있나요?";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "Xbox 계정과 연결됨";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube:";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Robux 부족";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "계정에 이미 PIN이 존재합니다. 다른 요청을 시도해 보세요.";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "계정 사용이 중지되었습니다. 작업 수행 전 계정 잠금을 해제하세요.";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "오류가 발생했어요. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "이미 인증된 이메일입니다.";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "본 기능은 현재 사용할 수 없습니다. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "비밀번호가 일치하지 않습니다.";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "유효하지 않은 이메일.";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "본 계정과 연결된 이메일 주소가 존재하지 않습니다.";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "PIN 사용이 중지되었습니다.";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "이미 등록된 이메일입니다.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "너무 많은 계정이 본 이메일과 연결되어 있습니다.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "이메일 업데이트 시도 가능 횟수를 초과했습니다. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "이메일 인증 시도 가능 횟수를 초과했습니다. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "알 수 없는 오류가 발생했어요.";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "일치하지 않는 PIN.";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "유효하지 않은 PIN 형식.";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "계정 PIN이 존재하지 않아요.";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "본 계정은 이메일을 인증하지 않았습니다.";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "시스템 오류.";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "요청 가능 횟수 초과. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "이메일 추가 완료";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "회원님의 이메일은 이미 인증이 완료되었습니다.";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "현재 사용할 수 없는 기능입니다. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "Robux가 부족해서 사용자 이름을 변경할 수 없어요.";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "유효하지 않은 이메일";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "이메일 주소를 계정에 연결해야 합니다";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "Robux가 부족해서 사용자 이름을 변경할 수 없어요.";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "PIN 사용이 중지되었습니다.";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "이미 인증된 이메일입니다.";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "설정이 업데이트되었습니다.";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "너무 많은 이메일 주소가 본 계정과 연결되어 있습니다.";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "시도 가능 횟수를 초과했습니다. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "알 수 없는 오류가 발생했어요.";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "비밀번호가 일치하지 않습니다. ";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "유효하지 않은 코드입니다. 확인 후 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "'나와 거래할 수 있는 대상'은 '내 인벤토리를 볼 수 있는 대상'과 동일하거나 더 제한적이어야 합니다.";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "코드가 필요합니다. 코드를 입력하세요.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "일단 만 13세 미만으로 생년월일을 변경하면 취소할 수 없습니다. 계속하시겠습니까?";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "생년월일을 변경하려면 Roblox 계정에 비밀번호를 추가해야 합니다.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "비밀번호를 추가해야 합니다";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "일단 만 13세 미만으로 생년월일을 변경하면 취소할 수 없습니다. 또한 Facebook 소셜 로그인이 비활성화되며 Roblox 비밀번호를 사용하여 로그인하셔야 합니다.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "입력하신 비밀번호가 일치하지 않아 비밀번호 변경을 완료하지 못했습니다.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "비밀번호가 일치하지 않습니다";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "8자 이상 입력하세요";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "사용자 이름을 입력하세요.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "부적절한 사용자 이름입니다.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "이미 사용 중인 사용자 이름입니다.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "변경 완료된 사용자 이름.";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "국가 목록 로드 중 오류 발생";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "통화 서비스 관련 오류가 발생했어요. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "오류가 발생했어요. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "오류 발생";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "저장을 완료했어요!";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "Xbox 계정과 연결 해제 중 오류가 발생했어요. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "인증을 위한 이메일이 발송되었어요.";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "유효하지 않은 이메일 주소";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "유효하지 않은 전화번호";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "보내기를 눌러 티켓을 제출하거나 취소를 눌러 사용자 이름을 수정하세요. 사용자 이름은 매우 중요한 정보로 문제 발생 시 빠른 해결에 도움을 줄 수 있습니다.";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "비밀번호는 최소한 숫자 2개, 문자 4개, 기호 1개를 포함하며 총 8자 이상이어야 합니다.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "PIN이 설정되었습니다. 앞으로는 방금 설정한 PIN을 입력해야 설정 페이지를 이용하실 수 있어요.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "PIN이 일치하지 않아요";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "다른 모든 세션에서 로그아웃하는 중에 오류가 발생했어요. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "다른 모든 세션에서 로그아웃했어요.";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "2단계 인증을 해제하면 비밀번호만으로도 새 기기에서 로그인이 가능합니다. 계속하시겠습니까?";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "2단계 인증 활성화";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "2단계 인증이 실행 중입니다. 지금 필요한 추가 작업은 없습니다. 다음 번 새 장치에서 로그인 시 보안 코드가 발송됩니다.";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "인벤토리 개인정보 설정을 업데이트했어요. 인벤토리 설정과 거래 설정은 일관성을 유지해야 합니다.";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "알림 설정을 업데이트하는 중 오류가 발생했어요. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "거래 개인정보 설정을 업데이트했어요. 인벤토리 설정과 거래 설정은 일관성을 유지해야 합니다.";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "유효하지 않은 코드입니다. 코드를 확인하신 후 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "주의";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "현재 사용할 수 없는 기능입니다. 나중에 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "오류가 발생했어요. 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "코드 입력 시도 가능 횟수를 초과했어요.";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "비밀번호가 일치하지 않습니다. 확인 후 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "유효하지 않은 전화번호 형식입니다. 확인 후 다시 시도하세요.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "전화번호가 삭제되었습니다";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "전화번호 업데이트를 완료했어요!";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "전화번호가 이미 다른 계정에 연결되어 있어요.";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "설정을 변경하려면 PIN을 입력하세요.";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "유효하지 않은 소셜 네트워크 링크입니다.";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "죄송합니다. 13세 미만으로 나이를 변경할 수 없습니다. 13세 미만 사용자는 새로 계정을 만든 후 고객지원으로 사용 중인 계정의 삭제를 요청하세요.";
	}
}
