namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_ja_jp : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "さらに読み込む";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "更新をキャンセル";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "メールアドレスを追加";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "電話番号を追加";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "キャンセル";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "メールアドレスの変更";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "OK";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "アップデート";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "OK";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "買う";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "閉じる";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "電話番号の編集";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "電話番号を削除";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "買う";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "いいえ";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "追加";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "OK";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "アンロック";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "削除";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "キャンセル";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "送信";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "OK";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "アップデート";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "OK";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "メールアドレスを認証";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "再試行";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "認証";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "コードを再送信";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "キャンセル";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "はい";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "非表示";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "加入";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "Builders Clubに加入";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "保存";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "表示";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "サインアウト";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "切断";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "OK";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "ブロックを解除";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "メンバーシップをアップグレード";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "このアカウントにアカウント制限を設定して、アカウント設定や不適切なコンテンツへのアクセスを制限することができます";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "Robloxメールアドレスのリセット";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Robloxを閉じた後でも、このパソコンで通知が見れます。";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "通知を見るには、ブラウザのプッシュ通知を有効にするよう求められる場合があります。";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "このデバイスのデスクトップ通知。";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "国コードを確認して、電話番号を入力してください。認証完了用のテキストメッセージが送信されます。（ご注意: 通信料がかかる場合があります）";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "認証用メールを送信しました";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "新しいメールアドレスの認証が完了するまでは、アカウントのメールアドレスは変更されません。";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "パスワードが変更されました。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "重要: アカウントの最初の作成日とフォーラムへの投稿数は、新しいユーザーネームに引き継がれます。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "ユーザーネームを1度だけ無料で変更できます。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "以前のフォーラムへの投稿は、以前のユーザーネームで表示され、新しいユーザーネームには引き継がれません。";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "ユーザーネームの変更";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "新しい電話番号の認証が完了するまでは、電話番号は変更されません。";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "ユーザーネームを変更する前に、メールアドレスの登録と認証が必要です。";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "登録ありがとうございます！認証用メールを送信しました。";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "ユーザーネームを変更する前に、メールアドレスの認証が必要です。";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "Facebookとの接続を解除する前に、パスワードを追加してアカウントを保護してください。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "アカウントPINを追加する前に、メールアドレスの登録と認証が必要です。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "二段階認証を有効にする前に、メールアドレスの登録と認証が必要です。";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "ユーザーネームを変更する前に、メールアドレスの登録と認証が必要です。";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "アカウントに設定されているアカウントPINを入力してください";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "アカウントPINを追加する前に、メールアドレスの認証が必要です。";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "二段階認証を有効にする前に、メールアドレスの認証が必要です。";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "ユーザーネームを変更する前に、メールアドレスの認証が必要です。";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "あなたは、規約違反を報告するファストトラック報告プログラムに参加しています。規約違反のご報告は現在、簡易レビュー中です。これからも規約違反の報告をして、プログラムへのご協力をお願いします。Robloxでの体験をポジティブなものにするためにご協力ありがとうございます。";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "統計";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "Roblox以外の場所であなたを特定できるような情報を提供しないようご注意ください。";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "信用度とは、規約違反の報告がモデレータにどれくらい採用されたかを表しています。報告をいくつか送信した後、あなたのスコアが表示されます。「全員」は、ファストトラックの全メンバーをグループとして表しています。";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "年齢を13歳未満に更新すると、プライバシーモードが有効になります。";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "パスワードの変更";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "ユーザーネームの変更";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "メールアドレスのアップデート";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "ご請求とお支払いについてのお問い合わせ: info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "あなたは、まだメンバーではありません。今すぐBuilders Clubに加入してください！";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "あなたは、まだメンバーではありません。今すぐRoblox Premiumに加入してください！";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "デバイスのホーム画面に通知を見てください。Robloxのアプリから、オンオフの設定を行うことができます。";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "このデバイスのモバイル用プッシュ通知。";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "マイストリームに通知で通知を見てください。通知を表示するには、上のバーの通知アイコンをクリックします。";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "通知タイプをオフにすると、そのタイプの新しい通知は届かなくなります。";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "ご注意: メンバーシップの更新をキャンセルするには、ウェブサイトからログインしてください。";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "保存しました！";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "認証済みメールアドレスが必要です";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Robloxユーザーネームの変更";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Robloxメールアドレスの認証";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Robloxアカウントの認証";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "自分についての説明を記入（最大1000文字）";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "例 www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "例 http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "例 www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "例 @Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "例 www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "アカウントコントロールについて";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "アカウント情報";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "ご請求";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "ブロック済みユーザー";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "連絡先設定";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "デスクトッププッシュ";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "パスワードを追加:";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "電話番号を追加";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "メールアドレスの変更";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "メールアドレスを変更しました";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "パスワードの変更";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "ユーザーネームの変更";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "エラー";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "電話番号の編集";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "資金が足りません";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "無効なユーザーネーム";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "PINを追加";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "成功";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "アカウントPINが必要です";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "電話番号を削除";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "認証済みメールアドレスが必要です";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "メールアドレスを認証";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "電話番号を認証";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "ファストトラック";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "メンバーシップ状況";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "通知タイミング";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "通知";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "通知タイミング";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "デスクトッププッシュ";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "モバイルプッシュ";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "通知ストリーム";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "通知ストリーム";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "その他の設定";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "マイ設定";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "パーソナル";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "アカウントPIN";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "プライバシー設定";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "更新日";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "アカウント制限";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "セキュアサインアウト";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "ソーシャルネットワーク";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "ソーシャルサインオン";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "成功";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "アカウント情報";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "ご請求";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "ファストトラック";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "通知";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "プライバシー";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "セキュリティ";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "取引";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "二段階認証";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "アカウントPINは現在無効になっています";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "アカウントPINは現在有効になっています";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "アカウント制限は現在無効になっています";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "アカウント制限は現在有効になっています";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "メールアドレスを追加";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "保護者のメールアドレスを追加";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "パスワードを追加:";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "電話番号を追加";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "電話番号を追加";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "ご請求とお支払いについてのお問い合わせ:";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "費用";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "日付";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "詳細";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "サービスは現在無効になっています。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "取引がありません";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "支払いタイプ";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "生年月日";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "ユーザーネームの変更";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "言語を選ぶ";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "オフ";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "接続アカウント:";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "国/地域を選ぶ";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "場所";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "ダーク";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "メールアドレスを追加";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "保護者のメールアドレスを追加";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "電話番号";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "アカウントのパスワードの認証";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "メールアドレスの変更";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "メールアドレスの変更";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "保護者のメールアドレスを変更";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "パスワード確認";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "現在のパスワード";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "新しいパスワード";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "アカウントのパスワード";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "希望するユーザーネーム （3〜20 文字）";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "PINの確認";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "現在の番号:";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "メールアドレスを変更しました";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "メールアドレスが必要です";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "認証済みメールアドレス:";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "アカウントのパスワードの認証";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "あなたの電話に送信されたコードを入力してください";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "SMS認証";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "カスタム";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "デフォルト";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "全員";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "友達、フォロー中のユーザー、フォロワー";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "友達、フォロー中のユーザー";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "友達";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "高";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "低";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "中";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "なし";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "なし";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "オフ";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "メールアドレス:";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "保護者のメールアドレス:";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "認証を待っています";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "終了日";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook:";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "信用度";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "全員";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "月";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "年";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "統計";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "あなた";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "性別";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+:";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "ライト";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "言語";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "あなたは、まだメンバーではありません。今すぐRoblox Premiumに加入してください！";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "VIPサーバーに招待されました";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "誰かからチャットが届きました";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "一緒にプレイする新しいゲームがピン付けされました";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "解析レポートがあります";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "友達リクエストが承認されました";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "友達リクエストが届きました";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "アップデート通知を受け取る";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "パーティに招待されました";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "誰かがパーティに参加しました";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "プライベートメッセージが届きました";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "ゲームの編集に招待されました";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "パスワード:";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "電話番号:";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "分";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "残り時間";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "秒";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "以前のユーザーネーム:";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "プライバシーモード";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "更新日";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "すべてのセッションからサインアウト";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "公開範囲:";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "壁紙テーマ";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "カスタム - 設定を自分で管理します。デフォルト - 友達とのチャットやメッセージを可能にします。オフ - チャットやメッセージを無効にします。";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "すべての設定がロックされています。編集するには、PINを使用してアンロックしてください";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "クリックして設定ページをロック";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "詳細については、こちらをクリックして確認してください";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "この設定は、アプリ内やネット上でこのユーザーが誰とチャットできるかを管理します（ゲーム内とは別の設定）。この設定で、フォーラムやグループ掲示板へのこのユーザーの投稿を禁止することもできます。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "この設定は、ゲーム内でこのユーザーが誰とチャットできるかを管理します。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "登録した電話番号からあなたを検索できる人を設定することができます。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "この設定は、VIPサーバーでこのユーザーが誰と一緒に行動できるかを管理します。VIPサーバーは、サーバー管理者からの招待があった場合にのみ参加できるサーバーです。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "この設定は、自分がどのゲームに参加しているかを確認したり、サーバー上で一緒に行動できる相手を管理します。「なし」を選択すると、特定サーバーで自分をフォローできる相手は存在しませんが、自分は他のユーザーとプレイできるようになります。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "この設定は、このユーザーがメッセージの受信トレイでメッセージを受信できる相手を管理します。";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "あなたのインベントリを見れる人を設定できます。";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "取引品質フィルタ";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter:";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "二段階認証を有効にする";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "認証済みメールアドレスが必要です。";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "アカウントのセキュリティを向上させましょう。新しいデバイスからログインする際にコードの入力が必要になります。";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "あなたのアカウントは保護されています！";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "メールアドレスのアップデート";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "電話番号のアップデート";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "デバイスの言語を使う";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "ユーザーネーム:";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "認証済み";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "認証";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "アプリ内でチャット可能な相手。";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "チャット可能な相手。";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "電話番号からの検索を許可する対象";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "VIPサーバーに招待してもらえる相手。";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "参加できる相手。";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "メッセージを受信できる相手。";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "あなたのインベントリを見れるユーザー。";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "取引できる相手";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "Xboxのアカウントで接続";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube:";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Robuxが不足しています";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "アカウントにはすでにPINが設定されています。他のリクエストを行ってください。";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "アカウントがロックされています。操作を実行する前にアカウントをアンロックしてください。";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "問題が発生しました。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "メールアドレスは認証済みです。";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "この機能は現在無効になっています。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "パスワードが間違っています。";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "メールアドレスが無効です。";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "このアカウントに関連付けられたメールアドレスはありません。";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "PINはロックされています。";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "このアドレスは、現在のメールアドレスです。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "このメールアドレスに関連付けられているメールアドレスが多すぎます。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "メールアドレスのアップデート試行回数が多すぎます。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "認証メールアドレス送信の試行回数が多すぎます。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "不明なエラーが発生しました。";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "PINが間違っています。";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "PINの形式が間違っています。";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "アカウントにPINが設定されていません。";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "アカウントに認証済みメールアドレスが設定されていません。";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "システムエラーです。";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "リクエストが多すぎます。後でもう一度お試しください。";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "メールアドレスを追加しました";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "あなたのメールアドレスは認証済みです！";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "この機能は現在無効になっています。後でもう一度お試しください。";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "Robuxが不足しているためユーザーネームを変更できません。";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "無効なメールアドレス";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "アカウントにメールアドレスを関連付ける必要があります";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "Robuxが不足しているためユーザーネームを変更できません。";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "PINはロックされています。";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "このアドレスは、現在の認証済みメールアドレスです。";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "設定をアップデートしました。";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "このメールアドレスに関連付けられているメールアドレスが多すぎます。";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "試行回数が多すぎます。後でもう一度お試しください。";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "不明なエラーが発生しました。";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "パスワードが間違っています。";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "コードが間違っています。電話番号をもう一度チェックしてからお試しください。";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "「取引できる相手」は「あなたのインベントリを見れるユーザー」と同じか、より制限の厳しい値である必要があります。";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "コードが必要です。コードを入力してください。";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "生年月日を13歳未満に設定すると、取り消すことはできません。よろしいですか？";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "生年月日を変更するには、Robloxアカウントへのパスワードを追加する必要があります。";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "パスワードを追加する必要があります";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "生年月日を13歳未満に変更すると、取り消すことができません。Facebookからのソーシャルサインオンは無効になり、Robloxのパスワードでのサインオンが必要になります。";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "現在のパスワードが間違っています。パスワードは変更されませんでした。";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "パスワードが一致しません";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "8文字以上である必要があります";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "ユーザーネームを入力して下さい。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "Robloxには適切でないユーザーネームです。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "このユーザーネームはすでに使われています。";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "ユーザーネームを変更しました。";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "国名リストの読み込み中にエラーが発生しました";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "通貨サービスにエラーが発生しました。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "問題が発生しました。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "エラーが発生しました";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "保存しました！";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "Xboxアカウントの接続の切断中にエラーが発生しました。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "認証用Eメールを送信しました。";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "メールアドレスが無効です";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "無効な電話番号";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "「送信」を押してチケットを送信するか、「キャンセル」を押してユーザーネームを編集してください。ユーザーネームはとても重要な情報であり、発生した問題を素早く解決するのに役立ちます。";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "パスワードは8文字以上で 少なくとも2つの数字、4つの文字、1つの記号を含んでいなければなりません。";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "PINが設定されました。今後設定ページにアクセスするには、このPINを入力する必要があります。";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "PINが一致しません";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "すべてのセッションからのサインアウト中にエラーが発生しました。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "すべてのセッションからサインアウトしました。";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "二段階認証をオフにすると、新しいデバイスからログインする際にパスワードのみが求められるようになります。よろしいですか？";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "二段階認証が有効になっています";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "アカウントの保護が完了しました！これで現在行う必要のある操作は完了です。今後新しいデバイスからログインする際に、セキュリティコードが送信されます。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "インベントリのプライバシー設定をアップデートしました。インベントリと取引設定に矛盾がないことが必要です。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "通知設定のアップデート中にエラーが発生しました。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "取引のプライバシー設定をアップデートしました。インベントリと取引設定に矛盾がないことが必要です。";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "コードが間違っています。電話番号をもう一度チェックしてからお試しください。";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "警告";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "この機能は現在無効になっています。後でもう一度お試しください。";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "エラーが発生しました。もう一度お試しください。";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "間違ったコードが何度も繰り返し入力されました。";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "パスワードが間違っています。パスワードをチェックしてからもう一度お試しください。";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "電話番号の形式が間違っています。もう一度チェックしてからお試しください。";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "電話番号が削除されました";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "電話番号がアップデートされました！";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "すでに他のアカウントと関連付けられている番号です。";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "設定を変更するにはPINを入力してください。";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "ソーシャルネットワークのリンクが無効です。";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "申し訳ありませんが、生年月日を13歳未満には変更できません。あなたが13歳未満の場合は、新しいアカウントを作成してから、サポートに古いアカウントの削除を依頼してください。";

	public AccountSettingsResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "さらに読み込む";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "更新をキャンセル";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "メールアドレスを追加";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "電話番号を追加";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "キャンセル";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "メールアドレスの変更";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "アップデート";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "買う";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "閉じる";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "電話番号の編集";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "電話番号を削除";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "買う";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "いいえ";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "追加";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "アンロック";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "削除";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "キャンセル";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "送信";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "アップデート";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "メールアドレスを認証";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "再試行";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "認証";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "コードを再送信";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "キャンセル";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "はい";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "非表示";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "加入";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "Builders Clubに加入";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "保存";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "表示";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "サインアウト";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "切断";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "ブロックを解除";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "メンバーシップをアップグレード";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "このアカウントにアカウント制限を設定して、アカウント設定や不適切なコンテンツへのアクセスを制限することができます";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Robloxメールアドレスのリセット{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}Robloxメールアドレスのリセット{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"Robloxユーザー様、{lineBreak}{lineBreak}{username}アカウントのメールアドレスが{oldEmailAddress}から{newEmailAddress}に変更されました。間違って変更してしまった場合や、お心当たりがない場合、こちらのリンク{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}をクリックして、元のメールアドレスに戻してください。また、新しいパスワードを入力する必要があります。そうすることで、アカウントを完全に安心してご利用いただくことができます。{lineBreak}{lineBreak}Robloxの新しいメールアドレスに問題がなければ、何もする必要はありません。新しいメールアドレスはすでに設定されています。{lineBreak}{lineBreak}このメッセージには返信しないでください。何かご質問があれば、{robloxInfoEmailAddress}にメールでお問い合わせください。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "Robloxユーザー様、{lineBreak}{lineBreak}{username}アカウントのメールアドレスが{oldEmailAddress}から{newEmailAddress}に変更されました。間違って変更してしまった場合や、お心当たりがない場合、こちらのリンク{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}をクリックして、元のメールアドレスに戻してください。また、新しいパスワードを入力する必要があります。そうすることで、アカウントを完全に安心してご利用いただくことができます。{lineBreak}{lineBreak}Robloxの新しいメールアドレスに問題がなければ、何もする必要はありません。新しいメールアドレスはすでに設定されています。{lineBreak}{lineBreak}このメッセージには返信しないでください。何かご質問があれば、{robloxInfoEmailAddress}にメールでお問い合わせください。";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"Robloxユーザー様、{lineBreak}{lineBreak}{username}アカウントのメールアドレスが{oldEmailAddress}から{newEmailAddress}に変更されました。間違って変更してしまった場合や、お心当たりがない場合、こちらのリンク{lineBreak}{revertAccountEmailLink}{lineBreak}をクリックして、元のメールアドレスに戻してください。また、新しいパスワードを入力する必要があります。そうすることで、アカウントを完全に安心してご利用いただくことができます。{lineBreak}{lineBreak}Robloxの新しいメールアドレスに問題がなければ、何もする必要はありません。新しいメールアドレスはすでに設定されています。{lineBreak}このメッセージには返信しないでください。何かご質問があれば、{robloxInfoEmailAddress}にメールでお問い合わせください。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "Robloxユーザー様、{lineBreak}{lineBreak}{username}アカウントのメールアドレスが{oldEmailAddress}から{newEmailAddress}に変更されました。間違って変更してしまった場合や、お心当たりがない場合、こちらのリンク{lineBreak}{revertAccountEmailLink}{lineBreak}をクリックして、元のメールアドレスに戻してください。また、新しいパスワードを入力する必要があります。そうすることで、アカウントを完全に安心してご利用いただくことができます。{lineBreak}{lineBreak}Robloxの新しいメールアドレスに問題がなければ、何もする必要はありません。新しいメールアドレスはすでに設定されています。{lineBreak}このメッセージには返信しないでください。何かご質問があれば、{robloxInfoEmailAddress}にメールでお問い合わせください。";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "Robloxメールアドレスのリセット";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"このアカウントは、プラットフォームで精選したコンテンツにのみアクセスできます。さらに連絡先設定（{linkStart}プライバシー{linkEnd}ページ内）はオフに設定されます。";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "このアカウントは、プラットフォームで精選したコンテンツにのみアクセスできます。さらに連絡先設定（{linkStart}プライバシー{linkEnd}ページ内）はオフに設定されます。";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"最大{maxBlockedCount}人中{totalBlockedCount}人のユーザーをブロックしています:";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "最大{maxBlockedCount}人中{totalBlockedCount}人のユーザーをブロックしています:";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"アカウント制限（{linkStart}セキュリティ{linkEnd}ページ内）が有効のため連絡先設定はロックされています";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "アカウント制限（{linkStart}セキュリティ{linkEnd}ページ内）が有効のため連絡先設定はロックされています";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Robloxを閉じた後でも、このパソコンで通知が見れます。";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "通知を見るには、ブラウザのプッシュ通知を有効にするよう求められる場合があります。";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "このデバイスのデスクトップ通知。";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "国コードを確認して、電話番号を入力してください。認証完了用のテキストメッセージが送信されます。（ご注意: 通信料がかかる場合があります）";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "認証用メールを送信しました";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "新しいメールアドレスの認証が完了するまでは、アカウントのメールアドレスは変更されません。";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "パスワードが変更されました。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "重要: アカウントの最初の作成日とフォーラムへの投稿数は、新しいユーザーネームに引き継がれます。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "ユーザーネームを1度だけ無料で変更できます。";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "以前のフォーラムへの投稿は、以前のユーザーネームで表示され、新しいユーザーネームには引き継がれません。";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"{robuxIcon} {price} でユーザーネームを変更しますか？";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "{robuxIcon} {price} でユーザーネームを変更しますか？";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "ユーザーネームの変更";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "新しい電話番号の認証が完了するまでは、電話番号は変更されません。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "ユーザーネームを変更する前に、メールアドレスの登録と認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "登録ありがとうございます！認証用メールを送信しました。";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "ユーザーネームを変更する前に、メールアドレスの認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "Facebookとの接続を解除する前に、パスワードを追加してアカウントを保護してください。";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"ユーザーネームの変更には、あと {robuxToBuy} 必要です。Robuxを追加購入しますか？";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "ユーザーネームの変更には、あと {robuxToBuy} 必要です。Robuxを追加購入しますか？";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "アカウントPINを追加する前に、メールアドレスの登録と認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "二段階認証を有効にする前に、メールアドレスの登録と認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "ユーザーネームを変更する前に、メールアドレスの登録と認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "アカウントに設定されているアカウントPINを入力してください";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"末尾が {phoneLast4} の電話番号を削除してよろしいですか？";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "末尾が {phoneLast4} の電話番号を削除してよろしいですか？";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "アカウントPINを追加する前に、メールアドレスの認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "二段階認証を有効にする前に、メールアドレスの認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "ユーザーネームを変更する前に、メールアドレスの認証が必要です。";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "あなたは、規約違反を報告するファストトラック報告プログラムに参加しています。規約違反のご報告は現在、簡易レビュー中です。これからも規約違反の報告をして、プログラムへのご協力をお願いします。Robloxでの体験をポジティブなものにするためにご協力ありがとうございます。";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "統計";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "Roblox以外の場所であなたを特定できるような情報を提供しないようご注意ください。";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "信用度とは、規約違反の報告がモデレータにどれくらい採用されたかを表しています。報告をいくつか送信した後、あなたのスコアが表示されます。「全員」は、ファストトラックの全メンバーをグループとして表しています。";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "年齢を13歳未満に更新すると、プライバシーモードが有効になります。";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "パスワードの変更";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "ユーザーネームの変更";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "メールアドレスのアップデート";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "ご請求とお支払いについてのお問い合わせ: info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "あなたは、まだメンバーではありません。今すぐBuilders Clubに加入してください！";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "あなたは、まだメンバーではありません。今すぐRoblox Premiumに加入してください！";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "デバイスのホーム画面に通知を見てください。Robloxのアプリから、オンオフの設定を行うことができます。";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "このデバイスのモバイル用プッシュ通知。";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "マイストリームに通知で通知を見てください。通知を表示するには、上のバーの通知アイコンをクリックします。";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "通知タイプをオフにすると、そのタイプの新しい通知は届かなくなります。";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "ご注意: メンバーシップの更新をキャンセルするには、ウェブサイトからログインしてください。";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "保存しました！";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "認証済みメールアドレスが必要です";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"新しいデバイスからログインしたときに、{email}にコードが送信されます。";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "新しいデバイスからログインしたときに、{email}にコードが送信されます。";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"Robloxユーザー様、{lineBreaks}あなたのユーザーネームが最近{oldUsername}から{newUsername}に変更されました。お心当たりがない場合は、{robloxInfoEmailAddress}にメールにてご連絡ください。";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "Robloxユーザー様、{lineBreaks}あなたのユーザーネームが最近{oldUsername}から{newUsername}に変更されました。お心当たりがない場合は、{robloxInfoEmailAddress}にメールにてご連絡ください。";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Robloxユーザーネームの変更{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Robloxユーザーネームの変更{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Robloxユーザーネームの変更";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Robloxメールアドレスの認証{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Robloxメールアドレスの認証{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Robloxアカウントの認証{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Robloxアカウントの認証{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"Robloxユーザー様、{lineBreak}{lineBreak}メールアドレスによる{username}のアカウント保護にご協力ありがとうございます。{lineBreak}Robloxアカウントに関連付けされたメールアドレスを認証することにより、アカウントのセキュリティを向上できます。{lineBreak}下のボタンをクリックして認証処理を完了してください。{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}メールアドレスの認証{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "Robloxユーザー様、{lineBreak}{lineBreak}メールアドレスによる{username}のアカウント保護にご協力ありがとうございます。{lineBreak}Robloxアカウントに関連付けされたメールアドレスを認証することにより、アカウントのセキュリティを向上できます。{lineBreak}下のボタンをクリックして認証処理を完了してください。{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}メールアドレスの認証{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"{lineBreak}{lineBreak}あなたのお子様がRobloxで{boldTagStart}{username}{boldTagEnd}のアカウントを作りました。Robloxは、ユーザーが作成した3Dの世界に入り込んで、イマジネーションを膨らませたり、ゲーム制作をしたり、一緒にプレイしたりできるオンラインのエンターテイメントプラットフォームです。このプラットフォームは、「Roblox Studio」という無料のゲーム開発ツールも提供しています。このツールは、簡単なドラッグアンドドロップによる作成体験から、複雑なマルチプレイヤーゲームまで、ユーザーが想像するものを何でも作り出すことができます。数百万人の子供たちがRobloxを使用して、究極のテーマパークのようなものを作ることを想像したり、プロのカーレースドライバーになって競争したり、ファッションショーに出演したり、夢のお家を作って友達と楽しい時間を過ごしたりしています。{lineBreak}{lineBreak}このメールは、お子様がユーザー名、生年月日、保護者の方のメールアドレスを登録されたことをお知らせするものです。保護者のメールアドレスは、アカウント管理、パスワードを忘れた場合のパスワードのリセット、お子様のアカウントへのアクセスを保護者の方にお知らせする目的にのみ使用します。このメールアドレスを認証するには、以下のボタンをクリックしてください: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}メールアドレスの認証{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Robloxについて{boldTagEnd}{lineBreak}{lineBreak}Robloxは、楽しくファミリーフレンドリーな環境を作り上げるため努力を続けています。セイフティ機能の改善に常に取り組んでいます。デジタルセイフティの専門家とともに、すべてのプレイヤーが安全で快適にプレイしたり、チャットしたり、制作プロジェクトでコラボレーションを行うことのできる場所を提供するために日々努力を続けています。保護者の方へのご案内をお読みいただき、Robloxでお子様が楽しい体験をしていただけるよう、このプラットフォームへのご理解をお願い申し上げます: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Robloxでは{boldTagStart}保護者による制限{boldTagEnd}もご用意しております。保護者のPINを有効にして、お子様の通信やチャットの設定を変更することができます。この制限については、お子様のアカウントでログインいただき、アカウント設定のセキュリティとプライバシータブでご確認ください。{lineBreak}{lineBreak}保護者のPINを追加するには: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}チャット設定を変更するには: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}プライバシー{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}{lineBreak}このメールには返信しないでください。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "{lineBreak}{lineBreak}あなたのお子様がRobloxで{boldTagStart}{username}{boldTagEnd}のアカウントを作りました。Robloxは、ユーザーが作成した3Dの世界に入り込んで、イマジネーションを膨らませたり、ゲーム制作をしたり、一緒にプレイしたりできるオンラインのエンターテイメントプラットフォームです。このプラットフォームは、「Roblox Studio」という無料のゲーム開発ツールも提供しています。このツールは、簡単なドラッグアンドドロップによる作成体験から、複雑なマルチプレイヤーゲームまで、ユーザーが想像するものを何でも作り出すことができます。数百万人の子供たちがRobloxを使用して、究極のテーマパークのようなものを作ることを想像したり、プロのカーレースドライバーになって競争したり、ファッションショーに出演したり、夢のお家を作って友達と楽しい時間を過ごしたりしています。{lineBreak}{lineBreak}このメールは、お子様がユーザー名、生年月日、保護者の方のメールアドレスを登録されたことをお知らせするものです。保護者のメールアドレスは、アカウント管理、パスワードを忘れた場合のパスワードのリセット、お子様のアカウントへのアクセスを保護者の方にお知らせする目的にのみ使用します。このメールアドレスを認証するには、以下のボタンをクリックしてください: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}メールアドレスの認証{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Robloxについて{boldTagEnd}{lineBreak}{lineBreak}Robloxは、楽しくファミリーフレンドリーな環境を作り上げるため努力を続けています。セイフティ機能の改善に常に取り組んでいます。デジタルセイフティの専門家とともに、すべてのプレイヤーが安全で快適にプレイしたり、チャットしたり、制作プロジェクトでコラボレーションを行うことのできる場所を提供するために日々努力を続けています。保護者の方へのご案内をお読みいただき、Robloxでお子様が楽しい体験をしていただけるよう、このプラットフォームへのご理解をお願い申し上げます: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Robloxでは{boldTagStart}保護者による制限{boldTagEnd}もご用意しております。保護者のPINを有効にして、お子様の通信やチャットの設定を変更することができます。この制限については、お子様のアカウントでログインいただき、アカウント設定のセキュリティとプライバシータブでご確認ください。{lineBreak}{lineBreak}保護者のPINを追加するには: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}チャット設定を変更するには: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}プライバシー{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}{lineBreak}このメールには返信しないでください。{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"この制限については、お子様のアカウントでログインいただき、アカウント設定のセキュリティとプライバシータブでご確認ください。{lineBreak}{lineBreak}保護者のPINを追加するには: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}{lineBreak}{lineBreak}チャット設定を変更するには: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}プライバシー{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}{lineBreak}このメールには返信しないでください。{lineBreak}{lineBreak}{aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "この制限については、お子様のアカウントでログインいただき、アカウント設定のセキュリティとプライバシータブでご確認ください。{lineBreak}{lineBreak}保護者のPINを追加するには: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}{lineBreak}{lineBreak}チャット設定を変更するには: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}プライバシー{boldTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}{lineBreak}このメールには返信しないでください。{lineBreak}{lineBreak}{aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd}{lineBreak}{lineBreak}{aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"Robloxユーザー様、{lineBreak}{lineBreak}メールアドレスによる{username}のアカウント保護にご協力ありがとうございます。{lineBreak}Robloxアカウントに関連付けされたメールアドレスを認証することにより、アカウントのセキュリティを向上できます。{lineBreak}下のリンクをクリックして認証処理を完了してください。{lineBreak}{verificationLink}\n";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "Robloxユーザー様、{lineBreak}{lineBreak}メールアドレスによる{username}のアカウント保護にご協力ありがとうございます。{lineBreak}Robloxアカウントに関連付けされたメールアドレスを認証することにより、アカウントのセキュリティを向上できます。{lineBreak}下のリンクをクリックして認証処理を完了してください。{lineBreak}{verificationLink}\n";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"{lineBreak}{lineBreak}あなたのお子様がRobloxで{username}のアカウントを作成されました。Robloxは、ユーザーが作成した3Dの世界に入り込んで、イマジネーションを膨らませたり、ゲーム制作をしたり、一緒に遊んだりできるオンラインのエンターテイメントプラットフォームです。このプラットフォームは、「Roblox Studio」という無料のゲーム開発ツールも提供しています。このツールは、簡単なドラッグアンドドロップによる作成体験から、複雑なマルチプレイヤーゲームまで、ユーザーが想像するものを何でも作り出すことができます。数百万人の子供たちがRobloxを使用して、究極のテーマパークのようなものを作ることを想像したり、プロのカーレースドライバーになって競争したり、ファッションショーに出演したり、夢のお家をを作って友達と楽しい時間を過ごしたりしています。{lineBreak}{lineBreak}このメールは、お子様がユーザー名、生年月日、保護者の方のメールアドレスを登録されたことをお知らせするものです。保護者のメールアドレスは、アカウント管理、パスワードを忘れた場合のパスワードのリセット、お子様のアカウントへのアクセスを保護者の方にお知らせする目的にのみ使用します。このメールアドレスを認証するには、以下のボタンをクリックしてください: {lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Robloxについて{lineBreak}{lineBreak}Robloxは、楽しくファミリーフレンドリーな環境を作り上げるため努力を続けています。セイフティ機能の改善に常に取り組んでいます。デジタルセイフティの専門家とともに、すべてのプレイヤーが安全で快適にプレイしたり、チャットしたり、制作プロジェクトでコラボレーションを行うことのできる場所を提供するために日々努力を続けています。保護者の方へのご案内をお読みいただき、Robloxでお子様が楽しい体験をしていただけるよう、このプラットフォームへのご理解をお願い申し上げます: {parentalPageLink}{lineBreak}{lineBreak}Robloxでは保護者による制限もご用意しております。保護者のPINを有効にして、お子様の通信やチャットの設定を変更することができます。この制限については、お子様のアカウントでログインいただき、アカウント設定のセキュリティとプライバシータブでご確認ください。{lineBreak}{lineBreak}保護者のPINを追加するには: {accountSecurityLink}{lineBreak}{lineBreak}チャット設定を変更するには: {chatPrivacyLink}{lineBreak}{lineBreak}プライバシー{lineBreak}{lineBreak}{supportPageLink}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{privacyPageLink}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}このメールには返信しないでください。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "{lineBreak}{lineBreak}あなたのお子様がRobloxで{username}のアカウントを作成されました。Robloxは、ユーザーが作成した3Dの世界に入り込んで、イマジネーションを膨らませたり、ゲーム制作をしたり、一緒に遊んだりできるオンラインのエンターテイメントプラットフォームです。このプラットフォームは、「Roblox Studio」という無料のゲーム開発ツールも提供しています。このツールは、簡単なドラッグアンドドロップによる作成体験から、複雑なマルチプレイヤーゲームまで、ユーザーが想像するものを何でも作り出すことができます。数百万人の子供たちがRobloxを使用して、究極のテーマパークのようなものを作ることを想像したり、プロのカーレースドライバーになって競争したり、ファッションショーに出演したり、夢のお家をを作って友達と楽しい時間を過ごしたりしています。{lineBreak}{lineBreak}このメールは、お子様がユーザー名、生年月日、保護者の方のメールアドレスを登録されたことをお知らせするものです。保護者のメールアドレスは、アカウント管理、パスワードを忘れた場合のパスワードのリセット、お子様のアカウントへのアクセスを保護者の方にお知らせする目的にのみ使用します。このメールアドレスを認証するには、以下のボタンをクリックしてください: {lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Robloxについて{lineBreak}{lineBreak}Robloxは、楽しくファミリーフレンドリーな環境を作り上げるため努力を続けています。セイフティ機能の改善に常に取り組んでいます。デジタルセイフティの専門家とともに、すべてのプレイヤーが安全で快適にプレイしたり、チャットしたり、制作プロジェクトでコラボレーションを行うことのできる場所を提供するために日々努力を続けています。保護者の方へのご案内をお読みいただき、Robloxでお子様が楽しい体験をしていただけるよう、このプラットフォームへのご理解をお願い申し上げます: {parentalPageLink}{lineBreak}{lineBreak}Robloxでは保護者による制限もご用意しております。保護者のPINを有効にして、お子様の通信やチャットの設定を変更することができます。この制限については、お子様のアカウントでログインいただき、アカウント設定のセキュリティとプライバシータブでご確認ください。{lineBreak}{lineBreak}保護者のPINを追加するには: {accountSecurityLink}{lineBreak}{lineBreak}チャット設定を変更するには: {chatPrivacyLink}{lineBreak}{lineBreak}プライバシー{lineBreak}{lineBreak}{supportPageLink}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{privacyPageLink}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}このメールには返信しないでください。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"チャット設定を変更するには: {chatPrivacyLink}{lineBreak}{lineBreak}プライバシー{lineBreak}{lineBreak}{supportPageLink}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{privacyPageLink}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}このメールには返信しないでください。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "チャット設定を変更するには: {chatPrivacyLink}{lineBreak}{lineBreak}プライバシー{lineBreak}{lineBreak}{supportPageLink}のカスターマーサービスにご連絡いただくことで、お子様のアカウントを削除することができます。お客様のメールアドレスを、上記以外の目的に使用したり、第三者に開示したり、お子様からご提供いただいた他の個人情報と関連付けることはありません。詳細については{privacyPageLink}のプライバシーポリシーをご確認ください。{lineBreak}{lineBreak}よろしくお願いいたします。{lineBreak}{lineBreak}Robloxチーム{lineBreak}このメールには返信しないでください。{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Robloxメールアドレスの認証";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Robloxアカウントの認証";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "自分についての説明を記入（最大1000文字）";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "例 www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "例 http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "例 www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "例 @Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "例 www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "アカウントコントロールについて";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "アカウント情報";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "ご請求";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "ブロック済みユーザー";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "連絡先設定";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "デスクトッププッシュ";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "パスワードを追加:";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "電話番号を追加";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "メールアドレスの変更";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "メールアドレスを変更しました";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "パスワードの変更";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "ユーザーネームの変更";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "エラー";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "電話番号の編集";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "資金が足りません";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "無効なユーザーネーム";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "PINを追加";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "アカウントPINが必要です";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "電話番号を削除";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "認証済みメールアドレスが必要です";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "メールアドレスを認証";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "電話番号を認証";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "ファストトラック";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "メンバーシップ状況";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "通知タイミング";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "通知";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "通知タイミング";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "デスクトッププッシュ";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "モバイルプッシュ";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "通知ストリーム";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "通知ストリーム";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "その他の設定";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "マイ設定";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "パーソナル";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "アカウントPIN";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "プライバシー設定";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "更新日";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "アカウント制限";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "セキュアサインアウト";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "ソーシャルネットワーク";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "ソーシャルサインオン";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "成功";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "アカウント情報";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "ご請求";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "ファストトラック";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "通知";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "プライバシー";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "セキュリティ";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "取引";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "二段階認証";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "アカウントPINは現在無効になっています";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "アカウントPINは現在有効になっています";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "アカウント制限は現在無効になっています";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "アカウント制限は現在有効になっています";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "メールアドレスを追加";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "保護者のメールアドレスを追加";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "パスワードを追加:";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "電話番号を追加";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "電話番号を追加";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "ご請求とお支払いについてのお問い合わせ:";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"ご請求とお支払いについては、{aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}ご請求のヘルプページ{aTagEnd}を見てください。";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "ご請求とお支払いについては、{aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}ご請求のヘルプページ{aTagEnd}を見てください。";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"末尾が{lastFourCard}のカード";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "末尾が{lastFourCard}のカード";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "費用";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "日付";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "詳細";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "サービスは現在無効になっています。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "取引がありません";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "支払いタイプ";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "生年月日";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"あなたは、まだメンバーではありません。今すぐ{startSpan}Builders Club{endSpan}に加入してください！";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "あなたは、まだメンバーではありません。今すぐ{startSpan}Builders Club{endSpan}に加入してください！";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "ユーザーネームの変更";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "言語を選ぶ";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "オフ";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "接続アカウント:";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "国/地域を選ぶ";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "場所";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "ダーク";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "メールアドレスを追加";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "保護者のメールアドレスを追加";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "電話番号";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "アカウントのパスワードの認証";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "メールアドレスの変更";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "メールアドレスの変更";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "保護者のメールアドレスを変更";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "パスワード確認";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "現在のパスワード";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "新しいパスワード";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "アカウントのパスワード";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "希望するユーザーネーム （3〜20 文字）";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "PINの確認";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"{digitCount}桁のPINを作成";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "{digitCount}桁のPINを作成";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "現在の番号:";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "メールアドレスを変更しました";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "メールアドレスが必要です";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "認証済みメールアドレス:";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "アカウントのパスワードの認証";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"コードを入力（{digitCount}桁）";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "コードを入力（{digitCount}桁）";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "あなたの電話に送信されたコードを入力してください";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "SMS認証";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "カスタム";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "デフォルト";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "全員";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "友達、フォロー中のユーザー、フォロワー";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "友達、フォロー中のユーザー";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "友達";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "高";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "低";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "中";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "なし";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "なし";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "オフ";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "メールアドレス:";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "保護者のメールアドレス:";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "認証を待っています";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "終了日";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"{startSpan}{expirationDate}{endSpan} に終了します。";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "{startSpan}{expirationDate}{endSpan} に終了します。";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook:";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "信用度";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "全員";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "月";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "年";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "統計";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "あなた";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "性別";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+:";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "ライト";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "言語";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"{startSpan}Builders Club{endSpan}メンバーシップ";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "{startSpan}Builders Club{endSpan}メンバーシップ";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "あなたは、まだメンバーではありません。今すぐRoblox Premiumに加入してください！";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "VIPサーバーに招待されました";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "誰かからチャットが届きました";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "一緒にプレイする新しいゲームがピン付けされました";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "解析レポートがあります";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "友達リクエストが承認されました";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "友達リクエストが届きました";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "アップデート通知を受け取る";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "パーティに招待されました";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "誰かがパーティに参加しました";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "プライベートメッセージが届きました";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "ゲームの編集に招待されました";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "パスワード:";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "電話番号:";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "分";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "残り時間";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "秒";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "以前のユーザーネーム:";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "プライバシーモード";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "更新日";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"{startSpan}{expirationDate}{endSpan} に自動更新されます。";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "{startSpan}{expirationDate}{endSpan} に自動更新されます。";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount} Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount} Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "すべてのセッションからサインアウト";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "公開範囲:";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"{socialUsername}として接続";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "{socialUsername}として接続";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "壁紙テーマ";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "カスタム - 設定を自分で管理します。デフォルト - 友達とのチャットやメッセージを可能にします。オフ - チャットやメッセージを無効にします。";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "すべての設定がロックされています。編集するには、PINを使用してアンロックしてください";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "クリックして設定ページをロック";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "詳細については、こちらをクリックして確認してください";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "この設定は、アプリ内やネット上でこのユーザーが誰とチャットできるかを管理します（ゲーム内とは別の設定）。この設定で、フォーラムやグループ掲示板へのこのユーザーの投稿を禁止することもできます。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "この設定は、ゲーム内でこのユーザーが誰とチャットできるかを管理します。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "登録した電話番号からあなたを検索できる人を設定することができます。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "この設定は、VIPサーバーでこのユーザーが誰と一緒に行動できるかを管理します。VIPサーバーは、サーバー管理者からの招待があった場合にのみ参加できるサーバーです。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "この設定は、自分がどのゲームに参加しているかを確認したり、サーバー上で一緒に行動できる相手を管理します。「なし」を選択すると、特定サーバーで自分をフォローできる相手は存在しませんが、自分は他のユーザーとプレイできるようになります。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "この設定は、このユーザーがメッセージの受信トレイでメッセージを受信できる相手を管理します。";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "あなたのインベントリを見れる人を設定できます。";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "取引品質フィルタ";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter:";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "二段階認証を有効にする";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "認証済みメールアドレスが必要です。";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "アカウントのセキュリティを向上させましょう。新しいデバイスからログインする際にコードの入力が必要になります。";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "あなたのアカウントは保護されています！";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "メールアドレスのアップデート";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "電話番号のアップデート";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "デバイスの言語を使う";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "ユーザーネーム:";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "認証済み";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "認証";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "アプリ内でチャット可能な相手。";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "チャット可能な相手。";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "電話番号からの検索を許可する対象";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "VIPサーバーに招待してもらえる相手。";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "参加できる相手。";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "メッセージを受信できる相手。";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "あなたのインベントリを見れるユーザー。";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "取引できる相手";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "Xboxのアカウントで接続";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube:";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Robuxが不足しています";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "アカウントにはすでにPINが設定されています。他のリクエストを行ってください。";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "アカウントがロックされています。操作を実行する前にアカウントをアンロックしてください。";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "問題が発生しました。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "メールアドレスは認証済みです。";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "この機能は現在無効になっています。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "パスワードが間違っています。";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "メールアドレスが無効です。";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "このアカウントに関連付けられたメールアドレスはありません。";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "PINはロックされています。";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "このアドレスは、現在のメールアドレスです。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "このメールアドレスに関連付けられているメールアドレスが多すぎます。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "メールアドレスのアップデート試行回数が多すぎます。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "認証メールアドレス送信の試行回数が多すぎます。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "不明なエラーが発生しました。";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "PINが間違っています。";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "PINの形式が間違っています。";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "アカウントにPINが設定されていません。";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "アカウントに認証済みメールアドレスが設定されていません。";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "システムエラーです。";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "リクエストが多すぎます。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "メールアドレスを追加しました";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "あなたのメールアドレスは認証済みです！";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "この機能は現在無効になっています。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "Robuxが不足しているためユーザーネームを変更できません。";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "無効なメールアドレス";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "アカウントにメールアドレスを関連付ける必要があります";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "Robuxが不足しているためユーザーネームを変更できません。";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "PINはロックされています。";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "このアドレスは、現在の認証済みメールアドレスです。";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "設定をアップデートしました。";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "このメールアドレスに関連付けられているメールアドレスが多すぎます。";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "試行回数が多すぎます。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "不明なエラーが発生しました。";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "パスワードが間違っています。";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "コードが間違っています。電話番号をもう一度チェックしてからお試しください。";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "「取引できる相手」は「あなたのインベントリを見れるユーザー」と同じか、より制限の厳しい値である必要があります。";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "コードが必要です。コードを入力してください。";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "生年月日を13歳未満に設定すると、取り消すことはできません。よろしいですか？";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "生年月日を変更するには、Robloxアカウントへのパスワードを追加する必要があります。";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "パスワードを追加する必要があります";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "生年月日を13歳未満に変更すると、取り消すことができません。Facebookからのソーシャルサインオンは無効になり、Robloxのパスワードでのサインオンが必要になります。";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "現在のパスワードが間違っています。パスワードは変更されませんでした。";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "パスワードが一致しません";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "8文字以上である必要があります";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "ユーザーネームを入力して下さい。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "Robloxには適切でないユーザーネームです。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "このユーザーネームはすでに使われています。";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "ユーザーネームを変更しました。";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "国名リストの読み込み中にエラーが発生しました";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "通貨サービスにエラーが発生しました。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "問題が発生しました。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "エラーが発生しました";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "保存しました！";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "Xboxアカウントの接続の切断中にエラーが発生しました。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "認証用Eメールを送信しました。";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "メールアドレスが無効です";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "無効な電話番号";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "「送信」を押してチケットを送信するか、「キャンセル」を押してユーザーネームを編集してください。ユーザーネームはとても重要な情報であり、発生した問題を素早く解決するのに役立ちます。";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "パスワードは8文字以上で 少なくとも2つの数字、4つの文字、1つの記号を含んでいなければなりません。";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "PINが設定されました。今後設定ページにアクセスするには、このPINを入力する必要があります。";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "PINが一致しません";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "すべてのセッションからのサインアウト中にエラーが発生しました。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "すべてのセッションからサインアウトしました。";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "二段階認証をオフにすると、新しいデバイスからログインする際にパスワードのみが求められるようになります。よろしいですか？";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "二段階認証が有効になっています";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "アカウントの保護が完了しました！これで現在行う必要のある操作は完了です。今後新しいデバイスからログインする際に、セキュリティコードが送信されます。";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "インベントリのプライバシー設定をアップデートしました。インベントリと取引設定に矛盾がないことが必要です。";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "通知設定のアップデート中にエラーが発生しました。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "取引のプライバシー設定をアップデートしました。インベントリと取引設定に矛盾がないことが必要です。";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "コードが間違っています。電話番号をもう一度チェックしてからお試しください。";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "警告";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "この機能は現在無効になっています。後でもう一度お試しください。";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "エラーが発生しました。もう一度お試しください。";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "間違ったコードが何度も繰り返し入力されました。";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "パスワードが間違っています。パスワードをチェックしてからもう一度お試しください。";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "電話番号の形式が間違っています。もう一度チェックしてからお試しください。";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "電話番号が削除されました";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "電話番号がアップデートされました！";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "すでに他のアカウントと関連付けられている番号です。";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "設定を変更するにはPINを入力してください。";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "ソーシャルネットワークのリンクが無効です。";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "申し訳ありませんが、生年月日を13歳未満には変更できません。あなたが13歳未満の場合は、新しいアカウントを作成してから、サポートに古いアカウントの削除を依頼してください。";
	}
}
