namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_fr_fr : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "Charger plus";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "Annuler le renouvellement";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "Ajouter une adresse e-mail";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "Ajouter un nº de téléphone";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Annuler";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "Changer d'adresse e-mail";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "OK";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "Mettre à jour";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "OK";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "Acheter";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "Fermer";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "Changer de nº de téléphone";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "Supprimer le numéro de téléphone";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "Acheter";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "Non";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "Ajouter";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "OK";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "Débloquer";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "Supprimer";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "Annuler";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Envoyer";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "OK";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "Mise à jour";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "OK";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "Vérifier l'adresse e-mail";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "Réessayer";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "Vérifier";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "Renvoyer le code";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "Annuler";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "Oui";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "Masquer";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "Rejoindre";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "Rejoindre le Builders Club";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Enregistrer";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "Afficher";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "Déconnexion";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "Déconnexion";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "OK";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "Débloquer";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "Mettre à niveau l'abonnement";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "Vous pouvez définir des limitations sur ce compte afin de limiter l'accès aux paramètres ainsi qu'au contenu non contrôlé.";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "Réinitialisation d'adresse e-mail Roblox";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Recevoir des notifications sur cet ordinateur même lorsque Roblox est fermé.";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "Pour recevoir les notifications, il te sera peut-être demandé d'activer les notifications push dans ton navigateur.";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "Notifications bureau pour cet appareil.";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "Confirme l'indicatif pays et saisis ton numéro de téléphone. Un Sms te sera envoyé pour finaliser la vérification (des frais de messagerie texte peuvent s'appliquer)";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "Un e-mail vous a été envoyé à des fins de vérification.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "L'adresse e-mail ne sera pas remplacée tant que la nouvelle n'a pas été vérifiée.";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "Vous avez changé de mot de passe.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "Important\u00a0: La date de création du compte sera transposée vers ton nouveau nom d'utilisateur.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "Changez le nom d'utilisateur une fois gratuitement.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "Les anciens messages sur les forums s'afficheront avec ton ancien nom d'utilisateur et ne seront PAS transposés vers le nouveau.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "Changer de nom d'utilisateur";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "Le numéro de téléphone ne sera pas remplacé tant que le nouveau n'a pas été vérifié.";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "Merci\u00a0! Un e-mail de vérification vous a été envoyé.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "Tu dois vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "Il faut ajouter un mot de passe pour sécuriser ton compte avant de te déconnecter de Facebook.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir ajouter un code PIN à ton compte.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir activer la vérification en 2\u00a0étapes.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "Saisis le code PIN lié à ton compte";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "Tu dois vérifier ton adresse e-mail avant de pouvoir ajouter un code PIN à ton compte.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "Tu dois vérifier ton adresse e-mail avant de pouvoir activer la vérification en 2\u00a0étapes.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "Tu dois vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "Vous avez rejoint le programme Fast Track visant à améliorer la qualité des signalements.  Vos signalements sont désormais soumis à la validation Fast Track.  Restez dans le programme en continuant à envoyer des signalements corrects. Merci de nous aider à améliorer l'expérience de jeu Roblox\u00a0!";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "Statistiques";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "Ne donnez aucune information pouvant servir à vous identifier ailleurs que sur Roblox.";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "La «\u00a0pertinence\u00a0» correspond au nombre de signalements validés par les modérateurs. Elle s'affichera après avoir soumis plusieurs signalements. «\u00a0Tout le monde\u00a0» signifie tous les membres du programme.";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "Si tu fais passer l'âge à moins de 13\u00a0ans, le Mode privé sera activé.";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "Changer de mot de passe";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "Changer de nom d'utilisateur";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "Mettre à jour l'adresse e-mail";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "Pour toute question sur les paiements et la facturation\u00a0: info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "Vous n'êtes pas encore membre. Rejoignez le Builders Club dès aujourd'hui\u00a0!";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "Tu n'es pas encore membre. Rejoins Roblox Premium maintenant !";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "Recevoir des notifications sur l'écran d'accueil de ton appareil. Tu peux les activer ou les désactiver dans l'application Roblox.";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "Notifications mobiles pour cet appareil.";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "Recevoir les notifications dans ton flux. Clique sur l'icône de notifications dans la barre supérieure pour les consulter.";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "Vous ne recevrez aucune nouvelle notification des types que vous avez désactivés.";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "Remarque\u00a0: Si tu souhaites annuler le renouvellement de ton abonnement, connecte-toi à partir du site Web.";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "Sauvegarde réussie\u00a0!";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "Vous devez fournir une adresse e-mail vérifiée.";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Changement de nom d'utilisateur Roblox";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Vérification d'adresse e-mail Roblox";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Autorisation du compte Roblox";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "Décrivez-vous en quelques mots (1\u00a0000\u00a0caractères max.)";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "p.\u00a0ex. www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "p.\u00a0ex. http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "p.\u00a0ex. www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "p.\u00a0ex. @Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "p.\u00a0ex. www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "Que sont les contrôles du compte\u00a0?";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "Infos sur le compte";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "Facturation";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "Utilisateurs bloqués";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "Paramètres de contact";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "Notifications bureau";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "Ajouter mot de passe";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "Ajouter un nº de téléphone";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "Changer mon adresse e-mail";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "Adresse e-mail changée";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "Changer de mot de passe";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "Succès";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "Succès";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "Changer de nom d'utilisateur";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "Erreur";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "Succès";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "Changer de nº de téléphone";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "Fonds insuffisants";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Nom d'utilisateur invalide";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "Ajouter code PIN";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "Succès";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "Code PIN du compte requis";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "Supprimer le nº de téléphone";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "Adresse e-mail vérifiée requise";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "Vérifier l'adresse e-mail";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "Vérifier le nº de téléphone";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "Fast Track";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "Statut de l'abonnement";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "M'avertir quand";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "Notifications";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "M'avertir quand";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "Notifications bureau";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "Notifications mobile";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "Flux de notifications";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "Flux de notifications";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "Autres paramètres";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "Mes paramètres";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "Personnel";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "Code PIN du compte";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "Paramètres de confidentialité";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "Date de renouvellement";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "Limitations du compte";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "Déconnexion sécurisée";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "Réseaux sociaux";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "Connexion via réseau social";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "Succès";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "Infos sur le compte";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "Facturation";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "Fast Track";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "Notifications";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "Confidentialité";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "Sécurité";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "Transactions";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "Vérification en 2\u00a0étapes";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "Le code PIN du compte est désactivé.";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "Le code PIN du compte est activé.";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "Les limitations du compte sont désactivées";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "Les limitations du compte sont activées";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "Ajouter une adresse e-mail";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "Ajouter une adresse e-mail parentale";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "Ajouter mot de passe\u00a0:";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "Ajouter un nº de téléphone";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "Ajouter un nº de téléphone";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "Pour toute question sur les paiements et la facturation\u00a0:";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "Coût";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "Date";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "Description";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "Le service est actuellement désactivé. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "Aucune transaction";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "Type de paiement";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "Date de naissance";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "Changer de nom d'utilisateur";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "Choix de la langue";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "Désactiver";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "Connecter le compte\u00a0:";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "Choisis ton pays/région";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "Lieu";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "Sombre";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "Ajouter mon adresse e-mail";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "Ajouter une adresse e-mail parentale";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "Numéro de téléphone";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "Vérifier le mot de passe du compte";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "Changer mon adresse e-mail";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "Changer mon adresse e-mail";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "Changer d'adresse e-mail parentale";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "Confirmer le mot de passe";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "Mot de passe actuel";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "Nouveau mot de passe";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "Mot de passe du compte";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "Nom d'utilisateur souhaité (3 à 20\u00a0caractères)";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "Confirmer ton code PIN";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "Nº de téléphone actuel\u00a0:";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "Adresse e-mail changée";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "Adresse e-mail requise";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "Adresse e-mail vérifiée\u00a0:";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "Vérifier le mot de passe du compte";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "Saisis le code que nous venons d'envoyer sur ton téléphone.";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "Vérifier le SMS";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "Personnalisé";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "Par défaut";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "Tout le monde";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "Amis, utilisateurs que je suis et abonnés";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "Amis et utilisateurs que je suis";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "Amis";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "Élevé";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "Bas";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "Moyen";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "Aucun";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "Personne";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "Désactivé";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "Adresse e-mail\u00a0:";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "Adresse e-mail parentale\u00a0:";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "En attente de vérification";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "Date d'expiration";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook\u00a0:";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "Pertinence";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "Tout le monde";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "Mois";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "Année";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "Statistiques";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "Vous";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "Sexe";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+\u00a0:";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "Clair";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "Langue";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "Tu n'es pas encore membre. Rejoins Roblox Premium maintenant !";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "Je suis invité(e) à rejoindre un serveur\u00a0VIP";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "Quelqu'un me parle";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "Quelqu'un épingle un nouveau jeu auquel jouer ensemble";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "Le rapport d'analyse est disponible";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "Quelqu'un accepte ma demande d'amitié";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "Je reçois une demande d'amitié";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "Je reçois des notifications à propos des mises à jour";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "Quelqu'un m'invite à rejoindre un groupe";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "Quelqu'un rejoint un groupe auquel j'appartiens";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "Je reçois un message privé";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "Quelqu'un m'invite à modifier un jeu";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "Mot de passe\u00a0:";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "Numéro de téléphone\u00a0:";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "min";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "Temps restant";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "s";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "Noms d'utilisateur précédents\u00a0:";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "Mode privé";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "Date de renouvellement";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "Fermer toutes les autres sessions";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "Visible par\u00a0:";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "Thème";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "Personnalisé\u00a0: définissez les paramètres comme vous le souhaitez. Par défaut\u00a0: active le chat et les messages entre amis. Désactivé\u00a0: désactive le chat et les messages.";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "Tous les paramètres sont verrouillés. Pour les modifier, entre ton code PIN.";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "Cliquer pour verrouiller ta page de paramètres";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "Cliquez ici pour en savoir plus";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "Cette option définit avec qui l'utilisateur peut discuter dans l'application et sur le site Web (distinct des discussions en jeu). Elle empêche également l'utilisateur d'écrire des messages sur les forums et le mur des groupes.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "Cette option définit avec qui l'utilisateur peut discuter en jeu.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "Cette option vous permet de contrôler qui peut vous trouver à l'aide du numéro de téléphone fourni.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "Cette option définit qui peut rejoindre l'utilisateur sur les serveurs\u00a0VIP, qui sont des serveurs qu'il n'est possible de rejoindre que sur invitation de leur propriétaire.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "Cette option définit qui peut voir dans quel jeu l'utilisateur se trouve et le rejoindre sur son serveur. Si «\u00a0Personne\u00a0» est sélectionné, aucun joueur ne pourra suivre l'utilisateur sur son serveur, mais il pourra tout de même jouer avec d'autres utilisateurs.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "Cette option définit qui peut envoyer des messages dans la boîte de réception de l'utilisateur.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "Ce paramètre détermine qui peut voir ton inventaire.";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "Filtre de qualité des échanges";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter\u00a0:";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "Activer la vérification en 2\u00a0étapes";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "Vous devez fournir une adresse e-mail vérifiée.";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "Renforce la sécurité de ton compte. Tu dois saisir un code pour te connecter sur un nouvel appareil.";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "Ton compte est protégé\u00a0!";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "Mettre à jour l'adresse e-mail";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "Mettre à jour le nº de téléphone";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "Utiliser la langue de l'appareil";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "Nom d'utilisateur\u00a0:";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "Vérifié";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "Vérifier";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "Qui peut me parler dans l'application\u00a0?";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "Qui peut faire discuter avec moi\u00a0?";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "Qui peut me trouver à l'aide de mon numéro de téléphone\u00a0?";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "Qui peut m'inviter à rejoindre un serveur\u00a0VIP\u00a0?";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "Qui peut me rejoindre ?";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "Qui peut m'envoyer des messages\u00a0?";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "Qui peut voir mon inventaire\u00a0?";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "Qui peut faire des échanges avec moi\u00a0?";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "Connecté(e) avec un compte Xbox";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube\u00a0:";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Pas assez de Robux";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "Le compte a déjà un code PIN. Essayez de faire une demande différente.";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "Le compte est verrouillé. Déverrouiller le compte avant d’effectuer l’action.";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "Un problème est survenu. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "L'adresse e-mail a déjà été vérifiée.";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "Cette fonctionnalité est actuellement désactivée. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "Mot de passe est incorrect.";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "Adresse e-mail invalide.";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "Aucune addresse mail associé au compte.";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "Le code PIN est verrouillé.";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "Cette adresse e-mail est déjà celle du compte.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "Trop de comptes sont associés à cette adresse e-mail.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "Trop de tentatives de mettre à jour l'addresse mail. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "Trop de tentatives d'envoyer le courriel de vérification. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "Une erreur inconnue s'est produite.";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "Code PIN incorrect.";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "Format non valide de PIN.";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "Aucun code PIN n’existe sur le compte.";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "Le compte ne dispose pas d'une addresse mail vérifiée.";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "Erreur système.";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "Trop de tentatives. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "Adresse e-mail ajoutée";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "Ton adresse e-mail a déjà été vérifiée\u00a0!";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "Cette fonctionnalité est actuellement désactivée. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "Vous n'avez pas assez de Robux pour changer de nom d'utilisateur.";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "Adresse e-mail invalide";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "Tu dois associer une adresse e-mail à ton compte";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "Vous n'avez pas assez de Robux pour changer de nom d'utilisateur.";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "Le code PIN est verrouillé.";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "Cette adresse e-mail est déjà celle qui est vérifiée.";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "Vos paramètres ont été mis à jour.";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "Trop de comptes sont associés à cette adresse e-mail.";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "Trop de tentatives. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "Une erreur inconnue s'est produite.";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "Ton mot de passe est incorrect.";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "Code non valide. Il faut vérifier ton téléphone, puis réessayer.";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "La valeur de \"Qui peut échanger avec moi\" doit être au moins la même ou plus restrictive que celle de \"Qui peut voire mon inventaire\".";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "Un code est nécessaire. Il faut saisir ton code.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "S'il apparaît que tu as moins de 13\u00a0ans après modification de ta date de naissance, tu ne pourras pas revenir en arrière. Veux-tu vraiment continuer\u00a0?";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "Tu dois ajouter un mot de passe à ton compte Roblox pour modifier ta date de naissance.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "Ajout de mot de passe nécessaire";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "S'il apparaît que tu as moins de 13\u00a0ans après modification de ta date de naissance, vous ne pourras pas revenir en arrière. La connexion via Facebook sera désactivée et tu devras te connecter en utilisant ton mot de passe Roblox.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "Ton mot de passe actuel est incorrect, le mot de passe n'a pas été modifié.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "Les mots de passe ne correspondent pas.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "Le nom doit compter au moins 8\u00a0caractères.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "Veuillez saisir un nom d'utilisateur.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "Nom d'utilisateur inapproprié pour Roblox.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "Ce nom d'utilisateur est déjà pris.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "Nom d'utilisateur changé.";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "Erreur lors du chargement de la liste des pays";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "Une erreur s'est produite avec le service de monnaie. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "Un problème est survenu. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "Une erreur est survenue";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "Sauvegarde réussie\u00a0!";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "Une erreur s'est produite lors de la tentative de déconnexion de ton compte Xbox. Réessaye plus tard.";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "Un e-mail vous a été envoyé à des fins de vérification.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "Adresse e-mail invalide";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "Numéro de téléphone invalide";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Appuyez sur Envoyer pour soumettre le ticket ou sur Annuler pour modifier le nom d'utilisateur. Ce dernier est très important et peut vous aider à obtenir une réponse plus rapidement.";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "Le mot de passe doit contenir au moins 2\u00a0chiffres, 4\u00a0lettres et 1\u00a0symbole et compter au moins 8\u00a0caractères.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "Ton code PIN a été défini. Tu devras saisir ce code pour accéder à ta page de paramètres à l'avenir.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "Les codes PIN ne correspondent pas.";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "Une erreur s'est produite lors de la tentative de déconnexion des autres sessions. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "Vous avez été déconnecté de toutes les autres sessions.";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "Si tu désactives la vérification en 2\u00a0étapes, seul ton mot de passe sera nécessaire pour te connecter sur un nouvel appareil. Continuer\u00a0?";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "Vérification en 2\u00a0étapes activée";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "Ton compte est maintenant protégé\u00a0! Tu n'as rien d'autre à faire pour le moment. Un code de sécurité te sera envoyé lors de ta connexion sur un nouvel appareil.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "Nous avons mis à jour le paramètre de confidentialité de ton inventaire. Les paramètres de l’inventaire et d'échange doivent être similaires.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "Une erreur s'est produite lors de la mise à jour de vos paramètres de notification. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "Nous avons mis à jour le paramètre de confidentialité des échanges. Les paramètres de l’inventaire et d'échange doivent être similaires.";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "Code non valide. Vérifie ton téléphone, puis réessaye.";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "Avertissement";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "Cette fonctionnalité est actuellement désactivée. Veuillez réessayer plus tard.";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "Une erreur est survenue. Veuillez réessayer.";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "Vous avez saisi un code incorrect à de trop nombreuses reprises.";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "Mot de passe incorrect. Veuillez vérifier le mot de passe, puis réessayez.";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "Le format du numéro de téléphone n'est pas valide. Veuillez le vérifier, puis réessayez.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "Le numéro de téléphone a été supprimé.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "Le numéro de téléphone a été mis à jour\u00a0!";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "Le numéro est déjà associé à un autre compte.";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "Tu dois saisir ton code PIN pour modifier tes paramètres.";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "Le lien vers le réseau social n'est pas valide.";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "Nos excuses, mais tu ne peux pas faire passer ton âge à moins de 13\u00a0ans. Si tu as moins de 13\u00a0ans, créé un nouveau compte et contacte l'assistance pour supprimer ton compte précédent.";

	public AccountSettingsResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "Charger plus";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "Annuler le renouvellement";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "Ajouter une adresse e-mail";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "Ajouter un nº de téléphone";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "Changer d'adresse e-mail";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "Mettre à jour";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "Acheter";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "Fermer";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "Changer de nº de téléphone";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "Supprimer le numéro de téléphone";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "Acheter";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "Non";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "Ajouter";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "Débloquer";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "Supprimer";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Envoyer";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "Mise à jour";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "Vérifier l'adresse e-mail";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "Réessayer";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "Vérifier";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "Renvoyer le code";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "Oui";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "Masquer";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "Rejoindre";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "Rejoindre le Builders Club";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Enregistrer";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "Afficher";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "Déconnexion";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "Déconnexion";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "Débloquer";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "Mettre à niveau l'abonnement";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "Vous pouvez définir des limitations sur ce compte afin de limiter l'accès aux paramètres ainsi qu'au contenu non contrôlé.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Réinitialisation d'adresse e-mail Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}Réinitialisation d'adresse e-mail Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"Bonjour,{lineBreak}{lineBreak}Nous avons remarqué que tu as modifié l'adresse de ton compte {username}, anciennement {oldEmailAddress}, en {newEmailAddress}. Au cas où ce changement n'était pas intentionnel, ou si tu penses que quelqu'un peut l'avoir effectué à ta place, clique sur ce lien{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}afin d'annuler la modification. Il te sera également demandé d'indiquer un nouveau mot de passe. De cette façon, nous pourrons nous assurer que ton compte est bien protégé.{lineBreak}{lineBreak}Si tu as bel et bien demandé à changer l'adresse e-mail de ton compte Roblox, alors tout est paré\u00a0!{lineBreak}{lineBreak}Merci de ne pas répondre à ce message. Pour toute question, contacte-nous par e-mail à l'adresse {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "Bonjour,{lineBreak}{lineBreak}Nous avons remarqué que tu as modifié l'adresse de ton compte {username}, anciennement {oldEmailAddress}, en {newEmailAddress}. Au cas où ce changement n'était pas intentionnel, ou si tu penses que quelqu'un peut l'avoir effectué à ta place, clique sur ce lien{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}afin d'annuler la modification. Il te sera également demandé d'indiquer un nouveau mot de passe. De cette façon, nous pourrons nous assurer que ton compte est bien protégé.{lineBreak}{lineBreak}Si tu as bel et bien demandé à changer l'adresse e-mail de ton compte Roblox, alors tout est paré\u00a0!{lineBreak}{lineBreak}Merci de ne pas répondre à ce message. Pour toute question, contacte-nous par e-mail à l'adresse {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"Bonjour,{lineBreak}{lineBreak}Nous avons remarqué que tu as modifié l'adresse de ton compte {username}, anciennement {oldEmailAddress}, en {newEmailAddress}. Au cas où ce changement n'était pas intentionnel, ou si tu penses que quelqu'un peut l'avoir effectué à ta place, clique sur ce lien{lineBreak}{revertAccountEmailLink}{lineBreak}afin d'annuler la modification. Il te sera également demandé d'indiquer un nouveau mot de passe. De cette façon, nous pourrons nous assurer que ton compte est bien protégé.{lineBreak}{lineBreak}Si tu as bel et bien demandé à changer l'adresse e-mail de ton compte Roblox, alors tout est paré\u00a0!{lineBreak}Merci de ne pas répondre à ce message. Pour toute question, contacte-nous par e-mail à l'adresse {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "Bonjour,{lineBreak}{lineBreak}Nous avons remarqué que tu as modifié l'adresse de ton compte {username}, anciennement {oldEmailAddress}, en {newEmailAddress}. Au cas où ce changement n'était pas intentionnel, ou si tu penses que quelqu'un peut l'avoir effectué à ta place, clique sur ce lien{lineBreak}{revertAccountEmailLink}{lineBreak}afin d'annuler la modification. Il te sera également demandé d'indiquer un nouveau mot de passe. De cette façon, nous pourrons nous assurer que ton compte est bien protégé.{lineBreak}{lineBreak}Si tu as bel et bien demandé à changer l'adresse e-mail de ton compte Roblox, alors tout est paré\u00a0!{lineBreak}Merci de ne pas répondre à ce message. Pour toute question, contacte-nous par e-mail à l'adresse {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "Réinitialisation d'adresse e-mail Roblox";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"Ce compte ne peut accéder qu'au contenu contrôlé sur la plateforme. De plus, les paramètres de contact (situés dans la page {linkStart}Confidentialité{linkEnd}) seront définis sur Désactivé.";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "Ce compte ne peut accéder qu'au contenu contrôlé sur la plateforme. De plus, les paramètres de contact (situés dans la page {linkStart}Confidentialité{linkEnd}) seront définis sur Désactivé.";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"Vous bloquez {totalBlockedCount}\u00a0utilisateurs sur les {maxBlockedCount} autorisés\u00a0:";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "Vous bloquez {totalBlockedCount}\u00a0utilisateurs sur les {maxBlockedCount} autorisés\u00a0:";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"Les paramètres de contact sont verrouillés, car les limitations du compte (situées dans la page {linkStart}Sécurité{linkEnd}) sont activées.";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "Les paramètres de contact sont verrouillés, car les limitations du compte (situées dans la page {linkStart}Sécurité{linkEnd}) sont activées.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Recevoir des notifications sur cet ordinateur même lorsque Roblox est fermé.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "Pour recevoir les notifications, il te sera peut-être demandé d'activer les notifications push dans ton navigateur.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "Notifications bureau pour cet appareil.";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "Confirme l'indicatif pays et saisis ton numéro de téléphone. Un Sms te sera envoyé pour finaliser la vérification (des frais de messagerie texte peuvent s'appliquer)";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "Un e-mail vous a été envoyé à des fins de vérification.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "L'adresse e-mail ne sera pas remplacée tant que la nouvelle n'a pas été vérifiée.";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "Vous avez changé de mot de passe.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "Important\u00a0: La date de création du compte sera transposée vers ton nouveau nom d'utilisateur.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "Changez le nom d'utilisateur une fois gratuitement.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "Les anciens messages sur les forums s'afficheront avec ton ancien nom d'utilisateur et ne seront PAS transposés vers le nouveau.";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"Changer de nom d'utilisateur pour {price}\u00a0{robuxIcon}\u00a0?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "Changer de nom d'utilisateur pour {price}\u00a0{robuxIcon}\u00a0?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "Changer de nom d'utilisateur";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "Le numéro de téléphone ne sera pas remplacé tant que le nouveau n'a pas été vérifié.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "Merci\u00a0! Un e-mail de vérification vous a été envoyé.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "Tu dois vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "Il faut ajouter un mot de passe pour sécuriser ton compte avant de te déconnecter de Facebook.";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"Il vous manque {robuxToBuy} pour changer de nom d'utilisateur. Souhaitez-vous acheter plus de Robux\u00a0?";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "Il vous manque {robuxToBuy} pour changer de nom d'utilisateur. Souhaitez-vous acheter plus de Robux\u00a0?";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir ajouter un code PIN à ton compte.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir activer la vérification en 2\u00a0étapes.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "Tu dois fournir et vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "Saisis le code PIN lié à ton compte";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"Veux-tu vraiment supprimer ton numéro de téléphone se terminant par {phoneLast4}\u00a0?";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "Veux-tu vraiment supprimer ton numéro de téléphone se terminant par {phoneLast4}\u00a0?";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "Tu dois vérifier ton adresse e-mail avant de pouvoir ajouter un code PIN à ton compte.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "Tu dois vérifier ton adresse e-mail avant de pouvoir activer la vérification en 2\u00a0étapes.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "Tu dois vérifier ton adresse e-mail avant de pouvoir changer de nom d'utilisateur.";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "Vous avez rejoint le programme Fast Track visant à améliorer la qualité des signalements.  Vos signalements sont désormais soumis à la validation Fast Track.  Restez dans le programme en continuant à envoyer des signalements corrects. Merci de nous aider à améliorer l'expérience de jeu Roblox\u00a0!";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "Statistiques";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "Ne donnez aucune information pouvant servir à vous identifier ailleurs que sur Roblox.";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "La «\u00a0pertinence\u00a0» correspond au nombre de signalements validés par les modérateurs. Elle s'affichera après avoir soumis plusieurs signalements. «\u00a0Tout le monde\u00a0» signifie tous les membres du programme.";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "Si tu fais passer l'âge à moins de 13\u00a0ans, le Mode privé sera activé.";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "Changer de mot de passe";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "Changer de nom d'utilisateur";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "Mettre à jour l'adresse e-mail";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "Pour toute question sur les paiements et la facturation\u00a0: info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "Vous n'êtes pas encore membre. Rejoignez le Builders Club dès aujourd'hui\u00a0!";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "Tu n'es pas encore membre. Rejoins Roblox Premium maintenant !";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "Recevoir des notifications sur l'écran d'accueil de ton appareil. Tu peux les activer ou les désactiver dans l'application Roblox.";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "Notifications mobiles pour cet appareil.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "Recevoir les notifications dans ton flux. Clique sur l'icône de notifications dans la barre supérieure pour les consulter.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "Vous ne recevrez aucune nouvelle notification des types que vous avez désactivés.";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "Remarque\u00a0: Si tu souhaites annuler le renouvellement de ton abonnement, connecte-toi à partir du site Web.";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "Sauvegarde réussie\u00a0!";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "Vous devez fournir une adresse e-mail vérifiée.";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"Si vous vous connectez sur un nouvel appareil, les codes seront envoyés à l'adresse {email}.";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "Si vous vous connectez sur un nouvel appareil, les codes seront envoyés à l'adresse {email}.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"Bonjour, {lineBreaks}Ton nom d'utilisateur, anciennement {oldUsername}, a été changé en {newUsername}. Si tu n'es pas à l'origine de la demande de changement de nom, envoie un e-mail à {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "Bonjour, {lineBreaks}Ton nom d'utilisateur, anciennement {oldUsername}, a été changé en {newUsername}. Si tu n'es pas à l'origine de la demande de changement de nom, envoie un e-mail à {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Changement de nom d'utilisateur Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Changement de nom d'utilisateur Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Changement de nom d'utilisateur Roblox";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Vérification d'adresse e-mail Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Vérification d'adresse e-mail Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Autorisation du compte Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Autorisation du compte Roblox{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"Bonjour,{lineBreak}{lineBreak}Nous sommes ravis que tu aies choisi de sécuriser ton compte {username} en indiquant une adresse e-mail.{lineBreak}En vérifiant l'adresse associée à ton compte Roblox, tu augmentes son niveau de sécurité.{lineBreak}Clique sur le bouton ci-dessous afin de finaliser le processus de vérification.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Vérifier l'adresse e-mail{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "Bonjour,{lineBreak}{lineBreak}Nous sommes ravis que tu aies choisi de sécuriser ton compte {username} en indiquant une adresse e-mail.{lineBreak}En vérifiant l'adresse associée à ton compte Roblox, tu augmentes son niveau de sécurité.{lineBreak}Clique sur le bouton ci-dessous afin de finaliser le processus de vérification.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Vérifier l'adresse e-mail{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Bonjour,{lineBreak}{lineBreak}Votre enfant a créé le compte {boldTagStart}{username}{boldTagEnd} sur Roblox, une plateforme de divertissement en ligne qui permet aux joueurs d'imaginer, de créer et de s'amuser ensemble dans des mondes en 3D générés par la communauté. Notre plateforme comprend également Roblox Studio, un outil de développement gratuit permettant aux utilisateurs de créer tout ce dont ils ont envie, que ce soit de simples jeux de construction ou des jeux multijoueurs plus complexes. Des millions d'enfants ont utilisé Roblox pour se lancer dans la conception d'un parc à thème, la carrière de pilote de course ou de mannequin professionnel, ou simplement la construction de la maison de leurs rêves pour y accueillir leurs amis.{lineBreak}{lineBreak}Cet e-mail vise à vous informer que votre enfant nous a communiqué un nom d'utilisateur, sa date de naissance ainsi qu'une adresse e-mail parentale. Celle-ci est utilisée uniquement pour la gestion du compte, la réinitialisation du mot de passe dans l'éventualité où votre enfant le perd, et pour vous informer des changements apportés à l'accès au compte de votre enfant. Pour vérifier votre adresse e-mail, cliquez sur le bouton ci-dessous\u00a0: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Vérifier l'adresse e-mail{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}À propos de Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox vise à créer et préserver un environnement agréable pour toute la famille. Nous améliorons constamment notre système de sécurité et collaborons avec des experts en matière de sécurité en ligne afin de nous assurer que tous puissent jouer, discuter et coopérer en toute sécurité dans un contexte rassurant. Consultez notre guide parental pour vous familiariser avec notre plateforme et apprendre comment créer une expérience de jeu positive pour vos enfants sur Roblox\u00a0: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox propose également une fonctionnalité de {boldTagStart}contrôle parental{boldTagEnd}, qui vous permet d'activer un code PIN parental et de modifier les paramètres de communication et de chat de votre enfant. Vous trouverez ces options de contrôle dans les onglets Sécurité et Confidentialité des paramètres du compte de votre enfant.{lineBreak}{lineBreak}Consultez cette page pour ajouter un code PIN parental\u00a0: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Consultez cette page pour modifier les paramètres de chat\u00a0: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Confidentialité{boldTagEnd}{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}{lineBreak}Veuillez ne pas répondre directement à cet e-mail.{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "Bonjour,{lineBreak}{lineBreak}Votre enfant a créé le compte {boldTagStart}{username}{boldTagEnd} sur Roblox, une plateforme de divertissement en ligne qui permet aux joueurs d'imaginer, de créer et de s'amuser ensemble dans des mondes en 3D générés par la communauté. Notre plateforme comprend également Roblox Studio, un outil de développement gratuit permettant aux utilisateurs de créer tout ce dont ils ont envie, que ce soit de simples jeux de construction ou des jeux multijoueurs plus complexes. Des millions d'enfants ont utilisé Roblox pour se lancer dans la conception d'un parc à thème, la carrière de pilote de course ou de mannequin professionnel, ou simplement la construction de la maison de leurs rêves pour y accueillir leurs amis.{lineBreak}{lineBreak}Cet e-mail vise à vous informer que votre enfant nous a communiqué un nom d'utilisateur, sa date de naissance ainsi qu'une adresse e-mail parentale. Celle-ci est utilisée uniquement pour la gestion du compte, la réinitialisation du mot de passe dans l'éventualité où votre enfant le perd, et pour vous informer des changements apportés à l'accès au compte de votre enfant. Pour vérifier votre adresse e-mail, cliquez sur le bouton ci-dessous\u00a0: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Vérifier l'adresse e-mail{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}À propos de Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox vise à créer et préserver un environnement agréable pour toute la famille. Nous améliorons constamment notre système de sécurité et collaborons avec des experts en matière de sécurité en ligne afin de nous assurer que tous puissent jouer, discuter et coopérer en toute sécurité dans un contexte rassurant. Consultez notre guide parental pour vous familiariser avec notre plateforme et apprendre comment créer une expérience de jeu positive pour vos enfants sur Roblox\u00a0: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox propose également une fonctionnalité de {boldTagStart}contrôle parental{boldTagEnd}, qui vous permet d'activer un code PIN parental et de modifier les paramètres de communication et de chat de votre enfant. Vous trouverez ces options de contrôle dans les onglets Sécurité et Confidentialité des paramètres du compte de votre enfant.{lineBreak}{lineBreak}Consultez cette page pour ajouter un code PIN parental\u00a0: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Consultez cette page pour modifier les paramètres de chat\u00a0: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Confidentialité{boldTagEnd}{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}{lineBreak}Veuillez ne pas répondre directement à cet e-mail.{lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Vous trouverez ces options de contrôle dans les onglets Sécurité et Confidentialité des paramètres du compte de votre enfant.{lineBreak}{lineBreak}Pour ajouter un code PIN parental, veuillez consulter cette page\u00a0: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Pour changer les paramètres de chat, veuillez consulter cette page\u00a0: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Confidentialité{boldTagEnd}{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}{lineBreak} Veuillez ne pas répondre directement à cet e-mail. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "Vous trouverez ces options de contrôle dans les onglets Sécurité et Confidentialité des paramètres du compte de votre enfant.{lineBreak}{lineBreak}Pour ajouter un code PIN parental, veuillez consulter cette page\u00a0: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Pour changer les paramètres de chat, veuillez consulter cette page\u00a0: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Confidentialité{boldTagEnd}{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}{lineBreak} Veuillez ne pas répondre directement à cet e-mail. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"Bonjour,{lineBreak}{lineBreak}Nous sommes ravis que tu aies choisi de sécuriser ton compte {username} en indiquant une adresse e-mail.{lineBreak}En vérifiant l'adresse associée à ton compte Roblox, tu augmentes son niveau de sécurité.{lineBreak}Clique sur le lien ci-dessous afin de finaliser le processus de vérification{lineBreak}{verificationLink}.\n";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "Bonjour,{lineBreak}{lineBreak}Nous sommes ravis que tu aies choisi de sécuriser ton compte {username} en indiquant une adresse e-mail.{lineBreak}En vérifiant l'adresse associée à ton compte Roblox, tu augmentes son niveau de sécurité.{lineBreak}Clique sur le lien ci-dessous afin de finaliser le processus de vérification{lineBreak}{verificationLink}.\n";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Bonjour,{lineBreak}{lineBreak}Votre enfant a créé le compte {username} sur Roblox, une plateforme de divertissement en ligne qui permet aux joueurs d'imaginer, de créer et de s'amuser ensemble dans des mondes en 3D générés par la communauté. Notre plateforme comprend également Roblox Studio, un outil de développement gratuit permettant aux utilisateurs de créer tout ce dont ils ont envie, que ce soit de simples jeux de construction ou des jeux multijoueurs plus complexes. Des millions d'enfants ont utilisé Roblox pour se lancer dans la conception d'un parc à thème, la carrière de pilote de course ou de mannequin professionnel, ou simplement la construction de la maison de leurs rêves pour y accueillir leurs amis.{lineBreak}{lineBreak}Cet e-mail vise à vous informer que votre enfant nous a communiqué un nom d'utilisateur, sa date de naissance ainsi qu'une adresse e-mail parentale. Celle-ci est utilisée uniquement pour la gestion du compte, la réinitialisation du mot de passe dans l'éventualité où votre enfant le perd, et pour vous informer des changements apportés à l'accès au compte de votre enfant. Pour vérifier votre adresse e-mail, cliquez sur le bouton ci-dessous\u00a0:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}À propos de Roblox{lineBreak}{lineBreak}Roblox vise à créer et préserver un environnement agréable pour toute la famille. Nous améliorons constamment notre système de sécurité et collaborons avec des experts en matière de sécurité en ligne afin de nous assurer que tous puissent jouer, discuter et coopérer en toute sécurité dans un contexte rassurant. Consultez notre guide parental pour vous familiariser avec notre plateforme et apprendre comment créer une expérience de jeu positive pour vos enfants sur Roblox\u00a0: {parentalPageLink}{lineBreak}{lineBreak}Roblox propose également une fonctionnalité de contrôle parental, qui vous permet d'activer un code PIN parental et de modifier les paramètres de communication et de chat de votre enfant. Vous trouverez ces options de contrôle dans les onglets Sécurité et Confidentialité des paramètres du compte de votre enfant.{lineBreak}{lineBreak}Consultez cette page pour ajouter un code PIN parental\u00a0: {accountSecurityLink}{lineBreak}{lineBreak}.Consultez cette page pour modifier les paramètres de chat\u00a0: {chatPrivacyLink} {lineBreak}{lineBreak}Confidentialité{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {supportPageLink}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {privacyPageLink}.{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}Veuillez ne pas répondre directement à cet e-mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "Bonjour,{lineBreak}{lineBreak}Votre enfant a créé le compte {username} sur Roblox, une plateforme de divertissement en ligne qui permet aux joueurs d'imaginer, de créer et de s'amuser ensemble dans des mondes en 3D générés par la communauté. Notre plateforme comprend également Roblox Studio, un outil de développement gratuit permettant aux utilisateurs de créer tout ce dont ils ont envie, que ce soit de simples jeux de construction ou des jeux multijoueurs plus complexes. Des millions d'enfants ont utilisé Roblox pour se lancer dans la conception d'un parc à thème, la carrière de pilote de course ou de mannequin professionnel, ou simplement la construction de la maison de leurs rêves pour y accueillir leurs amis.{lineBreak}{lineBreak}Cet e-mail vise à vous informer que votre enfant nous a communiqué un nom d'utilisateur, sa date de naissance ainsi qu'une adresse e-mail parentale. Celle-ci est utilisée uniquement pour la gestion du compte, la réinitialisation du mot de passe dans l'éventualité où votre enfant le perd, et pour vous informer des changements apportés à l'accès au compte de votre enfant. Pour vérifier votre adresse e-mail, cliquez sur le bouton ci-dessous\u00a0:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}À propos de Roblox{lineBreak}{lineBreak}Roblox vise à créer et préserver un environnement agréable pour toute la famille. Nous améliorons constamment notre système de sécurité et collaborons avec des experts en matière de sécurité en ligne afin de nous assurer que tous puissent jouer, discuter et coopérer en toute sécurité dans un contexte rassurant. Consultez notre guide parental pour vous familiariser avec notre plateforme et apprendre comment créer une expérience de jeu positive pour vos enfants sur Roblox\u00a0: {parentalPageLink}{lineBreak}{lineBreak}Roblox propose également une fonctionnalité de contrôle parental, qui vous permet d'activer un code PIN parental et de modifier les paramètres de communication et de chat de votre enfant. Vous trouverez ces options de contrôle dans les onglets Sécurité et Confidentialité des paramètres du compte de votre enfant.{lineBreak}{lineBreak}Consultez cette page pour ajouter un code PIN parental\u00a0: {accountSecurityLink}{lineBreak}{lineBreak}.Consultez cette page pour modifier les paramètres de chat\u00a0: {chatPrivacyLink} {lineBreak}{lineBreak}Confidentialité{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {supportPageLink}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {privacyPageLink}.{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}Veuillez ne pas répondre directement à cet e-mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Pour changer les paramètres de chat, veuillez consulter cette page\u00a0: {chatPrivacyLink} {lineBreak}{lineBreak}Confidentialité{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {supportPageLink}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {privacyPageLink}.{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}Veuillez ne pas répondre directement à cet e-mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "Pour changer les paramètres de chat, veuillez consulter cette page\u00a0: {chatPrivacyLink} {lineBreak}{lineBreak}Confidentialité{lineBreak}{lineBreak}Vous pouvez supprimer le compte de votre enfant en contactant l'assistance clientèle depuis cette page\u00a0: {supportPageLink}. Votre adresse e-mail ne sera utilisée à aucune autre fin, ni communiquée à un tiers, ni associée aux données personnelles obtenues auprès de votre enfant. Pour en savoir plus, consultez notre politique de confidentialité à l'adresse\u00a0: {privacyPageLink}.{lineBreak}{lineBreak}Merci,{lineBreak}{lineBreak}L'équipe Roblox{lineBreak}Veuillez ne pas répondre directement à cet e-mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Vérification d'adresse e-mail Roblox";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Autorisation du compte Roblox";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "Décrivez-vous en quelques mots (1\u00a0000\u00a0caractères max.)";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "p.\u00a0ex. www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "p.\u00a0ex. http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "p.\u00a0ex. www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "p.\u00a0ex. @Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "p.\u00a0ex. www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "Que sont les contrôles du compte\u00a0?";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "Infos sur le compte";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "Facturation";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "Utilisateurs bloqués";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "Paramètres de contact";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "Notifications bureau";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "Ajouter mot de passe";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "Ajouter un nº de téléphone";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "Changer mon adresse e-mail";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "Adresse e-mail changée";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "Changer de mot de passe";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "Succès";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "Succès";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "Changer de nom d'utilisateur";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "Erreur";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "Succès";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "Changer de nº de téléphone";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "Fonds insuffisants";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Nom d'utilisateur invalide";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "Ajouter code PIN";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "Succès";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "Code PIN du compte requis";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "Supprimer le nº de téléphone";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "Adresse e-mail vérifiée requise";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "Vérifier l'adresse e-mail";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "Vérifier le nº de téléphone";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "Fast Track";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "Statut de l'abonnement";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "M'avertir quand";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "Notifications";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "M'avertir quand";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "Notifications bureau";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "Notifications mobile";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "Flux de notifications";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "Flux de notifications";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "Autres paramètres";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Mes paramètres";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "Personnel";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "Code PIN du compte";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "Paramètres de confidentialité";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "Date de renouvellement";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "Limitations du compte";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "Déconnexion sécurisée";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "Réseaux sociaux";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "Connexion via réseau social";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "Succès";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "Infos sur le compte";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "Facturation";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "Fast Track";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "Notifications";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "Confidentialité";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "Sécurité";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "Transactions";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "Vérification en 2\u00a0étapes";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "Le code PIN du compte est désactivé.";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "Le code PIN du compte est activé.";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "Les limitations du compte sont désactivées";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "Les limitations du compte sont activées";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "Ajouter une adresse e-mail";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "Ajouter une adresse e-mail parentale";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "Ajouter mot de passe\u00a0:";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "Ajouter un nº de téléphone";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "Ajouter un nº de téléphone";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "Pour toute question sur les paiements et la facturation\u00a0:";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"Pour toute question sur les paiements et la facturation, veuillez consulter les {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}pages d'aide sur la facturation{aTagEnd}.";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "Pour toute question sur les paiements et la facturation, veuillez consulter les {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}pages d'aide sur la facturation{aTagEnd}.";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"Se terminant par {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "Se terminant par {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "Coût";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "Date";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "Description";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "Le service est actuellement désactivé. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "Aucune transaction";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "Type de paiement";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "Date de naissance";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"Vous n'êtes pas encore membre. Rejoignez le {startSpan}Builders Club{endSpan} dès aujourd'hui\u00a0!";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "Vous n'êtes pas encore membre. Rejoignez le {startSpan}Builders Club{endSpan} dès aujourd'hui\u00a0!";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "Changer de nom d'utilisateur";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "Choix de la langue";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "Désactiver";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "Connecter le compte\u00a0:";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "Choisis ton pays/région";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "Lieu";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "Sombre";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "Ajouter mon adresse e-mail";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "Ajouter une adresse e-mail parentale";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "Numéro de téléphone";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "Vérifier le mot de passe du compte";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "Changer mon adresse e-mail";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "Changer mon adresse e-mail";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "Changer d'adresse e-mail parentale";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "Confirmer le mot de passe";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "Mot de passe actuel";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "Nouveau mot de passe";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "Mot de passe du compte";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "Nom d'utilisateur souhaité (3 à 20\u00a0caractères)";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "Confirmer ton code PIN";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"Créez un code PIN à {digitCount}\u00a0chiffres";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "Créez un code PIN à {digitCount}\u00a0chiffres";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "Nº de téléphone actuel\u00a0:";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "Adresse e-mail changée";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "Adresse e-mail requise";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "Adresse e-mail vérifiée\u00a0:";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "Vérifier le mot de passe du compte";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"Saisir le code ({digitCount}\u00a0chiffres)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "Saisir le code ({digitCount}\u00a0chiffres)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "Saisis le code que nous venons d'envoyer sur ton téléphone.";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "Vérifier le SMS";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "Personnalisé";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "Par défaut";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "Tout le monde";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "Amis, utilisateurs que je suis et abonnés";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "Amis et utilisateurs que je suis";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "Amis";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "Élevé";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "Bas";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "Moyen";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "Aucun";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "Personne";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "Désactivé";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "Adresse e-mail\u00a0:";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "Adresse e-mail parentale\u00a0:";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "En attente de vérification";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "Date d'expiration";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Expiration le {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "Expiration le {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook\u00a0:";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "Pertinence";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "Tout le monde";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "Mois";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "Année";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "Statistiques";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "Vous";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "Sexe";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+\u00a0:";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "Clair";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "Langue";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"Abonnement au {startSpan}Builders Club{endSpan}";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "Abonnement au {startSpan}Builders Club{endSpan}";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "Tu n'es pas encore membre. Rejoins Roblox Premium maintenant !";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "Je suis invité(e) à rejoindre un serveur\u00a0VIP";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "Quelqu'un me parle";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "Quelqu'un épingle un nouveau jeu auquel jouer ensemble";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "Le rapport d'analyse est disponible";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "Quelqu'un accepte ma demande d'amitié";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "Je reçois une demande d'amitié";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "Je reçois des notifications à propos des mises à jour";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "Quelqu'un m'invite à rejoindre un groupe";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "Quelqu'un rejoint un groupe auquel j'appartiens";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "Je reçois un message privé";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "Quelqu'un m'invite à modifier un jeu";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "Mot de passe\u00a0:";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "Numéro de téléphone\u00a0:";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "min";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "Temps restant";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "s";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "Noms d'utilisateur précédents\u00a0:";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "Mode privé";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "Date de renouvellement";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Renouvellement automatique le {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "Renouvellement automatique le {startSpan}{expirationDate}{endSpan}.";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount}\u00a0Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount}\u00a0Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "Fermer toutes les autres sessions";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "Visible par\u00a0:";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"Connecté en tant que {socialUsername}";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "Connecté en tant que {socialUsername}";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "Thème";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "Personnalisé\u00a0: définissez les paramètres comme vous le souhaitez. Par défaut\u00a0: active le chat et les messages entre amis. Désactivé\u00a0: désactive le chat et les messages.";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "Tous les paramètres sont verrouillés. Pour les modifier, entre ton code PIN.";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "Cliquer pour verrouiller ta page de paramètres";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "Cliquez ici pour en savoir plus";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "Cette option définit avec qui l'utilisateur peut discuter dans l'application et sur le site Web (distinct des discussions en jeu). Elle empêche également l'utilisateur d'écrire des messages sur les forums et le mur des groupes.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "Cette option définit avec qui l'utilisateur peut discuter en jeu.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "Cette option vous permet de contrôler qui peut vous trouver à l'aide du numéro de téléphone fourni.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "Cette option définit qui peut rejoindre l'utilisateur sur les serveurs\u00a0VIP, qui sont des serveurs qu'il n'est possible de rejoindre que sur invitation de leur propriétaire.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "Cette option définit qui peut voir dans quel jeu l'utilisateur se trouve et le rejoindre sur son serveur. Si «\u00a0Personne\u00a0» est sélectionné, aucun joueur ne pourra suivre l'utilisateur sur son serveur, mais il pourra tout de même jouer avec d'autres utilisateurs.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "Cette option définit qui peut envoyer des messages dans la boîte de réception de l'utilisateur.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "Ce paramètre détermine qui peut voir ton inventaire.";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "Filtre de qualité des échanges";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter\u00a0:";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "Activer la vérification en 2\u00a0étapes";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "Vous devez fournir une adresse e-mail vérifiée.";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "Renforce la sécurité de ton compte. Tu dois saisir un code pour te connecter sur un nouvel appareil.";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "Ton compte est protégé\u00a0!";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "Mettre à jour l'adresse e-mail";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "Mettre à jour le nº de téléphone";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "Utiliser la langue de l'appareil";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Nom d'utilisateur\u00a0:";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "Vérifié";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "Vérifier";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "Qui peut me parler dans l'application\u00a0?";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "Qui peut faire discuter avec moi\u00a0?";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "Qui peut me trouver à l'aide de mon numéro de téléphone\u00a0?";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "Qui peut m'inviter à rejoindre un serveur\u00a0VIP\u00a0?";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "Qui peut me rejoindre ?";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "Qui peut m'envoyer des messages\u00a0?";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "Qui peut voir mon inventaire\u00a0?";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "Qui peut faire des échanges avec moi\u00a0?";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "Connecté(e) avec un compte Xbox";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube\u00a0:";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Pas assez de Robux";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "Le compte a déjà un code PIN. Essayez de faire une demande différente.";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "Le compte est verrouillé. Déverrouiller le compte avant d’effectuer l’action.";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "Un problème est survenu. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "L'adresse e-mail a déjà été vérifiée.";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "Cette fonctionnalité est actuellement désactivée. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "Mot de passe est incorrect.";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "Adresse e-mail invalide.";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "Aucune addresse mail associé au compte.";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "Le code PIN est verrouillé.";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "Cette adresse e-mail est déjà celle du compte.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "Trop de comptes sont associés à cette adresse e-mail.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "Trop de tentatives de mettre à jour l'addresse mail. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "Trop de tentatives d'envoyer le courriel de vérification. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "Une erreur inconnue s'est produite.";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "Code PIN incorrect.";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "Format non valide de PIN.";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "Aucun code PIN n’existe sur le compte.";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "Le compte ne dispose pas d'une addresse mail vérifiée.";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "Erreur système.";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "Trop de tentatives. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "Adresse e-mail ajoutée";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "Ton adresse e-mail a déjà été vérifiée\u00a0!";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "Cette fonctionnalité est actuellement désactivée. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "Vous n'avez pas assez de Robux pour changer de nom d'utilisateur.";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "Adresse e-mail invalide";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "Tu dois associer une adresse e-mail à ton compte";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "Vous n'avez pas assez de Robux pour changer de nom d'utilisateur.";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "Le code PIN est verrouillé.";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "Cette adresse e-mail est déjà celle qui est vérifiée.";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "Vos paramètres ont été mis à jour.";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "Trop de comptes sont associés à cette adresse e-mail.";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "Trop de tentatives. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "Une erreur inconnue s'est produite.";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "Ton mot de passe est incorrect.";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "Code non valide. Il faut vérifier ton téléphone, puis réessayer.";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "La valeur de \"Qui peut échanger avec moi\" doit être au moins la même ou plus restrictive que celle de \"Qui peut voire mon inventaire\".";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "Un code est nécessaire. Il faut saisir ton code.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "S'il apparaît que tu as moins de 13\u00a0ans après modification de ta date de naissance, tu ne pourras pas revenir en arrière. Veux-tu vraiment continuer\u00a0?";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "Tu dois ajouter un mot de passe à ton compte Roblox pour modifier ta date de naissance.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "Ajout de mot de passe nécessaire";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "S'il apparaît que tu as moins de 13\u00a0ans après modification de ta date de naissance, vous ne pourras pas revenir en arrière. La connexion via Facebook sera désactivée et tu devras te connecter en utilisant ton mot de passe Roblox.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "Ton mot de passe actuel est incorrect, le mot de passe n'a pas été modifié.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "Les mots de passe ne correspondent pas.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "Le nom doit compter au moins 8\u00a0caractères.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "Veuillez saisir un nom d'utilisateur.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "Nom d'utilisateur inapproprié pour Roblox.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "Ce nom d'utilisateur est déjà pris.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "Nom d'utilisateur changé.";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "Erreur lors du chargement de la liste des pays";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "Une erreur s'est produite avec le service de monnaie. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "Un problème est survenu. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "Une erreur est survenue";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "Sauvegarde réussie\u00a0!";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "Une erreur s'est produite lors de la tentative de déconnexion de ton compte Xbox. Réessaye plus tard.";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "Un e-mail vous a été envoyé à des fins de vérification.";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "Adresse e-mail invalide";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "Numéro de téléphone invalide";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Appuyez sur Envoyer pour soumettre le ticket ou sur Annuler pour modifier le nom d'utilisateur. Ce dernier est très important et peut vous aider à obtenir une réponse plus rapidement.";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "Le mot de passe doit contenir au moins 2\u00a0chiffres, 4\u00a0lettres et 1\u00a0symbole et compter au moins 8\u00a0caractères.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "Ton code PIN a été défini. Tu devras saisir ce code pour accéder à ta page de paramètres à l'avenir.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "Les codes PIN ne correspondent pas.";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "Une erreur s'est produite lors de la tentative de déconnexion des autres sessions. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "Vous avez été déconnecté de toutes les autres sessions.";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "Si tu désactives la vérification en 2\u00a0étapes, seul ton mot de passe sera nécessaire pour te connecter sur un nouvel appareil. Continuer\u00a0?";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "Vérification en 2\u00a0étapes activée";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "Ton compte est maintenant protégé\u00a0! Tu n'as rien d'autre à faire pour le moment. Un code de sécurité te sera envoyé lors de ta connexion sur un nouvel appareil.";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "Nous avons mis à jour le paramètre de confidentialité de ton inventaire. Les paramètres de l’inventaire et d'échange doivent être similaires.";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "Une erreur s'est produite lors de la mise à jour de vos paramètres de notification. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "Nous avons mis à jour le paramètre de confidentialité des échanges. Les paramètres de l’inventaire et d'échange doivent être similaires.";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "Code non valide. Vérifie ton téléphone, puis réessaye.";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "Avertissement";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "Cette fonctionnalité est actuellement désactivée. Veuillez réessayer plus tard.";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "Une erreur est survenue. Veuillez réessayer.";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "Vous avez saisi un code incorrect à de trop nombreuses reprises.";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "Mot de passe incorrect. Veuillez vérifier le mot de passe, puis réessayez.";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "Le format du numéro de téléphone n'est pas valide. Veuillez le vérifier, puis réessayez.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "Le numéro de téléphone a été supprimé.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "Le numéro de téléphone a été mis à jour\u00a0!";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "Le numéro est déjà associé à un autre compte.";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "Tu dois saisir ton code PIN pour modifier tes paramètres.";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "Le lien vers le réseau social n'est pas valide.";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "Nos excuses, mais tu ne peux pas faire passer ton âge à moins de 13\u00a0ans. Si tu as moins de 13\u00a0ans, créé un nouveau compte et contacte l'assistance pour supprimer ton compte précédent.";
	}
}
