namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_es_es : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "Cargar más";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "Cancelar renovación";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "Añadir correo electrónico";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "Añadir teléfono";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "Cambiar correo electrónico";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "Aceptar";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "Actualizar";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "Aceptar";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "Comprar";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "Cerrar";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "Editar teléfono";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "Eliminar número de teléfono";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "Comprar";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "No";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "Añadir";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "Aceptar";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "Desbloquear";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "Eliminar";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Enviar";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "Aceptar";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "Actualizar";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "Aceptar";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "Verificar correo electrónico";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "Reintentar";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "Verificar";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "Reenviar código";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "Cancelar";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "Sí";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "Ocultar";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "Unirse";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "Unirse al Builders Club";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Guardar";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "Mostrar";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "Cerrar sesión";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "Desconectar";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "Aceptar";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "Desbloquear";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "Mejorar suscripción";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "Puedes configurar restricciones en esta cuenta para restringir el acceso a sus ajustes y a contenidos no revisados.";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "Restablecimiento de correo electrónico de Roblox";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Ver notificaciones en este ordenador incluso cuando Roblox esté cerrado.";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "Para ver notificaciones, puede que se te solicite que actives las notificaciones push en tu navegador.";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "Notificaciones de escritorio para este dispositivo.";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "Confirma el código de tu país e introduce tu número de teléfono. Te enviaremos un SMS para completar la verificación. (Nota: pueden aplicarse cargos por el servicio de mensajería.)";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "Se ha enviado un correo electrónico de verificación.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "El correo electrónico de la cuenta no se modificará hasta que se haya verificado el nuevo correo electrónico.";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "Has modificado tu contraseña.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "Importante: la fecha de creación de la cuenta original se mantendrá con tu nuevo nombre de usuario.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "Cambio de nombre de usuario gratuito por una vez.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "Las publicaciones del foro anteriores aparecerán con tu nombre de usuario antiguo y NO se mantendrán con tu nuevo nombre de usuario.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "Cambio de nombre de usuario";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "El número de teléfono no se modificará hasta que se haya verificado el nuevo número.";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "Debes proporcionar un correo electrónico y verificarlo para poder cambiar tu nombre de usuario.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "¡Gracias! Se ha enviado tu correo electrónico de verificación.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "Debes verificar tu correo electrónico para poder cambiar tu nombre de usuario.";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "Añade una contraseña para proteger tu cuenta antes de desconectarte de Facebook.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "Debes proporcionar tu correo electrónico y verificarlo para poder añadir un PIN de la cuenta.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "Debes proporcionar tu correo electrónico y verificarlo para poder activar la verificación en dos pasos.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "Debes proporcionar tu correo electrónico y verificarlo para poder cambiar el nombre de usuario.";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "Introduce el PIN de cuenta asociado a tu cuenta";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "Debes verificar tu correo electrónico para poder añadir un PIN de la cuenta.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "Debes verificar tu correo electrónico para poder activar la verificación en dos pasos.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "Debes verificar tu correo electrónico para poder cambiar tu nombre de usuario.";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "Se te ha inscrito en el programa de informes Fast Track porque has enviado buenos informes de abuso. Los tuyos tendrán prioridad sobre otros y serán revisados rápidamente. Permanecerás en el programa siempre y cuando sigas enviando informes de buenas calidad. Gracias por ayudarnos a crear experiencias positivas en Roblox.";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "Estadísticas";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "No des ningún detalle que pueda usarse para identificarte fuera de Roblox.";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "La precisión depende de cuántas veces nuestro equipo de moderación comprueba la exactitud del contenido de los informes de abuso. Se mostrará tu número después de que hayas enviado varios. Con \"todos\" nos referimos a todos los miembros de Fast Track como grupo.";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "Actualizar la edad con una menor de 13 años activará el modo privado.";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "Cambio de contraseña";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "Cambio de nombre de usuario";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "Actualizar correo electrónico";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "Para preguntas de facturación y pagos: info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "Todavía no eres miembro. ¡Únete ya al Builders Club!";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "Todavía no eres miembro. ¡Únete a Roblox Premium ahora!";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "Ver notificaciones en las pantallas de inicio de tus dispositivos. Puedes activarlas y desactivarlas desde la aplicación de Roblox.";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "Notificaciones push de móvil para este dispositivo.";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "Ver notificaciones en mi transmisión. Haz clic en el icono de las notificaciones en la barra superior para ver esas notificaciones.";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "Si desactivas un tipo de notificación, ya no te enviaremos más notificaciones nuevas de ese tipo.";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "Nota: si deseas cancelar la renovación de tu suscripción, inicia sesión en la página web.";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "¡Guardado!";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "Es necesaria una dirección de correo electrónico verificada.";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Cambio de nombre de usuario de Roblox";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Verificación del correo electrónico de Roblox";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Autorización de la cuenta de Roblox";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "Descríbete (1000 caracteres máx.)";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "ej.: www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "ej.: http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "ej.: www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "ej.: @Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "ej.: www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "¿Qué son los controles de cuenta?";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "Información de la cuenta";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "Facturación";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "Usuarios bloqueados";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "Configuración de contactos";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "Notificaciones push de escritorio";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "Añadir contraseña";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "Añadir teléfono";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "Cambio de correo electrónico";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "Dirección de correo electrónico modificada";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "Cambio de contraseña";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "Hecho";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "Hecho";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "Cambio de nombre de usuario";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "Error";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "Hecho";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "Editar teléfono";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "Fondos insuficientes";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Nombre de usuario no válido.";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "Añadir PIN";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "Hecho";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "PIN de cuenta obligatorio";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "Eliminar teléfono";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "Correo verificado obligatorio";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "Verificar correo electrónico";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "Verificar teléfono";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "Fast Track";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "Estado de la suscripción";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "Notificarme cuando";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "Notificaciones";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "Notificarme cuando";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "Notificaciones push de escritorio";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "Notificaciones push de móvil";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "Flujo de notificaciones";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "Flujo de notificaciones";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "Otras configuraciones";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "Mi configuración";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "Personal";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "PIN de la cuenta";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "Configuración de privacidad";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "Fecha de renovación";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "Restricciones de la cuenta";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "Cierre de sesión seguro";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "Redes sociales";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "Inicio de sesión social";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "Hecho";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "Información de la cuenta";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "Facturación";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "Fast Track";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "Notificaciones";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "Privacidad";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "Seguridad";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "Transacciones";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "Verificación en dos pasos";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "El PIN de la cuenta está desactivado.";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "El PIN de la cuenta está activado.";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "Las restricciones de la cuenta están desactivadas.";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "Las restricciones de la cuenta están activadas.";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "Añadir correo electrónico";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "Añadir correo electrónico";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "Añadir contraseña:";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "Añadir teléfono";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "Añadir teléfono";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "Para preguntas de facturación y pagos:";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "Coste";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "Fecha";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "Descripción";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "El servicio está desactivado en este momento. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "Sin transacciones";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "Tipo de pago";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "Fecha de nacimiento";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "cambia tu nombre de usuario";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "Elegir idioma";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "Desactivado";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "Conectar cuenta:";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "Elige un país o una región";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "Ubicación";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "Oscuro";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "Añadir mi correo electrónico";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "Añadir correo electrónico de un progenitor";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "Número de teléfono";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "Verificar contraseña de la cuenta";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "Cambiar mi correo electrónico";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "Cambiar mi correo electrónico";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "Cambiar correo electrónico del progenitor";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "Confirmar contraseña";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "Contraseña actual";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "Contraseña nueva";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "Contraseña de la cuenta";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "Nombre de usuario deseado (3-20 caracteres)";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "Confirma tu PIN";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "Número actual:";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "Dirección de correo electrónico modificada";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "Correo electrónico obligatorio";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "Correo electrónico verificado:";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "Verificar contraseña de la cuenta";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "Introduce el código que te acabamos de enviar al teléfono.";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "SMS de verificación";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "Personalizado";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "Predeterminado";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "Todos";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "Amigos, usuarios a los que sigo y seguidores";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "Amigos, usuarios a los que sigo";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "Amigos";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "Alto";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "Bajo";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "Medio";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "Ninguno";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "Nadie";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "Desactivado";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "Dirección de correo electrónico:";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "Correo electrónico de un progenitor:";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "Verificación pendiente";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "Caducidad";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook:";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "Precisión";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "Todos";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "Mes";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "Año";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "Estadísticas";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "Tú";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "Sexo";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+:";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "Claro";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "Idioma";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "Todavía no eres miembro. ¡Únete a Roblox Premium ahora!";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "Me invitan a un servidor VIP";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "Alguien chatea conmigo";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "Alguien ancla un nuevo juego para jugar juntos";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "Cuando el informe analítico esté disponible";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "Alguien acepta mi solicitud de amistad";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "Recibo una solicitud de amistad";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "Recibo notificaciones de actualización";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "Alguien me invita a un grupo";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "Alguien se une a un grupo en el que estoy";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "Recibo un mensaje privado";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "Alguien me invita a editar un juego.";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "Contraseña:";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "Número de teléfono:";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "min.";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "Tiempo restante";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "seg.";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "Nombres de usuario anteriores:";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "Modo privado";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "Fecha de renovación";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "Cerrar todas las demás sesiones";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "Visible para:";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "Tema";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "Personalizado: controla tu propia configuración. Predeterminado: activa chat y mensajes con amigos. Desactivado: desactiva chat y mensajes.";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "La configuración está bloqueada. Para editarla, desbloquéala con tu PIN.";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "Haz clic para bloquear tu página de Configuración";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "Haz clic aquí para obtener más información.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "Este ajuste controla con quién se le permitirá al usuario chatear en la aplicación y en la web (no dentro del juego). También impide que el usuario publique en foros y en muros de grupos.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "Este ajuste controla con quién se le permitirá al usuario chatear dentro del juego.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "Este ajuste controla quién puede encontrarte mediante el número de teléfono que has proporcionado.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "Este ajuste controla quién puede unirse a este usuario en servidores VIP (a los que solo se puede acceder mediante invitación de su propietario).";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "Este ajuste controla quién puede ver en qué juego estoy y unirse a mí en mi servidor. Seleccionar «Nadie» significa que nadie puede seguirme a mi servidor específico, pero jugaré con otros usuarios.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "Este ajuste controla de quién puede recibir mensajes este usuario en su buzón.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "Esta configuración controla quién puede ver tu inventario.";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "Filtro de calidad de intercambio";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter:";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "Activar verificación en dos pasos";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "Es necesaria una dirección de correo electrónico verificada.";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "Mejora la seguridad de tu cuenta. Se te pedirá un código cuando inicies sesión desde un dispositivo nuevo.";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "¡Tu cuenta está protegida!";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "Actualizar correo electrónico";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "Actualizar teléfono";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "Usar el idioma del dispositivo";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "Nombre de usuario:";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "Verificado";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "Verificar";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "¿Quién puede hablar conmigo en la aplicación?";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "¿Quién puede chatear conmigo?";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "¿Quién puede encontrarme por mi número de teléfono?";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "¿Quién puede invitarme a servidores VIP?";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "¿Quién puede unirse a mí?";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "¿Quién puede enviarme mensajes?";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "¿Quién puede ver mi inventario?";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "¿Quién puede hacer intercambios conmigo?";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "Conectado con una cuenta de Xbox";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube:";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Robux insuficientes";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "La cuenta ya tiene un PIN. Intenta con otra solicitud.";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "La cuenta está bloqueada. Desbloquéala antes de realizar esta acción.";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "Algo ha ido mal. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "El correo electrónico ya se ha verificado.";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "La función está desactivada en este momento. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "La contraseña es incorrecta.";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "Dirección de correo electrónico no válida.";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "No hay direcciones de correo electrónico asociadas a esta cuenta.";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "El PIN está bloqueado.";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "Este correo electrónico ya es el actual.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "Hay demasiadas cuentas asociadas a esta dirección de correo electrónico.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "Demasiados intentos para actualizar el correo electrónico. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "Demasiados intentos para enviar un correo electrónico de verificación. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "Se ha producido un error desconocido.";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "PIN incorrecto.";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "Formato del PIN no válido.";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "No existe un PIN para esta cuenta.";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "La cuenta no tiene un correo electrónico verificado.";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "Error del sistema.";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "Demasiadas solicitudes. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "Correo electrónico añadido";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "Tu correo electrónico ya se ha verificado.";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "La función está desactivada en este momento. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "No tienes suficientes Robux para cambiar el nombre de usuario.";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "Correo electrónico no válido";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "Debes asociar una dirección de correo electrónico con la cuenta.";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "No tienes suficientes Robux para cambiar el nombre de usuario.";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "El PIN está bloqueado.";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "Este correo electrónico ya se ha verificado.";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "Se ha actualizado la configuración.";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "Hay demasiadas cuentas asociadas a este correo electrónico.";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "Demasiados intentos. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "Se ha producido un error desconocido.";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "La contraseña es incorrecta.";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "El código no es válido. Comprueba tu teléfono e inténtalo de nuevo.";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "El valor de \"Quién puede intercambiar conmigo\" debe ser igual o más restrictivo que el valor de \"Quién puede ver mi inventario\".";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "Es necesario introducir un código. Introduce el tuyo.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "Si cambias tu fecha de nacimiento de manera que seas menor de 13 años, el cambio no podrá deshacerse. ¿Seguro que quieres continuar?";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "Debes añadir una contraseña a tu cuenta de Roblox para cambiar tu fecha de nacimiento.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "Debes añadir contraseña";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "Si cambias tu fecha de nacimiento de manera que seas menor de 13 años, el cambio no podrá deshacerse. Se desactivará tu inicio de sesión social con Facebook y tendrás que iniciar sesión con tu contraseña de Roblox.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "La contraseña actual es incorrecta. La contraseña no se ha modificado.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "Las contraseñas no coinciden.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "Debe tener al menos 8 caracteres.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "Introduce un nombre de usuario.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "Nombre de usuario inadecuado para Roblox.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "Ese nombre de usuario ya está en uso.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "Nombre de usuario cambiado correctamente.";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "Error al cargar lista de países";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "Se ha producido un error con el servicio de divisas. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "Algo ha ido mal. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "Se ha producido un error";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "¡Guardado!";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "Se ha producido un error al desconectarte de tu cuenta de Xbox. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "Se ha enviado un correo electrónico de verificación.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "Dirección de correo electrónico no válida";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "Número de teléfono no válido";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Pulsa Enviar para enviar un ticket o Cancelar para editar el nombre de usuario. Proporcionar el nombre de usuario puede ayudar a priorizar tu problema.";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "La contraseña debe contener al menos 2 dígitos, 4 letras, 1 símbolo y tener al menos 8 caracteres.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "Has fijado tu PIN. Tendrás que introducir este PIN para poder acceder a la página de Configuración en el futuro.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "Los PIN no coinciden";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "Se ha producido un error al desconectarte de las otras sesiones. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "Te has desconectado de todas las otras sesiones.";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "Si desactivas la verificación en dos pasos, solo hará falta tu contraseña para iniciar sesión desde un dispositivo nuevo. ¿Seguro que quieres continuar?";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "Verificación en dos pasos activada";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "Tu cuenta está protegida. No es necesario que hagas nada más. Se te enviará un código de seguridad la próxima vez que inicies sesión desde un dispositivo nuevo.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "Hemos actualizado la configuración de privacidad del inventario. La configuración del inventario y la del intercambio deben ser coherentes.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "Se ha producido un error al actualizar tu configuración de notificaciones. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "Hemos actualizado la configuración de privacidad del intercambio. La configuración del inventario y la del intercambio deben ser coherentes.";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "El código no es válido. Comprueba tu teléfono e inténtalo de nuevo.";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "Advertencia";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "La función está desactivada en este momento. Inténtalo de nuevo más tarde.";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "Se ha producido un error. Inténtalo de nuevo.";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "Has introducido un código incorrecto demasiadas veces.";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "Contraseña incorrecta. Compruébala e inténtalo de nuevo.";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "El formato del número de teléfono no es válido. Compruébalo e inténtalo de nuevo.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "Se ha eliminado el teléfono.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "Se ha actualizado el teléfono.";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "El número ya está asociado a otra cuenta.";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "Introduce tu PIN para cambiar la configuración.";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "El enlace de la red social no es válido.";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "Los sentimos, no puedes cambiar la edad de tu cuenta a menor de 13 años. Si eres menor de 13 años, crea una nueva cuenta y contáctate con soporte para eliminar la vieja.";

	public AccountSettingsResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "Cargar más";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "Cancelar renovación";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "Añadir correo electrónico";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "Añadir teléfono";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "Cambiar correo electrónico";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "Actualizar";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "Cerrar";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "Editar teléfono";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "Eliminar número de teléfono";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "Comprar";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "No";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "Añadir";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "Eliminar";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Enviar";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "Actualizar";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "Verificar correo electrónico";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "Reintentar";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "Verificar";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "Reenviar código";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "Sí";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "Ocultar";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "Unirse";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "Unirse al Builders Club";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Guardar";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "Mostrar";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "Cerrar sesión";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "Desconectar";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "Desbloquear";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "Mejorar suscripción";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "Puedes configurar restricciones en esta cuenta para restringir el acceso a sus ajustes y a contenidos no revisados.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Restablecimiento de correo electrónico de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}Restablecimiento de correo electrónico de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"Querido usuario de Roblox:{lineBreak}{lineBreak}Nos dimos cuenta de que has cambiado la dirección de correo electrónico para tu cuenta {username} de {oldEmailAddress} a {newEmailAddress}. Si no era tu intención cambiarla o alguien más la cambió por error, te pedimos que hagas clic en este enlace{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}para volver a la dirección anterior. También necesitarás ingresar una nueva contraseña, para asegurarnos que tu cuenta es segura.{lineBreak}{lineBreak}Si estás satisfecho con tu nueva dirección de correo electrónico en Roblox, no tendrás que hacer nada porque ya está configurada.{lineBreak}{lineBreak}No respondas a este mensaje. Si tienes alguna pregunta, envíanos un correo electrónico a {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "Querido usuario de Roblox:{lineBreak}{lineBreak}Nos dimos cuenta de que has cambiado la dirección de correo electrónico para tu cuenta {username} de {oldEmailAddress} a {newEmailAddress}. Si no era tu intención cambiarla o alguien más la cambió por error, te pedimos que hagas clic en este enlace{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}para volver a la dirección anterior. También necesitarás ingresar una nueva contraseña, para asegurarnos que tu cuenta es segura.{lineBreak}{lineBreak}Si estás satisfecho con tu nueva dirección de correo electrónico en Roblox, no tendrás que hacer nada porque ya está configurada.{lineBreak}{lineBreak}No respondas a este mensaje. Si tienes alguna pregunta, envíanos un correo electrónico a {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"Querido usuario de Roblox:{lineBreak}{lineBreak}Nos dimos cuenta de que has cambiado la dirección de correo electrónico para tu cuenta {username} de {oldEmailAddress} a {newEmailAddress}. Si no era tu intención cambiarla o alguien más la cambió por error, te pedimos que hagas clic en este enlace{lineBreak}{revertAccountEmailLink}{lineBreak}para volver a la dirección anterior. También necesitarás ingresar una nueva contraseña, para asegurarnos que tu cuenta es segura.{lineBreak}{lineBreak}Si estás satisfecho con tu nueva dirección de correo electrónico en Roblox, no tendrás que hacer nada porque ya está configurada.{lineBreak}No respondas a este mensaje. Si tienes alguna pregunta, envíanos un correo electrónico a {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "Querido usuario de Roblox:{lineBreak}{lineBreak}Nos dimos cuenta de que has cambiado la dirección de correo electrónico para tu cuenta {username} de {oldEmailAddress} a {newEmailAddress}. Si no era tu intención cambiarla o alguien más la cambió por error, te pedimos que hagas clic en este enlace{lineBreak}{revertAccountEmailLink}{lineBreak}para volver a la dirección anterior. También necesitarás ingresar una nueva contraseña, para asegurarnos que tu cuenta es segura.{lineBreak}{lineBreak}Si estás satisfecho con tu nueva dirección de correo electrónico en Roblox, no tendrás que hacer nada porque ya está configurada.{lineBreak}No respondas a este mensaje. Si tienes alguna pregunta, envíanos un correo electrónico a {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "Restablecimiento de correo electrónico de Roblox";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"Esta cuenta solo puede acceder al contenido revisado de la plataforma. Además, los ajustes de contactos (en la página de {linkStart}Privacidad{linkEnd}) estarán fijados en Desactivado.";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "Esta cuenta solo puede acceder al contenido revisado de la plataforma. Además, los ajustes de contactos (en la página de {linkStart}Privacidad{linkEnd}) estarán fijados en Desactivado.";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"Tienes bloqueados a {totalBlockedCount} del máximo permitido de {maxBlockedCount} usuarios:";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "Tienes bloqueados a {totalBlockedCount} del máximo permitido de {maxBlockedCount} usuarios:";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"La configuración de contactos está bloqueada porque están activadas las restricciones de la cuenta (en la página de {linkStart}Seguridad{linkEnd}).";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "La configuración de contactos está bloqueada porque están activadas las restricciones de la cuenta (en la página de {linkStart}Seguridad{linkEnd}).";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Ver notificaciones en este ordenador incluso cuando Roblox esté cerrado.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "Para ver notificaciones, puede que se te solicite que actives las notificaciones push en tu navegador.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "Notificaciones de escritorio para este dispositivo.";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "Confirma el código de tu país e introduce tu número de teléfono. Te enviaremos un SMS para completar la verificación. (Nota: pueden aplicarse cargos por el servicio de mensajería.)";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "Se ha enviado un correo electrónico de verificación.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "El correo electrónico de la cuenta no se modificará hasta que se haya verificado el nuevo correo electrónico.";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "Has modificado tu contraseña.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "Importante: la fecha de creación de la cuenta original se mantendrá con tu nuevo nombre de usuario.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "Cambio de nombre de usuario gratuito por una vez.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "Las publicaciones del foro anteriores aparecerán con tu nombre de usuario antiguo y NO se mantendrán con tu nuevo nombre de usuario.";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"¿Cambiar nombre de usuario por {robuxIcon} {price}?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "¿Cambiar nombre de usuario por {robuxIcon} {price}?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "Cambio de nombre de usuario";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "El número de teléfono no se modificará hasta que se haya verificado el nuevo número.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "Debes proporcionar un correo electrónico y verificarlo para poder cambiar tu nombre de usuario.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "¡Gracias! Se ha enviado tu correo electrónico de verificación.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "Debes verificar tu correo electrónico para poder cambiar tu nombre de usuario.";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "Añade una contraseña para proteger tu cuenta antes de desconectarte de Facebook.";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"Necesitas {robuxToBuy} más para cambiar tu nombre de usuario. ¿Quieres comprar más Robux?";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "Necesitas {robuxToBuy} más para cambiar tu nombre de usuario. ¿Quieres comprar más Robux?";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "Debes proporcionar tu correo electrónico y verificarlo para poder añadir un PIN de la cuenta.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "Debes proporcionar tu correo electrónico y verificarlo para poder activar la verificación en dos pasos.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "Debes proporcionar tu correo electrónico y verificarlo para poder cambiar el nombre de usuario.";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "Introduce el PIN de cuenta asociado a tu cuenta";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"¿Seguro que quieres eliminar el número de teléfono que termina con {phoneLast4}?";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "¿Seguro que quieres eliminar el número de teléfono que termina con {phoneLast4}?";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "Debes verificar tu correo electrónico para poder añadir un PIN de la cuenta.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "Debes verificar tu correo electrónico para poder activar la verificación en dos pasos.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "Debes verificar tu correo electrónico para poder cambiar tu nombre de usuario.";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "Se te ha inscrito en el programa de informes Fast Track porque has enviado buenos informes de abuso. Los tuyos tendrán prioridad sobre otros y serán revisados rápidamente. Permanecerás en el programa siempre y cuando sigas enviando informes de buenas calidad. Gracias por ayudarnos a crear experiencias positivas en Roblox.";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "Estadísticas";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "No des ningún detalle que pueda usarse para identificarte fuera de Roblox.";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "La precisión depende de cuántas veces nuestro equipo de moderación comprueba la exactitud del contenido de los informes de abuso. Se mostrará tu número después de que hayas enviado varios. Con \"todos\" nos referimos a todos los miembros de Fast Track como grupo.";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "Actualizar la edad con una menor de 13 años activará el modo privado.";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "Cambio de contraseña";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "Cambio de nombre de usuario";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "Actualizar correo electrónico";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "Para preguntas de facturación y pagos: info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "Todavía no eres miembro. ¡Únete ya al Builders Club!";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "Todavía no eres miembro. ¡Únete a Roblox Premium ahora!";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "Ver notificaciones en las pantallas de inicio de tus dispositivos. Puedes activarlas y desactivarlas desde la aplicación de Roblox.";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "Notificaciones push de móvil para este dispositivo.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "Ver notificaciones en mi transmisión. Haz clic en el icono de las notificaciones en la barra superior para ver esas notificaciones.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "Si desactivas un tipo de notificación, ya no te enviaremos más notificaciones nuevas de ese tipo.";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "Nota: si deseas cancelar la renovación de tu suscripción, inicia sesión en la página web.";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "¡Guardado!";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "Es necesaria una dirección de correo electrónico verificada.";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"Cuando inicies sesión desde un dispositivo nuevo, se enviarán los códigos a {email}.";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "Cuando inicies sesión desde un dispositivo nuevo, se enviarán los códigos a {email}.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"Hola, usuario de Roblox: {lineBreaks}Tu nombre de usuario ha sido cambiado recientemente de {oldUsername} a {newUsername}. Si no solicitaste este cambio, envíanos un correo electrónico a {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "Hola, usuario de Roblox: {lineBreaks}Tu nombre de usuario ha sido cambiado recientemente de {oldUsername} a {newUsername}. Si no solicitaste este cambio, envíanos un correo electrónico a {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Cambio de nombre de usuario de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Cambio de nombre de usuario de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Cambio de nombre de usuario de Roblox";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Verificación del correo electrónico de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Verificación del correo electrónico de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Autorización de la cuenta de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Autorización de la cuenta de Roblox{escapeLiteralEnd}{fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"Querido usuario de Roblox: {lineBreak}{lineBreak}Nos complace que hayas elegido proteger tu cuenta {username} proporcionando una dirección de correo electrónico.{lineBreak}Al verificar el correo electrónico asociado a tu cuenta de Roblox, aumentas el nivel de seguridad de la cuenta.{lineBreak}Haz clic en el botón de abajo para completar el proceso de verificación.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verificar correo electrónico{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "Querido usuario de Roblox: {lineBreak}{lineBreak}Nos complace que hayas elegido proteger tu cuenta {username} proporcionando una dirección de correo electrónico.{lineBreak}Al verificar el correo electrónico asociado a tu cuenta de Roblox, aumentas el nivel de seguridad de la cuenta.{lineBreak}Haz clic en el botón de abajo para completar el proceso de verificación.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verificar correo electrónico{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Estimado padre de familia:{lineBreak}{lineBreak}Su hijo(a) ha creado la cuenta {boldTagStart}{username}{boldTagEnd} en Roblox, una plataforma de entretenimiento en línea que permite a los niños imaginar, crear y jugar juntos en mundos 3D inmersivos generados por los usuarios. Nuestra plataforma también ofrece una herramienta de desarrollo gratuita llamada \"Roblox Studio\", con la cual los usuarios pueden construir cualquier cosa que lleguen a imaginar: desde construcciones sencillas hechas arrastrando y soltando objetos hasta juegos multijugador complejos. Millones de niños han utilizado Roblox para imaginar lo que se siente al idear lo último en parques temáticos, competir como piloto profesional en carreras automovilísticas, ser una estrella de las pasarelas, o simplemente edificar una casa de ensueño y pasar el rato con amigos.{lineBreak}{lineBreak}Le enviamos este correo para informarle que su hijo(a) ha compartido con nosotros su nombre de usuario, fecha de nacimiento y la dirección de correo electrónico de uno de sus padres. El correo de los padres se utiliza exclusivamente para gestionar la cuenta, restablecer la contraseña si el menor la olvida y notificarle de cualquier cambio de acceso a la cuenta del niño. Para verificar el correo electrónico, haga clic en el botón de abajo: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verificar correo{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Acerca de Roblox{boldTagEnd}{lineBreak}{lineBreak}En Roblox nos dedicamos a crear un ambiente agradable y apto para toda la familia. Evolucionamos constantemente nuestras funciones de seguridad y trabajamos junto con expertos en seguridad digital para ofrecer un entorno seguro y acogedor a todos los jugadores que quieren jugar, chatear y colaborar en proyectos creativos. Le recomendamos que visite nuestra Guía para los padres para familiarizarse con nuestra plataforma y encontrar consejos útiles sobre cómo crear una experiencia positiva para sus hijos en Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox también ofrece {boldTagStart}controles parentales{boldTagEnd}. Los padres pueden activar un PIN y cambiar la configuración de los canales de comunicación y chat del menor. Encontrará dichos controles en la configuración de la cuenta, bajo las pestañas de seguridad y privacidad después de iniciar sesión con la cuenta del menor.{lineBreak}{lineBreak}Para añadir un PIN del progenitor, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para cambiar la configuración del chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidad{boldTagEnd}{lineBreak}{lineBreak}Puede eliminar la cuenta de su hijo(a) contactándose con nuestro servicio al cliente en {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Su correo electrónico no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre su hijo(a). Para obtener más información, revise nuestra política de privacidad en {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox {lineBreak}{lineBreak}No responda a este correo directamente. {lineBreak}{lineBreak}{aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "Estimado padre de familia:{lineBreak}{lineBreak}Su hijo(a) ha creado la cuenta {boldTagStart}{username}{boldTagEnd} en Roblox, una plataforma de entretenimiento en línea que permite a los niños imaginar, crear y jugar juntos en mundos 3D inmersivos generados por los usuarios. Nuestra plataforma también ofrece una herramienta de desarrollo gratuita llamada \"Roblox Studio\", con la cual los usuarios pueden construir cualquier cosa que lleguen a imaginar: desde construcciones sencillas hechas arrastrando y soltando objetos hasta juegos multijugador complejos. Millones de niños han utilizado Roblox para imaginar lo que se siente al idear lo último en parques temáticos, competir como piloto profesional en carreras automovilísticas, ser una estrella de las pasarelas, o simplemente edificar una casa de ensueño y pasar el rato con amigos.{lineBreak}{lineBreak}Le enviamos este correo para informarle que su hijo(a) ha compartido con nosotros su nombre de usuario, fecha de nacimiento y la dirección de correo electrónico de uno de sus padres. El correo de los padres se utiliza exclusivamente para gestionar la cuenta, restablecer la contraseña si el menor la olvida y notificarle de cualquier cambio de acceso a la cuenta del niño. Para verificar el correo electrónico, haga clic en el botón de abajo: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verificar correo{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Acerca de Roblox{boldTagEnd}{lineBreak}{lineBreak}En Roblox nos dedicamos a crear un ambiente agradable y apto para toda la familia. Evolucionamos constantemente nuestras funciones de seguridad y trabajamos junto con expertos en seguridad digital para ofrecer un entorno seguro y acogedor a todos los jugadores que quieren jugar, chatear y colaborar en proyectos creativos. Le recomendamos que visite nuestra Guía para los padres para familiarizarse con nuestra plataforma y encontrar consejos útiles sobre cómo crear una experiencia positiva para sus hijos en Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox también ofrece {boldTagStart}controles parentales{boldTagEnd}. Los padres pueden activar un PIN y cambiar la configuración de los canales de comunicación y chat del menor. Encontrará dichos controles en la configuración de la cuenta, bajo las pestañas de seguridad y privacidad después de iniciar sesión con la cuenta del menor.{lineBreak}{lineBreak}Para añadir un PIN del progenitor, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para cambiar la configuración del chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidad{boldTagEnd}{lineBreak}{lineBreak}Puede eliminar la cuenta de su hijo(a) contactándose con nuestro servicio al cliente en {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Su correo electrónico no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre su hijo(a). Para obtener más información, revise nuestra política de privacidad en {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox {lineBreak}{lineBreak}No responda a este correo directamente. {lineBreak}{lineBreak}{aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Puede encontrar esos controles visitando las pestañas de seguridad y privacidad en la configuración de la cuenta después de iniciar sesión con la cuenta de su hijo(a).{lineBreak}{lineBreak}Para añadir el PIN de uno de los padres, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para cambiar la configuración del chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidad{boldTagEnd}{lineBreak}{lineBreak}Puede eliminar la cuenta del menor contactándose con nuestro servicio al cliente en {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Su correo electrónico no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre el menor. Revise nuestra política de privacidad si quiere obtener más información en {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox {lineBreak}{lineBreak} No responda a este correo electrónico directamente. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "Puede encontrar esos controles visitando las pestañas de seguridad y privacidad en la configuración de la cuenta después de iniciar sesión con la cuenta de su hijo(a).{lineBreak}{lineBreak}Para añadir el PIN de uno de los padres, visite: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Para cambiar la configuración del chat, visite: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacidad{boldTagEnd}{lineBreak}{lineBreak}Puede eliminar la cuenta del menor contactándose con nuestro servicio al cliente en {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Su correo electrónico no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre el menor. Revise nuestra política de privacidad si quiere obtener más información en {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox {lineBreak}{lineBreak} No responda a este correo electrónico directamente. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"Querido usuario de Roblox: {lineBreak}{lineBreak}Nos complace que hayas elegido proteger tu cuenta {username} proporcionando una dirección de correo electrónico.{lineBreak}Al verificar el correo electrónico asociado a tu cuenta de Roblox, aumentas el nivel de seguridad de la cuenta.{lineBreak}Haz clic en el enlace de abajo para completar el proceso de verificación{lineBreak}{verificationLink}.";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "Querido usuario de Roblox: {lineBreak}{lineBreak}Nos complace que hayas elegido proteger tu cuenta {username} proporcionando una dirección de correo electrónico.{lineBreak}Al verificar el correo electrónico asociado a tu cuenta de Roblox, aumentas el nivel de seguridad de la cuenta.{lineBreak}Haz clic en el enlace de abajo para completar el proceso de verificación{lineBreak}{verificationLink}.";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Estimado padre de familia:{lineBreak}{lineBreak}Su hijo(a) ha creado la cuenta {username} en Roblox, una plataforma de entretenimiento en línea que permite a los niños imaginar, crear y jugar juntos en mundos 3D inmersivos generados por los usuarios. Nuestra plataforma también ofrece una herramienta de desarrollo gratuita llamada \"Roblox Studio\", con la cual los usuarios pueden construir cualquier cosa que lleguen a imaginar: desde construcciones sencillas hechas arrastrando y soltando objetos hasta juegos multijugador complejos. Millones de niños han utilizado Roblox para imaginar lo que se siente al crear lo último en parques temáticos, competir como piloto profesional en carreras automovilísticas, ser una estrella de las pasarelas, o simplemente edificar una casa de ensueño y pasar el rato con amigos.{lineBreak}{lineBreak}Le enviamos este correo para informarle que su hijo(a) ha compartido con nosotros su nombre de usuario, fecha de nacimiento y la dirección de correo electrónico de uno de sus padres. El correo de los padres se utiliza exclusivamente para gestionar la cuenta, restablecer la contraseña si el menor la olvida y notificarle de cualquier cambio de acceso a la cuenta del niño. Para verificar el correo electrónico, haga clic en el botón de abajo:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Acerca de Roblox{lineBreak}{lineBreak}En Roblox nos dedicamos a crear un ambiente agradable y apto para toda la familia. Evolucionamos constantemente nuestras funciones de seguridad y trabajamos junto con expertos en seguridad digital para ofrecer un entorno seguro y relajado a todos los jugadores que quieran jugar, chatear y colaborar en proyectos creativos. Le recomendamos que visite nuestra Guía para los padres donde podrá familiarizarse con nuestra plataforma y encontrar consejos útiles sobre cómo crear una experiencia positiva para sus hijos en Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox también ofrece controles parentales. Los padres pueden activar un PIN y cambiar la configuración de los canales de comunicación y chat del menor. Encontrará dichos controles en la configuración de la cuenta, bajo las pestañas de seguridad y privacidad después de iniciar sesión con la cuenta del menor.{lineBreak}{lineBreak}Para añadir un PIN del progenitor, visite: {accountSecurityLink}{lineBreak}{lineBreak}Para cambiar la configuración del chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidad{lineBreak}{lineBreak}Puede eliminar la cuenta de su hijo contactándose con nuestro servicio al cliente en {supportPageLink}. Su correo electrónico no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre su hijo(a). Para obtener más información, revise nuestra política de privacidad en {privacyPageLink}.{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox{lineBreak}No responda a este correo directamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "Estimado padre de familia:{lineBreak}{lineBreak}Su hijo(a) ha creado la cuenta {username} en Roblox, una plataforma de entretenimiento en línea que permite a los niños imaginar, crear y jugar juntos en mundos 3D inmersivos generados por los usuarios. Nuestra plataforma también ofrece una herramienta de desarrollo gratuita llamada \"Roblox Studio\", con la cual los usuarios pueden construir cualquier cosa que lleguen a imaginar: desde construcciones sencillas hechas arrastrando y soltando objetos hasta juegos multijugador complejos. Millones de niños han utilizado Roblox para imaginar lo que se siente al crear lo último en parques temáticos, competir como piloto profesional en carreras automovilísticas, ser una estrella de las pasarelas, o simplemente edificar una casa de ensueño y pasar el rato con amigos.{lineBreak}{lineBreak}Le enviamos este correo para informarle que su hijo(a) ha compartido con nosotros su nombre de usuario, fecha de nacimiento y la dirección de correo electrónico de uno de sus padres. El correo de los padres se utiliza exclusivamente para gestionar la cuenta, restablecer la contraseña si el menor la olvida y notificarle de cualquier cambio de acceso a la cuenta del niño. Para verificar el correo electrónico, haga clic en el botón de abajo:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Acerca de Roblox{lineBreak}{lineBreak}En Roblox nos dedicamos a crear un ambiente agradable y apto para toda la familia. Evolucionamos constantemente nuestras funciones de seguridad y trabajamos junto con expertos en seguridad digital para ofrecer un entorno seguro y relajado a todos los jugadores que quieran jugar, chatear y colaborar en proyectos creativos. Le recomendamos que visite nuestra Guía para los padres donde podrá familiarizarse con nuestra plataforma y encontrar consejos útiles sobre cómo crear una experiencia positiva para sus hijos en Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox también ofrece controles parentales. Los padres pueden activar un PIN y cambiar la configuración de los canales de comunicación y chat del menor. Encontrará dichos controles en la configuración de la cuenta, bajo las pestañas de seguridad y privacidad después de iniciar sesión con la cuenta del menor.{lineBreak}{lineBreak}Para añadir un PIN del progenitor, visite: {accountSecurityLink}{lineBreak}{lineBreak}Para cambiar la configuración del chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidad{lineBreak}{lineBreak}Puede eliminar la cuenta de su hijo contactándose con nuestro servicio al cliente en {supportPageLink}. Su correo electrónico no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre su hijo(a). Para obtener más información, revise nuestra política de privacidad en {privacyPageLink}.{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox{lineBreak}No responda a este correo directamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Para cambiar la configuración del chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidad{lineBreak}{lineBreak} Puede eliminar la cuenta de su hijo(a) contactándose con nuestro servicio al cliente en {supportPageLink}. Su correo no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre su hijo(a). Revise nuestra política de privacidad para obtener más información en {privacyPageLink}.{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox{lineBreak}No responda a este correo electrónico directamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "Para cambiar la configuración del chat, visite: {chatPrivacyLink} {lineBreak}{lineBreak}Privacidad{lineBreak}{lineBreak} Puede eliminar la cuenta de su hijo(a) contactándose con nuestro servicio al cliente en {supportPageLink}. Su correo no se usará con ningún otro fin, no se compartirá con terceros ni se combinará con ninguna otra información personal que se recolecte sobre su hijo(a). Revise nuestra política de privacidad para obtener más información en {privacyPageLink}.{lineBreak}{lineBreak}Gracias,{lineBreak}{lineBreak}El equipo de Roblox{lineBreak}No responda a este correo electrónico directamente.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Verificación del correo electrónico de Roblox";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Autorización de la cuenta de Roblox";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "Descríbete (1000 caracteres máx.)";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "ej.: www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "ej.: http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "ej.: www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "ej.: @Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "ej.: www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "¿Qué son los controles de cuenta?";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "Información de la cuenta";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "Facturación";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "Usuarios bloqueados";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "Configuración de contactos";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "Notificaciones push de escritorio";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "Añadir contraseña";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "Añadir teléfono";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "Cambio de correo electrónico";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "Dirección de correo electrónico modificada";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "Cambio de contraseña";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "Cambio de nombre de usuario";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "Error";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "Editar teléfono";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "Fondos insuficientes";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Nombre de usuario no válido.";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "Añadir PIN";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "PIN de cuenta obligatorio";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "Eliminar teléfono";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "Correo verificado obligatorio";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "Verificar correo electrónico";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "Verificar teléfono";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "Fast Track";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "Estado de la suscripción";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "Notificarme cuando";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "Notificaciones";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "Notificarme cuando";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "Notificaciones push de escritorio";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "Notificaciones push de móvil";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "Flujo de notificaciones";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "Flujo de notificaciones";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "Otras configuraciones";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Mi configuración";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "Personal";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "PIN de la cuenta";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "Configuración de privacidad";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "Fecha de renovación";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "Restricciones de la cuenta";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "Cierre de sesión seguro";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "Redes sociales";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "Inicio de sesión social";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "Hecho";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "Información de la cuenta";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "Facturación";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "Fast Track";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "Notificaciones";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "Privacidad";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "Seguridad";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "Transacciones";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "Verificación en dos pasos";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "El PIN de la cuenta está desactivado.";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "El PIN de la cuenta está activado.";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "Las restricciones de la cuenta están desactivadas.";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "Las restricciones de la cuenta están activadas.";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "Añadir correo electrónico";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "Añadir correo electrónico";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "Añadir contraseña:";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "Añadir teléfono";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "Añadir teléfono";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "Para preguntas de facturación y pagos:";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"Para preguntas de facturación y pagos, visita las {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}páginas de ayuda sobre facturación{aTagEnd}.";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "Para preguntas de facturación y pagos, visita las {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}páginas de ayuda sobre facturación{aTagEnd}.";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"Terminada en {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "Terminada en {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "Coste";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "Fecha";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "Descripción";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "El servicio está desactivado en este momento. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "Sin transacciones";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "Tipo de pago";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "Fecha de nacimiento";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"Todavía no eres miembro. ¡Únete ya al {startSpan}Builders Club{endSpan}!";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "Todavía no eres miembro. ¡Únete ya al {startSpan}Builders Club{endSpan}!";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "cambia tu nombre de usuario";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "Elegir idioma";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "Desactivado";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "Conectar cuenta:";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "Elige un país o una región";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "Ubicación";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "Oscuro";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "Añadir mi correo electrónico";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "Añadir correo electrónico de un progenitor";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "Número de teléfono";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "Verificar contraseña de la cuenta";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "Cambiar mi correo electrónico";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "Cambiar mi correo electrónico";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "Cambiar correo electrónico del progenitor";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "Confirmar contraseña";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "Contraseña actual";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "Contraseña nueva";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "Contraseña de la cuenta";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "Nombre de usuario deseado (3-20 caracteres)";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "Confirma tu PIN";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"Crea un PIN de {digitCount} dígitos";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "Crea un PIN de {digitCount} dígitos";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "Número actual:";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "Dirección de correo electrónico modificada";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "Correo electrónico obligatorio";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "Correo electrónico verificado:";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "Verificar contraseña de la cuenta";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"Introduce el código ({digitCount} dígitos)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "Introduce el código ({digitCount} dígitos)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "Introduce el código que te acabamos de enviar al teléfono.";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "SMS de verificación";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "Personalizado";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "Predeterminado";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "Todos";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "Amigos, usuarios a los que sigo y seguidores";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "Amigos, usuarios a los que sigo";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "Amigos";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "Alto";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "Bajo";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "Medio";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "Ninguno";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "Nadie";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "Desactivado";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "Dirección de correo electrónico:";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "Correo electrónico de un progenitor:";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "Verificación pendiente";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "Caducidad";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Se vence el {startSpan}{expirationDate}{endSpan}";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "Se vence el {startSpan}{expirationDate}{endSpan}";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook:";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "Precisión";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "Todos";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "Mes";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "Año";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "Estadísticas";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "Tú";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "Sexo";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+:";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "Claro";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "Idioma";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"Suscripción al {startSpan}Builders Club{endSpan}";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "Suscripción al {startSpan}Builders Club{endSpan}";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "Todavía no eres miembro. ¡Únete a Roblox Premium ahora!";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "Me invitan a un servidor VIP";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "Alguien chatea conmigo";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "Alguien ancla un nuevo juego para jugar juntos";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "Cuando el informe analítico esté disponible";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "Alguien acepta mi solicitud de amistad";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "Recibo una solicitud de amistad";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "Recibo notificaciones de actualización";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "Alguien me invita a un grupo";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "Alguien se une a un grupo en el que estoy";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "Recibo un mensaje privado";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "Alguien me invita a editar un juego.";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "Contraseña:";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "Número de teléfono:";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "min.";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "Tiempo restante";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "seg.";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "Nombres de usuario anteriores:";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "Modo privado";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "Fecha de renovación";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Renovación automática el {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "Renovación automática el {startSpan}{expirationDate}{endSpan}.";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox Premium {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox Premium {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount}\u00a0Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount}\u00a0Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "Cerrar todas las demás sesiones";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "Visible para:";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"Conectado como {socialUsername}";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "Conectado como {socialUsername}";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "Tema";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "Personalizado: controla tu propia configuración. Predeterminado: activa chat y mensajes con amigos. Desactivado: desactiva chat y mensajes.";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "La configuración está bloqueada. Para editarla, desbloquéala con tu PIN.";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "Haz clic para bloquear tu página de Configuración";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "Haz clic aquí para obtener más información.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "Este ajuste controla con quién se le permitirá al usuario chatear en la aplicación y en la web (no dentro del juego). También impide que el usuario publique en foros y en muros de grupos.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "Este ajuste controla con quién se le permitirá al usuario chatear dentro del juego.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "Este ajuste controla quién puede encontrarte mediante el número de teléfono que has proporcionado.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "Este ajuste controla quién puede unirse a este usuario en servidores VIP (a los que solo se puede acceder mediante invitación de su propietario).";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "Este ajuste controla quién puede ver en qué juego estoy y unirse a mí en mi servidor. Seleccionar «Nadie» significa que nadie puede seguirme a mi servidor específico, pero jugaré con otros usuarios.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "Este ajuste controla de quién puede recibir mensajes este usuario en su buzón.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "Esta configuración controla quién puede ver tu inventario.";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "Filtro de calidad de intercambio";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter:";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "Activar verificación en dos pasos";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "Es necesaria una dirección de correo electrónico verificada.";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "Mejora la seguridad de tu cuenta. Se te pedirá un código cuando inicies sesión desde un dispositivo nuevo.";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "¡Tu cuenta está protegida!";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "Actualizar correo electrónico";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "Actualizar teléfono";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "Usar el idioma del dispositivo";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Nombre de usuario:";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "Verificado";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "Verificar";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "¿Quién puede hablar conmigo en la aplicación?";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "¿Quién puede chatear conmigo?";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "¿Quién puede encontrarme por mi número de teléfono?";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "¿Quién puede invitarme a servidores VIP?";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "¿Quién puede unirse a mí?";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "¿Quién puede enviarme mensajes?";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "¿Quién puede ver mi inventario?";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "¿Quién puede hacer intercambios conmigo?";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "Conectado con una cuenta de Xbox";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube:";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Robux insuficientes";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "La cuenta ya tiene un PIN. Intenta con otra solicitud.";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "La cuenta está bloqueada. Desbloquéala antes de realizar esta acción.";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "Algo ha ido mal. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "El correo electrónico ya se ha verificado.";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "La función está desactivada en este momento. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "La contraseña es incorrecta.";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "Dirección de correo electrónico no válida.";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "No hay direcciones de correo electrónico asociadas a esta cuenta.";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "El PIN está bloqueado.";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "Este correo electrónico ya es el actual.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "Hay demasiadas cuentas asociadas a esta dirección de correo electrónico.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "Demasiados intentos para actualizar el correo electrónico. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "Demasiados intentos para enviar un correo electrónico de verificación. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "Se ha producido un error desconocido.";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "PIN incorrecto.";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "Formato del PIN no válido.";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "No existe un PIN para esta cuenta.";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "La cuenta no tiene un correo electrónico verificado.";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "Error del sistema.";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "Demasiadas solicitudes. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "Correo electrónico añadido";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "Tu correo electrónico ya se ha verificado.";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "La función está desactivada en este momento. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "No tienes suficientes Robux para cambiar el nombre de usuario.";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "Correo electrónico no válido";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "Debes asociar una dirección de correo electrónico con la cuenta.";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "No tienes suficientes Robux para cambiar el nombre de usuario.";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "El PIN está bloqueado.";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "Este correo electrónico ya se ha verificado.";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "Se ha actualizado la configuración.";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "Hay demasiadas cuentas asociadas a este correo electrónico.";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "Demasiados intentos. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "Se ha producido un error desconocido.";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "La contraseña es incorrecta.";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "El código no es válido. Comprueba tu teléfono e inténtalo de nuevo.";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "El valor de \"Quién puede intercambiar conmigo\" debe ser igual o más restrictivo que el valor de \"Quién puede ver mi inventario\".";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "Es necesario introducir un código. Introduce el tuyo.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "Si cambias tu fecha de nacimiento de manera que seas menor de 13 años, el cambio no podrá deshacerse. ¿Seguro que quieres continuar?";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "Debes añadir una contraseña a tu cuenta de Roblox para cambiar tu fecha de nacimiento.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "Debes añadir contraseña";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "Si cambias tu fecha de nacimiento de manera que seas menor de 13 años, el cambio no podrá deshacerse. Se desactivará tu inicio de sesión social con Facebook y tendrás que iniciar sesión con tu contraseña de Roblox.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "La contraseña actual es incorrecta. La contraseña no se ha modificado.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "Las contraseñas no coinciden.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "Debe tener al menos 8 caracteres.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "Introduce un nombre de usuario.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "Nombre de usuario inadecuado para Roblox.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "Ese nombre de usuario ya está en uso.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "Nombre de usuario cambiado correctamente.";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "Error al cargar lista de países";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "Se ha producido un error con el servicio de divisas. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "Algo ha ido mal. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "Se ha producido un error";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "¡Guardado!";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "Se ha producido un error al desconectarte de tu cuenta de Xbox. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "Se ha enviado un correo electrónico de verificación.";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "Dirección de correo electrónico no válida";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "Número de teléfono no válido";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Pulsa Enviar para enviar un ticket o Cancelar para editar el nombre de usuario. Proporcionar el nombre de usuario puede ayudar a priorizar tu problema.";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "La contraseña debe contener al menos 2 dígitos, 4 letras, 1 símbolo y tener al menos 8 caracteres.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "Has fijado tu PIN. Tendrás que introducir este PIN para poder acceder a la página de Configuración en el futuro.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "Los PIN no coinciden";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "Se ha producido un error al desconectarte de las otras sesiones. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "Te has desconectado de todas las otras sesiones.";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "Si desactivas la verificación en dos pasos, solo hará falta tu contraseña para iniciar sesión desde un dispositivo nuevo. ¿Seguro que quieres continuar?";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "Verificación en dos pasos activada";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "Tu cuenta está protegida. No es necesario que hagas nada más. Se te enviará un código de seguridad la próxima vez que inicies sesión desde un dispositivo nuevo.";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "Hemos actualizado la configuración de privacidad del inventario. La configuración del inventario y la del intercambio deben ser coherentes.";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "Se ha producido un error al actualizar tu configuración de notificaciones. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "Hemos actualizado la configuración de privacidad del intercambio. La configuración del inventario y la del intercambio deben ser coherentes.";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "El código no es válido. Comprueba tu teléfono e inténtalo de nuevo.";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "Advertencia";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "La función está desactivada en este momento. Inténtalo de nuevo más tarde.";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "Se ha producido un error. Inténtalo de nuevo.";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "Has introducido un código incorrecto demasiadas veces.";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "Contraseña incorrecta. Compruébala e inténtalo de nuevo.";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "El formato del número de teléfono no es válido. Compruébalo e inténtalo de nuevo.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "Se ha eliminado el teléfono.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "Se ha actualizado el teléfono.";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "El número ya está asociado a otra cuenta.";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "Introduce tu PIN para cambiar la configuración.";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "El enlace de la red social no es válido.";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "Los sentimos, no puedes cambiar la edad de tu cuenta a menor de 13 años. Si eres menor de 13 años, crea una nueva cuenta y contáctate con soporte para eliminar la vieja.";
	}
}
