namespace Roblox.TranslationResources.Feature;

/// <summary>
/// This class overrides AccountSettingsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AccountSettingsResources_de_de : AccountSettingsResources_en_us, IAccountSettingsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BillingHistoryLoadMore"
	/// English String: "Load More"
	/// </summary>
	public override string ActionBillingHistoryLoadMore => "Mehr laden";

	/// <summary>
	/// Key: "Action.CancelRenewal"
	/// English String: "Cancel Renewal"
	/// </summary>
	public override string ActionCancelRenewal => "Verlängerung abbrechen";

	/// <summary>
	/// Key: "Action.Dialog.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string ActionDialogAddEmail => "E-Mail-Adresse hinzufügen";

	/// <summary>
	/// Key: "Action.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string ActionDialogAddPhone => "Handy hinzufügen";

	/// <summary>
	/// Key: "Action.Dialog.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogCancel => "Abbrechen";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmail"
	/// English String: "Change Email"
	/// </summary>
	public override string ActionDialogChangeEmail => "E-Mail-Adresse ändern";

	/// <summary>
	/// Key: "Action.Dialog.ChangeEmailConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangeEmailConfirmation => "Okay";

	/// <summary>
	/// Key: "Action.Dialog.ChangePassword"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogChangePassword => "Aktualisieren";

	/// <summary>
	/// Key: "Action.Dialog.ChangePasswordConfirmation"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogChangePasswordConfirmation => "Okay";

	/// <summary>
	/// Key: "Action.Dialog.ChangeUsernameBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogChangeUsernameBuy => "Kaufen";

	/// <summary>
	/// Key: "Action.Dialog.Close"
	/// English String: "Close"
	/// </summary>
	public override string ActionDialogClose => "Schließen";

	/// <summary>
	/// Key: "Action.Dialog.EditPhonePrimary"
	/// English String: "Edit Phone"
	/// </summary>
	public override string ActionDialogEditPhonePrimary => "Handy bearbeiten";

	/// <summary>
	/// Key: "Action.Dialog.EditPhoneSecondary"
	/// English String: "Remove Phone Number"
	/// </summary>
	public override string ActionDialogEditPhoneSecondary => "Handynummer entfernen";

	/// <summary>
	/// Key: "Action.Dialog.InsufficientFundsBuy"
	/// English String: "Buy"
	/// </summary>
	public override string ActionDialogInsufficientFundsBuy => "Kaufen";

	/// <summary>
	/// Key: "Action.Dialog.No"
	/// English String: "No"
	/// </summary>
	public override string ActionDialogNo => "Nein";

	/// <summary>
	/// Key: "Action.Dialog.PinCreate"
	/// English String: "Add"
	/// </summary>
	public override string ActionDialogPinCreate => "Hinzufügen";

	/// <summary>
	/// Key: "Action.Dialog.PinCreateOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogPinCreateOk => "Okay";

	/// <summary>
	/// Key: "Action.Dialog.PinUnlock"
	/// English String: "Unlock"
	/// </summary>
	public override string ActionDialogPinUnlock => "Entsperren";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhonePrimary"
	/// English String: "Remove"
	/// </summary>
	public override string ActionDialogRemovePhonePrimary => "Entfernen";

	/// <summary>
	/// Key: "Action.Dialog.RemovePhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogRemovePhoneSecondary => "Abbrechen";

	/// <summary>
	/// Key: "Action.Dialog.Send"
	/// Send
	/// English String: "Send"
	/// </summary>
	public override string ActionDialogSend => "Senden";

	/// <summary>
	/// Key: "Action.Dialog.Success"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogSuccess => "Okay";

	/// <summary>
	/// Key: "Action.Dialog.Update"
	/// English String: "Update"
	/// </summary>
	public override string ActionDialogUpdate => "Aktualisieren";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailOk"
	/// English String: "OK"
	/// </summary>
	public override string ActionDialogVerifyEmailOk => "Okay";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailPrimary"
	/// English String: "Verify Email"
	/// </summary>
	public override string ActionDialogVerifyEmailPrimary => "E-Mail-Adresse verifizieren";

	/// <summary>
	/// Key: "Action.Dialog.VerifyEmailRetry"
	/// English String: "Retry"
	/// </summary>
	public override string ActionDialogVerifyEmailRetry => "Erneut versuchen";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhonePrimary"
	/// English String: "Verify"
	/// </summary>
	public override string ActionDialogVerifyPhonePrimary => "Verifizieren";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneResendLink"
	/// English String: "Resend Code"
	/// </summary>
	public override string ActionDialogVerifyPhoneResendLink => "Code erneut senden";

	/// <summary>
	/// Key: "Action.Dialog.VerifyPhoneSecondary"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionDialogVerifyPhoneSecondary => "Abbrechen";

	/// <summary>
	/// Key: "Action.Dialog.Yes"
	/// English String: "Yes"
	/// </summary>
	public override string ActionDialogYes => "Ja";

	/// <summary>
	/// Key: "Action.Hide"
	/// English String: "Hide"
	/// </summary>
	public override string ActionHide => "Verbergen";

	/// <summary>
	/// Key: "Action.Join"
	/// English String: "Join"
	/// </summary>
	public override string ActionJoin => "Beitreten";

	/// <summary>
	/// Key: "Action.JoinBuildersClub"
	/// English String: "Join Builders Club"
	/// </summary>
	public override string ActionJoinBuildersClub => "Builders Club beitreten";

	/// <summary>
	/// Key: "Action.Save"
	/// English String: "Save"
	/// </summary>
	public override string ActionSave => "Speichern";

	/// <summary>
	/// Key: "Action.Show"
	/// English String: "Show"
	/// </summary>
	public override string ActionShow => "Anzeigen";

	/// <summary>
	/// Key: "Action.SignoutAllSessions"
	/// English String: "Sign out"
	/// </summary>
	public override string ActionSignoutAllSessions => "Abmelden";

	/// <summary>
	/// Key: "Action.SocialDisconnect"
	/// English String: "Disconnect"
	/// </summary>
	public override string ActionSocialDisconnect => "Verbindung trennen";

	/// <summary>
	/// Key: "Action.SuccessDialogButtonText"
	/// English String: "OK"
	/// </summary>
	public override string ActionSuccessDialogButtonText => "Okay";

	/// <summary>
	/// Key: "Action.Unblock"
	/// English String: "Unblock"
	/// </summary>
	public override string ActionUnblock => "Nicht mehr sperren";

	/// <summary>
	/// Key: "Action.UpgradeMembership"
	/// English String: "Upgrade Membership"
	/// </summary>
	public override string ActionUpgradeMembership => "Mitgliedschaft aufwerten";

	/// <summary>
	/// Key: "Description.AccountControls"
	/// English String: "You can setup account restrictions on this account to restrict access to account settings and uncurated content"
	/// </summary>
	public override string DescriptionAccountControls => "Du kannst Kontoeinschränkungen für dieses Konto einrichten, um den Zugriff auf Kontoeinstellungen und ungeprüfte Inhalte einzuschränken.";

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.Subject"
	/// Subject for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Roblox Email Reset"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailSubject => "Roblox-E-Mail zurückgesetzt";

	/// <summary>
	/// Key: "Description.DesktopPush1"
	/// English String: "See notifications on this computer even when Roblox is closed."
	/// </summary>
	public override string DescriptionDesktopPush1 => "Erhalte selbst dann Benachrichtigungen auf diesem Computer, wenn Roblox nicht geöffnet ist.";

	/// <summary>
	/// Key: "Description.DesktopPush2"
	/// English String: "To see notifications, you may be prompted to turn on push notifications on your browser."
	/// </summary>
	public override string DescriptionDesktopPush2 => "Um Benachrichtigungen zu sehen, wirst du eventuell dazu aufgefordert, Push-Benachrichtigungen in deinem Browser zu aktivieren.";

	/// <summary>
	/// Key: "Description.DesktopPush3"
	/// English String: "Desktop notifications for this device."
	/// </summary>
	public override string DescriptionDesktopPush3 => "Desktop-Benachrichtigungen für dieses Gerät.";

	/// <summary>
	/// Key: "Description.Dialog.AddPhone"
	/// English String: "Please confirm your country code and enter your phone number. We will send a text message to complete verification. (Note: Text messaging charges may apply)"
	/// </summary>
	public override string DescriptionDialogAddPhone => "Bitte bestätige deine Ländervorwahl und gib deine Handynummer ein. Wir werden dir eine SMS schicken, um die Verifizierung abzuschließen. (Hinweis: Es können SMS-Kosten anfallen.)";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailConfirmation"
	/// English String: "An email has been sent for verification"
	/// </summary>
	public override string DescriptionDialogChangeEmailConfirmation => "Wir haben dir eine E-Mail zur Verifizierung gesendet.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeEmailWarning"
	/// English String: "The account email will not change until the new email has been verified."
	/// </summary>
	public override string DescriptionDialogChangeEmailWarning => "Die E-Mail-Adresse des Kontos wird erst aktualisiert, nachdem die neue E-Mail-Adresse verifiziert wurde.";

	/// <summary>
	/// Key: "Description.Dialog.ChangePasswordConfirmation"
	/// English String: "You have successfully changed your password."
	/// </summary>
	public override string DescriptionDialogChangePasswordConfirmation => "Du hast dein Passwort erfolgreich geändert.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameDisclaimer"
	/// English String: "Important: Original account creation date will carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameDisclaimer => "Wichtig: Das ursprüngliche Kontoerstellungsdatum wird auf deinen neuen Benutzernamen übertragen.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameForFree"
	/// Description notifying the user that this username change is free
	/// English String: "Change username once for free."
	/// </summary>
	public override string DescriptionDialogChangeUsernameForFree => "Du kannst deinen Benutzernamen einmal kostenlos ändern.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameHistory"
	/// English String: "Previous forum posts will appear under your old username and will NOT carry over to your new username."
	/// </summary>
	public override string DescriptionDialogChangeUsernameHistory => "Bisherige Forumposts werden weiterhin unter deinem alten Benutzernamen geführt und werden NICHT auf deinen neuen Benutzernamen übertragen.";

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernameTitle"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionDialogChangeUsernameTitle => "Benutzernamen ändern";

	/// <summary>
	/// Key: "Description.Dialog.EditPhoneWarning"
	/// English String: "The phone number will not change until the new phone number has been verified."
	/// </summary>
	public override string DescriptionDialogEditPhoneWarning => "Die Handynummer wird erst aktualisiert, nachdem die neue Handynummer verifiziert wurde.";

	/// <summary>
	/// Key: "Description.Dialog.EmailProvideAndVerifyWarning"
	/// warning message when user doesn't have email address on file at the time of changing username
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailProvideAndVerifyWarning => "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerificationSent"
	/// English String: "Thanks! Your verification email has been sent."
	/// </summary>
	public override string DescriptionDialogEmailVerificationSent => "Danke! Wir haben dir eine E-Mail zur Verifizierung gesendet.";

	/// <summary>
	/// Key: "Description.Dialog.EmailVerifyWarning"
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogEmailVerifyWarning => "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse verifizieren.";

	/// <summary>
	/// Key: "Description.Dialog.FacebookDisconnectWarning"
	/// English String: "Please add password to secure your account before disconnecting from Facebook."
	/// </summary>
	public override string DescriptionDialogFacebookDisconnectWarning => "Bitte füge ein Passwort hinzu, um dein Konto zu sichern, bevor du die Verbindung zu Facebook trennst.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailAccountPin"
	/// error message
	/// English String: "You must provide and verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogMissingEmailAccountPin => "Bevor du eine Konto-PIN hinzufügen kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailTwoStepVerification"
	/// error message
	/// English String: "You must provide and verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogMissingEmailTwoStepVerification => "Bevor du die Verifizierung in 2 Schritten aktivieren kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";

	/// <summary>
	/// Key: "Description.Dialog.MissingEmailUsername"
	/// error message
	/// English String: "You must provide and verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogMissingEmailUsername => "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";

	/// <summary>
	/// Key: "Description.Dialog.PinUnlock"
	/// English String: "Enter the Account PIN attached to your account"
	/// </summary>
	public override string DescriptionDialogPinUnlock => "Gib die Konto-PIN für dein Konto ein.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailAccountPin"
	/// error message
	/// English String: "You must verify your email before you can add an Account PIN."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailAccountPin => "Bevor du eine Konto-PIN hinzufügen kannst, musst du deine E-Mail-Adresse verifizieren.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailTwoStepVerification"
	/// error message
	/// English String: "You must verify your email before you can enable 2 Step Verification."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailTwoStepVerification => "Bevor du die Verifizierung in 2 Schritten aktivieren kannst, musst du deine E-Mail-Adresse verifizieren.";

	/// <summary>
	/// Key: "Description.Dialog.UnverifiedEmailUsername"
	/// error message
	/// English String: "You must verify your email before you can change your username."
	/// </summary>
	public override string DescriptionDialogUnverifiedEmailUsername => "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse verifizieren.";

	/// <summary>
	/// Key: "Description.FastTrack"
	/// A description of the Fast Track program that is intended to help users understand why they are part of the program and how they can best be involved.
	/// English String: "You have been enrolled in the Fast Track reporting program for making good abuse reports.  Your abuse reports are now Fast Tracked for review.  Stay in the program by continuing to make good abuse reports. Thank you for helping to make Roblox a positive experience!"
	/// </summary>
	public override string DescriptionFastTrack => "Da du gute Arbeit bei der Meldung von Verstößen geleistet hast, wurdest du ins Expressmeldungsprogramm aufgenommen. Deine Meldungen werden ab sofort bevorzugt geprüft. Wenn du weiterhin gute Arbeit leistest, verbleibst du im Programm. Danke für deine Hilfe, Roblox zu einer positiven Erfahrung für alle zu machen!";

	/// <summary>
	/// Key: "Description.FastTrack.Statistics"
	/// A section of the page dedicated to reporting, analysis, and charting of Fast Track contributor quality.
	/// English String: "Statistics"
	/// </summary>
	public override string DescriptionFastTrackStatistics => "Statistiken";

	/// <summary>
	/// Key: "Description.HelpText.Description"
	/// English String: "Do not provide any details that can be used to identify you outside Roblox."
	/// </summary>
	public override string DescriptionHelpTextDescription => "Gib keine Informationen an, mit denen du außerhalb von Roblox identifiziert werden könntest.";

	/// <summary>
	/// Key: "Description.HelpText.FastTrack.Accuracy"
	/// Help text that explains to users how we define Accuracy of abuse reports for the Fast Track program. Intention is to help avoid user confusion about the meaning of the scores.
	/// English String: "Accuracy is how often moderation agreed with abuse reports. Your number will show after you submit several reports. 'Everyone' means all of the Fast Track members as a group."
	/// </summary>
	public override string DescriptionHelpTextFastTrackAccuracy => "Die Genauigkeit spiegelt wider, wie häufig unser Moderationsteam deine Meldungen über Verstöße bestätigt. Dieser Wert wird erst angezeigt, nachdem du einige Meldungen eingereicht hast. „Jeder“ bezeichnet alle Expressmeldungsmitglieder zusammengenommen.";

	/// <summary>
	/// Key: "Description.HelpText.PrivacyMode"
	/// English String: "Updating age to under 13 will enable Privacy Mode."
	/// </summary>
	public override string DescriptionHelpTextPrivacyMode => "Wenn das Alter zu unter 13 Jahren geändert wird, wird der Datenschutzmodus aktiviert.";

	/// <summary>
	/// Key: "Description.HoverText.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string DescriptionHoverTextChangePassword => "Passwort ändern";

	/// <summary>
	/// Key: "Description.HoverText.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string DescriptionHoverTextChangeUsername => "Benutzernamen ändern";

	/// <summary>
	/// Key: "Description.HoverText.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string DescriptionHoverTextUpdateEmail => "E-Mail-Adresse aktualisieren";

	/// <summary>
	/// Key: "Description.MembershipHelp"
	/// English String: "For billing and payment questions: info@roblox.com"
	/// </summary>
	public override string DescriptionMembershipHelp => "Für Fragen zu Zahlungen: info@roblox.com";

	/// <summary>
	/// Key: "Description.MembershipStatus"
	/// English String: "You're not a member yet. Join Builders Club today!"
	/// </summary>
	public override string DescriptionMembershipStatus => "Du bist noch kein Mitglied. Tritt gleich dem Builders Club bei!";

	/// <summary>
	/// Key: "Description.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string DescriptionMembershipStatusRobloxPremium => "Du bist noch kein Mitglied. Tritt Roblox-Premium heute bei!";

	/// <summary>
	/// Key: "Description.MobilePush1"
	/// English String: "See notifications on your devices' home screens. You can turn them on or off from the Roblox app."
	/// </summary>
	public override string DescriptionMobilePush1 => "Erhalte Benachrichtigungen auf den Startbildschirmen deiner Geräte. Du kannst sie über die Roblox-App an- oder ausschalten.";

	/// <summary>
	/// Key: "Description.MobilePush2"
	/// English String: "Mobile push notifications for this device."
	/// </summary>
	public override string DescriptionMobilePush2 => "Mobilgerät-Push-Benachrichtigung für dieses Gerät.";

	/// <summary>
	/// Key: "Description.NotificationStream1"
	/// English String: "See notifications in my stream. Click the notifications icon in the top bar to view these notifications."
	/// </summary>
	public override string DescriptionNotificationStream1 => "Erhalte Benachrichtigungen in deinem Stream. Klicke auf das Benachrichtigungssymbol in der oberen Leiste, um diese Benachrichtigungen zu sehen.";

	/// <summary>
	/// Key: "Description.NotificationStream2"
	/// English String: "After you turn off a notification type, we won't send you any new notifications of that type."
	/// </summary>
	public override string DescriptionNotificationStream2 => "Wenn du eine bestimmte Benachrichtigungsart ausschaltest, werden wir dir keine Benachrichtigungen dieser Art mehr schicken.";

	/// <summary>
	/// Key: "Description.RenevalFromWebsiteOnly"
	/// English String: "Note: If you would like to cancel your renewal membership, please log in from the website."
	/// </summary>
	public override string DescriptionRenevalFromWebsiteOnly => "Hinweis: Falls du deine Mitgliedschaft nicht mehr verlängern möchtest, melde dich bitte über die Website an.";

	/// <summary>
	/// Key: "Description.SuccessDialogMessage"
	/// English String: "Saved  Successfully!"
	/// </summary>
	public override string DescriptionSuccessDialogMessage => "Erfolgreich gespeichert!";

	/// <summary>
	/// Key: "Description.TwoStepVerificationSecondary"
	/// English String: "A verified email is required"
	/// </summary>
	public override string DescriptionTwoStepVerificationSecondary => "Eine verifizierte E-Mail-Adresse ist erforderlich.";

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Subject"
	/// Subject for username change email that is sent out on a successful change of username
	/// English String: "Roblox Username Change"
	/// </summary>
	public override string DescriptionUsernameChangeEmailSubject => "Änderung des Roblox-Benutzernamens";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Over13"
	/// Subject for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Roblox Email Verification"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectOver13 => "Roblox-E-Mail-Verifizierung";

	/// <summary>
	/// Key: "Description.VerificationEmail.Subject.Under13"
	/// Subject for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Roblox Account Authorization"
	/// </summary>
	public override string DescriptionVerificationEmailSubjectUnder13 => "Roblox-Kontoautorisierung";

	/// <summary>
	/// Key: "Example.Description"
	/// English String: "Describe yourself(1000 character limit)"
	/// </summary>
	public override string ExampleDescription => "Beschreibe dich (max. 1000 Zeichen)";

	/// <summary>
	/// Key: "Example.Facebook"
	/// English String: "e.g. www.facebook.com/Roblox"
	/// </summary>
	public override string ExampleFacebook => "z.\u00a0B. www.facebook.com/Roblox";

	/// <summary>
	/// Key: "Example.GooglePlus"
	/// English String: "e.g. http://plus.google.com/profileId"
	/// </summary>
	public override string ExampleGooglePlus => "z. B. http://plus.google.com/profileId";

	/// <summary>
	/// Key: "Example.Twitch"
	/// English String: "e.g. www.twitch.tv/roblox/profile"
	/// </summary>
	public override string ExampleTwitch => "z.\u00a0B. www.twitch.tv/roblox/profile";

	/// <summary>
	/// Key: "Example.Twitter"
	/// English String: "e.g. @Roblox"
	/// </summary>
	public override string ExampleTwitter => "z.\u00a0B. @Roblox";

	/// <summary>
	/// Key: "Example.YouTube"
	/// English String: "e.g. www.youtube.com/user/roblox"
	/// </summary>
	public override string ExampleYouTube => "z.\u00a0B. www.youtube.com/user/roblox";

	/// <summary>
	/// Key: "Heading.AccountControls"
	/// English String: "What are Account Controls?"
	/// </summary>
	public override string HeadingAccountControls => "Was ist die Kontosteuerung?";

	/// <summary>
	/// Key: "Heading.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingAccountInfo => "Kontodetails";

	/// <summary>
	/// Key: "Heading.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingBilling => "Zahlungen";

	/// <summary>
	/// Key: "Heading.BlockedUsers"
	/// English String: "Blocked Users"
	/// </summary>
	public override string HeadingBlockedUsers => "Gesperrte Benutzer";

	/// <summary>
	/// Key: "Heading.ContactSettings"
	/// English String: "Contact Settings"
	/// </summary>
	public override string HeadingContactSettings => "Kontakteinstellungen";

	/// <summary>
	/// Key: "Heading.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingDesktopPush => "Desktop-Push-Benachrichtigung";

	/// <summary>
	/// Key: "Heading.Dialog.AddPassword"
	/// English String: "Add Password"
	/// </summary>
	public override string HeadingDialogAddPassword => "Passwort hinzufügen";

	/// <summary>
	/// Key: "Heading.Dialog.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string HeadingDialogAddPhone => "Handy hinzufügen";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmail"
	/// English String: "Change My Email"
	/// </summary>
	public override string HeadingDialogChangeEmail => "Meine E-Mail-Adresse ändern";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeEmailConfirmation"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string HeadingDialogChangeEmailConfirmation => "E-Mail-Adresse geändert";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePassword"
	/// English String: "Change Password"
	/// </summary>
	public override string HeadingDialogChangePassword => "Passwort ändern";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordConfirmation => "Erfolg";

	/// <summary>
	/// Key: "Heading.Dialog.ChangePasswordSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogChangePasswordSuccess => "Erfolg";

	/// <summary>
	/// Key: "Heading.Dialog.ChangeUsername"
	/// English String: "Change Username"
	/// </summary>
	public override string HeadingDialogChangeUsername => "Benutzernamen ändern";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultError"
	/// English String: "Error"
	/// </summary>
	public override string HeadingDialogDefaultError => "Fehler";

	/// <summary>
	/// Key: "Heading.Dialog.DefaultSuccess"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogDefaultSuccess => "Erfolg";

	/// <summary>
	/// Key: "Heading.Dialog.EditPhone"
	/// English String: "Edit Phone"
	/// </summary>
	public override string HeadingDialogEditPhone => "Handy bearbeiten";

	/// <summary>
	/// Key: "Heading.Dialog.InsufficientFunds"
	/// English String: "Insufficient Funds"
	/// </summary>
	public override string HeadingDialogInsufficientFunds => "Nicht genügend Guthaben";

	/// <summary>
	/// Key: "Heading.Dialog.InvalidUsername"
	/// Invalid Username
	/// English String: "Invalid Username"
	/// </summary>
	public override string HeadingDialogInvalidUsername => "Ungültiger Benutzername";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreate"
	/// English String: "Add PIN"
	/// </summary>
	public override string HeadingDialogPinCreate => "PIN hinzufügen";

	/// <summary>
	/// Key: "Heading.Dialog.PinCreateSuccessConfirmation"
	/// English String: "Success"
	/// </summary>
	public override string HeadingDialogPinCreateSuccessConfirmation => "Erfolg";

	/// <summary>
	/// Key: "Heading.Dialog.PinUnlock"
	/// English String: "Account PIN Required"
	/// </summary>
	public override string HeadingDialogPinUnlock => "Konto-PIN erforderlich";

	/// <summary>
	/// Key: "Heading.Dialog.RemovePhone"
	/// English String: "Remove Phone"
	/// </summary>
	public override string HeadingDialogRemovePhone => "Handy entfernen";

	/// <summary>
	/// Key: "Heading.Dialog.VerifiedEmailRequired"
	/// English String: "Verified Email Required"
	/// </summary>
	public override string HeadingDialogVerifiedEmailRequired => "Verifizierte E-Mail-Adresse erforderlich";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyEmail"
	/// English String: "Verify Email"
	/// </summary>
	public override string HeadingDialogVerifyEmail => "E-Mail-Adresse verifizieren";

	/// <summary>
	/// Key: "Heading.Dialog.VerifyPhone"
	/// English String: "Verify Phone"
	/// </summary>
	public override string HeadingDialogVerifyPhone => "Handy verifizieren";

	/// <summary>
	/// Key: "Heading.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingFastTrack => "Expressmeldung";

	/// <summary>
	/// Key: "Heading.MembershipStatus"
	/// English String: "Membership status"
	/// </summary>
	public override string HeadingMembershipStatus => "Mitgliedschaftsstatus";

	/// <summary>
	/// Key: "Heading.NotificationOptions"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationOptions => "Ich möchte eine Benachrichtigung, wenn:";

	/// <summary>
	/// Key: "Heading.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingNotifications => "Benachrichtigungen";

	/// <summary>
	/// Key: "Heading.Notifications.ActionWhen"
	/// English String: "Notify me when"
	/// </summary>
	public override string HeadingNotificationsActionWhen => "Ich möchte eine Benachrichtigung, wenn:";

	/// <summary>
	/// Key: "Heading.Notifications.DesktopPush"
	/// English String: "Desktop Push"
	/// </summary>
	public override string HeadingNotificationsDesktopPush => "Desktop-Push-Benachrichtigung";

	/// <summary>
	/// Key: "Heading.Notifications.MobilePush"
	/// English String: "Mobile Push"
	/// </summary>
	public override string HeadingNotificationsMobilePush => "Mobilgerät-Push-Benachrichtigung";

	/// <summary>
	/// Key: "Heading.Notifications.Stream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationsStream => "Benachrichtigungs-Stream";

	/// <summary>
	/// Key: "Heading.NotificationStream"
	/// English String: "Notification Stream"
	/// </summary>
	public override string HeadingNotificationStream => "Benachrichtigungs-Stream";

	/// <summary>
	/// Key: "Heading.OtherSettings"
	/// English String: "Other Settings"
	/// </summary>
	public override string HeadingOtherSettings => "Weitere Einstellungen";

	/// <summary>
	/// Key: "Heading.PageTitle"
	/// English String: "My Settings"
	/// </summary>
	public override string HeadingPageTitle => "Meine Einstellungen";

	/// <summary>
	/// Key: "Heading.Personal"
	/// English String: "Personal"
	/// </summary>
	public override string HeadingPersonal => "Persönliches";

	/// <summary>
	/// Key: "Heading.Pin"
	/// English String: "Account PIN"
	/// </summary>
	public override string HeadingPin => "Konto-PIN";

	/// <summary>
	/// Key: "Heading.PrivacySettings"
	/// English String: "Privacy Settings"
	/// </summary>
	public override string HeadingPrivacySettings => "Datenschutzeinstellungen";

	/// <summary>
	/// Key: "Heading.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string HeadingRenevalDate => "Verlängerungsdatum";

	/// <summary>
	/// Key: "Heading.Restrictions"
	/// English String: "Account Restrictions"
	/// </summary>
	public override string HeadingRestrictions => "Kontoeinschränkungen";

	/// <summary>
	/// Key: "Heading.SecureSignOut"
	/// English String: "Secure Sign Out"
	/// </summary>
	public override string HeadingSecureSignOut => "Sicher abmelden";

	/// <summary>
	/// Key: "Heading.SocialNetworks"
	/// English String: "Social Networks"
	/// </summary>
	public override string HeadingSocialNetworks => "Soziale Netzwerke";

	/// <summary>
	/// Key: "Heading.SocialSignOn"
	/// English String: "Social Sign On"
	/// </summary>
	public override string HeadingSocialSignOn => "Über soziales Netzwerk anmelden";

	/// <summary>
	/// Key: "Heading.SuccessDialogTitle"
	/// English String: "Success"
	/// </summary>
	public override string HeadingSuccessDialogTitle => "Erfolg";

	/// <summary>
	/// Key: "Heading.Tab.AccountInfo"
	/// English String: "Account Info"
	/// </summary>
	public override string HeadingTabAccountInfo => "Kontodetails";

	/// <summary>
	/// Key: "Heading.Tab.Billing"
	/// English String: "Billing"
	/// </summary>
	public override string HeadingTabBilling => "Zahlungen";

	/// <summary>
	/// Key: "Heading.Tab.FastTrack"
	/// Fast Track is the name of the limited access community moderation program.
	/// English String: "Fast Track"
	/// </summary>
	public override string HeadingTabFastTrack => "Expressmeldung";

	/// <summary>
	/// Key: "Heading.Tab.Notifications"
	/// English String: "Notifications"
	/// </summary>
	public override string HeadingTabNotifications => "Benachrichtigungen";

	/// <summary>
	/// Key: "Heading.Tab.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string HeadingTabPrivacy => "Datenschutz";

	/// <summary>
	/// Key: "Heading.Tab.Security"
	/// English String: "Security"
	/// </summary>
	public override string HeadingTabSecurity => "Sicherheit";

	/// <summary>
	/// Key: "Heading.Transactions"
	/// English String: "Transactions"
	/// </summary>
	public override string HeadingTransactions => "Transaktionen";

	/// <summary>
	/// Key: "Heading.TwoStepVerification"
	/// English String: "2 Step Verification"
	/// </summary>
	public override string HeadingTwoStepVerification => "Verifizierung in 2 Schritten";

	/// <summary>
	/// Key: "Heading.Xbox"
	/// English String: "Xbox"
	/// </summary>
	public override string HeadingXbox => "Xbox";

	/// <summary>
	/// Key: "Label.AccountPinDisabled"
	/// English String: "Account PIN is currently disabled"
	/// </summary>
	public override string LabelAccountPinDisabled => "Konto-PIN ist derzeit deaktiviert";

	/// <summary>
	/// Key: "Label.AccountPinEnabled"
	/// English String: "Account PIN is currently enabled"
	/// </summary>
	public override string LabelAccountPinEnabled => "Konto-PIN ist derzeit aktiviert";

	/// <summary>
	/// Key: "Label.AccountRestrictionDisabled"
	/// English String: "Account Restrictions is currently disabled"
	/// </summary>
	public override string LabelAccountRestrictionDisabled => "Kontoeinschränkungen sind derzeit deaktiviert";

	/// <summary>
	/// Key: "Label.AccountRestrictionEnabled"
	/// English String: "Account Restrictions is currently enabled"
	/// </summary>
	public override string LabelAccountRestrictionEnabled => "Kontoeinschränkungen sind derzeit aktiviert";

	/// <summary>
	/// Key: "Label.AddEmail"
	/// English String: "Add Email"
	/// </summary>
	public override string LabelAddEmail => "E-Mail-Adresse hinzufügen";

	/// <summary>
	/// Key: "Label.AddEmailParent"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelAddEmailParent => "E-Mail-Adresse deiner Eltern";

	/// <summary>
	/// Key: "Label.AddPassword"
	/// English String: "Add Password:"
	/// </summary>
	public override string LabelAddPassword => "Passwort hinzufügen:";

	/// <summary>
	/// Key: "Label.AddPhone"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhone => "Handy hinzufügen";

	/// <summary>
	/// Key: "Label.AddPhoneLink"
	/// English String: "Add Phone"
	/// </summary>
	public override string LabelAddPhoneLink => "Handy hinzufügen";

	/// <summary>
	/// Key: "Label.BillingHelp"
	/// English String: "For billing and payment questions:"
	/// </summary>
	public override string LabelBillingHelp => "Für Fragen zu Zahlungen:";

	/// <summary>
	/// Key: "Label.BillingHistoryCost"
	/// English String: "Cost"
	/// </summary>
	public override string LabelBillingHistoryCost => "Preis";

	/// <summary>
	/// Key: "Label.BillingHistoryDate"
	/// English String: "Date"
	/// </summary>
	public override string LabelBillingHistoryDate => "Datum";

	/// <summary>
	/// Key: "Label.BillingHistoryDescription"
	/// English String: "Description"
	/// </summary>
	public override string LabelBillingHistoryDescription => "Beschreibung";

	/// <summary>
	/// Key: "Label.BillingHistoryGeneralErrors"
	/// error message
	/// English String: "Service is currently disabled, please try again later."
	/// </summary>
	public override string LabelBillingHistoryGeneralErrors => "Dienst ist derzeit deaktiviert. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Label.BillingHistoryNoTransactions"
	/// English String: "No Transactions"
	/// </summary>
	public override string LabelBillingHistoryNoTransactions => "Keine Transaktionen";

	/// <summary>
	/// Key: "Label.BillingHistoryPaymentType"
	/// English String: "Payment Type"
	/// </summary>
	public override string LabelBillingHistoryPaymentType => "Bezahlungsart";

	/// <summary>
	/// Key: "Label.Birthday"
	/// English String: "Birthday"
	/// </summary>
	public override string LabelBirthday => "Geburtstag";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.ChangeYourUsername"
	/// English String: "change your username"
	/// </summary>
	public override string LabelChangeYourUsername => "Ändere deinen Benutzernamen";

	/// <summary>
	/// Key: "Label.ChooseLanguage"
	/// English String: "Choose Language"
	/// </summary>
	public override string LabelChooseLanguage => "Sprache wählen";

	/// <summary>
	/// Key: "Label.ClassicTheme"
	/// name of Theme, classic theme
	/// English String: "Off"
	/// </summary>
	public override string LabelClassicTheme => "Aus";

	/// <summary>
	/// Key: "Label.ConnectAccount"
	/// English String: "Connect account:"
	/// </summary>
	public override string LabelConnectAccount => "Konto verbinden:";

	/// <summary>
	/// Key: "Label.Country"
	/// English String: "Choose a Country/Region"
	/// </summary>
	public override string LabelCountry => "Land/Region wählen";

	/// <summary>
	/// Key: "Label.CountryTitle"
	/// label for country on account settings page
	/// English String: "Location"
	/// </summary>
	public override string LabelCountryTitle => "Standort";

	/// <summary>
	/// Key: "Label.DarkTheme"
	/// Dark Theme
	/// English String: "Dark"
	/// </summary>
	public override string LabelDarkTheme => "Dunkel";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailOver13"
	/// English String: "Add My Email"
	/// </summary>
	public override string LabelDialogAddEmailOver13 => "Meine E-Mail-Adresse hinzufügen";

	/// <summary>
	/// Key: "Label.Dialog.AddEmailUnder13"
	/// English String: "Add Parent's Email"
	/// </summary>
	public override string LabelDialogAddEmailUnder13 => "E-Mail-Adresse deiner Eltern hinzufügen";

	/// <summary>
	/// Key: "Label.Dialog.AddPhoneField"
	/// English String: "Phone Number"
	/// </summary>
	public override string LabelDialogAddPhoneField => "Handynummer";

	/// <summary>
	/// Key: "Label.Dialog.AddPhonePassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogAddPhonePassword => "Kontopasswort verifizieren";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailField"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailField => "Meine E-Mail-Adresse ändern";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailOver13"
	/// English String: "Change My Email"
	/// </summary>
	public override string LabelDialogChangeEmailOver13 => "Meine E-Mail-Adresse ändern";

	/// <summary>
	/// Key: "Label.Dialog.ChangeEmailUnder13"
	/// English String: "Change Parent's Email"
	/// </summary>
	public override string LabelDialogChangeEmailUnder13 => "E-Mail-Adresse deiner Eltern ändern";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordConfirm"
	/// English String: "Confirm Password"
	/// </summary>
	public override string LabelDialogChangePasswordConfirm => "Passwort bestätigen";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordCurrent"
	/// English String: "Current Password"
	/// </summary>
	public override string LabelDialogChangePasswordCurrent => "Aktuelles Passwort";

	/// <summary>
	/// Key: "Label.Dialog.ChangePasswordNew"
	/// English String: "New Password"
	/// </summary>
	public override string LabelDialogChangePasswordNew => "Neues Passwort";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameAccountPassword"
	/// English String: "Account Password"
	/// </summary>
	public override string LabelDialogChangeUsernameAccountPassword => "Kontopasswort";

	/// <summary>
	/// Key: "Label.Dialog.ChangeUsernameField"
	/// English String: "Desired Username (3-20 characters)"
	/// </summary>
	public override string LabelDialogChangeUsernameField => "Gewünschter Benutzername (3-20 Zeichen)";

	/// <summary>
	/// Key: "Label.Dialog.ConfirmPin"
	/// English String: "Confirm your PIN"
	/// </summary>
	public override string LabelDialogConfirmPin => "Bestätige deine PIN";

	/// <summary>
	/// Key: "Label.Dialog.EditPhoneCurrentNumber"
	/// English String: "Current Number:"
	/// </summary>
	public override string LabelDialogEditPhoneCurrentNumber => "Aktuelle Nummer:";

	/// <summary>
	/// Key: "Label.Dialog.EmailAddressChanged"
	/// English String: "Email Address Changed"
	/// </summary>
	public override string LabelDialogEmailAddressChanged => "E-Mail-Adresse geändert";

	/// <summary>
	/// Key: "Label.Dialog.EmailRequired"
	/// English String: "Email Required"
	/// </summary>
	public override string LabelDialogEmailRequired => "E-Mail-Adresse erforderlich";

	/// <summary>
	/// Key: "Label.Dialog.VerifiedEmail"
	/// English String: "Verified email:"
	/// </summary>
	public override string LabelDialogVerifiedEmail => "Verifizierte E-Mail-Adresse:";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPassword"
	/// English String: "Verify Account Password"
	/// </summary>
	public override string LabelDialogVerifyPassword => "Kontopasswort verifizieren";

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCodeLabel"
	/// English String: "Enter the code we just sent to your phone"
	/// </summary>
	public override string LabelDialogVerifyPhoneCodeLabel => "Gib den Code ein, den wir dir gerade an dein Handy geschickt haben.";

	/// <summary>
	/// Key: "Label.Dialog.VerifySms"
	/// English String: "Verify SMS"
	/// </summary>
	public override string LabelDialogVerifySms => "SMS verifizieren";

	/// <summary>
	/// Key: "Label.DropDown.Custom"
	/// English String: "Custom"
	/// </summary>
	public override string LabelDropDownCustom => "Benutzerdefiniert";

	/// <summary>
	/// Key: "Label.DropDown.Default"
	/// English String: "Default"
	/// </summary>
	public override string LabelDropDownDefault => "Standard";

	/// <summary>
	/// Key: "Label.DropDown.Everyone"
	/// English String: "Everyone"
	/// </summary>
	public override string LabelDropDownEveryone => "Jeder";

	/// <summary>
	/// Key: "Label.DropDown.Followers"
	/// English String: "Friends, Users I Follow, and Followers"
	/// </summary>
	public override string LabelDropDownFollowers => "Freunde, Benutzer, denen ich folge, sowie Follower";

	/// <summary>
	/// Key: "Label.DropDown.Following"
	/// English String: "Friends and Users I Follow"
	/// </summary>
	public override string LabelDropDownFollowing => "Freunde sowie Benutzer, denen ich folge";

	/// <summary>
	/// Key: "Label.DropDown.Friends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelDropDownFriends => "Freunde";

	/// <summary>
	/// Key: "Label.DropDown.High"
	/// English String: "High"
	/// </summary>
	public override string LabelDropDownHigh => "Hoch";

	/// <summary>
	/// Key: "Label.DropDown.Low"
	/// English String: "Low"
	/// </summary>
	public override string LabelDropDownLow => "Niedrig";

	/// <summary>
	/// Key: "Label.DropDown.Medium"
	/// English String: "Medium"
	/// </summary>
	public override string LabelDropDownMedium => "Mittel";

	/// <summary>
	/// Key: "Label.DropDown.None"
	/// English String: "None"
	/// </summary>
	public override string LabelDropDownNone => "Keine Auswahl";

	/// <summary>
	/// Key: "Label.DropDown.NoOne"
	/// English String: "No one"
	/// </summary>
	public override string LabelDropDownNoOne => "Niemand";

	/// <summary>
	/// Key: "Label.DropDown.Off"
	/// English String: "Off"
	/// </summary>
	public override string LabelDropDownOff => "Aus";

	/// <summary>
	/// Key: "Label.Email"
	/// English String: "Email address:"
	/// </summary>
	public override string LabelEmail => "E-Mail-Adresse:";

	/// <summary>
	/// Key: "Label.EmailParent"
	/// English String: "Parent's Email address:"
	/// </summary>
	public override string LabelEmailParent => "E-Mail-Adresse deiner Eltern:";

	/// <summary>
	/// Key: "Label.EmailVerificationPending"
	/// English String: "Pending verification"
	/// </summary>
	public override string LabelEmailVerificationPending => "Verifizierung steht noch aus";

	/// <summary>
	/// Key: "Label.ExpirationDate"
	/// English String: "Expiration date"
	/// </summary>
	public override string LabelExpirationDate => "Ablaufdatum";

	/// <summary>
	/// Key: "Label.Facebook"
	/// English String: "Facebook:"
	/// </summary>
	public override string LabelFacebook => "Facebook:";

	/// <summary>
	/// Key: "Label.FastTrack.Accuracy"
	/// A label above a report of the Fast Track member's reporting accuracy compared to other Fast Track members.
	/// English String: "Accuracy"
	/// </summary>
	public override string LabelFastTrackAccuracy => "Genauigkeit";

	/// <summary>
	/// Key: "Label.FastTrack.AllFastTrackMembers"
	/// The group of Roblox community members who are part of the Fast Track Member Role. These users, together, represent some of our most useful community reporters and their reports are given special attention.
	/// English String: "Everyone"
	/// </summary>
	public override string LabelFastTrackAllFastTrackMembers => "Jeder";

	/// <summary>
	/// Key: "Label.FastTrack.ReportMonth"
	/// A label for a column in a report that indicates that the column will contain months. For example "January" or "March".
	/// English String: "Month"
	/// </summary>
	public override string LabelFastTrackReportMonth => "Monat";

	/// <summary>
	/// Key: "Label.FastTrack.ReportYear"
	/// A label used as a column header in a report table. This column contains "years". These will be localized. Examples for en-us "2015" and "2020"
	/// English String: "Year"
	/// </summary>
	public override string LabelFastTrackReportYear => "Jahr";

	/// <summary>
	/// Key: "Label.FastTrack.Statistics"
	/// Title of a section of the Fast Track member page that includes reporting and statistical data.
	/// English String: "Statistics"
	/// </summary>
	public override string LabelFastTrackStatistics => "Statistiken";

	/// <summary>
	/// Key: "Label.FastTrack.You"
	/// Pronoun for the current user, who in this context is a Fast Track member. The usage here is intended to be as a heading for a column in a table.
	/// English String: "You"
	/// </summary>
	public override string LabelFastTrackYou => "Du";

	/// <summary>
	/// Key: "Label.Gender"
	/// English String: "Gender"
	/// </summary>
	public override string LabelGender => "Geschlecht";

	/// <summary>
	/// Key: "Label.GooglePlus"
	/// English String: "Google+:"
	/// </summary>
	public override string LabelGooglePlus => "Google+:";

	/// <summary>
	/// Key: "Label.LightTheme"
	/// Light Theme
	/// English String: "Light"
	/// </summary>
	public override string LabelLightTheme => "Hell";

	/// <summary>
	/// Key: "Label.LocaleTitle"
	/// text label for locale select on account setting's page
	/// English String: "Language"
	/// </summary>
	public override string LabelLocaleTitle => "Sprache";

	/// <summary>
	/// Key: "Label.MembershipStatusRobloxPremium"
	/// English String: "You're not a member yet. Join Roblox Premium today!"
	/// </summary>
	public override string LabelMembershipStatusRobloxPremium => "Du bist noch kein Mitglied. Tritt Roblox-Premium heute bei!";

	/// <summary>
	/// Key: "Label.Notifications.AddedToPrivateServer"
	/// English String: "I am invited to a VIP server"
	/// </summary>
	public override string LabelNotificationsAddedToPrivateServer => "Ich auf einen VIP-Server eingeladen werde";

	/// <summary>
	/// Key: "Label.Notifications.Chat"
	/// English String: "Someone chats with me"
	/// </summary>
	public override string LabelNotificationsChat => "Jemand mit mir chattet";

	/// <summary>
	/// Key: "Label.Notifications.ConversationUniverseChanged"
	/// label for notification settings
	/// English String: "Someone pins a new game to play together"
	/// </summary>
	public override string LabelNotificationsConversationUniverseChanged => "Jemand ein neues Spiel zum gemeinsamen Spielen anheftet";

	/// <summary>
	/// Key: "Label.Notifications.DeveloperMetricsAvailable"
	/// English String: "Analytics report becomes available"
	/// </summary>
	public override string LabelNotificationsDeveloperMetricsAvailable => "Analysebericht wird verfügbar";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestAccepted"
	/// English String: "Someone accepts my friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestAccepted => "Jemand meine Freundesanfrage annimmt";

	/// <summary>
	/// Key: "Label.Notifications.FriendRequestReceived"
	/// English String: "I receive a friend request"
	/// </summary>
	public override string LabelNotificationsFriendRequestReceived => "Ich eine Freundesanfrage erhalte";

	/// <summary>
	/// Key: "Label.Notifications.GameUpdate"
	/// Checkbox label for enabling game update notifications in the notification stream
	/// English String: "I receive update notifications"
	/// </summary>
	public override string LabelNotificationsGameUpdate => "Benachrichtigungen über Updates erhalten";

	/// <summary>
	/// Key: "Label.Notifications.PartyInvited"
	/// English String: "Someone invites me to a party"
	/// </summary>
	public override string LabelNotificationsPartyInvited => "Jemand mich in ein Team einlädt";

	/// <summary>
	/// Key: "Label.Notifications.PartyJoined"
	/// English String: "Someone joins a party I'm in"
	/// </summary>
	public override string LabelNotificationsPartyJoined => "Jemand einem Team beitritt, in dem ich bin";

	/// <summary>
	/// Key: "Label.Notifications.PrivateMessage"
	/// English String: "I receive a private message"
	/// </summary>
	public override string LabelNotificationsPrivateMessage => "Ich eine private Nachricht erhalte";

	/// <summary>
	/// Key: "Label.Notifications.TeamCreateInvite"
	/// English String: "Someone invites me to edit a game"
	/// </summary>
	public override string LabelNotificationsTeamCreateInvite => "Jemand mich zum Bearbeiten eines Spiels einlädt";

	/// <summary>
	/// Key: "Label.Password"
	/// English String: "Password:"
	/// </summary>
	public override string LabelPassword => "Passwort:";

	/// <summary>
	/// Key: "Label.Phone"
	/// English String: "Phone Number:"
	/// </summary>
	public override string LabelPhone => "Handynummer:";

	/// <summary>
	/// Key: "Label.PinTimeMins"
	/// English String: "min"
	/// </summary>
	public override string LabelPinTimeMins => "Min.";

	/// <summary>
	/// Key: "Label.PinTimeRemaining"
	/// English String: "Time Remaining"
	/// </summary>
	public override string LabelPinTimeRemaining => "Verbleibende Zeit";

	/// <summary>
	/// Key: "Label.PinTimeSecs"
	/// English String: "sec"
	/// </summary>
	public override string LabelPinTimeSecs => "Sek.";

	/// <summary>
	/// Key: "Label.PreviousUsernames"
	/// English String: "Previous usernames:"
	/// </summary>
	public override string LabelPreviousUsernames => "Vorherige Benutzernamen:";

	/// <summary>
	/// Key: "Label.PrivacyMode"
	/// English String: "Privacy Mode"
	/// </summary>
	public override string LabelPrivacyMode => "Datenschutzmodus";

	/// <summary>
	/// Key: "Label.RenevalDate"
	/// English String: "Renewal date"
	/// </summary>
	public override string LabelRenevalDate => "Verlängerungsdatum";

	/// <summary>
	/// Key: "Label.SignOutAllSessions"
	/// English String: "Sign out of all other sessions"
	/// </summary>
	public override string LabelSignOutAllSessions => "Von allen anderen Sitzungen abmelden";

	/// <summary>
	/// Key: "Label.SocialLinksVisibility"
	/// English String: "Visible to:"
	/// </summary>
	public override string LabelSocialLinksVisibility => "Wer kann mich sehen?";

	/// <summary>
	/// Key: "Label.ThemeTitle"
	/// English String: "Theme"
	/// </summary>
	public override string LabelThemeTitle => "Thema";

	/// <summary>
	/// Key: "Label.ToolTip.ContactSettings"
	/// English String: "Custom - Control your own settings. Default - Enable chat and messages with Friends. Off - Disables chat and messages."
	/// </summary>
	public override string LabelToolTipContactSettings => "Benutzerdefiniert\u00a0– Lege deine Einstellungen selbst fest. Standard\u00a0– Ermöglicht Chats und Nachrichten mit Freunden. Aus\u00a0– Deaktiviert Chats und Nachrichten.";

	/// <summary>
	/// Key: "Label.ToolTip.PinLocked"
	/// English String: "All settings are locked. To edit, please unlock with your PIN"
	/// </summary>
	public override string LabelToolTipPinLocked => "Alle Einstellungen sind gesperrt. Entsperre sie mit deiner PIN, um sie zu bearbeiten.";

	/// <summary>
	/// Key: "Label.ToolTip.PinUnlocked"
	/// English String: "Click to lock your Settings page"
	/// </summary>
	public override string LabelToolTipPinUnlocked => "Klicke, um deine Einstellungsseite zu sperren";

	/// <summary>
	/// Key: "Label.ToolTip.PrivacyMode"
	/// English String: "Click here for more information"
	/// </summary>
	public override string LabelToolTipPrivacyMode => "Klicke hier für weitere Infos";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInApp"
	/// English String: "This setting controls who this user will be allowed to chat with in the app and on the web (separate from in game). The setting also prevents this user from posting on Forums and group walls."
	/// </summary>
	public override string LabelToolTipWhoCanChatInApp => "Diese Einstellung bestimmt, mit wem dieser Benutzer in der App und im Internet (nicht im Spiel selbst) chatten darf. Mit dieser Einstellung wird zudem verhindert, dass dieser Benutzer in Foren und auf Gruppenpinnwänden posten kann.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanChatInGame"
	/// English String: "This setting controls who this user will be allowed to chat with in game."
	/// </summary>
	public override string LabelToolTipWhoCanChatInGame => "Diese Einstellung bestimmt, mit wem dieser Benutzer im Spiel chatten darf.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanFindMeByPhone"
	/// This setting controls who can find you using the phone number you provided.
	/// English String: "This setting controls who can find you using the phone number you provided."
	/// </summary>
	public override string LabelToolTipWhoCanFindMeByPhone => "Mit dieser Einstellung kannst du festlegen, wer dich über die von dir angegebene Handynummer finden kann.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanInviteVIP"
	/// English String: "This setting controls who can join this user in VIP servers - servers that can only be joined by invitation of the server owner."
	/// </summary>
	public override string LabelToolTipWhoCanInviteVIP => "Diese Einstellung bestimmt, wer mit diesem Benutzer auf VIP-Servern spielen darf. Diese Server können nur über eine Einladung des Serverbesitzers betreten werden.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanJoinGame"
	/// English String: "This setting controls who can see which game I'm in and join me in my server. Selecting no one means no one can follow me into my specific server, but I will be playing with other users."
	/// </summary>
	public override string LabelToolTipWhoCanJoinGame => "Diese Einstellung bestimmt, wer sehen kann, in welchem Spiel ich mich befinde und wer meinen Server betreten darf. Wenn ich „Niemand“ auswähle, bedeutet dies, dass mir niemand auf den von mir festgelegten Server folgen kann. Ich kann jedoch mit anderen Benutzern spielen.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanMessageMe"
	/// English String: "This setting controls who this user can receive messages from in their messages inbox."
	/// </summary>
	public override string LabelToolTipWhoCanMessageMe => "Diese Einstellung bestimmt, von wem dieser Benutzer Nachrichten in seinem Posteingang erhalten kann.";

	/// <summary>
	/// Key: "Label.ToolTip.WhoCanSeeInventory"
	/// English String: "This setting controls who can see your inventory."
	/// </summary>
	public override string LabelToolTipWhoCanSeeInventory => "Diese Einstellung bestimmt, wer dein Inventar sehen kann.";

	/// <summary>
	/// Key: "Label.TradeFilter"
	/// English String: "Trade quality filter"
	/// </summary>
	public override string LabelTradeFilter => "Filter für Handelsqualität";

	/// <summary>
	/// Key: "Label.Twitch"
	/// English String: "Twitch"
	/// </summary>
	public override string LabelTwitch => "Twitch";

	/// <summary>
	/// Key: "Label.Twitter"
	/// English String: "Twitter:"
	/// </summary>
	public override string LabelTwitter => "Twitter:";

	/// <summary>
	/// Key: "Label.TwoStepEmail"
	/// English String: "enable 2 Step Verification"
	/// </summary>
	public override string LabelTwoStepEmail => "Verifizierung in 2 Schritten aktivieren";

	/// <summary>
	/// Key: "Label.TwoStepPrerequisite"
	/// English String: "A verified email is required."
	/// </summary>
	public override string LabelTwoStepPrerequisite => "Eine verifizierte E-Mail-Adresse ist erforderlich.";

	/// <summary>
	/// Key: "Label.TwoStepVerification"
	/// English String: "Improve your account security. A code will be required when you login from a new device."
	/// </summary>
	public override string LabelTwoStepVerification => "Mach dein Konto sicherer. Wenn du dich von einem neuen Gerät aus anmeldest, benötigst du einen Code.";

	/// <summary>
	/// Key: "Label.TwoStepVerificationEnabled"
	/// English String: "Your account is protected!"
	/// </summary>
	public override string LabelTwoStepVerificationEnabled => "Dein Konto ist geschützt!";

	/// <summary>
	/// Key: "Label.UpdateEmail"
	/// English String: "Update Email"
	/// </summary>
	public override string LabelUpdateEmail => "E-Mail-Adresse aktualisieren";

	/// <summary>
	/// Key: "Label.UpdatePhone"
	/// English String: "Update Phone"
	/// </summary>
	public override string LabelUpdatePhone => "Handy aktualisieren";

	/// <summary>
	/// Key: "Label.UseDeviceLanguage"
	/// Allow user to use device language
	/// English String: "Use Device Language"
	/// </summary>
	public override string LabelUseDeviceLanguage => "Gerätesprache verwenden";

	/// <summary>
	/// Key: "Label.Username"
	/// English String: "Username:"
	/// </summary>
	public override string LabelUsername => "Benutzername:";

	/// <summary>
	/// Key: "Label.Verified"
	/// English String: "Verified"
	/// </summary>
	public override string LabelVerified => "Verifiziert";

	/// <summary>
	/// Key: "Label.Verify"
	/// English String: "Verify"
	/// </summary>
	public override string LabelVerify => "Verifizieren";

	/// <summary>
	/// Key: "Label.WhoCanChatInApp"
	/// English String: "Who can chat with me in app?"
	/// </summary>
	public override string LabelWhoCanChatInApp => "Wer kann in der App mit mir chatten?";

	/// <summary>
	/// Key: "Label.WhoCanChatInGame"
	/// English String: "Who can chat with me?"
	/// </summary>
	public override string LabelWhoCanChatInGame => "Wer kann mit mir chatten?";

	/// <summary>
	/// Key: "Label.WhoCanFindMeByPhone"
	/// Who can find me by my phone number?
	/// English String: "Who can find me by my phone number?"
	/// </summary>
	public override string LabelWhoCanFindMeByPhone => "Wer kann mich über meine Handynummer finden?";

	/// <summary>
	/// Key: "Label.WhoCanInviteVIP"
	/// English String: "Who can invite me to VIP Servers?"
	/// </summary>
	public override string LabelWhoCanInviteVIP => "Wer kann mich auf VIP-Server einladen?";

	/// <summary>
	/// Key: "Label.WhoCanJoinGame"
	/// English String: "Who can join me?"
	/// </summary>
	public override string LabelWhoCanJoinGame => "Wer kann mitmachen?";

	/// <summary>
	/// Key: "Label.WhoCanMessageMe"
	/// English String: "Who can message me?"
	/// </summary>
	public override string LabelWhoCanMessageMe => "Wer kann mir Nachrichten schreiben?";

	/// <summary>
	/// Key: "Label.WhoCanSeeInventory"
	/// This setting controls who can see the user's inventory.
	/// English String: "Who can see my inventory?"
	/// </summary>
	public override string LabelWhoCanSeeInventory => "Wer kann mein Inventar sehen?";

	/// <summary>
	/// Key: "Label.WhoCanTradeWithMe"
	/// English String: "Who can trade with me?"
	/// </summary>
	public override string LabelWhoCanTradeWithMe => "Wer kann mit mir handeln?";

	/// <summary>
	/// Key: "Label.XboxConnected"
	/// English String: "Connected with an Xbox account"
	/// </summary>
	public override string LabelXboxConnected => "Mit einem Xbox-Konto verbunden";

	/// <summary>
	/// Key: "Label.YouTube"
	/// English String: "YouTube:"
	/// </summary>
	public override string LabelYouTube => "YouTube:";

	/// <summary>
	/// Key: "LabelInsufficientRobux"
	/// English String: "Insufficient Robux"
	/// </summary>
	public override string LabelInsufficientRobux => "Nicht genügend Robux";

	/// <summary>
	/// Key: "Message.Error.AccountHasPin"
	/// English String: "The account already has a PIN. Try making a different request."
	/// </summary>
	public override string MessageErrorAccountHasPin => "Das Konto hat bereits eine PIN. Versuche eine andere Anfrage zu stellen.";

	/// <summary>
	/// Key: "Message.Error.AccountLocked"
	/// English String: "The account is locked. Unlock the acount before performing the action."
	/// </summary>
	public override string MessageErrorAccountLocked => "Das Konto ist gesperrt. Entsperre das Konto, bevor du die Handlung durchführst.";

	/// <summary>
	/// Key: "Message.Error.Default"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string MessageErrorDefault => "Ein Problem ist aufgetreten. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Message.Error.Email.AlreadyVerified"
	/// English String: "The email is already verified."
	/// </summary>
	public override string MessageErrorEmailAlreadyVerified => "Diese E-Mail-Adresse ist bereits verifiziert.";

	/// <summary>
	/// Key: "Message.Error.Email.FeatureDisabled"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageErrorEmailFeatureDisabled => "Dieses Feature ist zur Zeit deaktiviert. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Message.Error.Email.IncorrectPassword"
	/// English String: "Password is incorrect."
	/// </summary>
	public override string MessageErrorEmailIncorrectPassword => "Passwort ist falsch.";

	/// <summary>
	/// Key: "Message.Error.Email.InvalidEmail"
	/// English String: "Invalid email address."
	/// </summary>
	public override string MessageErrorEmailInvalidEmail => "Ungültige E-Mail-Adresse.";

	/// <summary>
	/// Key: "Message.Error.Email.NoEmailAssociated"
	/// English String: "No email address is associated with the account."
	/// </summary>
	public override string MessageErrorEmailNoEmailAssociated => "Diesem Konto ist keine E-Mail-Adresse zugeordnet.";

	/// <summary>
	/// Key: "Message.Error.Email.PinLocked"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessageErrorEmailPinLocked => "PIN ist gesperrt.";

	/// <summary>
	/// Key: "Message.Error.Email.SameEmail"
	/// English String: "This is already the current email."
	/// </summary>
	public override string MessageErrorEmailSameEmail => "Dies ist bereits die aktuelle E-Mail-Adresse.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyAccounts"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageErrorEmailTooManyAccounts => "Dieser E-Mail-Adresse sind zu viele Konten zugeordnet.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyUpdates"
	/// English String: "Too many attempts to update email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyUpdates => "Zu viele Versuche, die E-Mail-Adresse zu aktualisieren. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Message.Error.Email.TooManyVerify"
	/// English String: "Too many attempts to send verification email. Please try again later."
	/// </summary>
	public override string MessageErrorEmailTooManyVerify => "Zu viele Versuche, die E-Mail zur Verifizierung zu senden. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Message.Error.Email.Unknown"
	/// English String: "An unknown error occured."
	/// </summary>
	public override string MessageErrorEmailUnknown => "Ein unbekannter Fehler ist aufgetreten.";

	/// <summary>
	/// Key: "Message.Error.IncorrectPin"
	/// English String: "Incorrect PIN."
	/// </summary>
	public override string MessageErrorIncorrectPin => "Falsche PIN.";

	/// <summary>
	/// Key: "Message.Error.InvalidPinFormat"
	/// English String: "Invalid PIN format."
	/// </summary>
	public override string MessageErrorInvalidPinFormat => "Ungültiges PIN-Format.";

	/// <summary>
	/// Key: "Message.Error.NoPin"
	/// English String: "No PIN exists on the account."
	/// </summary>
	public override string MessageErrorNoPin => "Für das Konto existiert keine PIN.";

	/// <summary>
	/// Key: "Message.Error.NoVerifiedEmail"
	/// English String: "The account does not have a verified email."
	/// </summary>
	public override string MessageErrorNoVerifiedEmail => "Das Konto hat keine verifizierte E-Mail-Adresse.";

	/// <summary>
	/// Key: "Message.Error.System"
	/// English String: "System error."
	/// </summary>
	public override string MessageErrorSystem => "Systemfehler.";

	/// <summary>
	/// Key: "Message.Error.TooManyRequests"
	/// English String: "Too many requests made. Try again later."
	/// </summary>
	public override string MessageErrorTooManyRequests => "Zu viele Anfragen gestellt. Versuche es später erneut.";

	/// <summary>
	/// Key: "MessageEmailAddSuccess"
	/// English String: "Email Added"
	/// </summary>
	public override string MessageEmailAddSuccess => "E-Mail-Adresse hinzugefügt";

	/// <summary>
	/// Key: "MessageEmailAlreadyVerifiedError"
	/// English String: "Your email is already verified!"
	/// </summary>
	public override string MessageEmailAlreadyVerifiedError => "Deine E-Mail-Adresse wurde bereits verifiziert!";

	/// <summary>
	/// Key: "MessageFeatureDisabledError"
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string MessageFeatureDisabledError => "Dieses Feature ist derzeit deaktiviert. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "MessageInsufficientRobuxErrorForUserName"
	/// You don't have enough Robux to change your username.
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessageInsufficientRobuxErrorForUserName => "Du hast nicht genügend Robux, um deinen Benutzernamen zu ändern.";

	/// <summary>
	/// Key: "MessageInvalidEmail"
	/// English String: "Invalid Email"
	/// </summary>
	public override string MessageInvalidEmail => "Ungültige E-Mail-Adresse";

	/// <summary>
	/// Key: "MessageNoEmailAssociatedError"
	/// English String: "You must associate an email address with your account"
	/// </summary>
	public override string MessageNoEmailAssociatedError => "Du musst deinem Konto eine E-Mail-Adresse zuordnen.";

	/// <summary>
	/// Key: "MessagePermissionError"
	/// English String: "You don't have enough Robux to change your username."
	/// </summary>
	public override string MessagePermissionError => "Du hast nicht genügend Robux, um deinen Benutzernamen zu ändern.";

	/// <summary>
	/// Key: "MessagePinLockedError"
	/// English String: "PIN is locked."
	/// </summary>
	public override string MessagePinLockedError => "PIN ist gesperrt.";

	/// <summary>
	/// Key: "MessageSameEmailError"
	/// English String: "This is already the current verified email."
	/// </summary>
	public override string MessageSameEmailError => "Dies ist bereits die aktuelle, verifizierte E-Mail-Adresse.";

	/// <summary>
	/// Key: "MessageSettingsUpdateSuccess"
	/// English String: "Your settings have been updated."
	/// </summary>
	public override string MessageSettingsUpdateSuccess => "Deine Einstellungen wurden aktualisiert.";

	/// <summary>
	/// Key: "MessageTooManyAccountsOnEmailError"
	/// English String: "There are too many accounts associated with this email address."
	/// </summary>
	public override string MessageTooManyAccountsOnEmailError => "Dieser E-Mail-Adresse sind zu viele Konten zugeordnet.";

	/// <summary>
	/// Key: "MessageTooManyAttemptsError"
	/// English String: "Too many attempts. Please try again later."
	/// </summary>
	public override string MessageTooManyAttemptsError => "Zu viele Versuche. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "MessageUnknownError"
	/// English String: "An unknown error occurred."
	/// </summary>
	public override string MessageUnknownError => "Ein unbekannter Fehler ist aufgetreten.";

	/// <summary>
	/// Key: "MessageWrongPassword"
	/// English String: "Your password is incorrect."
	/// </summary>
	public override string MessageWrongPassword => "Dein Passwort ist falsch.";

	/// <summary>
	/// Key: "Respones.InvalidCodePhone"
	/// error message
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponesInvalidCodePhone => "Code ist ungültig. Bitte überprüfe dein Handy und versuche es erneut.";

	/// <summary>
	/// Key: "Respones.InventoryAndTradePrivacyConflictError"
	/// English String: "The value for \"Who can trade with me\" should be the same or more restrictive than the value for \"Who can see my inventory\"."
	/// </summary>
	public override string ResponesInventoryAndTradePrivacyConflictError => "Der Wert bei „Wer kann mit mir handeln“ sollte im gleichen Maße oder eingeschränkter sein, als der Wert bei „Wer kann mein Inventar sehen“.";

	/// <summary>
	/// Key: "Response.CodeRequired"
	/// error message
	/// English String: "A code is required. Please enter your code."
	/// </summary>
	public override string ResponseCodeRequired => "Ein Code ist erforderlich. Bitte gib deinen Code ein.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeDefaultWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Are you sure you want to continue?"
	/// </summary>
	public override string ResponseDialogBirthdayChangeDefaultWarning => "Wenn du dein Alter auf unter 13 Jahre änderst, kannst du das nicht mehr rückgängig machen. Möchtest du wirklich fortfahren?";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordBody"
	/// English String: "You must add a password to your Roblox account to change your birthday."
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordBody => "Du musst ein Passwort zu deinem Roblox-Konto hinzufügen, um deinen Geburtstag ändern zu können.";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangePasswordTitle"
	/// English String: "Must Add Password"
	/// </summary>
	public override string ResponseDialogBirthdayChangePasswordTitle => "Passwort muss hinzugefügt werden";

	/// <summary>
	/// Key: "Response.Dialog.BirthdayChangeSocialWarning"
	/// English String: "Changing your birthday to under age 13 cannot be un-done. Your Social Sign On from Facebook will be disabled and you will need to sign on using your Roblox password."
	/// </summary>
	public override string ResponseDialogBirthdayChangeSocialWarning => "Wenn du dein Alter auf unter 13 Jahre änderst, kannst du das nicht mehr rückgängig machen. Deine Anmeldung über das soziale Netzwerk Facebook wird deaktiviert und du musst dich mit deinem Roblox-Passwort anmelden.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordIncorrectPassword"
	/// Your current password is incorrect, the password was not changed.
	/// English String: "Your current password is incorrect, the password was not changed."
	/// </summary>
	public override string ResponseDialogChangePasswordIncorrectPassword => "Dein aktuelles Passwort ist falsch, das Passwort wurde nicht geändert.";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordNoMatch"
	/// English String: "Passwords do not match"
	/// </summary>
	public override string ResponseDialogChangePasswordNoMatch => "Passwörter stimmen nicht überein";

	/// <summary>
	/// Key: "Response.Dialog.ChangePasswordTooShortError"
	/// English String: "Must be at least 8 characters long"
	/// </summary>
	public override string ResponseDialogChangePasswordTooShortError => "Muss mindestens 8 Zeichen lang sein";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNoInput"
	/// English String: "Please enter a username."
	/// </summary>
	public override string ResponseDialogChangeUsernameNoInput => "Bitte gib einen Benutzernamen ein.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAllowed"
	/// error message
	/// English String: "Username not appropriate for Roblox."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAllowed => "Der Benutzername ist nicht geeignet für Roblox.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameNotAvailable"
	/// English String: "This username is already in use."
	/// </summary>
	public override string ResponseDialogChangeUsernameNotAvailable => "Dieser Benutzername wird bereits verwendet.";

	/// <summary>
	/// Key: "Response.Dialog.ChangeUsernameSuccess"
	/// success message
	/// English String: "Successfully changed username."
	/// </summary>
	public override string ResponseDialogChangeUsernameSuccess => "Benutzername wurde erfolgreich geändert.";

	/// <summary>
	/// Key: "Response.Dialog.CountryListError"
	/// English String: "Error loading country list"
	/// </summary>
	public override string ResponseDialogCountryListError => "Fehler beim Laden der Länderliste";

	/// <summary>
	/// Key: "Response.Dialog.CurrencyServiceError"
	/// English String: "There was an error with the currency service. Try again later."
	/// </summary>
	public override string ResponseDialogCurrencyServiceError => "Beim Währungssystem ist ein Fehler aufgetreten. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorMessage"
	/// English String: "Something went wrong, please try again later."
	/// </summary>
	public override string ResponseDialogDefaultErrorMessage => "Etwas ist schiefgelaufen. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Dialog.DefaultErrorTitle"
	/// English String: "Error occured"
	/// </summary>
	public override string ResponseDialogDefaultErrorTitle => "Fehler aufgetreten";

	/// <summary>
	/// Key: "Response.Dialog.DefaultSuccessMessage"
	/// English String: "Saved Successfully!"
	/// </summary>
	public override string ResponseDialogDefaultSuccessMessage => "Erfolgreich gespeichert!";

	/// <summary>
	/// Key: "Response.Dialog.DisconnectXBoxError"
	/// English String: "There was an error disconnecting your Xbox account, please try again later."
	/// </summary>
	public override string ResponseDialogDisconnectXBoxError => "Beim Aufheben der Verbindung zu deinem Xbox-Konto ist ein Fehler aufgetreten. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Dialog.EmailSentForVerification"
	/// English String: "An email has been sent for verification."
	/// </summary>
	public override string ResponseDialogEmailSentForVerification => "Wir haben dir eine E-Mail zur Verifizierung gesendet.";

	/// <summary>
	/// Key: "Response.Dialog.InvalidEmailAddress"
	/// English String: "Invalid Email Address"
	/// </summary>
	public override string ResponseDialogInvalidEmailAddress => "Ungültige E-Mail-Adresse";

	/// <summary>
	/// Key: "Response.Dialog.InvalidPhoneNumber"
	/// English String: "Invalid phone number"
	/// </summary>
	public override string ResponseDialogInvalidPhoneNumber => "Ungültige Handynummer";

	/// <summary>
	/// Key: "Response.Dialog.InvalidUsername"
	/// Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker.
	/// English String: "Press Send to submit the ticket or press Cancel to edit the username.  The username is very important information and may help get your issue addressed quicker."
	/// </summary>
	public override string ResponseDialogInvalidUsername => "Wähle „Senden“, um das Ticket einzureichen oder „Abbrechen“, um den Benutzernamen zu bearbeiten. Bei deinem Benutzernamen handelt es sich um eine wichtige Information, durch die dein Problem schneller bearbeitet werden kann.";

	/// <summary>
	/// Key: "Response.Dialog.PasswordRulesError"
	/// English String: "Password must contain at least 2 digits, 4 letters, 1 symbol, and be at least 8 characters."
	/// </summary>
	public override string ResponseDialogPasswordRulesError => "Das Passwort muss mindestens 2 Ziffern, 4 Buchstaben und 1 Symbol enthalten und muss mindestens 8 Zeichen lang sein.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateConfirmation"
	/// English String: "Your PIN is now set. You will need to enter this PIN before accessing the Settings page in the future."
	/// </summary>
	public override string ResponseDialogPinCreateConfirmation => "Deine PIN wurde festgelegt. Um in Zukunft auf deine Einstellungsseite zugreifen zu können, musst du diese PIN eingeben.";

	/// <summary>
	/// Key: "Response.Dialog.PinCreateMismatch"
	/// English String: "PINs do not match"
	/// </summary>
	public override string ResponseDialogPinCreateMismatch => "Die PINs stimmen nicht überein.";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionFailed"
	/// English String: "There was an error signing you out of all other sessions, please try again later."
	/// </summary>
	public override string ResponseDialogSignoutSessionFailed => "Beim Abmelden von allen anderen Sitzungen ist ein Fehler aufgetreten. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Dialog.SignoutSessionsConfirmation"
	/// English String: "You have been signed out of all other sessions."
	/// </summary>
	public override string ResponseDialogSignoutSessionsConfirmation => "Du wurdest von allen anderen Sitzungen abgemeldet.";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepDisableWarning"
	/// English String: "If you turn off 2-Step Verification, only your password will be needed when you login from a new device. Are you sure?"
	/// </summary>
	public override string ResponseDialogTwoStepDisableWarning => "Wenn du die Verifizierung in 2 Schritten ausschaltest, benötigst du nur dein Passwort, um dich über ein neues Gerät anzumelden. Bist du dir sicher?";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSuccessTitle"
	/// English String: "2 Step Verification Enabled"
	/// </summary>
	public override string ResponseDialogTwoStepSuccessTitle => "Verifizierung in 2 Schritten aktiviert";

	/// <summary>
	/// Key: "Response.Dialog.TwoStepSucessBody"
	/// English String: "Your account is now protected! No further action is required at this time. A security code will be sent next time you login from a new device."
	/// </summary>
	public override string ResponseDialogTwoStepSucessBody => "Dein Konto ist jetzt geschützt! Derzeit sind keine weiteren Aktionen erforderlich. Wenn du dich das nächste Mal über ein neues Gerät anmeldest, senden wir dir einen Sicherheitscode.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateInventorySetting"
	/// English String: "We have updated your inventory privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateInventorySetting => "Wir haben deine Inventar-Datenschutzeinstellungen aktualisiert. Die Einstellungen für Inventar und Handel müssen übereinstimmen.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateNotificationSettingsError"
	/// English String: "There was an error updating your notification settings, please try again later."
	/// </summary>
	public override string ResponseDialogUpdateNotificationSettingsError => "Beim Aktualisieren deiner Benachrichtigungseinstellungen ist ein Fehler aufgetreten. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.Dialog.UpdateTradeSetting"
	/// English String: "We have updated your trade privacy setting. The inventory and trade settings must be consistent."
	/// </summary>
	public override string ResponseDialogUpdateTradeSetting => "Wir haben deine Handel-Datenschutzeinstellungen aktualisiert. Die Einstellungen für Inventar und Handel müssen übereinstimmen.";

	/// <summary>
	/// Key: "Response.Dialog.VerifyPhoneInvalidCode"
	/// English String: "Code is invalid. Please check your phone and try again."
	/// </summary>
	public override string ResponseDialogVerifyPhoneInvalidCode => "Code ist ungültig. Bitte überprüfe dein Handy und versuche es erneut.";

	/// <summary>
	/// Key: "Response.Dialog.Warning"
	/// English String: "Warning"
	/// </summary>
	public override string ResponseDialogWarning => "Warnung";

	/// <summary>
	/// Key: "Response.FeatureDisabled"
	/// error message
	/// English String: "This feature is currently disabled. Please try again later."
	/// </summary>
	public override string ResponseFeatureDisabled => "Dieses Feature ist derzeit deaktiviert. Bitte versuche es später erneut.";

	/// <summary>
	/// Key: "Response.GeneralError"
	/// error
	/// English String: "An error occurred. Please try again."
	/// </summary>
	public override string ResponseGeneralError => "Ein Fehler ist aufgetreten. Bitte versuche es erneut.";

	/// <summary>
	/// Key: "Response.IncorrectCodeTooManyTimes"
	/// error message
	/// English String: "You have entered the incorrect code too many times."
	/// </summary>
	public override string ResponseIncorrectCodeTooManyTimes => "Du hast zu oft einen falschen Code eingegeben.";

	/// <summary>
	/// Key: "Response.IncorrectPasswordTryAgain"
	/// error message
	/// English String: "Incorrect password. Please check your password and try again."
	/// </summary>
	public override string ResponseIncorrectPasswordTryAgain => "Falsches Passwort. Bitte überprüfe dein Passwort und versuche es erneut.";

	/// <summary>
	/// Key: "Response.InvalidPhoneTryAgain"
	/// error message
	/// English String: "Phone number format is invalid. Please check and try again."
	/// </summary>
	public override string ResponseInvalidPhoneTryAgain => "Format der Handynummer ist ungültig. Bitte überprüfe die Nummer und versuche es erneut.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneRemovedConfirmation"
	/// English String: "Phone has been removed"
	/// </summary>
	public override string ResponseNotificationBarPhoneRemovedConfirmation => "Handynummer wurde entfernt.";

	/// <summary>
	/// Key: "Response.NotificationBar.PhoneVerifyConfirmation"
	/// English String: "Phone has been successfully updated!"
	/// </summary>
	public override string ResponseNotificationBarPhoneVerifyConfirmation => "Handynummer wurde erfolgreich aktualisiert!";

	/// <summary>
	/// Key: "Response.NumberAlreadyAssociated"
	/// error message
	/// English String: "Number is already associated with another account."
	/// </summary>
	public override string ResponseNumberAlreadyAssociated => "Die Nummer ist bereits einem anderen Konto zugeordnet.";

	/// <summary>
	/// Key: "Response.PinRequired"
	/// error
	/// English String: "Please enter your PIN to change your settings."
	/// </summary>
	public override string ResponsePinRequired => "Bitte gib deine PIN ein, um deine Einstellungen zu ändern.";

	/// <summary>
	/// Key: "Response.SocialMedia.ValidationError"
	/// English String: "The social network link is not valid."
	/// </summary>
	public override string ResponseSocialMediaValidationError => "Der Link über das soziale Netzwerk ist nicht gültig.";

	/// <summary>
	/// Key: "ResponseAgeDownError"
	/// English String: "Sorry but you cannot change your age to under 13.  If you are under 13, please create a new account and contact support to delete your old account."
	/// </summary>
	public override string ResponseAgeDownError => "Du kannst dein Alter leider nicht auf unter 13 Jahre ändern. Falls du unter 13 bist, erstelle bitte ein neues Konto und kontaktiere den Support, um das alte zu löschen.";

	public AccountSettingsResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBillingHistoryLoadMore()
	{
		return "Mehr laden";
	}

	protected override string _GetTemplateForActionCancelRenewal()
	{
		return "Verlängerung abbrechen";
	}

	protected override string _GetTemplateForActionDialogAddEmail()
	{
		return "E-Mail-Adresse hinzufügen";
	}

	protected override string _GetTemplateForActionDialogAddPhone()
	{
		return "Handy hinzufügen";
	}

	protected override string _GetTemplateForActionDialogCancel()
	{
		return "Abbrechen";
	}

	protected override string _GetTemplateForActionDialogChangeEmail()
	{
		return "E-Mail-Adresse ändern";
	}

	protected override string _GetTemplateForActionDialogChangeEmailConfirmation()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionDialogChangePassword()
	{
		return "Aktualisieren";
	}

	protected override string _GetTemplateForActionDialogChangePasswordConfirmation()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionDialogChangeUsernameBuy()
	{
		return "Kaufen";
	}

	protected override string _GetTemplateForActionDialogClose()
	{
		return "Schließen";
	}

	protected override string _GetTemplateForActionDialogEditPhonePrimary()
	{
		return "Handy bearbeiten";
	}

	protected override string _GetTemplateForActionDialogEditPhoneSecondary()
	{
		return "Handynummer entfernen";
	}

	protected override string _GetTemplateForActionDialogInsufficientFundsBuy()
	{
		return "Kaufen";
	}

	protected override string _GetTemplateForActionDialogNo()
	{
		return "Nein";
	}

	protected override string _GetTemplateForActionDialogPinCreate()
	{
		return "Hinzufügen";
	}

	protected override string _GetTemplateForActionDialogPinCreateOk()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionDialogPinUnlock()
	{
		return "Entsperren";
	}

	protected override string _GetTemplateForActionDialogRemovePhonePrimary()
	{
		return "Entfernen";
	}

	protected override string _GetTemplateForActionDialogRemovePhoneSecondary()
	{
		return "Abbrechen";
	}

	protected override string _GetTemplateForActionDialogSend()
	{
		return "Senden";
	}

	protected override string _GetTemplateForActionDialogSuccess()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionDialogUpdate()
	{
		return "Aktualisieren";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailOk()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailPrimary()
	{
		return "E-Mail-Adresse verifizieren";
	}

	protected override string _GetTemplateForActionDialogVerifyEmailRetry()
	{
		return "Erneut versuchen";
	}

	protected override string _GetTemplateForActionDialogVerifyPhonePrimary()
	{
		return "Verifizieren";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneResendLink()
	{
		return "Code erneut senden";
	}

	protected override string _GetTemplateForActionDialogVerifyPhoneSecondary()
	{
		return "Abbrechen";
	}

	protected override string _GetTemplateForActionDialogYes()
	{
		return "Ja";
	}

	protected override string _GetTemplateForActionHide()
	{
		return "Verbergen";
	}

	protected override string _GetTemplateForActionJoin()
	{
		return "Beitreten";
	}

	protected override string _GetTemplateForActionJoinBuildersClub()
	{
		return "Builders Club beitreten";
	}

	protected override string _GetTemplateForActionSave()
	{
		return "Speichern";
	}

	protected override string _GetTemplateForActionShow()
	{
		return "Anzeigen";
	}

	protected override string _GetTemplateForActionSignoutAllSessions()
	{
		return "Abmelden";
	}

	protected override string _GetTemplateForActionSocialDisconnect()
	{
		return "Verbindung trennen";
	}

	protected override string _GetTemplateForActionSuccessDialogButtonText()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionUnblock()
	{
		return "Nicht mehr sperren";
	}

	protected override string _GetTemplateForActionUpgradeMembership()
	{
		return "Mitgliedschaft aufwerten";
	}

	protected override string _GetTemplateForDescriptionAccountControls()
	{
		return "Du kannst Kontoeinschränkungen für dieses Konto einrichten, um den Zugriff auf Kontoeinstellungen und ungeprüfte Inhalte einzuschränken.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.From"
	/// From address for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "{escapeLiteralStart}Roblox Email Reset{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Roblox-E-Mail zurückgesetzt{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailFrom()
	{
		return "{escapeLiteralStart}Roblox-E-Mail zurückgesetzt{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.HtmlBody"
	/// Html body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailHtmlBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string aTagWithHref, string revertAccountEmailLinkWithTicket, string hrefEnd, string revertAccountEmailLink, string aTagEnd, string robloxInfoEmailAddress)
	{
		return $"Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir haben festgestellt, dass du die E-Mail-Adresse für dein Konto {username} von {oldEmailAddress} auf {newEmailAddress} geändert hast. Falls dies nicht beabsichtigt war oder du glaubst, dass jemand die E-Mail-Adresse aus Versehen geändert hat, klicke auf diesen Link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}, um die E-Mail-Adresse wiederherzustellen. Du musst außerdem ein neues Passwort angeben, damit wir ganz sicher sein können, dass dein Konto geschützt ist.{lineBreak}{lineBreak}Wenn du mit deiner neuen E-Mail-Adresse für Roblox zufrieden bist, brauchst du nichts zu tun! Sie ist bereits eingestellt.{lineBreak}{lineBreak}Bitte antworte nicht auf diese Nachricht. Falls Du Fragen hast, sende uns bitte eine E-Mail {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailHtmlBody()
	{
		return "Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir haben festgestellt, dass du die E-Mail-Adresse für dein Konto {username} von {oldEmailAddress} auf {newEmailAddress} geändert hast. Falls dies nicht beabsichtigt war oder du glaubst, dass jemand die E-Mail-Adresse aus Versehen geändert hat, klicke auf diesen Link{lineBreak}{aTagWithHref}{revertAccountEmailLinkWithTicket}{hrefEnd}{revertAccountEmailLink}{aTagEnd}{lineBreak}, um die E-Mail-Adresse wiederherzustellen. Du musst außerdem ein neues Passwort angeben, damit wir ganz sicher sein können, dass dein Konto geschützt ist.{lineBreak}{lineBreak}Wenn du mit deiner neuen E-Mail-Adresse für Roblox zufrieden bist, brauchst du nichts zu tun! Sie ist bereits eingestellt.{lineBreak}{lineBreak}Bitte antworte nicht auf diese Nachricht. Falls Du Fragen hast, sende uns bitte eine E-Mail {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.AccountEmailRevertEmail.PlainBody"
	/// Plain body for account email revert email that is sent out to the old account when the new account email is verified.
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We noticed that you have changed the email address for your {username} account from {oldEmailAddress} to {newEmailAddress}. Just in case you really didn't mean to change it, or you think someone else changed it by mistake, then we need you to click this link{lineBreak}{revertAccountEmailLink}{lineBreak}to change the email back. You will also need to enter a new password. That way we will know for sure that your account is secure and safe.{lineBreak}{lineBreak}If you are happy with your new email address on Roblox you don't have to do anything! It's already set up.{lineBreak}Please do not reply to this message. If you have any questions please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionAccountEmailRevertEmailPlainBody(string lineBreak, string username, string oldEmailAddress, string newEmailAddress, string revertAccountEmailLink, string robloxInfoEmailAddress)
	{
		return $"Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir haben festgestellt, dass du die E-Mail-Adresse für dein Konto {username} von {oldEmailAddress} auf {newEmailAddress} geändert hast. Falls dies nicht beabsichtigt war oder du glaubst, dass jemand die E-Mail-Adresse aus Versehen geändert hat, klicke auf diesen Link{lineBreak}{revertAccountEmailLink}{lineBreak}, um die E-Mail-Adresse wiederherzustellen. Du musst außerdem ein neues Passwort angeben, damit wir ganz sicher sein können, dass dein Konto geschützt ist.{lineBreak}{lineBreak}Wenn du mit deiner neuen E-Mail-Adresse für Roblox zufrieden bist, brauchst du nichts zu tun! Sie ist bereits eingestellt.{lineBreak}Bitte antworte nicht auf diese Nachricht. Falls Du Fragen hast, sende uns bitte eine E-Mail {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailPlainBody()
	{
		return "Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir haben festgestellt, dass du die E-Mail-Adresse für dein Konto {username} von {oldEmailAddress} auf {newEmailAddress} geändert hast. Falls dies nicht beabsichtigt war oder du glaubst, dass jemand die E-Mail-Adresse aus Versehen geändert hat, klicke auf diesen Link{lineBreak}{revertAccountEmailLink}{lineBreak}, um die E-Mail-Adresse wiederherzustellen. Du musst außerdem ein neues Passwort angeben, damit wir ganz sicher sein können, dass dein Konto geschützt ist.{lineBreak}{lineBreak}Wenn du mit deiner neuen E-Mail-Adresse für Roblox zufrieden bist, brauchst du nichts zu tun! Sie ist bereits eingestellt.{lineBreak}Bitte antworte nicht auf diese Nachricht. Falls Du Fragen hast, sende uns bitte eine E-Mail {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionAccountEmailRevertEmailSubject()
	{
		return "Roblox-E-Mail zurückgesetzt";
	}

	/// <summary>
	/// Key: "Description.AccountRestrictionsEnabled"
	/// English String: "This account can only access our curated content on the platform. Additionally, contact settings (under the {linkStart}Privacy{linkEnd} page) will be set to Off."
	/// </summary>
	public override string DescriptionAccountRestrictionsEnabled(string linkStart, string linkEnd)
	{
		return $"Mit diesem Konto kann nur auf unsere geprüften Inhalte auf der Plattform zugegriffen werden. Außerdem werden Kontakteinstellungen (siehe Seite {linkStart}Datenschutz{linkEnd}) auf „Aus“ gestellt.";
	}

	protected override string _GetTemplateForDescriptionAccountRestrictionsEnabled()
	{
		return "Mit diesem Konto kann nur auf unsere geprüften Inhalte auf der Plattform zugegriffen werden. Außerdem werden Kontakteinstellungen (siehe Seite {linkStart}Datenschutz{linkEnd}) auf „Aus“ gestellt.";
	}

	/// <summary>
	/// Key: "Description.BlockedLimitMessage"
	/// English String: "You're blocking {totalBlockedCount} of {maxBlockedCount} users allowed:"
	/// </summary>
	public override string DescriptionBlockedLimitMessage(string totalBlockedCount, string maxBlockedCount)
	{
		return $"Du sperrst {totalBlockedCount} von {maxBlockedCount} erlaubten Benutzern:";
	}

	protected override string _GetTemplateForDescriptionBlockedLimitMessage()
	{
		return "Du sperrst {totalBlockedCount} von {maxBlockedCount} erlaubten Benutzern:";
	}

	/// <summary>
	/// Key: "Description.ContactSetting"
	/// English String: "Contact Settings are locked because Account Restrictions (under {linkStart}Security{linkEnd} page) is enabled"
	/// </summary>
	public override string DescriptionContactSetting(string linkStart, string linkEnd)
	{
		return $"Die Kontakteinstellungen sind gesperrt, da die Kontoeinschränkungen (siehe Seite {linkStart}Sicherheit{linkEnd}) aktiviert sind.";
	}

	protected override string _GetTemplateForDescriptionContactSetting()
	{
		return "Die Kontakteinstellungen sind gesperrt, da die Kontoeinschränkungen (siehe Seite {linkStart}Sicherheit{linkEnd}) aktiviert sind.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush1()
	{
		return "Erhalte selbst dann Benachrichtigungen auf diesem Computer, wenn Roblox nicht geöffnet ist.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush2()
	{
		return "Um Benachrichtigungen zu sehen, wirst du eventuell dazu aufgefordert, Push-Benachrichtigungen in deinem Browser zu aktivieren.";
	}

	protected override string _GetTemplateForDescriptionDesktopPush3()
	{
		return "Desktop-Benachrichtigungen für dieses Gerät.";
	}

	protected override string _GetTemplateForDescriptionDialogAddPhone()
	{
		return "Bitte bestätige deine Ländervorwahl und gib deine Handynummer ein. Wir werden dir eine SMS schicken, um die Verifizierung abzuschließen. (Hinweis: Es können SMS-Kosten anfallen.)";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailConfirmation()
	{
		return "Wir haben dir eine E-Mail zur Verifizierung gesendet.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeEmailWarning()
	{
		return "Die E-Mail-Adresse des Kontos wird erst aktualisiert, nachdem die neue E-Mail-Adresse verifiziert wurde.";
	}

	protected override string _GetTemplateForDescriptionDialogChangePasswordConfirmation()
	{
		return "Du hast dein Passwort erfolgreich geändert.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameDisclaimer()
	{
		return "Wichtig: Das ursprüngliche Kontoerstellungsdatum wird auf deinen neuen Benutzernamen übertragen.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameForFree()
	{
		return "Du kannst deinen Benutzernamen einmal kostenlos ändern.";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameHistory()
	{
		return "Bisherige Forumposts werden weiterhin unter deinem alten Benutzernamen geführt und werden NICHT auf deinen neuen Benutzernamen übertragen.";
	}

	/// <summary>
	/// Key: "Description.Dialog.ChangeUsernamePageText"
	/// English String: "Change username for {robuxIcon} {price}?"
	/// </summary>
	public override string DescriptionDialogChangeUsernamePageText(string robuxIcon, string price)
	{
		return $"Benutzernamen für {price} {robuxIcon} ändern?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernamePageText()
	{
		return "Benutzernamen für {price} {robuxIcon} ändern?";
	}

	protected override string _GetTemplateForDescriptionDialogChangeUsernameTitle()
	{
		return "Benutzernamen ändern";
	}

	protected override string _GetTemplateForDescriptionDialogEditPhoneWarning()
	{
		return "Die Handynummer wird erst aktualisiert, nachdem die neue Handynummer verifiziert wurde.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailProvideAndVerifyWarning()
	{
		return "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerificationSent()
	{
		return "Danke! Wir haben dir eine E-Mail zur Verifizierung gesendet.";
	}

	protected override string _GetTemplateForDescriptionDialogEmailVerifyWarning()
	{
		return "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse verifizieren.";
	}

	protected override string _GetTemplateForDescriptionDialogFacebookDisconnectWarning()
	{
		return "Bitte füge ein Passwort hinzu, um dein Konto zu sichern, bevor du die Verbindung zu Facebook trennst.";
	}

	/// <summary>
	/// Key: "Description.Dialog.InsufficientFundsWarning"
	/// English String: "You need {robuxToBuy} more to change your username. Would you like to buy more Robux?"
	/// </summary>
	public override string DescriptionDialogInsufficientFundsWarning(string robuxToBuy)
	{
		return $"Du benötigst noch {robuxToBuy}, um deinen Benutzernamen zu ändern. Möchtest du mehr Robux kaufen?";
	}

	protected override string _GetTemplateForDescriptionDialogInsufficientFundsWarning()
	{
		return "Du benötigst noch {robuxToBuy}, um deinen Benutzernamen zu ändern. Möchtest du mehr Robux kaufen?";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailAccountPin()
	{
		return "Bevor du eine Konto-PIN hinzufügen kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailTwoStepVerification()
	{
		return "Bevor du die Verifizierung in 2 Schritten aktivieren kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";
	}

	protected override string _GetTemplateForDescriptionDialogMissingEmailUsername()
	{
		return "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse angeben und verifizieren.";
	}

	protected override string _GetTemplateForDescriptionDialogPinUnlock()
	{
		return "Gib die Konto-PIN für dein Konto ein.";
	}

	/// <summary>
	/// Key: "Description.Dialog.RemovePhoneWarning"
	/// English String: "Are you sure that you want to remove your phone number which ends with {phoneLast4}?"
	/// </summary>
	public override string DescriptionDialogRemovePhoneWarning(string phoneLast4)
	{
		return $"Möchtest du deine Handynummer, die auf {phoneLast4} endet, wirklich entfernen?";
	}

	protected override string _GetTemplateForDescriptionDialogRemovePhoneWarning()
	{
		return "Möchtest du deine Handynummer, die auf {phoneLast4} endet, wirklich entfernen?";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailAccountPin()
	{
		return "Bevor du eine Konto-PIN hinzufügen kannst, musst du deine E-Mail-Adresse verifizieren.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailTwoStepVerification()
	{
		return "Bevor du die Verifizierung in 2 Schritten aktivieren kannst, musst du deine E-Mail-Adresse verifizieren.";
	}

	protected override string _GetTemplateForDescriptionDialogUnverifiedEmailUsername()
	{
		return "Bevor du deinen Benutzernamen ändern kannst, musst du deine E-Mail-Adresse verifizieren.";
	}

	protected override string _GetTemplateForDescriptionFastTrack()
	{
		return "Da du gute Arbeit bei der Meldung von Verstößen geleistet hast, wurdest du ins Expressmeldungsprogramm aufgenommen. Deine Meldungen werden ab sofort bevorzugt geprüft. Wenn du weiterhin gute Arbeit leistest, verbleibst du im Programm. Danke für deine Hilfe, Roblox zu einer positiven Erfahrung für alle zu machen!";
	}

	protected override string _GetTemplateForDescriptionFastTrackStatistics()
	{
		return "Statistiken";
	}

	protected override string _GetTemplateForDescriptionHelpTextDescription()
	{
		return "Gib keine Informationen an, mit denen du außerhalb von Roblox identifiziert werden könntest.";
	}

	protected override string _GetTemplateForDescriptionHelpTextFastTrackAccuracy()
	{
		return "Die Genauigkeit spiegelt wider, wie häufig unser Moderationsteam deine Meldungen über Verstöße bestätigt. Dieser Wert wird erst angezeigt, nachdem du einige Meldungen eingereicht hast. „Jeder“ bezeichnet alle Expressmeldungsmitglieder zusammengenommen.";
	}

	protected override string _GetTemplateForDescriptionHelpTextPrivacyMode()
	{
		return "Wenn das Alter zu unter 13 Jahren geändert wird, wird der Datenschutzmodus aktiviert.";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangePassword()
	{
		return "Passwort ändern";
	}

	protected override string _GetTemplateForDescriptionHoverTextChangeUsername()
	{
		return "Benutzernamen ändern";
	}

	protected override string _GetTemplateForDescriptionHoverTextUpdateEmail()
	{
		return "E-Mail-Adresse aktualisieren";
	}

	protected override string _GetTemplateForDescriptionMembershipHelp()
	{
		return "Für Fragen zu Zahlungen: info@roblox.com";
	}

	protected override string _GetTemplateForDescriptionMembershipStatus()
	{
		return "Du bist noch kein Mitglied. Tritt gleich dem Builders Club bei!";
	}

	protected override string _GetTemplateForDescriptionMembershipStatusRobloxPremium()
	{
		return "Du bist noch kein Mitglied. Tritt Roblox-Premium heute bei!";
	}

	protected override string _GetTemplateForDescriptionMobilePush1()
	{
		return "Erhalte Benachrichtigungen auf den Startbildschirmen deiner Geräte. Du kannst sie über die Roblox-App an- oder ausschalten.";
	}

	protected override string _GetTemplateForDescriptionMobilePush2()
	{
		return "Mobilgerät-Push-Benachrichtigung für dieses Gerät.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream1()
	{
		return "Erhalte Benachrichtigungen in deinem Stream. Klicke auf das Benachrichtigungssymbol in der oberen Leiste, um diese Benachrichtigungen zu sehen.";
	}

	protected override string _GetTemplateForDescriptionNotificationStream2()
	{
		return "Wenn du eine bestimmte Benachrichtigungsart ausschaltest, werden wir dir keine Benachrichtigungen dieser Art mehr schicken.";
	}

	protected override string _GetTemplateForDescriptionRenevalFromWebsiteOnly()
	{
		return "Hinweis: Falls du deine Mitgliedschaft nicht mehr verlängern möchtest, melde dich bitte über die Website an.";
	}

	protected override string _GetTemplateForDescriptionSuccessDialogMessage()
	{
		return "Erfolgreich gespeichert!";
	}

	protected override string _GetTemplateForDescriptionTwoStepVerificationSecondary()
	{
		return "Eine verifizierte E-Mail-Adresse ist erforderlich.";
	}

	/// <summary>
	/// Key: "Description.TwoStepverificationSecondaryEnabled"
	/// English String: "When you log in from a new device, codes will be sent to {email}"
	/// </summary>
	public override string DescriptionTwoStepverificationSecondaryEnabled(string email)
	{
		return $"Wenn du dich von einem neuen Gerät aus anmeldest, werden Codes an {email} gesendet.";
	}

	protected override string _GetTemplateForDescriptionTwoStepverificationSecondaryEnabled()
	{
		return "Wenn du dich von einem neuen Gerät aus anmeldest, werden Codes an {email} gesendet.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.Body"
	/// Body for username change email that is sent out on a successful change of username
	/// English String: "Hello Roblox user, {lineBreaks}Your username has recently been changed from {oldUsername} to {newUsername}. If you did not request a username change, please email {robloxInfoEmailAddress}."
	/// </summary>
	public override string DescriptionUsernameChangeEmailBody(string lineBreaks, string oldUsername, string newUsername, string robloxInfoEmailAddress)
	{
		return $"Hallo Roblox-Benutzer,{lineBreaks}dein Benutzername wurde vor Kurzem von „{oldUsername}“ zu „{newUsername}“ geändert. Solltest du diese Änderung nicht selbst vorgenommen haben, wende dich bitte per E-Mail an {robloxInfoEmailAddress}.";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailBody()
	{
		return "Hallo Roblox-Benutzer,{lineBreaks}dein Benutzername wurde vor Kurzem von „{oldUsername}“ zu „{newUsername}“ geändert. Solltest du diese Änderung nicht selbst vorgenommen haben, wende dich bitte per E-Mail an {robloxInfoEmailAddress}.";
	}

	/// <summary>
	/// Key: "Description.UsernameChangeEmail.From"
	/// From address for username change email that is sent out on a successful change of username
	/// English String: "{escapeLiteralStart}Roblox Username Change{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionUsernameChangeEmailFrom(string escapeLiteralStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteralStart}Änderung des Roblox-Benutzernamens{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailFrom()
	{
		return "{escapeLiteralStart}Änderung des Roblox-Benutzernamens{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionUsernameChangeEmailSubject()
	{
		return "Änderung des Roblox-Benutzernamens";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Over13"
	/// From address for verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Email Verification{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromOver13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox-E-Mail-Verifizierung{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromOver13()
	{
		return "{escapeLiteratStart}Roblox-E-Mail-Verifizierung{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.From.Under13"
	/// From address for verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "{escapeLiteratStart}Roblox Account Authorization{escapeLiteralEnd} {fromEmailAddress}"
	/// </summary>
	public override string DescriptionVerificationEmailFromUnder13(string escapeLiteratStart, string escapeLiteralEnd, string fromEmailAddress)
	{
		return $"{escapeLiteratStart}Roblox-Kontoautorisierung{escapeLiteralEnd} {fromEmailAddress}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailFromUnder13()
	{
		return "{escapeLiteratStart}Roblox-Kontoautorisierung{escapeLiteralEnd} {fromEmailAddress}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Over13	"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the button below to complete the verification process.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}Verify Email{buttonEnd}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyOver13(string lineBreak, string username, string aTagStartWithHref, string verificationLink, string targetBlank, string buttonStart, string buttonEnd, string aTagEnd)
	{
		return $"Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir freuen uns, dass du dein Konto ({username}) durch eine E-Mail-Adresse schützen möchtest.{lineBreak}Wenn du die E-Mail-Adresse, die mit deinem Roblox-Konto verknüpft ist, verifizierst, machst du dein Konto sicherer.{lineBreak}Bitte klicke auf die Schaltfläche unten, um die Verifizierung abzuschließen.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}E-Mail-Adresse verifizieren{buttonEnd}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyOver13()
	{
		return "Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir freuen uns, dass du dein Konto ({username}) durch eine E-Mail-Adresse schützen möchtest.{lineBreak}Wenn du die E-Mail-Adresse, die mit deinem Roblox-Konto verknüpft ist, verifizierst, machst du dein Konto sicherer.{lineBreak}Bitte klicke auf die Schaltfläche unten, um die Verifizierung abzuschließen.{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{targetBlank}{buttonStart}E-Mail-Adresse verifizieren{buttonEnd}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {boldTagStart}{username}{boldTagEnd} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below: {lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}Verify Email{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}About Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox also offers {boldTagStart}parental controls{boldTagEnd}. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13(string lineBreak, string boldTagStart, string username, string boldTagEnd, string aTagStartWithHref, string verificationLink, string hrefEnd, string buttonStart, string buttonEnd, string aTagEnd, string parentalPageLink, string accountSecurityLink, string accountPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Hallo,{lineBreak}{lineBreak}Ihr Kind hat das Konto {boldTagStart}{username}{boldTagEnd} auf Roblox erstellt. Roblox ist eine Online-Unterhaltungsplattform, auf der Kinder ihrer Fantasie freien Lauf lassen und gemeinsam in immersiven, von unseren Benutzern erschaffenen 3D-Welten spielen und Inhalte erstellen können. Unsere Plattform bietet auch ein kostenloses Entwickler-Tool namens „Roblox Studio“, mit dem Benutzer alles in ihrer Vorstellungskraft entwickeln können: von simplen Drag-and-Drop-Konstruktionen bis hin zu komplexen Mehrspielerspielen. Millionen von Kindern nutzen Roblox, um selbst zu erleben, wie es sich anfühlt, den ultimativen Vergnügungspark zu bauen, als professioneller Rennfahrer anzutreten, bei einer Modenschau zu glänzen oder einfach nur ein Traumhaus zu bauen und sich dort mit Freunden zu treffen.{lineBreak}{lineBreak}Durch diese E-Mail möchten wir Ihnen mitteilen, dass Ihr Kind seinen Benutzernamen, Geburtstag und die E-Mail-Adresse seiner Eltern angegeben hat. Die E-Mail-Adresse der Eltern wird nur verwendet, um das Konto zu verwalten, vergessene Passwörter zurückzusetzen und die Eltern darüber zu benachrichtigen, wenn sich der Kontozugriff des Kinds ändert. Um Ihre E-Mail-Adresse zu verifizieren, klicken Sie bitte auf die Schaltfläche unten:{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}E-Mail-Adresse verifizieren{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Über Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox setzt sich dafür ein, eine unterhaltsame, familienfreundliche Umgebung bereitzustellen. Wir verbessern unsere Sicherheitsmaßnahmen fortwährend und arbeiten mit Experten für digitale Sicherheit zusammen, um dafür zu sorgen, dass allen Spielern ein sicherer, angenehmer Ort zum Spielen und Chatten sowie für gemeinsame, kreative Projekte zur Verfügung steht. Wir empfehlen Ihnen, unseren Elternratgeber zu lesen, um sich mit unserer Plattform vertraut zu machen. Dort finden Sie auch hilfreiche Tipps, mit denen Sie ein positives Erlebnis für Ihre Kinder auf Roblox gewährleisten können: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox bietet auch {boldTagStart}Jugendschutzeinstellungen{boldTagEnd}. Eltern können eine Eltern-PIN aktivieren und die Kommunikations- und Chateinstellungen für ihre Kinder anpassen. Diese Einstellungen finden Sie in den Reitern für Sicherheit und Datenschutz in den Kontoeinstellungen, während Sie beim Konto Ihres Kindes angemeldet sind.{lineBreak}{lineBreak}Um eine Eltern-PIN hinzuzufügen, besuchen Sie bitte: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Um die Chateinstellungen anzupassen, besuchen Sie bitte: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Datenschutz{boldTagEnd}{lineBreak}{lineBreak}Sie können das Konto Ihres Kindes entfernen, indem Sie den Kundenservice hier kontaktieren: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Ihre E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von Ihrem Kind erhalten haben, verknüpft. Weitere Informationen können Sie unseren Datenschutzrichtlinien hier entnehmen: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team {lineBreak}{lineBreak} Bitte antworten Sie nicht direkt auf diese E-Mail. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13()
	{
		return "Hallo,{lineBreak}{lineBreak}Ihr Kind hat das Konto {boldTagStart}{username}{boldTagEnd} auf Roblox erstellt. Roblox ist eine Online-Unterhaltungsplattform, auf der Kinder ihrer Fantasie freien Lauf lassen und gemeinsam in immersiven, von unseren Benutzern erschaffenen 3D-Welten spielen und Inhalte erstellen können. Unsere Plattform bietet auch ein kostenloses Entwickler-Tool namens „Roblox Studio“, mit dem Benutzer alles in ihrer Vorstellungskraft entwickeln können: von simplen Drag-and-Drop-Konstruktionen bis hin zu komplexen Mehrspielerspielen. Millionen von Kindern nutzen Roblox, um selbst zu erleben, wie es sich anfühlt, den ultimativen Vergnügungspark zu bauen, als professioneller Rennfahrer anzutreten, bei einer Modenschau zu glänzen oder einfach nur ein Traumhaus zu bauen und sich dort mit Freunden zu treffen.{lineBreak}{lineBreak}Durch diese E-Mail möchten wir Ihnen mitteilen, dass Ihr Kind seinen Benutzernamen, Geburtstag und die E-Mail-Adresse seiner Eltern angegeben hat. Die E-Mail-Adresse der Eltern wird nur verwendet, um das Konto zu verwalten, vergessene Passwörter zurückzusetzen und die Eltern darüber zu benachrichtigen, wenn sich der Kontozugriff des Kinds ändert. Um Ihre E-Mail-Adresse zu verifizieren, klicken Sie bitte auf die Schaltfläche unten:{lineBreak}{lineBreak}{aTagStartWithHref}{verificationLink}{hrefEnd}{buttonStart}E-Mail-Adresse verifizieren{buttonEnd}{aTagEnd}{lineBreak}{lineBreak}{boldTagStart}Über Roblox{boldTagEnd}{lineBreak}{lineBreak}Roblox setzt sich dafür ein, eine unterhaltsame, familienfreundliche Umgebung bereitzustellen. Wir verbessern unsere Sicherheitsmaßnahmen fortwährend und arbeiten mit Experten für digitale Sicherheit zusammen, um dafür zu sorgen, dass allen Spielern ein sicherer, angenehmer Ort zum Spielen und Chatten sowie für gemeinsame, kreative Projekte zur Verfügung steht. Wir empfehlen Ihnen, unseren Elternratgeber zu lesen, um sich mit unserer Plattform vertraut zu machen. Dort finden Sie auch hilfreiche Tipps, mit denen Sie ein positives Erlebnis für Ihre Kinder auf Roblox gewährleisten können: {aTagStartWithHref}{parentalPageLink}{hrefEnd}{parentalPageLink}{aTagEnd}{lineBreak}{lineBreak}Roblox bietet auch {boldTagStart}Jugendschutzeinstellungen{boldTagEnd}. Eltern können eine Eltern-PIN aktivieren und die Kommunikations- und Chateinstellungen für ihre Kinder anpassen. Diese Einstellungen finden Sie in den Reitern für Sicherheit und Datenschutz in den Kontoeinstellungen, während Sie beim Konto Ihres Kindes angemeldet sind.{lineBreak}{lineBreak}Um eine Eltern-PIN hinzuzufügen, besuchen Sie bitte: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Um die Chateinstellungen anzupassen, besuchen Sie bitte: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Datenschutz{boldTagEnd}{lineBreak}{lineBreak}Sie können das Konto Ihres Kindes entfernen, indem Sie den Kundenservice hier kontaktieren: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Ihre E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von Ihrem Kind erhalten haben, verknüpft. Weitere Informationen können Sie unseren Datenschutzrichtlinien hier entnehmen: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team {lineBreak}{lineBreak} Bitte antworten Sie nicht direkt auf diese E-Mail. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.HtmlBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}To change chat settings, please visit: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Privacy{boldTagEnd}{lineBreak}{lineBreak}You may remove your child's account by contacting customer service at {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team {lineBreak}{lineBreak} Do not reply to this email directly. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}"
	/// </summary>
	public override string DescriptionVerificationEmailHtmlBodyUnder13Part2(string lineBreak, string aTagStartWithHref, string accountSecurityLink, string hrefEnd, string aTagEnd, string accountPrivacyLink, string boldTagStart, string boldTagEnd, string supportPageLink, string privacyPageLink, string robloxWebsiteLink)
	{
		return $"Diese Einstellungen findest du in den Reitern für Sicherheit und Datenschutz in den Kontoeinstellungen, während du beim Konto deines Kindes angemeldet bist.{lineBreak}{lineBreak}Um eine Eltern-PIN hinzuzufügen, besuche bitte: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Um die Chateinstellungen anzupassen, besuche bitte: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Datenschutz{boldTagEnd}{lineBreak}{lineBreak}Du kannst das Konto deines Kindes entfernen, indem du den Kundenservice hier kontaktierst: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Deine E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von deinem Kind erhalten haben, verknüpft. Weitere Informationen kannst du unseren Datenschutzrichtlinien hier entnehmen: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team {lineBreak}{lineBreak} Bitte antworte nicht direkt auf diese E-Mail. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailHtmlBodyUnder13Part2()
	{
		return "Diese Einstellungen findest du in den Reitern für Sicherheit und Datenschutz in den Kontoeinstellungen, während du beim Konto deines Kindes angemeldet bist.{lineBreak}{lineBreak}Um eine Eltern-PIN hinzuzufügen, besuche bitte: {aTagStartWithHref}{accountSecurityLink}{hrefEnd}{accountSecurityLink}{aTagEnd}.{lineBreak}{lineBreak}Um die Chateinstellungen anzupassen, besuche bitte: {aTagStartWithHref}{accountPrivacyLink}{hrefEnd}{accountPrivacyLink}{aTagEnd}.{lineBreak}{lineBreak}{boldTagStart}Datenschutz{boldTagEnd}{lineBreak}{lineBreak}Du kannst das Konto deines Kindes entfernen, indem du den Kundenservice hier kontaktierst: {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}. Deine E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von deinem Kind erhalten haben, verknüpft. Weitere Informationen kannst du unseren Datenschutzrichtlinien hier entnehmen: {aTagStartWithHref}{privacyPageLink}{hrefEnd}{privacyPageLink}{aTagEnd}.{lineBreak}{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team {lineBreak}{lineBreak} Bitte antworte nicht direkt auf diese E-Mail. {lineBreak}{lineBreak} {aTagStartWithHref}{robloxWebsiteLink}{hrefEnd}{robloxWebsiteLink}{aTagEnd} {lineBreak}{lineBreak} {aTagStartWithHref}{supportPageLink}{hrefEnd}{supportPageLink}{aTagEnd}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Over13"
	/// Email body of verification email that is sent out when an over 13 user adds an email to the account
	/// English String: "Dear Roblox user,{lineBreak}{lineBreak}We are pleased that you have chosen to secure your {username} account by providing an email address.{lineBreak}By verifying the email address associated with your Roblox account, you enable a higher level of account security.{lineBreak}Please click the link below to complete the verification process{lineBreak}{verificationLink}.\n"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyOver13(string lineBreak, string username, string verificationLink)
	{
		return $"Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir freuen uns, dass du dein Konto ({username}) durch eine E-Mail-Adresse schützen möchtest.{lineBreak}Wenn du die E-Mail-Adresse, die mit deinem Roblox-Konto verknüpft ist, verifizierst, machst du dein Konto sicherer.{lineBreak}Bitte klicke auf den folgenden Link, um die Verifizierung abzuschließen:{lineBreak}{verificationLink}\n";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyOver13()
	{
		return "Lieber Roblox-Benutzer,{lineBreak}{lineBreak}wir freuen uns, dass du dein Konto ({username}) durch eine E-Mail-Adresse schützen möchtest.{lineBreak}Wenn du die E-Mail-Adresse, die mit deinem Roblox-Konto verknüpft ist, verifizierst, machst du dein Konto sicherer.{lineBreak}Bitte klicke auf den folgenden Link, um die Verifizierung abzuschließen:{lineBreak}{verificationLink}\n";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account
	/// English String: "Hello,{lineBreak}{lineBreak}Your child created the account {username} on Roblox, an online entertainment platform that enables kids to imagine, create, and play together in immersive, user-generated 3D worlds. Our platform also provides a free development tool called “Roblox Studio” that allows users to create anything they imagine, from simple drag-and-drop building experiences to complex multiplayer games. Millions of kids have used Roblox to imagine what it’s like to create the ultimate theme park, compete as a professional race car driver, star in a fashion show, or simply build a dream home and hang out with friends.{lineBreak}{lineBreak}This email is to inform you that your child has provided us with a username, date of birth, and a parent’s email address. The parent’s email address is only used for account management, password resets if the child forgets their password, and to notify parents of changes to the child’s account access. To verify your email address, please click the button below:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}About Roblox{lineBreak}{lineBreak}Roblox is dedicated to building an enjoyable, family-friendly environment. We are constantly evolving our safety features and working with digital safety experts to ensure that all players have a safe, comfortable place to play, chat, and collaborate on creative projects. We recommend that you visit our Parent’s Guide to help yourself get acquainted with our platform and find helpful tips for creating a positive experience for your kids on Roblox: {parentalPageLink}{lineBreak}{lineBreak}Roblox also offers parental controls. Parents can enable a parent PIN and change their child’s communication and chat settings. You can find these controls by visiting the security and privacy tabs in the account settings while logged into your child’s account.{lineBreak}{lineBreak}To add a parent PIN, please visit: {accountSecurityLink}{lineBreak}{lineBreak}To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13(string lineBreak, string username, string verificationLink, string parentalPageLink, string accountSecurityLink, string chatPrivacyLink, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Hallo,{lineBreak}{lineBreak}Ihr Kind hat das Konto {username} auf Roblox erstellt. Roblox ist eine Online-Unterhaltungsplattform, auf der Kinder ihrer Fantasie freien Lauf lassen und gemeinsam in immersiven, von unseren Benutzern erschaffenen 3D-Welten spielen und Inhalte erstellen können. Unsere Plattform bietet auch ein kostenloses Entwickler-Tool namens „Roblox Studio“, mit dem Benutzer alles in ihrer Vorstellungskraft entwickeln können: von simplen Drag-and-Drop-Konstruktionen bis hin zu komplexen Mehrspielerspielen. Millionen von Kindern nutzen Roblox, um selbst zu erleben, wie es sich anfühlt, den ultimativen Vergnügungspark zu bauen, als professioneller Rennfahrer anzutreten, bei einer Modenschau zu glänzen oder einfach nur ein Traumhaus zu bauen und sich dort mit Freunden zu treffen.{lineBreak}{lineBreak}Durch diese E-Mail möchten wir Ihnen mitteilen, dass Ihr Kind seinen Benutzernamen, Geburtstag und die E-Mail-Adresse seiner Eltern angegeben hat. Die E-Mail-Adresse der Eltern wird nur verwendet, um das Konto zu verwalten, vergessene Passwörter zurückzusetzen und die Eltern darüber zu benachrichtigen, wenn sich der Kontozugriff des Kinds ändert. Um Ihre E-Mail-Adresse zu verifizieren, klicken Sie bitte auf die Schaltfläche unten:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Über Roblox{lineBreak}{lineBreak}Roblox setzt sich dafür ein, eine unterhaltsame, familienfreundliche Umgebung bereitzustellen. Wir verbessern unsere Sicherheitsmaßnahmen fortwährend und arbeiten mit Experten für digitale Sicherheit zusammen, um dafür zu sorgen, dass allen Spielern ein sicherer, angenehmer Ort zum Spielen und Chatten sowie für gemeinsame, kreative Projekte zur Verfügung steht. Wir empfehlen Ihnen, unseren Elternratgeber zu lesen, um sich mit unserer Plattform vertraut zu machen. Dort finden Sie auch hilfreiche Tipps, mit denen Sie ein positives Erlebnis für Ihre Kinder auf Roblox gewährleisten können: {parentalPageLink}{lineBreak}{lineBreak}Roblox bietet auch Jugendschutzeinstellungen. Eltern können eine Eltern-PIN aktivieren und die Kommunikations- und Chateinstellungen für ihre Kinder anpassen. Diese Einstellungen finden Sie in den Reitern für Sicherheit und Datenschutz in den Kontoeinstellungen, während Sie beim Konto Ihres Kindes angemeldet sind.{lineBreak}{lineBreak}Um eine Eltern-PIN hinzuzufügen, besuchen Sie bitte: {accountSecurityLink}{lineBreak}{lineBreak}Um die Chateinstellungen anzupassen, besuchen Sie bitte: {chatPrivacyLink}{lineBreak}{lineBreak}Datenschutz{lineBreak}{lineBreak}Sie können das Konto deines Kindes entfernen, indem Sie den Kundenservice hier kontaktieren: {supportPageLink}. Ihre E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von Ihrem Kind erhalten haben, verknüpft. Weitere Informationen können Sie unseren Datenschutzrichtlinien hier entnehmen: {privacyPageLink}{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team{lineBreak}Bitte antworten Sie nicht direkt auf diese E-Mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13()
	{
		return "Hallo,{lineBreak}{lineBreak}Ihr Kind hat das Konto {username} auf Roblox erstellt. Roblox ist eine Online-Unterhaltungsplattform, auf der Kinder ihrer Fantasie freien Lauf lassen und gemeinsam in immersiven, von unseren Benutzern erschaffenen 3D-Welten spielen und Inhalte erstellen können. Unsere Plattform bietet auch ein kostenloses Entwickler-Tool namens „Roblox Studio“, mit dem Benutzer alles in ihrer Vorstellungskraft entwickeln können: von simplen Drag-and-Drop-Konstruktionen bis hin zu komplexen Mehrspielerspielen. Millionen von Kindern nutzen Roblox, um selbst zu erleben, wie es sich anfühlt, den ultimativen Vergnügungspark zu bauen, als professioneller Rennfahrer anzutreten, bei einer Modenschau zu glänzen oder einfach nur ein Traumhaus zu bauen und sich dort mit Freunden zu treffen.{lineBreak}{lineBreak}Durch diese E-Mail möchten wir Ihnen mitteilen, dass Ihr Kind seinen Benutzernamen, Geburtstag und die E-Mail-Adresse seiner Eltern angegeben hat. Die E-Mail-Adresse der Eltern wird nur verwendet, um das Konto zu verwalten, vergessene Passwörter zurückzusetzen und die Eltern darüber zu benachrichtigen, wenn sich der Kontozugriff des Kinds ändert. Um Ihre E-Mail-Adresse zu verifizieren, klicken Sie bitte auf die Schaltfläche unten:{lineBreak}{lineBreak}{verificationLink}{lineBreak}{lineBreak}Über Roblox{lineBreak}{lineBreak}Roblox setzt sich dafür ein, eine unterhaltsame, familienfreundliche Umgebung bereitzustellen. Wir verbessern unsere Sicherheitsmaßnahmen fortwährend und arbeiten mit Experten für digitale Sicherheit zusammen, um dafür zu sorgen, dass allen Spielern ein sicherer, angenehmer Ort zum Spielen und Chatten sowie für gemeinsame, kreative Projekte zur Verfügung steht. Wir empfehlen Ihnen, unseren Elternratgeber zu lesen, um sich mit unserer Plattform vertraut zu machen. Dort finden Sie auch hilfreiche Tipps, mit denen Sie ein positives Erlebnis für Ihre Kinder auf Roblox gewährleisten können: {parentalPageLink}{lineBreak}{lineBreak}Roblox bietet auch Jugendschutzeinstellungen. Eltern können eine Eltern-PIN aktivieren und die Kommunikations- und Chateinstellungen für ihre Kinder anpassen. Diese Einstellungen finden Sie in den Reitern für Sicherheit und Datenschutz in den Kontoeinstellungen, während Sie beim Konto Ihres Kindes angemeldet sind.{lineBreak}{lineBreak}Um eine Eltern-PIN hinzuzufügen, besuchen Sie bitte: {accountSecurityLink}{lineBreak}{lineBreak}Um die Chateinstellungen anzupassen, besuchen Sie bitte: {chatPrivacyLink}{lineBreak}{lineBreak}Datenschutz{lineBreak}{lineBreak}Sie können das Konto deines Kindes entfernen, indem Sie den Kundenservice hier kontaktieren: {supportPageLink}. Ihre E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von Ihrem Kind erhalten haben, verknüpft. Weitere Informationen können Sie unseren Datenschutzrichtlinien hier entnehmen: {privacyPageLink}{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team{lineBreak}Bitte antworten Sie nicht direkt auf diese E-Mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	/// <summary>
	/// Key: "Description.VerificationEmail.PlainBody.Under13.Part2"
	/// Email body of verification email that is sent out when an under 13 user adds an email to the account part 2
	/// English String: "To change chat settings, please visit: {chatPrivacyLink} {lineBreak}{lineBreak}Privacy{lineBreak}{lineBreak} You may remove your child's account by contacting customer service at {supportPageLink}. Your email will not be used for any other purpose, disclosed to third parties, or combined with any other personal information collected from your child. Please review our privacy policy for more information at {privacyPageLink}.{lineBreak}{lineBreak}Thank you,{lineBreak}{lineBreak}The Roblox Team{lineBreak}Do not reply to this email directly.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}"
	/// </summary>
	public override string DescriptionVerificationEmailPlainBodyUnder13Part2(string chatPrivacyLink, string lineBreak, string supportPageLink, string privacyPageLink, string robloxWebiteLink)
	{
		return $"Um die Chateinstellungen anzupassen, besuchen Sie bitte: {chatPrivacyLink} {lineBreak}{lineBreak}Datenschutz{lineBreak}{lineBreak}Sie können das Konto Ihres Kindes löschen, indem Sie den Kundenservice hier kontaktieren: {supportPageLink}. Ihre E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von Ihrem Kind erhalten haben, verknüpft. Weitere Informationen können Sie unseren Datenschutzrichtlinien hier entnehmen: {privacyPageLink}.{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team{lineBreak}Bitte antworten Sie nicht direkt auf diese E-Mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailPlainBodyUnder13Part2()
	{
		return "Um die Chateinstellungen anzupassen, besuchen Sie bitte: {chatPrivacyLink} {lineBreak}{lineBreak}Datenschutz{lineBreak}{lineBreak}Sie können das Konto Ihres Kindes löschen, indem Sie den Kundenservice hier kontaktieren: {supportPageLink}. Ihre E-Mail-Adresse wird zu keinen anderen Zwecken verwendet und nicht an Dritte weitergegeben oder mit anderen persönlichen Daten, die wir von Ihrem Kind erhalten haben, verknüpft. Weitere Informationen können Sie unseren Datenschutzrichtlinien hier entnehmen: {privacyPageLink}.{lineBreak}{lineBreak}Vielen Dank{lineBreak}{lineBreak}Das Roblox-Team{lineBreak}Bitte antworten Sie nicht direkt auf diese E-Mail.{lineBreak}{robloxWebiteLink}{lineBreak}{supportPageLink}";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectOver13()
	{
		return "Roblox-E-Mail-Verifizierung";
	}

	protected override string _GetTemplateForDescriptionVerificationEmailSubjectUnder13()
	{
		return "Roblox-Kontoautorisierung";
	}

	protected override string _GetTemplateForExampleDescription()
	{
		return "Beschreibe dich (max. 1000 Zeichen)";
	}

	protected override string _GetTemplateForExampleFacebook()
	{
		return "z.\u00a0B. www.facebook.com/Roblox";
	}

	protected override string _GetTemplateForExampleGooglePlus()
	{
		return "z. B. http://plus.google.com/profileId";
	}

	protected override string _GetTemplateForExampleTwitch()
	{
		return "z.\u00a0B. www.twitch.tv/roblox/profile";
	}

	protected override string _GetTemplateForExampleTwitter()
	{
		return "z.\u00a0B. @Roblox";
	}

	protected override string _GetTemplateForExampleYouTube()
	{
		return "z.\u00a0B. www.youtube.com/user/roblox";
	}

	protected override string _GetTemplateForHeadingAccountControls()
	{
		return "Was ist die Kontosteuerung?";
	}

	protected override string _GetTemplateForHeadingAccountInfo()
	{
		return "Kontodetails";
	}

	protected override string _GetTemplateForHeadingBilling()
	{
		return "Zahlungen";
	}

	protected override string _GetTemplateForHeadingBlockedUsers()
	{
		return "Gesperrte Benutzer";
	}

	protected override string _GetTemplateForHeadingContactSettings()
	{
		return "Kontakteinstellungen";
	}

	protected override string _GetTemplateForHeadingDesktopPush()
	{
		return "Desktop-Push-Benachrichtigung";
	}

	protected override string _GetTemplateForHeadingDialogAddPassword()
	{
		return "Passwort hinzufügen";
	}

	protected override string _GetTemplateForHeadingDialogAddPhone()
	{
		return "Handy hinzufügen";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmail()
	{
		return "Meine E-Mail-Adresse ändern";
	}

	protected override string _GetTemplateForHeadingDialogChangeEmailConfirmation()
	{
		return "E-Mail-Adresse geändert";
	}

	protected override string _GetTemplateForHeadingDialogChangePassword()
	{
		return "Passwort ändern";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordConfirmation()
	{
		return "Erfolg";
	}

	protected override string _GetTemplateForHeadingDialogChangePasswordSuccess()
	{
		return "Erfolg";
	}

	protected override string _GetTemplateForHeadingDialogChangeUsername()
	{
		return "Benutzernamen ändern";
	}

	protected override string _GetTemplateForHeadingDialogDefaultError()
	{
		return "Fehler";
	}

	protected override string _GetTemplateForHeadingDialogDefaultSuccess()
	{
		return "Erfolg";
	}

	protected override string _GetTemplateForHeadingDialogEditPhone()
	{
		return "Handy bearbeiten";
	}

	protected override string _GetTemplateForHeadingDialogInsufficientFunds()
	{
		return "Nicht genügend Guthaben";
	}

	protected override string _GetTemplateForHeadingDialogInvalidUsername()
	{
		return "Ungültiger Benutzername";
	}

	protected override string _GetTemplateForHeadingDialogPinCreate()
	{
		return "PIN hinzufügen";
	}

	protected override string _GetTemplateForHeadingDialogPinCreateSuccessConfirmation()
	{
		return "Erfolg";
	}

	protected override string _GetTemplateForHeadingDialogPinUnlock()
	{
		return "Konto-PIN erforderlich";
	}

	protected override string _GetTemplateForHeadingDialogRemovePhone()
	{
		return "Handy entfernen";
	}

	protected override string _GetTemplateForHeadingDialogVerifiedEmailRequired()
	{
		return "Verifizierte E-Mail-Adresse erforderlich";
	}

	protected override string _GetTemplateForHeadingDialogVerifyEmail()
	{
		return "E-Mail-Adresse verifizieren";
	}

	protected override string _GetTemplateForHeadingDialogVerifyPhone()
	{
		return "Handy verifizieren";
	}

	protected override string _GetTemplateForHeadingFastTrack()
	{
		return "Expressmeldung";
	}

	protected override string _GetTemplateForHeadingMembershipStatus()
	{
		return "Mitgliedschaftsstatus";
	}

	protected override string _GetTemplateForHeadingNotificationOptions()
	{
		return "Ich möchte eine Benachrichtigung, wenn:";
	}

	protected override string _GetTemplateForHeadingNotifications()
	{
		return "Benachrichtigungen";
	}

	protected override string _GetTemplateForHeadingNotificationsActionWhen()
	{
		return "Ich möchte eine Benachrichtigung, wenn:";
	}

	protected override string _GetTemplateForHeadingNotificationsDesktopPush()
	{
		return "Desktop-Push-Benachrichtigung";
	}

	protected override string _GetTemplateForHeadingNotificationsMobilePush()
	{
		return "Mobilgerät-Push-Benachrichtigung";
	}

	protected override string _GetTemplateForHeadingNotificationsStream()
	{
		return "Benachrichtigungs-Stream";
	}

	protected override string _GetTemplateForHeadingNotificationStream()
	{
		return "Benachrichtigungs-Stream";
	}

	protected override string _GetTemplateForHeadingOtherSettings()
	{
		return "Weitere Einstellungen";
	}

	protected override string _GetTemplateForHeadingPageTitle()
	{
		return "Meine Einstellungen";
	}

	protected override string _GetTemplateForHeadingPersonal()
	{
		return "Persönliches";
	}

	protected override string _GetTemplateForHeadingPin()
	{
		return "Konto-PIN";
	}

	protected override string _GetTemplateForHeadingPrivacySettings()
	{
		return "Datenschutzeinstellungen";
	}

	protected override string _GetTemplateForHeadingRenevalDate()
	{
		return "Verlängerungsdatum";
	}

	protected override string _GetTemplateForHeadingRestrictions()
	{
		return "Kontoeinschränkungen";
	}

	protected override string _GetTemplateForHeadingSecureSignOut()
	{
		return "Sicher abmelden";
	}

	protected override string _GetTemplateForHeadingSocialNetworks()
	{
		return "Soziale Netzwerke";
	}

	protected override string _GetTemplateForHeadingSocialSignOn()
	{
		return "Über soziales Netzwerk anmelden";
	}

	protected override string _GetTemplateForHeadingSuccessDialogTitle()
	{
		return "Erfolg";
	}

	protected override string _GetTemplateForHeadingTabAccountInfo()
	{
		return "Kontodetails";
	}

	protected override string _GetTemplateForHeadingTabBilling()
	{
		return "Zahlungen";
	}

	protected override string _GetTemplateForHeadingTabFastTrack()
	{
		return "Expressmeldung";
	}

	protected override string _GetTemplateForHeadingTabNotifications()
	{
		return "Benachrichtigungen";
	}

	protected override string _GetTemplateForHeadingTabPrivacy()
	{
		return "Datenschutz";
	}

	protected override string _GetTemplateForHeadingTabSecurity()
	{
		return "Sicherheit";
	}

	protected override string _GetTemplateForHeadingTransactions()
	{
		return "Transaktionen";
	}

	protected override string _GetTemplateForHeadingTwoStepVerification()
	{
		return "Verifizierung in 2 Schritten";
	}

	protected override string _GetTemplateForHeadingXbox()
	{
		return "Xbox";
	}

	protected override string _GetTemplateForLabelAccountPinDisabled()
	{
		return "Konto-PIN ist derzeit deaktiviert";
	}

	protected override string _GetTemplateForLabelAccountPinEnabled()
	{
		return "Konto-PIN ist derzeit aktiviert";
	}

	protected override string _GetTemplateForLabelAccountRestrictionDisabled()
	{
		return "Kontoeinschränkungen sind derzeit deaktiviert";
	}

	protected override string _GetTemplateForLabelAccountRestrictionEnabled()
	{
		return "Kontoeinschränkungen sind derzeit aktiviert";
	}

	protected override string _GetTemplateForLabelAddEmail()
	{
		return "E-Mail-Adresse hinzufügen";
	}

	protected override string _GetTemplateForLabelAddEmailParent()
	{
		return "E-Mail-Adresse deiner Eltern";
	}

	protected override string _GetTemplateForLabelAddPassword()
	{
		return "Passwort hinzufügen:";
	}

	protected override string _GetTemplateForLabelAddPhone()
	{
		return "Handy hinzufügen";
	}

	protected override string _GetTemplateForLabelAddPhoneLink()
	{
		return "Handy hinzufügen";
	}

	protected override string _GetTemplateForLabelBillingHelp()
	{
		return "Für Fragen zu Zahlungen:";
	}

	/// <summary>
	/// Key: "Label.BillingHelpWithLink"
	/// English String: "For billing and payment questions, please see the {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}billing help pages{aTagEnd}."
	/// </summary>
	public override string LabelBillingHelpWithLink(string aTagStartWithHref, string billingHelpPagesLink, string hrefEnd, string aTagEnd)
	{
		return $"Für Fragen zu Zahlungen besuche bitte die {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}Hilfeseiten zu Zahlungen{aTagEnd}.";
	}

	protected override string _GetTemplateForLabelBillingHelpWithLink()
	{
		return "Für Fragen zu Zahlungen besuche bitte die {aTagStartWithHref}{billingHelpPagesLink}{hrefEnd}Hilfeseiten zu Zahlungen{aTagEnd}.";
	}

	/// <summary>
	/// Key: "Label.BillingHistoryCardNumber"
	/// English String: "Ending in {lastFourCard}"
	/// </summary>
	public override string LabelBillingHistoryCardNumber(string lastFourCard)
	{
		return $"Endet mit {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCardNumber()
	{
		return "Endet mit {lastFourCard}";
	}

	protected override string _GetTemplateForLabelBillingHistoryCost()
	{
		return "Preis";
	}

	protected override string _GetTemplateForLabelBillingHistoryDate()
	{
		return "Datum";
	}

	protected override string _GetTemplateForLabelBillingHistoryDescription()
	{
		return "Beschreibung";
	}

	protected override string _GetTemplateForLabelBillingHistoryGeneralErrors()
	{
		return "Dienst ist derzeit deaktiviert. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForLabelBillingHistoryNoTransactions()
	{
		return "Keine Transaktionen";
	}

	protected override string _GetTemplateForLabelBillingHistoryPaymentType()
	{
		return "Bezahlungsart";
	}

	protected override string _GetTemplateForLabelBirthday()
	{
		return "Geburtstag";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	/// <summary>
	/// Key: "Label.BuildersClubJoin"
	/// English String: "You're not a member yet. Join {startSpan}Builders Club{endSpan} today!"
	/// </summary>
	public override string LabelBuildersClubJoin(string startSpan, string endSpan)
	{
		return $"Du bist noch kein Mitglied. Tritt gleich dem {startSpan}Builders Club{endSpan} bei!";
	}

	protected override string _GetTemplateForLabelBuildersClubJoin()
	{
		return "Du bist noch kein Mitglied. Tritt gleich dem {startSpan}Builders Club{endSpan} bei!";
	}

	protected override string _GetTemplateForLabelChangeYourUsername()
	{
		return "Ändere deinen Benutzernamen";
	}

	protected override string _GetTemplateForLabelChooseLanguage()
	{
		return "Sprache wählen";
	}

	protected override string _GetTemplateForLabelClassicTheme()
	{
		return "Aus";
	}

	protected override string _GetTemplateForLabelConnectAccount()
	{
		return "Konto verbinden:";
	}

	protected override string _GetTemplateForLabelCountry()
	{
		return "Land/Region wählen";
	}

	protected override string _GetTemplateForLabelCountryTitle()
	{
		return "Standort";
	}

	protected override string _GetTemplateForLabelDarkTheme()
	{
		return "Dunkel";
	}

	protected override string _GetTemplateForLabelDialogAddEmailOver13()
	{
		return "Meine E-Mail-Adresse hinzufügen";
	}

	protected override string _GetTemplateForLabelDialogAddEmailUnder13()
	{
		return "E-Mail-Adresse deiner Eltern hinzufügen";
	}

	protected override string _GetTemplateForLabelDialogAddPhoneField()
	{
		return "Handynummer";
	}

	protected override string _GetTemplateForLabelDialogAddPhonePassword()
	{
		return "Kontopasswort verifizieren";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailField()
	{
		return "Meine E-Mail-Adresse ändern";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailOver13()
	{
		return "Meine E-Mail-Adresse ändern";
	}

	protected override string _GetTemplateForLabelDialogChangeEmailUnder13()
	{
		return "E-Mail-Adresse deiner Eltern ändern";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordConfirm()
	{
		return "Passwort bestätigen";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordCurrent()
	{
		return "Aktuelles Passwort";
	}

	protected override string _GetTemplateForLabelDialogChangePasswordNew()
	{
		return "Neues Passwort";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameAccountPassword()
	{
		return "Kontopasswort";
	}

	protected override string _GetTemplateForLabelDialogChangeUsernameField()
	{
		return "Gewünschter Benutzername (3-20 Zeichen)";
	}

	protected override string _GetTemplateForLabelDialogConfirmPin()
	{
		return "Bestätige deine PIN";
	}

	/// <summary>
	/// Key: "Label.Dialog.CreatePin"
	/// English String: "Create a {digitCount}-digit PIN"
	/// </summary>
	public override string LabelDialogCreatePin(string digitCount)
	{
		return $"Erstelle eine {digitCount}-stellige PIN";
	}

	protected override string _GetTemplateForLabelDialogCreatePin()
	{
		return "Erstelle eine {digitCount}-stellige PIN";
	}

	protected override string _GetTemplateForLabelDialogEditPhoneCurrentNumber()
	{
		return "Aktuelle Nummer:";
	}

	protected override string _GetTemplateForLabelDialogEmailAddressChanged()
	{
		return "E-Mail-Adresse geändert";
	}

	protected override string _GetTemplateForLabelDialogEmailRequired()
	{
		return "E-Mail-Adresse erforderlich";
	}

	protected override string _GetTemplateForLabelDialogVerifiedEmail()
	{
		return "Verifizierte E-Mail-Adresse:";
	}

	protected override string _GetTemplateForLabelDialogVerifyPassword()
	{
		return "Kontopasswort verifizieren";
	}

	/// <summary>
	/// Key: "Label.Dialog.VerifyPhoneCode"
	/// English String: "Enter Code ({digitCount}-digit)"
	/// </summary>
	public override string LabelDialogVerifyPhoneCode(string digitCount)
	{
		return $"Code eingeben ({digitCount}-stellig)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCode()
	{
		return "Code eingeben ({digitCount}-stellig)";
	}

	protected override string _GetTemplateForLabelDialogVerifyPhoneCodeLabel()
	{
		return "Gib den Code ein, den wir dir gerade an dein Handy geschickt haben.";
	}

	protected override string _GetTemplateForLabelDialogVerifySms()
	{
		return "SMS verifizieren";
	}

	protected override string _GetTemplateForLabelDropDownCustom()
	{
		return "Benutzerdefiniert";
	}

	protected override string _GetTemplateForLabelDropDownDefault()
	{
		return "Standard";
	}

	protected override string _GetTemplateForLabelDropDownEveryone()
	{
		return "Jeder";
	}

	protected override string _GetTemplateForLabelDropDownFollowers()
	{
		return "Freunde, Benutzer, denen ich folge, sowie Follower";
	}

	protected override string _GetTemplateForLabelDropDownFollowing()
	{
		return "Freunde sowie Benutzer, denen ich folge";
	}

	protected override string _GetTemplateForLabelDropDownFriends()
	{
		return "Freunde";
	}

	protected override string _GetTemplateForLabelDropDownHigh()
	{
		return "Hoch";
	}

	protected override string _GetTemplateForLabelDropDownLow()
	{
		return "Niedrig";
	}

	protected override string _GetTemplateForLabelDropDownMedium()
	{
		return "Mittel";
	}

	protected override string _GetTemplateForLabelDropDownNone()
	{
		return "Keine Auswahl";
	}

	protected override string _GetTemplateForLabelDropDownNoOne()
	{
		return "Niemand";
	}

	protected override string _GetTemplateForLabelDropDownOff()
	{
		return "Aus";
	}

	protected override string _GetTemplateForLabelEmail()
	{
		return "E-Mail-Adresse:";
	}

	protected override string _GetTemplateForLabelEmailParent()
	{
		return "E-Mail-Adresse deiner Eltern:";
	}

	protected override string _GetTemplateForLabelEmailVerificationPending()
	{
		return "Verifizierung steht noch aus";
	}

	protected override string _GetTemplateForLabelExpirationDate()
	{
		return "Ablaufdatum";
	}

	/// <summary>
	/// Key: "Label.ExpirationDateMessage"
	/// English String: "Expires on {startSpan}{expirationDate}{endSpan}"
	/// </summary>
	public override string LabelExpirationDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Läuft am {startSpan}{expirationDate}{endSpan} ab";
	}

	protected override string _GetTemplateForLabelExpirationDateMessage()
	{
		return "Läuft am {startSpan}{expirationDate}{endSpan} ab";
	}

	protected override string _GetTemplateForLabelFacebook()
	{
		return "Facebook:";
	}

	protected override string _GetTemplateForLabelFastTrackAccuracy()
	{
		return "Genauigkeit";
	}

	protected override string _GetTemplateForLabelFastTrackAllFastTrackMembers()
	{
		return "Jeder";
	}

	protected override string _GetTemplateForLabelFastTrackReportMonth()
	{
		return "Monat";
	}

	protected override string _GetTemplateForLabelFastTrackReportYear()
	{
		return "Jahr";
	}

	protected override string _GetTemplateForLabelFastTrackStatistics()
	{
		return "Statistiken";
	}

	protected override string _GetTemplateForLabelFastTrackYou()
	{
		return "Du";
	}

	protected override string _GetTemplateForLabelGender()
	{
		return "Geschlecht";
	}

	protected override string _GetTemplateForLabelGooglePlus()
	{
		return "Google+:";
	}

	protected override string _GetTemplateForLabelLightTheme()
	{
		return "Hell";
	}

	protected override string _GetTemplateForLabelLocaleTitle()
	{
		return "Sprache";
	}

	/// <summary>
	/// Key: "Label.MembershipName"
	/// English String: "{startSpan}Builders Club{endSpan} membership"
	/// </summary>
	public override string LabelMembershipName(string startSpan, string endSpan)
	{
		return $"{startSpan}„Builders Club“{endSpan}-Mitgliedschaft";
	}

	protected override string _GetTemplateForLabelMembershipName()
	{
		return "{startSpan}„Builders Club“{endSpan}-Mitgliedschaft";
	}

	protected override string _GetTemplateForLabelMembershipStatusRobloxPremium()
	{
		return "Du bist noch kein Mitglied. Tritt Roblox-Premium heute bei!";
	}

	protected override string _GetTemplateForLabelNotificationsAddedToPrivateServer()
	{
		return "Ich auf einen VIP-Server eingeladen werde";
	}

	protected override string _GetTemplateForLabelNotificationsChat()
	{
		return "Jemand mit mir chattet";
	}

	protected override string _GetTemplateForLabelNotificationsConversationUniverseChanged()
	{
		return "Jemand ein neues Spiel zum gemeinsamen Spielen anheftet";
	}

	protected override string _GetTemplateForLabelNotificationsDeveloperMetricsAvailable()
	{
		return "Analysebericht wird verfügbar";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestAccepted()
	{
		return "Jemand meine Freundesanfrage annimmt";
	}

	protected override string _GetTemplateForLabelNotificationsFriendRequestReceived()
	{
		return "Ich eine Freundesanfrage erhalte";
	}

	protected override string _GetTemplateForLabelNotificationsGameUpdate()
	{
		return "Benachrichtigungen über Updates erhalten";
	}

	protected override string _GetTemplateForLabelNotificationsPartyInvited()
	{
		return "Jemand mich in ein Team einlädt";
	}

	protected override string _GetTemplateForLabelNotificationsPartyJoined()
	{
		return "Jemand einem Team beitritt, in dem ich bin";
	}

	protected override string _GetTemplateForLabelNotificationsPrivateMessage()
	{
		return "Ich eine private Nachricht erhalte";
	}

	protected override string _GetTemplateForLabelNotificationsTeamCreateInvite()
	{
		return "Jemand mich zum Bearbeiten eines Spiels einlädt";
	}

	protected override string _GetTemplateForLabelPassword()
	{
		return "Passwort:";
	}

	protected override string _GetTemplateForLabelPhone()
	{
		return "Handynummer:";
	}

	protected override string _GetTemplateForLabelPinTimeMins()
	{
		return "Min.";
	}

	protected override string _GetTemplateForLabelPinTimeRemaining()
	{
		return "Verbleibende Zeit";
	}

	protected override string _GetTemplateForLabelPinTimeSecs()
	{
		return "Sek.";
	}

	/// <summary>
	/// Key: "Label.PremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelPremiumClub(string amount)
	{
		return $"Roblox-Premium {amount}";
	}

	protected override string _GetTemplateForLabelPremiumClub()
	{
		return "Roblox-Premium {amount}";
	}

	protected override string _GetTemplateForLabelPreviousUsernames()
	{
		return "Vorherige Benutzernamen:";
	}

	protected override string _GetTemplateForLabelPrivacyMode()
	{
		return "Datenschutzmodus";
	}

	protected override string _GetTemplateForLabelRenevalDate()
	{
		return "Verlängerungsdatum";
	}

	/// <summary>
	/// Key: "Label.RenevalDateMessage"
	/// English String: "Automatically renew on {startSpan}{expirationDate}{endSpan}."
	/// </summary>
	public override string LabelRenevalDateMessage(string startSpan, string expirationDate, string endSpan)
	{
		return $"Automatische Verlängerung am {startSpan}{expirationDate}{endSpan}.";
	}

	protected override string _GetTemplateForLabelRenevalDateMessage()
	{
		return "Automatische Verlängerung am {startSpan}{expirationDate}{endSpan}.";
	}

	/// <summary>
	/// Key: "Label.RobloxPremiumClub"
	/// English String: "Roblox Premium {amount}"
	/// </summary>
	public override string LabelRobloxPremiumClub(string amount)
	{
		return $"Roblox-Premium {amount}";
	}

	protected override string _GetTemplateForLabelRobloxPremiumClub()
	{
		return "Roblox-Premium {amount}";
	}

	/// <summary>
	/// Key: "Label.RobuxProductName"
	/// The robux package name
	/// English String: "{amount} Robux"
	/// </summary>
	public override string LabelRobuxProductName(string amount)
	{
		return $"{amount} Robux";
	}

	protected override string _GetTemplateForLabelRobuxProductName()
	{
		return "{amount} Robux";
	}

	protected override string _GetTemplateForLabelSignOutAllSessions()
	{
		return "Von allen anderen Sitzungen abmelden";
	}

	protected override string _GetTemplateForLabelSocialLinksVisibility()
	{
		return "Wer kann mich sehen?";
	}

	/// <summary>
	/// Key: "Label.SocialUsername"
	/// English String: "Connected as {socialUsername}"
	/// </summary>
	public override string LabelSocialUsername(string socialUsername)
	{
		return $"Verbunden als {socialUsername}";
	}

	protected override string _GetTemplateForLabelSocialUsername()
	{
		return "Verbunden als {socialUsername}";
	}

	protected override string _GetTemplateForLabelThemeTitle()
	{
		return "Thema";
	}

	protected override string _GetTemplateForLabelToolTipContactSettings()
	{
		return "Benutzerdefiniert\u00a0– Lege deine Einstellungen selbst fest. Standard\u00a0– Ermöglicht Chats und Nachrichten mit Freunden. Aus\u00a0– Deaktiviert Chats und Nachrichten.";
	}

	protected override string _GetTemplateForLabelToolTipPinLocked()
	{
		return "Alle Einstellungen sind gesperrt. Entsperre sie mit deiner PIN, um sie zu bearbeiten.";
	}

	protected override string _GetTemplateForLabelToolTipPinUnlocked()
	{
		return "Klicke, um deine Einstellungsseite zu sperren";
	}

	protected override string _GetTemplateForLabelToolTipPrivacyMode()
	{
		return "Klicke hier für weitere Infos";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInApp()
	{
		return "Diese Einstellung bestimmt, mit wem dieser Benutzer in der App und im Internet (nicht im Spiel selbst) chatten darf. Mit dieser Einstellung wird zudem verhindert, dass dieser Benutzer in Foren und auf Gruppenpinnwänden posten kann.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanChatInGame()
	{
		return "Diese Einstellung bestimmt, mit wem dieser Benutzer im Spiel chatten darf.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanFindMeByPhone()
	{
		return "Mit dieser Einstellung kannst du festlegen, wer dich über die von dir angegebene Handynummer finden kann.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanInviteVIP()
	{
		return "Diese Einstellung bestimmt, wer mit diesem Benutzer auf VIP-Servern spielen darf. Diese Server können nur über eine Einladung des Serverbesitzers betreten werden.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanJoinGame()
	{
		return "Diese Einstellung bestimmt, wer sehen kann, in welchem Spiel ich mich befinde und wer meinen Server betreten darf. Wenn ich „Niemand“ auswähle, bedeutet dies, dass mir niemand auf den von mir festgelegten Server folgen kann. Ich kann jedoch mit anderen Benutzern spielen.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanMessageMe()
	{
		return "Diese Einstellung bestimmt, von wem dieser Benutzer Nachrichten in seinem Posteingang erhalten kann.";
	}

	protected override string _GetTemplateForLabelToolTipWhoCanSeeInventory()
	{
		return "Diese Einstellung bestimmt, wer dein Inventar sehen kann.";
	}

	protected override string _GetTemplateForLabelTradeFilter()
	{
		return "Filter für Handelsqualität";
	}

	protected override string _GetTemplateForLabelTwitch()
	{
		return "Twitch";
	}

	protected override string _GetTemplateForLabelTwitter()
	{
		return "Twitter:";
	}

	protected override string _GetTemplateForLabelTwoStepEmail()
	{
		return "Verifizierung in 2 Schritten aktivieren";
	}

	protected override string _GetTemplateForLabelTwoStepPrerequisite()
	{
		return "Eine verifizierte E-Mail-Adresse ist erforderlich.";
	}

	protected override string _GetTemplateForLabelTwoStepVerification()
	{
		return "Mach dein Konto sicherer. Wenn du dich von einem neuen Gerät aus anmeldest, benötigst du einen Code.";
	}

	protected override string _GetTemplateForLabelTwoStepVerificationEnabled()
	{
		return "Dein Konto ist geschützt!";
	}

	protected override string _GetTemplateForLabelUpdateEmail()
	{
		return "E-Mail-Adresse aktualisieren";
	}

	protected override string _GetTemplateForLabelUpdatePhone()
	{
		return "Handy aktualisieren";
	}

	protected override string _GetTemplateForLabelUseDeviceLanguage()
	{
		return "Gerätesprache verwenden";
	}

	protected override string _GetTemplateForLabelUsername()
	{
		return "Benutzername:";
	}

	protected override string _GetTemplateForLabelVerified()
	{
		return "Verifiziert";
	}

	protected override string _GetTemplateForLabelVerify()
	{
		return "Verifizieren";
	}

	protected override string _GetTemplateForLabelWhoCanChatInApp()
	{
		return "Wer kann in der App mit mir chatten?";
	}

	protected override string _GetTemplateForLabelWhoCanChatInGame()
	{
		return "Wer kann mit mir chatten?";
	}

	protected override string _GetTemplateForLabelWhoCanFindMeByPhone()
	{
		return "Wer kann mich über meine Handynummer finden?";
	}

	protected override string _GetTemplateForLabelWhoCanInviteVIP()
	{
		return "Wer kann mich auf VIP-Server einladen?";
	}

	protected override string _GetTemplateForLabelWhoCanJoinGame()
	{
		return "Wer kann mitmachen?";
	}

	protected override string _GetTemplateForLabelWhoCanMessageMe()
	{
		return "Wer kann mir Nachrichten schreiben?";
	}

	protected override string _GetTemplateForLabelWhoCanSeeInventory()
	{
		return "Wer kann mein Inventar sehen?";
	}

	protected override string _GetTemplateForLabelWhoCanTradeWithMe()
	{
		return "Wer kann mit mir handeln?";
	}

	protected override string _GetTemplateForLabelXboxConnected()
	{
		return "Mit einem Xbox-Konto verbunden";
	}

	protected override string _GetTemplateForLabelYouTube()
	{
		return "YouTube:";
	}

	protected override string _GetTemplateForLabelInsufficientRobux()
	{
		return "Nicht genügend Robux";
	}

	protected override string _GetTemplateForMessageErrorAccountHasPin()
	{
		return "Das Konto hat bereits eine PIN. Versuche eine andere Anfrage zu stellen.";
	}

	protected override string _GetTemplateForMessageErrorAccountLocked()
	{
		return "Das Konto ist gesperrt. Entsperre das Konto, bevor du die Handlung durchführst.";
	}

	protected override string _GetTemplateForMessageErrorDefault()
	{
		return "Ein Problem ist aufgetreten. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageErrorEmailAlreadyVerified()
	{
		return "Diese E-Mail-Adresse ist bereits verifiziert.";
	}

	protected override string _GetTemplateForMessageErrorEmailFeatureDisabled()
	{
		return "Dieses Feature ist zur Zeit deaktiviert. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageErrorEmailIncorrectPassword()
	{
		return "Passwort ist falsch.";
	}

	protected override string _GetTemplateForMessageErrorEmailInvalidEmail()
	{
		return "Ungültige E-Mail-Adresse.";
	}

	protected override string _GetTemplateForMessageErrorEmailNoEmailAssociated()
	{
		return "Diesem Konto ist keine E-Mail-Adresse zugeordnet.";
	}

	protected override string _GetTemplateForMessageErrorEmailPinLocked()
	{
		return "PIN ist gesperrt.";
	}

	protected override string _GetTemplateForMessageErrorEmailSameEmail()
	{
		return "Dies ist bereits die aktuelle E-Mail-Adresse.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyAccounts()
	{
		return "Dieser E-Mail-Adresse sind zu viele Konten zugeordnet.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyUpdates()
	{
		return "Zu viele Versuche, die E-Mail-Adresse zu aktualisieren. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageErrorEmailTooManyVerify()
	{
		return "Zu viele Versuche, die E-Mail zur Verifizierung zu senden. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageErrorEmailUnknown()
	{
		return "Ein unbekannter Fehler ist aufgetreten.";
	}

	protected override string _GetTemplateForMessageErrorIncorrectPin()
	{
		return "Falsche PIN.";
	}

	protected override string _GetTemplateForMessageErrorInvalidPinFormat()
	{
		return "Ungültiges PIN-Format.";
	}

	protected override string _GetTemplateForMessageErrorNoPin()
	{
		return "Für das Konto existiert keine PIN.";
	}

	protected override string _GetTemplateForMessageErrorNoVerifiedEmail()
	{
		return "Das Konto hat keine verifizierte E-Mail-Adresse.";
	}

	protected override string _GetTemplateForMessageErrorSystem()
	{
		return "Systemfehler.";
	}

	protected override string _GetTemplateForMessageErrorTooManyRequests()
	{
		return "Zu viele Anfragen gestellt. Versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageEmailAddSuccess()
	{
		return "E-Mail-Adresse hinzugefügt";
	}

	protected override string _GetTemplateForMessageEmailAlreadyVerifiedError()
	{
		return "Deine E-Mail-Adresse wurde bereits verifiziert!";
	}

	protected override string _GetTemplateForMessageFeatureDisabledError()
	{
		return "Dieses Feature ist derzeit deaktiviert. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageInsufficientRobuxErrorForUserName()
	{
		return "Du hast nicht genügend Robux, um deinen Benutzernamen zu ändern.";
	}

	protected override string _GetTemplateForMessageInvalidEmail()
	{
		return "Ungültige E-Mail-Adresse";
	}

	protected override string _GetTemplateForMessageNoEmailAssociatedError()
	{
		return "Du musst deinem Konto eine E-Mail-Adresse zuordnen.";
	}

	protected override string _GetTemplateForMessagePermissionError()
	{
		return "Du hast nicht genügend Robux, um deinen Benutzernamen zu ändern.";
	}

	protected override string _GetTemplateForMessagePinLockedError()
	{
		return "PIN ist gesperrt.";
	}

	protected override string _GetTemplateForMessageSameEmailError()
	{
		return "Dies ist bereits die aktuelle, verifizierte E-Mail-Adresse.";
	}

	protected override string _GetTemplateForMessageSettingsUpdateSuccess()
	{
		return "Deine Einstellungen wurden aktualisiert.";
	}

	protected override string _GetTemplateForMessageTooManyAccountsOnEmailError()
	{
		return "Dieser E-Mail-Adresse sind zu viele Konten zugeordnet.";
	}

	protected override string _GetTemplateForMessageTooManyAttemptsError()
	{
		return "Zu viele Versuche. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForMessageUnknownError()
	{
		return "Ein unbekannter Fehler ist aufgetreten.";
	}

	protected override string _GetTemplateForMessageWrongPassword()
	{
		return "Dein Passwort ist falsch.";
	}

	protected override string _GetTemplateForResponesInvalidCodePhone()
	{
		return "Code ist ungültig. Bitte überprüfe dein Handy und versuche es erneut.";
	}

	protected override string _GetTemplateForResponesInventoryAndTradePrivacyConflictError()
	{
		return "Der Wert bei „Wer kann mit mir handeln“ sollte im gleichen Maße oder eingeschränkter sein, als der Wert bei „Wer kann mein Inventar sehen“.";
	}

	protected override string _GetTemplateForResponseCodeRequired()
	{
		return "Ein Code ist erforderlich. Bitte gib deinen Code ein.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeDefaultWarning()
	{
		return "Wenn du dein Alter auf unter 13 Jahre änderst, kannst du das nicht mehr rückgängig machen. Möchtest du wirklich fortfahren?";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordBody()
	{
		return "Du musst ein Passwort zu deinem Roblox-Konto hinzufügen, um deinen Geburtstag ändern zu können.";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangePasswordTitle()
	{
		return "Passwort muss hinzugefügt werden";
	}

	protected override string _GetTemplateForResponseDialogBirthdayChangeSocialWarning()
	{
		return "Wenn du dein Alter auf unter 13 Jahre änderst, kannst du das nicht mehr rückgängig machen. Deine Anmeldung über das soziale Netzwerk Facebook wird deaktiviert und du musst dich mit deinem Roblox-Passwort anmelden.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordIncorrectPassword()
	{
		return "Dein aktuelles Passwort ist falsch, das Passwort wurde nicht geändert.";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordNoMatch()
	{
		return "Passwörter stimmen nicht überein";
	}

	protected override string _GetTemplateForResponseDialogChangePasswordTooShortError()
	{
		return "Muss mindestens 8 Zeichen lang sein";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNoInput()
	{
		return "Bitte gib einen Benutzernamen ein.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAllowed()
	{
		return "Der Benutzername ist nicht geeignet für Roblox.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameNotAvailable()
	{
		return "Dieser Benutzername wird bereits verwendet.";
	}

	protected override string _GetTemplateForResponseDialogChangeUsernameSuccess()
	{
		return "Benutzername wurde erfolgreich geändert.";
	}

	protected override string _GetTemplateForResponseDialogCountryListError()
	{
		return "Fehler beim Laden der Länderliste";
	}

	protected override string _GetTemplateForResponseDialogCurrencyServiceError()
	{
		return "Beim Währungssystem ist ein Fehler aufgetreten. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorMessage()
	{
		return "Etwas ist schiefgelaufen. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseDialogDefaultErrorTitle()
	{
		return "Fehler aufgetreten";
	}

	protected override string _GetTemplateForResponseDialogDefaultSuccessMessage()
	{
		return "Erfolgreich gespeichert!";
	}

	protected override string _GetTemplateForResponseDialogDisconnectXBoxError()
	{
		return "Beim Aufheben der Verbindung zu deinem Xbox-Konto ist ein Fehler aufgetreten. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseDialogEmailSentForVerification()
	{
		return "Wir haben dir eine E-Mail zur Verifizierung gesendet.";
	}

	protected override string _GetTemplateForResponseDialogInvalidEmailAddress()
	{
		return "Ungültige E-Mail-Adresse";
	}

	protected override string _GetTemplateForResponseDialogInvalidPhoneNumber()
	{
		return "Ungültige Handynummer";
	}

	protected override string _GetTemplateForResponseDialogInvalidUsername()
	{
		return "Wähle „Senden“, um das Ticket einzureichen oder „Abbrechen“, um den Benutzernamen zu bearbeiten. Bei deinem Benutzernamen handelt es sich um eine wichtige Information, durch die dein Problem schneller bearbeitet werden kann.";
	}

	protected override string _GetTemplateForResponseDialogPasswordRulesError()
	{
		return "Das Passwort muss mindestens 2 Ziffern, 4 Buchstaben und 1 Symbol enthalten und muss mindestens 8 Zeichen lang sein.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateConfirmation()
	{
		return "Deine PIN wurde festgelegt. Um in Zukunft auf deine Einstellungsseite zugreifen zu können, musst du diese PIN eingeben.";
	}

	protected override string _GetTemplateForResponseDialogPinCreateMismatch()
	{
		return "Die PINs stimmen nicht überein.";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionFailed()
	{
		return "Beim Abmelden von allen anderen Sitzungen ist ein Fehler aufgetreten. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseDialogSignoutSessionsConfirmation()
	{
		return "Du wurdest von allen anderen Sitzungen abgemeldet.";
	}

	protected override string _GetTemplateForResponseDialogTwoStepDisableWarning()
	{
		return "Wenn du die Verifizierung in 2 Schritten ausschaltest, benötigst du nur dein Passwort, um dich über ein neues Gerät anzumelden. Bist du dir sicher?";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSuccessTitle()
	{
		return "Verifizierung in 2 Schritten aktiviert";
	}

	protected override string _GetTemplateForResponseDialogTwoStepSucessBody()
	{
		return "Dein Konto ist jetzt geschützt! Derzeit sind keine weiteren Aktionen erforderlich. Wenn du dich das nächste Mal über ein neues Gerät anmeldest, senden wir dir einen Sicherheitscode.";
	}

	protected override string _GetTemplateForResponseDialogUpdateInventorySetting()
	{
		return "Wir haben deine Inventar-Datenschutzeinstellungen aktualisiert. Die Einstellungen für Inventar und Handel müssen übereinstimmen.";
	}

	protected override string _GetTemplateForResponseDialogUpdateNotificationSettingsError()
	{
		return "Beim Aktualisieren deiner Benachrichtigungseinstellungen ist ein Fehler aufgetreten. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseDialogUpdateTradeSetting()
	{
		return "Wir haben deine Handel-Datenschutzeinstellungen aktualisiert. Die Einstellungen für Inventar und Handel müssen übereinstimmen.";
	}

	protected override string _GetTemplateForResponseDialogVerifyPhoneInvalidCode()
	{
		return "Code ist ungültig. Bitte überprüfe dein Handy und versuche es erneut.";
	}

	protected override string _GetTemplateForResponseDialogWarning()
	{
		return "Warnung";
	}

	protected override string _GetTemplateForResponseFeatureDisabled()
	{
		return "Dieses Feature ist derzeit deaktiviert. Bitte versuche es später erneut.";
	}

	protected override string _GetTemplateForResponseGeneralError()
	{
		return "Ein Fehler ist aufgetreten. Bitte versuche es erneut.";
	}

	protected override string _GetTemplateForResponseIncorrectCodeTooManyTimes()
	{
		return "Du hast zu oft einen falschen Code eingegeben.";
	}

	protected override string _GetTemplateForResponseIncorrectPasswordTryAgain()
	{
		return "Falsches Passwort. Bitte überprüfe dein Passwort und versuche es erneut.";
	}

	protected override string _GetTemplateForResponseInvalidPhoneTryAgain()
	{
		return "Format der Handynummer ist ungültig. Bitte überprüfe die Nummer und versuche es erneut.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneRemovedConfirmation()
	{
		return "Handynummer wurde entfernt.";
	}

	protected override string _GetTemplateForResponseNotificationBarPhoneVerifyConfirmation()
	{
		return "Handynummer wurde erfolgreich aktualisiert!";
	}

	protected override string _GetTemplateForResponseNumberAlreadyAssociated()
	{
		return "Die Nummer ist bereits einem anderen Konto zugeordnet.";
	}

	protected override string _GetTemplateForResponsePinRequired()
	{
		return "Bitte gib deine PIN ein, um deine Einstellungen zu ändern.";
	}

	protected override string _GetTemplateForResponseSocialMediaValidationError()
	{
		return "Der Link über das soziale Netzwerk ist nicht gültig.";
	}

	protected override string _GetTemplateForResponseAgeDownError()
	{
		return "Du kannst dein Alter leider nicht auf unter 13 Jahre ändern. Falls du unter 13 bist, erstelle bitte ein neues Konto und kontaktiere den Support, um das alte zu löschen.";
	}
}
