using System;
using System.Collections.Generic;

namespace Roblox.TranslationResources.Communication;

internal class CommonEmailResources_en_us : TranslationResourcesBase, ICommonEmailResources, ITranslationResources
{
	private readonly Lazy<IReadOnlyDictionary<string, string>> _AllKeys;

	public CommonEmailResources_en_us(TranslationResourceState state)
		: base(state)
	{
		_AllKeys = new Lazy<IReadOnlyDictionary<string, string>>(() => new Dictionary<string, string> { 
		{
			"Description.MessageGenerationContent",
			_GetTemplateForDescriptionMessageGenerationContent()
		} });
	}

	public IReadOnlyDictionary<string, string> GetAllKeys()
	{
		return _AllKeys.Value;
	}

	public string GetFullContentNamespaceName()
	{
		return "Communication.CommonEmail";
	}

	/// <summary>
	/// Key: "Description.MessageGenerationContent"
	/// The environment specific generation message appended to each email.
	/// English String: "This message was generated by {environmentIdentifier}."
	/// </summary>
	public virtual string DescriptionMessageGenerationContent(string environmentIdentifier)
	{
		return $"This message was generated by {environmentIdentifier}.";
	}

	protected virtual string _GetTemplateForDescriptionMessageGenerationContent()
	{
		return "This message was generated by {environmentIdentifier}.";
	}
}
