namespace Roblox.TranslationResources.CommonUI;

public interface IFeaturesResources : ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	string ActionBackToTop { get; }

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	string ActionBuyAccess { get; }

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	string ActionCancel { get; }

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	string ActionOk { get; }

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	string ActionsUpgradeNow { get; }

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	string DescriptionCopyRightMessage { get; }

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	string DescriptionUnsupportedLanguage { get; }

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	string HeadingBuyItem { get; }

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	string HeadingUnsupportedLanguage { get; }

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	string LabelAboutUs { get; }

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	string LabelAuthenticationError { get; }

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	string LabelBadges { get; }

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	string LabelCareers { get; }

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	string LabelConfigure { get; }

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	string LabelConfigureGame { get; }

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	string LabelConfigurePlace { get; }

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	string LabelConfigurePrivateServer { get; }

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	string LabelContactUs { get; }

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	string LabelCreate { get; }

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	string LabelCreateGame { get; }

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	string LabelCreateGroup { get; }

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	string LabelDiscover { get; }

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	string LabelFavorites { get; }

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	string LabelFeeds { get; }

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	string LabelFindMyFeed { get; }

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	string LabelHelp { get; }

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	string LabelJobs { get; }

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	string LabelLibrary { get; }

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	string LabelMerch { get; }

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	string LabelParents { get; }

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	string LabelPlaceStatistics { get; }

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	string LabelPlayers { get; }

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	string LabelPrivacy { get; }

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	string LabelRedeemRobloxCards { get; }

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	string LabelsAvatar { get; }

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	string LabelsBlog { get; }

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	string LabelsCatalog { get; }

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	string LabelsDevelop { get; }

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	string LabelsEvents { get; }

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	string LabelsForum { get; }

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	string LabelsFriends { get; }

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	string LabelsGames { get; }

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	string LabelsGroups { get; }

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	string LabelsHome { get; }

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	string LabelsInventory { get; }

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	string LabelsLogin { get; }

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	string LabelsMessages { get; }

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	string LabelsProfile { get; }

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	string LabelsRobux { get; }

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	string LabelsSearch { get; }

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	string LabelsShop { get; }

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	string LabelsSignUp { get; }

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	string LabelStore { get; }

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	string LabelsTrade { get; }

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	string LabelSupport { get; }

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	string LabelTerms { get; }

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	string LabelTermsOfUse { get; }

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	string LabelThanks { get; }

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	string LabelUpgrade { get; }

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	string BuyAccessToGameForModal(string placeName, string creatorName, string robux);

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	string DescriptionCopyRightMessageDynamicYear(string copyrightYear);

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage);

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	string LabelsSearchPhrase(string phrase, string location);
}
