namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_zh_tw : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "回到頂端";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "購買通行權";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "取消";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "確定";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "現在升級";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation。Roblox、Roblox 標誌及 Powering Imagination 是我們在美國及其它國家的部分註冊與未註冊商標。";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "有一些遊戲可能會使用選擇的語言，但 roblox.com 並未完全支援該語言。";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "購買道具";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "未支援語言";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "關於我們";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "驗證錯誤";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "徽章";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "工作機會";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "設定";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "設定遊戲";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "設定空間";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "設定 VIP 伺服器";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "聯絡我們";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "創作";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "創作遊戲";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "建立群組";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "探索";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "最愛";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "我的饋送";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "在找我的饋送？請前往側選單";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "協助";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "工作機會";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "資料庫";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "商品";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "家長";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "空間統計資料";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "玩家";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "隱私權";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "兌換 Roblox 點數卡";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "虛擬人偶";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "部落格";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "型錄";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "創作";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "活動";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "論壇";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "好友";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "遊戲";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "群組";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "首頁";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "道具欄";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "登入";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "訊息";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "個人檔案";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "搜尋";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "商店";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "註冊";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "商店";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "交易";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "協助";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "條款";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "使用條款";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "感謝";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "升級";

	public FeaturesResources_zh_tw(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "回到頂端";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "購買通行權";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "確定";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "現在升級";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"您要以 {robux} 向 {creatorName} 購買 {placeName} 的空間通行權嗎？";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "您要以 {robux} 向 {creatorName} 購買 {placeName} 的空間通行權嗎？";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation。Roblox、Roblox 標誌及 Powering Imagination 是我們在美國及其它國家的部分註冊與未註冊商標。";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation。Roblox、Roblox 標誌及 Powering Imagination 是我們在美國及其它國家的部分註冊與未註冊商標。";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation。Roblox、Roblox 標誌及 Powering Imagination 是我們在美國及其它國家的部分註冊與未註冊商標。";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "有一些遊戲可能會使用選擇的語言，但 roblox.com 並未完全支援該語言。";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"roblox.com 目前不支援{userLanguage}。遊戲內容會以{platformLanguage}顯示，roblox.com 會以英文顯示。";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "roblox.com 目前不支援{userLanguage}。遊戲內容會以{platformLanguage}顯示，roblox.com 會以英文顯示。";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "購買道具";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "未支援語言";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "關於我們";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "驗證錯誤";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "徽章";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "工作機會";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "設定";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "設定遊戲";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "設定空間";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "設定 VIP 伺服器";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "聯絡我們";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "創作";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "創作遊戲";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "建立群組";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "探索";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "最愛";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "我的饋送";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "在找我的饋送？請前往側選單";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "協助";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "工作機會";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "資料庫";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "商品";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "家長";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "空間統計資料";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "玩家";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "隱私權";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "兌換 Roblox 點數卡";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "虛擬人偶";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "部落格";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "型錄";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "創作";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "活動";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "論壇";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "好友";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "遊戲";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "群組";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "首頁";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "道具欄";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "登入";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "訊息";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "個人檔案";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "搜尋";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"在{location}中搜尋「{phrase}」";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "在{location}中搜尋「{phrase}」";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "商店";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "註冊";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "商店";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "交易";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "協助";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "條款";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "使用條款";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "感謝";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "升級";
	}
}
