namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_zh_cjv : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "返回顶部";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "购买访问权限";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "取消";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "好";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "立即升级";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation。Roblox、Roblox 标志、Robux、Bloxy 及 Powering Imagination 是我们在美国及其他国家或地区的部分注册与未注册商标。";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "有些游戏可能会使用已选择的语言，但 roblox.com 并未完全支持该语言。";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "购买物品";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "未支持的语言";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "关于我们";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "身份验证错误";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "徽章";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "职位";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "配置";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "配置游戏";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "配置场景";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "配置 VIP 服务器";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "联系我们";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "创作";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "创建游戏";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "创建群组";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "探索";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "最爱";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "我的推送";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "在找“我的推送”？它现在移到了侧边菜单";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "帮助";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "工作机会";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "档案库";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "商品";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "家长";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "场景统计资料";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "玩家";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "隐私";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "兑换 Roblox 卡";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "虚拟形象";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "博客";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "商店";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "开发";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "活动";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "论坛";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "好友";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "游戏";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "群组";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "首页";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "道具";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "登录";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "信息";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "个人资料";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "搜索";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "周边";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "注册";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "商店";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "交易";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "支持";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "条款";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "使用条款";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "谢谢";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "升级";

	public FeaturesResources_zh_cjv(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "返回顶部";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "购买访问权限";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "取消";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "好";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "立即升级";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"你是否要以 {robux} 的价格向”{creatorName}“购买场景“{placeName}”的通行证？";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "你是否要以 {robux} 的价格向”{creatorName}“购买场景“{placeName}”的通行证？";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation。Roblox、Roblox 标志、Robux、Bloxy 及 Powering Imagination 是我们在美国及其他国家或地区的部分注册与未注册商标。";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation。Roblox、Roblox 标志、Robux、Bloxy 及 Powering Imagination 是我们在美国及其他国家或地区的部分注册与未注册商标。";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation。Roblox、Roblox 标志、Robux、Bloxy 及 Powering Imagination 是我们在美国及其他国家或地区的部分注册与未注册商标。";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "有些游戏可能会使用已选择的语言，但 roblox.com 并未完全支持该语言。";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"roblox.com 目前不支持“{userLanguage}”。游戏内容将以“{platformLanguage}”显示，roblox.com 将以“英文”显示。";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "roblox.com 目前不支持“{userLanguage}”。游戏内容将以“{platformLanguage}”显示，roblox.com 将以“英文”显示。";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "购买物品";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "未支持的语言";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "关于我们";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "身份验证错误";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "徽章";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "职位";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "配置";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "配置游戏";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "配置场景";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "配置 VIP 服务器";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "联系我们";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "创作";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "创建游戏";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "创建群组";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "探索";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "最爱";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "我的推送";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "在找“我的推送”？它现在移到了侧边菜单";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "帮助";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "工作机会";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "档案库";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "商品";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "家长";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "场景统计资料";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "玩家";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "隐私";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "兑换 Roblox 卡";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "虚拟形象";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "博客";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "商店";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "开发";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "活动";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "论坛";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "好友";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "游戏";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "群组";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "首页";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "道具";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "登录";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "信息";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "个人资料";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "搜索";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"在{location}中搜索“{phrase}”";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "在{location}中搜索“{phrase}”";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "周边";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "注册";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "商店";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "交易";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "支持";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "条款";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "使用条款";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "谢谢";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "升级";
	}
}
