namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_vi_vn : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Về đầu trang";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Mua quyền truy cập";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Hủy";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Ok";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Nâng cấp ngay";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, logo Roblox và Powering Imagination là các thương hiệu đã đăng ký và chưa đăng ký của chúng tôi tại Hoa Kỳ và các quốc gia khác.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Mặc dù một số trò chơi có thể sử dụng ngôn ngữ đã chọn, nhưng ngôn ngữ này không được roblox.com hỗ trợ đầy đủ.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Mua vật phẩm";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Ngôn ngữ không được hỗ trợ";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "Về chúng tôi";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Lỗi xác thực";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Huy hiệu";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Tuyển dụng";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Thiết lập";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Thiết lập game";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Thiết lập Địa điểm";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "Thiết lập máy chủ VIP";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Liên hệ chúng tôi";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Tạo";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Tạo Trò chơi";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Tạo Nhóm";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Khám phá";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Yêu thích";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Nguồn tin của tôi";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Bạn đang tìm Nguồn tin của tôi? Hãy tìm trong menu cạnh bên";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Trợ giúp";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Việc làm";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Thư viện";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Các món hàng";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Cha mẹ";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Thống kê về địa điểm";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Người chơi";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Riêng tư";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Quy đổi Thẻ Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Hình đại diện";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Danh mục";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Phát triển";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Sự kiện";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Diễn đàn";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Bạn bè";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Trò chơi";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Nhóm";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Trang chủ";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Kho";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Đăng nhập";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Tin nhắn";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Hồ sơ";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Tìm kiếm";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Cửa hàng";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Đăng ký";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Cửa hàng";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Trao đổi";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Hỗ trợ";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Điều khoản";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Điều khoản sử dụng";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Cảm ơn";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Nâng cấp";

	public FeaturesResources_vi_vn(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Về đầu trang";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Mua quyền truy cập";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Hủy";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Ok";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Nâng cấp ngay";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"Bạn có muốn mua quyền truy cập tới Địa điểm: {placeName} từ {creatorName} với giá {robux} không?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "Bạn có muốn mua quyền truy cập tới Địa điểm: {placeName} từ {creatorName} với giá {robux} không?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, logo Roblox và Powering Imagination là các thương hiệu đã đăng ký và chưa đăng ký của chúng tôi tại Hoa Kỳ và các quốc gia khác.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, logo Roblox và Powering Imagination là các nhãn hiệu đã đăng ký và chưa đăng ký của chúng tôi tại Hoa Kỳ và các quốc gia khác.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, logo Roblox và Powering Imagination là các nhãn hiệu đã đăng ký và chưa đăng ký của chúng tôi tại Hoa Kỳ và các quốc gia khác.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Mặc dù một số trò chơi có thể sử dụng ngôn ngữ đã chọn, nhưng ngôn ngữ này không được roblox.com hỗ trợ đầy đủ.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} hiện không khả dụng trên roblox.com. Bạn sẽ thấy nội dung trong trò chơi bằng {platformLanguage}, và roblox.com đã được đặt thành tiếng Anh.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} hiện không khả dụng trên roblox.com. Bạn sẽ thấy nội dung trong trò chơi bằng {platformLanguage}, và roblox.com đã được đặt thành tiếng Anh.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Mua vật phẩm";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Ngôn ngữ không được hỗ trợ";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "Về chúng tôi";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Lỗi xác thực";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Huy hiệu";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Tuyển dụng";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Thiết lập";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Thiết lập game";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Thiết lập Địa điểm";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "Thiết lập máy chủ VIP";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Liên hệ chúng tôi";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Tạo";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Tạo Trò chơi";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Tạo Nhóm";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Khám phá";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Yêu thích";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Nguồn tin của tôi";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Bạn đang tìm Nguồn tin của tôi? Hãy tìm trong menu cạnh bên";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Trợ giúp";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Việc làm";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Thư viện";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Các món hàng";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Cha mẹ";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Thống kê về địa điểm";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Người chơi";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Riêng tư";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Quy đổi Thẻ Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Hình đại diện";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Danh mục";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Phát triển";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Sự kiện";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Diễn đàn";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Bạn bè";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Trò chơi";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Nhóm";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Trang chủ";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Kho";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Đăng nhập";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Tin nhắn";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Hồ sơ";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Tìm kiếm";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Tìm kiếm \"{phrase}\" trong {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Tìm kiếm \"{phrase}\" trong {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Cửa hàng";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Đăng ký";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Cửa hàng";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Trao đổi";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Hỗ trợ";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Điều khoản";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Điều khoản sử dụng";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Cảm ơn";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Nâng cấp";
	}
}
