namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_tr_tr : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "En Üste Dön";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Erişim Satın Al";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "İptal Et";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Tamam";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Hemen Yükselt";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, Roblox logosu ve Powering Imagination ABD ve diğer ülkelerde bizim tescilli ve tescilsiz ticari markalarımızdır.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Bazı oyunlar seçilen dili kullanıyor olsa da bu dil roblox.com tam olarak desteklenmemektedir.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Öğe Satın Al";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Desteklenmeyen Dil";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "Hakkımızda";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Doğrulama Hatası";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Rozetler";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Kariyer";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Yapılandır";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Oyunu Yapılandır";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Mekânı Yapılandır";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "VIP Sunucusunu Yapılandır";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Bizimle İletişime Geç";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Oluştur";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Oyun Oluştur";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Grup Oluştur";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Keşfet";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoriler";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Akış Listem";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Akış Listem bölümünü mü arıyorsun? Artık yan menüde";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Yardım";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Kariyer Fırsatları";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Kütüphane";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Ürünler";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Ebeveyn";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Mekan İstatistikleri";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Oyuncular";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Gizlilik";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Roblox Kartlarını Kullan";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Avatar";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Katalog";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Geliştir";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Etkinlikler";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Forum";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Arkadaşlar";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Oyunlar";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Gruplar";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Ana Sayfa";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Envanter";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Giriş Yap";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Mesajlar";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Profil";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Ara";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Mağaza";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Kayıt Ol";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Mağaza";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Takas";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Destek";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Koşullar";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Kullanım Koşulları";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Teşekkürler";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Yükselt";

	public FeaturesResources_tr_tr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "En Üste Dön";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Erişim Satın Al";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "İptal Et";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Tamam";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Hemen Yükselt";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"{robux} karşılığında {creatorName} tarafından {placeName} Mekanına erişim satın almak ister misin?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "{robux} karşılığında {creatorName} tarafından {placeName} Mekanına erişim satın almak ister misin?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, Roblox logosu ve Powering Imagination ABD ve diğer ülkelerde bizim tescilli ve tescilsiz ticari markalarımızdır.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, Roblox logosu ve Powering Imagination ABD ve diğer ülkelerde bizim tescilli ve tescilsiz ticari markalarımızdır.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, Roblox logosu ve Powering Imagination ABD ve diğer ülkelerde bizim tescilli ve tescilsiz ticari markalarımızdır.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Bazı oyunlar seçilen dili kullanıyor olsa da bu dil roblox.com tam olarak desteklenmemektedir.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} şu anda roblox.com'da kullanılamıyor. Oyun içi içerikleri{platformLanguage} görürsünüz ve roblox.com İngilizce olarak ayarlanır.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} şu anda roblox.com'da kullanılamıyor. Oyun içi içerikleri{platformLanguage} görürsünüz ve roblox.com İngilizce olarak ayarlanır.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Öğe Satın Al";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Desteklenmeyen Dil";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "Hakkımızda";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Doğrulama Hatası";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Rozetler";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Kariyer";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Yapılandır";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Oyunu Yapılandır";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Mekânı Yapılandır";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "VIP Sunucusunu Yapılandır";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Bizimle İletişime Geç";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Oluştur";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Oyun Oluştur";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Grup Oluştur";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Keşfet";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoriler";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Akış Listem";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Akış Listem bölümünü mü arıyorsun? Artık yan menüde";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Yardım";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Kariyer Fırsatları";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Kütüphane";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Ürünler";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Ebeveyn";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Mekan İstatistikleri";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Oyuncular";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Gizlilik";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Roblox Kartlarını Kullan";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Avatar";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Katalog";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Geliştir";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Etkinlikler";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Forum";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Arkadaşlar";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Oyunlar";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Gruplar";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Ana Sayfa";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Envanter";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Giriş Yap";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Mesajlar";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Profil";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Ara";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"{location} içinde \"{phrase}\" ara";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "{location} içinde \"{phrase}\" ara";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Mağaza";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Kayıt Ol";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Mağaza";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Takas";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Destek";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Koşullar";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Kullanım Koşulları";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Teşekkürler";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Yükselt";
	}
}
