namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_th_th : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "กล\u0e31บไปย\u0e31งส\u0e48วนบนส\u0e38ด";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "ซ\u0e37\u0e49อส\u0e34ทธ\u0e34\u0e4cเข\u0e49าถ\u0e36ง";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "ยกเล\u0e34ก";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "ตกลง";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "อ\u0e31ปเกรดตอนน\u0e35\u0e49เลย";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation โดย Roblox, โลโก\u0e49 Roblox และ Powering Imagination เป\u0e47นส\u0e48วนหน\u0e36\u0e48งของเคร\u0e37\u0e48องหมายการค\u0e49าของเราท\u0e31\u0e49งท\u0e35\u0e48ได\u0e49ร\u0e31บการจดทะเบ\u0e35ยนและย\u0e31งไม\u0e48ได\u0e49จดทะเบ\u0e35ยนในสหร\u0e31ฐฯ และในประเทศอ\u0e37\u0e48นๆ";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "ถ\u0e36งแม\u0e49ว\u0e48าอาจจะม\u0e35บางเกมท\u0e35\u0e48ม\u0e35การใช\u0e49ภาษาท\u0e35\u0e48เล\u0e37อก ภาษาน\u0e31\u0e49นก\u0e47ไม\u0e48ได\u0e49ร\u0e31บการร\u0e31บรองจาก roblox.com อย\u0e48างสมบ\u0e39รณ\u0e4c";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "ซ\u0e37\u0e49อไอเท\u0e47ม";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "ภาษาท\u0e35\u0e48ไม\u0e48รองร\u0e31บ";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "เก\u0e35\u0e48ยวก\u0e31บเรา";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "ข\u0e49อผ\u0e34ดพลาดในการตรวจสอบความถ\u0e39กต\u0e49อง";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "ตรา";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "อาช\u0e35พการงาน";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "กำหนดค\u0e48า";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "กำหนดค\u0e48าเกม";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "กำหนดค\u0e48าสถานท\u0e35\u0e48";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "กำหนดค\u0e48าเซ\u0e34ร\u0e4cฟเวอร\u0e4c VIP";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "ต\u0e34ดต\u0e48อเรา";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "สร\u0e49าง";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "สร\u0e49างเกม";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "สร\u0e49างกล\u0e38\u0e48ม";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "ค\u0e49นพบ";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "รายการโปรด";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "ฟ\u0e35ดข\u0e49อม\u0e39ลของฉ\u0e31น";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "กำล\u0e31งมองหาฟ\u0e35ดข\u0e48าวของฉ\u0e31น? ตอนน\u0e35\u0e49ม\u0e31นอย\u0e39\u0e48ในเมน\u0e39ด\u0e49านข\u0e49าง";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "ช\u0e48วยเหล\u0e37อ";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "งาน";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "ไลบราร\u0e35";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "ส\u0e34นค\u0e49า";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "ผ\u0e39\u0e49ปกครอง";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "สถ\u0e34ต\u0e34สถานท\u0e35\u0e48";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "ผ\u0e39\u0e49เล\u0e48น";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "ความเป\u0e47นส\u0e48วนต\u0e31ว";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "แลกร\u0e31บบ\u0e31ตร Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "อวตาร";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "บล\u0e47อก";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "แค\u0e47ตตาล\u0e47อก";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "พ\u0e31ฒนา";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "อ\u0e35เวนต\u0e4c";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "ฟอร\u0e31\u0e48ม";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "เพ\u0e37\u0e48อน";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "เกม";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "กล\u0e38\u0e48ม";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "หน\u0e49าหล\u0e31ก";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "คล\u0e31งไอเทม";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "เข\u0e49าส\u0e39\u0e48ระบบ";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "ข\u0e49อความ";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "ประว\u0e31ต\u0e34";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "ค\u0e49นหา";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "ร\u0e49านค\u0e49า";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "สม\u0e31ครบ\u0e31ญช\u0e35ผ\u0e39\u0e49ใช\u0e49";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "ร\u0e49านค\u0e49า";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "แลกเปล\u0e35\u0e48ยน";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "ฝ\u0e48ายสน\u0e31บสน\u0e38น";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "เง\u0e37\u0e48อนไข";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "เง\u0e37\u0e48อนไขการใช\u0e49งาน";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "ขอบค\u0e38ณ";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "อ\u0e31ปเกรด";

	public FeaturesResources_th_th(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "กล\u0e31บไปย\u0e31งส\u0e48วนบนส\u0e38ด";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "ซ\u0e37\u0e49อส\u0e34ทธ\u0e34\u0e4cเข\u0e49าถ\u0e36ง";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "ยกเล\u0e34ก";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "ตกลง";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "อ\u0e31ปเกรดตอนน\u0e35\u0e49เลย";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"ค\u0e38ณต\u0e49องการซ\u0e37\u0e49อส\u0e34ทธ\u0e34\u0e4cเข\u0e49าถ\u0e36งสถานท\u0e35\u0e48: {placeName} จาก {creatorName} สำหร\u0e31บ {robux} หร\u0e37อไม\u0e48?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "ค\u0e38ณต\u0e49องการซ\u0e37\u0e49อส\u0e34ทธ\u0e34\u0e4cเข\u0e49าถ\u0e36งสถานท\u0e35\u0e48: {placeName} จาก {creatorName} สำหร\u0e31บ {robux} หร\u0e37อไม\u0e48?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation โดย Roblox, โลโก\u0e49 Roblox และ Powering Imagination เป\u0e47นส\u0e48วนหน\u0e36\u0e48งของเคร\u0e37\u0e48องหมายการค\u0e49าของเราท\u0e31\u0e49งท\u0e35\u0e48ได\u0e49ร\u0e31บการจดทะเบ\u0e35ยนและย\u0e31งไม\u0e48ได\u0e49จดทะเบ\u0e35ยนในสหร\u0e31ฐฯ และในประเทศอ\u0e37\u0e48นๆ";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, โลโก\u0e49 Roblox และ Powering Imagination เป\u0e47นส\u0e48วนหน\u0e36\u0e48งของเคร\u0e37\u0e48องหมายการค\u0e49าท\u0e35\u0e48จดทะเบ\u0e35ยน และไม\u0e48ได\u0e49จดทะเบ\u0e35ยนของเราในสหร\u0e31ฐฯ และประเทศอ\u0e37\u0e48นๆ";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, โลโก\u0e49 Roblox และ Powering Imagination เป\u0e47นส\u0e48วนหน\u0e36\u0e48งของเคร\u0e37\u0e48องหมายการค\u0e49าท\u0e35\u0e48จดทะเบ\u0e35ยน และไม\u0e48ได\u0e49จดทะเบ\u0e35ยนของเราในสหร\u0e31ฐฯ และประเทศอ\u0e37\u0e48นๆ";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "ถ\u0e36งแม\u0e49ว\u0e48าอาจจะม\u0e35บางเกมท\u0e35\u0e48ม\u0e35การใช\u0e49ภาษาท\u0e35\u0e48เล\u0e37อก ภาษาน\u0e31\u0e49นก\u0e47ไม\u0e48ได\u0e49ร\u0e31บการร\u0e31บรองจาก roblox.com อย\u0e48างสมบ\u0e39รณ\u0e4c";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"ไม\u0e48ม\u0e35ภาษา {userLanguage} พร\u0e49อมให\u0e49บร\u0e34การท\u0e35\u0e48 roblox.com ในขณะน\u0e35\u0e49 ค\u0e38ณจะเห\u0e47นเน\u0e37\u0e49อหาในเกมเป\u0e47นภาษา {platformLanguage} และท\u0e35\u0e48 roblox.com จะถ\u0e39กต\u0e31\u0e49งค\u0e48าให\u0e49แสดงผลเป\u0e47นภาษาอ\u0e31งกฤษ";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "ไม\u0e48ม\u0e35ภาษา {userLanguage} พร\u0e49อมให\u0e49บร\u0e34การท\u0e35\u0e48 roblox.com ในขณะน\u0e35\u0e49 ค\u0e38ณจะเห\u0e47นเน\u0e37\u0e49อหาในเกมเป\u0e47นภาษา {platformLanguage} และท\u0e35\u0e48 roblox.com จะถ\u0e39กต\u0e31\u0e49งค\u0e48าให\u0e49แสดงผลเป\u0e47นภาษาอ\u0e31งกฤษ";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "ซ\u0e37\u0e49อไอเท\u0e47ม";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "ภาษาท\u0e35\u0e48ไม\u0e48รองร\u0e31บ";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "เก\u0e35\u0e48ยวก\u0e31บเรา";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "ข\u0e49อผ\u0e34ดพลาดในการตรวจสอบความถ\u0e39กต\u0e49อง";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "ตรา";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "อาช\u0e35พการงาน";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "กำหนดค\u0e48า";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "กำหนดค\u0e48าเกม";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "กำหนดค\u0e48าสถานท\u0e35\u0e48";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "กำหนดค\u0e48าเซ\u0e34ร\u0e4cฟเวอร\u0e4c VIP";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "ต\u0e34ดต\u0e48อเรา";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "สร\u0e49าง";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "สร\u0e49างเกม";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "สร\u0e49างกล\u0e38\u0e48ม";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "ค\u0e49นพบ";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "รายการโปรด";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "ฟ\u0e35ดข\u0e49อม\u0e39ลของฉ\u0e31น";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "กำล\u0e31งมองหาฟ\u0e35ดข\u0e48าวของฉ\u0e31น? ตอนน\u0e35\u0e49ม\u0e31นอย\u0e39\u0e48ในเมน\u0e39ด\u0e49านข\u0e49าง";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "ช\u0e48วยเหล\u0e37อ";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "งาน";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "ไลบราร\u0e35";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "ส\u0e34นค\u0e49า";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "ผ\u0e39\u0e49ปกครอง";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "สถ\u0e34ต\u0e34สถานท\u0e35\u0e48";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "ผ\u0e39\u0e49เล\u0e48น";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "ความเป\u0e47นส\u0e48วนต\u0e31ว";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "แลกร\u0e31บบ\u0e31ตร Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "อวตาร";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "บล\u0e47อก";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "แค\u0e47ตตาล\u0e47อก";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "พ\u0e31ฒนา";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "อ\u0e35เวนต\u0e4c";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "ฟอร\u0e31\u0e48ม";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "เพ\u0e37\u0e48อน";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "เกม";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "กล\u0e38\u0e48ม";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "หน\u0e49าหล\u0e31ก";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "คล\u0e31งไอเทม";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "เข\u0e49าส\u0e39\u0e48ระบบ";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "ข\u0e49อความ";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "ประว\u0e31ต\u0e34";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "ค\u0e49นหา";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"ค\u0e49นหา \"{phrase}\" ใน {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "ค\u0e49นหา \"{phrase}\" ใน {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "ร\u0e49านค\u0e49า";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "สม\u0e31ครบ\u0e31ญช\u0e35ผ\u0e39\u0e49ใช\u0e49";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "ร\u0e49านค\u0e49า";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "แลกเปล\u0e35\u0e48ยน";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "ฝ\u0e48ายสน\u0e31บสน\u0e38น";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "เง\u0e37\u0e48อนไข";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "เง\u0e37\u0e48อนไขการใช\u0e49งาน";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "ขอบค\u0e38ณ";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "อ\u0e31ปเกรด";
	}
}
