namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_ru_ru : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Наверх";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Купить доступ";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Отмена";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "OK";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Улучшить";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, логотип Roblox и Powering Imagination входят в число зарегистрированных и незарегистрированных товарных знаков в США и других странах.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Выбранный язык может использоваться в некоторых играх, однако roblox.com не поддерживает его в полной мере.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Купить предмет";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Язык не поддерживается";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "О нас";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Ошибка авторизации";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Значки";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Работа";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Создать";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Создать игру";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Настроить место";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "Создать VIP сервер";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Связаться с нами";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Создать";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Создать игру";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Создать группу";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Исследовать";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Избранные";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Лента";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Видите мою ленту? Тепрь она на боковом меню.";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Справка";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Вакансии";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Библиотека";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Товар";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Родители";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Разместить статистику";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Игроки";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Конфиденциальность";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Купите карты Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Аватар";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Блог";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Каталог";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Разработка";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "События";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Форум";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Друзья";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Игры";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Группы";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Главная";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Инвентарь";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Вход";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Сообщения";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Профиль";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Поиск";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Магазин";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Регистрация";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Магазин";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Торговля";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Поддержка";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Условия";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Условия использования";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Спасибо";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Улучшить";

	public FeaturesResources_ru_ru(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Наверх";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Купить доступ";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Отмена";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Улучшить";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"Хотите купить доступ: {placeName} от {creatorName} за {robux}?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "Хотите купить доступ: {placeName} от {creatorName} за {robux}?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, логотип Roblox и Powering Imagination входят в число зарегистрированных и незарегистрированных товарных знаков в США и других странах.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, логотип Roblox и Powering Imagination входят в число зарегистрированных и незарегистрированных товарных знаков в США и других странах.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, логотип Roblox и Powering Imagination входят в число зарегистрированных и незарегистрированных товарных знаков в США и других странах.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Выбранный язык может использоваться в некоторых играх, однако roblox.com не поддерживает его в полной мере.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"Данный язык ({userLanguage}) в настоящее время недоступен на roblox.com. Вы сможете играть в игры на этом языке ({platformLanguage}), однако для roblox.com будет установлен английский язык.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "Данный язык ({userLanguage}) в настоящее время недоступен на roblox.com. Вы сможете играть в игры на этом языке ({platformLanguage}), однако для roblox.com будет установлен английский язык.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Купить предмет";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Язык не поддерживается";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "О нас";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Ошибка авторизации";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Значки";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Работа";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Создать";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Создать игру";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Настроить место";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "Создать VIP сервер";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Связаться с нами";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Создать";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Создать игру";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Создать группу";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Исследовать";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Избранные";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Лента";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Видите мою ленту? Тепрь она на боковом меню.";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Справка";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Вакансии";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Библиотека";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Товар";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Родители";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Разместить статистику";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Игроки";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Конфиденциальность";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Купите карты Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Аватар";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Блог";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Каталог";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Разработка";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "События";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Форум";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Друзья";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Игры";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Группы";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Главная";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Инвентарь";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Вход";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Сообщения";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Профиль";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Поиск";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Поиск \"{phrase}\" в {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Поиск \"{phrase}\" в {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Магазин";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Регистрация";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Магазин";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Торговля";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Поддержка";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Условия";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Условия использования";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Спасибо";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Улучшить";
	}
}
