namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_pt_br : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Voltar para o topo";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Comprar acesso";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Ok";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Melhorar agora";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, o logotipo Roblox e Powering Imagination estão entre nossas marcas registradas e não registradas nos EUA e outros países.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Embora alguns jogos usem o idioma selecionado, roblox.com não tem suporte para ele.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Comprar item";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Idioma não incluso";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "Sobre nós";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Erro de autenticação";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Emblemas";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Carreiras";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Configurar";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Configurar jogo";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Configurar local";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "Configurar servidor VIP";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Fale conosco";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Criar";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Criar jogo";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Criar grupo";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Descubra";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoritos";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Meu feed";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Procurando Meu Feed? Confira o menu lateral";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Ajuda";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Vagas";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Biblioteca";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Produtos";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Responsáveis";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Estatísticas do local";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Jogadores";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Privacidade";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Usar cartões Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Avatar";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Catálogo";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Desenvolvimento";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Eventos";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Fórum";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Amigos";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Jogos";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Grupos";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Início";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Inventário";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Conectar-se";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Mensagens";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Perfil";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Pesquisar";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Loja";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Cadastrar-se";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Loja";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Trocar";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Suporte";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Termos";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Termos de Uso";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Obrigado";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Melhorar";

	public FeaturesResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Voltar para o topo";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Comprar acesso";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Ok";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Melhorar agora";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"Gostaria de comprar acesso a este local: {placeName} de {creatorName} por {robux}?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "Gostaria de comprar acesso a este local: {placeName} de {creatorName} por {robux}?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, o logotipo Roblox e Powering Imagination estão entre nossas marcas registradas e não registradas nos EUA e outros países.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, o logotipo Roblox e Powering Imagination estão entre nossas marcas registradas e não registradas nos EUA e outros países.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, o logotipo Roblox e Powering Imagination estão entre nossas marcas registradas e não registradas nos EUA e outros países.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Embora alguns jogos usem o idioma selecionado, roblox.com não tem suporte para ele.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} não está disponível no momento em roblox.com. Você verá o conteúdo no jogo em {platformLanguage} e roblox.com será exibido em inglês.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} não está disponível no momento em roblox.com. Você verá o conteúdo no jogo em {platformLanguage} e roblox.com será exibido em inglês.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Comprar item";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Idioma não incluso";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "Sobre nós";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Erro de autenticação";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Emblemas";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Carreiras";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Configurar";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Configurar jogo";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Configurar local";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "Configurar servidor VIP";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Fale conosco";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Criar";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Criar jogo";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Criar grupo";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Descubra";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Meu feed";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Procurando Meu Feed? Confira o menu lateral";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Ajuda";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Vagas";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Biblioteca";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Produtos";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Responsáveis";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Estatísticas do local";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Jogadores";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Privacidade";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Usar cartões Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Avatar";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Catálogo";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Desenvolvimento";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Eventos";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Fórum";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Amigos";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Jogos";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Grupos";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Início";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Inventário";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Conectar-se";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Mensagens";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Perfil";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Pesquisar";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Pesquisar por {phrase} em {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Pesquisar por {phrase} em {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Loja";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Cadastrar-se";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Loja";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Trocar";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Suporte";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Termos";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Termos de Uso";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Obrigado";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Melhorar";
	}
}
