namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_ko_kr : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "맨 위로 돌아가기";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "이용권 구매";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "취소";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "확인";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "업그레이드";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, Roblox 로고 및 Powering Imagination은 미국 및 기타 국가에서 등록 및 미등록 상표입니다.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "가능할 경우 어떤 게임들은 이 언어로 나올 거예요. 하지만 roblox.com에서 전적으로 지원하는 것은 아니랍니다.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "아이템 구매";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "지원하지 않는 언어";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "회사 소개";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "인증 오류";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "배지";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "인재채용";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "구성";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "게임 구성";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "장소 구성";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "VIP 서버 구성";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "고객센터";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "만들기";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "게임 만들기";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "그룹 만들기";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "찾아보기";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "즐겨찾기";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "내 피드";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "내 피드는 사이드 메뉴를 확인하세요";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "도움말";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "인재채용";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "라이브러리";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "캐릭터 상품";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "보호자 가이드";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "장소 통계";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "플레이어";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "개인정보 처리방침";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Roblox 카드 사용";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "아바타";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "블로그";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "카탈로그";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "개발";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "이벤트";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "포럼";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "친구";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "게임";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "그룹";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "홈";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "인벤토리";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "로그인";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "메시지";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "프로필";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "검색";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "구매";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "회원가입";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "상점";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "거래";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "고객지원";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "이용 약관";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "이용 약관";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "감사합니다";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "업그레이드";

	public FeaturesResources_ko_kr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "맨 위로 돌아가기";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "이용권 구매";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "취소";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "확인";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "업그레이드";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"{creatorName}이(가) 제작한 {placeName} 이용권을 {robux}으(로) 구매할까요?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "{creatorName}이(가) 제작한 {placeName} 이용권을 {robux}으(로) 구매할까요?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, Roblox 로고 및 Powering Imagination은 미국 및 기타 국가에서 등록 및 미등록 상표입니다.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, Roblox 로고 및 Powering Imagination은 미국 및 그 외 국가에서 등록 상표 및 미등록 상표입니다.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, Roblox 로고 및 Powering Imagination은 미국 및 그 외 국가에서 등록 상표 및 미등록 상표입니다.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "가능할 경우 어떤 게임들은 이 언어로 나올 거예요. 하지만 roblox.com에서 전적으로 지원하는 것은 아니랍니다.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage}은(는) 현재 roblox.com에서 이용할 수 없어요. 게임 내 콘텐츠는 {platformLanguage}로 나오고, roblox.com은 영어로 설정되어 있어요.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage}은(는) 현재 roblox.com에서 이용할 수 없어요. 게임 내 콘텐츠는 {platformLanguage}로 나오고, roblox.com은 영어로 설정되어 있어요.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "아이템 구매";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "지원하지 않는 언어";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "회사 소개";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "인증 오류";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "배지";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "인재채용";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "구성";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "게임 구성";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "장소 구성";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "VIP 서버 구성";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "고객센터";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "만들기";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "게임 만들기";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "그룹 만들기";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "찾아보기";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "즐겨찾기";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "내 피드";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "내 피드는 사이드 메뉴를 확인하세요";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "도움말";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "인재채용";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "라이브러리";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "캐릭터 상품";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "보호자 가이드";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "장소 통계";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "플레이어";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "개인정보 처리방침";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Roblox 카드 사용";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "아바타";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "블로그";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "카탈로그";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "개발";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "이벤트";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "포럼";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "친구";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "게임";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "그룹";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "홈";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "인벤토리";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "로그인";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "메시지";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "프로필";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "검색";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"{location}에서 \"{phrase}\" 검색";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "{location}에서 \"{phrase}\" 검색";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "구매";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "회원가입";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "상점";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "거래";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "고객지원";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "이용 약관";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "이용 약관";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "감사합니다";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "업그레이드";
	}
}
