namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_ja_jp : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "トップに戻る";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "アクセスを買う";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "キャンセル";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "OK";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "アップグレードする";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "© 2018 Roblox Corporation. Roblox、RobloxロゴおよびPowering Imaginationは、米国並びにその他の国における登録商標および非登録商標です。";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "一部のゲームでは特定の言語が使われている場合がありますが、roblox.comでは完全には多言語は対応していません。";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "アイテムを買う";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "対応していない言語";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "当社について";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "認証エラー";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "バッジ";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "採用情報";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "設定する";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "ゲームの設定";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "プレースを設定する";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "VIPサーバーの設定";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "お問い合わせ";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "制作";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "ゲームを制作";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "グループを作成";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "発見";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "お気に入り";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "マイフィード";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "フィードをお探しですか？サイドメニューにあります";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "ヘルプ";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "採用情報";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "ライブラリ";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "商品";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "保護者の方へ";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "プレースの統計";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "プレイヤー";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "プライバシー";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Robloxカードを引き換える";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "アバター";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "ブログ";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "カタログ";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "開発";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "イベント";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "フォーラム";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "友達";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "ゲーム";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "グループ";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "ホーム";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "インベントリ";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "ログイン";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "メッセージ";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "プロフィール";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "検索";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "ショップ";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "新規登録";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "ショップ";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "取引";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "サポート";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "規約";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "利用規約";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "ありがとうございます";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "アップグレード";

	public FeaturesResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "トップに戻る";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "アクセスを買う";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "キャンセル";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "OK";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "アップグレードする";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"次のプレースへのアクセスを買いますか？：{creatorName} が作成した{robux} の{placeName}";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "次のプレースへのアクセスを買いますか？：{creatorName} が作成した{robux} の{placeName}";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "© 2018 Roblox Corporation. Roblox、RobloxロゴおよびPowering Imaginationは、米国並びにその他の国における登録商標および非登録商標です。";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox、RobloxロゴおよびPowering Imaginationは、米国並びにその他の国における登録商標および非登録商標です。";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox、RobloxロゴおよびPowering Imaginationは、米国並びにその他の国における登録商標および非登録商標です。";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "一部のゲームでは特定の言語が使われている場合がありますが、roblox.comでは完全には多言語は対応していません。";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} は現在 roblox.com では対応していません。ゲーム上で {platformLanguage} のコンテンツがありますが、roblox.com は英語に設定されています。";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} は現在 roblox.com では対応していません。ゲーム上で {platformLanguage} のコンテンツがありますが、roblox.com は英語に設定されています。";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "アイテムを買う";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "対応していない言語";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "当社について";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "認証エラー";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "バッジ";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "採用情報";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "設定する";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "ゲームの設定";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "プレースを設定する";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "VIPサーバーの設定";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "お問い合わせ";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "制作";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "ゲームを制作";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "グループを作成";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "発見";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "お気に入り";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "マイフィード";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "フィードをお探しですか？サイドメニューにあります";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "ヘルプ";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "採用情報";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "ライブラリ";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "商品";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "保護者の方へ";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "プレースの統計";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "プレイヤー";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "プライバシー";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Robloxカードを引き換える";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "アバター";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "ブログ";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "カタログ";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "開発";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "イベント";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "フォーラム";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "友達";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "ゲーム";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "グループ";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "ホーム";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "インベントリ";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "ログイン";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "メッセージ";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "プロフィール";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "検索";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"「{phrase}」を{location}で検索する";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "「{phrase}」を{location}で検索する";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "ショップ";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "新規登録";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "ショップ";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "取引";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "サポート";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "規約";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "利用規約";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "ありがとうございます";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "アップグレード";
	}
}
