namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_it_it : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Torna all'inizio";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Acquista accesso";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Annulla";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Ok";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Migliora adesso";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, il logo Roblox e Powering Imagination sono alcuni dei nostri marchi registrati e marchi di fatto negli Stati Uniti e in altri Paesi.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "La lingua selezionata non è pienamente supportata da roblox.com, anche se alcuni giochi potrebbero usarla.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Acquista oggetto";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Lingua non supportata";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "Su di noi";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Errore di autenticazione";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Contrassegni";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Lavora con noi";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Configura";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Configura partita";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Configura località";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "Configura server VIP";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Contattaci";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Crea";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Crea partita";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Crea gruppo";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Scopri";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Preferiti";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "I miei Feed";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Non trovi più \"I miei Feed\"? Guarda nel menu laterale";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Guida";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Lavori";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Libreria";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Gadget";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Genitori";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Statistiche località";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Giocatori";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Privacy";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Riscuoti carte Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Avatar";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Catalogo";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Sviluppa";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Eventi";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Forum";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Amici";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Giochi";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Gruppi";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Home";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Inventario";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Accedi";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Messaggi";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Profilo";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Cerca";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Negozio";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Registrati";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Negozio";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Scambia";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Assistenza";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Temini";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Termini di servizio";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Grazie";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Migliora";

	public FeaturesResources_it_it(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Torna all'inizio";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Acquista accesso";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Annulla";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Ok";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Migliora adesso";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"Vuoi acquistare l'accesso alla località: {placeName} da {creatorName} per {robux}?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "Vuoi acquistare l'accesso alla località: {placeName} da {creatorName} per {robux}?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, il logo Roblox e Powering Imagination sono alcuni dei nostri marchi registrati e marchi di fatto negli Stati Uniti e in altri Paesi.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, il logo Roblox e Powering Imagination sono alcuni dei nostri marchi registrati e marchi di fatto negli Stati Uniti e in altri Paesi.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, il logo Roblox e Powering Imagination sono alcuni dei nostri marchi registrati e marchi di fatto negli Stati Uniti e in altri Paesi.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "La lingua selezionata non è pienamente supportata da roblox.com, anche se alcuni giochi potrebbero usarla.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"La lingua {userLanguage} non è attualmente disponibile su roblox.com. I contenuti di gioco saranno in lingua {platformLanguage}, e roblox.com è stato impostato in lingua inglese.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "La lingua {userLanguage} non è attualmente disponibile su roblox.com. I contenuti di gioco saranno in lingua {platformLanguage}, e roblox.com è stato impostato in lingua inglese.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Acquista oggetto";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Lingua non supportata";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "Su di noi";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Errore di autenticazione";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Contrassegni";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Lavora con noi";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Configura";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Configura partita";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Configura località";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "Configura server VIP";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Contattaci";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Crea";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Crea partita";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Crea gruppo";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Scopri";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Preferiti";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "I miei Feed";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Non trovi più \"I miei Feed\"? Guarda nel menu laterale";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Guida";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Lavori";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Libreria";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Gadget";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Genitori";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Statistiche località";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Giocatori";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Privacy";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Riscuoti carte Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Avatar";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Catalogo";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Sviluppa";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Eventi";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Forum";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Amici";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Giochi";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Gruppi";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Home";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Inventario";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Accedi";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Messaggi";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Profilo";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Cerca";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Cerca \"{phrase}\" in {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Cerca \"{phrase}\" in {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Negozio";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Registrati";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Negozio";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Scambia";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Assistenza";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Temini";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Termini di servizio";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Grazie";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Migliora";
	}
}
