namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_id_id : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Kembali ke Atas";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Beli Akses";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Batal";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Oke";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Tingkatkan Sekarang";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, logo Roblox dan Powering Imagination termasuk dalam merek-merek dagang kami yang terdaftar dan tidak terdaftar di AS dan negara lainnya.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Meskipun beberapa game dapat menggunakan bahasa tertentu, tapi fitur itu tidak sepenuhnya didukung oleh roblox.com.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Beli Item";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Bahasa yang Tidak Didukung";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "Tentang Kami";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Kesalahan Autentikasi";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Lencana";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Karier";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Konfigurasi";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Konfigurasi Game";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Konfigurasikan Tempat";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "Konfigurasi VIP Server";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Hubungi Kami";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Buat";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Buat Game";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Buat Grup";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Temukan";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favorit";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Feed Saya";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Mencari Feed Saya? Kini bisa ditemukan di menu samping";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Bantuan";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Pekerjaan";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Perpustakaan";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Cendera mata";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Orang Tua";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Statistik Penempatan";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Pemain";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Privasi";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Tukarkan Kartu Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Avatar";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Katalog";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Kembangkan";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Event";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Forum";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Teman";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Game";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Grup";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Beranda";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Inventaris";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Masuk";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Pesan";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Profil";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Cari";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Toko";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Daftar";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Toko";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Dagang";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Dukungan";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Ketentuan";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Ketentuan Penggunaan";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Terima Kasih";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Tingkatkan";

	public FeaturesResources_id_id(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Kembali ke Atas";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Beli Akses";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Batal";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Oke";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Tingkatkan Sekarang";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"Apakah kamu ingin membeli akses ke Tempat: {placeName} dari {creatorName} seharga {robux}?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "Apakah kamu ingin membeli akses ke Tempat: {placeName} dari {creatorName} seharga {robux}?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, logo Roblox dan Powering Imagination termasuk dalam merek-merek dagang kami yang terdaftar dan tidak terdaftar di AS dan negara lainnya.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, logo Roblox, dan Powering Imagination termasuk dalam merek-merek dagang kami yang terdaftar dan tidak terdaftar di AS dan negara lainnya.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, logo Roblox, dan Powering Imagination termasuk dalam merek-merek dagang kami yang terdaftar dan tidak terdaftar di AS dan negara lainnya.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Meskipun beberapa game dapat menggunakan bahasa tertentu, tapi fitur itu tidak sepenuhnya didukung oleh roblox.com.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} saat ini tidak tersedia di roblox.com. Kamu dapat menikmati konten di game dalam bahasa {platformLanguage}, dan roblox.com sudah diatur ke bahasa Inggris.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} saat ini tidak tersedia di roblox.com. Kamu dapat menikmati konten di game dalam bahasa {platformLanguage}, dan roblox.com sudah diatur ke bahasa Inggris.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Beli Item";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Bahasa yang Tidak Didukung";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "Tentang Kami";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Kesalahan Autentikasi";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Lencana";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Karier";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Konfigurasi";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Konfigurasi Game";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Konfigurasikan Tempat";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "Konfigurasi VIP Server";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Hubungi Kami";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Buat";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Buat Game";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Buat Grup";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Temukan";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favorit";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Feed Saya";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Mencari Feed Saya? Kini bisa ditemukan di menu samping";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Bantuan";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Pekerjaan";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Perpustakaan";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Cendera mata";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Orang Tua";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Statistik Penempatan";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Pemain";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Privasi";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Tukarkan Kartu Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Avatar";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Katalog";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Kembangkan";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Event";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Forum";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Teman";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Game";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Grup";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Beranda";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Inventaris";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Masuk";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Pesan";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Profil";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Cari";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Cari \"{phrase}\" di {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Cari \"{phrase}\" di {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Toko";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Daftar";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Toko";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Dagang";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Dukungan";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Ketentuan";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Ketentuan Penggunaan";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Terima Kasih";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Tingkatkan";
	}
}
