namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_fr_fr : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Retour en haut";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Acheter accès";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Annuler";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Ok";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Améliorer";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, le logo Roblox et Powering Imagination font partie de nos marques de commerce déposées et non déposées aux États-Unis et dans d'autres pays.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Certains jeux ont été tranduits dans la langue sélectionnée mais toutes les langues ne sont pas supportées par roblox.com";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Acheter objet";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Langue non-disponible";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "À propos de nous";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Erreur d'authentification";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Badges";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Carrières";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Configurer";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Configuration du jeu";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Configurer l'emplacement";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "Configuration du serveur VIP";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Contact";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Créer";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Créer une partie";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Créer un groupe";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Découvrir";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoris";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Mes actus";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Les actus sont maintenant dans le menu de côté";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Aide";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Emplois";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Bibliothèque";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Marchandise";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Parents";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Statistiques d'emplacement";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Joueurs";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Confidentialité";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Activer une carte Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Avatar";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Catalogue";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Développer";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Événements";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Forum";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Amis";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Jeux";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Groupes";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Accueil";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Inventaire";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Connexion";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Messages";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Profil";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Rechercher";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Boutique";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "S'inscrire";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Boutique";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Échange";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Assistance";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Conditions";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Conditions d'utilisation";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Merci";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Améliorer";

	public FeaturesResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Retour en haut";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Acheter accès";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Annuler";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Ok";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Améliorer";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"Souhaitez-vous acheter l'accès à l'emplacement\u00a0: {placeName} de {creatorName} pour {robux}\u00a0?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "Souhaitez-vous acheter l'accès à l'emplacement\u00a0: {placeName} de {creatorName} pour {robux}\u00a0?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, le logo Roblox et Powering Imagination font partie de nos marques de commerce déposées et non déposées aux États-Unis et dans d'autres pays.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, le logo Roblox et Powering Imagination font partie de nos marques de commerce déposées ou non, aux États-Unis et dans d'autres pays.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, le logo Roblox et Powering Imagination font partie de nos marques de commerce déposées ou non, aux États-Unis et dans d'autres pays.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Certains jeux ont été tranduits dans la langue sélectionnée mais toutes les langues ne sont pas supportées par roblox.com";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} est indisponible sur Roblox.com. Tu verras du contenu en-jeu en {platformLanguage}, et roblox.com a été lancé en anglais.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} est indisponible sur Roblox.com. Tu verras du contenu en-jeu en {platformLanguage}, et roblox.com a été lancé en anglais.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Acheter objet";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Langue non-disponible";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "À propos de nous";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Erreur d'authentification";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Badges";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Carrières";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Configurer";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Configuration du jeu";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Configurer l'emplacement";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "Configuration du serveur VIP";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Contact";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Créer";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Créer une partie";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Créer un groupe";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Découvrir";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoris";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Mes actus";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Les actus sont maintenant dans le menu de côté";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Aide";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Emplois";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Bibliothèque";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Marchandise";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Parents";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Statistiques d'emplacement";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Joueurs";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Confidentialité";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Activer une carte Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Avatar";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Catalogue";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Développer";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Événements";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Forum";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Amis";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Jeux";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Groupes";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Accueil";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Inventaire";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Connexion";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Messages";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Profil";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Rechercher";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Rechercher \"{phrase}\" dans {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Rechercher \"{phrase}\" dans {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Boutique";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "S'inscrire";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Boutique";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Échange";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Assistance";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Conditions";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Conditions d'utilisation";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Merci";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Améliorer";
	}
}
