namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_es_es : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Volver arriba";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Comprar acceso";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Cancelar";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Aceptar";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Mejorar ahora";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, el logotipo de Roblox y Powering Imagination son algunas de nuestras marcas registradas y no registradas en los Estados Unidos y otros países.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Aunque algunos juegos están disponibles en el idioma seleccionado, el que acabas de elegir no es totalmente compatible con roblox.com.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Comprar objeto";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Idiomas no compatibles";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "Quiénes somos";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Error de autenticación";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Emblemas";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Empleo";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Configurar";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Configuración del juego";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Configurar el lugar";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "Configuración del servidor VIP";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Contáctanos";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Crear";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Crear juego";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Crear grupo";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Descubrir";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoritos";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Mis noticias";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "¿Estás buscando Mis noticias? Ahora encontrarás el enlace en el menú lateral.";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Ayuda";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Empleo";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Biblioteca";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Mercancía";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Padres";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Estadísticas del lugar";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Jugadores";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Privacidad";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Canjeo de tarjetas de Roblox";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Avatar";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Catálogo";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Desarrolla";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Eventos";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Foro";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Amigos";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Juegos";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Grupos";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Inicio";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Inventario";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Iniciar sesión";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Mensajes";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Perfil";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Buscar";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Tienda";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Registro";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Tienda";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Intercambiar";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Asistencia técnica";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Términos";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Términos de uso";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Gracias";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Actualizar";

	public FeaturesResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Volver arriba";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Comprar acceso";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Cancelar";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Aceptar";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Mejorar ahora";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"¿Quieres comprarle el acceso al lugar: {placeName} de {creatorName} por {robux}?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "¿Quieres comprarle el acceso al lugar: {placeName} de {creatorName} por {robux}?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, el logotipo de Roblox y Powering Imagination son algunas de nuestras marcas registradas y no registradas en los Estados Unidos y otros países.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, el logotipo de Roblox y Powering Imagination son algunas de nuestras marcas registradas y no registradas en los Estados Unidos y otros países.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, el logotipo de Roblox y Powering Imagination son algunas de nuestras marcas registradas y no registradas en los Estados Unidos y otros países.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Aunque algunos juegos están disponibles en el idioma seleccionado, el que acabas de elegir no es totalmente compatible con roblox.com.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} no es actualmente compatible en roblox.com. Verás el contenido en el juego en {platformLanguage} y roblox.com está en inglés.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} no es actualmente compatible en roblox.com. Verás el contenido en el juego en {platformLanguage} y roblox.com está en inglés.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Comprar objeto";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Idiomas no compatibles";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "Quiénes somos";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Error de autenticación";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Emblemas";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Empleo";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Configurar";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Configuración del juego";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Configurar el lugar";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "Configuración del servidor VIP";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Contáctanos";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Crear";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Crear juego";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Crear grupo";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Descubrir";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Mis noticias";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "¿Estás buscando Mis noticias? Ahora encontrarás el enlace en el menú lateral.";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Ayuda";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Empleo";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Biblioteca";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Mercancía";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Padres";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Estadísticas del lugar";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Jugadores";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Privacidad";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Canjeo de tarjetas de Roblox";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Avatar";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Catálogo";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Desarrolla";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Eventos";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Foro";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Amigos";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Juegos";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Grupos";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Inicio";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Inventario";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Iniciar sesión";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Mensajes";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Perfil";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Buscar";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Buscar {phrase} en {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Buscar {phrase} en {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Tienda";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Registro";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Tienda";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Intercambiar";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Asistencia técnica";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Términos";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Términos de uso";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Gracias";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Actualizar";
	}
}
