namespace Roblox.TranslationResources.CommonUI;

/// <summary>
/// This class overrides FeaturesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class FeaturesResources_de_de : FeaturesResources_en_us, IFeaturesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Action.BackToTop"
	/// English String: "Back To Top"
	/// </summary>
	public override string ActionBackToTop => "Zurück zum Seitenanfang";

	/// <summary>
	/// Key: "Action.BuyAccess"
	/// Purchase access to the place button
	/// English String: "Buy Access"
	/// </summary>
	public override string ActionBuyAccess => "Zugang kaufen";

	/// <summary>
	/// Key: "Action.Cancel"
	/// English String: "Cancel"
	/// </summary>
	public override string ActionCancel => "Abbrechen";

	/// <summary>
	/// Key: "Action.Ok"
	/// English String: "Ok"
	/// </summary>
	public override string ActionOk => "Okay";

	/// <summary>
	/// Key: "Action.sUpgradeNow"
	/// English String: "Upgrade Now"
	/// </summary>
	public override string ActionsUpgradeNow => "Jetzt aufwerten";

	/// <summary>
	/// Key: "Description.CopyRightMessage"
	/// Copyright message at the bottom of the website
	/// English String: "©2018 Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessage => "©2018 Roblox Corporation. Roblox, das Roblox-Logo und „Powering Imagination“ gehören zu unseren eingetragenen und nicht eingetragenen Markenzeichen in den USA und anderen Ländern.";

	/// <summary>
	/// Key: "Description.UnsupportedLanguage"
	/// English String: "While some games may use the selected language, it is not fully supported by roblox.com."
	/// </summary>
	public override string DescriptionUnsupportedLanguage => "Während einige Spiele die ausgewählte Sprache verwenden, wird sie von roblox.com nicht vollständig unterstützt.";

	/// <summary>
	/// Key: "Heading.BuyItem"
	/// Purchase access to the place
	/// English String: "Buy Item"
	/// </summary>
	public override string HeadingBuyItem => "Gegenstand kaufen";

	/// <summary>
	/// Key: "Heading.UnsupportedLanguage"
	/// English String: "Unsupported Language"
	/// </summary>
	public override string HeadingUnsupportedLanguage => "Nicht unterstütze Sprache";

	/// <summary>
	/// Key: "Label.AboutUs"
	/// English String: "About Us"
	/// </summary>
	public override string LabelAboutUs => "Über uns";

	/// <summary>
	/// Key: "Label.AuthenticationError"
	/// page title
	/// English String: "Authentication Error"
	/// </summary>
	public override string LabelAuthenticationError => "Authentifizierungsfehler";

	/// <summary>
	/// Key: "Label.Badges"
	/// page title
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Abzeichen";

	/// <summary>
	/// Key: "Label.Careers"
	/// English String: "Careers"
	/// </summary>
	public override string LabelCareers => "Jobs";

	/// <summary>
	/// Key: "Label.Configure"
	/// Configure
	/// English String: "Configure"
	/// </summary>
	public override string LabelConfigure => "Konfigurieren";

	/// <summary>
	/// Key: "Label.ConfigureGame"
	/// configure game page title
	/// English String: "Configure Game"
	/// </summary>
	public override string LabelConfigureGame => "Spiel konfigurieren";

	/// <summary>
	/// Key: "Label.ConfigurePlace"
	/// Configure Place
	/// English String: "Configure Place"
	/// </summary>
	public override string LabelConfigurePlace => "Ort konfigurieren";

	/// <summary>
	/// Key: "Label.ConfigurePrivateServer"
	/// page title
	/// English String: "Configure VIP Server"
	/// </summary>
	public override string LabelConfigurePrivateServer => "VIP-Server konfigurieren";

	/// <summary>
	/// Key: "Label.ContactUs"
	/// page title
	/// English String: "Contact Us"
	/// </summary>
	public override string LabelContactUs => "Kontakt";

	/// <summary>
	/// Key: "Label.Create"
	/// Alternate name for the "Develop" section of the website
	/// English String: "Create"
	/// </summary>
	public override string LabelCreate => "Erstellen";

	/// <summary>
	/// Key: "Label.CreateGame"
	/// Create Game
	/// English String: "Create Game"
	/// </summary>
	public override string LabelCreateGame => "Spiel erstellen";

	/// <summary>
	/// Key: "Label.CreateGroup"
	/// Create Group
	/// English String: "Create Group"
	/// </summary>
	public override string LabelCreateGroup => "Gruppe erstellen";

	/// <summary>
	/// Key: "Label.Discover"
	/// English String: "Discover"
	/// </summary>
	public override string LabelDiscover => "Entdecke";

	/// <summary>
	/// Key: "Label.Favorites"
	/// Favorites
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoriten";

	/// <summary>
	/// Key: "Label.Feeds"
	/// English String: "My Feed"
	/// </summary>
	public override string LabelFeeds => "Mein Feed";

	/// <summary>
	/// Key: "Label.FindMyFeed"
	/// English String: "Looking for My Feed? It's now in side menu"
	/// </summary>
	public override string LabelFindMyFeed => "Wo ist „Mein Feed“? Sieh im Seitenmenü nach!";

	/// <summary>
	/// Key: "Label.Help"
	/// English String: "Help"
	/// </summary>
	public override string LabelHelp => "Hilfe";

	/// <summary>
	/// Key: "Label.Jobs"
	/// jobs link in footer
	/// English String: "Jobs"
	/// </summary>
	public override string LabelJobs => "Jobs";

	/// <summary>
	/// Key: "Label.Library"
	/// search context for inventory search
	/// English String: "Library"
	/// </summary>
	public override string LabelLibrary => "Bibliothek";

	/// <summary>
	/// Key: "Label.Merch"
	/// English String: "Merchandise"
	/// </summary>
	public override string LabelMerch => "Ware";

	/// <summary>
	/// Key: "Label.Parents"
	/// English String: "Parents"
	/// </summary>
	public override string LabelParents => "Eltern";

	/// <summary>
	/// Key: "Label.PlaceStatistics"
	/// page title
	/// English String: "Place Statistics"
	/// </summary>
	public override string LabelPlaceStatistics => "Ort-Statistik";

	/// <summary>
	/// Key: "Label.Players"
	/// search context for user search
	/// English String: "Players"
	/// </summary>
	public override string LabelPlayers => "Spieler";

	/// <summary>
	/// Key: "Label.Privacy"
	/// English String: "Privacy"
	/// </summary>
	public override string LabelPrivacy => "Datenschutz";

	/// <summary>
	/// Key: "Label.RedeemRobloxCards"
	/// page title
	/// English String: "Redeem Roblox Cards"
	/// </summary>
	public override string LabelRedeemRobloxCards => "Roblox-Karten einlösen";

	/// <summary>
	/// Key: "Label.sAvatar"
	/// English String: "Avatar"
	/// </summary>
	public override string LabelsAvatar => "Avatar";

	/// <summary>
	/// Key: "Label.sBlog"
	/// English String: "Blog"
	/// </summary>
	public override string LabelsBlog => "Blog";

	/// <summary>
	/// Key: "Label.sCatalog"
	/// English String: "Catalog"
	/// </summary>
	public override string LabelsCatalog => "Katalog";

	/// <summary>
	/// Key: "Label.sDevelop"
	/// English String: "Develop"
	/// </summary>
	public override string LabelsDevelop => "Entwickeln";

	/// <summary>
	/// Key: "Label.sEvents"
	/// English String: "Events"
	/// </summary>
	public override string LabelsEvents => "Events";

	/// <summary>
	/// Key: "Label.sForum"
	/// English String: "Forum"
	/// </summary>
	public override string LabelsForum => "Forum";

	/// <summary>
	/// Key: "Label.sFriends"
	/// English String: "Friends"
	/// </summary>
	public override string LabelsFriends => "Freunde";

	/// <summary>
	/// Key: "Label.sGames"
	/// English String: "Games"
	/// </summary>
	public override string LabelsGames => "Spiele";

	/// <summary>
	/// Key: "Label.sGroups"
	/// English String: "Groups"
	/// </summary>
	public override string LabelsGroups => "Gruppen";

	/// <summary>
	/// Key: "Label.sHome"
	/// English String: "Home"
	/// </summary>
	public override string LabelsHome => "Hauptmenü";

	/// <summary>
	/// Key: "Label.sInventory"
	/// English String: "Inventory"
	/// </summary>
	public override string LabelsInventory => "Inventar";

	/// <summary>
	/// Key: "Label.sLogin"
	/// English String: "Log In"
	/// </summary>
	public override string LabelsLogin => "Anmelden";

	/// <summary>
	/// Key: "Label.sMessages"
	/// English String: "Messages"
	/// </summary>
	public override string LabelsMessages => "Nachrichten";

	/// <summary>
	/// Key: "Label.sProfile"
	/// English String: "Profile"
	/// </summary>
	public override string LabelsProfile => "Profil";

	/// <summary>
	/// Key: "Label.sRobux"
	/// English String: "Robux"
	/// </summary>
	public override string LabelsRobux => "Robux";

	/// <summary>
	/// Key: "Label.sSearch"
	/// English String: "Search"
	/// </summary>
	public override string LabelsSearch => "Suchen";

	/// <summary>
	/// Key: "Label.sShop"
	/// English String: "Shop"
	/// </summary>
	public override string LabelsShop => "Shop";

	/// <summary>
	/// Key: "Label.sSignUp"
	/// English String: "Sign Up"
	/// </summary>
	public override string LabelsSignUp => "Registrieren";

	/// <summary>
	/// Key: "Label.Store"
	/// English String: "Store"
	/// </summary>
	public override string LabelStore => "Shop";

	/// <summary>
	/// Key: "Label.sTrade"
	/// English String: "Trade"
	/// </summary>
	public override string LabelsTrade => "Handel";

	/// <summary>
	/// Key: "Label.Support"
	/// page title
	/// English String: "Support"
	/// </summary>
	public override string LabelSupport => "Support";

	/// <summary>
	/// Key: "Label.Terms"
	/// English String: "Terms"
	/// </summary>
	public override string LabelTerms => "Bedingungen";

	/// <summary>
	/// Key: "Label.TermsOfUse"
	/// terms of use link label
	/// English String: "Terms of Use"
	/// </summary>
	public override string LabelTermsOfUse => "Nutzungsbedingungen";

	/// <summary>
	/// Key: "Label.Thanks"
	/// page title
	/// English String: "Thanks"
	/// </summary>
	public override string LabelThanks => "Danke";

	/// <summary>
	/// Key: "Label.Upgrade"
	/// Upgrade
	/// English String: "Upgrade"
	/// </summary>
	public override string LabelUpgrade => "Aufwerten";

	public FeaturesResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForActionBackToTop()
	{
		return "Zurück zum Seitenanfang";
	}

	protected override string _GetTemplateForActionBuyAccess()
	{
		return "Zugang kaufen";
	}

	protected override string _GetTemplateForActionCancel()
	{
		return "Abbrechen";
	}

	protected override string _GetTemplateForActionOk()
	{
		return "Okay";
	}

	protected override string _GetTemplateForActionsUpgradeNow()
	{
		return "Jetzt aufwerten";
	}

	/// <summary>
	/// Key: "BuyAccessToGameForModal"
	/// English String: "Would you like to buy access to the Place: {placeName} from {creatorName} for {robux}?"
	/// </summary>
	public override string BuyAccessToGameForModal(string placeName, string creatorName, string robux)
	{
		return $"Möchtest du Zugang zu diesem Ort kaufen: {placeName} von {creatorName} für {robux}?";
	}

	protected override string _GetTemplateForBuyAccessToGameForModal()
	{
		return "Möchtest du Zugang zu diesem Ort kaufen: {placeName} von {creatorName} für {robux}?";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessage()
	{
		return "©2018 Roblox Corporation. Roblox, das Roblox-Logo und „Powering Imagination“ gehören zu unseren eingetragenen und nicht eingetragenen Markenzeichen in den USA und anderen Ländern.";
	}

	/// <summary>
	/// Key: "Description.CopyRightMessageDynamicYear"
	/// Footer copyright message with dynamic year value
	/// English String: "©{copyrightYear} Roblox Corporation. Roblox, the Roblox logo and Powering Imagination are among our registered and unregistered trademarks in the U.S. and other countries."
	/// </summary>
	public override string DescriptionCopyRightMessageDynamicYear(string copyrightYear)
	{
		return $"©{copyrightYear} Roblox Corporation. Roblox, das Roblox-Logo und „Powering Imagination“ gehören zu unseren eingetragenen und nicht eingetragenen Markenzeichen in den USA und anderen Ländern.";
	}

	protected override string _GetTemplateForDescriptionCopyRightMessageDynamicYear()
	{
		return "©{copyrightYear} Roblox Corporation. Roblox, das Roblox-Logo und „Powering Imagination“ gehören zu unseren eingetragenen und nicht eingetragenen Markenzeichen in den USA und anderen Ländern.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguage()
	{
		return "Während einige Spiele die ausgewählte Sprache verwenden, wird sie von roblox.com nicht vollständig unterstützt.";
	}

	/// <summary>
	/// Key: "Description.UnsupportedLanguageModal"
	/// English String: "{userLanguage} is currently unavailable on roblox.com. You will see in-game content in {platformLanguage}, and roblox.com has been set to English."
	/// </summary>
	public override string DescriptionUnsupportedLanguageModal(string userLanguage, string platformLanguage)
	{
		return $"{userLanguage} ist derzeit auf roblox.com nicht verfügbar. Du siehst In-Game-Inhalte in {platformLanguage} und roblox.com wurde auf Englisch gesetzt.";
	}

	protected override string _GetTemplateForDescriptionUnsupportedLanguageModal()
	{
		return "{userLanguage} ist derzeit auf roblox.com nicht verfügbar. Du siehst In-Game-Inhalte in {platformLanguage} und roblox.com wurde auf Englisch gesetzt.";
	}

	protected override string _GetTemplateForHeadingBuyItem()
	{
		return "Gegenstand kaufen";
	}

	protected override string _GetTemplateForHeadingUnsupportedLanguage()
	{
		return "Nicht unterstütze Sprache";
	}

	protected override string _GetTemplateForLabelAboutUs()
	{
		return "Über uns";
	}

	protected override string _GetTemplateForLabelAuthenticationError()
	{
		return "Authentifizierungsfehler";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Abzeichen";
	}

	protected override string _GetTemplateForLabelCareers()
	{
		return "Jobs";
	}

	protected override string _GetTemplateForLabelConfigure()
	{
		return "Konfigurieren";
	}

	protected override string _GetTemplateForLabelConfigureGame()
	{
		return "Spiel konfigurieren";
	}

	protected override string _GetTemplateForLabelConfigurePlace()
	{
		return "Ort konfigurieren";
	}

	protected override string _GetTemplateForLabelConfigurePrivateServer()
	{
		return "VIP-Server konfigurieren";
	}

	protected override string _GetTemplateForLabelContactUs()
	{
		return "Kontakt";
	}

	protected override string _GetTemplateForLabelCreate()
	{
		return "Erstellen";
	}

	protected override string _GetTemplateForLabelCreateGame()
	{
		return "Spiel erstellen";
	}

	protected override string _GetTemplateForLabelCreateGroup()
	{
		return "Gruppe erstellen";
	}

	protected override string _GetTemplateForLabelDiscover()
	{
		return "Entdecke";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoriten";
	}

	protected override string _GetTemplateForLabelFeeds()
	{
		return "Mein Feed";
	}

	protected override string _GetTemplateForLabelFindMyFeed()
	{
		return "Wo ist „Mein Feed“? Sieh im Seitenmenü nach!";
	}

	protected override string _GetTemplateForLabelHelp()
	{
		return "Hilfe";
	}

	protected override string _GetTemplateForLabelJobs()
	{
		return "Jobs";
	}

	protected override string _GetTemplateForLabelLibrary()
	{
		return "Bibliothek";
	}

	protected override string _GetTemplateForLabelMerch()
	{
		return "Ware";
	}

	protected override string _GetTemplateForLabelParents()
	{
		return "Eltern";
	}

	protected override string _GetTemplateForLabelPlaceStatistics()
	{
		return "Ort-Statistik";
	}

	protected override string _GetTemplateForLabelPlayers()
	{
		return "Spieler";
	}

	protected override string _GetTemplateForLabelPrivacy()
	{
		return "Datenschutz";
	}

	protected override string _GetTemplateForLabelRedeemRobloxCards()
	{
		return "Roblox-Karten einlösen";
	}

	protected override string _GetTemplateForLabelsAvatar()
	{
		return "Avatar";
	}

	protected override string _GetTemplateForLabelsBlog()
	{
		return "Blog";
	}

	protected override string _GetTemplateForLabelsCatalog()
	{
		return "Katalog";
	}

	protected override string _GetTemplateForLabelsDevelop()
	{
		return "Entwickeln";
	}

	protected override string _GetTemplateForLabelsEvents()
	{
		return "Events";
	}

	protected override string _GetTemplateForLabelsForum()
	{
		return "Forum";
	}

	protected override string _GetTemplateForLabelsFriends()
	{
		return "Freunde";
	}

	protected override string _GetTemplateForLabelsGames()
	{
		return "Spiele";
	}

	protected override string _GetTemplateForLabelsGroups()
	{
		return "Gruppen";
	}

	protected override string _GetTemplateForLabelsHome()
	{
		return "Hauptmenü";
	}

	protected override string _GetTemplateForLabelsInventory()
	{
		return "Inventar";
	}

	protected override string _GetTemplateForLabelsLogin()
	{
		return "Anmelden";
	}

	protected override string _GetTemplateForLabelsMessages()
	{
		return "Nachrichten";
	}

	protected override string _GetTemplateForLabelsProfile()
	{
		return "Profil";
	}

	protected override string _GetTemplateForLabelsRobux()
	{
		return "Robux";
	}

	protected override string _GetTemplateForLabelsSearch()
	{
		return "Suchen";
	}

	/// <summary>
	/// Key: "Label.sSearchPhrase"
	/// English String: "Search \"{phrase}\" in {location}"
	/// </summary>
	public override string LabelsSearchPhrase(string phrase, string location)
	{
		return $"Suche „{phrase}“ in {location}";
	}

	protected override string _GetTemplateForLabelsSearchPhrase()
	{
		return "Suche „{phrase}“ in {location}";
	}

	protected override string _GetTemplateForLabelsShop()
	{
		return "Shop";
	}

	protected override string _GetTemplateForLabelsSignUp()
	{
		return "Registrieren";
	}

	protected override string _GetTemplateForLabelStore()
	{
		return "Shop";
	}

	protected override string _GetTemplateForLabelsTrade()
	{
		return "Handel";
	}

	protected override string _GetTemplateForLabelSupport()
	{
		return "Support";
	}

	protected override string _GetTemplateForLabelTerms()
	{
		return "Bedingungen";
	}

	protected override string _GetTemplateForLabelTermsOfUse()
	{
		return "Nutzungsbedingungen";
	}

	protected override string _GetTemplateForLabelThanks()
	{
		return "Danke";
	}

	protected override string _GetTemplateForLabelUpgrade()
	{
		return "Aufwerten";
	}
}
