namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides GameSortsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GameSortsResources_zh_cjv : GameSortsResources_en_us, IGameSortsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Adventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelAdventure => "冒险";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.Contest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelContest => "竞赛";

	/// <summary>
	/// Key: "Label.ContinuePlaying"
	/// English String: "Continue Playing"
	/// </summary>
	public override string LabelContinuePlaying => "继续游戏";

	/// <summary>
	/// Key: "Label.Experimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelExperimental => "推荐";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "最爱";

	/// <summary>
	/// Key: "Label.Featured"
	/// English String: "Featured Rthro"
	/// </summary>
	public override string LabelFeatured => "精选 Rthro";

	/// <summary>
	/// Key: "Label.Fighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelFighting => "格斗";

	/// <summary>
	/// Key: "Label.FriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFriendActivity => "好友动态";

	/// <summary>
	/// Key: "Label.FriendsPlaying"
	/// English String: "Friends Playing"
	/// </summary>
	public override string LabelFriendsPlaying => "好友们正在玩";

	/// <summary>
	/// Key: "Label.GamesForYou"
	/// English String: "Games for You"
	/// </summary>
	public override string LabelGamesForYou => "为你推荐";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string LabelMoreResultsFor => "更多搜索结果：";

	/// <summary>
	/// Key: "Label.MostEngaging"
	/// English String: "Most Engaging"
	/// </summary>
	public override string LabelMostEngaging => "互动性强";

	/// <summary>
	/// Key: "Label.MyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelMyFavorite => "我的最爱";

	/// <summary>
	/// Key: "Label.MyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelMyFavorites => "我的最爱";

	/// <summary>
	/// Key: "Label.MyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelMyRecent => "我的最近活动";

	/// <summary>
	/// Key: "Label.Obby"
	/// English String: "Obby"
	/// </summary>
	public override string LabelObby => "障碍赛跑";

	/// <summary>
	/// Key: "Label.PersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelPersonalizedByLiked => "因为你赞过";

	/// <summary>
	/// Key: "Label.PersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelPersonalServer => "个人服务器";

	/// <summary>
	/// Key: "Label.PlayersLove"
	/// English String: "Players Love"
	/// </summary>
	public override string LabelPlayersLove => "玩家喜欢";

	/// <summary>
	/// Key: "Label.Popular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelPopular => "热门";

	/// <summary>
	/// Key: "Label.PopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelPopularInVr => "VR 热门";

	/// <summary>
	/// Key: "Label.PopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelPopularNearYou => "你附近的热门";

	/// <summary>
	/// Key: "Label.PopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelPopularWorldwide => "全球热门";

	/// <summary>
	/// Key: "Label.Purchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelPurchased => "已购买";

	/// <summary>
	/// Key: "Label.Roleplay"
	/// English String: "Roleplay"
	/// </summary>
	public override string LabelRoleplay => "角色扮演";

	/// <summary>
	/// Key: "Label.Simulator"
	/// English String: "Simulator"
	/// </summary>
	public override string LabelSimulator => "模拟器";

	/// <summary>
	/// Key: "Label.SuggestedGames"
	/// English String: "Suggested Games"
	/// </summary>
	public override string LabelSuggestedGames => "建议游戏";

	/// <summary>
	/// Key: "Label.TopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelTopFavorite => "最受喜爱";

	/// <summary>
	/// Key: "Label.TopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelTopGrossing => "最高收入";

	/// <summary>
	/// Key: "Label.TopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelTopPaid => "最高收益";

	/// <summary>
	/// Key: "Label.TopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelTopRated => "最高评分";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "最佳结果";

	/// <summary>
	/// Key: "Label.TopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelTopRetaining => "推荐";

	/// <summary>
	/// Key: "Label.Tycoon"
	/// English String: "Tycoon"
	/// </summary>
	public override string LabelTycoon => "大亨";

	/// <summary>
	/// Key: "Label.UpAndComing"
	/// English String: "Up-and-Coming"
	/// </summary>
	public override string LabelUpAndComing => "迅速崛起";

	/// <summary>
	/// Key: "MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string MoreResultsFor => "更多搜索结果：";

	public GameSortsResources_zh_cjv(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAdventure()
	{
		return "冒险";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "竞赛";
	}

	protected override string _GetTemplateForLabelContinuePlaying()
	{
		return "继续游戏";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "推荐";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "最爱";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "精选 Rthro";
	}

	protected override string _GetTemplateForLabelFighting()
	{
		return "格斗";
	}

	protected override string _GetTemplateForLabelFriendActivity()
	{
		return "好友动态";
	}

	protected override string _GetTemplateForLabelFriendsPlaying()
	{
		return "好友们正在玩";
	}

	protected override string _GetTemplateForLabelGamesForYou()
	{
		return "为你推荐";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "更多搜索结果：";
	}

	protected override string _GetTemplateForLabelMostEngaging()
	{
		return "互动性强";
	}

	protected override string _GetTemplateForLabelMyFavorite()
	{
		return "我的最爱";
	}

	protected override string _GetTemplateForLabelMyFavorites()
	{
		return "我的最爱";
	}

	protected override string _GetTemplateForLabelMyRecent()
	{
		return "我的最近活动";
	}

	protected override string _GetTemplateForLabelObby()
	{
		return "障碍赛跑";
	}

	protected override string _GetTemplateForLabelPersonalizedByLiked()
	{
		return "因为你赞过";
	}

	protected override string _GetTemplateForLabelPersonalServer()
	{
		return "个人服务器";
	}

	protected override string _GetTemplateForLabelPlayersLove()
	{
		return "玩家喜欢";
	}

	protected override string _GetTemplateForLabelPopular()
	{
		return "热门";
	}

	/// <summary>
	/// Key: "Label.PopularInCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelPopularInCountry(string CountryName)
	{
		return $"{CountryName}热门";
	}

	protected override string _GetTemplateForLabelPopularInCountry()
	{
		return "{CountryName}热门";
	}

	protected override string _GetTemplateForLabelPopularInVr()
	{
		return "VR 热门";
	}

	protected override string _GetTemplateForLabelPopularNearYou()
	{
		return "你附近的热门";
	}

	protected override string _GetTemplateForLabelPopularWorldwide()
	{
		return "全球热门";
	}

	protected override string _GetTemplateForLabelPurchased()
	{
		return "已购买";
	}

	protected override string _GetTemplateForLabelRoleplay()
	{
		return "角色扮演";
	}

	protected override string _GetTemplateForLabelSimulator()
	{
		return "模拟器";
	}

	protected override string _GetTemplateForLabelSuggestedGames()
	{
		return "建议游戏";
	}

	protected override string _GetTemplateForLabelTopFavorite()
	{
		return "最受喜爱";
	}

	protected override string _GetTemplateForLabelTopGrossing()
	{
		return "最高收入";
	}

	protected override string _GetTemplateForLabelTopPaid()
	{
		return "最高收益";
	}

	protected override string _GetTemplateForLabelTopRated()
	{
		return "最高评分";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "最佳结果";
	}

	protected override string _GetTemplateForLabelTopRetaining()
	{
		return "推荐";
	}

	protected override string _GetTemplateForLabelTycoon()
	{
		return "大亨";
	}

	protected override string _GetTemplateForLabelUpAndComing()
	{
		return "迅速崛起";
	}

	protected override string _GetTemplateForMoreResultsFor()
	{
		return "更多搜索结果：";
	}
}
