namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides GameSortsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GameSortsResources_pt_br : GameSortsResources_en_us, IGameSortsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Adventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelAdventure => "Aventura";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.Contest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelContest => "Concurso";

	/// <summary>
	/// Key: "Label.ContinuePlaying"
	/// English String: "Continue Playing"
	/// </summary>
	public override string LabelContinuePlaying => "Continue a jogar";

	/// <summary>
	/// Key: "Label.Experimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelExperimental => "Recomendados";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoritos";

	/// <summary>
	/// Key: "Label.Featured"
	/// English String: "Featured Rthro"
	/// </summary>
	public override string LabelFeatured => "Rthro em destaque";

	/// <summary>
	/// Key: "Label.Fighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelFighting => "Luta";

	/// <summary>
	/// Key: "Label.FriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFriendActivity => "Atividade de amigo";

	/// <summary>
	/// Key: "Label.FriendsPlaying"
	/// English String: "Friends Playing"
	/// </summary>
	public override string LabelFriendsPlaying => "Amigos jogando";

	/// <summary>
	/// Key: "Label.GamesForYou"
	/// English String: "Games for You"
	/// </summary>
	public override string LabelGamesForYou => "Jogos para você";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string LabelMoreResultsFor => "Mais resultados para";

	/// <summary>
	/// Key: "Label.MostEngaging"
	/// English String: "Most Engaging"
	/// </summary>
	public override string LabelMostEngaging => "Mais populares";

	/// <summary>
	/// Key: "Label.MyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelMyFavorite => "Meus favoritos";

	/// <summary>
	/// Key: "Label.MyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelMyFavorites => "Meus favoritos";

	/// <summary>
	/// Key: "Label.MyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelMyRecent => "Meus recentes";

	/// <summary>
	/// Key: "Label.Obby"
	/// English String: "Obby"
	/// </summary>
	public override string LabelObby => "Obby";

	/// <summary>
	/// Key: "Label.PersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelPersonalizedByLiked => "Porque você curtiu";

	/// <summary>
	/// Key: "Label.PersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelPersonalServer => "Servidor pessoal";

	/// <summary>
	/// Key: "Label.PlayersLove"
	/// English String: "Players Love"
	/// </summary>
	public override string LabelPlayersLove => "Curtidos pelos jogadores";

	/// <summary>
	/// Key: "Label.Popular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelPopular => "Popular";

	/// <summary>
	/// Key: "Label.PopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelPopularInVr => "Popular em RV";

	/// <summary>
	/// Key: "Label.PopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelPopularNearYou => "Popular perto de você";

	/// <summary>
	/// Key: "Label.PopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelPopularWorldwide => "Popular no mundo todo";

	/// <summary>
	/// Key: "Label.Purchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelPurchased => "Comprados";

	/// <summary>
	/// Key: "Label.Roleplay"
	/// English String: "Roleplay"
	/// </summary>
	public override string LabelRoleplay => "Roleplay";

	/// <summary>
	/// Key: "Label.Simulator"
	/// English String: "Simulator"
	/// </summary>
	public override string LabelSimulator => "Simulador";

	/// <summary>
	/// Key: "Label.SuggestedGames"
	/// English String: "Suggested Games"
	/// </summary>
	public override string LabelSuggestedGames => "Jogos sugeridos";

	/// <summary>
	/// Key: "Label.TopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelTopFavorite => "Favorito absoluto";

	/// <summary>
	/// Key: "Label.TopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelTopGrossing => "Maior ganho";

	/// <summary>
	/// Key: "Label.TopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelTopPaid => "Populares pagos";

	/// <summary>
	/// Key: "Label.TopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelTopRated => "Melhor avaliação";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Melhores resultados";

	/// <summary>
	/// Key: "Label.TopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelTopRetaining => "Recomendados";

	/// <summary>
	/// Key: "Label.Tycoon"
	/// English String: "Tycoon"
	/// </summary>
	public override string LabelTycoon => "Tycoon";

	/// <summary>
	/// Key: "Label.UpAndComing"
	/// English String: "Up-and-Coming"
	/// </summary>
	public override string LabelUpAndComing => "Revelações";

	/// <summary>
	/// Key: "MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string MoreResultsFor => "Mais resultados para";

	public GameSortsResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAdventure()
	{
		return "Aventura";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Concurso";
	}

	protected override string _GetTemplateForLabelContinuePlaying()
	{
		return "Continue a jogar";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "Rthro em destaque";
	}

	protected override string _GetTemplateForLabelFighting()
	{
		return "Luta";
	}

	protected override string _GetTemplateForLabelFriendActivity()
	{
		return "Atividade de amigo";
	}

	protected override string _GetTemplateForLabelFriendsPlaying()
	{
		return "Amigos jogando";
	}

	protected override string _GetTemplateForLabelGamesForYou()
	{
		return "Jogos para você";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Mais resultados para";
	}

	protected override string _GetTemplateForLabelMostEngaging()
	{
		return "Mais populares";
	}

	protected override string _GetTemplateForLabelMyFavorite()
	{
		return "Meus favoritos";
	}

	protected override string _GetTemplateForLabelMyFavorites()
	{
		return "Meus favoritos";
	}

	protected override string _GetTemplateForLabelMyRecent()
	{
		return "Meus recentes";
	}

	protected override string _GetTemplateForLabelObby()
	{
		return "Obby";
	}

	protected override string _GetTemplateForLabelPersonalizedByLiked()
	{
		return "Porque você curtiu";
	}

	protected override string _GetTemplateForLabelPersonalServer()
	{
		return "Servidor pessoal";
	}

	protected override string _GetTemplateForLabelPlayersLove()
	{
		return "Curtidos pelos jogadores";
	}

	protected override string _GetTemplateForLabelPopular()
	{
		return "Popular";
	}

	/// <summary>
	/// Key: "Label.PopularInCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelPopularInCountry(string CountryName)
	{
		return $"Popular no(a) {CountryName}";
	}

	protected override string _GetTemplateForLabelPopularInCountry()
	{
		return "Popular no(a) {CountryName}";
	}

	protected override string _GetTemplateForLabelPopularInVr()
	{
		return "Popular em RV";
	}

	protected override string _GetTemplateForLabelPopularNearYou()
	{
		return "Popular perto de você";
	}

	protected override string _GetTemplateForLabelPopularWorldwide()
	{
		return "Popular no mundo todo";
	}

	protected override string _GetTemplateForLabelPurchased()
	{
		return "Comprados";
	}

	protected override string _GetTemplateForLabelRoleplay()
	{
		return "Roleplay";
	}

	protected override string _GetTemplateForLabelSimulator()
	{
		return "Simulador";
	}

	protected override string _GetTemplateForLabelSuggestedGames()
	{
		return "Jogos sugeridos";
	}

	protected override string _GetTemplateForLabelTopFavorite()
	{
		return "Favorito absoluto";
	}

	protected override string _GetTemplateForLabelTopGrossing()
	{
		return "Maior ganho";
	}

	protected override string _GetTemplateForLabelTopPaid()
	{
		return "Populares pagos";
	}

	protected override string _GetTemplateForLabelTopRated()
	{
		return "Melhor avaliação";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Melhores resultados";
	}

	protected override string _GetTemplateForLabelTopRetaining()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelTycoon()
	{
		return "Tycoon";
	}

	protected override string _GetTemplateForLabelUpAndComing()
	{
		return "Revelações";
	}

	protected override string _GetTemplateForMoreResultsFor()
	{
		return "Mais resultados para";
	}
}
