namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides GameSortsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GameSortsResources_ko_kr : GameSortsResources_en_us, IGameSortsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Adventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelAdventure => "모험";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.Contest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelContest => "콘테스트";

	/// <summary>
	/// Key: "Label.ContinuePlaying"
	/// English String: "Continue Playing"
	/// </summary>
	public override string LabelContinuePlaying => "계속 플레이하기";

	/// <summary>
	/// Key: "Label.Experimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelExperimental => "추천";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "즐겨찾기";

	/// <summary>
	/// Key: "Label.Featured"
	/// English String: "Featured Rthro"
	/// </summary>
	public override string LabelFeatured => "주목 Rthro";

	/// <summary>
	/// Key: "Label.Fighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelFighting => "대전";

	/// <summary>
	/// Key: "Label.FriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFriendActivity => "친구 활동";

	/// <summary>
	/// Key: "Label.FriendsPlaying"
	/// English String: "Friends Playing"
	/// </summary>
	public override string LabelFriendsPlaying => "친구가 플레이 중인 게임";

	/// <summary>
	/// Key: "Label.GamesForYou"
	/// English String: "Games for You"
	/// </summary>
	public override string LabelGamesForYou => "회원님을 위한 게임";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string LabelMoreResultsFor => "다음에 대한 더 많은 검색 결과:";

	/// <summary>
	/// Key: "Label.MostEngaging"
	/// English String: "Most Engaging"
	/// </summary>
	public override string LabelMostEngaging => "가장 주목받는 게임";

	/// <summary>
	/// Key: "Label.MyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelMyFavorite => "내 즐겨찾기";

	/// <summary>
	/// Key: "Label.MyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelMyFavorites => "내 즐겨찾기";

	/// <summary>
	/// Key: "Label.MyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelMyRecent => "최근 플레이";

	/// <summary>
	/// Key: "Label.Obby"
	/// English String: "Obby"
	/// </summary>
	public override string LabelObby => "장애물 코스";

	/// <summary>
	/// Key: "Label.PersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelPersonalizedByLiked => "관심 기반 추천";

	/// <summary>
	/// Key: "Label.PersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelPersonalServer => "개인 서버";

	/// <summary>
	/// Key: "Label.PlayersLove"
	/// English String: "Players Love"
	/// </summary>
	public override string LabelPlayersLove => "선호도 높은 게임";

	/// <summary>
	/// Key: "Label.Popular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelPopular => "인기";

	/// <summary>
	/// Key: "Label.PopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelPopularInVr => "VR에서 인기 게임";

	/// <summary>
	/// Key: "Label.PopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelPopularNearYou => "주변에서 인기";

	/// <summary>
	/// Key: "Label.PopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelPopularWorldwide => "전 세계적으로 인기";

	/// <summary>
	/// Key: "Label.Purchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelPurchased => "구매한 게임";

	/// <summary>
	/// Key: "Label.Roleplay"
	/// English String: "Roleplay"
	/// </summary>
	public override string LabelRoleplay => "롤플레이";

	/// <summary>
	/// Key: "Label.Simulator"
	/// English String: "Simulator"
	/// </summary>
	public override string LabelSimulator => "시뮬레이터";

	/// <summary>
	/// Key: "Label.SuggestedGames"
	/// English String: "Suggested Games"
	/// </summary>
	public override string LabelSuggestedGames => "제안 게임";

	/// <summary>
	/// Key: "Label.TopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelTopFavorite => "최고 즐겨찾기";

	/// <summary>
	/// Key: "Label.TopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelTopGrossing => "최고 수익";

	/// <summary>
	/// Key: "Label.TopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelTopPaid => "최고 매출";

	/// <summary>
	/// Key: "Label.TopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelTopRated => "최고 평점";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "상위 검색 결과";

	/// <summary>
	/// Key: "Label.TopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelTopRetaining => "추천 게임";

	/// <summary>
	/// Key: "Label.Tycoon"
	/// English String: "Tycoon"
	/// </summary>
	public override string LabelTycoon => "타이쿤";

	/// <summary>
	/// Key: "Label.UpAndComing"
	/// English String: "Up-and-Coming"
	/// </summary>
	public override string LabelUpAndComing => "새롭게 떠오르는 게임";

	/// <summary>
	/// Key: "MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string MoreResultsFor => "다음에 대한 더 많은 검색 결과:";

	public GameSortsResources_ko_kr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAdventure()
	{
		return "모험";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "콘테스트";
	}

	protected override string _GetTemplateForLabelContinuePlaying()
	{
		return "계속 플레이하기";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "추천";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "즐겨찾기";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "주목 Rthro";
	}

	protected override string _GetTemplateForLabelFighting()
	{
		return "대전";
	}

	protected override string _GetTemplateForLabelFriendActivity()
	{
		return "친구 활동";
	}

	protected override string _GetTemplateForLabelFriendsPlaying()
	{
		return "친구가 플레이 중인 게임";
	}

	protected override string _GetTemplateForLabelGamesForYou()
	{
		return "회원님을 위한 게임";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "다음에 대한 더 많은 검색 결과:";
	}

	protected override string _GetTemplateForLabelMostEngaging()
	{
		return "가장 주목받는 게임";
	}

	protected override string _GetTemplateForLabelMyFavorite()
	{
		return "내 즐겨찾기";
	}

	protected override string _GetTemplateForLabelMyFavorites()
	{
		return "내 즐겨찾기";
	}

	protected override string _GetTemplateForLabelMyRecent()
	{
		return "최근 플레이";
	}

	protected override string _GetTemplateForLabelObby()
	{
		return "장애물 코스";
	}

	protected override string _GetTemplateForLabelPersonalizedByLiked()
	{
		return "관심 기반 추천";
	}

	protected override string _GetTemplateForLabelPersonalServer()
	{
		return "개인 서버";
	}

	protected override string _GetTemplateForLabelPlayersLove()
	{
		return "선호도 높은 게임";
	}

	protected override string _GetTemplateForLabelPopular()
	{
		return "인기";
	}

	/// <summary>
	/// Key: "Label.PopularInCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelPopularInCountry(string CountryName)
	{
		return $"{CountryName}에서 인기 게임";
	}

	protected override string _GetTemplateForLabelPopularInCountry()
	{
		return "{CountryName}에서 인기 게임";
	}

	protected override string _GetTemplateForLabelPopularInVr()
	{
		return "VR에서 인기 게임";
	}

	protected override string _GetTemplateForLabelPopularNearYou()
	{
		return "주변에서 인기";
	}

	protected override string _GetTemplateForLabelPopularWorldwide()
	{
		return "전 세계적으로 인기";
	}

	protected override string _GetTemplateForLabelPurchased()
	{
		return "구매한 게임";
	}

	protected override string _GetTemplateForLabelRoleplay()
	{
		return "롤플레이";
	}

	protected override string _GetTemplateForLabelSimulator()
	{
		return "시뮬레이터";
	}

	protected override string _GetTemplateForLabelSuggestedGames()
	{
		return "제안 게임";
	}

	protected override string _GetTemplateForLabelTopFavorite()
	{
		return "최고 즐겨찾기";
	}

	protected override string _GetTemplateForLabelTopGrossing()
	{
		return "최고 수익";
	}

	protected override string _GetTemplateForLabelTopPaid()
	{
		return "최고 매출";
	}

	protected override string _GetTemplateForLabelTopRated()
	{
		return "최고 평점";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "상위 검색 결과";
	}

	protected override string _GetTemplateForLabelTopRetaining()
	{
		return "추천 게임";
	}

	protected override string _GetTemplateForLabelTycoon()
	{
		return "타이쿤";
	}

	protected override string _GetTemplateForLabelUpAndComing()
	{
		return "새롭게 떠오르는 게임";
	}

	protected override string _GetTemplateForMoreResultsFor()
	{
		return "다음에 대한 더 많은 검색 결과:";
	}
}
