namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides GameSortsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GameSortsResources_ja_jp : GameSortsResources_en_us, IGameSortsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Adventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelAdventure => "アドベンチャー";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.Contest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelContest => "コンテスト";

	/// <summary>
	/// Key: "Label.ContinuePlaying"
	/// English String: "Continue Playing"
	/// </summary>
	public override string LabelContinuePlaying => "プレイを続ける";

	/// <summary>
	/// Key: "Label.Experimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelExperimental => "おすすめ";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "お気に入り";

	/// <summary>
	/// Key: "Label.Featured"
	/// English String: "Featured Rthro"
	/// </summary>
	public override string LabelFeatured => "注目のRthro";

	/// <summary>
	/// Key: "Label.Fighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelFighting => "格闘";

	/// <summary>
	/// Key: "Label.FriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFriendActivity => "友達のアクティビティ";

	/// <summary>
	/// Key: "Label.FriendsPlaying"
	/// English String: "Friends Playing"
	/// </summary>
	public override string LabelFriendsPlaying => "友達がプレイ中";

	/// <summary>
	/// Key: "Label.GamesForYou"
	/// English String: "Games for You"
	/// </summary>
	public override string LabelGamesForYou => "あなたにおすすめのゲーム";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string LabelMoreResultsFor => "さらに結果を表示する";

	/// <summary>
	/// Key: "Label.MostEngaging"
	/// English String: "Most Engaging"
	/// </summary>
	public override string LabelMostEngaging => "みんなが夢中のゲーム";

	/// <summary>
	/// Key: "Label.MyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelMyFavorite => "あなたのお気に入り";

	/// <summary>
	/// Key: "Label.MyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelMyFavorites => "あなたのお気に入り";

	/// <summary>
	/// Key: "Label.MyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelMyRecent => "最近のプレイ";

	/// <summary>
	/// Key: "Label.Obby"
	/// English String: "Obby"
	/// </summary>
	public override string LabelObby => "オービー（障害物）";

	/// <summary>
	/// Key: "Label.PersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelPersonalizedByLiked => "「いいね」したため";

	/// <summary>
	/// Key: "Label.PersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelPersonalServer => "パーソナルサーバー";

	/// <summary>
	/// Key: "Label.PlayersLove"
	/// English String: "Players Love"
	/// </summary>
	public override string LabelPlayersLove => "プレイヤーに大人気";

	/// <summary>
	/// Key: "Label.Popular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelPopular => "人気";

	/// <summary>
	/// Key: "Label.PopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelPopularInVr => "VRで人気";

	/// <summary>
	/// Key: "Label.PopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelPopularNearYou => "あなたの周りで人気";

	/// <summary>
	/// Key: "Label.PopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelPopularWorldwide => "世界中で人気";

	/// <summary>
	/// Key: "Label.Purchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelPurchased => "購入済み";

	/// <summary>
	/// Key: "Label.Roleplay"
	/// English String: "Roleplay"
	/// </summary>
	public override string LabelRoleplay => "ロールプレイ";

	/// <summary>
	/// Key: "Label.Simulator"
	/// English String: "Simulator"
	/// </summary>
	public override string LabelSimulator => "シミュレータ";

	/// <summary>
	/// Key: "Label.SuggestedGames"
	/// English String: "Suggested Games"
	/// </summary>
	public override string LabelSuggestedGames => "おすすめゲーム";

	/// <summary>
	/// Key: "Label.TopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelTopFavorite => "大人気";

	/// <summary>
	/// Key: "Label.TopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelTopGrossing => "収益トップ";

	/// <summary>
	/// Key: "Label.TopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelTopPaid => "収入トップ";

	/// <summary>
	/// Key: "Label.TopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelTopRated => "高評価";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "上位の結果";

	/// <summary>
	/// Key: "Label.TopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelTopRetaining => "おすすめ";

	/// <summary>
	/// Key: "Label.Tycoon"
	/// English String: "Tycoon"
	/// </summary>
	public override string LabelTycoon => "タイクーン";

	/// <summary>
	/// Key: "Label.UpAndComing"
	/// English String: "Up-and-Coming"
	/// </summary>
	public override string LabelUpAndComing => "話題の新作ゲーム";

	/// <summary>
	/// Key: "MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string MoreResultsFor => "さらに結果を表示する";

	public GameSortsResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAdventure()
	{
		return "アドベンチャー";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "コンテスト";
	}

	protected override string _GetTemplateForLabelContinuePlaying()
	{
		return "プレイを続ける";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "おすすめ";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "お気に入り";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "注目のRthro";
	}

	protected override string _GetTemplateForLabelFighting()
	{
		return "格闘";
	}

	protected override string _GetTemplateForLabelFriendActivity()
	{
		return "友達のアクティビティ";
	}

	protected override string _GetTemplateForLabelFriendsPlaying()
	{
		return "友達がプレイ中";
	}

	protected override string _GetTemplateForLabelGamesForYou()
	{
		return "あなたにおすすめのゲーム";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "さらに結果を表示する";
	}

	protected override string _GetTemplateForLabelMostEngaging()
	{
		return "みんなが夢中のゲーム";
	}

	protected override string _GetTemplateForLabelMyFavorite()
	{
		return "あなたのお気に入り";
	}

	protected override string _GetTemplateForLabelMyFavorites()
	{
		return "あなたのお気に入り";
	}

	protected override string _GetTemplateForLabelMyRecent()
	{
		return "最近のプレイ";
	}

	protected override string _GetTemplateForLabelObby()
	{
		return "オービー（障害物）";
	}

	protected override string _GetTemplateForLabelPersonalizedByLiked()
	{
		return "「いいね」したため";
	}

	protected override string _GetTemplateForLabelPersonalServer()
	{
		return "パーソナルサーバー";
	}

	protected override string _GetTemplateForLabelPlayersLove()
	{
		return "プレイヤーに大人気";
	}

	protected override string _GetTemplateForLabelPopular()
	{
		return "人気";
	}

	/// <summary>
	/// Key: "Label.PopularInCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelPopularInCountry(string CountryName)
	{
		return $"{CountryName} で人気";
	}

	protected override string _GetTemplateForLabelPopularInCountry()
	{
		return "{CountryName} で人気";
	}

	protected override string _GetTemplateForLabelPopularInVr()
	{
		return "VRで人気";
	}

	protected override string _GetTemplateForLabelPopularNearYou()
	{
		return "あなたの周りで人気";
	}

	protected override string _GetTemplateForLabelPopularWorldwide()
	{
		return "世界中で人気";
	}

	protected override string _GetTemplateForLabelPurchased()
	{
		return "購入済み";
	}

	protected override string _GetTemplateForLabelRoleplay()
	{
		return "ロールプレイ";
	}

	protected override string _GetTemplateForLabelSimulator()
	{
		return "シミュレータ";
	}

	protected override string _GetTemplateForLabelSuggestedGames()
	{
		return "おすすめゲーム";
	}

	protected override string _GetTemplateForLabelTopFavorite()
	{
		return "大人気";
	}

	protected override string _GetTemplateForLabelTopGrossing()
	{
		return "収益トップ";
	}

	protected override string _GetTemplateForLabelTopPaid()
	{
		return "収入トップ";
	}

	protected override string _GetTemplateForLabelTopRated()
	{
		return "高評価";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "上位の結果";
	}

	protected override string _GetTemplateForLabelTopRetaining()
	{
		return "おすすめ";
	}

	protected override string _GetTemplateForLabelTycoon()
	{
		return "タイクーン";
	}

	protected override string _GetTemplateForLabelUpAndComing()
	{
		return "話題の新作ゲーム";
	}

	protected override string _GetTemplateForMoreResultsFor()
	{
		return "さらに結果を表示する";
	}
}
