namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides GameSortsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GameSortsResources_fr_fr : GameSortsResources_en_us, IGameSortsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Adventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelAdventure => "Aventure";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.Contest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelContest => "Compétition";

	/// <summary>
	/// Key: "Label.ContinuePlaying"
	/// English String: "Continue Playing"
	/// </summary>
	public override string LabelContinuePlaying => "Continuer à jouer";

	/// <summary>
	/// Key: "Label.Experimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelExperimental => "Recommandés";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoris";

	/// <summary>
	/// Key: "Label.Featured"
	/// English String: "Featured Rthro"
	/// </summary>
	public override string LabelFeatured => "Rthro en vedette";

	/// <summary>
	/// Key: "Label.Fighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelFighting => "Combat";

	/// <summary>
	/// Key: "Label.FriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFriendActivity => "Activité des amis";

	/// <summary>
	/// Key: "Label.FriendsPlaying"
	/// English String: "Friends Playing"
	/// </summary>
	public override string LabelFriendsPlaying => "Amis y jouant";

	/// <summary>
	/// Key: "Label.GamesForYou"
	/// English String: "Games for You"
	/// </summary>
	public override string LabelGamesForYou => "Jeux sélectionnés pour vous";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string LabelMoreResultsFor => "Plus de résultats pour";

	/// <summary>
	/// Key: "Label.MostEngaging"
	/// English String: "Most Engaging"
	/// </summary>
	public override string LabelMostEngaging => "Plus inspirant";

	/// <summary>
	/// Key: "Label.MyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelMyFavorite => "Mes favoris";

	/// <summary>
	/// Key: "Label.MyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelMyFavorites => "Mes favoris";

	/// <summary>
	/// Key: "Label.MyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelMyRecent => "Mes jeux récents";

	/// <summary>
	/// Key: "Label.Obby"
	/// English String: "Obby"
	/// </summary>
	public override string LabelObby => "Obby";

	/// <summary>
	/// Key: "Label.PersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelPersonalizedByLiked => "Car vous avez aimé";

	/// <summary>
	/// Key: "Label.PersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelPersonalServer => "Serveur personnel";

	/// <summary>
	/// Key: "Label.PlayersLove"
	/// English String: "Players Love"
	/// </summary>
	public override string LabelPlayersLove => "Les joueurs adorent";

	/// <summary>
	/// Key: "Label.Popular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelPopular => "Populaires";

	/// <summary>
	/// Key: "Label.PopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelPopularInVr => "Populaires en RV";

	/// <summary>
	/// Key: "Label.PopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelPopularNearYou => "Populaires près de vous";

	/// <summary>
	/// Key: "Label.PopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelPopularWorldwide => "Populaire dans le monde entier";

	/// <summary>
	/// Key: "Label.Purchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelPurchased => "Achetés";

	/// <summary>
	/// Key: "Label.Roleplay"
	/// English String: "Roleplay"
	/// </summary>
	public override string LabelRoleplay => "Jeu de rôles";

	/// <summary>
	/// Key: "Label.Simulator"
	/// English String: "Simulator"
	/// </summary>
	public override string LabelSimulator => "Simulateur";

	/// <summary>
	/// Key: "Label.SuggestedGames"
	/// English String: "Suggested Games"
	/// </summary>
	public override string LabelSuggestedGames => "Jeux suggérés";

	/// <summary>
	/// Key: "Label.TopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelTopFavorite => "Meilleurs favoris";

	/// <summary>
	/// Key: "Label.TopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelTopGrossing => "Meilleurs gains";

	/// <summary>
	/// Key: "Label.TopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelTopPaid => "Meilleurs paiements";

	/// <summary>
	/// Key: "Label.TopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelTopRated => "Meilleures notes";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Meilleur résultat";

	/// <summary>
	/// Key: "Label.TopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelTopRetaining => "Recommandés";

	/// <summary>
	/// Key: "Label.Tycoon"
	/// English String: "Tycoon"
	/// </summary>
	public override string LabelTycoon => "Magnat";

	/// <summary>
	/// Key: "Label.UpAndComing"
	/// English String: "Up-and-Coming"
	/// </summary>
	public override string LabelUpAndComing => "Prometteur";

	/// <summary>
	/// Key: "MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string MoreResultsFor => "Plus de résultats pour";

	public GameSortsResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAdventure()
	{
		return "Aventure";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Compétition";
	}

	protected override string _GetTemplateForLabelContinuePlaying()
	{
		return "Continuer à jouer";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Recommandés";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoris";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "Rthro en vedette";
	}

	protected override string _GetTemplateForLabelFighting()
	{
		return "Combat";
	}

	protected override string _GetTemplateForLabelFriendActivity()
	{
		return "Activité des amis";
	}

	protected override string _GetTemplateForLabelFriendsPlaying()
	{
		return "Amis y jouant";
	}

	protected override string _GetTemplateForLabelGamesForYou()
	{
		return "Jeux sélectionnés pour vous";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Plus de résultats pour";
	}

	protected override string _GetTemplateForLabelMostEngaging()
	{
		return "Plus inspirant";
	}

	protected override string _GetTemplateForLabelMyFavorite()
	{
		return "Mes favoris";
	}

	protected override string _GetTemplateForLabelMyFavorites()
	{
		return "Mes favoris";
	}

	protected override string _GetTemplateForLabelMyRecent()
	{
		return "Mes jeux récents";
	}

	protected override string _GetTemplateForLabelObby()
	{
		return "Obby";
	}

	protected override string _GetTemplateForLabelPersonalizedByLiked()
	{
		return "Car vous avez aimé";
	}

	protected override string _GetTemplateForLabelPersonalServer()
	{
		return "Serveur personnel";
	}

	protected override string _GetTemplateForLabelPlayersLove()
	{
		return "Les joueurs adorent";
	}

	protected override string _GetTemplateForLabelPopular()
	{
		return "Populaires";
	}

	/// <summary>
	/// Key: "Label.PopularInCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelPopularInCountry(string CountryName)
	{
		return $"Populaires ({CountryName})";
	}

	protected override string _GetTemplateForLabelPopularInCountry()
	{
		return "Populaires ({CountryName})";
	}

	protected override string _GetTemplateForLabelPopularInVr()
	{
		return "Populaires en RV";
	}

	protected override string _GetTemplateForLabelPopularNearYou()
	{
		return "Populaires près de vous";
	}

	protected override string _GetTemplateForLabelPopularWorldwide()
	{
		return "Populaire dans le monde entier";
	}

	protected override string _GetTemplateForLabelPurchased()
	{
		return "Achetés";
	}

	protected override string _GetTemplateForLabelRoleplay()
	{
		return "Jeu de rôles";
	}

	protected override string _GetTemplateForLabelSimulator()
	{
		return "Simulateur";
	}

	protected override string _GetTemplateForLabelSuggestedGames()
	{
		return "Jeux suggérés";
	}

	protected override string _GetTemplateForLabelTopFavorite()
	{
		return "Meilleurs favoris";
	}

	protected override string _GetTemplateForLabelTopGrossing()
	{
		return "Meilleurs gains";
	}

	protected override string _GetTemplateForLabelTopPaid()
	{
		return "Meilleurs paiements";
	}

	protected override string _GetTemplateForLabelTopRated()
	{
		return "Meilleures notes";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Meilleur résultat";
	}

	protected override string _GetTemplateForLabelTopRetaining()
	{
		return "Recommandés";
	}

	protected override string _GetTemplateForLabelTycoon()
	{
		return "Magnat";
	}

	protected override string _GetTemplateForLabelUpAndComing()
	{
		return "Prometteur";
	}

	protected override string _GetTemplateForMoreResultsFor()
	{
		return "Plus de résultats pour";
	}
}
