namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides GameSortsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GameSortsResources_es_es : GameSortsResources_en_us, IGameSortsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Adventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelAdventure => "Aventura";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.Contest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelContest => "Concurso";

	/// <summary>
	/// Key: "Label.ContinuePlaying"
	/// English String: "Continue Playing"
	/// </summary>
	public override string LabelContinuePlaying => "Seguir jugando";

	/// <summary>
	/// Key: "Label.Experimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelExperimental => "Recomendados";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoritos";

	/// <summary>
	/// Key: "Label.Featured"
	/// English String: "Featured Rthro"
	/// </summary>
	public override string LabelFeatured => "Rthro promocionado";

	/// <summary>
	/// Key: "Label.Fighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelFighting => "Lucha";

	/// <summary>
	/// Key: "Label.FriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFriendActivity => "Actividad de tus amigos";

	/// <summary>
	/// Key: "Label.FriendsPlaying"
	/// English String: "Friends Playing"
	/// </summary>
	public override string LabelFriendsPlaying => "Amigos que están jugando";

	/// <summary>
	/// Key: "Label.GamesForYou"
	/// English String: "Games for You"
	/// </summary>
	public override string LabelGamesForYou => "Juegos para ti";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string LabelMoreResultsFor => "Más resultados para";

	/// <summary>
	/// Key: "Label.MostEngaging"
	/// English String: "Most Engaging"
	/// </summary>
	public override string LabelMostEngaging => "Los más atractivos";

	/// <summary>
	/// Key: "Label.MyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelMyFavorite => "Mis favoritos";

	/// <summary>
	/// Key: "Label.MyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelMyFavorites => "Mis favoritos";

	/// <summary>
	/// Key: "Label.MyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelMyRecent => "Mis recientes";

	/// <summary>
	/// Key: "Label.Obby"
	/// English String: "Obby"
	/// </summary>
	public override string LabelObby => "Obby";

	/// <summary>
	/// Key: "Label.PersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelPersonalizedByLiked => "Porque te gustó";

	/// <summary>
	/// Key: "Label.PersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelPersonalServer => "Servidor personal";

	/// <summary>
	/// Key: "Label.PlayersLove"
	/// English String: "Players Love"
	/// </summary>
	public override string LabelPlayersLove => "A los jugadores les encanta";

	/// <summary>
	/// Key: "Label.Popular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelPopular => "Populares";

	/// <summary>
	/// Key: "Label.PopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelPopularInVr => "Popular en RV";

	/// <summary>
	/// Key: "Label.PopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelPopularNearYou => "Populares cerca de ti";

	/// <summary>
	/// Key: "Label.PopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelPopularWorldwide => "Populares en todo el mundo";

	/// <summary>
	/// Key: "Label.Purchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelPurchased => "Comprados";

	/// <summary>
	/// Key: "Label.Roleplay"
	/// English String: "Roleplay"
	/// </summary>
	public override string LabelRoleplay => "Juegos de rol";

	/// <summary>
	/// Key: "Label.Simulator"
	/// English String: "Simulator"
	/// </summary>
	public override string LabelSimulator => "Simulador";

	/// <summary>
	/// Key: "Label.SuggestedGames"
	/// English String: "Suggested Games"
	/// </summary>
	public override string LabelSuggestedGames => "Juegos sugeridos";

	/// <summary>
	/// Key: "Label.TopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelTopFavorite => "Más favoritos";

	/// <summary>
	/// Key: "Label.TopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelTopGrossing => "Más rentables";

	/// <summary>
	/// Key: "Label.TopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelTopPaid => "Mejores de pago";

	/// <summary>
	/// Key: "Label.TopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelTopRated => "Mejor valorados";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Mejor resultado";

	/// <summary>
	/// Key: "Label.TopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelTopRetaining => "Recomendados";

	/// <summary>
	/// Key: "Label.Tycoon"
	/// English String: "Tycoon"
	/// </summary>
	public override string LabelTycoon => "Magnate";

	/// <summary>
	/// Key: "Label.UpAndComing"
	/// English String: "Up-and-Coming"
	/// </summary>
	public override string LabelUpAndComing => "Prometedores";

	/// <summary>
	/// Key: "MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string MoreResultsFor => "Más resultados para";

	public GameSortsResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAdventure()
	{
		return "Aventura";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Concurso";
	}

	protected override string _GetTemplateForLabelContinuePlaying()
	{
		return "Seguir jugando";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoritos";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "Rthro promocionado";
	}

	protected override string _GetTemplateForLabelFighting()
	{
		return "Lucha";
	}

	protected override string _GetTemplateForLabelFriendActivity()
	{
		return "Actividad de tus amigos";
	}

	protected override string _GetTemplateForLabelFriendsPlaying()
	{
		return "Amigos que están jugando";
	}

	protected override string _GetTemplateForLabelGamesForYou()
	{
		return "Juegos para ti";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Más resultados para";
	}

	protected override string _GetTemplateForLabelMostEngaging()
	{
		return "Los más atractivos";
	}

	protected override string _GetTemplateForLabelMyFavorite()
	{
		return "Mis favoritos";
	}

	protected override string _GetTemplateForLabelMyFavorites()
	{
		return "Mis favoritos";
	}

	protected override string _GetTemplateForLabelMyRecent()
	{
		return "Mis recientes";
	}

	protected override string _GetTemplateForLabelObby()
	{
		return "Obby";
	}

	protected override string _GetTemplateForLabelPersonalizedByLiked()
	{
		return "Porque te gustó";
	}

	protected override string _GetTemplateForLabelPersonalServer()
	{
		return "Servidor personal";
	}

	protected override string _GetTemplateForLabelPlayersLove()
	{
		return "A los jugadores les encanta";
	}

	protected override string _GetTemplateForLabelPopular()
	{
		return "Populares";
	}

	/// <summary>
	/// Key: "Label.PopularInCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelPopularInCountry(string CountryName)
	{
		return $"Popular en {CountryName}";
	}

	protected override string _GetTemplateForLabelPopularInCountry()
	{
		return "Popular en {CountryName}";
	}

	protected override string _GetTemplateForLabelPopularInVr()
	{
		return "Popular en RV";
	}

	protected override string _GetTemplateForLabelPopularNearYou()
	{
		return "Populares cerca de ti";
	}

	protected override string _GetTemplateForLabelPopularWorldwide()
	{
		return "Populares en todo el mundo";
	}

	protected override string _GetTemplateForLabelPurchased()
	{
		return "Comprados";
	}

	protected override string _GetTemplateForLabelRoleplay()
	{
		return "Juegos de rol";
	}

	protected override string _GetTemplateForLabelSimulator()
	{
		return "Simulador";
	}

	protected override string _GetTemplateForLabelSuggestedGames()
	{
		return "Juegos sugeridos";
	}

	protected override string _GetTemplateForLabelTopFavorite()
	{
		return "Más favoritos";
	}

	protected override string _GetTemplateForLabelTopGrossing()
	{
		return "Más rentables";
	}

	protected override string _GetTemplateForLabelTopPaid()
	{
		return "Mejores de pago";
	}

	protected override string _GetTemplateForLabelTopRated()
	{
		return "Mejor valorados";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Mejor resultado";
	}

	protected override string _GetTemplateForLabelTopRetaining()
	{
		return "Recomendados";
	}

	protected override string _GetTemplateForLabelTycoon()
	{
		return "Magnate";
	}

	protected override string _GetTemplateForLabelUpAndComing()
	{
		return "Prometedores";
	}

	protected override string _GetTemplateForMoreResultsFor()
	{
		return "Más resultados para";
	}
}
