namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides GameSortsResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class GameSortsResources_de_de : GameSortsResources_en_us, IGameSortsResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Adventure"
	/// English String: "Adventure"
	/// </summary>
	public override string LabelAdventure => "Abenteuer";

	/// <summary>
	/// Key: "Label.BuildersClub"
	/// English String: "Builders Club"
	/// </summary>
	public override string LabelBuildersClub => "Builders Club";

	/// <summary>
	/// Key: "Label.Contest"
	/// English String: "Contest"
	/// </summary>
	public override string LabelContest => "Wettbewerb";

	/// <summary>
	/// Key: "Label.ContinuePlaying"
	/// English String: "Continue Playing"
	/// </summary>
	public override string LabelContinuePlaying => "Weiterspielen";

	/// <summary>
	/// Key: "Label.Experimental"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelExperimental => "Empfohlen";

	/// <summary>
	/// Key: "Label.Favorites"
	/// English String: "Favorites"
	/// </summary>
	public override string LabelFavorites => "Favoriten";

	/// <summary>
	/// Key: "Label.Featured"
	/// English String: "Featured Rthro"
	/// </summary>
	public override string LabelFeatured => "Highlight-Rthro";

	/// <summary>
	/// Key: "Label.Fighting"
	/// English String: "Fighting"
	/// </summary>
	public override string LabelFighting => "Kampf";

	/// <summary>
	/// Key: "Label.FriendActivity"
	/// English String: "Friend Activity"
	/// </summary>
	public override string LabelFriendActivity => "Freundesaktivität";

	/// <summary>
	/// Key: "Label.FriendsPlaying"
	/// English String: "Friends Playing"
	/// </summary>
	public override string LabelFriendsPlaying => "Spielende Freunde";

	/// <summary>
	/// Key: "Label.GamesForYou"
	/// English String: "Games for You"
	/// </summary>
	public override string LabelGamesForYou => "Spiele für dich";

	/// <summary>
	/// Key: "Label.MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string LabelMoreResultsFor => "Mehr Ergebnisse für";

	/// <summary>
	/// Key: "Label.MostEngaging"
	/// English String: "Most Engaging"
	/// </summary>
	public override string LabelMostEngaging => "Am meisten ansprechend";

	/// <summary>
	/// Key: "Label.MyFavorite"
	/// English String: "My Favorite"
	/// </summary>
	public override string LabelMyFavorite => "Meine Favoriten";

	/// <summary>
	/// Key: "Label.MyFavorites"
	/// English String: "My Favorites"
	/// </summary>
	public override string LabelMyFavorites => "Meine Favoriten";

	/// <summary>
	/// Key: "Label.MyRecent"
	/// English String: "My Recent"
	/// </summary>
	public override string LabelMyRecent => "Zuletzt gespielt";

	/// <summary>
	/// Key: "Label.Obby"
	/// English String: "Obby"
	/// </summary>
	public override string LabelObby => "Obby";

	/// <summary>
	/// Key: "Label.PersonalizedByLiked"
	/// English String: "Because You Liked"
	/// </summary>
	public override string LabelPersonalizedByLiked => "Weil dir das gefallen hat";

	/// <summary>
	/// Key: "Label.PersonalServer"
	/// English String: "Personal Server"
	/// </summary>
	public override string LabelPersonalServer => "Persönlicher Server";

	/// <summary>
	/// Key: "Label.PlayersLove"
	/// English String: "Players Love"
	/// </summary>
	public override string LabelPlayersLove => "Spieler lieben";

	/// <summary>
	/// Key: "Label.Popular"
	/// English String: "Popular"
	/// </summary>
	public override string LabelPopular => "Beliebt";

	/// <summary>
	/// Key: "Label.PopularInVr"
	/// English String: "Popular in VR"
	/// </summary>
	public override string LabelPopularInVr => "Beliebt in VR";

	/// <summary>
	/// Key: "Label.PopularNearYou"
	/// English String: "Popular Near You"
	/// </summary>
	public override string LabelPopularNearYou => "Beliebt in deiner Umgebung";

	/// <summary>
	/// Key: "Label.PopularWorldwide"
	/// English String: "Popular Worldwide"
	/// </summary>
	public override string LabelPopularWorldwide => "Weltweit beliebt";

	/// <summary>
	/// Key: "Label.Purchased"
	/// English String: "Purchased"
	/// </summary>
	public override string LabelPurchased => "Gekauft";

	/// <summary>
	/// Key: "Label.Roleplay"
	/// English String: "Roleplay"
	/// </summary>
	public override string LabelRoleplay => "Rollenspiel";

	/// <summary>
	/// Key: "Label.Simulator"
	/// English String: "Simulator"
	/// </summary>
	public override string LabelSimulator => "Simulator";

	/// <summary>
	/// Key: "Label.SuggestedGames"
	/// English String: "Suggested Games"
	/// </summary>
	public override string LabelSuggestedGames => "Vorgeschlagene Spiele";

	/// <summary>
	/// Key: "Label.TopFavorite"
	/// English String: "Top Favorite"
	/// </summary>
	public override string LabelTopFavorite => "Superbeliebt";

	/// <summary>
	/// Key: "Label.TopGrossing"
	/// English String: "Top Earning"
	/// </summary>
	public override string LabelTopGrossing => "Top-Verdienst";

	/// <summary>
	/// Key: "Label.TopPaid"
	/// English String: "Top Paid"
	/// </summary>
	public override string LabelTopPaid => "Top-Bezahlt";

	/// <summary>
	/// Key: "Label.TopRated"
	/// English String: "Top Rated"
	/// </summary>
	public override string LabelTopRated => "Top-Bewertung";

	/// <summary>
	/// Key: "Label.TopResult"
	/// English String: "Top Result"
	/// </summary>
	public override string LabelTopResult => "Top-Ergebnis";

	/// <summary>
	/// Key: "Label.TopRetaining"
	/// English String: "Recommended"
	/// </summary>
	public override string LabelTopRetaining => "Empfohlen";

	/// <summary>
	/// Key: "Label.Tycoon"
	/// English String: "Tycoon"
	/// </summary>
	public override string LabelTycoon => "Tycoon";

	/// <summary>
	/// Key: "Label.UpAndComing"
	/// English String: "Up-and-Coming"
	/// </summary>
	public override string LabelUpAndComing => "Aufstrebende";

	/// <summary>
	/// Key: "MoreResultsFor"
	/// English String: "More Results for"
	/// </summary>
	public override string MoreResultsFor => "Mehr Ergebnisse für";

	public GameSortsResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAdventure()
	{
		return "Abenteuer";
	}

	protected override string _GetTemplateForLabelBuildersClub()
	{
		return "Builders Club";
	}

	protected override string _GetTemplateForLabelContest()
	{
		return "Wettbewerb";
	}

	protected override string _GetTemplateForLabelContinuePlaying()
	{
		return "Weiterspielen";
	}

	protected override string _GetTemplateForLabelExperimental()
	{
		return "Empfohlen";
	}

	protected override string _GetTemplateForLabelFavorites()
	{
		return "Favoriten";
	}

	protected override string _GetTemplateForLabelFeatured()
	{
		return "Highlight-Rthro";
	}

	protected override string _GetTemplateForLabelFighting()
	{
		return "Kampf";
	}

	protected override string _GetTemplateForLabelFriendActivity()
	{
		return "Freundesaktivität";
	}

	protected override string _GetTemplateForLabelFriendsPlaying()
	{
		return "Spielende Freunde";
	}

	protected override string _GetTemplateForLabelGamesForYou()
	{
		return "Spiele für dich";
	}

	protected override string _GetTemplateForLabelMoreResultsFor()
	{
		return "Mehr Ergebnisse für";
	}

	protected override string _GetTemplateForLabelMostEngaging()
	{
		return "Am meisten ansprechend";
	}

	protected override string _GetTemplateForLabelMyFavorite()
	{
		return "Meine Favoriten";
	}

	protected override string _GetTemplateForLabelMyFavorites()
	{
		return "Meine Favoriten";
	}

	protected override string _GetTemplateForLabelMyRecent()
	{
		return "Zuletzt gespielt";
	}

	protected override string _GetTemplateForLabelObby()
	{
		return "Obby";
	}

	protected override string _GetTemplateForLabelPersonalizedByLiked()
	{
		return "Weil dir das gefallen hat";
	}

	protected override string _GetTemplateForLabelPersonalServer()
	{
		return "Persönlicher Server";
	}

	protected override string _GetTemplateForLabelPlayersLove()
	{
		return "Spieler lieben";
	}

	protected override string _GetTemplateForLabelPopular()
	{
		return "Beliebt";
	}

	/// <summary>
	/// Key: "Label.PopularInCountry"
	/// English String: "Popular in {CountryName}"
	/// </summary>
	public override string LabelPopularInCountry(string CountryName)
	{
		return $"Beliebt in {CountryName}";
	}

	protected override string _GetTemplateForLabelPopularInCountry()
	{
		return "Beliebt in {CountryName}";
	}

	protected override string _GetTemplateForLabelPopularInVr()
	{
		return "Beliebt in VR";
	}

	protected override string _GetTemplateForLabelPopularNearYou()
	{
		return "Beliebt in deiner Umgebung";
	}

	protected override string _GetTemplateForLabelPopularWorldwide()
	{
		return "Weltweit beliebt";
	}

	protected override string _GetTemplateForLabelPurchased()
	{
		return "Gekauft";
	}

	protected override string _GetTemplateForLabelRoleplay()
	{
		return "Rollenspiel";
	}

	protected override string _GetTemplateForLabelSimulator()
	{
		return "Simulator";
	}

	protected override string _GetTemplateForLabelSuggestedGames()
	{
		return "Vorgeschlagene Spiele";
	}

	protected override string _GetTemplateForLabelTopFavorite()
	{
		return "Superbeliebt";
	}

	protected override string _GetTemplateForLabelTopGrossing()
	{
		return "Top-Verdienst";
	}

	protected override string _GetTemplateForLabelTopPaid()
	{
		return "Top-Bezahlt";
	}

	protected override string _GetTemplateForLabelTopRated()
	{
		return "Top-Bewertung";
	}

	protected override string _GetTemplateForLabelTopResult()
	{
		return "Top-Ergebnis";
	}

	protected override string _GetTemplateForLabelTopRetaining()
	{
		return "Empfohlen";
	}

	protected override string _GetTemplateForLabelTycoon()
	{
		return "Tycoon";
	}

	protected override string _GetTemplateForLabelUpAndComing()
	{
		return "Aufstrebende";
	}

	protected override string _GetTemplateForMoreResultsFor()
	{
		return "Mehr Ergebnisse für";
	}
}
