namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides AssetTypesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AssetTypesResources_zh_tw : AssetTypesResources_en_us, IAssetTypesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "飾品";

	/// <summary>
	/// Key: "Label.Accessory"
	/// Accessory asset group, in singular form
	/// English String: "Accessory"
	/// </summary>
	public override string LabelAccessory => "飾品";

	/// <summary>
	/// Key: "Label.Animation"
	/// Asset type Animation, singular form
	/// English String: "Animation"
	/// </summary>
	public override string LabelAnimation => "動畫";

	/// <summary>
	/// Key: "Label.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "動畫";

	/// <summary>
	/// Key: "Label.Audio"
	/// English String: "Audio"
	/// </summary>
	public override string LabelAudio => "音訊";

	/// <summary>
	/// Key: "Label.AvatarAnimations"
	/// Avatar Animations allow the user to have their character or avatar move differently within the game.
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "虛擬人偶動畫";

	/// <summary>
	/// Key: "Label.Back"
	/// This is the back of a person. The user has an avatar which has a back.
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "背面";

	/// <summary>
	/// Key: "Label.BackAccessory"
	/// English String: "Back Accessory"
	/// </summary>
	public override string LabelBackAccessory => "背面飾品";

	/// <summary>
	/// Key: "Label.Badge"
	/// Asset type Badge, singular form
	/// English String: "Badge"
	/// </summary>
	public override string LabelBadge => "徽章";

	/// <summary>
	/// Key: "Label.Badges"
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "徽章";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "攀爬";

	/// <summary>
	/// Key: "Label.Death"
	/// English String: "Death"
	/// </summary>
	public override string LabelDeath => "死亡";

	/// <summary>
	/// Key: "Label.Decal"
	/// Asset type Decal, singular form
	/// English String: "Decal"
	/// </summary>
	public override string LabelDecal => "貼花";

	/// <summary>
	/// Key: "Label.Decals"
	/// English String: "Decals"
	/// </summary>
	public override string LabelDecals => "貼花";

	/// <summary>
	/// Key: "Label.Emote"
	/// Asset type Emote, singular form
	/// English String: "Emote"
	/// </summary>
	public override string LabelEmote => "動作";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Asset type Emote, plural form
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "動作";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "臉部";

	/// <summary>
	/// Key: "Label.FaceAccessory"
	/// English String: "Face Accessory"
	/// </summary>
	public override string LabelFaceAccessory => "臉部飾品";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "臉部";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "跌落";

	/// <summary>
	/// Key: "Label.Front"
	/// This is the front of a person. The user has an avatar which has a front.
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "正面";

	/// <summary>
	/// Key: "Label.FrontAccessory"
	/// English String: "Front Accessory"
	/// </summary>
	public override string LabelFrontAccessory => "正面飾品";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "遊戲";

	/// <summary>
	/// Key: "Label.GamePass"
	/// Asset type Game Pass, singular form
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "遊戲證";

	/// <summary>
	/// Key: "Label.GamePasses"
	/// English String: "Game Passes"
	/// </summary>
	public override string LabelGamePasses => "遊戲證";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "裝備";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "髮型";

	/// <summary>
	/// Key: "Label.HairAccessory"
	/// English String: "Hair Accessory"
	/// </summary>
	public override string LabelHairAccessory => "髮型飾品";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "帽子";

	/// <summary>
	/// Key: "Label.Hats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelHats => "帽子";

	/// <summary>
	/// Key: "Label.Head"
	/// Asset type Head, singular form
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "頭部";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "頭部";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "閒置";

	/// <summary>
	/// Key: "Label.Image"
	/// Asset type Image, singular form
	/// English String: "Image"
	/// </summary>
	public override string LabelImage => "圖像";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "跳躍";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// Asset type Left Arm, singular form
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "左臂";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// Asset type Left Leg, singular form
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "左腿";

	/// <summary>
	/// Key: "Label.Mesh"
	/// Asset type mesh, singular form
	/// English String: "Mesh"
	/// </summary>
	public override string LabelMesh => "網格";

	/// <summary>
	/// Key: "Label.Meshes"
	/// English String: "Meshes"
	/// </summary>
	public override string LabelMeshes => "網格";

	/// <summary>
	/// Key: "Label.MeshPart"
	/// Asset type Mesh Part, singular form
	/// English String: "Mesh Part"
	/// </summary>
	public override string LabelMeshPart => "網格零件";

	/// <summary>
	/// Key: "Label.Model"
	/// Asset type Model, singular form
	/// English String: "Model"
	/// </summary>
	public override string LabelModel => "模型";

	/// <summary>
	/// Key: "Label.Models"
	/// English String: "Models"
	/// </summary>
	public override string LabelModels => "模型";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "頸部";

	/// <summary>
	/// Key: "Label.NeckAccessory"
	/// English String: "Neck Accessory"
	/// </summary>
	public override string LabelNeckAccessory => "頸部飾品";

	/// <summary>
	/// Key: "Label.Package"
	/// Asset type Package, singular form
	/// English String: "Package"
	/// </summary>
	public override string LabelPackage => "套裝";

	/// <summary>
	/// Key: "Label.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "套裝";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "褲子";

	/// <summary>
	/// Key: "Label.Place"
	/// Asset type Place, singular form
	/// English String: "Place"
	/// </summary>
	public override string LabelPlace => "空間";

	/// <summary>
	/// Key: "Label.Places"
	/// English String: "Places"
	/// </summary>
	public override string LabelPlaces => "空間";

	/// <summary>
	/// Key: "Label.Plugin"
	/// Asset type Plugin, singular form
	/// English String: "Plugin"
	/// </summary>
	public override string LabelPlugin => "外掛程式";

	/// <summary>
	/// Key: "Label.Plugins"
	/// English String: "Plugins"
	/// </summary>
	public override string LabelPlugins => "外掛程式";

	/// <summary>
	/// Key: "Label.Pose"
	/// English String: "Pose"
	/// </summary>
	public override string LabelPose => "姿勢";

	/// <summary>
	/// Key: "Label.RightArm"
	/// Asset type Right Arm, singular form
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "右臂";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// Asset type Right Leg, singular form
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "右腿";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "奔跑";

	/// <summary>
	/// Key: "Label.Shirt"
	/// Asset type Shirt, singular form
	/// English String: "Shirt"
	/// </summary>
	public override string LabelShirt => "襯衫";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "襯衫";

	/// <summary>
	/// Key: "Label.Shoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelShoulder => "肩膀";

	/// <summary>
	/// Key: "Label.ShoulderAccessory"
	/// English String: "Shoulder Accessory"
	/// </summary>
	public override string LabelShoulderAccessory => "肩膀飾品";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "肩膀";

	/// <summary>
	/// Key: "Label.SolidModel"
	/// Asset type Solid Model, singular
	/// English String: "Solid Model"
	/// </summary>
	public override string LabelSolidModel => "固體模型";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "游泳";

	/// <summary>
	/// Key: "Label.Torso"
	/// Asset type Torso, singular form
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "軀幹";

	/// <summary>
	/// Key: "Label.TShirt"
	/// Asset type T-Shirt, singular form
	/// English String: "T-Shirt"
	/// </summary>
	public override string LabelTShirt => "T 恤";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "T 恤";

	/// <summary>
	/// Key: "Label.VipServers"
	/// VIP servers are private servers which users can create to play only with their friends instead of strangers.
	/// English String: "VIP Servers"
	/// </summary>
	public override string LabelVipServers => "VIP 伺服器";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "腰部";

	/// <summary>
	/// Key: "Label.WaistAccessory"
	/// English String: "Waist Accessory"
	/// </summary>
	public override string LabelWaistAccessory => "腰部飾品";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "步行";

	public AssetTypesResources_zh_tw(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "飾品";
	}

	protected override string _GetTemplateForLabelAccessory()
	{
		return "飾品";
	}

	protected override string _GetTemplateForLabelAnimation()
	{
		return "動畫";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "動畫";
	}

	protected override string _GetTemplateForLabelAudio()
	{
		return "音訊";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "虛擬人偶動畫";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "背面";
	}

	protected override string _GetTemplateForLabelBackAccessory()
	{
		return "背面飾品";
	}

	protected override string _GetTemplateForLabelBadge()
	{
		return "徽章";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "徽章";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "攀爬";
	}

	protected override string _GetTemplateForLabelDeath()
	{
		return "死亡";
	}

	protected override string _GetTemplateForLabelDecal()
	{
		return "貼花";
	}

	protected override string _GetTemplateForLabelDecals()
	{
		return "貼花";
	}

	protected override string _GetTemplateForLabelEmote()
	{
		return "動作";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "動作";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "臉部";
	}

	protected override string _GetTemplateForLabelFaceAccessory()
	{
		return "臉部飾品";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "臉部";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "跌落";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "正面";
	}

	protected override string _GetTemplateForLabelFrontAccessory()
	{
		return "正面飾品";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "遊戲";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "遊戲證";
	}

	protected override string _GetTemplateForLabelGamePasses()
	{
		return "遊戲證";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "裝備";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "髮型";
	}

	protected override string _GetTemplateForLabelHairAccessory()
	{
		return "髮型飾品";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "帽子";
	}

	protected override string _GetTemplateForLabelHats()
	{
		return "帽子";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "頭部";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "頭部";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "閒置";
	}

	protected override string _GetTemplateForLabelImage()
	{
		return "圖像";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "跳躍";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "左臂";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "左腿";
	}

	protected override string _GetTemplateForLabelMesh()
	{
		return "網格";
	}

	protected override string _GetTemplateForLabelMeshes()
	{
		return "網格";
	}

	protected override string _GetTemplateForLabelMeshPart()
	{
		return "網格零件";
	}

	protected override string _GetTemplateForLabelModel()
	{
		return "模型";
	}

	protected override string _GetTemplateForLabelModels()
	{
		return "模型";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "頸部";
	}

	protected override string _GetTemplateForLabelNeckAccessory()
	{
		return "頸部飾品";
	}

	protected override string _GetTemplateForLabelPackage()
	{
		return "套裝";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "套裝";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "褲子";
	}

	protected override string _GetTemplateForLabelPlace()
	{
		return "空間";
	}

	protected override string _GetTemplateForLabelPlaces()
	{
		return "空間";
	}

	protected override string _GetTemplateForLabelPlugin()
	{
		return "外掛程式";
	}

	protected override string _GetTemplateForLabelPlugins()
	{
		return "外掛程式";
	}

	protected override string _GetTemplateForLabelPose()
	{
		return "姿勢";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "右臂";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "右腿";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "奔跑";
	}

	protected override string _GetTemplateForLabelShirt()
	{
		return "襯衫";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "襯衫";
	}

	protected override string _GetTemplateForLabelShoulder()
	{
		return "肩膀";
	}

	protected override string _GetTemplateForLabelShoulderAccessory()
	{
		return "肩膀飾品";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "肩膀";
	}

	protected override string _GetTemplateForLabelSolidModel()
	{
		return "固體模型";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "游泳";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "軀幹";
	}

	protected override string _GetTemplateForLabelTShirt()
	{
		return "T 恤";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "T 恤";
	}

	protected override string _GetTemplateForLabelVipServers()
	{
		return "VIP 伺服器";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "腰部";
	}

	protected override string _GetTemplateForLabelWaistAccessory()
	{
		return "腰部飾品";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "步行";
	}
}
