namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides AssetTypesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AssetTypesResources_pt_br : AssetTypesResources_en_us, IAssetTypesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "Acessórios";

	/// <summary>
	/// Key: "Label.Accessory"
	/// Accessory asset group, in singular form
	/// English String: "Accessory"
	/// </summary>
	public override string LabelAccessory => "Acessório";

	/// <summary>
	/// Key: "Label.Animation"
	/// Asset type Animation, singular form
	/// English String: "Animation"
	/// </summary>
	public override string LabelAnimation => "Animações";

	/// <summary>
	/// Key: "Label.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "Animações";

	/// <summary>
	/// Key: "Label.Audio"
	/// English String: "Audio"
	/// </summary>
	public override string LabelAudio => "Áudio";

	/// <summary>
	/// Key: "Label.AvatarAnimations"
	/// Avatar Animations allow the user to have their character or avatar move differently within the game.
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "Animações de avatar";

	/// <summary>
	/// Key: "Label.Back"
	/// This is the back of a person. The user has an avatar which has a back.
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "Costas";

	/// <summary>
	/// Key: "Label.BackAccessory"
	/// English String: "Back Accessory"
	/// </summary>
	public override string LabelBackAccessory => "Acessório de costas";

	/// <summary>
	/// Key: "Label.Badge"
	/// Asset type Badge, singular form
	/// English String: "Badge"
	/// </summary>
	public override string LabelBadge => "Emblemas";

	/// <summary>
	/// Key: "Label.Badges"
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Emblemas";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "Escalar";

	/// <summary>
	/// Key: "Label.Death"
	/// English String: "Death"
	/// </summary>
	public override string LabelDeath => "Morte";

	/// <summary>
	/// Key: "Label.Decal"
	/// Asset type Decal, singular form
	/// English String: "Decal"
	/// </summary>
	public override string LabelDecal => "Adesivos";

	/// <summary>
	/// Key: "Label.Decals"
	/// English String: "Decals"
	/// </summary>
	public override string LabelDecals => "Adesivos";

	/// <summary>
	/// Key: "Label.Emote"
	/// Asset type Emote, singular form
	/// English String: "Emote"
	/// </summary>
	public override string LabelEmote => "Emote";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Asset type Emote, plural form
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "Emotes";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "Rosto";

	/// <summary>
	/// Key: "Label.FaceAccessory"
	/// English String: "Face Accessory"
	/// </summary>
	public override string LabelFaceAccessory => "Acessório de rosto";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Rostos";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "Cair";

	/// <summary>
	/// Key: "Label.Front"
	/// This is the front of a person. The user has an avatar which has a front.
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "Frente";

	/// <summary>
	/// Key: "Label.FrontAccessory"
	/// English String: "Front Accessory"
	/// </summary>
	public override string LabelFrontAccessory => "Acessório da frente";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "Jogo";

	/// <summary>
	/// Key: "Label.GamePass"
	/// Asset type Game Pass, singular form
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "Passe de jogo";

	/// <summary>
	/// Key: "Label.GamePasses"
	/// English String: "Game Passes"
	/// </summary>
	public override string LabelGamePasses => "Passes de jogo";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Equipamentos";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "Cabelo";

	/// <summary>
	/// Key: "Label.HairAccessory"
	/// English String: "Hair Accessory"
	/// </summary>
	public override string LabelHairAccessory => "Acessório de cabelo";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "Chapéu";

	/// <summary>
	/// Key: "Label.Hats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelHats => "Chapéus";

	/// <summary>
	/// Key: "Label.Head"
	/// Asset type Head, singular form
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "Cabeça";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Cabeças";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "Inatividade";

	/// <summary>
	/// Key: "Label.Image"
	/// Asset type Image, singular form
	/// English String: "Image"
	/// </summary>
	public override string LabelImage => "Imagem";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "Pular";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// Asset type Left Arm, singular form
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "Braço esquerdo";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// Asset type Left Leg, singular form
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "Perna esquerda";

	/// <summary>
	/// Key: "Label.Mesh"
	/// Asset type mesh, singular form
	/// English String: "Mesh"
	/// </summary>
	public override string LabelMesh => "Malha";

	/// <summary>
	/// Key: "Label.Meshes"
	/// English String: "Meshes"
	/// </summary>
	public override string LabelMeshes => "Malhas";

	/// <summary>
	/// Key: "Label.MeshPart"
	/// Asset type Mesh Part, singular form
	/// English String: "Mesh Part"
	/// </summary>
	public override string LabelMeshPart => "Parte da malha";

	/// <summary>
	/// Key: "Label.Model"
	/// Asset type Model, singular form
	/// English String: "Model"
	/// </summary>
	public override string LabelModel => "Modelos";

	/// <summary>
	/// Key: "Label.Models"
	/// English String: "Models"
	/// </summary>
	public override string LabelModels => "Modelos";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "Pescoço";

	/// <summary>
	/// Key: "Label.NeckAccessory"
	/// English String: "Neck Accessory"
	/// </summary>
	public override string LabelNeckAccessory => "Acessório de pescoço";

	/// <summary>
	/// Key: "Label.Package"
	/// Asset type Package, singular form
	/// English String: "Package"
	/// </summary>
	public override string LabelPackage => "Pacotes";

	/// <summary>
	/// Key: "Label.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "Pacotes";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Calças";

	/// <summary>
	/// Key: "Label.Place"
	/// Asset type Place, singular form
	/// English String: "Place"
	/// </summary>
	public override string LabelPlace => "Locais";

	/// <summary>
	/// Key: "Label.Places"
	/// English String: "Places"
	/// </summary>
	public override string LabelPlaces => "Locais";

	/// <summary>
	/// Key: "Label.Plugin"
	/// Asset type Plugin, singular form
	/// English String: "Plugin"
	/// </summary>
	public override string LabelPlugin => "Plugins";

	/// <summary>
	/// Key: "Label.Plugins"
	/// English String: "Plugins"
	/// </summary>
	public override string LabelPlugins => "Plugins";

	/// <summary>
	/// Key: "Label.Pose"
	/// English String: "Pose"
	/// </summary>
	public override string LabelPose => "Pose";

	/// <summary>
	/// Key: "Label.RightArm"
	/// Asset type Right Arm, singular form
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "Braço direito";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// Asset type Right Leg, singular form
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "Perna direita";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "Correr";

	/// <summary>
	/// Key: "Label.Shirt"
	/// Asset type Shirt, singular form
	/// English String: "Shirt"
	/// </summary>
	public override string LabelShirt => "Camisas";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Camisas";

	/// <summary>
	/// Key: "Label.Shoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelShoulder => "Ombro";

	/// <summary>
	/// Key: "Label.ShoulderAccessory"
	/// English String: "Shoulder Accessory"
	/// </summary>
	public override string LabelShoulderAccessory => "Acessório de ombro";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "Ombros";

	/// <summary>
	/// Key: "Label.SolidModel"
	/// Asset type Solid Model, singular
	/// English String: "Solid Model"
	/// </summary>
	public override string LabelSolidModel => "Modelo sólido";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "Nadar";

	/// <summary>
	/// Key: "Label.Torso"
	/// Asset type Torso, singular form
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "Tronco";

	/// <summary>
	/// Key: "Label.TShirt"
	/// Asset type T-Shirt, singular form
	/// English String: "T-Shirt"
	/// </summary>
	public override string LabelTShirt => "Camisetas";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Camisetas";

	/// <summary>
	/// Key: "Label.VipServers"
	/// VIP servers are private servers which users can create to play only with their friends instead of strangers.
	/// English String: "VIP Servers"
	/// </summary>
	public override string LabelVipServers => "Servidores VIP";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "Cintura";

	/// <summary>
	/// Key: "Label.WaistAccessory"
	/// English String: "Waist Accessory"
	/// </summary>
	public override string LabelWaistAccessory => "Acessório de cintura";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "Andar";

	public AssetTypesResources_pt_br(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "Acessórios";
	}

	protected override string _GetTemplateForLabelAccessory()
	{
		return "Acessório";
	}

	protected override string _GetTemplateForLabelAnimation()
	{
		return "Animações";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "Animações";
	}

	protected override string _GetTemplateForLabelAudio()
	{
		return "Áudio";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "Animações de avatar";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "Costas";
	}

	protected override string _GetTemplateForLabelBackAccessory()
	{
		return "Acessório de costas";
	}

	protected override string _GetTemplateForLabelBadge()
	{
		return "Emblemas";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Emblemas";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "Escalar";
	}

	protected override string _GetTemplateForLabelDeath()
	{
		return "Morte";
	}

	protected override string _GetTemplateForLabelDecal()
	{
		return "Adesivos";
	}

	protected override string _GetTemplateForLabelDecals()
	{
		return "Adesivos";
	}

	protected override string _GetTemplateForLabelEmote()
	{
		return "Emote";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "Emotes";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "Rosto";
	}

	protected override string _GetTemplateForLabelFaceAccessory()
	{
		return "Acessório de rosto";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Rostos";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "Cair";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "Frente";
	}

	protected override string _GetTemplateForLabelFrontAccessory()
	{
		return "Acessório da frente";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "Jogo";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "Passe de jogo";
	}

	protected override string _GetTemplateForLabelGamePasses()
	{
		return "Passes de jogo";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Equipamentos";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "Cabelo";
	}

	protected override string _GetTemplateForLabelHairAccessory()
	{
		return "Acessório de cabelo";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "Chapéu";
	}

	protected override string _GetTemplateForLabelHats()
	{
		return "Chapéus";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "Cabeça";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Cabeças";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "Inatividade";
	}

	protected override string _GetTemplateForLabelImage()
	{
		return "Imagem";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "Pular";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "Braço esquerdo";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "Perna esquerda";
	}

	protected override string _GetTemplateForLabelMesh()
	{
		return "Malha";
	}

	protected override string _GetTemplateForLabelMeshes()
	{
		return "Malhas";
	}

	protected override string _GetTemplateForLabelMeshPart()
	{
		return "Parte da malha";
	}

	protected override string _GetTemplateForLabelModel()
	{
		return "Modelos";
	}

	protected override string _GetTemplateForLabelModels()
	{
		return "Modelos";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "Pescoço";
	}

	protected override string _GetTemplateForLabelNeckAccessory()
	{
		return "Acessório de pescoço";
	}

	protected override string _GetTemplateForLabelPackage()
	{
		return "Pacotes";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "Pacotes";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Calças";
	}

	protected override string _GetTemplateForLabelPlace()
	{
		return "Locais";
	}

	protected override string _GetTemplateForLabelPlaces()
	{
		return "Locais";
	}

	protected override string _GetTemplateForLabelPlugin()
	{
		return "Plugins";
	}

	protected override string _GetTemplateForLabelPlugins()
	{
		return "Plugins";
	}

	protected override string _GetTemplateForLabelPose()
	{
		return "Pose";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "Braço direito";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "Perna direita";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "Correr";
	}

	protected override string _GetTemplateForLabelShirt()
	{
		return "Camisas";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Camisas";
	}

	protected override string _GetTemplateForLabelShoulder()
	{
		return "Ombro";
	}

	protected override string _GetTemplateForLabelShoulderAccessory()
	{
		return "Acessório de ombro";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "Ombros";
	}

	protected override string _GetTemplateForLabelSolidModel()
	{
		return "Modelo sólido";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "Nadar";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "Tronco";
	}

	protected override string _GetTemplateForLabelTShirt()
	{
		return "Camisetas";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Camisetas";
	}

	protected override string _GetTemplateForLabelVipServers()
	{
		return "Servidores VIP";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "Cintura";
	}

	protected override string _GetTemplateForLabelWaistAccessory()
	{
		return "Acessório de cintura";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "Andar";
	}
}
