namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides AssetTypesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AssetTypesResources_ko_kr : AssetTypesResources_en_us, IAssetTypesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "장신구";

	/// <summary>
	/// Key: "Label.Accessory"
	/// Accessory asset group, in singular form
	/// English String: "Accessory"
	/// </summary>
	public override string LabelAccessory => "장신구";

	/// <summary>
	/// Key: "Label.Animation"
	/// Asset type Animation, singular form
	/// English String: "Animation"
	/// </summary>
	public override string LabelAnimation => "애니메이션";

	/// <summary>
	/// Key: "Label.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "애니메이션";

	/// <summary>
	/// Key: "Label.Audio"
	/// English String: "Audio"
	/// </summary>
	public override string LabelAudio => "오디오";

	/// <summary>
	/// Key: "Label.AvatarAnimations"
	/// Avatar Animations allow the user to have their character or avatar move differently within the game.
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "아바타 애니메이션";

	/// <summary>
	/// Key: "Label.Back"
	/// This is the back of a person. The user has an avatar which has a back.
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "등";

	/// <summary>
	/// Key: "Label.BackAccessory"
	/// English String: "Back Accessory"
	/// </summary>
	public override string LabelBackAccessory => "등 장신구";

	/// <summary>
	/// Key: "Label.Badge"
	/// Asset type Badge, singular form
	/// English String: "Badge"
	/// </summary>
	public override string LabelBadge => "배지";

	/// <summary>
	/// Key: "Label.Badges"
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "배지";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "오르기";

	/// <summary>
	/// Key: "Label.Death"
	/// English String: "Death"
	/// </summary>
	public override string LabelDeath => "사망";

	/// <summary>
	/// Key: "Label.Decal"
	/// Asset type Decal, singular form
	/// English String: "Decal"
	/// </summary>
	public override string LabelDecal => "데칼";

	/// <summary>
	/// Key: "Label.Decals"
	/// English String: "Decals"
	/// </summary>
	public override string LabelDecals => "데칼";

	/// <summary>
	/// Key: "Label.Emote"
	/// Asset type Emote, singular form
	/// English String: "Emote"
	/// </summary>
	public override string LabelEmote => "감정 표현";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Asset type Emote, plural form
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "감정 표현";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "얼굴";

	/// <summary>
	/// Key: "Label.FaceAccessory"
	/// English String: "Face Accessory"
	/// </summary>
	public override string LabelFaceAccessory => "얼굴 장신구";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "얼굴";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "낙하";

	/// <summary>
	/// Key: "Label.Front"
	/// This is the front of a person. The user has an avatar which has a front.
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "가슴";

	/// <summary>
	/// Key: "Label.FrontAccessory"
	/// English String: "Front Accessory"
	/// </summary>
	public override string LabelFrontAccessory => "가슴 장신구";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "게임";

	/// <summary>
	/// Key: "Label.GamePass"
	/// Asset type Game Pass, singular form
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "게임패스";

	/// <summary>
	/// Key: "Label.GamePasses"
	/// English String: "Game Passes"
	/// </summary>
	public override string LabelGamePasses => "게임패스";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "장비";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "헤어";

	/// <summary>
	/// Key: "Label.HairAccessory"
	/// English String: "Hair Accessory"
	/// </summary>
	public override string LabelHairAccessory => "헤어 장신구";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "모자";

	/// <summary>
	/// Key: "Label.Hats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelHats => "모자";

	/// <summary>
	/// Key: "Label.Head"
	/// Asset type Head, singular form
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "머리";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "머리";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "대기";

	/// <summary>
	/// Key: "Label.Image"
	/// Asset type Image, singular form
	/// English String: "Image"
	/// </summary>
	public override string LabelImage => "이미지";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "점프";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// Asset type Left Arm, singular form
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "왼팔";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// Asset type Left Leg, singular form
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "왼 다리";

	/// <summary>
	/// Key: "Label.Mesh"
	/// Asset type mesh, singular form
	/// English String: "Mesh"
	/// </summary>
	public override string LabelMesh => "메시";

	/// <summary>
	/// Key: "Label.Meshes"
	/// English String: "Meshes"
	/// </summary>
	public override string LabelMeshes => "메시";

	/// <summary>
	/// Key: "Label.MeshPart"
	/// Asset type Mesh Part, singular form
	/// English String: "Mesh Part"
	/// </summary>
	public override string LabelMeshPart => "메시 파트";

	/// <summary>
	/// Key: "Label.Model"
	/// Asset type Model, singular form
	/// English String: "Model"
	/// </summary>
	public override string LabelModel => "모델";

	/// <summary>
	/// Key: "Label.Models"
	/// English String: "Models"
	/// </summary>
	public override string LabelModels => "모델";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "목";

	/// <summary>
	/// Key: "Label.NeckAccessory"
	/// English String: "Neck Accessory"
	/// </summary>
	public override string LabelNeckAccessory => "목 장신구";

	/// <summary>
	/// Key: "Label.Package"
	/// Asset type Package, singular form
	/// English String: "Package"
	/// </summary>
	public override string LabelPackage => "패키지";

	/// <summary>
	/// Key: "Label.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "패키지";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "바지";

	/// <summary>
	/// Key: "Label.Place"
	/// Asset type Place, singular form
	/// English String: "Place"
	/// </summary>
	public override string LabelPlace => "장소";

	/// <summary>
	/// Key: "Label.Places"
	/// English String: "Places"
	/// </summary>
	public override string LabelPlaces => "장소";

	/// <summary>
	/// Key: "Label.Plugin"
	/// Asset type Plugin, singular form
	/// English String: "Plugin"
	/// </summary>
	public override string LabelPlugin => "플러그인";

	/// <summary>
	/// Key: "Label.Plugins"
	/// English String: "Plugins"
	/// </summary>
	public override string LabelPlugins => "플러그인";

	/// <summary>
	/// Key: "Label.Pose"
	/// English String: "Pose"
	/// </summary>
	public override string LabelPose => "포즈";

	/// <summary>
	/// Key: "Label.RightArm"
	/// Asset type Right Arm, singular form
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "오른팔";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// Asset type Right Leg, singular form
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "오른 다리";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "달리기";

	/// <summary>
	/// Key: "Label.Shirt"
	/// Asset type Shirt, singular form
	/// English String: "Shirt"
	/// </summary>
	public override string LabelShirt => "셔츠";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "셔츠";

	/// <summary>
	/// Key: "Label.Shoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelShoulder => "어깨";

	/// <summary>
	/// Key: "Label.ShoulderAccessory"
	/// English String: "Shoulder Accessory"
	/// </summary>
	public override string LabelShoulderAccessory => "어깨 장신구";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "어깨";

	/// <summary>
	/// Key: "Label.SolidModel"
	/// Asset type Solid Model, singular
	/// English String: "Solid Model"
	/// </summary>
	public override string LabelSolidModel => "솔리드 모델";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "수영";

	/// <summary>
	/// Key: "Label.Torso"
	/// Asset type Torso, singular form
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "몸통";

	/// <summary>
	/// Key: "Label.TShirt"
	/// Asset type T-Shirt, singular form
	/// English String: "T-Shirt"
	/// </summary>
	public override string LabelTShirt => "티셔츠";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "티셔츠";

	/// <summary>
	/// Key: "Label.VipServers"
	/// VIP servers are private servers which users can create to play only with their friends instead of strangers.
	/// English String: "VIP Servers"
	/// </summary>
	public override string LabelVipServers => "VIP 서버";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "허리";

	/// <summary>
	/// Key: "Label.WaistAccessory"
	/// English String: "Waist Accessory"
	/// </summary>
	public override string LabelWaistAccessory => "허리 장신구";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "걷기";

	public AssetTypesResources_ko_kr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "장신구";
	}

	protected override string _GetTemplateForLabelAccessory()
	{
		return "장신구";
	}

	protected override string _GetTemplateForLabelAnimation()
	{
		return "애니메이션";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "애니메이션";
	}

	protected override string _GetTemplateForLabelAudio()
	{
		return "오디오";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "아바타 애니메이션";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "등";
	}

	protected override string _GetTemplateForLabelBackAccessory()
	{
		return "등 장신구";
	}

	protected override string _GetTemplateForLabelBadge()
	{
		return "배지";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "배지";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "오르기";
	}

	protected override string _GetTemplateForLabelDeath()
	{
		return "사망";
	}

	protected override string _GetTemplateForLabelDecal()
	{
		return "데칼";
	}

	protected override string _GetTemplateForLabelDecals()
	{
		return "데칼";
	}

	protected override string _GetTemplateForLabelEmote()
	{
		return "감정 표현";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "감정 표현";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "얼굴";
	}

	protected override string _GetTemplateForLabelFaceAccessory()
	{
		return "얼굴 장신구";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "얼굴";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "낙하";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "가슴";
	}

	protected override string _GetTemplateForLabelFrontAccessory()
	{
		return "가슴 장신구";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "게임";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "게임패스";
	}

	protected override string _GetTemplateForLabelGamePasses()
	{
		return "게임패스";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "장비";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "헤어";
	}

	protected override string _GetTemplateForLabelHairAccessory()
	{
		return "헤어 장신구";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "모자";
	}

	protected override string _GetTemplateForLabelHats()
	{
		return "모자";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "머리";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "머리";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "대기";
	}

	protected override string _GetTemplateForLabelImage()
	{
		return "이미지";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "점프";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "왼팔";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "왼 다리";
	}

	protected override string _GetTemplateForLabelMesh()
	{
		return "메시";
	}

	protected override string _GetTemplateForLabelMeshes()
	{
		return "메시";
	}

	protected override string _GetTemplateForLabelMeshPart()
	{
		return "메시 파트";
	}

	protected override string _GetTemplateForLabelModel()
	{
		return "모델";
	}

	protected override string _GetTemplateForLabelModels()
	{
		return "모델";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "목";
	}

	protected override string _GetTemplateForLabelNeckAccessory()
	{
		return "목 장신구";
	}

	protected override string _GetTemplateForLabelPackage()
	{
		return "패키지";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "패키지";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "바지";
	}

	protected override string _GetTemplateForLabelPlace()
	{
		return "장소";
	}

	protected override string _GetTemplateForLabelPlaces()
	{
		return "장소";
	}

	protected override string _GetTemplateForLabelPlugin()
	{
		return "플러그인";
	}

	protected override string _GetTemplateForLabelPlugins()
	{
		return "플러그인";
	}

	protected override string _GetTemplateForLabelPose()
	{
		return "포즈";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "오른팔";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "오른 다리";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "달리기";
	}

	protected override string _GetTemplateForLabelShirt()
	{
		return "셔츠";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "셔츠";
	}

	protected override string _GetTemplateForLabelShoulder()
	{
		return "어깨";
	}

	protected override string _GetTemplateForLabelShoulderAccessory()
	{
		return "어깨 장신구";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "어깨";
	}

	protected override string _GetTemplateForLabelSolidModel()
	{
		return "솔리드 모델";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "수영";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "몸통";
	}

	protected override string _GetTemplateForLabelTShirt()
	{
		return "티셔츠";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "티셔츠";
	}

	protected override string _GetTemplateForLabelVipServers()
	{
		return "VIP 서버";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "허리";
	}

	protected override string _GetTemplateForLabelWaistAccessory()
	{
		return "허리 장신구";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "걷기";
	}
}
