namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides AssetTypesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AssetTypesResources_ja_jp : AssetTypesResources_en_us, IAssetTypesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "アクセサリ";

	/// <summary>
	/// Key: "Label.Accessory"
	/// Accessory asset group, in singular form
	/// English String: "Accessory"
	/// </summary>
	public override string LabelAccessory => "アクセサリ";

	/// <summary>
	/// Key: "Label.Animation"
	/// Asset type Animation, singular form
	/// English String: "Animation"
	/// </summary>
	public override string LabelAnimation => "アニメーション";

	/// <summary>
	/// Key: "Label.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "アニメーション";

	/// <summary>
	/// Key: "Label.Audio"
	/// English String: "Audio"
	/// </summary>
	public override string LabelAudio => "オーディオ";

	/// <summary>
	/// Key: "Label.AvatarAnimations"
	/// Avatar Animations allow the user to have their character or avatar move differently within the game.
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "アバターアニメ";

	/// <summary>
	/// Key: "Label.Back"
	/// This is the back of a person. The user has an avatar which has a back.
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "背面";

	/// <summary>
	/// Key: "Label.BackAccessory"
	/// English String: "Back Accessory"
	/// </summary>
	public override string LabelBackAccessory => "背面用アクセサリ";

	/// <summary>
	/// Key: "Label.Badge"
	/// Asset type Badge, singular form
	/// English String: "Badge"
	/// </summary>
	public override string LabelBadge => "バッジ";

	/// <summary>
	/// Key: "Label.Badges"
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "バッジ";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "登る";

	/// <summary>
	/// Key: "Label.Death"
	/// English String: "Death"
	/// </summary>
	public override string LabelDeath => "死";

	/// <summary>
	/// Key: "Label.Decal"
	/// Asset type Decal, singular form
	/// English String: "Decal"
	/// </summary>
	public override string LabelDecal => "デカール";

	/// <summary>
	/// Key: "Label.Decals"
	/// English String: "Decals"
	/// </summary>
	public override string LabelDecals => "デカール";

	/// <summary>
	/// Key: "Label.Emote"
	/// Asset type Emote, singular form
	/// English String: "Emote"
	/// </summary>
	public override string LabelEmote => "エモート";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Asset type Emote, plural form
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "エモート";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "顔";

	/// <summary>
	/// Key: "Label.FaceAccessory"
	/// English String: "Face Accessory"
	/// </summary>
	public override string LabelFaceAccessory => "顔用アクセサリ";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "顔";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "落下";

	/// <summary>
	/// Key: "Label.Front"
	/// This is the front of a person. The user has an avatar which has a front.
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "正面";

	/// <summary>
	/// Key: "Label.FrontAccessory"
	/// English String: "Front Accessory"
	/// </summary>
	public override string LabelFrontAccessory => "正面用アクセサリ";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "ゲーム";

	/// <summary>
	/// Key: "Label.GamePass"
	/// Asset type Game Pass, singular form
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "ゲームパス";

	/// <summary>
	/// Key: "Label.GamePasses"
	/// English String: "Game Passes"
	/// </summary>
	public override string LabelGamePasses => "ゲームパス";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "ギア";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "髪";

	/// <summary>
	/// Key: "Label.HairAccessory"
	/// English String: "Hair Accessory"
	/// </summary>
	public override string LabelHairAccessory => "髪用アクセサリ";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "帽子";

	/// <summary>
	/// Key: "Label.Hats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelHats => "帽子";

	/// <summary>
	/// Key: "Label.Head"
	/// Asset type Head, singular form
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "頭";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "頭";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "待機";

	/// <summary>
	/// Key: "Label.Image"
	/// Asset type Image, singular form
	/// English String: "Image"
	/// </summary>
	public override string LabelImage => "画像";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "ジャンプ";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// Asset type Left Arm, singular form
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "左腕";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// Asset type Left Leg, singular form
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "左脚";

	/// <summary>
	/// Key: "Label.Mesh"
	/// Asset type mesh, singular form
	/// English String: "Mesh"
	/// </summary>
	public override string LabelMesh => "メッシュ";

	/// <summary>
	/// Key: "Label.Meshes"
	/// English String: "Meshes"
	/// </summary>
	public override string LabelMeshes => "メッシュ";

	/// <summary>
	/// Key: "Label.MeshPart"
	/// Asset type Mesh Part, singular form
	/// English String: "Mesh Part"
	/// </summary>
	public override string LabelMeshPart => "メッシュパーツ";

	/// <summary>
	/// Key: "Label.Model"
	/// Asset type Model, singular form
	/// English String: "Model"
	/// </summary>
	public override string LabelModel => "モデル";

	/// <summary>
	/// Key: "Label.Models"
	/// English String: "Models"
	/// </summary>
	public override string LabelModels => "モデル";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "首";

	/// <summary>
	/// Key: "Label.NeckAccessory"
	/// English String: "Neck Accessory"
	/// </summary>
	public override string LabelNeckAccessory => "首用アクセサリ";

	/// <summary>
	/// Key: "Label.Package"
	/// Asset type Package, singular form
	/// English String: "Package"
	/// </summary>
	public override string LabelPackage => "パッケージ";

	/// <summary>
	/// Key: "Label.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "パッケージ";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "パンツ";

	/// <summary>
	/// Key: "Label.Place"
	/// Asset type Place, singular form
	/// English String: "Place"
	/// </summary>
	public override string LabelPlace => "プレース";

	/// <summary>
	/// Key: "Label.Places"
	/// English String: "Places"
	/// </summary>
	public override string LabelPlaces => "プレース";

	/// <summary>
	/// Key: "Label.Plugin"
	/// Asset type Plugin, singular form
	/// English String: "Plugin"
	/// </summary>
	public override string LabelPlugin => "プラグイン";

	/// <summary>
	/// Key: "Label.Plugins"
	/// English String: "Plugins"
	/// </summary>
	public override string LabelPlugins => "プラグイン";

	/// <summary>
	/// Key: "Label.Pose"
	/// English String: "Pose"
	/// </summary>
	public override string LabelPose => "ポーズ";

	/// <summary>
	/// Key: "Label.RightArm"
	/// Asset type Right Arm, singular form
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "右腕";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// Asset type Right Leg, singular form
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "右脚";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "走る";

	/// <summary>
	/// Key: "Label.Shirt"
	/// Asset type Shirt, singular form
	/// English String: "Shirt"
	/// </summary>
	public override string LabelShirt => "シャツ";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "シャツ";

	/// <summary>
	/// Key: "Label.Shoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelShoulder => "肩";

	/// <summary>
	/// Key: "Label.ShoulderAccessory"
	/// English String: "Shoulder Accessory"
	/// </summary>
	public override string LabelShoulderAccessory => "肩用アクセサリ";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "肩";

	/// <summary>
	/// Key: "Label.SolidModel"
	/// Asset type Solid Model, singular
	/// English String: "Solid Model"
	/// </summary>
	public override string LabelSolidModel => "ソリッドモデル";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "泳ぐ";

	/// <summary>
	/// Key: "Label.Torso"
	/// Asset type Torso, singular form
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "胴体";

	/// <summary>
	/// Key: "Label.TShirt"
	/// Asset type T-Shirt, singular form
	/// English String: "T-Shirt"
	/// </summary>
	public override string LabelTShirt => "Tシャツ";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Tシャツ";

	/// <summary>
	/// Key: "Label.VipServers"
	/// VIP servers are private servers which users can create to play only with their friends instead of strangers.
	/// English String: "VIP Servers"
	/// </summary>
	public override string LabelVipServers => "VIPサーバー";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "腰";

	/// <summary>
	/// Key: "Label.WaistAccessory"
	/// English String: "Waist Accessory"
	/// </summary>
	public override string LabelWaistAccessory => "腰用アクセサリ";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "歩く";

	public AssetTypesResources_ja_jp(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "アクセサリ";
	}

	protected override string _GetTemplateForLabelAccessory()
	{
		return "アクセサリ";
	}

	protected override string _GetTemplateForLabelAnimation()
	{
		return "アニメーション";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "アニメーション";
	}

	protected override string _GetTemplateForLabelAudio()
	{
		return "オーディオ";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "アバターアニメ";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "背面";
	}

	protected override string _GetTemplateForLabelBackAccessory()
	{
		return "背面用アクセサリ";
	}

	protected override string _GetTemplateForLabelBadge()
	{
		return "バッジ";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "バッジ";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "登る";
	}

	protected override string _GetTemplateForLabelDeath()
	{
		return "死";
	}

	protected override string _GetTemplateForLabelDecal()
	{
		return "デカール";
	}

	protected override string _GetTemplateForLabelDecals()
	{
		return "デカール";
	}

	protected override string _GetTemplateForLabelEmote()
	{
		return "エモート";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "エモート";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "顔";
	}

	protected override string _GetTemplateForLabelFaceAccessory()
	{
		return "顔用アクセサリ";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "顔";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "落下";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "正面";
	}

	protected override string _GetTemplateForLabelFrontAccessory()
	{
		return "正面用アクセサリ";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "ゲーム";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "ゲームパス";
	}

	protected override string _GetTemplateForLabelGamePasses()
	{
		return "ゲームパス";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "ギア";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "髪";
	}

	protected override string _GetTemplateForLabelHairAccessory()
	{
		return "髪用アクセサリ";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "帽子";
	}

	protected override string _GetTemplateForLabelHats()
	{
		return "帽子";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "頭";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "頭";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "待機";
	}

	protected override string _GetTemplateForLabelImage()
	{
		return "画像";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "ジャンプ";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "左腕";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "左脚";
	}

	protected override string _GetTemplateForLabelMesh()
	{
		return "メッシュ";
	}

	protected override string _GetTemplateForLabelMeshes()
	{
		return "メッシュ";
	}

	protected override string _GetTemplateForLabelMeshPart()
	{
		return "メッシュパーツ";
	}

	protected override string _GetTemplateForLabelModel()
	{
		return "モデル";
	}

	protected override string _GetTemplateForLabelModels()
	{
		return "モデル";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "首";
	}

	protected override string _GetTemplateForLabelNeckAccessory()
	{
		return "首用アクセサリ";
	}

	protected override string _GetTemplateForLabelPackage()
	{
		return "パッケージ";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "パッケージ";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "パンツ";
	}

	protected override string _GetTemplateForLabelPlace()
	{
		return "プレース";
	}

	protected override string _GetTemplateForLabelPlaces()
	{
		return "プレース";
	}

	protected override string _GetTemplateForLabelPlugin()
	{
		return "プラグイン";
	}

	protected override string _GetTemplateForLabelPlugins()
	{
		return "プラグイン";
	}

	protected override string _GetTemplateForLabelPose()
	{
		return "ポーズ";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "右腕";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "右脚";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "走る";
	}

	protected override string _GetTemplateForLabelShirt()
	{
		return "シャツ";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "シャツ";
	}

	protected override string _GetTemplateForLabelShoulder()
	{
		return "肩";
	}

	protected override string _GetTemplateForLabelShoulderAccessory()
	{
		return "肩用アクセサリ";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "肩";
	}

	protected override string _GetTemplateForLabelSolidModel()
	{
		return "ソリッドモデル";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "泳ぐ";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "胴体";
	}

	protected override string _GetTemplateForLabelTShirt()
	{
		return "Tシャツ";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Tシャツ";
	}

	protected override string _GetTemplateForLabelVipServers()
	{
		return "VIPサーバー";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "腰";
	}

	protected override string _GetTemplateForLabelWaistAccessory()
	{
		return "腰用アクセサリ";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "歩く";
	}
}
