namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides AssetTypesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AssetTypesResources_fr_fr : AssetTypesResources_en_us, IAssetTypesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "Accessoires";

	/// <summary>
	/// Key: "Label.Accessory"
	/// Accessory asset group, in singular form
	/// English String: "Accessory"
	/// </summary>
	public override string LabelAccessory => "Accessoire";

	/// <summary>
	/// Key: "Label.Animation"
	/// Asset type Animation, singular form
	/// English String: "Animation"
	/// </summary>
	public override string LabelAnimation => "Animation";

	/// <summary>
	/// Key: "Label.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "Animations";

	/// <summary>
	/// Key: "Label.Audio"
	/// English String: "Audio"
	/// </summary>
	public override string LabelAudio => "Audio";

	/// <summary>
	/// Key: "Label.AvatarAnimations"
	/// Avatar Animations allow the user to have their character or avatar move differently within the game.
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "Animations d'avatar";

	/// <summary>
	/// Key: "Label.Back"
	/// This is the back of a person. The user has an avatar which has a back.
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "Retour";

	/// <summary>
	/// Key: "Label.BackAccessory"
	/// English String: "Back Accessory"
	/// </summary>
	public override string LabelBackAccessory => "Accessoire arrière";

	/// <summary>
	/// Key: "Label.Badge"
	/// Asset type Badge, singular form
	/// English String: "Badge"
	/// </summary>
	public override string LabelBadge => "Badge";

	/// <summary>
	/// Key: "Label.Badges"
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Badges";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "Escalade";

	/// <summary>
	/// Key: "Label.Death"
	/// English String: "Death"
	/// </summary>
	public override string LabelDeath => "Mort";

	/// <summary>
	/// Key: "Label.Decal"
	/// Asset type Decal, singular form
	/// English String: "Decal"
	/// </summary>
	public override string LabelDecal => "Insigne";

	/// <summary>
	/// Key: "Label.Decals"
	/// English String: "Decals"
	/// </summary>
	public override string LabelDecals => "Insignes";

	/// <summary>
	/// Key: "Label.Emote"
	/// Asset type Emote, singular form
	/// English String: "Emote"
	/// </summary>
	public override string LabelEmote => "Emote";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Asset type Emote, plural form
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "Emotes";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "Visage";

	/// <summary>
	/// Key: "Label.FaceAccessory"
	/// English String: "Face Accessory"
	/// </summary>
	public override string LabelFaceAccessory => "Accessoire de visage";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Visages";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "Chute";

	/// <summary>
	/// Key: "Label.Front"
	/// This is the front of a person. The user has an avatar which has a front.
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "Avant";

	/// <summary>
	/// Key: "Label.FrontAccessory"
	/// English String: "Front Accessory"
	/// </summary>
	public override string LabelFrontAccessory => "Accessoire avant";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "Jeu";

	/// <summary>
	/// Key: "Label.GamePass"
	/// Asset type Game Pass, singular form
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "Passe de jeu";

	/// <summary>
	/// Key: "Label.GamePasses"
	/// English String: "Game Passes"
	/// </summary>
	public override string LabelGamePasses => "Passes de jeu";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Équipement";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "Cheveux";

	/// <summary>
	/// Key: "Label.HairAccessory"
	/// English String: "Hair Accessory"
	/// </summary>
	public override string LabelHairAccessory => "Accessoire de cheveux";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "Chapeau";

	/// <summary>
	/// Key: "Label.Hats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelHats => "Chapeaux";

	/// <summary>
	/// Key: "Label.Head"
	/// Asset type Head, singular form
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "Tête";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Têtes";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "Inaction";

	/// <summary>
	/// Key: "Label.Image"
	/// Asset type Image, singular form
	/// English String: "Image"
	/// </summary>
	public override string LabelImage => "Image";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "Saut";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// Asset type Left Arm, singular form
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "Bras gauche";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// Asset type Left Leg, singular form
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "Jambe gauche";

	/// <summary>
	/// Key: "Label.Mesh"
	/// Asset type mesh, singular form
	/// English String: "Mesh"
	/// </summary>
	public override string LabelMesh => "Maillage";

	/// <summary>
	/// Key: "Label.Meshes"
	/// English String: "Meshes"
	/// </summary>
	public override string LabelMeshes => "Maillages";

	/// <summary>
	/// Key: "Label.MeshPart"
	/// Asset type Mesh Part, singular form
	/// English String: "Mesh Part"
	/// </summary>
	public override string LabelMeshPart => "Partie de maillage";

	/// <summary>
	/// Key: "Label.Model"
	/// Asset type Model, singular form
	/// English String: "Model"
	/// </summary>
	public override string LabelModel => "Modèle";

	/// <summary>
	/// Key: "Label.Models"
	/// English String: "Models"
	/// </summary>
	public override string LabelModels => "Modèles";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "Cou";

	/// <summary>
	/// Key: "Label.NeckAccessory"
	/// English String: "Neck Accessory"
	/// </summary>
	public override string LabelNeckAccessory => "Accessoire de cou";

	/// <summary>
	/// Key: "Label.Package"
	/// Asset type Package, singular form
	/// English String: "Package"
	/// </summary>
	public override string LabelPackage => "Pack";

	/// <summary>
	/// Key: "Label.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "Packs";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Pantalons";

	/// <summary>
	/// Key: "Label.Place"
	/// Asset type Place, singular form
	/// English String: "Place"
	/// </summary>
	public override string LabelPlace => "Emplacement";

	/// <summary>
	/// Key: "Label.Places"
	/// English String: "Places"
	/// </summary>
	public override string LabelPlaces => "Emplacements";

	/// <summary>
	/// Key: "Label.Plugin"
	/// Asset type Plugin, singular form
	/// English String: "Plugin"
	/// </summary>
	public override string LabelPlugin => "Plugin";

	/// <summary>
	/// Key: "Label.Plugins"
	/// English String: "Plugins"
	/// </summary>
	public override string LabelPlugins => "Plugins";

	/// <summary>
	/// Key: "Label.Pose"
	/// English String: "Pose"
	/// </summary>
	public override string LabelPose => "Pose";

	/// <summary>
	/// Key: "Label.RightArm"
	/// Asset type Right Arm, singular form
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "Bras droit";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// Asset type Right Leg, singular form
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "Jambe droite";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "Course";

	/// <summary>
	/// Key: "Label.Shirt"
	/// Asset type Shirt, singular form
	/// English String: "Shirt"
	/// </summary>
	public override string LabelShirt => "Chemise";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Chemises";

	/// <summary>
	/// Key: "Label.Shoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelShoulder => "Épaules";

	/// <summary>
	/// Key: "Label.ShoulderAccessory"
	/// English String: "Shoulder Accessory"
	/// </summary>
	public override string LabelShoulderAccessory => "Accessoire d'épaule";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "Épaules";

	/// <summary>
	/// Key: "Label.SolidModel"
	/// Asset type Solid Model, singular
	/// English String: "Solid Model"
	/// </summary>
	public override string LabelSolidModel => "Modèle solide";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "Nage";

	/// <summary>
	/// Key: "Label.Torso"
	/// Asset type Torso, singular form
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "Torse";

	/// <summary>
	/// Key: "Label.TShirt"
	/// Asset type T-Shirt, singular form
	/// English String: "T-Shirt"
	/// </summary>
	public override string LabelTShirt => "Tee-shirt";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Tee-shirts";

	/// <summary>
	/// Key: "Label.VipServers"
	/// VIP servers are private servers which users can create to play only with their friends instead of strangers.
	/// English String: "VIP Servers"
	/// </summary>
	public override string LabelVipServers => "Serveurs\u00a0VIP";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "Taille";

	/// <summary>
	/// Key: "Label.WaistAccessory"
	/// English String: "Waist Accessory"
	/// </summary>
	public override string LabelWaistAccessory => "Accessoire de taille";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "Marche";

	public AssetTypesResources_fr_fr(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "Accessoires";
	}

	protected override string _GetTemplateForLabelAccessory()
	{
		return "Accessoire";
	}

	protected override string _GetTemplateForLabelAnimation()
	{
		return "Animation";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "Animations";
	}

	protected override string _GetTemplateForLabelAudio()
	{
		return "Audio";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "Animations d'avatar";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "Retour";
	}

	protected override string _GetTemplateForLabelBackAccessory()
	{
		return "Accessoire arrière";
	}

	protected override string _GetTemplateForLabelBadge()
	{
		return "Badge";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Badges";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "Escalade";
	}

	protected override string _GetTemplateForLabelDeath()
	{
		return "Mort";
	}

	protected override string _GetTemplateForLabelDecal()
	{
		return "Insigne";
	}

	protected override string _GetTemplateForLabelDecals()
	{
		return "Insignes";
	}

	protected override string _GetTemplateForLabelEmote()
	{
		return "Emote";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "Emotes";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "Visage";
	}

	protected override string _GetTemplateForLabelFaceAccessory()
	{
		return "Accessoire de visage";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Visages";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "Chute";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "Avant";
	}

	protected override string _GetTemplateForLabelFrontAccessory()
	{
		return "Accessoire avant";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "Jeu";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "Passe de jeu";
	}

	protected override string _GetTemplateForLabelGamePasses()
	{
		return "Passes de jeu";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Équipement";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "Cheveux";
	}

	protected override string _GetTemplateForLabelHairAccessory()
	{
		return "Accessoire de cheveux";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "Chapeau";
	}

	protected override string _GetTemplateForLabelHats()
	{
		return "Chapeaux";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "Tête";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Têtes";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "Inaction";
	}

	protected override string _GetTemplateForLabelImage()
	{
		return "Image";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "Saut";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "Bras gauche";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "Jambe gauche";
	}

	protected override string _GetTemplateForLabelMesh()
	{
		return "Maillage";
	}

	protected override string _GetTemplateForLabelMeshes()
	{
		return "Maillages";
	}

	protected override string _GetTemplateForLabelMeshPart()
	{
		return "Partie de maillage";
	}

	protected override string _GetTemplateForLabelModel()
	{
		return "Modèle";
	}

	protected override string _GetTemplateForLabelModels()
	{
		return "Modèles";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "Cou";
	}

	protected override string _GetTemplateForLabelNeckAccessory()
	{
		return "Accessoire de cou";
	}

	protected override string _GetTemplateForLabelPackage()
	{
		return "Pack";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "Packs";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Pantalons";
	}

	protected override string _GetTemplateForLabelPlace()
	{
		return "Emplacement";
	}

	protected override string _GetTemplateForLabelPlaces()
	{
		return "Emplacements";
	}

	protected override string _GetTemplateForLabelPlugin()
	{
		return "Plugin";
	}

	protected override string _GetTemplateForLabelPlugins()
	{
		return "Plugins";
	}

	protected override string _GetTemplateForLabelPose()
	{
		return "Pose";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "Bras droit";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "Jambe droite";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "Course";
	}

	protected override string _GetTemplateForLabelShirt()
	{
		return "Chemise";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Chemises";
	}

	protected override string _GetTemplateForLabelShoulder()
	{
		return "Épaules";
	}

	protected override string _GetTemplateForLabelShoulderAccessory()
	{
		return "Accessoire d'épaule";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "Épaules";
	}

	protected override string _GetTemplateForLabelSolidModel()
	{
		return "Modèle solide";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "Nage";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "Torse";
	}

	protected override string _GetTemplateForLabelTShirt()
	{
		return "Tee-shirt";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Tee-shirts";
	}

	protected override string _GetTemplateForLabelVipServers()
	{
		return "Serveurs\u00a0VIP";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "Taille";
	}

	protected override string _GetTemplateForLabelWaistAccessory()
	{
		return "Accessoire de taille";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "Marche";
	}
}
