namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides AssetTypesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AssetTypesResources_es_es : AssetTypesResources_en_us, IAssetTypesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "Accesorios";

	/// <summary>
	/// Key: "Label.Accessory"
	/// Accessory asset group, in singular form
	/// English String: "Accessory"
	/// </summary>
	public override string LabelAccessory => "Accesorio";

	/// <summary>
	/// Key: "Label.Animation"
	/// Asset type Animation, singular form
	/// English String: "Animation"
	/// </summary>
	public override string LabelAnimation => "Animación";

	/// <summary>
	/// Key: "Label.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "Animaciones";

	/// <summary>
	/// Key: "Label.Audio"
	/// English String: "Audio"
	/// </summary>
	public override string LabelAudio => "Sonidos";

	/// <summary>
	/// Key: "Label.AvatarAnimations"
	/// Avatar Animations allow the user to have their character or avatar move differently within the game.
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "Animaciones de avatar";

	/// <summary>
	/// Key: "Label.Back"
	/// This is the back of a person. The user has an avatar which has a back.
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "Trasero";

	/// <summary>
	/// Key: "Label.BackAccessory"
	/// English String: "Back Accessory"
	/// </summary>
	public override string LabelBackAccessory => "Accesorio trasero";

	/// <summary>
	/// Key: "Label.Badge"
	/// Asset type Badge, singular form
	/// English String: "Badge"
	/// </summary>
	public override string LabelBadge => "Emblema";

	/// <summary>
	/// Key: "Label.Badges"
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Emblemas";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "Escalada";

	/// <summary>
	/// Key: "Label.Death"
	/// English String: "Death"
	/// </summary>
	public override string LabelDeath => "La muerte";

	/// <summary>
	/// Key: "Label.Decal"
	/// Asset type Decal, singular form
	/// English String: "Decal"
	/// </summary>
	public override string LabelDecal => "Adhesivo";

	/// <summary>
	/// Key: "Label.Decals"
	/// English String: "Decals"
	/// </summary>
	public override string LabelDecals => "Adhesivos";

	/// <summary>
	/// Key: "Label.Emote"
	/// Asset type Emote, singular form
	/// English String: "Emote"
	/// </summary>
	public override string LabelEmote => "Emoticono";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Asset type Emote, plural form
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "Emoticonos";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "Cara";

	/// <summary>
	/// Key: "Label.FaceAccessory"
	/// English String: "Face Accessory"
	/// </summary>
	public override string LabelFaceAccessory => "Accesorio para la cara";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Caras";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "Caída";

	/// <summary>
	/// Key: "Label.Front"
	/// This is the front of a person. The user has an avatar which has a front.
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "Frontal";

	/// <summary>
	/// Key: "Label.FrontAccessory"
	/// English String: "Front Accessory"
	/// </summary>
	public override string LabelFrontAccessory => "Accesorio frontal";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "Juego";

	/// <summary>
	/// Key: "Label.GamePass"
	/// Asset type Game Pass, singular form
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "Pase del juego";

	/// <summary>
	/// Key: "Label.GamePasses"
	/// English String: "Game Passes"
	/// </summary>
	public override string LabelGamePasses => "Pases del juego";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Equipamiento";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "Pelo";

	/// <summary>
	/// Key: "Label.HairAccessory"
	/// English String: "Hair Accessory"
	/// </summary>
	public override string LabelHairAccessory => "Accesorios para el pelo";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "Sombrero";

	/// <summary>
	/// Key: "Label.Hats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelHats => "Sombreros";

	/// <summary>
	/// Key: "Label.Head"
	/// Asset type Head, singular form
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "Cabeza";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Cabezas";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "Inactividad";

	/// <summary>
	/// Key: "Label.Image"
	/// Asset type Image, singular form
	/// English String: "Image"
	/// </summary>
	public override string LabelImage => "Imagen";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "Salto";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// Asset type Left Arm, singular form
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "Brazo izquierdo";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// Asset type Left Leg, singular form
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "Pierna izquierda";

	/// <summary>
	/// Key: "Label.Mesh"
	/// Asset type mesh, singular form
	/// English String: "Mesh"
	/// </summary>
	public override string LabelMesh => "Malla";

	/// <summary>
	/// Key: "Label.Meshes"
	/// English String: "Meshes"
	/// </summary>
	public override string LabelMeshes => "Mallas";

	/// <summary>
	/// Key: "Label.MeshPart"
	/// Asset type Mesh Part, singular form
	/// English String: "Mesh Part"
	/// </summary>
	public override string LabelMeshPart => "Parte de la malla";

	/// <summary>
	/// Key: "Label.Model"
	/// Asset type Model, singular form
	/// English String: "Model"
	/// </summary>
	public override string LabelModel => "Modelo";

	/// <summary>
	/// Key: "Label.Models"
	/// English String: "Models"
	/// </summary>
	public override string LabelModels => "Modelos";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "Cuello";

	/// <summary>
	/// Key: "Label.NeckAccessory"
	/// English String: "Neck Accessory"
	/// </summary>
	public override string LabelNeckAccessory => "Accesorio para el cuello";

	/// <summary>
	/// Key: "Label.Package"
	/// Asset type Package, singular form
	/// English String: "Package"
	/// </summary>
	public override string LabelPackage => "Paquete";

	/// <summary>
	/// Key: "Label.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "Paquetes";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Pantalones";

	/// <summary>
	/// Key: "Label.Place"
	/// Asset type Place, singular form
	/// English String: "Place"
	/// </summary>
	public override string LabelPlace => "Lugar";

	/// <summary>
	/// Key: "Label.Places"
	/// English String: "Places"
	/// </summary>
	public override string LabelPlaces => "Lugares";

	/// <summary>
	/// Key: "Label.Plugin"
	/// Asset type Plugin, singular form
	/// English String: "Plugin"
	/// </summary>
	public override string LabelPlugin => "Complemento";

	/// <summary>
	/// Key: "Label.Plugins"
	/// English String: "Plugins"
	/// </summary>
	public override string LabelPlugins => "Complementos";

	/// <summary>
	/// Key: "Label.Pose"
	/// English String: "Pose"
	/// </summary>
	public override string LabelPose => "Pose";

	/// <summary>
	/// Key: "Label.RightArm"
	/// Asset type Right Arm, singular form
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "Brazo derecho";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// Asset type Right Leg, singular form
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "Pierna derecha";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "Carrera";

	/// <summary>
	/// Key: "Label.Shirt"
	/// Asset type Shirt, singular form
	/// English String: "Shirt"
	/// </summary>
	public override string LabelShirt => "Camisa";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Camisas";

	/// <summary>
	/// Key: "Label.Shoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelShoulder => "Hombro";

	/// <summary>
	/// Key: "Label.ShoulderAccessory"
	/// English String: "Shoulder Accessory"
	/// </summary>
	public override string LabelShoulderAccessory => "Accesorio para el hombro";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "Hombros";

	/// <summary>
	/// Key: "Label.SolidModel"
	/// Asset type Solid Model, singular
	/// English String: "Solid Model"
	/// </summary>
	public override string LabelSolidModel => "Modelo sólido";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "Nado";

	/// <summary>
	/// Key: "Label.Torso"
	/// Asset type Torso, singular form
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "Torso";

	/// <summary>
	/// Key: "Label.TShirt"
	/// Asset type T-Shirt, singular form
	/// English String: "T-Shirt"
	/// </summary>
	public override string LabelTShirt => "Camiseta";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "Camisetas";

	/// <summary>
	/// Key: "Label.VipServers"
	/// VIP servers are private servers which users can create to play only with their friends instead of strangers.
	/// English String: "VIP Servers"
	/// </summary>
	public override string LabelVipServers => "Servidores VIP";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "Cintura";

	/// <summary>
	/// Key: "Label.WaistAccessory"
	/// English String: "Waist Accessory"
	/// </summary>
	public override string LabelWaistAccessory => "Accesorio para la cintura";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "Marcha";

	public AssetTypesResources_es_es(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "Accesorios";
	}

	protected override string _GetTemplateForLabelAccessory()
	{
		return "Accesorio";
	}

	protected override string _GetTemplateForLabelAnimation()
	{
		return "Animación";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "Animaciones";
	}

	protected override string _GetTemplateForLabelAudio()
	{
		return "Sonidos";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "Animaciones de avatar";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "Trasero";
	}

	protected override string _GetTemplateForLabelBackAccessory()
	{
		return "Accesorio trasero";
	}

	protected override string _GetTemplateForLabelBadge()
	{
		return "Emblema";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Emblemas";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "Escalada";
	}

	protected override string _GetTemplateForLabelDeath()
	{
		return "La muerte";
	}

	protected override string _GetTemplateForLabelDecal()
	{
		return "Adhesivo";
	}

	protected override string _GetTemplateForLabelDecals()
	{
		return "Adhesivos";
	}

	protected override string _GetTemplateForLabelEmote()
	{
		return "Emoticono";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "Emoticonos";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "Cara";
	}

	protected override string _GetTemplateForLabelFaceAccessory()
	{
		return "Accesorio para la cara";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Caras";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "Caída";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "Frontal";
	}

	protected override string _GetTemplateForLabelFrontAccessory()
	{
		return "Accesorio frontal";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "Juego";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "Pase del juego";
	}

	protected override string _GetTemplateForLabelGamePasses()
	{
		return "Pases del juego";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Equipamiento";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "Pelo";
	}

	protected override string _GetTemplateForLabelHairAccessory()
	{
		return "Accesorios para el pelo";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "Sombrero";
	}

	protected override string _GetTemplateForLabelHats()
	{
		return "Sombreros";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "Cabeza";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Cabezas";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "Inactividad";
	}

	protected override string _GetTemplateForLabelImage()
	{
		return "Imagen";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "Salto";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "Brazo izquierdo";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "Pierna izquierda";
	}

	protected override string _GetTemplateForLabelMesh()
	{
		return "Malla";
	}

	protected override string _GetTemplateForLabelMeshes()
	{
		return "Mallas";
	}

	protected override string _GetTemplateForLabelMeshPart()
	{
		return "Parte de la malla";
	}

	protected override string _GetTemplateForLabelModel()
	{
		return "Modelo";
	}

	protected override string _GetTemplateForLabelModels()
	{
		return "Modelos";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "Cuello";
	}

	protected override string _GetTemplateForLabelNeckAccessory()
	{
		return "Accesorio para el cuello";
	}

	protected override string _GetTemplateForLabelPackage()
	{
		return "Paquete";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "Paquetes";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Pantalones";
	}

	protected override string _GetTemplateForLabelPlace()
	{
		return "Lugar";
	}

	protected override string _GetTemplateForLabelPlaces()
	{
		return "Lugares";
	}

	protected override string _GetTemplateForLabelPlugin()
	{
		return "Complemento";
	}

	protected override string _GetTemplateForLabelPlugins()
	{
		return "Complementos";
	}

	protected override string _GetTemplateForLabelPose()
	{
		return "Pose";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "Brazo derecho";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "Pierna derecha";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "Carrera";
	}

	protected override string _GetTemplateForLabelShirt()
	{
		return "Camisa";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Camisas";
	}

	protected override string _GetTemplateForLabelShoulder()
	{
		return "Hombro";
	}

	protected override string _GetTemplateForLabelShoulderAccessory()
	{
		return "Accesorio para el hombro";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "Hombros";
	}

	protected override string _GetTemplateForLabelSolidModel()
	{
		return "Modelo sólido";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "Nado";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "Torso";
	}

	protected override string _GetTemplateForLabelTShirt()
	{
		return "Camiseta";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "Camisetas";
	}

	protected override string _GetTemplateForLabelVipServers()
	{
		return "Servidores VIP";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "Cintura";
	}

	protected override string _GetTemplateForLabelWaistAccessory()
	{
		return "Accesorio para la cintura";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "Marcha";
	}
}
