namespace Roblox.TranslationResources.Common;

/// <summary>
/// This class overrides AssetTypesResources_en_us to provide locale specific translations where possible,
/// using the base translations where they are not provided
/// </summary>
internal class AssetTypesResources_de_de : AssetTypesResources_en_us, IAssetTypesResources, ITranslationResources
{
	/// <summary>
	/// Key: "Label.Accessories"
	/// English String: "Accessories"
	/// </summary>
	public override string LabelAccessories => "Accessoires";

	/// <summary>
	/// Key: "Label.Accessory"
	/// Accessory asset group, in singular form
	/// English String: "Accessory"
	/// </summary>
	public override string LabelAccessory => "Accessoire";

	/// <summary>
	/// Key: "Label.Animation"
	/// Asset type Animation, singular form
	/// English String: "Animation"
	/// </summary>
	public override string LabelAnimation => "Animation";

	/// <summary>
	/// Key: "Label.Animations"
	/// English String: "Animations"
	/// </summary>
	public override string LabelAnimations => "Animationen";

	/// <summary>
	/// Key: "Label.Audio"
	/// English String: "Audio"
	/// </summary>
	public override string LabelAudio => "Audiodateien";

	/// <summary>
	/// Key: "Label.AvatarAnimations"
	/// Avatar Animations allow the user to have their character or avatar move differently within the game.
	/// English String: "Avatar Animations"
	/// </summary>
	public override string LabelAvatarAnimations => "Avataranimationen";

	/// <summary>
	/// Key: "Label.Back"
	/// This is the back of a person. The user has an avatar which has a back.
	/// English String: "Back"
	/// </summary>
	public override string LabelBack => "Rückseite";

	/// <summary>
	/// Key: "Label.BackAccessory"
	/// English String: "Back Accessory"
	/// </summary>
	public override string LabelBackAccessory => "Rückseite-Accessoire";

	/// <summary>
	/// Key: "Label.Badge"
	/// Asset type Badge, singular form
	/// English String: "Badge"
	/// </summary>
	public override string LabelBadge => "Abzeichen";

	/// <summary>
	/// Key: "Label.Badges"
	/// English String: "Badges"
	/// </summary>
	public override string LabelBadges => "Abzeichen";

	/// <summary>
	/// Key: "Label.Climb"
	/// English String: "Climb"
	/// </summary>
	public override string LabelClimb => "Klettern";

	/// <summary>
	/// Key: "Label.Death"
	/// English String: "Death"
	/// </summary>
	public override string LabelDeath => "Tod";

	/// <summary>
	/// Key: "Label.Decal"
	/// Asset type Decal, singular form
	/// English String: "Decal"
	/// </summary>
	public override string LabelDecal => "Decal";

	/// <summary>
	/// Key: "Label.Decals"
	/// English String: "Decals"
	/// </summary>
	public override string LabelDecals => "Decals";

	/// <summary>
	/// Key: "Label.Emote"
	/// Asset type Emote, singular form
	/// English String: "Emote"
	/// </summary>
	public override string LabelEmote => "Emote";

	/// <summary>
	/// Key: "Label.Emotes"
	/// Asset type Emote, plural form
	/// English String: "Emotes"
	/// </summary>
	public override string LabelEmotes => "Emotes";

	/// <summary>
	/// Key: "Label.Face"
	/// English String: "Face"
	/// </summary>
	public override string LabelFace => "Gesicht";

	/// <summary>
	/// Key: "Label.FaceAccessory"
	/// English String: "Face Accessory"
	/// </summary>
	public override string LabelFaceAccessory => "Gesicht-Accessoire";

	/// <summary>
	/// Key: "Label.Faces"
	/// English String: "Faces"
	/// </summary>
	public override string LabelFaces => "Gesichter";

	/// <summary>
	/// Key: "Label.Fall"
	/// English String: "Fall"
	/// </summary>
	public override string LabelFall => "Fallen";

	/// <summary>
	/// Key: "Label.Front"
	/// This is the front of a person. The user has an avatar which has a front.
	/// English String: "Front"
	/// </summary>
	public override string LabelFront => "Vorderseite";

	/// <summary>
	/// Key: "Label.FrontAccessory"
	/// English String: "Front Accessory"
	/// </summary>
	public override string LabelFrontAccessory => "Vorderseite-Accessoire";

	/// <summary>
	/// Key: "Label.Game"
	/// English String: "Game"
	/// </summary>
	public override string LabelGame => "Spiel";

	/// <summary>
	/// Key: "Label.GamePass"
	/// Asset type Game Pass, singular form
	/// English String: "Game Pass"
	/// </summary>
	public override string LabelGamePass => "Spielpass";

	/// <summary>
	/// Key: "Label.GamePasses"
	/// English String: "Game Passes"
	/// </summary>
	public override string LabelGamePasses => "Spielpässe";

	/// <summary>
	/// Key: "Label.Gear"
	/// English String: "Gear"
	/// </summary>
	public override string LabelGear => "Ausrüstung";

	/// <summary>
	/// Key: "Label.Hair"
	/// English String: "Hair"
	/// </summary>
	public override string LabelHair => "Haare";

	/// <summary>
	/// Key: "Label.HairAccessory"
	/// English String: "Hair Accessory"
	/// </summary>
	public override string LabelHairAccessory => "Haar-Accessoire";

	/// <summary>
	/// Key: "Label.Hat"
	/// English String: "Hat"
	/// </summary>
	public override string LabelHat => "Hut";

	/// <summary>
	/// Key: "Label.Hats"
	/// English String: "Hats"
	/// </summary>
	public override string LabelHats => "Hüte";

	/// <summary>
	/// Key: "Label.Head"
	/// Asset type Head, singular form
	/// English String: "Head"
	/// </summary>
	public override string LabelHead => "Kopf";

	/// <summary>
	/// Key: "Label.Heads"
	/// English String: "Heads"
	/// </summary>
	public override string LabelHeads => "Köpfe";

	/// <summary>
	/// Key: "Label.Idle"
	/// English String: "Idle"
	/// </summary>
	public override string LabelIdle => "Untätig";

	/// <summary>
	/// Key: "Label.Image"
	/// Asset type Image, singular form
	/// English String: "Image"
	/// </summary>
	public override string LabelImage => "Bild";

	/// <summary>
	/// Key: "Label.Jump"
	/// English String: "Jump"
	/// </summary>
	public override string LabelJump => "Springen";

	/// <summary>
	/// Key: "Label.LeftArm"
	/// Asset type Left Arm, singular form
	/// English String: "Left Arm"
	/// </summary>
	public override string LabelLeftArm => "Linker Arm";

	/// <summary>
	/// Key: "Label.LeftLeg"
	/// Asset type Left Leg, singular form
	/// English String: "Left Leg"
	/// </summary>
	public override string LabelLeftLeg => "Linkes Bein";

	/// <summary>
	/// Key: "Label.Mesh"
	/// Asset type mesh, singular form
	/// English String: "Mesh"
	/// </summary>
	public override string LabelMesh => "Mesh";

	/// <summary>
	/// Key: "Label.Meshes"
	/// English String: "Meshes"
	/// </summary>
	public override string LabelMeshes => "Meshes";

	/// <summary>
	/// Key: "Label.MeshPart"
	/// Asset type Mesh Part, singular form
	/// English String: "Mesh Part"
	/// </summary>
	public override string LabelMeshPart => "Mesh-Teil";

	/// <summary>
	/// Key: "Label.Model"
	/// Asset type Model, singular form
	/// English String: "Model"
	/// </summary>
	public override string LabelModel => "Modell";

	/// <summary>
	/// Key: "Label.Models"
	/// English String: "Models"
	/// </summary>
	public override string LabelModels => "Modelle";

	/// <summary>
	/// Key: "Label.Neck"
	/// English String: "Neck"
	/// </summary>
	public override string LabelNeck => "Hals";

	/// <summary>
	/// Key: "Label.NeckAccessory"
	/// English String: "Neck Accessory"
	/// </summary>
	public override string LabelNeckAccessory => "Hals-Accessoire";

	/// <summary>
	/// Key: "Label.Package"
	/// Asset type Package, singular form
	/// English String: "Package"
	/// </summary>
	public override string LabelPackage => "Paket";

	/// <summary>
	/// Key: "Label.Packages"
	/// English String: "Packages"
	/// </summary>
	public override string LabelPackages => "Pakete";

	/// <summary>
	/// Key: "Label.Pants"
	/// English String: "Pants"
	/// </summary>
	public override string LabelPants => "Hosen";

	/// <summary>
	/// Key: "Label.Place"
	/// Asset type Place, singular form
	/// English String: "Place"
	/// </summary>
	public override string LabelPlace => "Ort";

	/// <summary>
	/// Key: "Label.Places"
	/// English String: "Places"
	/// </summary>
	public override string LabelPlaces => "Orte";

	/// <summary>
	/// Key: "Label.Plugin"
	/// Asset type Plugin, singular form
	/// English String: "Plugin"
	/// </summary>
	public override string LabelPlugin => "Plug-in";

	/// <summary>
	/// Key: "Label.Plugins"
	/// English String: "Plugins"
	/// </summary>
	public override string LabelPlugins => "Plug-ins";

	/// <summary>
	/// Key: "Label.Pose"
	/// English String: "Pose"
	/// </summary>
	public override string LabelPose => "Pose";

	/// <summary>
	/// Key: "Label.RightArm"
	/// Asset type Right Arm, singular form
	/// English String: "Right Arm"
	/// </summary>
	public override string LabelRightArm => "Rechter Arm";

	/// <summary>
	/// Key: "Label.RightLeg"
	/// Asset type Right Leg, singular form
	/// English String: "Right Leg"
	/// </summary>
	public override string LabelRightLeg => "Rechtes Bein";

	/// <summary>
	/// Key: "Label.Run"
	/// English String: "Run"
	/// </summary>
	public override string LabelRun => "Laufen";

	/// <summary>
	/// Key: "Label.Shirt"
	/// Asset type Shirt, singular form
	/// English String: "Shirt"
	/// </summary>
	public override string LabelShirt => "Hemd";

	/// <summary>
	/// Key: "Label.Shirts"
	/// English String: "Shirts"
	/// </summary>
	public override string LabelShirts => "Hemden";

	/// <summary>
	/// Key: "Label.Shoulder"
	/// English String: "Shoulder"
	/// </summary>
	public override string LabelShoulder => "Schulter";

	/// <summary>
	/// Key: "Label.ShoulderAccessory"
	/// English String: "Shoulder Accessory"
	/// </summary>
	public override string LabelShoulderAccessory => "Schulter-Accessoire";

	/// <summary>
	/// Key: "Label.Shoulders"
	/// English String: "Shoulders"
	/// </summary>
	public override string LabelShoulders => "Schultern";

	/// <summary>
	/// Key: "Label.SolidModel"
	/// Asset type Solid Model, singular
	/// English String: "Solid Model"
	/// </summary>
	public override string LabelSolidModel => "Solides Modell";

	/// <summary>
	/// Key: "Label.Swim"
	/// English String: "Swim"
	/// </summary>
	public override string LabelSwim => "Schwimmen";

	/// <summary>
	/// Key: "Label.Torso"
	/// Asset type Torso, singular form
	/// English String: "Torso"
	/// </summary>
	public override string LabelTorso => "Torso";

	/// <summary>
	/// Key: "Label.TShirt"
	/// Asset type T-Shirt, singular form
	/// English String: "T-Shirt"
	/// </summary>
	public override string LabelTShirt => "T-Shirt";

	/// <summary>
	/// Key: "Label.TShirts"
	/// English String: "T-Shirts"
	/// </summary>
	public override string LabelTShirts => "T-Shirts";

	/// <summary>
	/// Key: "Label.VipServers"
	/// VIP servers are private servers which users can create to play only with their friends instead of strangers.
	/// English String: "VIP Servers"
	/// </summary>
	public override string LabelVipServers => "VIP-Server";

	/// <summary>
	/// Key: "Label.Waist"
	/// English String: "Waist"
	/// </summary>
	public override string LabelWaist => "Taille";

	/// <summary>
	/// Key: "Label.WaistAccessory"
	/// English String: "Waist Accessory"
	/// </summary>
	public override string LabelWaistAccessory => "Taille-Accessoire";

	/// <summary>
	/// Key: "Label.Walk"
	/// English String: "Walk"
	/// </summary>
	public override string LabelWalk => "Gehen";

	public AssetTypesResources_de_de(TranslationResourceState state)
		: base(state)
	{
	}

	protected override string _GetTemplateForLabelAccessories()
	{
		return "Accessoires";
	}

	protected override string _GetTemplateForLabelAccessory()
	{
		return "Accessoire";
	}

	protected override string _GetTemplateForLabelAnimation()
	{
		return "Animation";
	}

	protected override string _GetTemplateForLabelAnimations()
	{
		return "Animationen";
	}

	protected override string _GetTemplateForLabelAudio()
	{
		return "Audiodateien";
	}

	protected override string _GetTemplateForLabelAvatarAnimations()
	{
		return "Avataranimationen";
	}

	protected override string _GetTemplateForLabelBack()
	{
		return "Rückseite";
	}

	protected override string _GetTemplateForLabelBackAccessory()
	{
		return "Rückseite-Accessoire";
	}

	protected override string _GetTemplateForLabelBadge()
	{
		return "Abzeichen";
	}

	protected override string _GetTemplateForLabelBadges()
	{
		return "Abzeichen";
	}

	protected override string _GetTemplateForLabelClimb()
	{
		return "Klettern";
	}

	protected override string _GetTemplateForLabelDeath()
	{
		return "Tod";
	}

	protected override string _GetTemplateForLabelDecal()
	{
		return "Decal";
	}

	protected override string _GetTemplateForLabelDecals()
	{
		return "Decals";
	}

	protected override string _GetTemplateForLabelEmote()
	{
		return "Emote";
	}

	protected override string _GetTemplateForLabelEmotes()
	{
		return "Emotes";
	}

	protected override string _GetTemplateForLabelFace()
	{
		return "Gesicht";
	}

	protected override string _GetTemplateForLabelFaceAccessory()
	{
		return "Gesicht-Accessoire";
	}

	protected override string _GetTemplateForLabelFaces()
	{
		return "Gesichter";
	}

	protected override string _GetTemplateForLabelFall()
	{
		return "Fallen";
	}

	protected override string _GetTemplateForLabelFront()
	{
		return "Vorderseite";
	}

	protected override string _GetTemplateForLabelFrontAccessory()
	{
		return "Vorderseite-Accessoire";
	}

	protected override string _GetTemplateForLabelGame()
	{
		return "Spiel";
	}

	protected override string _GetTemplateForLabelGamePass()
	{
		return "Spielpass";
	}

	protected override string _GetTemplateForLabelGamePasses()
	{
		return "Spielpässe";
	}

	protected override string _GetTemplateForLabelGear()
	{
		return "Ausrüstung";
	}

	protected override string _GetTemplateForLabelHair()
	{
		return "Haare";
	}

	protected override string _GetTemplateForLabelHairAccessory()
	{
		return "Haar-Accessoire";
	}

	protected override string _GetTemplateForLabelHat()
	{
		return "Hut";
	}

	protected override string _GetTemplateForLabelHats()
	{
		return "Hüte";
	}

	protected override string _GetTemplateForLabelHead()
	{
		return "Kopf";
	}

	protected override string _GetTemplateForLabelHeads()
	{
		return "Köpfe";
	}

	protected override string _GetTemplateForLabelIdle()
	{
		return "Untätig";
	}

	protected override string _GetTemplateForLabelImage()
	{
		return "Bild";
	}

	protected override string _GetTemplateForLabelJump()
	{
		return "Springen";
	}

	protected override string _GetTemplateForLabelLeftArm()
	{
		return "Linker Arm";
	}

	protected override string _GetTemplateForLabelLeftLeg()
	{
		return "Linkes Bein";
	}

	protected override string _GetTemplateForLabelMesh()
	{
		return "Mesh";
	}

	protected override string _GetTemplateForLabelMeshes()
	{
		return "Meshes";
	}

	protected override string _GetTemplateForLabelMeshPart()
	{
		return "Mesh-Teil";
	}

	protected override string _GetTemplateForLabelModel()
	{
		return "Modell";
	}

	protected override string _GetTemplateForLabelModels()
	{
		return "Modelle";
	}

	protected override string _GetTemplateForLabelNeck()
	{
		return "Hals";
	}

	protected override string _GetTemplateForLabelNeckAccessory()
	{
		return "Hals-Accessoire";
	}

	protected override string _GetTemplateForLabelPackage()
	{
		return "Paket";
	}

	protected override string _GetTemplateForLabelPackages()
	{
		return "Pakete";
	}

	protected override string _GetTemplateForLabelPants()
	{
		return "Hosen";
	}

	protected override string _GetTemplateForLabelPlace()
	{
		return "Ort";
	}

	protected override string _GetTemplateForLabelPlaces()
	{
		return "Orte";
	}

	protected override string _GetTemplateForLabelPlugin()
	{
		return "Plug-in";
	}

	protected override string _GetTemplateForLabelPlugins()
	{
		return "Plug-ins";
	}

	protected override string _GetTemplateForLabelPose()
	{
		return "Pose";
	}

	protected override string _GetTemplateForLabelRightArm()
	{
		return "Rechter Arm";
	}

	protected override string _GetTemplateForLabelRightLeg()
	{
		return "Rechtes Bein";
	}

	protected override string _GetTemplateForLabelRun()
	{
		return "Laufen";
	}

	protected override string _GetTemplateForLabelShirt()
	{
		return "Hemd";
	}

	protected override string _GetTemplateForLabelShirts()
	{
		return "Hemden";
	}

	protected override string _GetTemplateForLabelShoulder()
	{
		return "Schulter";
	}

	protected override string _GetTemplateForLabelShoulderAccessory()
	{
		return "Schulter-Accessoire";
	}

	protected override string _GetTemplateForLabelShoulders()
	{
		return "Schultern";
	}

	protected override string _GetTemplateForLabelSolidModel()
	{
		return "Solides Modell";
	}

	protected override string _GetTemplateForLabelSwim()
	{
		return "Schwimmen";
	}

	protected override string _GetTemplateForLabelTorso()
	{
		return "Torso";
	}

	protected override string _GetTemplateForLabelTShirt()
	{
		return "T-Shirt";
	}

	protected override string _GetTemplateForLabelTShirts()
	{
		return "T-Shirts";
	}

	protected override string _GetTemplateForLabelVipServers()
	{
		return "VIP-Server";
	}

	protected override string _GetTemplateForLabelWaist()
	{
		return "Taille";
	}

	protected override string _GetTemplateForLabelWaistAccessory()
	{
		return "Taille-Accessoire";
	}

	protected override string _GetTemplateForLabelWalk()
	{
		return "Gehen";
	}
}
