namespace Roblox.TrackingQueue;

/// <summary>
/// A Factory for <see cref="T:Roblox.TrackingQueue.ITrackingQueueMetrics" /> objects.
/// Effectively a wrapper for data stored within the given key.
/// </summary>
public interface ITrackingQueueMetricsFactory
{
	/// <summary>
	/// Used for pulling metrics generated by <see cref="T:Roblox.TrackingQueue.ITrackingQueuePublisher" />
	/// and <see cref="T:Roblox.TrackingQueue.ITrackingQueueConsumer" />. Note that the <paramref name="trackingKey" /> value
	/// must match the values used in those two objects.
	/// </summary>
	/// <param name="trackingKey">The specific key to track against.  Tracking data for different queues will be aggregated together if they use the same key.</param>
	/// <returns></returns>
	ITrackingQueueMetrics Create(string trackingKey);
}
