namespace Roblox.PremiumFeatures.Models.Enums;

/// <summary>
/// Represents a type of currency.
/// </summary>
public enum CurrencyType : byte
{
	/// <summary>
	/// US Dollar
	/// </summary>
	USD,
	/// <summary>
	/// Canadian Dollar
	/// </summary>
	CAD,
	/// <summary>
	/// Pound Sterling
	/// </summary>
	GBP,
	/// <summary>
	/// Euro
	/// </summary>
	EUR,
	/// <summary>
	/// Algerian dinar
	/// </summary>
	DZD,
	/// <summary>
	/// Australian dollar
	/// </summary>
	AUD,
	/// <summary>
	/// Bangladeshi taka
	/// </summary>
	BDT,
	/// <summary>
	/// Bolivian boliviano
	/// </summary>
	BOB,
	/// <summary>
	/// Brazilian real
	/// </summary>
	BRL,
	/// <summary>
	/// Bulgarian lev (old)
	/// </summary>
	BGN,
	/// <summary>
	/// Chilean Peso
	/// </summary>
	CLP,
	/// <summary>
	/// Chinese yuan renminbi
	/// </summary>
	CNY,
	/// <summary>
	/// Colombian peso
	/// </summary>
	COP,
	/// <summary>
	/// Costa Rican colon
	/// </summary>
	CRC,
	/// <summary>
	/// Croatian Kuna
	/// </summary>
	HRK,
	/// <summary>
	/// Czech koruna
	/// </summary>
	CZK,
	/// <summary>
	/// Danish krone
	/// </summary>
	DKK,
	/// <summary>
	/// Egyptian pound
	/// </summary>
	EGP,
	/// <summary>
	/// Ghanaian cedi
	/// </summary>
	GHS,
	/// <summary>
	/// Hong Kong Dollar
	/// </summary>
	HKD,
	/// <summary>
	/// Hungarian Forint
	/// </summary>
	HUF,
	/// <summary>
	/// Indian Rupee
	/// </summary>
	INR,
	/// <summary>
	/// Indonesian Rupiah
	/// </summary>
	IDR,
	/// <summary>
	/// Israeli New Shekel
	/// </summary>
	ILS,
	/// <summary>
	/// Japanese Yen
	/// </summary>
	JPY,
	/// <summary>
	/// Kazakhstani Tenge
	/// </summary>
	KZT,
	/// <summary>
	/// Kenyan Shilling
	/// </summary>
	KES,
	/// <summary>
	/// Lebanese Pound
	/// </summary>
	LBP,
	/// <summary>
	/// Macao pataca
	/// </summary>
	MOP,
	/// <summary>
	/// Malaysian Ringgit
	/// </summary>
	MYR,
	/// <summary>
	/// Mexican Peso
	/// </summary>
	MXN,
	/// <summary>
	/// Moroccan Dirham
	/// </summary>
	MAD,
	/// <summary>
	/// New Zealand Dollar
	/// </summary>
	NZD,
	/// <summary>
	/// Nigerian Naira
	/// </summary>
	NGN,
	/// <summary>
	/// Norwegian Krone
	/// </summary>
	NOK,
	/// <summary>
	/// Pakistani Rupee
	/// </summary>
	PKR,
	/// <summary>
	/// Peruvian Sol
	/// </summary>
	PEN,
	/// <summary>
	/// Philippine Peso
	/// </summary>
	PHP,
	/// <summary>
	/// Polish Zloty
	/// </summary>
	PLN,
	/// <summary>
	/// Qatari Riyal
	/// </summary>
	QAR,
	/// <summary>
	/// Romanian Leu
	/// </summary>
	RON,
	/// <summary>
	/// Russian Ruble
	/// </summary>
	RUB,
	/// <summary>
	/// Saudi Riyal
	/// </summary>
	SAR,
	/// <summary>
	/// Singapore Dollar
	/// </summary>
	SGD,
	/// <summary>
	/// South African Rand
	/// </summary>
	ZAR,
	/// <summary>
	/// South Korean Won
	/// </summary>
	KRW,
	/// <summary>
	/// Sri Lankan Rupee
	/// </summary>
	LKR,
	/// <summary>
	/// Swedish Krona
	/// </summary>
	SEK,
	/// <summary>
	/// Swiss franc
	/// </summary>
	CHF,
	/// <summary>
	/// New Taiwan dollar
	/// </summary>
	TWD,
	/// <summary>
	/// Tanzanian shilling
	/// </summary>
	TZS,
	/// <summary>
	/// Thai Baht
	/// </summary>
	THB,
	/// <summary>
	/// Turkish lira
	/// </summary>
	TRY,
	/// <summary>
	/// Ukrainian Hryvnia
	/// </summary>
	UAH,
	/// <summary>
	/// United Arab Emirates dirham
	/// </summary>
	AED,
	/// <summary>
	/// Vietnamese Dong
	/// </summary>
	VND
}
