using System;

namespace Roblox.Platform.Notifications.Core;

/// <summary>
/// The core concept of the the notification system - a notification generated by the <see cref="P:Roblox.Platform.Notifications.Core.INotification.Generator" /> to N recipients.
/// </summary>
public interface INotification
{
	/// <summary>
	/// The <see cref="T:Roblox.Platform.Notifications.Core.NotificationGenerator" /> causing this notification to be sent.
	/// </summary>
	NotificationGenerator Generator { get; }

	/// <summary>
	/// The notification's <see cref="T:Roblox.Platform.Notifications.Core.NotificationSourceType" />
	/// </summary>
	NotificationSourceType SourceType { get; }

	/// <summary>
	/// The notification's event target. Used by the consumer subsystem to identify the content of this notification.
	/// </summary>
	EventTarget EventTargetId { get; }

	/// <summary>
	/// The date this notification was sent.
	/// </summary>
	DateTime EventDate { get; }

	/// <summary>
	/// Gets a per-notification key. Can be used to revoke the notification.
	/// </summary>
	/// <returns>The key for this notification.</returns>
	string GetMessageSpecificNotificationKey();
}
