using System;

namespace Roblox.Platform.Core;

/// <summary>
/// Exception thrown when a validation operation fails.
/// </summary>
public class ValidationException : PlatformException
{
	/// <summary>
	/// Initializes a new instance of the <see cref="T:Roblox.Platform.Core.ValidationException" /> class.
	/// </summary>
	public ValidationException()
	{
	}

	/// <summary>
	/// Initializes a new instance of the <see cref="T:Roblox.Platform.Core.ValidationException" /> class with a specified error message.
	/// </summary>
	/// <param name="message">The message that describes the error.</param>
	public ValidationException(string message)
		: base(message)
	{
	}

	/// <summary>
	/// Initializes a new instance of the <see cref="T:Roblox.Platform.Core.ValidationException" /> class with a 
	/// specified error message and a reference to the inner exception that is the cause 
	/// of this exception.
	/// </summary>
	/// <param name="message">The message that describes the error.</param>
	/// <param name="innerException">The exception that is the cause of the current exception, or a null reference if no inner exception is specified.</param>
	public ValidationException(string message, Exception innerException)
		: base(message, innerException)
	{
	}
}
