using System.Drawing.Imaging;
using Roblox.Platform.AssetMedia.Properties;
using Roblox.Platform.Core;
using Roblox.Thumbs;

namespace Roblox.Platform.AssetMedia;

/// <inheritdoc />
public class PlaceIconThumbnailGetter : IPlaceIconThumbnailGetter
{
	private readonly IAssetThumbnail _AssetThumbnail;

	/// <summary>
	/// Constructs an instance of <see cref="T:Roblox.Platform.AssetMedia.PlaceIconThumbnailGetter" />.
	/// </summary>
	/// <param name="assetThumbnail">An <see cref="T:Roblox.Thumbs.IAssetThumbnail" />.</param>
	/// <exception cref="T:Roblox.Platform.Core.PlatformArgumentNullException">
	/// - <paramref name="assetThumbnail" />
	/// </exception>
	public PlaceIconThumbnailGetter(IAssetThumbnail assetThumbnail)
	{
		_AssetThumbnail = assetThumbnail ?? throw new PlatformArgumentNullException("assetThumbnail");
	}

	/// <inheritdoc />
	public ThumbResult GetPlaceIconThumbResult(long placeId, long? imageId, int width, int height, ImageFormat format, bool returnAutoGenerated = false)
	{
		ImageParameters imageParameters = new ImageParameters(width, height, format);
		return GetPlaceIconThumbResult(placeId, imageId, imageParameters, returnAutoGenerated);
	}

	/// <inheritdoc />
	public ThumbResult GetPlaceIconThumbResult(long placeId, long? imageId, ImageParameters imageParameters, bool returnAutoGenerated = false)
	{
		if (imageParameters == null)
		{
			throw new PlatformArgumentNullException("imageParameters");
		}
		if (!imageId.HasValue && !returnAutoGenerated && Settings.Default.IsDefaultCameraGeneratedThumbnailRemovalEnabled)
		{
			return _AssetThumbnail.GetDefaultPlaceGameIcon(placeId, imageParameters);
		}
		return _AssetThumbnail.GetThumbnailUrl(Asset.Get(imageId ?? placeId), imageParameters, overrideModeration: false, ignoreAssetMediaItems: true, returnAutoGenerated);
	}
}
