using System;
using System.Drawing.Imaging;
using Roblox.AssetMedia.Entities;
using Roblox.Platform.Core;
using Roblox.Thumbs;

namespace Roblox.Platform.AssetMedia;

public class PlaceIcon : IPlaceIcon
{
	private readonly IPlaceIconThumbnailGetter _PlaceIconThumbnailGetter;

	public long Id { get; private set; }

	public long PlaceId { get; private set; }

	public long? ImageId { get; set; }

	public DateTime Created { get; private set; }

	public DateTime Updated { get; private set; }

	internal PlaceIcon(long placeId, IPlaceIconThumbnailGetter placeIconThumbnailGetter)
	{
		PlaceId = placeId;
		ImageId = null;
		_PlaceIconThumbnailGetter = placeIconThumbnailGetter ?? throw new PlatformArgumentNullException("placeIconThumbnailGetter");
	}

	internal PlaceIcon(Roblox.AssetMedia.Entities.PlaceIcon placeIconEntity, IPlaceIconThumbnailGetter placeIconThumbnailGetter)
	{
		Id = placeIconEntity.ID;
		PlaceId = placeIconEntity.PlaceID;
		ImageId = placeIconEntity.ImageID;
		Created = placeIconEntity.Created;
		Updated = placeIconEntity.Updated;
		_PlaceIconThumbnailGetter = placeIconThumbnailGetter ?? throw new PlatformArgumentNullException("placeIconThumbnailGetter");
	}

	[Obsolete("Use PlaceIconThumbnailGetter.GetPlaceIconThumbResult instead.")]
	public ThumbResult GetGameIconThumbResult(int width, int height, ImageFormat format, bool returnAutoGenerated = false)
	{
		return _PlaceIconThumbnailGetter.GetPlaceIconThumbResult(PlaceId, ImageId, width, height, format, returnAutoGenerated);
	}

	[Obsolete("Use PlaceIconThumbnailGetter.GetPlaceIconThumbResult instead.")]
	public ThumbResult GetGameIconThumbResult(ImageParameters imageParameters, bool returnAutoGenerated = false)
	{
		return _PlaceIconThumbnailGetter.GetPlaceIconThumbResult(PlaceId, ImageId, imageParameters, returnAutoGenerated);
	}
}
