using System.Drawing.Imaging;
using Roblox.Thumbs;

namespace Roblox.Platform.AssetMedia;

/// <summary>
/// A class to getter place icon thumbnail
/// </summary>
public interface IPlaceIconThumbnailGetter
{
	/// <summary>
	/// Gets the <see cref="T:Roblox.Thumbs.ThumbResult" /> for a place icon image in the specified format, and size.
	/// </summary>
	/// <param name="placeId">The place ID.</param>
	/// <param name="imageId">The image ID of a place icon.</param>
	/// <param name="width">The desired width.</param>
	/// <param name="height">The desired height.</param>
	/// <param name="format">The image format to use.</param>
	/// <param name="returnAutoGenerated">The image will be auto generated using the thumbnail service of the user's place, if true.</param>
	/// <returns>The <see cref="T:Roblox.Thumbs.ThumbResult" /> for the place icon image.</returns>
	ThumbResult GetPlaceIconThumbResult(long placeId, long? imageId, int width, int height, ImageFormat format, bool returnAutoGenerated = false);

	/// <summary>
	/// Gets the <see cref="T:Roblox.Thumbs.ThumbResult" /> for a place icon image with the given <see cref="T:Roblox.Thumbs.ImageParameters" />.
	/// </summary>
	/// <param name="placeId">The place ID.</param>
	/// <param name="imageId">The image ID of a place icon.</param>
	/// <param name="imageParameters">The <see cref="T:Roblox.Thumbs.ImageParameters" /> of the image to get.</param>
	/// <param name="returnAutoGenerated">The image will be auto generated using the thumbnail service of the user's place, if true.</param>
	/// <returns>The <see cref="T:Roblox.Thumbs.ThumbResult" /> for the place icon image.</returns>
	/// <exception cref="T:Roblox.Platform.Core.PlatformArgumentNullException">Thrown if <paramref name="imageParameters" /> is null.</exception>
	ThumbResult GetPlaceIconThumbResult(long placeId, long? imageId, ImageParameters imageParameters, bool returnAutoGenerated = false);
}
