using System;
using System.Collections.Generic;
using Roblox.Caching;
using Roblox.Caching.Interfaces;
using Roblox.Common;
using Roblox.Data.Interfaces;
using Roblox.Platform.AbTesting.Core.Properties;

namespace Roblox.Platform.AbTesting.Core.Entities;

/// <summary>
/// This class contains methods not generated by the dbwireuptool. If someone wants to regenerate the entity files, we want these to not be overwritten.
/// </summary>
internal class EnrollmentDeclination : IRobloxEntity<long, EnrollmentDeclinationDAL>, ICacheableObject<long>, ICacheableObject, IRemoteCacheableObject
{
	private EnrollmentDeclinationDAL _EntityDAL;

	public static CacheInfo EntityCacheInfo = new CacheInfo(new CacheabilitySettings(collectionsAreCacheable: false, countsAreCacheable: false, entityIsCacheable: true, idLookupsAreCacheable: true, hasUnqualifiedCollections: false), typeof(EnrollmentDeclination).ToString(), isNullCacheable: true);

	public long ID => _EntityDAL.ID;

	internal int SubjectTypeID
	{
		get
		{
			return _EntityDAL.SubjectTypeID;
		}
		set
		{
			_EntityDAL.SubjectTypeID = value;
		}
	}

	internal long SubjectTargetID
	{
		get
		{
			return _EntityDAL.SubjectTargetID;
		}
		set
		{
			_EntityDAL.SubjectTargetID = value;
		}
	}

	internal int VersionID
	{
		get
		{
			return _EntityDAL.VersionID;
		}
		set
		{
			_EntityDAL.VersionID = value;
		}
	}

	internal int DeclinationReasonTypeID
	{
		get
		{
			return _EntityDAL.DeclinationReasonTypeID;
		}
		set
		{
			_EntityDAL.DeclinationReasonTypeID = value;
		}
	}

	internal DateTime Created
	{
		get
		{
			return _EntityDAL.Created;
		}
		set
		{
			_EntityDAL.Created = value;
		}
	}

	public CacheInfo CacheInfo => EntityCacheInfo;

	/// <summary>
	///
	/// </summary>
	/// <param name="subjectTypeID"></param>
	/// <param name="subjectTargetID"></param>
	/// <param name="versionID"></param>
	/// <param name="declinationReasonTypeID">Value to be used IF the entity must be created. If the entity already exists, this is ignored.</param>
	/// <returns></returns>
	public static EnrollmentDeclination GetOrCreate(int subjectTypeID, long subjectTargetID, int versionID, int declinationReasonTypeID)
	{
		if (Settings.Default.IsEnrollmentDeclinationRemoteCacheEnabled)
		{
			return EntityHelper.GetOrCreateEntityWithRemoteCache<long, EnrollmentDeclination>(EntityCacheInfo, GetLookupCacheKeysBySubjectTypeIDSubjectTargetIDVersionID(subjectTypeID, subjectTargetID, versionID), () => DoGetOrCreate(subjectTypeID, subjectTargetID, versionID, declinationReasonTypeID), Get);
		}
		return EntityHelper.GetOrCreateEntity<long, EnrollmentDeclination>(EntityCacheInfo, GetLookupCacheKeysBySubjectTypeIDSubjectTargetIDVersionID(subjectTypeID, subjectTargetID, versionID), () => DoGetOrCreate(subjectTypeID, subjectTargetID, versionID, declinationReasonTypeID));
	}

	private static EnrollmentDeclination DoGetOrCreate(int subjectTypeID, long subjectTargetID, int versionID, int declinationReasonTypeID)
	{
		return EntityHelper.DoGetOrCreate<long, EnrollmentDeclinationDAL, EnrollmentDeclination>(() => EnrollmentDeclinationDAL.GetOrCreateEnrollmentDeclination(subjectTypeID, subjectTargetID, versionID, declinationReasonTypeID));
	}

	public EnrollmentDeclination()
	{
		_EntityDAL = new EnrollmentDeclinationDAL();
	}

	public EnrollmentDeclination(EnrollmentDeclinationDAL enrollmentDeclinationDAL)
	{
		_EntityDAL = enrollmentDeclinationDAL;
	}

	public object GetSerializable()
	{
		return _EntityDAL;
	}

	internal void Delete()
	{
		if (Settings.Default.IsEnrollmentDeclinationRemoteCacheEnabled)
		{
			EntityHelper.DeleteEntityWithRemoteCache(this, _EntityDAL.Delete);
		}
		else
		{
			EntityHelper.DeleteEntity(this, _EntityDAL.Delete);
		}
	}

	internal void Save()
	{
		if (Settings.Default.IsEnrollmentDeclinationRemoteCacheEnabled)
		{
			EntityHelper.SaveEntityWithRemoteCache(this, delegate
			{
				_EntityDAL.Created = DateTime.Now;
				_EntityDAL.Insert();
			}, delegate
			{
				_EntityDAL.Update();
			});
		}
		else
		{
			EntityHelper.SaveEntity(this, delegate
			{
				_EntityDAL.Created = DateTime.Now;
				_EntityDAL.Insert();
			}, delegate
			{
				_EntityDAL.Update();
			});
		}
	}

	internal static EnrollmentDeclination Get(long id)
	{
		return EntityHelper.GetEntity<long, EnrollmentDeclinationDAL, EnrollmentDeclination>(EntityCacheInfo, id, () => EnrollmentDeclinationDAL.Get(id));
	}

	internal static ICollection<EnrollmentDeclination> MultiGet(ICollection<long> ids)
	{
		return EntityHelper.MultiGetEntity<long, EnrollmentDeclinationDAL, EnrollmentDeclination>(ids, EntityCacheInfo, EnrollmentDeclinationDAL.MultiGet);
	}

	public static EnrollmentDeclination GetBySubjectTypeIDSubjectTargetIDAndVersionID(int subjectTypeID, long subjectTargetID, int versionID)
	{
		if (Settings.Default.IsEnrollmentDeclinationRemoteCacheEnabled)
		{
			return EntityHelper.GetEntityByLookupWithRemoteCache<long, EnrollmentDeclinationDAL, EnrollmentDeclination>(EntityCacheInfo, GetLookupCacheKeysBySubjectTypeIDSubjectTargetIDVersionID(subjectTypeID, subjectTargetID, versionID), () => EnrollmentDeclinationDAL.GetEnrollmentDeclinationBySubjectTypeIDSubjectTargetIDAndVersionID(subjectTypeID, subjectTargetID, versionID), Get);
		}
		return EntityHelper.GetEntityByLookup<long, EnrollmentDeclinationDAL, EnrollmentDeclination>(EntityCacheInfo, GetLookupCacheKeysBySubjectTypeIDSubjectTargetIDVersionID(subjectTypeID, subjectTargetID, versionID), () => EnrollmentDeclinationDAL.GetEnrollmentDeclinationBySubjectTypeIDSubjectTargetIDAndVersionID(subjectTypeID, subjectTargetID, versionID));
	}

	public void Construct(EnrollmentDeclinationDAL dal)
	{
		_EntityDAL = dal;
	}

	public IEnumerable<string> BuildEntityIDLookups()
	{
		yield return GetLookupCacheKeysBySubjectTypeIDSubjectTargetIDVersionID(SubjectTypeID, SubjectTargetID, VersionID);
	}

	private static string GetLookupCacheKeysBySubjectTypeIDSubjectTargetIDVersionID(int subjectTypeID, long subjectTargetID, int versionID)
	{
		return $"SubjectTypeID:{subjectTypeID}_SubjectTargetID:{subjectTargetID}_VersionID:{versionID}";
	}

	public IEnumerable<StateToken> BuildStateTokenCollection()
	{
		yield break;
	}
}
