struct Appdata
{
    float4 Position	    : POSITION;
    float2 Uv	        : TEXCOORD0;
    float4 Color        : COLOR0;
};

struct VertexOutput
{
    float4 HPosition    : POSITION;

    float2 Uv           : TEXCOORD0;
    float4 Color        : COLOR0;

#if defined(PIN_FOG) && defined(GLSL)
    float FogFactor     : TEXCOORD1;
#endif
};

uniform float4x4 World;
uniform float4x4 WorldViewProjection;

uniform float3 FogColor;
uniform float4 FogParams;

VertexOutput UIVS(Appdata IN)
{
    VertexOutput OUT = (VertexOutput)0;

    OUT.HPosition = mul(WorldViewProjection, IN.Position);

    OUT.Uv = IN.Uv;
    OUT.Color = IN.Color;

#if defined(PIN_FOG) && defined(GLSL)
    OUT.FogFactor = (FogParams.z - OUT.HPosition.w) * FogParams.w;
#endif

    return OUT;
}

sampler2D DiffuseMap: register(s0);

float4 UIPS(VertexOutput IN): COLOR0
{
    float4 base = tex2D(DiffuseMap, IN.Uv);
    float4 result = IN.Color * base;

#if defined(PIN_FOG) && defined(GLSL)
    // Manually apply fog in GLSL path
    result.rgb = lerp(FogColor, result.rgb, saturate(IN.FogFactor));
#endif

    return result;
}
