-- Decal v1.0.2
-- Used for faces and decals

local assetUrl = "rbxassetid://%assetid%"
local baseUrl = "%url%"
local fileExtension = "PNG"
local x, y = 352, 352
game.DescendantAdded:connect(function(obj)
	-- ASSET FIXER MADE BY MEDITEXT
	-- BaseParts renderers
	if obj:IsA("SpecialMesh") and obj.MeshType == Enum.MeshType.FileMesh then
		if not string.find(obj.MeshId, "roblox.com") and string.find(obj.MeshId, "blox14.lol") then
			return -- ignore
		end
		local a = string.gsub(obj.MeshId, "roblox.com", "aftwld.xyz")
		local b = string.gsub(a, "blox14.lol", "aftwld.xyz")
		obj.MeshId = b
		if not string.find(obj.TextureId, "roblox.com") and not string.find(obj.TextureId, "blox14.lol") then
			return -- ignore
		end
		local c = string.gsub(obj.TextureId, "roblox.com", "aftwld.xyz")
		local d = string.gsub(c, "blox14.lol", "aftwld.xyz")
		obj.TextureId = d
	elseif obj:IsA("Decal") or obj:IsA("Texture") then
		if not string.find(obj.Texture, "roblox.com") and not string.find(obj.Texture, "blox14.lol") then
			return -- ignore
		end
		local a = string.gsub(obj.Texture, "roblox.com", "aftwld.xyz")
		local b = string.gsub(a, "blox14.lol", "aftwld.xyz")
		obj.Texture = b
	-- player exclusive
	elseif obj:IsA("Tool") or obj:IsA("HopperBin") then
		if not string.find(obj.TextureId, "roblox.com") and not string.find(obj.TextureId, "blox14.lol") then
			return -- ignore
		end
		local c = string.gsub(obj.TextureId, "roblox.com", "aftwld.xyz")
		local d = string.gsub(c, "blox14.lol", "aftwld.xyz")
		obj.TextureId = d
	elseif obj:IsA("Shirt") then
		if not string.find(obj.ShirtTemplate, "roblox.com") and not string.find(obj.ShirtTemplate, "blox14.lol") then
			return -- ignore
		end
		local a = string.gsub(obj.ShirtTemplate, "roblox.com", "aftwld.xyz")
		local b = string.gsub(a, "blox14.lol", "aftwld.xyz")
		obj.ShirtTemplate = b
	elseif obj:IsA("ShirtGraphic") then
		if not string.find(obj.Graphic, "roblox.com") and not string.find(obj.Graphic, "blox14.lol") then
			return -- ignore
		end
		local a = string.gsub(obj.Graphic, "roblox.com", "aftwld.xyz")
		local b = string.gsub(a, "blox14.lol", "aftwld.xyz")
		obj.Graphic = a
	elseif obj:IsA("Pants") then
		if not string.find(obj.PantsTemplate, "roblox.com") and not string.find(obj.PantsTemplate, "blox14.lol") then
			return -- ignore
		end
		local a = string.gsub(obj.PantsTemplate, "roblox.com", "aftwld.xyz")
		local b = string.gsub(a, "blox14.lol", "aftwld.xyz")
		obj.PantsTemplate = b
	-- Player UI
	elseif obj:IsA("ImageButton") or obj:IsA("ImageLabel") then
		if not string.find(obj.Image, "roblox.com") and not string.find(obj.Image, "blox14.lol") then
			return -- ignore
		end
		local a = string.gsub(obj.Image, "roblox.com", "aftwld.xyz")
		local b = string.gsub(a, "blox14.lol", "aftwld.xyz")
		obj.Image = b
	-- Legacy/Local scripts
	elseif obj:IsA("Script") or obj:IsA("LocalScript") or obj:IsA("ModuleScript") then
		if not string.find(obj.Source, "roblox.com") and not string.find(obj.Source, "blox14.lol") then
			return -- ignore
		end
		local a = obj.Source
		a = a:gsub("roblox.com","aftwld.xyz"):gsub("blox14.lol","aftwld.xyz")
		obj.Source = a
	-- Sounds and misc
	elseif obj:IsA("Sound") then
		if not string.find(obj.SoundId, "roblox.com") and not string.find(obj.SoundId, "blox14.lol") then
			return -- ignore
		end
		local a = string.gsub(obj.SoundId, "roblox.com", "aftwld.xyz")
		local b = string.gsub(a, "blox14.lol", "aftwld.xyz")
		obj.SoundId = b
	end
end)
local ThumbnailGenerator = game:GetService("ThumbnailGenerator")

pcall(function() game:GetService("ContentProvider"):SetBaseUrl(baseUrl) end)
game:GetService('ScriptContext').ScriptsDisabled = true

local decal = game:GetObjects(assetUrl)[1]

local image, requestedUrls
local success = pcall(function()
	image, requestedUrls = ThumbnailGenerator:ClickTexture(string.gsub(decal.Texture, "roblox.com", "aftwld.xyz"), fileExtension, x, y)
end)

if success then
	return image, requestedUrls
end

-- if we fail return the hourglass, since we're probably in moderation.
return "/9j/4AAQSkZJRgABAQEASABIAAD//gATQ3JlYXRlZCB3aXRoIEdJTVD/2wBDAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQH/2wBDAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQH/wgARCAABAAEDAREAAhEBAxEB/8QAFAABAAAAAAAAAAAAAAAAAAAACf/EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAX8P/8QAFBABAAAAAAAAAAAAAAAAAAAAAP/aAAgBAQABBQJ//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPwF//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPwF//8QAFBABAAAAAAAAAAAAAAAAAAAAAP/aAAgBAQAGPwJ//8QAFBABAAAAAAAAAAAAAAAAAAAAAP/aAAgBAQABPyF//9oADAMBAAIAAwAAABAf/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPxB//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPxB//8QAFBABAAAAAAAAAAAAAAAAAAAAAP/aAAgBAQABPxB//9k=", {decal.Texture}